<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
class Concopius
{
    private $dbUsername;
    private $dbPassword;
    private $dbLocalhost;
    private $dbName;
    private $prefix = 9900;
    private $charset = 'utf8';
    private $connectionUrl;
    private $companyID;
    private $companyTIC;
    private $companyVAT;
    private $vatArray;
    private $db;


    public function __construct($dbLocalhost, $dbUsername, $dbPassword,$dbName)
    {
        $this->dbUsername = $dbUsername;
        $this->dbPassword = $dbPassword;
        $this->dbLocalhost = $dbLocalhost;
        $this->dbName = $dbName;

    }

    public function setCompanyInfo($companyID){
        $companyInfo = (object)$this->query("SELECT * FROM Companies WHERE company_id='$companyID' LIMIT 1")[0];
        $this->companyID = $companyID;
        $this->companyTIC = $companyInfo->tic_code;
        $this->companyVAT = $companyInfo->vat_code;
    }

    public function dbConnectionStart(){
        $this->db = new mysqli($this->dbLocalhost,$this->dbUsername,$this->dbPassword,$this->dbName);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $this->db->set_charset("utf8");
        $this->db->begin_transaction();
    }

    public function dbConnectionEnd(){
        $this->db->commit(true);
    }

    private function query($query){
        $stmt = $this->db->prepare("$query");
        $stmt-> execute();
        $result = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
        $stmt->close();
        return $result;
    }

    public function invoiceObjectByID($invoiceID,$removeReturnAmount = false){

        $object      = (object)$this->query("SELECT * FROM Invoices INNER JOIN Customers ON (Invoices.customer_id=Customers.customer_id) WHERE Invoices.invoice_id='$invoiceID' LIMIT 1")[0];
        $lines       = $this->query("SELECT * FROM Invoice_Item INNER JOIN Items ON (Invoice_Item.item_id=Items.item_id) LEFT JOIN Vats ON (Vats.vat_id=Invoice_Item.vat_id) WHERE Invoice_Item.invoice_id='$invoiceID'");

        if($removeReturnAmount){
            $totalSubtractAmount = 0;
            $returns = $this->query("SELECT * FROM Returns,Invoice_Return WHERE Returns.return_id=Invoice_Return.return_id AND Invoice_Return.invoice_id='$invoiceID' ");
            foreach ($returns as $return) {
                $returnObject = (object)$return;
                $totalSubtractAmount += $returnObject->grand_total;
            }
            $object->grand_total -= $totalSubtractAmount;
        }

        $lineObjects = array();

        foreach ($lines as $line){
            array_push($lineObjects,(object)$line);
        }

        $object->lines = $lineObjects;

        return $object;
    }

    public function invoicePDFByID($invoiceID,$root){
        $object      = (object)$this->query("SELECT * FROM Invoices INNER JOIN Customers ON (Invoices.customer_id=Customers.customer_id) WHERE Invoices.invoice_id='$invoiceID' LIMIT 1")[0];
        $invoiceCode = $object->invoice_code;
        if(file_exists($root."media/pdfs/invoices/Invoice$invoiceCode.pdf")){
            return $root."media/pdfs/invoices/Invoice$invoiceCode.pdf";
        } else {
            return  '';
        }
    }

    public function returnPDFByID($returnID,$root){
        $object      = (object)$this->query("SELECT * FROM Returns INNER JOIN Customers ON (Returns.customer_id=Customers.customer_id) WHERE Returns.return_id='$returnID' LIMIT 1")[0];
        $invoiceCode = $object->invoice_code;
        if(file_exists($root."media/pdfs/returns/Return$invoiceCode.pdf")){
            return $root."media/pdfs/returns/Return$invoiceCode.pdf";
        } else {
            return  '';
        }
    }

    public function returnObjectByID($returnID){

        $object      = (object)$this->query("SELECT * FROM Returns INNER JOIN Customers ON (Returns.customer_id=Customers.customer_id) WHERE Returns.return_id='$returnID' LIMIT 1")[0];
        $lines       = $this->query("SELECT * FROM Return_Item INNER JOIN Items ON (Return_Item.item_id=Items.item_id) LEFT JOIN Vats ON (Vats.vat_id=Return_Item.vat_id) WHERE Return_Item.return_id='$returnID'");
        if(isset($object->return_id) && $object->return_id > 0) {
            $jiniusInvoice = (object)$this->query("SELECT Documents_Jinius.export_id FROM Invoice_Return, Documents_Jinius WHERE Documents_Jinius.id=Invoice_Return.invoice_id AND Documents_Jinius.type=5 AND Invoice_Return.return_id='$object->return_id' LIMIT 1")[0];
            if(isset($jiniusInvoice->export_id) && strcmp($jiniusInvoice->export_id,'')!=0) {
                $object->jinius_invoice_id = $jiniusInvoice->export_id;
            }
        }

        $lineObjects = array();

        foreach ($lines as $line){
            array_push($lineObjects,(object)$line);
        }

        $object->lines = $lineObjects;

        return $object;
    }

    public function receiptObjectByID($receiptID){

        $object = (object)$this->query("SELECT * FROM Receipts  WHERE Receipts.receipt_id='$receiptID' LIMIT 1")[0];

        return $object;
    }

    public function jiniusInvoiceByCopObject($invoiceObject)
    {

        $globalDiscount = 0;

        if(strcmp($invoiceObject->due_date,'0000-00-00')==0){$invoiceObject->due_date = $invoiceObject->invoice_date;}

        $result = new stdClass();
        $result->kind = 'Invoice';
        $result->documentNumber = $invoiceObject->invoice_code;
        $result->issueDate = $invoiceObject->invoice_date;
        $result->modificationDate = $invoiceObject->invoice_date;
        $result->dueDate = $invoiceObject->due_date;
        $result->description = $invoiceObject->details;
        $result->issuerVatNumber = $this->companyVAT;
        $result->issuerTaxIdNumber = $this->companyTIC;
        $result->recipientVatNumber = $invoiceObject->vat_code;
        $result->recipientTaxIdNumber = $invoiceObject->tic_code;

        $result->lineItems = array();


        foreach ($invoiceObject->lines as $invoiceItem){
            $invoiceItemObject = (object)$invoiceItem;
            if($invoiceItemObject->unit_price == 0){continue;}

//            $globalDiscount -= $invoiceItemObject->global_discount;
            $lineDiscount = round($invoiceItemObject->line_discount + $invoiceItemObject->global_discount,12);
            $lineDiscountPercentageCalculation = round($lineDiscount / ($invoiceItemObject->unit_price * $invoiceItemObject->qty) * 100,4);
            $invoiceItemObject->qty /= $invoiceItemObject->subunits;

            $resultLine = new stdClass();
            $resultLine->code = preg_replace("/[^A-Za-z0-9-]/", '',$invoiceItemObject->item_code);
            $resultLine->description = $invoiceItemObject->name;
            $resultLine->quantity = $invoiceItemObject->qty;
            if($invoiceItemObject->subunits > 1){
                $resultLine->unit = 'Boxes';
            } else {
                $resultLine->unit = 'Pieces';
            }
            $resultLine->price = $invoiceItemObject->unit_price;
            $resultLine->discountPercentage = $lineDiscountPercentageCalculation;
            $resultLine->taxPercentage = $this->jiniusVatIDs((int)$invoiceItemObject->percentage);
            $resultLine->discount = $lineDiscount;
            $resultLine->lineTotal = round(($invoiceItemObject->unit_price * $invoiceItemObject->qty) - $lineDiscount + $invoiceItemObject->vat_amount,2);
            $resultLine->taxAmount = round($invoiceItemObject->vat_amount,2);
            array_push($result->lineItems,$resultLine );
        }

//        if($globalDiscount < 0){
//            $resultLine = new stdClass();
//            $resultLine->code = 'DISC';
//            $resultLine->description = 'Discount';
//            $resultLine->quantity = '1';
//            $resultLine->unit = 'Pieces';
//            $resultLine->price = $globalDiscount;
//            $resultLine->discountPercentage = 0;
//            $resultLine->taxPercentage = 4;
//            $resultLine->discount = 0;
//            $resultLine->lineTotal = $globalDiscount;
//            $resultLine->taxAmount = $globalDiscount*0.19;
//            array_push($result->lineItems,$resultLine );
//        }

        $result->net = $invoiceObject->subtotal - $invoiceObject->discount_amount;
        $result->vatAmount = $invoiceObject->vat_amount;
        $result->totalAmount = $invoiceObject->grand_total;
        $result->discount = $invoiceObject->discount_amount;
        $result->initial = $invoiceObject->subtotal;

        return $result;

    }

    public function jiniusInvoicePaymentByCopObjects($invoiceObject,$receiptObject,$manualPaymentMethod = '')
    {

        $globalDiscount = 0;

        if(strcmp($invoiceObject->due_date,'0000-00-00')==0){$invoiceObject->due_date = $invoiceObject->invoice_date;}

        $result = new stdClass();
        $result->kind = 'Invoice';
        $result->documentNumber = $invoiceObject->invoice_code;
        $result->issueDate = $invoiceObject->invoice_date;
        $result->modificationDate = $invoiceObject->invoice_date;
        $result->dueDate = $invoiceObject->due_date;
        $result->description = $invoiceObject->details;
        $result->issuerVatNumber = $this->companyVAT;
        $result->issuerTaxIdNumber = $this->companyTIC;
        $result->recipientVatNumber = $invoiceObject->vat_code;
        $result->recipientTaxIdNumber = $invoiceObject->tic_code;
        $result->lineItems = array();


        foreach ($invoiceObject->lines as $invoiceItem){
            $invoiceItemObject = (object)$invoiceItem;
            if($invoiceItemObject->unit_price == 0){continue;}

            $lineDiscount = round($invoiceItemObject->line_discount + $invoiceItemObject->global_discount,12);
            $lineDiscountPercentageCalculation = round($lineDiscount / ($invoiceItemObject->unit_price * $invoiceItemObject->qty) * 100,4);
            $invoiceItemObject->qty /= $invoiceItemObject->subunits;

            $resultLine = new stdClass();
            $resultLine->code = preg_replace("/[^A-Za-z0-9-]/", '',$invoiceItemObject->item_code);
            $resultLine->description = $invoiceItemObject->name;
            $resultLine->quantity = $invoiceItemObject->qty;
            if($invoiceItemObject->subunits > 1){
                $resultLine->unit = 'Boxes';
            } else {
                $resultLine->unit = 'Pieces';
            }
            $resultLine->price = $invoiceItemObject->unit_price;
            $resultLine->discountPercentage = $lineDiscountPercentageCalculation;
            $resultLine->taxPercentage = $this->jiniusVatIDs((int)$invoiceItemObject->percentage);
            $resultLine->discount = $lineDiscount;
            $resultLine->lineTotal = round(($invoiceItemObject->unit_price * $invoiceItemObject->qty) - $lineDiscount + $invoiceItemObject->vat_amount,2);
            $resultLine->taxAmount = round($invoiceItemObject->vat_amount,2);
            array_push($result->lineItems,$resultLine );
        }

        $result->net = $invoiceObject->subtotal - $invoiceObject->discount_amount;
        $result->vatAmount = $invoiceObject->vat_amount;
        $result->totalAmount = $invoiceObject->grand_total;
        $result->discount = $invoiceObject->discount_amount;
        $result->initial = $invoiceObject->subtotal;

        $result->PaymentNumber = $receiptObject->receipt_code;
        $result->referenceNumber = $receiptObject->receipt_code;
        $result->PaymentAmount = (float)$receiptObject->amount + (float)$receiptObject->cash_discount;
        $result->invoicePaymentDate = $receiptObject->receipt_date.'T'.date('H:i:s.u').'Z';
        $result->comments = $receiptObject->details;

        if(strcmp(trim($manualPaymentMethod),'')==0){
            $result->paymentMethod = $receiptObject->payment_method;
        } else {
            $result->paymentMethod = $manualPaymentMethod;
        }


        return $result;

    }

    public function jiniusReturnByCopObject($returnObject)
    {

        $globalDiscount = 0;


        $result = new stdClass();
        if(isset($returnObject->jinius_invoice_id) && strcmp($returnObject->jinius_invoice_id,'')!=0){
            $result->jiniusInvoiceID=$returnObject->jinius_invoice_id;
        }
        $result->kind = 'creditNote';
        $result->documentNumber = $returnObject->return_code;
        $result->issueDate = $returnObject->return_date;
        $result->modificationDate = $returnObject->return_date;
        $result->dueDate = $returnObject->return_date;
        $result->description = $returnObject->details;
        $result->issuerVatNumber = $this->companyVAT;
        $result->issuerTaxIdNumber = $this->companyTIC;
        $result->recipientVatNumber = $returnObject->vat_code;
        $result->recipientTaxIdNumber = $returnObject->tic_code;

        $result->lineItems = array();


        foreach ($returnObject->lines as $returnItem){
            $returnItemObject = (object)$returnItem;
            if($returnItemObject->unit_price == 0){continue;}

//            $globalDiscount -= $returnItemObject->global_discount;
            $lineDiscount = round($returnItemObject->line_discount + $returnItemObject->global_discount,12);
            $lineDiscountPercentageCalculation = round($lineDiscount / ($returnItemObject->unit_price * $returnItemObject->qty) * 100,4);
            $returnItemObject->qty /= $returnItemObject->subunits;

            $resultLine = new stdClass();
            $resultLine->code = preg_replace("/[^A-Za-z0-9-]/", '',$returnItemObject->item_code);
            $resultLine->description = $returnItemObject->name;
            $resultLine->quantity = $returnItemObject->qty;
            if($returnItemObject->subunits > 1){
                $resultLine->unit = 'Boxes';
            } else {
                $resultLine->unit = 'Pieces';
            }
            $resultLine->price = $returnItemObject->unit_price - ($returnItemObject->line_discount/$returnItemObject->qty) - ($returnItemObject->global_discount/$returnItemObject->qty);
            $resultLine->discountPercentage = $lineDiscountPercentageCalculation;
            $resultLine->taxPercentage = $this->jiniusVatIDs((int)$returnItemObject->percentage);
            $resultLine->discount = $lineDiscount;
            $resultLine->lineTotal = round(($returnItemObject->unit_price * $returnItemObject->qty) - $lineDiscount + $returnItemObject->vat_amount,3);
            $resultLine->taxAmount = $returnItemObject->vat_amount;
            array_push($result->lineItems,$resultLine );
        }

//        if($globalDiscount < 0){
//            $resultLine = new stdClass();
//            $resultLine->code = 'DISC';
//            $resultLine->description = 'Discount';
//            $resultLine->quantity = '1';
//            $resultLine->unit = 'Pieces';
//            $resultLine->price = $globalDiscount;
//            $resultLine->discountPercentage = 0;
//            $resultLine->taxPercentage = 4;
//            $resultLine->discount = 0;
//            $resultLine->lineTotal = $globalDiscount;
//            $resultLine->taxAmount = $globalDiscount*0.19;
//            array_push($result->lineItems,$resultLine );
//        }

        $result->net = $returnObject->subtotal - $returnObject->discount_amount;
        $result->vatAmount = $returnObject->vat_amount;
        $result->totalAmount = $returnObject->grand_total;
        $result->discount = 0;
        $result->initial = $returnObject->subtotal - $returnObject->discount_amount;

        return $result;

    }

    public function insertUpdateJiniusDocumentsStatus($db, $id, $type,$status,$reason,$exportID,$exportCode){

        if(strcmp(trim($exportID),'')!=0){
            $stmt = $db->prepare("INSERT INTO Documents_Jinius (id, type, status, reason, export_id, export_code, timestamp) VALUES(?,?,?,?,?,?,NOW()) ON DUPLICATE KEY UPDATE status=?, reason=?, export_id=?,export_code=?, timestamp=NOW()");
            $stmt->bind_param('isssssssss', $id, $type,$status,$reason,$exportID,$exportCode,$status,$reason,$exportID,$exportCode);
            $stmt->execute();
            $error =$stmt->error;
            $stmt->close();
        }else {
            $stmt = $db->prepare("INSERT INTO Documents_Jinius (id, type, status, reason, export_id, export_code, timestamp) VALUES(?,?,?,?,?,?,NOW()) ON DUPLICATE KEY UPDATE status=?, reason=?, export_code=?, timestamp=NOW()");
            $stmt->bind_param('issssssss', $id, $type, $status, $reason, $exportID, $exportCode, $status, $reason, $exportCode);
            $stmt->execute();
            $error = $stmt->error;
            $stmt->close();
        }

        return $error;
    }

    public function markInvoiceAsPaid($db, $invoiceID, $paymentMethod = 'Cash', $status='Paid'){

        $invoice  = (object)$this->query("SELECT * FROM Invoices WHERE invoice_id='$invoiceID' LIMIT 1")[0];
        $returns  = (object)$this->query("SELECT SUM(grand_total) as total FROM Invoice_Return,Returns WHERE Invoice_Return.return_id=Returns.return_id AND Invoice_Return.invoice_id='$invoiceID'")[0];
        $receipts = (object)$this->query("SELECT SUM(Invoice_Receipt.amount) as total FROM Invoice_Receipt WHERE Invoice_Receipt.invoice_id='$invoiceID'")[0];

        $invoiceTotal = (float)$invoice->grand_total;
        $returnsTotal = (float)$returns->total;
        $receiptsTotal = (float)$receipts->total;

        $subtractionTotal = $returnsTotal + $receiptsTotal;

        if($invoiceTotal > $subtractionTotal){

            $receiptID = $this->getNextID("Receipts", "receipt_id", $db);
            $receiptCode = getNextCodeSingleTransaction("Receipts", "receipt_code", "R", "CLOUD", $db);
            $customerID = $invoice->customer_id;
            $companyID =$invoice->company_id;
            $salespersonID = 0;
            $orderID = 0;
            $receiptAddress = 0;
            $amount = $invoiceTotal - $subtractionTotal;
            $cashDiscount = 0;
            $bank = '';
            $branch = '';
            $chequeNumber = '';
            $chequeDate = '';
            $receiptDate = date('Y-m-d');
            $notes = "Created by Jinius for Invoice $invoice->invoice_code";

            $stmt = $db->prepare("INSERT INTO Receipts (receipt_id, receipt_code, customer_id, company_id, salesperson_id, order_id, invoice_id, address_id, amount, payment_method, cash_discount, bank, branch, cheque_number, cheque_date, receipt_date, notes) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('isiiiiiidsdssssss', $receiptID, $receiptCode, $customerID, $companyID, $salespersonID, $orderID, $invoiceID, $receiptAddress, $amount, $paymentMethod, $cashDiscount, $bank, $branch, $chequeNumber, $chequeDate, $receiptDate, $notes);
            $stmt->execute();
            $stmt->close();

            $sign = -1;
            $detailsTra = "Receipt $receiptCode";
            $transactionID = $this->getNextID("Transactions", "transaction_id", $db);

            $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('isisssids', $transactionID, $receiptCode, $customerID, $receiptDate, $receiptDate, $receiptCode, $sign, $amount, $detailsTra);
            $stmt->execute();
            $stmt->close();

            $stmt = $db->prepare("UPDATE Customers SET balance = balance + ? WHERE customer_id=?");
            $stmt->bind_param('di',$amount,$customerID);
            $stmt->execute();
            $stmt->close();
        }


        $stmt = $db->prepare("UPDATE Invoices SET status=? WHERE invoice_id=?");
        $stmt->bind_param('si', $status, $invoiceID);
        $stmt->execute();
        $error = $stmt->error;
        $stmt->close();

        return $error;
    }

    public function insertReceipt($db, $invoiceID,$json, $receiptJiniusID,$amount,$receiptDate,$notes,$jiniusStatus,$paymentMethod = 0){

        if($invoiceID > 0 &&  strcmp(trim($receiptJiniusID),'')!=0){

            $invoice  = (object)$this->query("SELECT * FROM Invoices WHERE invoice_id='$invoiceID' LIMIT 1")[0];

            $receiptID = $this->getNextID("Receipts", "receipt_id", $db);
            $receiptCode = $this->getNextDocumentCode("Receipts", "receipt_code", "R", "CLOUD", $db);
            $customerID = $invoice->customer_id;
            $companyID =$invoice->company_id;
            $salespersonID = 0;
            $orderID = 0;
            $receiptAddress = $invoice->invoice_address_id;
            $cashDiscount = 0;
            $bank = '';
            $branch = '';
            $chequeNumber = '';
            $chequeDate = '';
            $status = 'to be checked';

            $stmt = $db->prepare("INSERT INTO Receipts (receipt_id, receipt_code, customer_id, company_id, salesperson_id, order_id, invoice_id, address_id, amount, payment_method, cash_discount, bank, branch, cheque_number, cheque_date, receipt_date,status, notes) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('isiiiiiidsdsssssss', $receiptID, $receiptCode, $customerID, $companyID, $salespersonID, $orderID, $invoiceID, $receiptAddress, $amount, $paymentMethod, $cashDiscount, $bank, $branch, $chequeNumber, $chequeDate, $receiptDate,$status, $notes);
            $stmt->execute();
            $error = $stmt->error;
            $stmt->close();


            $this->insertUpdateJiniusDocumentsStatus($db, $receiptID, 6,"OK",$json,$receiptJiniusID,$jiniusStatus);
            $jsonDecoded = json_decode($json,true);
            $this->insertUpdateJiniusDocumentsStatus($db, $invoiceID, 5,"OK",$json,"".$jsonDecoded["id"],"".$jsonDecoded["status"]);

            return $receiptID;

        } else {
            return 0 ;
        }

    }

    public function insertApprovedReceipt($db, $invoiceID,$json, $receiptJiniusID,$amount,$receiptDate,$notes,$jiniusStatus,$paymentMethod = 0){

        if($invoiceID > 0 &&  strcmp(trim($receiptJiniusID),'')!=0){

            $invoice  = (object)$this->query("SELECT * FROM Invoices WHERE invoice_id='$invoiceID' LIMIT 1")[0];

            $receiptID = $this->getNextID("Receipts", "receipt_id", $db);
            $receiptCode = $this->getNextDocumentCode("Receipts", "receipt_code", "R", "CLOUD", $db);
            $customerID = $invoice->customer_id;
            $companyID =$invoice->company_id;
            $salespersonID = 0;
            $orderID = 0;
            $receiptAddress = $invoice->invoice_address_id;
            $cashDiscount = 0;
            $bank = '';
            $branch = '';
            $chequeNumber = '';
            $chequeDate = '';
            $status = 'to be checked';

            $stmt = $db->prepare("INSERT INTO Receipts (receipt_id, receipt_code, customer_id, company_id, salesperson_id, order_id, invoice_id, address_id, amount, payment_method, cash_discount, bank, branch, cheque_number, cheque_date, receipt_date,status, notes) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('isiiiiiidsdsssssss', $receiptID, $receiptCode, $customerID, $companyID, $salespersonID, $orderID, $invoiceID, $receiptAddress, $amount, $paymentMethod, $cashDiscount, $bank, $branch, $chequeNumber, $chequeDate, $receiptDate,$status, $notes);
            $stmt->execute();
            $stmt->close();


            $sign = -1;
            $detailsTra = "Receipt $receiptCode";
            $transactionID = $this->getNextID("Transactions", "transaction_id", $db);

            $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('isisssids', $transactionID, $receiptID, $customerID, $receiptDate, $receiptDate, $receiptDate, $sign, $amount, $detailsTra);
            $stmt->execute();
            $stmt->close();

            $stmt = $db->prepare("UPDATE Customers SET balance = balance + ? WHERE customer_id=?");
            $stmt->bind_param('di',$amount,$customerID);
            $stmt->execute();
            $stmt->close();

            $newStatus = 'Confirmed';
            $stmt = $db->prepare("UPDATE Receipts SET status = ? WHERE receipt_id=?");
            $stmt->bind_param('si',$newStatus,$receiptID);
            $stmt->execute();
            $stmt->close();

            $stmt = $db->prepare("INSERT INTO Invoice_Receipt (receipt_id, invoice_id, amount) VALUES (?,?,?)");
            $stmt->bind_param('iid', $receiptID,$invoiceID,$amount);
            $stmt->execute();
            $stmt->close();


            $this->insertUpdateJiniusDocumentsStatus($db, $receiptID, 6,"OK",$json,$receiptJiniusID,$jiniusStatus);
            $jsonDecoded = json_decode($json,true);
            $this->insertUpdateJiniusDocumentsStatus($db, $invoiceID, 5,"OK",$json,"".$jsonDecoded["id"],"".$jsonDecoded["status"]);

            return $receiptID;

        } else {
            return 0 ;
        }

    }

    public function linkReceiptToInvoice($db,$invoiceID,$receiptID,$amount){

        if($invoiceID > 0 && $receiptID > 0 ){



            $stmt = $db->prepare("INSERT IGNORE INTO Invoice_Receipt (receipt_id, invoice_id, amount, timestamp) VALUES(?,?,?,NOW())");
            $stmt->bind_param('iid', $receiptID,$invoiceID,$amount);
            $stmt->execute();
            $error = $stmt->error;
            $stmt->close();


            return $error;

        } else {
            return "Missing ID Invoice:$invoiceID Receipt:$receiptID";
        }

    }

    public function approveReceipt($db, $invoiceID,$receiptID,$receiptJiniusID,$json){
        $receipt  = (object)$this->query("SELECT * FROM Receipts WHERE receipt_id='$receiptID' LIMIT 1")[0];
        $sign = -1;
        $detailsTra = "Receipt $receipt->receipt_code";
        $transactionID = $this->getNextID("Transactions", "transaction_id", $db);

        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids', $transactionID, $receipt->receipt_code, $receipt->customer_id, $receipt->receipt_date, $receipt->receipt_date, $receipt->receipt_date, $sign, $receipt->amount, $detailsTra);
        $stmt->execute();
        $stmt->close();

        $stmt = $db->prepare("UPDATE Customers SET balance = balance + ? WHERE customer_id=?");
        $stmt->bind_param('di',$receipt->amount,$receipt->customer_id);
        $stmt->execute();
        $stmt->close();

        $newStatus = 'Confirmed';
        $stmt = $db->prepare("UPDATE Receipts SET status = ? WHERE receipt_id=?");
        $stmt->bind_param('si',$newStatus,$receiptID);
        $stmt->execute();
        $stmt->close();

        $stmt = $db->prepare("INSERT INTO Invoice_Receipt (receipt_id, invoice_id, amount) VALUES (?,?,?)");
        $stmt->bind_param('iid', $receiptID,$invoiceID,$receipt->amount);
        $stmt->execute();
        $stmt->close();

        $this->insertUpdateJiniusDocumentsStatus($db, $receiptID, 6,"OK",$json,$receiptJiniusID,'Approved');
        $jsonDecoded = json_decode($json,true);
        $this->insertUpdateJiniusDocumentsStatus($db, $invoiceID, 5,"OK",$json,"".$jsonDecoded["id"],"".$jsonDecoded["status"]);

    }

    public function rejectReceipt($db, $invoiceID,$receiptID,$receiptJiniusID,$json){

        $newStatus = 'Canceled';
        $stmt = $db->prepare("UPDATE Receipts SET status = ? WHERE receipt_id=?");
        $stmt->bind_param('si',$newStatus,$receiptID);
        $stmt->execute();
        $stmt->close();

        $stmt = $db->prepare("INSERT INTO Invoice_Receipt (receipt_id, invoice_id, amount) VALUES (?,?,0)");
        $stmt->bind_param('iid', $receiptID,$invoiceID);
        $stmt->execute();
        $stmt->close();

        $this->insertUpdateJiniusDocumentsStatus($db, $receiptID, 6,"OK",$json,$receiptJiniusID,'Declined');

    }

    public function curlPostRequest($json){
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://concopius.com/connector/request.php',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_HTTPHEADER, array('Content-Type: application/json'),
            CURLOPT_POSTFIELDS => array('json'=>$json),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        return $response;
    }

    public function curlAttachFileRequest($json,$pathToFile){
        if(strcmp($pathToFile,'')!=0 && file_exists($pathToFile)) {
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://concopius.com/connector/request.php',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_HTTPHEADER, array('Content-Type: multipart/form-data'),
                CURLOPT_POSTFIELDS => array('json' => $json, 'file' => new CURLFILE("$pathToFile")),
            ));

            $response = curl_exec($curl);

            curl_close($curl);
            return $response;
        } else {
            return '';
        }
    }

    private function jiniusVatIDs($percent)
    {
        switch($percent){
            case '0':
                $vatID = 0;
                break;
            case '5':
                $vatID = 2;
                break;
            case '9':
                $vatID = 3;
                break;
            case '19':
                $vatID = 4;
                break;
            default:
                $vatID = 4;
        }

        return $vatID;
    }

    private function vatVerbalPercent($number)
    {
        list($integer, $fraction) = explode(".", (string) $number);

        $output = "";

        if ($integer{0} == "-")
        {
            $output = "negative ";
            $integer    = ltrim($integer, "-");
        }
        else if ($integer{0} == "+")
        {
            $output = "positive ";
            $integer    = ltrim($integer, "+");
        }

        if ($integer{0} == "0")
        {
            $output .= "zero";
        }
        else
        {
            $integer = str_pad($integer, 36, "0", STR_PAD_LEFT);
            $group   = rtrim(chunk_split($integer, 3, " "), " ");
            $groups  = explode(" ", $group);

            $groups2 = array();
            foreach ($groups as $g)
            {
                $groups2[] = $this->convertThreeDigit($g{0}, $g{1}, $g{2});
            }

            for ($z = 0; $z < count($groups2); $z++)
            {
                if ($groups2[$z] != "")
                {
                    $output .= $groups2[$z] . $this->convertGroup(11 - $z) . (
                        $z < 11
                        && !array_search('', array_slice($groups2, $z + 1, -1))
                        && $groups2[11] != ''
                        && $groups[11]{0} == '0'
                            ? " and "
                            : ", "
                        );
                }
            }

            $output = rtrim($output, ", ");
        }

        if ($fraction > 0)
        {
            $output .= " point";
            for ($i = 0; $i < strlen($fraction); $i++)
            {
                $output .= " " . $this->convertDigit($fraction{$i});
            }
        }

        return ucfirst(trim($output)).'Percent';
    }

    private function convertGroup($index)
{
    switch ($index)
    {
        case 11:
            return " decillion";
        case 10:
            return " nonillion";
        case 9:
            return " octillion";
        case 8:
            return " septillion";
        case 7:
            return " sextillion";
        case 6:
            return " quintrillion";
        case 5:
            return " quadrillion";
        case 4:
            return " trillion";
        case 3:
            return " billion";
        case 2:
            return " million";
        case 1:
            return " thousand";
        case 0:
            return "";
    }
}

    private function convertThreeDigit($digit1, $digit2, $digit3)
{
    $buffer = "";

    if ($digit1 == "0" && $digit2 == "0" && $digit3 == "0")
    {
        return "";
    }

    if ($digit1 != "0")
    {
        $buffer .= $this->convertDigit($digit1) . " hundred";
        if ($digit2 != "0" || $digit3 != "0")
        {
            $buffer .= " ";
        }
    }

    if ($digit2 != "0")
    {
        $buffer .= $this->convertTwoDigit($digit2, $digit3);
    }
    else if ($digit3 != "0")
    {
        $buffer .= $this->convertDigit($digit3);
    }

    return $buffer;
}

    private function convertTwoDigit($digit1, $digit2)
{
    if ($digit2 == "0")
    {
        switch ($digit1)
        {
            case "1":
                return "ten";
            case "2":
                return "twenty";
            case "3":
                return "thirty";
            case "4":
                return "forty";
            case "5":
                return "fifty";
            case "6":
                return "sixty";
            case "7":
                return "seventy";
            case "8":
                return "eighty";
            case "9":
                return "ninety";
        }
    } else if ($digit1 == "1")
    {
        switch ($digit2)
        {
            case "1":
                return "eleven";
            case "2":
                return "twelve";
            case "3":
                return "thirteen";
            case "4":
                return "fourteen";
            case "5":
                return "fifteen";
            case "6":
                return "sixteen";
            case "7":
                return "seventeen";
            case "8":
                return "eighteen";
            case "9":
                return "nineteen";
        }
    } else
    {
        $temp = $this->convertDigit($digit2);
        switch ($digit1)
        {
            case "2":
                return "twenty $temp";
            case "3":
                return "thirty $temp";
            case "4":
                return "forty $temp";
            case "5":
                return "fifty $temp";
            case "6":
                return "sixty $temp";
            case "7":
                return "seventy $temp";
            case "8":
                return "eighty $temp";
            case "9":
                return "ninety $temp";
        }
    }
}

    private function convertDigit($digit)
{
    switch ($digit)
    {
        case "0":
            return "zero";
        case "1":
            return "one";
        case "2":
            return "two";
        case "3":
            return "three";
        case "4":
            return "four";
        case "5":
            return "five";
        case "6":
            return "six";
        case "7":
            return "seven";
        case "8":
            return "eight";
        case "9":
            return "nine";
    }
}

    private function getNextID($tableName,$idName,$db)
    {
        $z=0;
        $prefix=1000;

        $likeVar = $prefix."%";
        $stm1 = $db->prepare("SELECT $idName FROM $tableName WHERE $idName LIKE '$likeVar' ORDER BY $idName DESC LIMIT 1");
        $stm1-> execute();
        $stm1-> bind_result($nextID);
        while ($stm1->fetch()) {

            $z = substr($nextID,4,strlen($nextID));
            $z+=1;


        }
        $stm1->close();


        return $prefix.$z;

    }

    private function getNextDocumentCode($table,$field,$tablePrefix,$activationCode,$db)
    {
        $result   = 0;
        $prefix   = '';
        $nextCode = '';

        $stm1 = $db->prepare("SELECT display_prefix FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
        $stm1->execute();
        $stm1->bind_result($prefix);
        while ($stm1->fetch()) {}
        $stm1->close();

        if(strcmp($prefix,'')!=0) {
            $prefix = $tablePrefix.$prefix;
            $stm = $db->prepare("SELECT REPLACE($field, '$prefix', '')+1 AS counter FROM $table WHERE $field LIKE'$prefix%' AND REPLACE($field, '$prefix', '') REGEXP '^-?[0-9]+$' ORDER BY counter DESC LIMIT 1");
            $stm->execute();
            $stm->bind_result($nextCode);
            while ($stm->fetch()) {
                if(is_numeric($nextCode) && $nextCode > 0){
                    $result=$nextCode;
                }
            }
            $stm->close();
        }

        if($result > 0){
            while ($this->canceledActionExists($table,$prefix,$result)){
                $result++;
            }
            return $prefix.$result;
        } else {
            return '';
        }


    }

    private function canceledActionExists($table,$prefix,$code){
        $z=false;

        $actionType = rtrim($table,'s');
        $actionCode = $prefix.$code;

        global $username,$password,$database;
        $db9 = new mysqli('localhost',$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $stm1 = $db9->prepare("SELECT cancelled_id FROM Cancelled_Actions WHERE type = '$actionType' AND code = '$actionCode' LIMIT 1");
        $stm1-> execute();
        $stm1-> bind_result($key);
        while ($stm1->fetch()) {
            if(strcmp($key,'')!=0 && $key > 0){
                $z = true;
            }
        }
        $stm1->close();

        return $z;
    }


}