<?php
include_once("../../../../param.php");
require_once(ROOT . "backend/core/model/CustomerAddress.php");
require_once(ROOT . "concc/dbhelpers/classes/DBCustomer.php");
require_once(ROOT . "concc/dbhelpers/classes/DBItem.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");
require_once(ROOT . "concc/dbhelpers/dbhelper.php");


$edit = false;
$groupContractHeaderID = 0;
if (isset($_GET['group_contract_header_id']) && $_GET['group_contract_header_id']>0){
    $edit = true;
    $groupContractHeaderID = $_GET['group_contract_header_id'];
}
if (isset($_POST['group_contract_header_id']) && $_POST['group_contract_header_id']>0 && !$edit){
    $edit = true;
    $groupContractHeaderID = $_POST['group_contract_header_id'];
}

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$viewElement            = '';
$backgroundColorPage    = '';
$buttonPlaced           = "";
$buttonCancel           = "";
$statusCancel           = false;
if ($edit){
    $stm = $db->prepare("SELECT group_contract_header_code,customer_id,salesperson_id,technician_id,contract_type_id,item_id,serial_number_id,customer_address_id,title,valid_from,valid_until,status,details,details_2,notes,notes_2 FROM Group_Contract_Header WHERE group_contract_header_id='$groupContractHeaderID'");
    $stm->execute();
    $stm->bind_result($group_contract_header_code,$customer_id,$salesperson_id,$technician_id,$contract_type_id,$item_id,$serial_number_id,$customer_address_id,$title,$valid_from,$valid_until,$status,$details,$details_2,$notes,$notes_2);
    while ($stm->fetch()) {}
    $stm->close();
    $dbHelbelCustomer= new DBCustomer();
    $customer=$dbHelbelCustomer->getCustomerByID($customer_id);

    $stm2 = $db->prepare("SELECT salesperson_code,first_name,last_name FROM SalesPersons WHERE salesperson_id='$salesperson_id'");
    $stm2->execute();
    $stm2->bind_result($salespersonCode,$firstName,$lastName);
    while ($stm2->fetch()) {

    }
    $stm2->close();

    $stm2 = $db->prepare("SELECT salesperson_code,first_name,last_name FROM SalesPersons WHERE salesperson_id='$technician_id'");
    $stm2->execute();
    $stm2->bind_result($technicianCode,$technicianfirstName,$technicianlastName);
    while ($stm2->fetch()) {

    }
    $stm2->close();
    if(strcmp($status,'Winning')==0){
        $viewElement            = 'readonly';
        $backgroundColorPage  = '#e8fbe8';
        $buttonPlaced         = "disabled";
        $buttonCancel         = "";
        $statusCancel         = true;
    }else if(strcmp($status,'Canceled')==0){
        $viewElement            = 'readonly';
        $backgroundColorPage  = '#fbd9d3';
        $buttonPlaced         = "disabled";
        $buttonCancel         = "disabled";
        $statusCancel         = false;
    }else{
        $statusCancel         = true;
    }
}


$custTable = new CustomTable('Group_Contract_Header',$groupContractHeaderID);

?>

<div id="main" role="main" style="background-color: <?php echo $backgroundColorPage; ?>">

    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" style="background-color:#c5b07b">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / <?php if($edit){echo "Edit";} else {echo "New";}?> Contract </li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-3 col-lg-<?php if($statusCancel && $edit){echo "8";}else{echo "10";}?>">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <img class="custom-rounded-image-padding " style="background-color: #c5b07b !important;display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/visiticon.png" width="30" height="30">
                    <?php if($edit){echo "Edit";} else {echo "New";}?> Group Contract Main
                </h3>
            </div>

            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2 pull-right">
                <button id="saveButton" onclick="saveContractHeader();" class="btn btn-success btn-block pull-right" <?php echo $buttonPlaced ?>><i class="fa fa-check"></i>&nbsp; Place Contract</button>
            </div>
            <?php
                if ($statusCancel && $edit){
                    echo "
                        <div class=\"col-xs-12 col-sm-4 col-md-3 col-lg-2 pull-right\">
                            <button id=\"cancelButton\" onclick=\"cancelContractHeader();\" class=\"btn btn-danger btn-block pull-right\" $buttonCancel><i class=\"fa fa-times\"></i>&nbsp; Cancel Contract</button>
                        </div>
                    ";
                }

            ?>

        </div>

        <!-- row -->
        <section id="widget-grid" class="">

            <div class="row" >

                <!-- NEW WIDGET START -->
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div style="margin-bottom:10px;" class="jarviswidget jarviswidget-color-blueDark" id="wid-id-5" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Contract Form</h2>

                        </header>

                        <!-- widget div-->
                        <div>

                            <!-- widget content -->
                            <div class="widget-body no-padding">

                                <form action="" id="checkout-form" class="smart-form">
                                    <fieldset>
                                        <div class="row">
                                            <section class="col col-4 no-margin" style="padding-left:20px;border-left:1px dotted #ADD8E6;border-right:1px dotted #ADD8E6;">
                                                <section>
                                                    <img style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/customerdefault.jpg" width="25" height="25">
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Contract Main Details</h3>
                                                </section>
                                                <section>
                                                    <label style="display:inline;" class="label-bold form-label-space" ><b>Find Customer: </b></label>
                                                    <input style='display:inline;' class='text-center form-control' id='customerSearch' name='customerSearch' type='text' <?php echo $viewElement ?> value='<?php if($edit)
                                                    {
                                                        echo "$customer->customerCode - $customer->companyName";
                                                    }
                                                    ?>'>

                                                </section>
                                                <section class="no-margin">
                                                    <input type="hidden" id="customerID" value="<?php if($edit){echo "$customer->customerID";} ?>"/>
                                                    <label class="label-bold form-label-space"> Customer Code: </label>
                                                    <label  style='color:#4682c4' class="label-text  bold" id='customerCode'><?php if($edit){echo "$customer->customerCode";} ?>  </label>
                                                </section>
                                                <section class="no-margin">
                                                    <label class="label-bold form-label-space"> Customer Name: </label>
                                                    <label style='color:#4682c4' class="label-text bold" id='customerName'><?php if($edit){echo "$customer->companyName";} ?>  </label>
                                                </section>
                                                <section class="no-margin">
                                                    <label class="label-bold form-label-space"> Balance : </label>
                                                    <label style='color:#4682c4' class="label-text bold" id='balance'><?php if($edit){echo number_format($customer->balance,2);} ?>  </label>
                                                </section>
                                                <div class="row" style="margin-top:10px;">

                                                </div>
                                                <section>
                                                    <label style="display:inline;" class="label-bold form-label-space" ><b>Select Salesperson:</b> </label>
                                                    <input <?php echo $viewElement ?> style='display:inline;' class='text-center form-control' id='salespersonSearch' name='salespersonSearch' type='text' value='<?php if($edit){echo "$salespersonCode - $firstName $lastName";}?>'>
                                                    <input  id='salespersonID' name='salespersonID' type='hidden' value='<?php if($edit){echo $salesperson_id;}?>'>
                                                </section>

                                                <div class="row" style="margin-top:10px;">

                                                </div>
                                                <section>
                                                    <label style="display:inline;" class="label-bold form-label-space" ><b>Select Technician:</b> </label>
                                                    <input <?php echo $viewElement ?>  style='display:inline;' class='text-center form-control' id='technicianSearch' name='technicianSearch' type='text' value='<?php if($edit){echo "$technicianCode - $technicianfirstName $technicianlastName";}?>'>
                                                    <input  id='technicianID' name='technician' type='hidden' value='<?php if($edit){echo $technician_id;}?>'>
                                                </section>


                                            </section>
                                            <section class="col col-4 no-margin" style="padding-left:20px;border-right:1px dotted #ADD8E6;">
                                                <section>
                                                    <img style="width:20px;height:20px;background-color: #c5b07b !important;" class="custom-rounded-image-padding tender" style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/visiticon.png" width="25" height="25">
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle">  Contract Details</h3>

                                                </section>

                                                <table id="detailsTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0">

                                                    <thead class="height:1px;">


                                                    </thead>
                                                    <tbody>
                                                    <tr >
                                                        <td><label class="label-bold form-label-space align-left"><b>Contract Number:</b> </label></td>
                                                        <td><input <?php echo $viewElement ?> class='text-center form-control' id='contractNumber' name='contractNumber' type='text' value='<?php if($edit){echo $group_contract_header_code;} ?>' readonly></td>


                                                    </tr>
                                                    <tr >
                                                        <td><label class="label-bold form-label-space align-left" ><b>Contract Status:</b> </label></td>
                                                        <td><input <?php echo $viewElement ?> type="text" id="contractStatus" class='text-center form-control slim-input' readonly value="<?php if ($edit){echo "$status";}else{echo "";} ?> "</td>
                                                    </tr>
                                                    <tr >
                                                        <td><label class="label-bold form-label-space align-left" ><b>Project:</b> </label></td>
                                                        <td><input <?php echo $viewElement ?> type="text" id="contractTitle" class='text-center form-control slim-input' value="<?php if ($edit){echo "$title";}else{echo "";} ?> "</td>
                                                    </tr>
                                                    <tr >
                                                        <td><label class="label-bold form-label-space align-left" ><b>Contract Title:</b> </label></td>
                                                        <td><input <?php echo $viewElement ?> type="text" id="notes" class='text-center form-control slim-input' value="<?php if ($edit){echo "$notes";}else{echo "";} ?> "</td>
                                                    </tr>


                                                    <tr >
                                                        <td><label class="label-bold form-label-space align-left" >Valid From: </label></td>
                                                        <td><input <?php echo $viewElement ?> type="text" id="contractValidFrom" value="<?php
                                                            if($edit)
                                                            {
                                                                $old_date_timestamp = strtotime($valid_from);
                                                                $groupContractDate = date('d/m/Y', $old_date_timestamp);
                                                                echo $groupContractDate;
                                                            }
                                                            else {
                                                                echo date('d/m/Y');
                                                            }?>" data-dateformat="dd/mm/yy" class="form-control text-center slim-input"
                                                                   data-mask="99/99/9999" data-mask-placeholder= "-">
                                                        </td>
                                                    </tr>


                                                    <tr >
                                                        <td><label class="label-bold form-label-space align-left" >Valid To: </label></td>
                                                        <td><input <?php echo $viewElement ?> type="text" id="contractValidUntil" value="<?php
                                                            if($edit)
                                                            {
                                                                $old_date_timestamp = strtotime($valid_until);
                                                                $groupContractDate = date('d/m/Y', $old_date_timestamp);
                                                                echo $groupContractDate;
                                                            }
                                                            else {
                                                                echo date('d/m/Y');
                                                            }?>" data-dateformat="dd/mm/yy" class="form-control text-center slim-input"
                                                                   data-mask="99/99/9999" data-mask-placeholder= "-">
                                                        </td>
                                                    </tr>
                                                    <tr >
                                                        <td><label class="label-bold form-label-space align-left" >Type of Contract: </label></td>
<!--                                                        <td class="custom-td-label"><label class="label-bold form-label-space align-center">Type of Contract: </label></td>-->
                                                        <td class="custom-td-input-large"><label class="select">
                                                                <select <?php echo $viewElement ?> style="text-align-last:center;" class='form-control slim-input'  id='typeOfContract' name='typeOfContract'>
                                                                    <?php

                                                                    global $username,$password,$database;


                                                                    $db = new mysqli(localhost,$username,$password,$database);
                                                                    if (mysqli_connect_errno()) {
                                                                        printf("Connect failed: %s\n", mysqli_connect_error());
                                                                        exit();
                                                                    }
                                                                    $db->set_charset("utf8");
                                                                    // WHERE compani code in  Session

                                                                    $stm = $db->prepare("SELECT contract_type_id,contract_type_code,contract_type_name FROM Contract_Types ORDER BY contract_type_id");
                                                                    $stm-> execute();
                                                                    $stm-> bind_result($contractTypeID,$contractTypeCode,$contractTypeName);
                                                                    while ($stm->fetch()) {

                                                                        if($edit&&strcmp($contract_type_id,$contractTypeID)==0)
                                                                        {
                                                                            echo "<option value='$contractTypeID' selected>$contractTypeName</option>";
                                                                        }
                                                                        else {
                                                                            echo "<option value='$contractTypeID'>$contractTypeName</option>";
                                                                        }

                                                                    }
                                                                    $stm-> close();
                                                                    ?>
                                                                </select>
                                                                <i></i>
                                                            </label>
                                                        </td>
                                                        </td>
                                                    </tr>




                                                    </tbody>
                                                </table>
                                            </section>
                                            <section class="col col-4 no-margin" >
                                                <section>
                                                    <img style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/infoicon.png" width="30" height="30">
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Additional Details</h3>



                                                </section>
                                                <section>
                                                    <label style="display:inline;" class="label-bold form-label-space" ><b>Details</b>: </label>
                                                    <textarea <?php echo $viewElement ?> style='width:100%;' class='form-control custom-textarea' rows='3' id='details'><?php if($edit){echo $details;} ?></textarea>

                                                </section>

                                                <section>
                                                    <label style="display:inline;" class="label-bold form-label-space" ><b>Extra Details</b>: </label>
                                                    <textarea <?php echo $viewElement ?> style='width:100%;' class='form-control custom-textarea' rows='3' id='detailsExtra'><?php if($edit){echo $details_2;} ?></textarea>

                                                </section>

                                                <section>
                                                    <label style="display:inline;" class="label-bold form-label-space" ><b>Notes</b>: </label>
                                                    <textarea <?php echo $viewElement ?> style='width:100%;' class='form-control custom-textarea' rows='3' id='notesExtra'><?php if($edit){echo $notes_2;} ?></textarea>

                                                </section>



                                            </section>

                                    </fieldset>
                                </form>

                            </div>
                            <!-- end widget content -->
                            <section style="border-top: 1px solid grey;padding-top: 2%">
                                <?php
                                $custTable->editCustomTableValues();
                                ?>
                            </section>

                        </div>
                        <!-- end widget div -->


                    </div>
                    <!-- end widget -->
                    <!-- Custom Fields-->

                    <!-- Custom Fields/-->
            </div>

            <!-- end row -->



        </section>
    </div>
</div>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/jquery.tabletojson.js"></script>
<script type="text/javascript">
    function cancelContractHeader(){
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/groupContracts/controllers/cancelContractHeader.php',
            data: {
                'group_contract_header_id':<?php echo $groupContractHeaderID; ?>
            },
            dataType:"json",
            success: function (result) {
                console.log(result);
                console.log('here');
                window.location.replace("//<?php echo HTML_PATH; ?>/cop/backend/modules/groupContracts/views/manage_contract_header.php");
            }
        });
    }


    function initCustomerCodeAutocomplete()
    {
        $("#customerSearch").autocomplete({
            source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/customer_autocomplete.php",
            autoFocus: true,
            select: function (event, ui) {
                $('#customerID').val(ui.item.customer_id);
                $('#customerCode').text(ui.item.customer_code);
                $('#customerName').text(ui.item.customer_company_name);
                $('#balance').text(ui.item.balance);

                var optionsAsString = "";
                for(var i = 0; i < ui.item.addresses.length; i++) {
                    if(i==0)
                    {
                        optionsAsString += "<option value=\"" + ui.item.addresses[i].id + "\" selected>" + ui.item.addresses[i].addressLine1 + "</option>";
                    }
                    else{
                        optionsAsString += "<option value=\"" + ui.item.addresses[i].id + "\">" + ui.item.addresses[i].addressLine1 + "</option>";
                    }


                }
                $("select[name='deliveryAddress']").find('option').remove().end().append($(optionsAsString));
                $("select[name='billingAddress']").find('option').remove().end().append($(optionsAsString));
                return true;
            }
        });
    }

    function initSalepersonCodeAutocomplete()
    {
        $("#salespersonSearch").autocomplete({
            source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/salesperson_autocomplete.php",
            autoFocus: true,
            minLength:0,
            select: function (event, ui) {

                $('#salespersonID').val(ui.item.salesperson_id);
                return true;
            }
        }).focus(function()
            {
                $(this).autocomplete("search","");
            }


        );
    }
    function initTechnicianCodeAutocomplete()
    {
        $("#technicianSearch").autocomplete({
            source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/salesperson_autocomplete.php",
            autoFocus: true,
            minLength:0,
            select: function (event, ui) {

                $('#technicianID').val(ui.item.salesperson_id);
                return true;
            }
        }).focus(function()
            {
                $(this).autocomplete("search","");
            }


        );
    }

    function saveContractHeader(){
        var customerID          = $('#customerID').val();
        var salespersonID       = $('#salespersonID').val();
        var technicianID        = $('#technicianID').val();
        var contractValidFrom   = $('#contractValidFrom').val();
        var contractValidUntil  = $('#contractValidUntil').val();
        var details             = $('#details').val();
        var detailsExtra        = $('#detailsExtra').val();
        var notes               = $('#notes').val();
        var notesExtra          = $('#notesExtra').val();
        var contractTitle       = $('#contractTitle').val();
        var typeOfContract = $('#typeOfContract').val();

        console.log(customerID);
        console.log(salespersonID);
        console.log(technicianID);
        console.log(contractTitle);
        console.log(contractValidFrom);
        console.log(contractValidUntil);
        console.log(details);
        console.log(detailsExtra);
        console.log(notes);
        console.log(notesExtra);
        <?php
        $custTable->declareCustomTableJsonVariables();
        ?>
        run = true;
        if(!customerID || !salespersonID|| !technicianID|| !contractValidFrom || !contractValidUntil ||!notes ||!contractTitle )
        {
            run=false;

        }

        if(run) {
            $.ajax({
                type: "POST",

                <?php
                if($edit)
                {
                    echo "url: '//" . HTML_PATH . "/cop/backend/modules/groupContracts/controllers/editGroupContractHeader.php',";
                }
                else
                {
                    echo "url: '//" . HTML_PATH . "/cop/backend/modules/groupContracts/controllers/addGroupContractHeader.php',";
                }
                ?>
                data: {
                    'customerID'        : customerID,
                    'salespersonID'     : salespersonID,
                    'technicianID'      : technicianID,
                    'contractValidFrom' : contractValidFrom,
                    'contractValidUntil': contractValidUntil,
                    'typeOfContract'    :typeOfContract,
                    'details'           : details,
                    'detailsExtra'      : detailsExtra,
                    'notes'             : notes,
                    'contractTitle'     : contractTitle,
                    'notesExtra'        : notesExtra
                    <?php if ($edit){echo ",'group_contract_header_id':$groupContractHeaderID";}
                    $custTable->passCustomTableJsonVariables();
                    ?>
                },

                success: function (result) {
                    if(result.includes('error')) {
                        $.smallBox({
                            title: "Warning!",
                            content: "Something Went Wrong Please Try again.",
                            color: '#b22222',
                            timeout: 3000,
                            icon: "fa fa-user swing animated"
                        });
                        $("#saveButton").attr("disabled", false);
                    } else {
                        $.smallBox({
                            title: "Success!",
                            content: "Contract successfully entered",
                            color: "#739E73",
                            timeout: 3000,
                            icon: "fa fa-user swing animated"
                        });

                        //window.location.replace("//<?php //echo HTML_PATH; ?>///cop/backend/modules/groupContracts/views/create_group_contract_header.php?group_contract_header_id=" + result);
                        window.location.replace("//<?php echo HTML_PATH; ?>/cop/backend/modules/groupContracts/views/manage_contract_header.php");

                    }
                }

            });
        }else{
            $.smallBox({
                title: "Error!",
                content: "Please complete Contract data",
                color: "#b22222",
                timeout: 3000,
                icon: "fa fa-user swing animated"
            });
            $("#saveButton").attr("disabled", false);
        }
    }


    $(document).ready(function() {
        pageSetUp();
        initCustomerCodeAutocomplete();
        initSalepersonCodeAutocomplete();
        initTechnicianCodeAutocomplete();
    });
</script>
