<?php
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Reader\Html;
include_once("../../../../param.php");
require_once (ROOT . "libs/phpSpreadsheet/vendor/autoload.php");

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$htmlCode = getHtmlCode($db);

if(isset($_POST['typeReport']) && strcmp( $_POST['typeReport'],"excel")==0){
    exportExcel($htmlCode);
}
else{
    echo $htmlCode;
}


function getHTMLCode($db){
    $typeReport='';
    if(isset($_POST['typeReport'])  ){
        $typeReport = $_POST['typeReport'];
    }
    $colors = ['#F1D46C', '#F5A49A', '#E3C3D7', '#F7D1A3', '#D47D5D'];
    $projectCounter = 1;
    $projects = array();
    $stmt = $db->prepare("SELECT h.group_contract_header_id, h.title, h.valid_from, h.valid_until, ind.grand_total, ind.invoice_date
                      FROM Group_Contracts_Documents AS g
                      INNER JOIN Invoices_Draft ind ON g.group_contract_doc_id = ind.tender_id
                      INNER JOIN Group_Contract_Header AS h ON h.group_contract_header_id = g.group_contract_header_id
                      WHERE h.status = 'Winning'
                      ORDER BY h.group_contract_header_id, ind.invoice_date ASC");
    $stmt->execute();
    $stmt->bind_result($headerID, $title, $validFrom, $validUntil, $monthGrandTotal, $invoiceDate);

    $yearTotals = array();
    while ($stmt->fetch()) {
        if (!isset($projects[$headerID])) {
            $projects[$headerID] = new StdClass();
            $projects[$headerID]->title = $title;
            $projects[$headerID]->valid_from = $validFrom;
            $projects[$headerID]->valid_until = $validUntil;
            $projects[$headerID]->total_agreement = 0;
            $projects[$headerID]->invoices = array();
        }

        $year = (new DateTime($invoiceDate))->format('Y');
        $month = (new DateTime($invoiceDate))->format('M-y');

        if (!isset($projects[$headerID]->invoices[$year])) {
            $projects[$headerID]->invoices[$year] = array();
            $yearTotals[$headerID][$year] = 0;
        }

        $projects[$headerID]->invoices[$year][$month] = $monthGrandTotal;
        $projects[$headerID]->total_agreement += $monthGrandTotal;
        $yearTotals[$headerID][$year] += $monthGrandTotal;

    }

    $report = '';
    foreach ($projects as $headerID => $project) {
        $report .= '<table style="border-collapse: collapse; width: 100%; ">';
        $report .= '<thead>
        <tr>
            <th rowspan="2" style="border: 1px solid black; text-align: center;background-color: #2c73df; " >A/A</th>
            <th rowspan="2" style="border: 1px solid black; text-align: center;background-color: #2c73df; ">PROJECT</th>
            <th rowspan="2" style="border: 1px solid black; text-align: center;background-color: #2c73df; ">Freq.</th>
            <th rowspan="2" style="border: 1px solid black; text-align: center;background-color: #2c73df; "> Agreement<br>Period</th>
            <th rowspan="2" style="border: 1px solid black; text-align: center;background-color: #4da846; "> TOTAL CHARGE FOR<br>AGREEMENT PERIOD</th>';

        //write years with the correct colspan
        $colorIndex = 0;
        foreach ($project->invoices as $year => $months) {
            $report .= '<th style="border: 1px solid black; text-align: center; background-color:' . $colors[$colorIndex % count($colors)] . ';" colspan="' . count($months) . '">' . $year . ' CHARGE (€)</th>';
            $colorIndex++;
        }

        //write the months of each year
        $colorIndex = 0;
        $report .= "<tr>";
        foreach ($project->invoices as $year => $months) {
            foreach ($months as $month => $total) {
                $report .= '<th style="border: 1px solid black; text-align: center;  background-color:' . $colors[$colorIndex % count($colors)] .';">' . $month . '</th>';
            }
            $colorIndex++;
        }
        $report .= "</tr>";
        $report .= '</thead><tbody>';

        $validFromFormatted = (new DateTime($project->valid_from))->format('d/m/Y');
        $validUntilFormatted = (new DateTime($project->valid_until))->format('d/m/Y');

        $report .= '<tr>';
        $report .= "<td style='border: 1px solid black; text-align: center;'>$projectCounter</td>";
        $report .= "<td style='border: 1px solid black; text-align: center;'>$project->title</td>";
        $report .= "<td style='border: 1px solid black; text-align: center;'>2/year</td>";
        $report .= "<td style='border: 1px solid black; text-align: center;'>$validFromFormatted - $validUntilFormatted</td>";
        $report .= "<td style='border: 1px solid black;text-align: center;'>€ " . number_format($project->total_agreement, 2) . "</td>";


        //write total of each month
        foreach ($project->invoices as $year => $months) {
            foreach ($months as $month => $total) {
                $report .= '<td style="border: 1px solid black;text-align: right;">€ ' . number_format($total, 2) . '</td>';
            }

        }
        $report .= '</tr>';


        // last line of table
        $report .= '<tr>';
        $report .= "<td colspan='4'  style='border: 1px solid black;text-align: center;background-color: #4da846;'>TOTAL AGREEMENT PERIOD:</td>";
        $report .= "<td colspan='1'  style='border: 1px solid black;text-align: center;background-color: #4da846;;'>€ " . number_format($project->total_agreement, 2) . "</td>";

        $colorIndex = 0;
        foreach ($project->invoices as $year => $months) {
            $yearTotal = $yearTotals[$headerID][$year];

            if( count($months)==1){
                $report .= "<td style='border: 1px solid black;text-align: left;background-color:" . $colors[$colorIndex % count($colors)] . ";'><b>TOTAL $year: € " . number_format($yearTotal, 2) . "</b></td>";
            }
            else{
               $report .= "<td style='border: 1px solid black;text-align: left;background-color:" . $colors[$colorIndex % count($colors)] . ";'><b>TOTAL $year:</b></td>";
                $report .= "<td style='border: 1px solid black;text-align: right;background-color:" . $colors[$colorIndex % count($colors)] . ";'> € " . number_format($yearTotal, 2) . "</td>";

                $remainingTds = count($months) - 2;
                if($remainingTds > 0) {
                    $report .= "<td style='border: 1px solid black;background-color:" . $colors[$colorIndex % count($colors)] . ";' colspan='$remainingTds'></td>";
                }
            }
            $colorIndex++;


        }

        $report .= '</tr>';

        $report .= '</tbody></table>';

        if(strcmp( $typeReport,"excel")!=0) {
            $report .= '<br>';

        }
            $projectCounter++;

    }


    return $report;

}

function exportExcel($htmlString){
    $spreadsheet = new Spreadsheet();
    $reader = new Html();
    $spreadsheet = $reader->loadFromString($htmlString);

    $sheet = $spreadsheet->getActiveSheet();
    $highestRow = $sheet->getHighestRow();
    $highestColumn = $sheet->getHighestColumn();
    $range = 'A1:' . $highestColumn . $highestRow;



    $writer = new Xlsx($spreadsheet);
    ob_end_clean();
    $fileName = "export.xlsx";
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . time() . '_' . $fileName . '"');
    header('Cache-Control: max-age=0');
    echo $writer->save('php://output');

}





?>