<?php
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);
include_once('../../../../param.php');
// DB table to use
$table = 'Journals';

// Table's primary key
$primaryKey = "journal_id";
$type = '';

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`j`.`journal_id`', 'dt' => 'logo', 'formatter' => function( $d, $row ) {
        return '<img class="img-rounded center-canvas" src="//' . HTML_PATH . '/cop/backend/modules/expenses/media/iconExpenses.png"  style="width: 35px !important;"></td>';},
        'field' => 'journal_id' ),

    array( 'db' => '`c`.`company_id`', 'dt' =>  'companyID', 'formatter' => function( $d, $row ) {
        $GLOBALS['companyID'] = $d;
        return $d;
    }, 'field' =>'company_id' ),

    array( 'db' => '`c`.`company_code`', 'dt' =>  'code', 'formatter' => function( $d, $row ) {
        $GLOBALS['companyCode'] = $d;
        return $d;
    }, 'field' =>'company_code' ),
    array( 'db' => '`c`.`company_name`', 'dt' => 'name', 'formatter' => function( $d, $row ) {
        $GLOBALS['companyName'] = $d;
        return $d;
    }, 'field' => 'company_name' ),


    array( 'db' => '`j`.`period_id`', 'dt' => 'month', 'formatter' => function( $d, $row ) {
        $GLOBALS['month'] = $d;
        return $d;
    }, 'field' => 'period_id' ),

    array( 'db' => '`j`.`year`', 'dt' => 'year', 'formatter' => function( $d, $row ) {
        $GLOBALS['year'] = $d;
        return $d;
    }, 'field' => 'year' ),

    array( 'db' => '`j`.`action_code`', 'dt' => 'status', 'formatter' => function( $d, $row ) {
        $GLOBALS['status'] = $d;
        return $d;
    },
        'field' => 'action_code' ),


    array( 'db' => '`j`.`journal_id`', 'dt' => 'actions', 'formatter' => function( $d, $row ) use ($type) {
        $year = $GLOBALS['year'];
        $month = $GLOBALS['month'];
        $companyInfo = $GLOBALS['companyCode']."-".$GLOBALS['companyName'];
        $companyID = $GLOBALS['companyID'];

        global $username,$password,$database;
        $db = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $exported = -1;
        $stm = $db->prepare("SELECT exported FROM Z_Z_ADJUSTMENTS WHERE  journal_id='$d'");
        $stm-> execute();
        $stm-> bind_result($exported);
        while ($stm->fetch()) {}
        $stm-> close();

        $buttonView = "<button type='button' class='btn btn-link' data-toggle='modal' onclick=\"showAdjustment('$d')\" style=\"margin-top:5px;width: auto;margin-left: 5%;color: darkgreen\">Exported</button>";
        $buttonViewPending = "<button type='button' class='btn btn-link' data-toggle='modal' onclick=\"showAdjustment('$d')\" style=\"margin-top:5px;width: auto;margin-left: 5%;color: orangered\">Pending To Export</button>";
        if ($exported>0){
            $returnElement = $buttonView;
        }elseif ($exported==0){
            $returnElement=$buttonViewPending;
        }else{
            $returnElement = '<button class="btn btn-orange" onclick="createAdjustmentforSD(\''.$d.'\',\''.$month.'\',\''.$year.'\',\''.$companyInfo.'\',\''.$companyID.'\');">Create Adjustments For S&D</button>';
        }


        return $returnElement;
    },
        'field' => 'journal_id' )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
if ($type>0){
    $arrayOFStatus = ['Successfull Check','Ready For Check','Failed Check','Successfull Check'];
}else{
    $arrayOFStatus = ['Failed Check','Successfull Check','Pending'];
}


$where = '';
$joinQuery = "FROM `Journals` AS `j` LEFT JOIN `Companies` AS `c` ON (`j`.`company_id` = `c`.`company_id`)";
$where = " `j`.`action_code` = 'Successfull Check'";

require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>