<?php
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);
include_once('../../../../param.php');
// DB table to use
$table = 'Expenses_Budget';

// Table's primary key
$primaryKey = 'budget';

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`e`.`account_id`', 'dt' => 'logo', 'formatter' => function( $d, $row ) {
        return '<img class="img-rounded center-canvas" src="//' . HTML_PATH . '/cop/backend/modules/expenses/media/iconExpenses.png"  style="width: 35px !important;"></td>';},
        'field' => 'account_id' ),

//    array( 'db' => '`e`.`year`', 'dt' =>  'year', 'field' =>'year' ),
//    array( 'db' => '`e`.`month`', 'dt' => 'month', 'field' => 'month' ),
    array( 'db' => '`c`.`company_name`', 'dt' => 'company', 'field' => 'company_name' ),
    array( 'db' => '`c`.`company_code`', 'dt' => 'companyCode', 'field' => 'company_code' ),
//    array( 'db' => '`ch`.`account_name`', 'dt' => 'category', 'field' => 'account_name' ),

    array( 'db' => '`ch`.`account_name`', 'dt' => 'category', 'formatter' => function( $d, $row ) {
        $name = explode("%&ara&%", $d)[0];
        return "$name";
        ;},
        'field' => 'account_name' ),
    array( 'db' => '`ch`.`account_name`', 'dt' => 'categoryArabic', 'formatter' => function( $d, $row ) {
        $nameArabic = explode("%&ara&%", $d)[1];
        return "$nameArabic";
        ;},
        'field' => 'account_name' ),
    array( 'db' => '`e`.`year`', 'dt' => 'year', 'formatter' => function( $d, $row ) {
        $GLOBALS['year']=$d;
        return "$d";
    }
    ,'field' => 'year' ),
    array( 'db' => '`e`.`month`', 'dt' => 'month', 'formatter' => function( $d, $row ) {
        $GLOBALS['month']=$d;
        $monthReturn = date("F", mktime(0, 0, 0, $d, 10));
        if ($d<10){
            $dcount = "0"."$d";
        }
        return "$dcount-$monthReturn";
    },'field' => 'month' ),
    array( 'db' => '`e`.`company_id`', 'dt' => 'company_id', 'formatter' => function( $d, $row ) {
        $GLOBALS['company_id']=$d;
    },'field' => 'company_id' ),
    array( 'db' => '`e`.`account_id`', 'dt' => 'account_id', 'formatter' => function( $d, $row ) {
        $GLOBALS['account_id']=$d;
    }
    ,'field' => 'account_id' ),
    array( 'db' => '`e`.`budget`', 'dt' => 'budget', 'field' => 'budget' ),

    array( 'db' => '`e`.`account_id`', 'dt' => 'actions', 'formatter' => function( $d, $row ) {
        $year = $GLOBALS['year'];
        $month = $GLOBALS['month'];
        $companyID = $GLOBALS['company_id'];
        $accountID = $GLOBALS['account_id'];
        return '<div style="display: flex;"><form style="display:inline;" target="_blank" class="tableRowForm" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/modules/expenses/views/new_expenses_category_budget.php" method="post">
                    <input type="hidden" class="invoiceID" name="year" value="'.$year.'">
                    <input type="hidden" class="invoiceID" name="month" value="'.$month.'">
                    <input type="hidden" class="invoiceID" name="companyID" value="'.$companyID.'">
                    <input type="hidden" class="invoiceID" name="accountID" value="'.$accountID.'">
                    <input style="font-size:13px;" type="submit" class="btn btn-primary" value="Edit">
                 </form>
			    <button class="btn btn-danger" type="button" style="margin-left: 2%;" onclick="deleteBudget('.$year.','.$month.','.$companyID.','.$accountID.')">Delete</button>
			</div>
			
			';},
        'field' => 'account_id' )

);

global $username,$password,$database;
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */

$where = '';
$joinQuery = "FROM `Expenses_Budget` AS `e` LEFT JOIN `Companies` AS `c` ON (`e`.`company_id` = `c`.`company_id`) LEFT JOIN `ChartOfAccounts` AS `ch` ON (`e`.`account_id` = `ch`.`account_id`)";
$where .= '';
require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table,
        $primaryKey,
        $columns,$joinQuery,$where)
);

?>