<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');

// DB table to use
$table = 'Customer_Updates';

// Table's primary key
$primaryKey = "id";

// Array of database columns which should be read and sent back to DataTables.
// The db parameter represents the column name in the database, while the dt
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => " CONCAT(c.customer_code,' - ',c.customer_company_name)",
        'dt' => 'customer',
        'field' => 'customer',
        'as'=>'customer'
    ),

    array(
        'db' => 'e.amount',
        'dt' => 'amount',
        'field' => 'amount'
    ),
    array(
        'db' => 'e.timestamp',
        'dt' => 'timestamp',
        'field' => 'timestamp'
    )


);
global $username,$password,$database;
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM Customer_Updates AS e 
                LEFT JOIN Customers AS c ON e.customer_id = c.customer_id ";
$where = '';


require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);

?>
