<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

include_once('../concc/dbinfo.php');
session_start();
require_once('../libs/emailer/PHPMailer/Exception.php');
require_once('../libs/emailer/PHPMailer/PHPMailer.php');
require_once('../libs/emailer/PHPMailer/SMTP.php');


global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

$docTypes  = array('1'=>'Tender','2'=>'Order','3'=>'Waybill','4'=>'Return','5'=>'Invoice','6'=>'Receipt','7'=>'Transfer');
$dateStart = date('Y-m-d H:i:s',strtotime(date('Y-m-d H:i:s') . "-90 minutes"));
$dateEnd   = date('Y-m-d H:i:s',strtotime(date('Y-m-d H:i:s') . "-30 minutes"));
$query     = "SELECT id,type,status,reason,timestamp FROM Documents_Status WHERE timestamp >= '$dateStart' AND timestamp <= '$dateEnd' AND NOT status = 1 AND NOT reason='Document Number already in use!' AND NOT reason='Document Already Exists'";
$result    = '';
$counter   = 0;
$db->set_charset("utf8");
$stm = $db->prepare("$query");
$stm->execute();
$stm->bind_result($docID, $docType, $status, $reason, $timestamp);
while ($stm->fetch()) {
    $counter++;
    $verbalType = $docTypes[$docType];

    if(strcmp($docTypes[$docType],'Transfer')==0){
        $class = "invoice";
        $table = "Warehouse_Transactions";
        $fileView = "warehouse_transaction";
        $fileEdit = "warehouse_transfer";
        $codeColumn = "warehouse_transaction_code";
        $idColumn = 'warehouse_transaction_id';
    } else {
        $class = strtolower($docTypes[$docType]);
        $table = $docTypes[$docType]."s";
        $codeColumn = strtolower($docTypes[$docType])."_code";
        $idColumn = strtolower($docTypes[$docType]).'_id';
        $fileEdit = $fileView = $class;
    }

    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT $codeColumn FROM $table WHERE $idColumn = $docID ");
    $stm2->execute();
    $stm2->bind_result($docCode);
    while ($stm2->fetch()) {}
    $stm2->close();

    $result .= "<tr><td>$counter</td><td>$verbalType</td><td>$docCode</td><td>$status</td><td>$reason</td></tr>";
}
$stm->close();

if(strcmp($result,'')!=0){
    $testfile = fopen('emailCronLog.txt','w');
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT company_name FROM Companies LIMIT 1");
    $stm->execute();
    $stm->bind_result($companyName);
    while ($stm->fetch()) {}
    $stm->close();

    $title = "Document Status Errors";

    if(strcmp("$companyName","")!=0){
        $title .= " For $companyName ";
    }



    $message = '<style>
                    table.bordered{border-left: 1px solid #ddd;border-top: 1px solid #ddd;border-spacing:0;border-collapse: collapse;width:100%;}
                    table.bordered td{border-right: 1px solid #ddd;border-bottom: 1px solid #ddd;padding: 2mm;text-align: center;}
                </style>';

    $message .= "<center>";
    $message .= "<table class='bordered'>";
    $message .= "<tr><td colspan='5' style='font-weight: bolder;'>$title</td></tr>";
    $message .= "<tr style='background-color: lightblue;font-weight: bolder;'><td >AA</td><td>Document Type</td><td>Document Code</td><td>Error Code</td><td>Reason</td></tr>";
    $message .=  $result;
    $message .= "</table>";
    $message .= "<br><br>-- This is an automatic Email. Please DO NOT reply to this Email --<br><br>";
    echo $message;

    $emails = array('aspanos@coprime.co');

    foreach ($emails as $email) {
        if (strpos($email, '@') !== false) {
            sendEmailForDocumentStatus("$email", 'Coprime Mobile Commerce', "$title", "$message", "$title");
            fwrite($testfile,"SENT TO : $email\n");
        }
    }
    fclose($testfile);
}



function sendEmailForDocumentStatus($emailsString,$senderName,$subject,$body,$documentCode='',$documentID=0,$documentType='mail'){

    $emailsString = trim($emailsString, '"');
    $emailsString = str_replace(",", ";", $emailsString);
    $emailsString = rtrim($emailsString, ';');

    $emails = array();
    $emails = explode(';', $emailsString);
    if(count($emails) == 0){echo "Missing Emails<br>";return;}

    global $username,$password,$database;
    $db99 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db99->set_charset("utf8");

    if(strcmp("$senderName","")==0){
        $mailStmt = $db99->prepare("SELECT company_name FROM Companies LIMIT 1");
        $mailStmt->execute();
        $mailStmt->bind_result($company_name);
        if ($mailStmt->fetch()) {
            if(strcmp($company_name,'')!=0) {
                $senderName = $company_name;
            }
        } else {
            echo $mailStmt->error;
        }
        $mailStmt->close();
    }

    $mailStmt = $db99->prepare("SELECT email_host,email_from,email_username,email_password FROM Cloud_Configuration LIMIT 1");
    $mailStmt->execute();
    $mailStmt->bind_result($email_host, $email_from, $email_username, $email_password);
    if ($mailStmt->fetch()) {
        $mailHost = $email_host;
        $senderEmail = $email_from;
        $mailUsername = $email_username;
        $mailPassword = $email_password;
    } else {
        echo $mailStmt->error;
    }
    $mailStmt->close();

    if(strcmp("$mailHost","")==0){echo "Missing email Host<br>";return;}
    if(strcmp("$senderEmail","")==0){echo "Missing Sender Email<br>";return;}
    if(strcmp("$mailUsername","")==0){echo "Missing Credentials<br>";return;}
    if(strcmp("$mailPassword","")==0){echo "Missing Credentials<br>";return;}
    if(strcmp("$senderName","")==0){$senderName = "$senderEmail";}

    foreach ($emails as $emailTo) {
        $atCounter = substr_count($emailTo, "@");
        if ($atCounter < 2) {

            $mail = new PHPMailer(true);
            $mail->SMTPDebug = 0;
            $mail->isSMTP();
            $mail->Host = $mailHost;
            $mail->SMTPAuth = true;
            $mail->Username = $mailUsername;
            $mail->Password = $mailPassword;
            $mail->SMTPSecure = 'tls';
            $mail->Port = 587;
            $mail->setFrom($senderEmail, $senderName);
            $mail->addAddress($emailTo);
            $mail->addCC('amichael@coprime.co');
            $mail->CharSet = 'UTF-8';
            $mail->Encoding = "base64";
            $mail->isHTML(true);
            $mail->Subject = "$subject";
            $mail->Body = "$body";
            $mail->send();

            $db99->set_charset("utf8");
            $mailStmt = $db99->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
            $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
            $mailStmt->execute();
            $mailStmt->close();

            echo " Sent Email -> $emailTo<br>";
        } else {
            echo " Wrong Email Format ($emailTo)<br>";
            $emailTo = "ERROR: Wrong Email Format ($emailTo) ";

            $db99->set_charset("utf8");
            $mailStmt = $db99->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
            $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
            $mailStmt->execute();
            echo $mailStmt->error;
            $mailStmt->close();
        }

    }
    echo "<br>";

    return 1;
}

?>