<?php
include_once("../../../../param.php");

$edit = false;

if(isset($_POST['custom_screen_id'])) {
    $customScreenID=$_POST['custom_screen_id'];
    $edit = true;
}

if(isset($_GET['custom_screen_id'])) {
    $customScreenID=$_GET['custom_screen_id'];
    $edit = true;
}


if($edit){
    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $statement = $db->prepare("SELECT custom_screen_id,custom_screen_code,title,type,class,icon,query,show_icon_on_lines,show_table_filters,custom_top_buttons,custom_line_buttons,table_order_by,hide_columns,field_type,records_per_page,on_click_function,custom_javascript,menu_item_definition_id FROM ZB_Custom_Screens WHERE custom_screen_id='$customScreenID'");
    $statement->execute();
    $statement->bind_result($customTableID,$screenCode,$screenTitle,$screenType,$screenClass,$screenIcon,$query,$showIconLines,$filter,$customButtons,$customLineButtons,$orderCol,$hideCol,$fieldType,$recordsPerPage,$onClickFunction,$customJavaScript,$menuItemDefinisionID);
    if (!$statement->fetch()) {
        echo $statement->error;
    }
    $statement->close();
    $customScreenCode = str_replace(' ','%20',$screenCode);
}

?>

<style type="text/css" media="screen">

    .editor {
        padding: 0px;
        margin: 0;
        position: relative;
        top: 0;
        bottom: ;
        left: 0;
        right: 0;
        height: 250px;
        font-size: 14px;
    }

    .app_editor {
        height: 250px;
        font-size: 13px;
    }

    .app_editor_wrapper {
        background-color: #cccccc;
        border-bottom: 1px solid transparent;
    }

    .app_editor_dragbar {
        background-color: whitesmoke;
        border-bottom: 2px solid rgba(128, 128, 128, 0.62);
        width: 100%;
        height: fit-content;
        line-height: 10px;
        cursor: row-resize;
        opacity: 1;
        margin-top: -9px;
    }

    .table>tbody>tr>td{
        padding: 2px !important;
    }
</style>

<div id="main" role="main">
    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>
        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Custom Screen</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">
        <section>
            <div align="left">
                <h3 class="page-title txt-color-blueDark" style="margin-top:5px;margin-bottom: 15px;">
                    <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                    <?php if ($edit){echo 'Edit';}else{echo 'New';}?>
                    Custom Screen
                    <button  type="button" name="generateReport"  class="btn btn-success" onclick="saveCustomForm()" style="padding: 8px 12px;float: right;margin-left: 20px;"><i class="fa fa-check"></i>&nbsp; Save Screen</button>
                    <?php if ($edit){
                        echo '<a href="//'.HTML_PATH.'/cop/backend/modules/customViews/views/custom_screen.php?screen='.$customScreenCode.'" target="_blank" class="btn btn-waybill"  style="padding: 8px 12px;float: right;margin-left: 20px;">&nbsp; <i class="fa fa-eye"></i>&nbsp; view &nbsp;</a>';
                        echo '<button type="button" class="btn btn-danger " style="padding: 8px 12px;margin-left: 15px;" onclick="funModalToDeleteCustomScreen()">Delete  Screen </button> ';
                    }
                    ?>

                </h3>
            </div>
        </section>

        <section id="widget-grid" class="">

            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-6 col-sm-6 col-md-6 col-lg-6">

                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <h2>Screen Settings</h2>
                        </header>
                        <!-- widget div-->
                        <div>

                            <!-- widget content -->
                            <div class="widget-body no-padding" id="resultElement">
                                <div class="row">

                                    <div class="col-sm-12">

                                        <form id="sliderForm" method="post" class="smart-form" enctype="multipart/form-data">

                                            <fieldset style="padding-top:15px;padding-bottom: 0px;">



                                                        <section class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                                                            <table class="table" style="width: 100%;">
                                                                <tr>
                                                                    <td>
                                                                        <label class="label-bold pull-left padding-10">Screen Code:</label>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" class="form-control text-center"  id="screenCode" value="<?php if ($edit){echo $screenCode;} ?>"/>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <label class="label-bold pull-left padding-10">Screen Title:</label>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" class="form-control text-center"  id="screenTitle" value="<?php if ($edit){echo $screenTitle;}?>"/>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <label class="label-bold pull-left padding-10">Order By (Columns):</label>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" class="form-control text-center"  id="orderCol" placeholder="1-asc , 2-desc , 3-asc" value="<?php if ($edit){echo $orderCol;}?>"/>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <label class="label-bold pull-left padding-10">Hide Fields (Columns):</label>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" class="form-control text-center"  id="hideCol" placeholder="1, 2, 3" value="<?php if ($edit){echo $hideCol;}?>"/>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <label class="label-bold pull-left padding-10">On Click function (Row):</label>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" class="form-control text-center"  id="onClickFunction" placeholder="" value="<?php if ($edit){echo $onClickFunction;}?>"/>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>

                                                                    </td>
                                                                    <td>

                                                                    </td>
                                                                </tr>
                                                            </table>

                                                        </section>
                                            </fieldset>
                                        </form>



                                    </div>

                                </div>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>

                <article class="col-xs-6 col-sm-6 col-md-6 col-lg-6">

                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <h2>Screen Design</h2>
                        </header>
                        <!-- widget div-->
                        <div>

                            <!-- widget content -->
                            <div class="widget-body no-padding" id="resultElement">
                                <div class="row">

                                    <div class="col-sm-12">

                                        <form id="sliderForm" method="post" class="smart-form" enctype="multipart/form-data">

                                            <fieldset style="padding-top:15px;padding-bottom: 0px;">

                                                    <section class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                                                        <table class="table" style="width: 100%;">
                                                            <tr>
                                                                <td>
                                                                    <label class="label-bold pull-left padding-10">Screen Type</label>
                                                                </td>
                                                                <td  colspan="2">
                                                                    <select  class="form-control text-center" id="screenType" style="border-radius: 15px !important;">
                                                                        <option value="table" <?php if ($edit && ($screenType=='table')){echo 'selected';} ?>>Table</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <label class="label-bold pull-left padding-10">Records Per Page</label>
                                                                </td>
                                                                <td colspan="2">
                                                                    <select  class="form-control text-center" id="recordsPerPage" style="border-radius: 15px !important;">
                                                                        <option value="10" <?php if ($edit && ($recordsPerPage=='10')){echo 'selected';} ?>>10</option>
                                                                        <option value="25" <?php if ($edit && ($recordsPerPage=='25')){echo 'selected';} ?>>25</option>
                                                                        <option value="50" <?php if ($edit && ($recordsPerPage=='50')){echo 'selected';} ?>>50</option>
                                                                        <option value="100" <?php if ($edit && ($recordsPerPage=='100')){echo 'selected';} ?>>100</option>
                                                                    </select>
                                                                </td>

                                                            </tr>
                                                            <tr>
                                                                <td >
                                                                        <span class="pull-left">
                                                                            <label class="label-bold padding-10">Icon & Class</label>
                                                                            <img id="icon-image" class="custom-rounded-image <?php echo $screenClass?>" src="<?php if ($edit){echo "//".HTML_PATH."/cop/backend/themes/smartadmin/img/".$screenIcon;}?>" width="30" height="30" style="margin-left: 0px;" />
                                                                        </span>
                                                                </td>
                                                                <td style="width: 140px;">
                                                                    <select class="form-control text-center" id="screenIcon" style="border-radius: 15px 0px 0px 15px !important;">
                                                                        <option value="tendericon.png">Tender Icon</option>
                                                                        <option value="ordericon.png">Order Icon</option>
                                                                        <option value="waybillicon.png">Waybill Icon</option>
                                                                        <option value="invoiceicon.png">Invoice Icon</option>
                                                                        <option value="returnicon.png">Return Icon</option>
                                                                        <option value="receipticon.png">Receipt Icon</option>
                                                                        <option value="visiticon.png">Visit Icon</option>
                                                                        <option value="settingsicon.png">Service Call Icon</option>
                                                                        <option value="stockadjustmenticon.png">Stock Icon</option>
                                                                        <option value="itemdefaulticon.jpg">Item Icon</option>
                                                                        <option value="customerdefault.jpg">Customer Icon</option>
                                                                    </select>
                                                                </td>
                                                                <td style="width: 140px;">
                                                                    <select class="form-control text-center" id="screenClass" style="border-radius: 0px 15px 15px 0px !important;">
                                                                        <option value="noclass">No Class</option>
                                                                        <option value="tender">Tender Class</option>
                                                                        <option value="order">Order Class</option>
                                                                        <option value="waybill">Waybill Class</option>
                                                                        <option value="invoice">Invoice Class</option>
                                                                        <option value="return">Return Class</option>
                                                                        <option value="receipt">Receipt Class</option>
                                                                        <option value="btn-visit">Visit Class</option>
                                                                        <option value="yearly">Black Class</option>
                                                                        <option value="btn-success">Success Class</option>
                                                                        <option value="btn-warning">Warning Class</option>
                                                                        <option value="btn-danger">Danger Class</option>
                                                                    </select>
                                                                </td>
                                                            </tr>

                                                            <tr>
                                                                <td>
                                                                    <label class="label-bold pull-left padding-10">Table Filters</label>
                                                                </td>
                                                                <td colspan="2">
                                                                    <label class="cop-switch"><input type="checkbox" class="checkmark" id="filter" name="filter" value="yes" <?php if ($edit && $filter=='no'){echo '';}else{echo 'checked';} ?>><span class="cop-switch-slider"></span></label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <label class="label-bold pull-left padding-10">Icon on line</label>
                                                                </td>
                                                                <td colspan="2">
                                                                    <label class="cop-switch"><input type="checkbox" class="checkmark" id="showIconLines" name="showIconLines" value="yes" <?php if ($edit && $showIconLines=='no'){echo '';}else{echo 'checked';} ?>><span class="cop-switch-slider"></span></label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>

                                                                </td>
                                                                <td >

                                                                </td>
                                                                <td>

                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </section>
                                            </fieldset>
                                        </form>


                                    </div>

                                </div>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>

                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <h2>Screen Query</h2>
                        </header>
                        <!-- widget div-->
                        <div>

                            <!-- widget content -->
                            <div class="widget-body no-padding" id="resultElement">
                                <div class="row">

                                    <div class="col-sm-12">



<!--                                                    <pre class="editor" id="query">--><?php //if ($edit){echo $query;}?><!--</pre>-->
                                                    <input type="hidden" id="customTableID" value="<?php if ($edit){echo $customTableID;} ?>" >
                                                    <input type="hidden" id="menuItemDefinisionID" value="<?php if ($edit){echo $menuItemDefinisionID;} ?>" >

                                                <div id="query_wrapper" class="app_editor_wrapper">
                                                    <pre class="app_editor" id="query" ><?php if ($edit){echo $query;}?></pre>
                                                    <div id="query_dragbar" class="app_editor_dragbar"><center>=</center></div>
                                                </div>


                                        <footer>

                                        </footer>

                                    </div>

                                </div>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>

                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false" >
                        <header>
                            <h2>Field Inputs</h2>
                        </header>
                        <!-- widget div-->
                        <div>

                            <!-- widget content -->
                            <div class="widget-body no-padding" id="resultElement" >
                                <div class="row">

                                    <div class="col-sm-12">

                                        <form id="sliderForm" method="post" class="smart-form" enctype="multipart/form-data">

                                            <fieldset style="padding:0px!important;margin-top: 0px;!important;">
                                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTable " width="100%" border="0" cellpadding="0" cellspacing="0" style="padding:0px!important; margin-top: 0px !important;">

                                                    <thead style="color: white">
                                                        <tr>
                                                            <th class='text-center yearly'></th>
                                                            <th class='text-center yearly'>Input Type</th>
                                                            <th class='text-center yearly'>Field</th>
                                                            <th class='text-center yearly'>Default Values</th>
                                                            <th class='text-center yearly'>From Query</th>
                                                            <th class='text-center yearly'>Display Name</th>
                                                            <th class='text-center yearly'>Input Value</th>
                                                            <th class='text-center yearly'>On click function</th>
                                                            <th class='text-center yearly'>On change function</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php
                                                        $i = 1;
                                                        if($edit) {

                                                            $db = new mysqli(localhost, $username, $password, $database);
                                                            if (mysqli_connect_errno()) {
                                                                printf("Connect failed: %s\n", mysqli_connect_error());
                                                                exit();
                                                            }
                                                            $db->set_charset("utf8");
                                                            $stm = $db->prepare("SELECT field, field_type, default_values, from_query, display_name, input_value, on_click_function, on_change_function,custom_screen_field_id FROM ZB_Custom_Screen_Fields WHERE custom_screen_id ='$customScreenID' ");
                                                            $stm-> execute();
                                                            $stm-> bind_result($field,$lineFieldType,$defaultValues,$fromQuery,$displayName,$inputValue,$onClickFunctionFields,$onChangeFunction,$customScreenFieldID);
                                                            while ($stm->fetch()) {



                                                                echo "<tr>";

                                                                echo "<td >
                                                                <img class='deletRowButton' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/deleteicon.png' style='width:20px;height:20px;'/>
												            </td>";


                                                                $numberSelected = $checkboxSelected = $comboboxSelected = $dateSelected = $timeSelected = $textareaSelected = $jsonArraySelected = $textSelected = $nullselect = '';
                                                                switch ($lineFieldType){
                                                                    case 'number':
                                                                        $numberSelected = 'selected';
                                                                        break;
                                                                    case 'checkbox':
                                                                        $checkboxSelected = 'selected';
                                                                        break;
                                                                    case 'combobox':
                                                                        $comboboxSelected = 'selected';
                                                                        break;
                                                                    case 'date':
                                                                        $dateSelected = 'selected';
                                                                        break;
                                                                    case 'time':
                                                                        $timeSelected = 'selected';
                                                                        break;
                                                                    case 'textarea':
                                                                        $textareaSelected = 'selected';
                                                                        break;
                                                                    case 'JSONArray':
                                                                        $jsonArraySelected = 'selected';
                                                                        break;
                                                                    case 'text':
                                                                        $textSelected = 'selected';
                                                                        break;
                                                                    default:
                                                                        $nullselect = 'selected';
                                                                }

                                                                echo "<td style='' class='text-center' style='width:10%' >
                                                   <select style='width:100%' class='form-control text-center' id='lineFieldType' name='lineFieldType'>
                                                        <option $textSelected>text</option>
                                                        <option $dateSelected>date</option>
                                                        <option $timeSelected>time</option>
                                                        <option $numberSelected>number</option>
                                                        <option $textareaSelected>textarea</option>
                                                        <option $checkboxSelected>checkbox</option>
                                                        <option $comboboxSelected>combobox</option>
                                                        <option $jsonArraySelected>JSONArray</option>
                                                        <option $nullselect></option>
                                                   </select>
                                                  </td>";
                                                                echo "<td style='' class='text-center' style='width:20%' >
                                                   <input style='width:100%' class='text-center form-control' id='fieldfield' name='fieldfield' type='text' value='$field'>
                                                  </td>";


                                                                echo "<td class='index text-center' style='width:10%'>
                                                                        <textarea style='width:100%' class='text-center form-control' id='fieldDefaultValues' name='fieldDefaultValues' >$defaultValues</textarea>				
                                                                     </td>";


                                                                echo "<td style='' class='text-center' style='width:20%' >
                                                                <textarea style='width:100%' class='text-center form-control' id='fieldFromQuery' name='fieldFromQuery' >$fromQuery</textarea>
                                                  </td>";

                                                                echo "<td style='' class='text-center' style='width:20%' >
                                                   <input style='width:100%' class='text-center form-control' id='fieldDisplayName' name='fieldDisplayName' type='text' value='$displayName'>
                                                  </td>";

                                                                echo "<td style='' class='text-center' style='width:20%' >
                                                   <input style='width:100%' class='text-center form-control' id='fieldInputValue' name='fieldInputValue' type='text' value='$inputValue'>
                                                  </td>";

                                                                echo "<td style='' class='text-center' style='width:20%' >
                                                                        <textarea style='width:100%' class='text-center form-control' id='fieldOnClickFunction' name='fieldOnClickFunction' >$onClickFunctionFields</textarea>				
                                                  </td>";

                                                                echo "<td style='' class='text-center' style='width:20%' >
                                                                        <textarea style='width:100%' class='text-center form-control' id='fieldOnChangeFunction' name='fieldOnChangeFunction' >$onChangeFunction</textarea>				
                                                  </td>";



                                                                echo "</tr>";

                                                                $i++;
                                                            }
                                                            $stm-> close();
                                                        }

                                                        $k=$i+1;
                                                        if($i == 1){$k=3;}
                                                        for ($i; $i < $k; $i++) {

                                                            echo "<tr>";



                                                            echo "<td  >
                                                                <img class='deletRowButton' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/deleteicon.png' style='width:20px;height:20px;'/>
												            </td>";
                                                            echo "<td style='' class='text-center'  >
                                                   <select style='width:100%' class='form-control text-center' id='lineFieldType' name='lineFieldType'>
                                                        <option></option>
                                                        <option>text</option>
                                                        <option>date</option>
                                                        <option>time</option> 
                                                        <option>number</option>
                                                        <option>textarea</option>
                                                        <option>checkbox</option>
                                                        <option>combobox</option>
                                                   </select>
                                                  </td>";
                                                            echo "<td style='' class='text-center'  >
                                                          <input style='width:100%' class='text-center form-control' id='fieldfield' name='fieldfield' type='text' value=''>
                                                  </td>";
                                                            echo "<td style='' class='text-center'  >
                                                    <textarea style='width:100%' class='text-center form-control' id='fieldDefaultValues' name='fieldDefaultValues' ></textarea>
                                                  </td>";
                                                            echo "<td style='' class='text-center'  >
                                                    <textarea style='width:100%' class='text-center form-control' id='fieldFromQuery' name='fieldFromQuery' ></textarea>
                                                  </td>";

                                                            echo "<td style='' class='text-center'  >
                                                   <input style='width:100%' class='text-center form-control' id='fieldDisplayName' name='fieldDisplayName' type='text' value=''>
                                                  </td>";

                                                            echo "<td style='' class='text-center'  >
                                                   <input style='width:100%' class='text-center form-control' id='fieldInputValue' name='fieldInputValue' type='text' value=''>
                                                  </td>";

                                                            echo "<td style='' class='text-center'  >
                                                    <textarea style='width:100%' class='text-center form-control' id='fieldOnClickFunction' name='fieldOnClickFunction' ></textarea>
                                                  </td>";

                                                            echo "<td style='' class='text-center'  >
                                                    <textarea style='width:100%' class='text-center form-control' id='fieldOnChangeFunction' name='fieldOnChangeFunction' ></textarea>
                                                  </td>";

                                                            echo "</tr>";


                                                        }



                                                        ?>
                                                    </tbody>
                                                </table>
                                            </fieldset>
                                        </form>
                                        <div class="row" >
                                            <span class="col-sm-1" style="margin: 10px;margin-top: 0px;">
                                                <a target="_blank" id="newLineButton" class="btn btn-primary btn-block">
                                                    <i class="fa fa-plus  "></i>&nbsp; Add Field
                                                </a>
                                            </span>
                                        </div>
                                        <footer>

                                        </footer>

                                    </div>

                                </div>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>

                <article class="col-xs-6 col-sm-6 col-md-6 col-lg-6">

                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <h2>Custom Header HTML</h2>
                        </header>
                        <!-- widget div-->
                        <div>

                            <!-- widget content -->
                            <div class="widget-body no-padding" id="resultElement">
                                <div class="row">

                                    <div class="col-sm-12">

                                        <form id="sliderForm" method="post" class="smart-form" enctype="multipart/form-data">

                                            <fieldset style="padding:0px">

                                                <textarea name="content" id="customButtons" class="form-control" style="resize: vertical;" rows="15" required><?php if ($edit){echo $customButtons;}?></textarea>

                                            </fieldset>
                                        </form>

                                        <footer>

                                        </footer>

                                    </div>

                                </div>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>

                <article class="col-xs-6 col-sm-6 col-md-6 col-lg-6">

                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <h2>Custom Line HTML</h2>
                        </header>
                        <!-- widget div-->
                        <div>

                            <!-- widget content -->
                            <div class="widget-body no-padding" id="resultElement">
                                <div class="row">

                                    <div class="col-sm-12">

                                        <form id="sliderForm" method="post" class="smart-form" enctype="multipart/form-data">

                                            <fieldset style="padding:0px">

                                                <textarea name="content1" id="customLineButtons" class="form-control" style="resize: vertical;" rows="15" required><?php if ($edit){echo $customLineButtons;}?></textarea>

                                            </fieldset>
                                        </form>

                                        <footer>

                                        </footer>

                                    </div>

                                </div>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>

                <article class="col-xs-6 col-sm-6 col-md-6 col-lg-6">

                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <h2>JavaScript</h2>
                        </header>
                        <!-- widget div-->
                        <div>

                            <!-- widget content -->
                            <div class="widget-body no-padding" id="resultElement">

                                <div class="row">

                                    <div class="col-sm-12">


                                            <fieldset style="padding:0px;">
                                                <div id="customJavaScript_wrapper" class="app_editor_wrapper">
                                                    <pre class="app_editor" id="customJavaScript" ><?php if ($edit){echo $customJavaScript;}?></pre>
                                                    <div id="customJavaScript_dragbar" class="app_editor_dragbar"><center>=</center></div>
                                                </div>
                                            </fieldset>

                                        <footer>

                                        </footer>

                                    </div>

                                </div>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>

                <article class="col-xs-6 col-sm-6 col-md-6 col-lg-6">

                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <h2>Table Colors function(nRow)</h2>
                        </header>
                        <!-- widget div-->
                        <div>

                            <!-- widget content -->
                            <div class="widget-body no-padding" id="resultElement">
                                <div class="row">

                                    <div class="col-sm-12">



                                                <div id="fieldType_wrapper" class="app_editor_wrapper">
                                                    <pre class="app_editor" id="fieldType" ><?php if ($edit){echo $fieldType;}?></pre>
                                                    <div id="fieldType_dragbar" class="app_editor_dragbar"><center>=</center></div>
                                                </div>


                                        <footer>

                                        </footer>

                                    </div>

                                </div>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>

                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false" >
                        <header>
                            <h2>Screen Controllers</h2>
                        </header>
                        <!-- widget div-->
                        <div>

                            <!-- widget content -->
                            <div class="widget-body no-padding" id="resultElement" >
                                <div class="row">

                                    <div class="col-sm-12">

                                        <form id="sliderForm" method="post" class="smart-form" enctype="multipart/form-data">

                                            <fieldset style="padding:0px!important;margin-top: 0px;!important;">
                                                <table id="datatable_controllers" class="table table-striped table-hover dataTable " width="100%" border="0" cellpadding="0" cellspacing="0" style="padding:0px!important; margin-top: 0px !important;">

                                                    <thead style="color: white">
                                                    <tr>
                                                        <th class='text-center yearly'>Controller</th>
                                                        <th class='text-center yearly'>File Name</th>
                                                        <th class='text-center yearly'>Actions</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>

                                                    </tbody>
                                                </table>
                                            </fieldset>
                                        </form>
                                        <div class="row" >
                                            <span class="col-sm-2" style="margin: 10px;margin-top: 0px;">
                                                <button target="_blank"  class="btn btn-primary btn-block" onclick="createController(<?php echo $customScreenID?>);">
                                                    <i class="fa fa-plus  "></i>&nbsp; Add Controller
                                                </button>
                                            </span>
                                        </div>
                                        <footer>

                                        </footer>

                                    </div>

                                </div>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- WIDGET END -->
            </div>
            <!-- end row -->
        </section>

    </div>
</div>


<div id="deleteModalCustomScreen" class="modal fade" role="dialog">

    <div class="modal-dialog">

        <div class="modal-content">

            <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal">&times;</button>

                <center><h4 class="modal-title">Delete Custom Screen </h4></center>

            </div>

            <div class="modal-body" style="word-break: break-all;">

                <center>

                    <h3>You are about to delete <b><?php echo $screenTitle ?></b> Custom Screen:</h3>
<!--                    <h3>Custom Screen Query:</h3>-->
                    <p style="width: 100%;"><b>Query: </b><?php echo $query ?></p>


                    <h3 style="width: 100%; color: firebrick">The <b>Custom Screen will be removed </b></h3>
                    <h3 style="width: 100%; color: firebrick">from all custom menus as well.</h3>
                    <h3>Are you sure?</h3>

                </center>
            </div>
            <div class="modal-footer">

                <button type="button" class="btn btn-danger pull-left" onclick="deleteCustomForm()" >Yes, Delete</button>

                <button type="button" class="btn btn-link pull-right" onclick="$('#deleteModalCustomScreen').modal('hide');" >No, Close</button>

            </div>

        </div>

    </div>

</div>

<div class="modal fade" id="fileModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document"  style=" width: 90% !important;">
        <div class="modal-content" style="background-color: #22262e;" >
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" id="modalClose"><span aria-hidden="true" style="color: whitesmoke">Close</span></button>
                <h4 style="color:black;display: inline-block;width: 40%;margin-right: 1px;" class="modal-title" id="myModalLabel" >
                    <span style="color: white">Controller Name &nbsp;&nbsp;</span>
                    <input type="text" class="form-control" id="customScreenControllerName" style="width: 40%;display: inline-block; background-color: #3D3B39; color: white;padding: 10px !important;"/>
                    <button type="button" class="btn btn-primary" id="saveControllerButton" name="saveControllerButton" onclick="saveController();" style="margin-left: 15px;">Save</button>
                </h4>

            </div>
            <div class="modal-body" style="height: 640px !important;">
                    <pre class="app_editor" id="customScreenControllerEditor" style="height: 600px;"></pre>
                <input type="hidden" id="customScreenControllerID" value="">
                <input type="hidden" id="customScreenControllerFileName" value="">
            </div>
            <div class="modal-footer">
                <div class="text-color-white pull-left" style="display: block;">Console:</div>
                <pre class="text-color-white pull-left" style="background-color: black;color: white;width: 100%;text-align: left;" id="resultDiv">

                </pre>
            </div>
        </div>
    </div>
</div>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/jquery.tabletojson.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/libs/ace-builds/src/ace.js"></script>

<script type="text/javascript">

    function saveController(){
        var screenID    = '<?php echo $customScreenID;?>';
        var screenControllerID = $('#customScreenControllerID').val();
        var screenControllerName = $('#customScreenControllerName').val();
        var fileName = $('#customScreenControllerFileName').val();
        var fileContext = ace.edit("customScreenControllerEditor").session.getValue();

        fileContext = fileContext.replaceAll("UPDATE",'|-|UPDT|-|');
        fileContext = fileContext.replaceAll("INSERT",'|-|INSRT|-|');
        fileContext = fileContext.replaceAll("SET",'|-|ST|-|');
        fileContext = fileContext.replaceAll("DELETE",'|-|DLT|-|');

        var check = true;
        var msg = "";

        if(screenID==="" || screenID==="0"){
            msg = "Controllers Can Be Added Only in Saved Screens";
            check = false;
        } else if(screenControllerName===null || screenControllerName==="" || screenID===" "){
            msg = "Please Add Controller Name";
            check = false;
        } else if(fileContext===null || fileContext==="" || fileContext===" "){
            msg = "Empty Files are not allowed as controllers";
            check = false;
        }

        if(check) {
            $.ajax({
                type: "POST",
                url: '//<?php echo HTML_PATH; ?>/cop/backend/modules/customViews/controllers/add_update_controller.php',
                data: {
                    'screenID': screenID,
                    'screenControllerID': screenControllerID,
                    'screenControllerName': screenControllerName,
                    'fileName': fileName,
                    'fileContext': fileContext,
                },
                success: function (result) {
                    $('#resultDiv').html(result);
                    $('#datatable_controllers').DataTable().ajax.reload(null,false);

                    if(result === '') {
                        $.smallBox({
                            title: "Saved!",
                            content: "Controller Saved",
                            color: "#739E73",
                            timeout: 1000,
                            icon: "fa fa-gear swing animated"
                        });
                        $('#resultDiv').html("Controller File Saved.");
                    }
                }
            });
        } else {
            $.smallBox({
                title : "Complete Data!",
                content : msg,
                color : "firebrick",
                timeout: 5000,
                icon : "fa fa-gift swing animated"
            });
        }


    }

    function saveOpenedController(){
        $('#resultDiv').html('&nbsp;');
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH; ?>/cop/backend/modules/customViews/controllers/getCustomScreenControllerContext.php',
            data: {'screenControllerID':screenControllerID},
            success: function (result) {
                var controller = jQuery.parseJSON(result);


                $('#customScreenControllerID').val(screenControllerID);
                $('#customScreenControllerName').val(controller.controllerName);
                ace.edit("customScreenControllerEditor").setValue(controller.file,-1);
                $('#fileModal').modal('show');
            }
        });
    }

    function createController(screenID){
        $('#resultDiv').html('&nbsp;');
        $('#customScreenControllerName').val('');
        $('#customScreenControllerID').val(0);
        ace.edit("customScreenControllerEditor").setValue('<\?php\ninclude_once("../../param.php");\n\n\?>',-1);
        $('#fileModal').modal('show');
    }

    function editScreenController(screenControllerID){
        $('#resultDiv').html('&nbsp;');
        $('#customScreenControllerName').val('');
        $('#customScreenControllerID').val(0);
        ace.edit("customScreenControllerEditor").setValue("");

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH; ?>/cop/backend/modules/customViews/controllers/getCustomScreenControllerContext.php',
            data: {'screenControllerID':screenControllerID},
            success: function (result) {
                var controller = jQuery.parseJSON(result);

                $('#customScreenControllerID').val(screenControllerID);
                $('#customScreenControllerName').val(controller.controllerName);
                ace.edit("customScreenControllerEditor").setValue(controller.file,-1);
                $('#fileModal').modal('show');
            }
        });


    }

    window.draggingAceEditor = {};

    function makeAceEditorResizable(editor){
        var id_editor = editor.container.id;
        var id_dragbar = '#' + id_editor + '_dragbar';
        var id_wrapper = '#' + id_editor + '_wrapper';
        var wpoffset = 0;
        window.draggingAceEditor[id_editor] = false;

        $(id_dragbar).mousedown(function(e) {
            e.preventDefault();

            window.draggingAceEditor[id_editor] = true;

            var _editor = $('#' + id_editor);
            var top_offset = _editor.offset().top - wpoffset;

            // Set editor opacity to 0 to make transparent so our wrapper div shows
            _editor.css('opacity', 0);

            // handle mouse movement
            $(document).mousemove(function(e){
                var actualY = e.pageY - wpoffset;
                // editor height
                var eheight = actualY - top_offset;

                // Set wrapper height
                $(id_wrapper).css('height', eheight);

                // Set dragbar opacity while dragging (set to 0 to not show)
                $(id_dragbar).css('opacity', 0.15);
            });
        });

        $(document).mouseup(function(e){
            if (window.draggingAceEditor[id_editor])
            {
                var ctx_editor = $('#' + id_editor);

                var actualY = e.pageY - wpoffset;
                var top_offset = ctx_editor.offset().top - wpoffset;
                var eheight = actualY - top_offset;

                $( document ).unbind('mousemove');

                // Set dragbar opacity back to 1
                $(id_dragbar).css('opacity', 1);

                // Set height on actual editor element, and opacity back to 1
                ctx_editor.css('height', eheight).css('opacity', 1);

                // Trigger ace editor resize()
                editor.resize();

                window.draggingAceEditor[id_editor] = false;
            }
        });
    }

    function funModalToDeleteCustomScreen(){
        $('#deleteModalCustomScreen').modal('show');
    }

    function deleteCustomForm(){
        var customTableID = document.getElementById("customTableID").value;
        var menuItemDefinisionID = document.getElementById("menuItemDefinisionID").value;
        if (customTableID!=''){
            $.ajax({
                type: "POST",
                url: '//<?php echo HTML_PATH; ?>/cop/backend/modules/customViews/controllers/delete_custom_table.php',
                data: {
                    'customTableID':customTableID,
                    'menuItemDefinisionID':menuItemDefinisionID
                },
                success: function (result) {
                    window.location.replace("//<?php echo HTML_PATH; ?>/cop/backend/modules/customViews/views/manage_custom_screens.php");
                }
            });
        }else{
            $.smallBox({
                title : "Failed!",
                content : msg,
                color : "red",
                timeout: 5000,
                icon : "fa fa-gift swing animated"
            });
        }
    }

    function deleteRow(row) {
        var rowCount = $('#datatable_fixed_column tr').length;

        if (rowCount > 2) {
            $(row).parents('tr').remove();
        }
    }

    function addNewLine() {
        $lastTr = $('tr:last', $('#datatable_fixed_column'));
        $lastTd = $('td:last', $lastTr);
        $newTr = $lastTr.clone();
        $lastTr.after($newTr);
        $i = $newTr.find(".fieldPosition").val();
        $newTr.find("input").val("");
        $newTr.find("textarea").text("");
        $newTr.find("label").text("");
        $i++;
        $newTr.find(".fieldPosition").val();

        $( ".deletRowButton" ).click(function() {
            deleteRow(this);
        });

    }

    function saveCustomForm(){
        $('#generateReport').attr('disabled',true);
        var screenCode = document.getElementById("screenCode").value;
        var screenType = document.getElementById("screenType").value;
        var screenTitle = document.getElementById("screenTitle").value;
        var screenIcon = document.getElementById("screenIcon").value;
        var screenClass = document.getElementById("screenClass").value;
        var orderCol = document.getElementById("orderCol").value;
        var hideCol = document.getElementById("hideCol").value;
        var customTableID = document.getElementById("customTableID").value;
        var menuItemDefinisionID = document.getElementById("menuItemDefinisionID").value;
        var recordsPerPage = document.getElementById("recordsPerPage").value;
        var onClickFunction = document.getElementById("onClickFunction").value;

        var filter = $('#filter:checked').val();
        if(!filter){filter = 'no';}

        var showIconLines = $('#showIconLines:checked').val();
        if(!showIconLines){showIconLines = 'no';}

        var query = ace.edit("query").session.getValue();
        var fieldType = ace.edit("fieldType").session.getValue();
        var customJavaScript = ace.edit("customJavaScript").session.getValue();

        var customButtons = $('#customButtons').summernote('code');
        var customLineButtons = $('#customLineButtons').summernote('code');



        var fieldsCustom = $('#datatable_fixed_column').tableToJSON(
            {
                // ignoreColumns: [0,1],
                textExtractor : {
                    0 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    1 : function(cellIndex, $cell) {
                        // var checkVal = $cell.find('input').val();
                        // if(checkVal.localeCompare('')!=0){
                        //     hasFields = true;
                        // }
                        return $cell.find('select').val();
                    },
                    2 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    3 : function(cellIndex, $cell) {
                        return $cell.find('textarea').val();
                    },
                    4 : function(cellIndex, $cell) {
                        return $cell.find('textarea').val();
                    },
                    5 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    6 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    7 : function(cellIndex, $cell) {
                        return $cell.find('textarea').val();
                    },
                    8 : function(cellIndex, $cell) {
                        return $cell.find('textarea').val();
                    }
                },
                ignoreHiddenRows: false,
                ignoreEmptyRows: false
            }
        );


        console.log(customButtons);
        console.log(customLineButtons);
        if(screenCode===null || screenCode===""){
            var msg = "Screen Code is empty";
            var check = false;
        }else if(screenTitle===null || screenTitle===""){
            var msg = "Screen Name is empty";
            var check = false;
        }else if(screenIcon===null || screenIcon===""){
            var msg = "Screen Icon  is empty";
            var check = false;
        }else if(screenClass===null || screenClass===""){
            var msg = "Screen Class is empty";
            var check = false;
        }else if(query===null || query===""){
            var msg = "Query is empty";
            var check = false;
        }else{
            check = true;
        }

        if (check){
            $.ajax({
                type: "POST",
                url: '//<?php echo HTML_PATH; ?>/cop/backend/modules/customViews/controllers/validateCustomScreenCode.php',
                data: {'screenCode':screenCode,'customTableID':customTableID},
                success: function (result) {
                    if(result == 0) {
                        $.ajax({
                            type: "POST",
                            <?php
                            if ($edit) {
                                echo "url: '//" . HTML_PATH . "/cop/backend/modules/customViews/controllers/edit_custom_table.php',";
                            } else {
                                echo "url: '//" . HTML_PATH . "/cop/backend/modules/customViews/controllers/add_custom_table.php',";
                            }
                            ?>
                            data: {
                                'screenCode': screenCode,
                                'screenType': screenType,
                                'screenTitle': screenTitle,
                                'screenIcon': screenIcon,
                                'screenClass': screenClass,
                                'showIconLines': showIconLines,
                                'customButtons': customButtons,
                                'customLineButtons': customLineButtons,
                                'orderCol': orderCol,
                                'hideCol': hideCol,
                                'filter': filter,
                                'customTableID': customTableID,
                                'menuItemDefinisionID': menuItemDefinisionID,
                                'query': query,
                                'customJavaScript': customJavaScript,
                                'fieldType': fieldType,
                                'recordsPerPage': recordsPerPage,
                                'onClickFunction': onClickFunction,
                                'fieldsCustom': fieldsCustom
                            },
                            success: function (result) {
                                // console.log(result);
                                window.location.replace("//<?php echo HTML_PATH; ?>/cop/backend/modules/customViews/views/create_new_custom_screen.php?custom_screen_id=" + result);
                            }

                        });
                    } else {
                        console.log(result);
                        $.smallBox({
                            title : "Failed!",
                            content : "Code Already Exists",
                            color : "red",
                            timeout: 5000,
                            icon : "fa fa-gift swing animated"
                        });
                    }
                }
            });
        }else{
            $.smallBox({
                title : "Failed!",
                content : msg,
                color : "red",
                timeout: 5000,
                icon : "fa fa-gift swing animated"
            });
        }


    }

    $(document).ready(function() {

        <?php
        if ($edit){
            echo "$('#screenIcon').val('$screenIcon');";
            echo "$('#screenClass').val('$screenClass');";
        }
        ?>

        $('#screenIcon').on('change',function() {
            var image = $(this).val();
            $('#icon-image').attr('src','//<?php echo HTML_PATH; ?>/cop/backend/themes/smartadmin/img/'+image);
        });
        $('#screenClass').on('change',function() {
            $('#icon-image').removeAttr('class').attr('class', '');
            $('#icon-image').addClass('custom-rounded-image').addClass($(this).val());

        });

        pageSetUp();
        $( "#newLineButton" ).click(function() {
            addNewLine();
        });
        $( ".deletRowButton" ).click(function() {
            deleteRow(this);
        });

        var fixHelperModified = function(e, tr) {
                var $originals = tr.children();
                var $helper = tr.clone();
                $helper.children().each(function(tr) {
                    $(this).width($originals.eq(tr).width())
                });
                return $helper;
            },
            updateIndex = function(e, ui) {
                $('td.index', ui.item.parent()).each(function (i) {
                    $(this).find('.fieldPosition').val(i + 1);
                });
            };

        $("#datatable_fixed_column tbody").sortable({
            helper: fixHelperModified,
            stop: updateIndex
        });

        $('#customButtons').summernote({
            height: 200,                 // set editor height
            minHeight: 200,             // set minimum height of editor
            maxHeight: null,            // set maximum height of editor
            focus: false,               // set focus to editable area after initializing summernote
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'underline', 'clear']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['table', ['table']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            table: 'table table-striped'

        });
        $('#customLineButtons').summernote({
            height: 200,                 // set editor height
            minHeight: 200,             // set minimum height of editor
            maxHeight: null,            // set maximum height of editor
            focus: false,               // set focus to editable area after initializing summernote
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'underline', 'clear']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['table', ['table']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            table: 'table table-striped'

        });


        window.scrollTo(0, 0);

        var queryeditor = ace.edit("query");
        queryeditor.setTheme("ace/theme/cobalt");
        queryeditor.session.setMode("ace/mode/sql");
        makeAceEditorResizable(queryeditor);


        var customJavaScripteditor = ace.edit("customJavaScript");
        customJavaScripteditor.setTheme("ace/theme/idle_fingers");
        customJavaScripteditor.session.setMode("ace/mode/javascript");
        makeAceEditorResizable(customJavaScripteditor);

        var fieldTypeeditor = ace.edit("fieldType");
        fieldTypeeditor.setTheme("ace/theme/idle_fingers");
        fieldTypeeditor.session.setMode("ace/mode/javascript");
        makeAceEditorResizable(fieldTypeeditor);

        var customScreenControllerEditor = ace.edit("customScreenControllerEditor");
        customScreenControllerEditor.setTheme("ace/theme/monokai");
        customScreenControllerEditor.session.setMode("ace/mode/php");


        var responsiveHelper_datatable_fixed_column = undefined;
        var breakpointDefinition = {tablet : 1024, phone : 480};

        $('#datatable_controllers').DataTable({
            "sDom": "t",
            "autoWidth" : true,
            "processing": false,
            "serverSide": true,
            'pageLength':-1,
            "ajax": "//<?php echo HTML_PATH ?>/cop/backend/modules/customViews/controllers/getCustomScreenControllers.php?screenID=<?php echo $customScreenID?>",
            "columns": [
                { "data": "controller_name" },
                { "data": "file_name" },
                { "data": "actions" }
            ],
            "order": [[ 1, "asc" ]],
            "deferRender": true,
            "buttons": ["copyHtml5",
                "excelHtml5",
                "csvHtml5",
                {
                    extend: 'pdfHtml5',
                    orientation: 'landscape',
                    pageSize: 'LEGAL'
                }
            ],
            "preDrawCallback" : function() {
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_controllers'), breakpointDefinition);
                }
            },
            "rowCallback" : function(nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback" : function(oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }
        });

    });


</script>

<link rel="stylesheet" type="text/css" href="//cdnjs.cloudflare.com/ajax/libs/codemirror/3.20.0/codemirror.css">
<link rel="stylesheet" type="text/css" href="//cdnjs.cloudflare.com/ajax/libs/codemirror/3.20.0/theme/monokai.css">
<script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/codemirror/3.20.0/codemirror.js"></script>
<script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/codemirror/3.20.0/mode/xml/xml.js"></script>
<script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/codemirror/2.36.0/formatting.js"></script>

<link rel="stylesheet" href="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.css">
<script type="text/javascript" src="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.js"></script>
<script type="text/javascript" src="//<?php echo HTML_PATH ?>/cop/libs/summernote/plugin/hello/summernote-ext-hello.js"></script>