<?php
// ----------------------------------------------------------
// ------- CHANGE IF TRANSFERRED TO CUSTOM FOLDER !! --------
// ----------------------------------------------------------

 $rootDirectory = "../../../../"; // Default Folder Directory
// $rootDirectory = "../";        //  Custom Folder Directory

// ----------------------------------------------------------
// ----------------------------------------------------------

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

$scheduleID = intval($_POST['scheduleID']);
$contractID = intval($_POST['contractID']);

$scheduleID = 111212;
$contractID = 993412;

include_once($rootDirectory.'concc/dbinfo.php');
include_once($rootDirectory.'backend/modules/contractSchedules/controllers/calculateNextExecutionDate.php');

global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {printf("Connect failed: %s\n", mysqli_connect_error());exit();}
$db->set_charset("utf8");

$contractScheduleHelper = new ContractSchedule();

$contractSchedule = $contractScheduleHelper->getContractScheduleByID($db, $scheduleID);

if(strcmp("$contractSchedule->contractID", "$contractID") == 0) {

    if(strcmp("$contractSchedule->startDate","0000-00-00") != 0 && strcmp("$contractSchedule->startDate","0000-00-00") != 0) {

        $todayDateTime = time();
        $startDateTime = strtotime("$contractSchedule->startDate");
        $dateDifference = $todayDateTime - $startDateTime;
        $daysDifference = floor($dateDifference / (60 * 60 * 24));

        for($i = $daysDifference; $i > 0; $i--) {
            $currentDate = date('Y-m-d', strtotime(date('Y-m-d') . " -$i day"));
            executeContractShedulesOfDate($db,$contractScheduleHelper,$contractSchedule,$currentDate);
        }

    }

}


function executeContractShedulesOfDate($db,$contractScheduleHelper,$contractSchedule,$today){

    $match = $contractScheduleHelper->matchContractScheduleByDate($today,$contractSchedule->startDate,$contractSchedule->typeOfSchedule,$contractSchedule->months,$contractSchedule->days,$contractSchedule->daysOfMonth,$contractSchedule->details);

    if(!$match){
        echo "$today - No Contract Schedules<br>";
        echo "---------------------------------------------------------<br>";
        return;
    }

    $hasServiceCall = $contractScheduleHelper->contractScheduleHasServiceCall($db,$contractSchedule->contractScheduleID,$today);
    if($hasServiceCall){
        echo "$today - Contract Schedule Already Executed<br>";
        echo "---------------------------------------------------------<br>";
        return;
    }

    echo "$today - $contractSchedule->typeOfSchedule $contractSchedule->details | MONTHS[$contractSchedule->months] DAYS[$contractSchedule->days] DATES[$contractSchedule->daysOfMonth]<br>";


    try {
        $db->begin_transaction();

        echo "Contract Schedule: $contractSchedule->details<br>";

        $scheduleID     = $contractSchedule->contractScheduleID;
        $assignToID     = $contractSchedule->assignSalespersonID;
        $typeOfSchedule = $contractSchedule->typeOfSchedule;
        $startDate      = $contractSchedule->startDate;
        $startTime      = $contractSchedule->startTime;
        $endTime        = $contractSchedule->endTime;
        $days           = $contractSchedule->days;
        $months         = $contractSchedule->months;
        $daysOfMonth    = $contractSchedule->daysOfMonth;
        $details        = $contractSchedule->details;
        $nextRunDate    = $contractScheduleHelper->calculateNextExecutionDate($startDate,$typeOfSchedule,$months,$days,$daysOfMonth);

        $scheduleStartTime   = date_format(date_create($startTime), "H:i");
        $scheduleEndTime     = date_format(date_create($endTime), "H:i");

        $sourceName          = "";
        $callerDetails       = "";
        $sourceID            = 0;
        $serviceCallType     = intval($contractSchedule->scTypeID);
        $serviceCallStatus   = 1;
        $priority            = 1;
        $customerID          = intval($contractSchedule->customerID);
        $serialNumberID      = intval($contractSchedule->serialNumberID);
        $customerAddressID   = getPrimaryCustomerAddressID($db,$customerID);
        $serviceCallTitle    = "$details";
        $serviceCallDetails  = "$typeOfSchedule Contract Schedule \n $details";
        $serviceCallDate     = $today.' '.$scheduleStartTime;
        $dueDate             = $today.' '.$scheduleEndTime;
        $scScheduleStartDate = $today.' '.$scheduleStartTime;
        $scScheduleEndDate   = $today.' '.$scheduleEndTime;
        $referSalespersons   = explode(',',"$contractSchedule->referredSalespersons");

        echo "Creating Service Call: ";

        $response = createServiceCall($db, $assignToID, $customerID, $customerAddressID, $serialNumberID, $sourceID, $serviceCallType, $serviceCallStatus, $priority, $serviceCallTitle, $serviceCallDetails, $sourceName, $callerDetails, $serviceCallDate, $dueDate, $scScheduleStartDate, $scScheduleEndDate);

        if ($response->status != 1) {
            throw new Exception("$response->error");
        }


        if($response->serviceCallID > 0){

            $serviceCallID = $response->serviceCallID;

            foreach($referSalespersons as $referSalesperson){
                if($referSalesperson != 0) {
                    addServiceCallReferred($db, $serviceCallID, $referSalesperson, 0);
                }
            }

            $scRecord = $contractScheduleHelper->insertContractScheduleServiceCallRecord($db,$scheduleID,$serviceCallID,$today);

            if (!$scRecord) {
                throw new Exception("Error Linking Service Call to Contract Schedule");
            }
        }

        echo "$response->serviceCallCode - $response->serviceCallTitle<br>";

        $response = $contractScheduleHelper->updateContractSchedule($db,$scheduleID,$today,$nextRunDate,$startTime,$endTime);

        echo "Update Contract Schedule ($scheduleID) Last Run ($today) - Next Run ($nextRunDate)<br>";
        if (!$response) {
            throw new Exception("Error Updating Contract Schedule");
        }




        echo "Contract Schedules for $today Complete<br>";
        echo "---------------------------------------------------------<br>";
        $db->commit(true);

    } catch (Exception  $e) {
        echo '<br>ERROR: ' . $e->getMessage()."<br>Line: ".$e->getLine();
        $db->rollback();
    }
}

function createServiceCall($db,$salespersonSearch,$customerID,$customerAddressID,$serialNumberID,$sourceID,$serviceCallType,$serviceCallStatus,$priority,$serviceCallTitle,$serviceCallDetails,$sourceName,$callerDetails,$serviceCallDate,$dueDate,$serviceCallscheduleStartDate,$serviceCallscheduleEndDate){

    $serviceCallCode = "C"."C".getNextServiceCallCodeSingleTransaction($db,"CLOUD");
    $serviceCallID   = getNextIdSingleTransaction($db,"Service_Call","service_call_id");
    $salespersonID   = 0;

    $stmt = $db->prepare("INSERT INTO Service_Call (service_call_id,service_call_code,salesperson_id,assign_to,customer_id,customer_address_id,serial_number_id,source_id,type_id,status_id,priority_id,topic,details,source_name,source_details,date,due_date,schedule_start_date,schedule_end_date,progress,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'-1',NOW())");
    $stmt->bind_param('isiiiiiiiiissssssss',$serviceCallID,$serviceCallCode,$salespersonID,$salespersonSearch,$customerID,$customerAddressID,$serialNumberID,$sourceID,$serviceCallType,$serviceCallStatus,$priority,$serviceCallTitle,$serviceCallDetails,$sourceName,$callerDetails,$serviceCallDate,$dueDate,$serviceCallscheduleStartDate,$serviceCallscheduleEndDate);
    $stmt->execute();
    $error = $stmt->error;
    $stmt->close();

    $response = new stdClass();
    $response->error = $error;
    $response->serviceCallID = $serviceCallID;
    $response->serviceCallCode = $serviceCallCode;
    $response->serviceCallTitle = $serviceCallTitle;


    if(strcmp($error,"")!=0) {
        $response->status = 0;
        return $response;
    } else {
        lockContractServiceCallSingleTransaction($db,$serviceCallID, "Service_Call");
        setNextContractServiceCallCodeSingleTransaction($db,"CLOUD");
        $response->status = 1;
        return $response;
    }
}

function lockContractServiceCallSingleTransaction($db,$documentID,$documentType){

    if(!contractServiceCallContainsLockSingleTransaction($db,$documentID,$documentType)) {
        $stmt = $db->prepare("INSERT INTO ZD_Lock_Document (document_id,document_type,timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('is', $documentID, $documentType);
        $stmt->execute();
        $stmt->close();
    }
}

function contractServiceCallContainsLockSingleTransaction($db,$documentID,$documentType){
    $contains=false;
    $stm1 = $db->prepare("SELECT COUNT(*) FROM ZD_Lock_Document WHERE document_id='$documentID' AND document_type='$documentType'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0) {
            $contains=true;
        }
    }
    $stm1->close();
    return $contains;
}

function setNextContractServiceCallCodeSingleTransaction($db,$activationCode){

    $stmt = $db->prepare("UPDATE Devices SET begin_service_call_number=begin_service_call_number+1 WHERE activation_code='$activationCode'");
    $stmt->execute();
    $stmt->close();
}

function getPrimaryCustomerAddressID($db,$customerID){
    $customerAddressID = 0;
    $stm = $db->prepare("SELECT customer_address_id FROM CustomerAddress WHERE customer_id=? ORDER BY primary_address DESC,timestamp DESC LIMIT 1");
    $stm->bind_param('i', $customerID);
    $stm->execute();
    $stm->bind_result($customerAddressID);
    while ($stm->fetch()) {}
    $stm->close();
    return intval($customerAddressID);
}

function getNextServiceCallCodeSingleTransaction($db,$activationCode)
{
    $beginOrderNumber="";


    $stm1 = $db->prepare("SELECT begin_service_call_number FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($beginOrderNumber);
    while ($stm1->fetch()) {

    }
    $stm1->close();
    return $beginOrderNumber;
}

function getNextIdSingleTransaction($db,$tableName,$idName){
    $z=0;
    $prefix=1990;

    $likeVar = $prefix."%";
    $stm1 = $db->prepare("SELECT $idName FROM $tableName WHERE $idName LIKE '$likeVar' ORDER BY $idName DESC LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($nextID);
    while ($stm1->fetch()) {
        $z = substr($nextID,4,strlen($nextID));
        $z+=1;
    }
    $stm1->close();

    return $prefix.$z;

}

function addServiceCallReferred($db,$serviceCallID,$referSalesperson,$addedBy){
    $stmt = $db->prepare("INSERT INTO SC_Referred_To (service_call_id,salesperson_id,added_time,added_by_id,timestamp) VALUES(?,?,NOW(),?,NOW())");
    $stmt->bind_param('iii', $serviceCallID, $referSalesperson, $addedBy);
    $stmt->execute();
    $stmt->close();
}
?>

