<?php
include_once("../../../param.php");

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT DISTINCT(B2B_User.customer_id), CONCAT(customer_code, ' - ',customer_company_name), count(b2b_user_id) FROM B2B_User,Customers WHERE B2B_User.customer_id=Customers.customer_id GROUP BY B2B_User.customer_id");
$stm-> execute();
$stm-> bind_result($customerID, $customerName,$countUsers);
while ($stm->fetch()) {
    $customerSelection .= "<option value='$customerID'>$customerName - (Users: $countUsers)</option>";
}


function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}
?>

<div id="main" role="main" class="background-color-whitish">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Reports / Single  Report</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
                <span>  <a onclick="backToReports()" class="btn btn-primary"><i class="fa fa-arrow-left"></i>&nbsp; Back to Reports</a> </span>
                <h3 style="display:inline;margin-left:10px;" class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-signal"></i>
                    Reports
                </h3>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="" style="margin-top:10px;">
            <!-- row -->
            <div class="row">

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-2" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Report Criteria</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">

<!--                                <label style="display: block; margin-top: 10px"><b>Select B2B Customer:</b></label>-->
<!--                                <select name="b2bCustomer" id="b2bCustomer" class="form-control" style="width: 50%">-->
<!--                                    <option value="0">- All Customers -</option>-->
<!--                                    --><?php //echo $customerSelection; ?>
<!--                                </select>-->

                                <label style="display: block; margin-top: 10px"><b>Filter Customer Specific Categories:</b></label>
                                <select name="userSpecific" id="userSpecific" class="form-control" style="width: 50%">
                                    <option value="no">B2B Categories</option>
                                    <option value="only">Customer Specific Categories</option>
                                    <option value="yes">B2B & Customer Specific Categories</option>

                                </select>

                                <label style="display: block; margin-top: 10px"><b>Filter Inactive Products:</b></label>
                                <select name="filterProductStatus" id="filterProductStatus" class="form-control" style="width: 50%">
                                    <option value="active">Active Products</option>
                                    <option value="inactive">Inactive Products</option>
                                    <option value="all">All Products</option>

                                </select>

                                <br>
                                <br>


                                <button type="button" name="generateReport" id="generateReport" class="btn btn-primary" onclick="getReport()" >Generate Report</button>
                                <button type="button" name="generateExcel"  id="generateExcel"  class="btn btn-waybill" onclick="exportXLS()" >Export to Excel</button>
                                <button type="button" name="generatePDF"    id="generatePDF"    class="btn btn-danger"  onclick="exportPDF()" >Export PDF</button>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-3" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Report</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">

                            <div name="reportResult" id="reportResult"></div>
                                <form method="POST" action="#" name="xlsForm" id="xlsForm" >
                                    <input type="hidden" name="inputResult" id="inputResult" value=""/>
                                    <input type="hidden" name="inputTitle" id="inputTitle" value="ProductsNotInB2B_<?php echo date('d-m-y_h-i'); ?>"/>
                                </form>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

            </div>


    </div>
    <!-- end widget content -->

    <!-- end row -->
    </section>

</div>

<script type="text/javascript">

    $(document).ready(function() {

        pageSetUp();
        $('#b2bCustomer').select2();



    });

    function getReport(){

        var customer = $('#b2bCustomer').val();
        var userSpecific = $('#userSpecific').val();
        var filterProductStatus = $('#filterProductStatus').val();

        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/b2bAdmin/generateProductsNotInB2BCategoriesReport.php',
            data: {'customer':customer,'userSpecific':userSpecific,'filterProductStatus':filterProductStatus},

            success: function (result) {
                $('#reportResult').html(result);
            }
        });

    }

    function exportXLS(){

        var customer = $('#b2bCustomer').val();
        var userSpecific = $('#userSpecific').val();
        var filterProductStatus = $('#filterProductStatus').val();

        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/b2bAdmin/generateProductsNotInB2BCategoriesReport.php',
            data: {'customer':customer,'userSpecific':userSpecific,'filterProductStatus':filterProductStatus},

            success: function (result) {
                $('#reportResult').html(result);
                $('#inputResult').val(result);
                $('#xlsForm').attr('action','//<?php echo HTML_PATH ?>/cop/backend/core/templates/xls/generateGeneralXLS.php').submit();
            }
        });


    }

    function exportPDF(){

        var customer = $('#b2bCustomer').val();
        var userSpecific = $('#userSpecific').val();
        var filterProductStatus = $('#filterProductStatus').val();

        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/b2bAdmin/generateProductsNotInB2BCategoriesReport.php',
            data: {'customer':customer,'userSpecific':userSpecific,'filterProductStatus':filterProductStatus},

            success: function (result) {
                $('#reportResult').html(result);
                $('#inputResult').val(result);
                $('#xlsForm').attr('action','//<?php echo HTML_PATH ?>/cop/backend/core/templates/pdf/generatePDFFromHTML.php').submit();
            }
        });


    }

    function backToReports() {
        try {
            $(".swLinkMenu")[0].click();
        }
        catch(err)
        {

        }

        setTimeout(function() {
            window.history.back();
        }, 1000);


    }

</script>


