<?php

if (!isset($_SESSION['adminID'])) {
    redirect("../../../login.php");
}

function redirect($url)
{
    if (headers_sent()) {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    } else {
        header('Location: ' . $url);
        die();
    }
}

?>
<div id="main" role="main" class="background-color-whitish">
    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh"
                          rel="tooltip" data-placement="bottom"
                          data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?"
                          data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / B2B Promo Page / Coupons</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->
    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-10">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-info-circle"></i>
                    B2B Coupons
            </div>
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-2">
		        <span class="pull-right show-stat-buttons">
                   <span>
                       <a href="new_promotion_coupon.php" class="btn btn-primary btn-block"><i class="fa fa-plus"></i>&nbsp; Add Coupons</a>
                   </span>
	            </span>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="">
            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false"
                         data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                            <h2>Promotion Coupons</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">

                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTable"
                                       width="100%">
                                    <thead>
                                    <tr>
                                        <th class="hasinput" >
                                            <input type="text" class="form-control text-center" placeholder="Filter Coupon" />
                                        </th>
                                        <th class="hasinput">
                                            <input id="dateselect_filter1" type="text" placeholder="Filter Date" class="form-control datepicker text-center" data-dateformat="yy-mm-dd">
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Promo" />
                                        </th>
                                        <th class="hasinput">
                                            <select id="selectTypeFilter"  class="form-control text-center" style="width: 100%">
                                                <option value="">All Types</option>
                                                <option value="4">One Time Percentage Discount</option>
                                                <option value="5">One Time Price Discount</option>
                                                <option value="6">One Time Per User Percentage Discount</option>
                                                <option value="7">One Time Per User Price Discount</option>
                                                <option value="9">Competition</option>
                                                <option value="6666">Percentage Discount Claim</option>
                                                <option value="7777">Price Discount Claim</option>
                                                <option value="9999">Competition Entry</option>
                                            </select>
                                            <input type="text" class="form-control text-center" id="inputTypeFilter" style="display: none;" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter amount" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter percent" />
                                        </th>
                                        <th class="hasinput">
                                            <input id="dateselect_filter2" type="text" placeholder="Filter From" class="form-control datepicker text-center" data-dateformat="yy-mm-dd">

                                        </th>
                                        <th class="hasinput">
                                            <input id="dateselect_filter3" type="text" placeholder="Filter Until" class="form-control datepicker text-center" data-dateformat="yy-mm-dd">

                                        </th>
                                        <th class="hasinput">
                                            <select id="selectStatusFilter"  class="form-control text-center" style="width: 100%">
                                                <option value="">All Statuses</option>
                                                <option value="no">Used & Inactive</option>
                                                <option value="yes">Available & Claimed</option>
                                            </select>
                                            <input type="text" class="form-control text-center" id="inputStatusFilter" style="display: none;" />
                                        </th>
                                        <th class="hasinput">
                                        </th>
                                    </tr>
                                    <tr>
                                        <th class='text-center'>Coupon Code</th>
                                        <th class='text-center'>Coupon Date</th>
                                        <th class='text-center'>Promotion Name</th>
                                        <th class='text-center'>Type</th>
                                        <th class='text-center'>Discount Amount</th>
                                        <th class='text-center'>Discount Percentage</th>
                                        <th class='text-center'>Valid From</th>
                                        <th class='text-center'>Valid Until</th>
                                        <th class='text-center'>Status</th>
                                        <th class='text-center'>Actions</th>
                                    </tr>
                                    </thead>

                                </table>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->

                </article>
                <!-- WIDGET END -->

            </div>

            <!-- end row -->

        </section>
    </div>


</div>


<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="js/plugin/select2/select2.min.js"></script>

<script type="text/javascript">

    function disableCoupon(id,status){
        $.ajax({
            type: 'POST',
            url: './concc/disableCoupon.php',
            dataType: 'html',
            data: {'promotionID': id,'status': status},
            success: function (result) {

                $.smallBox({
                    title: 'Success!',
                    content: "Coupons successfully Changed",
                    color: "#739E73",
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
                $('#datatable_fixed_column').DataTable().ajax.reload(null,false);
            }
        });
    }

    $(document).ready(function () {

        pageSetUp();

        $('#selectTypeFilter').on('change', function() {
            $('#inputTypeFilter').val($('#selectTypeFilter').val()).trigger('change');
        });

        $('#selectTypeFilter').select2();

        $('#selectStatusFilter').on('change', function() {
            $('#inputStatusFilter').val($('#selectStatusFilter').val()).trigger('change');
        });

        $('#selectStatusFilter').select2();

        var responsiveHelper_datatable_fixed_column = undefined;

        var breakpointDefinition = {
            tablet: 1024,
            phone: 480
        };

        /* COLUMN FILTER  */
        var otable = $('#datatable_fixed_column').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "processing": false,
            "serverSide": true,
            "lengthMenu": [ [10, 25, 50, 100, 250, 500, -1], [10, 25, 50, 100, 250, 500, "All"] ],
            "pageLength": 10,
            "order": [[ 2, "desc" ],[ 0, "asc" ],[ 1, "desc" ]],
            "ajax": "./concc/getAllPromotionCoupons.php",
            "columns": [
                {"data": "code"},
                {"data": "timestamp"},
                {"data": "name"},
                {"data": "type"},
                {"data": "amount"},
                {"data": "percent"},
                {"data": "from"},
                {"data": "until"},
                {"data": "status"},
                {"data": "form"}
            ],
            "deferRender": true,
            "autoWidth": true,
            "oTableTools": {
                "aButtons": [
                    "copy",
                    "csv",
                    "xls",
                    {
                        "sExtends": "pdf",
                        "sTitle": "Coprime PDF",
                        "sPdfMessage": "Coprime PDF Export",
                        "sPdfSize": "letter"
                    },
                    {
                        "sExtends": "print",
                        "sMessage": "Generated by Coprime<i>(press Esc to close)</i>"
                    }
                ],
                "sSwfPath": "js/plugin/datatables/swf/copy_csv_xls_pdf.swf"
            },
            "preDrawCallback": function () {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
            "rowCallback": function (nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback": function (oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }
        });

        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on('keyup change', function () {

            otable
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();
        });
        /* END COLUMN FILTER */




    })

</script>

