<?php

if (!isset($_SESSION['adminID'])) {
    redirect("../../../login.php");
}

function redirect($url)
{
    if (headers_sent()) {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    } else {
        header('Location: ' . $url);
        die();
    }
}

?>
<div id="main" role="main" class="background-color-whitish">
    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh"
                          rel="tooltip" data-placement="bottom"
                          data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?"
                          data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / B2B Promo Page</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->
    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-4 col-md-4 col-lg-8">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-info-circle"></i>
                    B2B Promo Page
            </div>
            <div class="col-xs-12 col-sm-4 col-md-4 col-lg-2">
		        <span class="pull-right show-stat-buttons">
                   <span>
                       <a href="promotion_coupons.php" class="btn btn-invoice btn-block" target="_blank"><i class="fa fa-star"></i>&nbsp; Manage Coupons</a>
                   </span>
	            </span>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-4 col-lg-2">
		        <span class="pull-right show-stat-buttons">
                   <span>
                       <a href="edit_promo_section.php" class="btn btn-primary btn-block"><i class="fa fa-plus"></i>&nbsp; New Section</a>
                   </span>
	            </span>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="">
            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false"
                         data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                            <h2>Promo Page Settings</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">

                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTable"
                                       width="100%">
                                    <thead>
                                    <tr>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center"
                                                   placeholder="Filter Code"/>
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center"
                                                   placeholder="Filter Section"/>
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center"
                                                   placeholder="Filter Title"/>
                                        </th>
<!--                                        <th class="hasinput">-->
<!--                                            <input type="text" class="form-control text-center"-->
<!--                                                   placeholder="Filter Text"/>-->
<!--                                        </th>-->
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center"
                                                   placeholder="Filter Function"/>
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center"
                                                   placeholder="Filter Link"/>
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center"
                                                   placeholder="Filter height"/>
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center"
                                                   placeholder="Filter width"/>
                                        </th>
                                        <th class="hasinput">
                                        </th>
                                        <th class="hasinput">
                                        </th>
                                        <th class="hasinput" style="width: 8%">
                                        </th>
                                        <th class="hasinput" style="width: 8%">
                                        </th>
                                        <th class="hasinput" style="width: 8%">
                                        </th>
                                    </tr>
                                    <tr>
                                        <th class='text-center'>URL Code</th>
                                        <th class='text-center'>Section</th>
                                        <th class='text-center'>Title</th>
<!--                                        <th class='text-center'>Text</th>-->
                                        <th class='text-center'>Function</th>
                                        <th class='text-center'>Link</th>
                                        <th class='text-center'>Height</th>
                                        <th class='text-center'>Width</th>
                                        <th class='text-center'>Image</th>
                                        <th class='text-center'>Position</th>
                                        <th class='text-center'>Valid From</th>
                                        <th class='text-center'>Valid Until</th>
                                        <th class='text-center'>Actions</th>
                                    </tr>
                                    </thead>

                                </table>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->

                </article>
                <!-- WIDGET END -->

            </div>

            <!-- end row -->

        </section>

        <!-- Modal -->
        <div class="modal fade" id="competitionModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
            <div class="modal-dialog" style="width: 100%">
                <div class="modal-content" >
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    </div>

                    <div class="modal-body" style="margin-top:5px;padding-top:5px;font-size: 16px;" id="competitionModalMain">

                    </div>

                    <footer class="modal-footer" >
                        <button onclick="$('#competitionModal').modal('toggle');" class="btn btn-default" type="button" style="margin-right:10px;">Close</button>
                    </footer>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->
    </div>


</div>


<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="js/plugin/select2/select2.min.js"></script>

<script type="text/javascript">

    function viewCompetitionPromo(competitionID){
        $('#competitionModalMain').html('<center><h3>Processing...</h3></center>');
        $('#competitionModal').modal('toggle');
        $.ajax({
            type: 'POST',
            url: './concc/getPromotionCompetitionContestants.php',
            data: { 'competitionID': competitionID},
            success: function (result) {
                $('#competitionModalMain').html(result);
            }
        });
    }

    function activateButtonClicked(featuredID)
    {
        $.ajax({
            type: "POST",
            url: './concc/change_promo_image_status.php',
            data: {
                'featuredID': featuredID,
                'active':"yes"
            },

            success: function (result) {

                $('#b'+featuredID).text('Hide');
                $('#b'+featuredID).removeClass('btn-success');
                $('#b'+featuredID).addClass('btn-danger');
                $('#b'+featuredID).prop("onclick", null).unbind('click');
                $('#b'+featuredID).click(function()
                {
                    deactivateButtonClicked(featuredID);
                });
            }

        });
    }

    function deactivateButtonClicked(featuredID)
    {
        $.ajax({
            type: "POST",
            url: './concc/change_promo_image_status.php',
            data: {
                'featuredID':featuredID,
                'active':"no"
            },
            success: function (result) {

                $('#b'+featuredID).text('Show');
                $('#b'+featuredID).removeClass('btn-danger');
                $('#b'+featuredID).addClass('btn-success');
                $('#b'+featuredID).prop("onclick", null).unbind('click');
                $('#b'+featuredID).click(function()
                {
                    activateButtonClicked(featuredID);
                });
            }
        });
    }


    $(document).ready(function () {

        pageSetUp();

        var responsiveHelper_datatable_fixed_column = undefined;

        var breakpointDefinition = {
            tablet: 1024,
            phone: 480
        };

        /* COLUMN FILTER  */
        var otable = $('#datatable_fixed_column').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "processing": false,
            "serverSide": true,
            "ajax": "./concc/getAllPromotionPage.php",
            "columns": [
                {"data": "code"},
                {"data": "slider"},
                {"data": "title"},
                // {"data": "text"},
                {"data": "iframe"},
                {"data": "link"},
                {"data": "height"},
                {"data": "width"},
                {"data": "image"},
                {"data": "position"},
                {"data": "valid_from"},
                {"data": "valid_until"},
                {"data": "form"}

            ],
            "order": [[ 0, "asc" ],[ 1, "asc" ],[ 7, "asc" ]],
            "deferRender": true,
            "autoWidth": true,
            "oTableTools": {
                "aButtons": [
                    "copy",
                    "csv",
                    "xls",
                    {
                        "sExtends": "pdf",
                        "sTitle": "Coprime PDF",
                        "sPdfMessage": "Coprime PDF Export",
                        "sPdfSize": "letter"
                    },
                    {
                        "sExtends": "print",
                        "sMessage": "Generated by Coprime<i>(press Esc to close)</i>"
                    }
                ],
                "sSwfPath": "js/plugin/datatables/swf/copy_csv_xls_pdf.swf"
            },
            "preDrawCallback": function () {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
            "rowCallback": function (nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback": function (oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }
        });

        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on('keyup change', function () {

            otable
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();
        });
        /* END COLUMN FILTER */




    })

</script>

