<?php
include_once("../../../param.php");
require("./concc/dbinfo.php");
require("./concc/dbhelper.php");


if(!isset($_SESSION['adminID']) ) {
    redirect("../../../login.php");
}


global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$itemSelection = '';
$stm = $db->prepare("SELECT item_id, item_code, name  FROM Items  ORDER BY item_code");
$stm-> execute();
$stm-> bind_result($itemID, $itemCode, $itemName);
while ($stm->fetch()) {
    $itemSelection .= "<option value='$itemID'>$itemCode - $itemName </option>";
}

$stm->close();


$stm = $db->prepare("SELECT long_description FROM Items  ORDER BY item_code LIMIT 1");
$stm-> execute();
$stm-> bind_result($itemDescription);
while ($stm->fetch()) {
}
$stm->close();

function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}




?>
<div id="main" role="main">

    <!-- Start CUSTOM CODE-->
    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

        <span class="ribbon-button-alignment">
            <span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
                <i class="fa fa-refresh"></i>
            </span>
        </span>
        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / B2B Product Description</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->



    <!-- MAIN CONTENT -->
    <article id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-8 col-lg-10">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-info-circle"></i>
                    Product Long Description
                </h3>
            </div>

            <div class="col-xs-12 col-sm-4 col-md-4 col-lg-2">
                <span class="pull-right show-stat-buttons">
                    <button id="saveButton" onclick="saveDescription()" class="btn btn-success btn-block">
                        <i class="fa fa-check"></i>&nbsp; Save Description
                    </button>
                </span>
            </div>
        </div>
    </article>

        <!-- NEW WIDGET START -->
        <section id="widget-grid" class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <!-- row -->
            <div class="row">

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Product Form</h2>
                        </header>
                        <div>
                            <div class="widget-body" style="overflow-x:scroll">

                                <label style="display: block; margin-top: 10px"><b>Select Product:</b></label>
                                <select name="itemSelection" id="itemSelection" class="form-control text-center" style="width: 40%;">
                                    <?php echo $itemSelection; ?>
                                </select>
                            </div>

                        </div>
                    </div>
                </article>

<article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-0" data-widget-togglebutton="false" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2>Edit Product Description</h2>
                    </header>
                    <div>
                        <!-- widget content -->
                        <div class="widget-body no-padding">
                    <form method="post">
                        <section>
                            <textarea id="summernote" name="editordata"><?php echo $itemDescription; ?></textarea>
                        </section>
                    </form>

                </div>
                    </div>
                </div>
</article>
            </div>
        </section>
</div>





<script type="text/javascript">


    function saveDescription()
    {
        var markupStr = $('#summernote').summernote('code');
        var itemID = $('#itemSelection').val();

        $.ajax({
            type: "POST",
            url: './concc/edit_product_long_description.php',
            data: {
                'markupStr':markupStr,
                'itemID':itemID
            },

            success: function (result) {
                //do somthing here
                $.smallBox({
                    title : "Success!",
                    content : "Description successfully saved",
                    color : "#739E73",
                    timeout: 3000,
                    icon : "fa fa-gift swing animated"
                });
            }
        });
    }

    $(document).ready(function() {

        pageSetUp();
        $('#itemSelection').select2({
            minimumInputLength: 3
        });

        setTimeout(function() {
            $(".note-btn[data-original-title='Table']").remove();
            $(".note-btn[data-original-title='Picture']").remove();
            $(".note-btn[data-original-title='Code View']").remove();

        }, 300);

        $('#summernote').summernote({
            callbacks: {
                onImageUpload: function(files) {
                    for(let i=0; i < files.length; i++) {
                        $.upload(files[i]);
                    }
                }
            },
            height: 550,                 // set editor height
            minHeight: 550,             // set minimum height of editor
            maxHeight: null,            // set maximum height of editor
            focus: true                // set focus to editable area after initializing summernote

        });

        $.upload = function (file) {
            let out = new FormData();
            out.append('file', file, file.name);

            $.ajax({
                method: 'POST',
                url: 'summernoteImageUpload.php',
                contentType: false,
                cache: false,
                processData: false,
                data: out,
                success: function (img) {
                    $('#summernote').summernote('insertImage', img);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.error(textStatus + " " + errorThrown);
                }
            });
        };

        $("#itemSelection").on("change", function () {
            var itemID = $('#itemSelection').val();

            if (itemID !== "" &&  itemID !== 0 && itemID!=null) {
                $.ajax({
                    type: "GET",
                    url: './concc/getProductLongDescription.php',
                    data: {
                        'itemID':itemID
                    },
                    success: function (result) {
                        $('#summernote').summernote('code', result);

                    }
                });
            }

        });
        


       
    });



</script>


<script src="js/notification/SmartNotification.min.js"></script>
<link rel="stylesheet" href="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.css">
<script type="text/javascript" src="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.js"></script>



