<?php
include_once("../../../param.php");
if (!isset($_SESSION['adminID'])) {
    redirect("../../../login.php");
}

function redirect($url)
{
    if (headers_sent()) {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    } else {
        header('Location: ' . $url);
        die();
    }
}

?>
<div id="main" role="main" class="background-color-whitish">
    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh"
                          rel="tooltip" data-placement="bottom"
                          data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?"
                          data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / B2B Grid Menu</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->
    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-10">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-info-circle"></i>
                    B2B Grid Menu
            </div>
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-2">
		        <span class="pull-right show-stat-buttons">
                   <span>
                       <a href="edit_grid_menu.php" class="btn btn-primary btn-block"><i class="fa fa-plus"></i>&nbsp; Create Menu Item</a>
                   </span>
	            </span>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="">
            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false"
                         data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                            <h2>Grid Menu Settings</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">

                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTable"
                                       width="100%">
                                    <thead>
                                    <tr>
                                        <th class="hasinput">
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center"
                                                   placeholder="Filter Title"/>
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center"
                                                   placeholder="Filter Parent"/>
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center"
                                                   placeholder="Filter Link"/>
                                        </th>
                                        <th class="hasinput">
                                        </th>
                                        <th class="hasinput">
                                        </th>
                                        <th class="hasinput">
                                        </th>
                                        <th class="hasinput">
                                        </th>
                                        <th class="hasinput">
                                        </th>
                                    </tr>
                                    <tr>
                                        <th class='text-center'>Icon</th>
                                        <th class='text-center'>Title</th>
                                        <th class='text-center'>Parent</th>
                                        <th class='text-center'>URL Link</th>
                                        <th class='text-center'>Position</th>
                                        <th class='text-center'>Outer Class</th>
                                        <th class='text-center'>Inner Class</th>
                                        <th class='text-center'>Hover Text</th>
                                        <th class='text-center'>Actions</th>

                                    </tr>
                                    </thead>

                                </table>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->

                </article>
                <!-- WIDGET END -->

            </div>

            <!-- end row -->

        </section>
    </div>


</div>


<script src="js/plugin/datatables/jquery.dataTables.min.js"></script>
<script src="js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="js/plugin/select2/select2.min.js"></script>

<script type="text/javascript">


    $(document).ready(function () {

        pageSetUp();

        $('.summernote').summernote({
        });

        var responsiveHelper_datatable_fixed_column = undefined;

        var breakpointDefinition = {
            tablet: 1024,
            phone: 480
        };

        /* COLUMN FILTER  */
        var otable = $('#datatable_fixed_column').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' T C l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "processing": false,
            "serverSide": true,
            "ajax": "./concc/getAllGridMenu.php",
            "columns": [
                {"data": "icon"},
                {"data": "title"},
                {"data": "parent"},
                {"data": "url"},
                {"data": "position"},
                {"data": "classOuter"},
                {"data": "classInner"},
                {"data": "hoverText"},
                {"data": "form"}

            ],
            "deferRender": true,
            "autoWidth": true,
            "oTableTools": {
                "aButtons": [
                    "copy",
                    "csv",
                    "xls",
                    {
                        "sExtends": "pdf",
                        "sTitle": "Coprime PDF",
                        "sPdfMessage": "Coprime PDF Export",
                        "sPdfSize": "letter"
                    },
                    {
                        "sExtends": "print",
                        "sMessage": "Generated by Coprime<i>(press Esc to close)</i>"
                    }
                ],
                "sSwfPath": "js/plugin/datatables/swf/copy_csv_xls_pdf.swf"
            },
            "preDrawCallback": function () {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
            "rowCallback": function (nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback": function (oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }
        });

        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on('keyup change', function () {

            otable
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();
        });
        /* END COLUMN FILTER */




    })

</script>
<!-- include summernote css/js -->
<link rel="stylesheet" href="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.css">
<script type="text/javascript" src="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.js"></script>
