<?php
require("./concc/dbinfo.php");
if(!isset($_SESSION['adminID']) ) {
    redirect("../../../login.php");
}



function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

function endsWith($haystack, $needle)
{
    $length = strlen($needle);
    if ($length == 0) {
        return true;
    }

    return (substr($haystack, -$length) === $needle);
}


if(isset($_POST['range_id'])){

    $isEdit      = true;
    $rangeID     = trim($_POST['range_id']);
    $pageStatus  = 'Edit';
    $postURL     = 'edit_promotion_range_post.php';

    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT b2b_category_promotion_id, from_amount, to_amount, days FROM B2B_Categories_Promotions_Ranges WHERE b2b_category_promotion_value_id='$rangeID'");
    $stm-> execute();
    $stm-> bind_result($promotionID,$from,$to,$days);
    while ($stm->fetch()) {}
    $stm-> close();


    $deleteButton = '<button id="deleteRange" class="btn btn-danger" onclick="deleteRange()" style="font-weight:400;font-size:15px;margin-top:30px;float:left;margin-left:1px;width:150px;" >Delete Range</button>';

} else {
    $promotionID = trim($_GET['id']);
    $rangeID     = trim($_POST['range_id']);
    $isEdit      = false;
    $pageStatus  = 'New';
    $postURL     = 'add_promotion_range_post.php';
}
?>

<div id="main" role="main">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white"> Home / B2B Edit Promotion / <?php echo $pageStatus?> Range</li>
        </ol>
        <!-- end breadcrumb -->


    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">
        <!-- row -->
        <div class="row">
            <article class="col-xs-12 col-sm-12 col-md-12 col-lg-6">
                <!-- new widget -->
                <div class="jarviswidget" id="wid-id-0" data-widget-togglebutton="false" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2><?php echo $pageStatus?> Range</h2>
                    </header>

                    <div class="widget-body">

                        <div class="row">

                            <div class="col-sm-12">

                                <form id="pageForm" method="post" class="smart-form" enctype="multipart/form-data">

                                    <fieldset style="padding-top:0px">
                                        <section>
                                            <h2 style="font-weight:bold;"></h2>
                                        </section>
                                        <div class="row">

                                            <section class="col-sm-11">
                                                <section>
                                                    <label class="label-bold align-left">Amount From </label>
                                                    <input type="text" class="form-control"  id="from" value="<?php echo $from?>" />
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Amount To </label>
                                                    <input type="text" class="form-control"  id="to" value="<?php echo $to?>"/>
                                                </section>
                                                <section>
                                                    <label class="label-bold  align-left">Days </label>
                                                    <input type="text" class="form-control"  id="days" value="<?php echo $days?>"/>
                                                </section>
                                                <section>
                                                    <input type="hidden" class="form-control" id="pageID" value="<?php echo $rangeID?>"/>
                                                </section>
                                            </section>

                                        </div>
                                    </fieldset>
                                </form>


                                <footer>
                                    <input type="button" id="PostSubmit" class="btn btn-primary"  style="font-weight:400;font-size:15px;margin-top:30px;float:right;margin-right:10px;width:150px;" value="Submit Range" onclick="savePost()">
                                    <?php echo $deleteButton ?>
                                </footer>

                            </div>

                        </div>

                    </div>
                    <!-- end widget div -->
                </div>
                <!-- end widget -->
            </article>

        </div>
        <!-- end row -->
    </div>






</div>





<script type="text/javascript">

    function deleteRange(){
        var rangeID  = '<?php echo $rangeID;?>';

        if(rangeID.length > 0) {

            $.ajax({
                type: 'POST',
                url: './concc/remove_promotion_range.php',
                dataType: 'html',
                data: {
                    'rangeID': rangeID


                },
                success: function (result) {
                    $('#from').val('');
                    $('#from').trigger('change');
                    $('#to').val('');
                    $('#to').trigger('change');
                    $('#days').val('');
                    $('#days').trigger('change');
                    $.smallBox({
                        title: 'Range Deleted!',
                        content: "Range successfully Deleted",
                        color: "#B22222",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                    setTimeout(function(){window.location.assign('promotion_ranges.php?id=<?php echo $promotionID;?>');}, 1000);
                }
            });
        }

    }

    function savePost() {

        var promotionID = '<?php echo $promotionID;?>';
        var rangeID     = '<?php echo $rangeID;?>';
        var from        = $('#from').val();
        var to          = $('#to').val();
        var days        = $('#days').val();

        if(promotionID.length > 0) {

            $.ajax({
                type: 'POST',
                url: './concc/<?php echo $postURL?>',
                dataType: 'html',
                data: {
                    'promotionID': promotionID,
                    'rangeID': rangeID,
                    'from': from,
                    'to': to,
                    'days': days


                },
                success: function (result) {

                    $('#from').val('');
                    $('#from').trigger('change');
                    $('#to').val('');
                    $('#to').trigger('change');
                    $('#days').val('');
                    $('#days').trigger('change');

                    $.smallBox({
                        title: 'Success!',
                        content: "Range successfully entered",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                  setTimeout(function(){window.location.assign('promotion_ranges.php?id=<?php echo $promotionID;?>');}, 1000);
                }
            });
        }

    }

    // End of SavePost()

    $(document).ready(function() {

        pageSetUp();


    })
</script>

<script src="js/plugin/select2/select2.min.js"></script>



?>