<?php
session_start();
if (!isset($_SESSION['adminID'])) {
    redirect("../../../login.php");
}

function redirect($url)
{
    if (headers_sent()) {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    } else {
        header('Location: ' . $url);
        die();
    }
}


if(isset($_GET['id'])){

    $userFirstName = trim($_GET['fn']);
    $userLastName  = trim($_GET['ln']);
    $userID        = trim($_GET['id']);
    $customerID    = trim($_GET['cid']);
    $edit = true;

    require("./concc/dbinfo.php");
    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT customer_id, username, identifier, email, first_name, last_name, mobile, show_stock, show_prices,show_promo,B2C_User  FROM B2B_User WHERE b2b_user_id=".$userID);
    $stm->execute();
    $stm->bind_result( $customerID, $userName, $identifier, $userEmail, $userFirstName, $userLastName, $mobile, $showStock, $showPrices, $showPromotions,$B2CUser );
    while ($stm->fetch()) {}
    $stm->close();

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT COUNT(category_id) FROM B2B_Allow_Categories_User WHERE b2b_user_id=".$userID);
    $stm->execute();
    $stm->bind_result($access);
    while ($stm->fetch()) {}
    $stm->close();

    if(strcmp($B2CUser,'yes')==0){
        $isB2C = true;
        $identifier = '_____________';
        $disabledFields = ' style="border-color:transparent;" disabled readonly';
    } else {
        $isB2C = false;
        $disabledFields = '';
    }

    if($access == 0) {
        $access = 'All ';
    }

    if($userEmail==null)
    {
        $userEmail="";
    }
    if(strcmp($showStock,'yes') == 0 ){
        $stockSelected = 'selected';
    }
    if(strcmp($showPrices,'yes') == 0 ){
        $pricesSelected = 'selected';
    }
    if(strcmp($showPromotions,'yes') == 0 ){
        $showPromotionsSelected = 'selected';
    }

} else {
    $edit = false;
    $customerID = $_GET['cid'];
}



?>
<div id="main" role="main" class="background-color-whitish">
    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh"
                          rel="tooltip" data-placement="bottom"
                          data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?"
                          data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / <?php if($edit){echo 'Edit';}else{ echo 'New';}?> <?php if($isB2C){echo 'B2C';}else{ echo 'B2B';}?> User </li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->
    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-10 col-sm-6 col-md-6 col-lg-10">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-info-circle"></i>
                    <?php if($edit){echo 'Edit';}else{ echo 'New';}?> <?php if($isB2C){echo 'B2C';}else{ echo 'B2B';}?> User <br>

            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
            		<span class="pull-right show-stat-buttons">
                        <span >
                            <a target="_blank" class="btn btn-success btn-block" id="saveB2BUsers"><i class="fa fa-check"></i>&nbsp; Save Changes</a>
                        </span>
                    </span>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="">
            <!-- row -->
            <div class="row">

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-0" data-widget-editbutton="false"
                         data-widget-deletebutton="false" >
                        <header>
                            <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                            <h2>User Info</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">
                                <form method="post" action="" id="userInfoForm" class="smart-form">
                                    <input  id='customerID' name='customerID' type='hidden' value="<?php echo $customerID?>">
                                    <input  id='userID' name='userID' type='hidden' value="<?php echo $userID?>">
                                <fieldset>
                                    <div class="row">
                                        <section class="col col-4 no-margin" style="padding-right:2px;">
                                            <section>
                                                <img style="display:inline;width:30px;height:30px;" class="" src="./img/customerdefault.jpg" width="25" height="25">
                                                <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Login Details</h3>
                                                <div style="color: firebrick; text-align: center; " id="error"></div>
                                            </section>
                                            <table id="detailsTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0">
                                                <thead >
                                                </thead>
                                                <tbody>
                                                <tr>
                                                    <td class="custom-td-label"><label class="label-bold lalign">Username: </label></td>
                                                    <td class="custom-td-input"><input class='text-center form-control slim-input' id='username' name='username' type='text' value="<?php echo $userName?>" <?php echo $disabledFields?>></td>
                                                </tr>
                                                <tr>
                                                    <td class="custom-td-label"><label class="label-bold lalign" >Password: </label></td>
                                                    <td class="custom-td-input"><input type="text"  class="form-control text-center slim-input" name="identifier" id="identifier" value="<?php echo $identifier?>" <?php echo $disabledFields?>>
                                                    </td>
                                                </tr>
                                                <tr >
                                                <tr >
                                                    <td class="custom-td-input" colspan="2"><label class="label-bold lalign" style="font-size: 19px;">&nbsp;</label></td>
                                                </tr>
                                                <tr >
                                                    <td colspan="2" style="border-color: transparent;">
                                                        <a  data-toggle='modal' data-target='#deleteModal' id='$customerAddressID'>
                                                            <button type="button" class="btn btn-danger pull-left" style="height: 30px; width: 100px;margin-left: -15px;<?php if(!$edit){echo 'display: none;';}?>">Delete User</button>
                                                        </a>
                                                    </td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </section>
                                        <section class="col col-4 no-margin" style="padding-right:2px;">
                                            <section>
                                                <img style="display:inline;width:30px;height:30px;" class="" src="./img/infoicon.png" width="25" height="25">
                                                <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Additional User Details</h3>
                                                <div style="color: firebrick; text-align: center; " id="error2"></div>
                                            </section>
                                            <table id="detailsTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0">
                                                <thead >
                                                </thead>
                                                <tbody>
                                                <tr >
                                                    <td class="custom-td-label"><label class="label-bold lalign">First Name: </label></td>
                                                    <td  class="custom-td-input"><input  type="text"  class="form-control text-center slim-input" name="firstName" id="firstName" value="<?php echo $userFirstName?>" <?php echo $disabledFields?>>
                                                    </td>
                                                </tr>
                                                <tr >
                                                    <td class="custom-td-label"><label class="label-bold  lalign" >Last Name: </label></td>
                                                    <td class="custom-td-input"><input type="text"  class="form-control text-center slim-input" name="lastName" id="lastName" value="<?php echo $userLastName?>" <?php echo $disabledFields?>></td>
                                                </tr>
                                                <tr >
                                                    <td class="custom-td-label"><label class="label-bold  lalign" >Mobile: </label></td>
                                                    <td class="custom-td-input"><input type="text"  class="form-control text-center slim-input" name="mobile" id="mobile" value="<?php echo $mobile?>" <?php echo $disabledFields?>></td>
                                                </tr>
                                                <tr >
                                                    <td class="custom-td-label"><label class="label-bold  lalign" >Email: </label></td>
                                                    <td class="custom-td-input"><input type="text"  class="form-control text-center slim-input" name="email" id="email"  value="<?php echo $userEmail?>" <?php echo $disabledFields?>></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </section>
                                        <section class="col col-4 no-margin" style="padding-right:2px;">
                                            <section>
                                                <img style="display:inline;width:30px;height:30px;" class="" src="./img/usericon1.png" width="25" height="25">
                                                <h3 style="display: inline;margin-left:6px;vertical-align: middle">User Access</h3>
                                            </section>
                                                <table id="detailsTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0">
                                                    <thead >
                                                    </thead>
                                                    <tbody>
                                                    <tr >
                                                        <td class="custom-td-label"><label class="label-bold  lalign" >Show Stock: </label></td>
                                                        <td class="custom-td-input"><select  class="form-control text-center slim-input" name="showStock" id="showStock" >
                                                                <option value="">No</option>
                                                                <option value="yes"<?php echo $stockSelected?>>Yes</option>
                                                            </select></td>
                                                    </tr>
                                                    <tr >
                                                        <td class="custom-td-label"><label class="label-bold  lalign" >Show Prices: </label></td>
                                                        <td class="custom-td-input"><select  class="form-control text-center slim-input" name="showPrices" id="showPrices" >
                                                                <option value="">No</option>
                                                                <option value="yes"<?php echo $pricesSelected?>>Yes</option>
                                                            </select></td>
                                                    </tr>
                                                    <tr >
                                                        <td class="custom-td-label"><label class="label-bold  lalign" >Show Promotion Categories: </label></td>
                                                        <td class="custom-td-input"><select  class="form-control text-center slim-input" name="showPromotions" id="showPromotions" >
                                                                <option value="no">No</option>
                                                                <option value="yes"<?php echo $showPromotionsSelected?>>Yes</option>
                                                            </select></td>
                                                    </tr>
                                                    <tr >
                                                        <td class="custom-td-label"><label class="label-bold  lalign" > Category Access:</label></td>
                                                        <td class="custom-td-input">
                                                            <div  class="form-control text-center slim-input" style="text-align: center; <?php if(!$edit){echo 'display:none;';}?> ">
                                                                <h5 style="">Access to <span id="accessInfo"> <?php echo $access;?></span> Categories <i class="fa-fw fa fa-check"></i></h5>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                        </section>


                                </form>






                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->

                </article>
                <!-- WIDGET END -->

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false"
                         data-widget-deletebutton="false" >
                        <header <?php if(!$edit){echo 'style="display: none;"';}?>>
                            <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                            <h2>Category Access</h2>
                        </header>
                        <!-- widget div-->
                        <div <?php if(!$edit){echo 'style="display: none;"';}?>>
                            <!-- widget content -->
                            <div class="widget-body no-padding">

                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTable"
                                       width="100%">
                                    <thead>
                                    <tr>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center"
                                                   placeholder="Filter Code"/>
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center"
                                                   placeholder="Filter Name"/>
                                        </th>
                                        <th class="hasinput">
                                        </th>
                                        <th class="hasinput">
                                            <center>
                                                <button class="btn btn-danger" onclick="$('#clearCategoriesModal').modal('toggle');" >Clear User Access</button>
                                            </center>
                                        </th>

                                    </tr>
                                    <tr>
                                        <th class='text-center'>Code </th>
                                        <th class='text-center'>Category Name</th>
                                        <th class='text-center'>Description</th>
                                        <th class='text-center'>Actions</th>
                                    </tr>
                                    </thead>

                                </table>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->

                </article>
                <!-- WIDGET END -->

            </div>

            <!-- end row -->

        </section>
    </div>


</div>

<!-- Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document" >
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 style="color:black;" class="modal-title" id="myModalLabel">Delete User</h4>
            </div>
            <div class="modal-body">
            <h3>You are about to delete user
                <b>
                    <?php
                    if(strcmp($userFirstName,'') == 0 && strcmp($userFirstName,'') == 0){
                        echo " $userName";
                    }else{
                        echo " $userFirstName $userLastName";
                    }
                    ?>
                </b>.
            </h3>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="deleteUser()">Delete</button>
            </div>
        </div>
    </div>
</div>

<!--Modal-->
<div class="modal fade" id="clearCategoriesModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 style="color:black;" class="modal-title" id="clearModalLabel">Clear User Category Access</h4>
            </div>

            <div class="modal-body">
                <h3>
                You are About to Clear All Access to Categories for User.<br>
                Are you Sure you want to Continue?
                </h3>
            </div>

            <footer class="modal-footer">
                <button onclick="clearCategories();" class="btn btn-danger" type="button">Yes, Clear</button>
                <button onclick="$('#clearCategoriesModal').modal('hide');" class="btn btn-default" type="button" style="margin-right:10px;">Close</button>
            </footer>
        </div><!--/.modal-content-->
    </div><!--/.modal-dialog-->
</div><!--/.modal-->

<script src="js/plugin/datatables/jquery.dataTables.min.js"></script>
<script src="js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="js/plugin/select2/select2.min.js"></script>

<script type="text/javascript">

    function deleteUser() {

        var userID = $('#userID').val();
        var forDelete = 'delete';
        $.ajax({
            type: "POST",
            url: './concc/edit_b2b_user.php',
            data: {
                'userID':userID,
                'forDelete':forDelete
            },

            success: function (result) {
                //do somthing here
                $.smallBox({
                    title : "Success!",
                    content : "User successfully Deleted",
                    color : "#739E73",
                    timeout: 3000,
                    icon : "fa fa-user swing animated"
                });
                window.location.replace('edit_b2b_users.php?customer_id=<?php echo $customerID?>');
            }
        });
    }

    function clearCategories() {

        $('#clearCategoriesModal').modal('hide');

        var userID = $('#userID').val();

        $.ajax({
            type: "POST",
            url: './concc/clear_b2b_user_category_access.php',
            data: {
                'userID':userID
            },

            success: function (result) {

                $.smallBox({
                    title : "Success!",
                    content : "Category Access Cleared!",
                    color : "#739E73",
                    timeout: 3000,
                    icon : "fa fa-user swing animated"
                });

                $('#datatable_fixed_column').DataTable().ajax.reload();
                $('#accessInfo').text('All');
            }
        });
    }

    function saveUser() {
       var customerID = $('#customerID').val();
       var username = $('#username').val();
       var identifier = $('#identifier').val();
       var firstName = $('#firstName').val();
       var lastName = $('#lastName').val();
       var email = $('#email').val();
       var mobile = $('#mobile').val();
       var showStock = $('#showStock').val();
       var showPrices = $('#showPrices').val();
       var showPromotions = $('#showPromotions').val();
       var userID = $('#userID').val();
        if(username.localeCompare('') == 0 || identifier.localeCompare('') ==0 ){
            $.smallBox({
                title : "Failed!",
                content : "Fill required Data",
                color : "#b22222",
                timeout: 1000,
                icon : "fa fa-user swing animated"
            });
            highlightDataError($('#username'));
            highlightDataError($('#identifier'));
            highlightDataError($('#email'));
        } else {
            $.ajax({
                type: "POST",
                url: './concc/b2bUserValidation.php',
                data: {
                    'userID':userID,
                    'email': email,
                    'username': username
                },
                success: function (result) {
                    if(result == 0) {
                        $.ajax({
                            type: "POST",
                            url: './concc/edit_b2b_user.php',
                            data: {
                                <?php if (isset($_GET['b2bAccountRequest']) && (int)$_GET['b2bAccountRequest'] > 0) {
                                    echo "'b2bAccountRequest':'" . $_GET['b2bAccountRequest'] . "',";
                                } ?>
                                'customerID': customerID,
                                'userID': userID,
                                'username': username,
                                'identifier': identifier,
                                'firstName': firstName,
                                'lastName': lastName,
                                'email': email,
                                'mobile': mobile,
                                'showStock': showStock,
                                'showPromotions': showPromotions,
                                'showPrices': showPrices
                            },

                            success: function (result) {
                                //do somthing here
                                $.smallBox({
                                    title: "Success!",
                                    content: "User successfully saved",
                                    color: "#739E73",
                                    timeout: 3000,
                                    icon: "fa fa-user swing animated"
                                });

                                window.location.replace('edit_b2b_user_privileges.php' + result);
                            }
                        });
                    } else if(result == 1) {
                        $.smallBox({
                            title: "Error!",
                            content: "Username already Exists",
                            color: "#b22222",
                            timeout: 3000,
                            icon: "fa fa-user swing animated"
                        });
                        highlightDataError($('#username'));
                    } else if(result == 2) {
                        $.smallBox({
                            title: "Error!",
                            content: "Email already Exists",
                            color: "#b22222",
                            timeout: 3000,
                            icon: "fa fa-user swing animated"
                        });
                        highlightDataError($('#email'));
                    } else if(result == 3) {
                        $.smallBox({
                            title: "Failed!",
                            content: "Fill required Data",
                            color: "#b22222",
                            timeout: 3000,
                            icon: "fa fa-user swing animated"
                        });
                        highlightDataError($('#username'));
                        highlightDataError($('#identifier'));
                        highlightDataError($('#email'));
                    } else {
                        console.log(result)
                        $.smallBox({
                            title: "Error!",
                            content: "Please Try again.",
                            color: "#b22222",
                            timeout: 3000,
                            icon: "fa fa-user swing animated"
                        });
                    }
                }
            });
        }
    }

    function allowButtonClicked(categoryID)
    {

        $('#b'+categoryID).prop('disabled', true);
        var userID = '<?php echo $userID;?>' ;

        $.ajax({
            type: "POST",
            url: './concc/change_b2b_category_access.php',
            data: {
                'userID':userID,
                'categoryID':categoryID,
                'status':"A"
            },

            success: function (result) {

                $('#b'+categoryID).text('Deny Access');
                $('#b'+categoryID).removeClass('btn-success');
                $('#b'+categoryID).addClass('btn-danger');
                $('#b'+categoryID).prop("onclick", null).unbind('click');
                $('#b'+categoryID).bind('click',function()
                {
                    denyButtonClicked(categoryID);

                });
                $('#accessInfo').text(result);
                $('#b'+categoryID).prop('disabled', false);

            }

        });
    }

    function denyButtonClicked(categoryID)
    {
        $('#b'+categoryID).prop('disabled', true);
        var userID = '<?php echo $userID;?>';

        $.ajax({
            type: "POST",
            url: './concc/change_b2b_category_access.php',
            data: {
                'userID':userID,
                'categoryID':categoryID,
                'status':"D"
            },
            success: function (result) {

                $('#b'+categoryID).text('Allow Access');
                $('#b'+categoryID).removeClass('btn-danger');
                $('#b'+categoryID).addClass('btn-success');
                $('#b'+categoryID).prop("onclick", null).unbind('click');
                $('#b'+categoryID).bind( 'click', function()
                {
                    allowButtonClicked(categoryID);
                });
                $('#accessInfo').text(result);
                $('#b'+categoryID).prop('disabled', false);
            }
        });
    }

    function highlightDataError(element){
        element.css('border-color','firebrick').css('background-color','#ffd0bd');
        window.setTimeout(function(){element.css('border-color','').css('background-color','');
        },2500);
    }

    $(document).ready(function () {

        pageSetUp();


        $("#saveB2BUsers").click(function () { saveUser(); });

        $("#username").keyup(function(){
            var username   = $(this).val();
            var customerID = $('#customerID').val();
            var $this = $(this);


            $.ajax({
                type: "POST",
                url: './concc/b2b_username_validation.php',
                data: {
                    'username': username,
                    'customerID': customerID
                },
                success: function (result) {

                    if(result != 0){
                        $('#saveB2BUsers').attr("disabled", true);
                        $($this).css("border-color","firebrick");
                        $($this).css("color","firebrick");
                        $('#error').html('<i class="fa fa-star"></i> Username Exists. Please choose another.')
                    } else {
                        $('#saveB2BUsers').removeAttr("disabled");
                        $($this).css("border-color","");
                        $($this).css("color","");
                        $('#error').html("");

                    }
                }

            });

        });

        $("#email").keyup(function(){

            var email   = $(this).val();
            var userID = $('#userID').val();
            var $this = $(this);


            $.ajax({
                type: "POST",
                url: './concc/b2b_email_validation.php',
                data: {
                    'email': email,
                    'userID': userID
                },
                success: function (result) {

                    if(result != 0){
                        $('#saveB2BUsers').attr("disabled", true);
                        $($this).css("border-color","firebrick");
                        $($this).css("color","firebrick");
                        $('#error2').html('<i class="fa fa-star"></i> Email Exists. Please choose another. ')
                    } else {
                        $('#saveB2BUsers').removeAttr("disabled");
                        $($this).css("border-color","");
                        $($this).css("color","");
                        $('#error2').html("");

                    }
                }

            });

        });

        var responsiveHelper_datatable_fixed_column = undefined;

        var breakpointDefinition = {
            tablet: 1024,
            phone: 480
        };

        /* COLUMN FILTER  */
        var otable = $('#datatable_fixed_column').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' T C l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "processing": false,
            "serverSide": true,
            "ajax": "./concc/getAllCategories.php?uid=<?php echo $userID?>",
            "columns": [

                {"data": "code"},
                {"data": "name"},
                {"data": "description"},
                {"data": "form"}

            ],
            "deferRender": true,
            "autoWidth": true,
            "oTableTools": {
                "aButtons": [
                    "copy",
                    "csv",
                    "xls",
                    {
                        "sExtends": "pdf",
                        "sTitle": "Coprime PDF",
                        "sPdfMessage": "Coprime PDF Export",
                        "sPdfSize": "letter"
                    },
                    {
                        "sExtends": "print",
                        "sMessage": "Generated by Coprime<i>(press Esc to close)</i>"
                    }
                ],
                "sSwfPath": "js/plugin/datatables/swf/copy_csv_xls_pdf.swf"
            },
            "preDrawCallback": function () {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
            "rowCallback": function (nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback": function (oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }
        });

        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on('keyup change', function () {

            otable
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();
        });
        /* END COLUMN FILTER */


        <?php
        if(isset($_GET['b2bAccountRequest']) && (int)$_GET['b2bAccountRequest'] > 0) {
            $requestID = $_GET['b2bAccountRequest'];

            global $username,$password,$database;
            $db = new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db->set_charset("utf8");
            $stmt = $db->prepare("SELECT user_first_name,user_last_name,username,password,mobile,email FROM B2B_User_Account_Request WHERE request_id='$requestID' LIMIT 1");
            $stmt-> execute();
            $stmt-> bind_result($reqFirstNAme,$reqLastName,$reqUsername,$reqPassword,$reqMobile,$reqEmail);
            while ($stmt->fetch()) {
                echo "$('#username').val('$reqUsername');";
                echo "$('#identifier').val('$reqPassword');";
                echo "$('#firstName').val('$reqFirstNAme');";
                echo "$('#lastName').val('$reqLastName');";
                echo "$('#mobile').val('$reqMobile');";
                echo "$('#email').val('$reqEmail');";

            }
            $stmt->close();


        }

        ?>


    })

</script>

