<?php
require("./concc/dbinfo.php");
if(!isset($_SESSION['adminID']) ) {
    redirect("../../../login.php");
}



function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

function endsWith($haystack, $needle)
{
    $length = strlen($needle);
    if ($length == 0) {
        return true;
    }

    return (substr($haystack, -$length) === $needle);
}

$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT `lat`, 
                                  `lng`, 
                                  `address`, 
                                  `telephone`, 
                                  `fax`, 
                                  `email_left_sidebar`, 
                                  `contact_form_email`, 
                                  `facebook_link`, 
                                  `twitter_link`
                            FROM `B2B_Configuration` 
                            WHERE b2b_confuguration_id=1 LIMIT 1");
$stm->execute();
$stm->bind_result($lat, $lng, $address, $telephone, $fax, $sidebarEmail, $contactFormEmail,$facebook,$twitter);

while ($stm->fetch()) {}
$stm->close();

?>

<div id="main" role="main">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / B2B Contact Us</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <article id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-8 col-lg-10">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-info-circle"></i>
                    B2B Contact Us
                </h3>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-4 col-lg-2">
                    <span class="pull-right show-stat-buttons">
                        <span> <button id="saveButton" onclick="savePost()" class="btn btn-success btn-block" style=" margin-bottom:10px;">
                                <i class="fa fa-check"></i>&nbsp; Save Configuration</button>
                        </span>
                    </span>
            </div>
        </div>

        <!-- widget grid -->
        <section id="widget-grid" class="">
            <div class="row">

                <!-- widget map -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12" >
                    <div  class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-gears"></i> </span>
                            <h2>Set Company's Coordinates </h2>
                        </header>
                        <!-- widget div-->

                        <!-- widget content -->
                        <div class="" style="padding: 10px; 10px; 10px; 10px;" >
                            <div class="">
                                <section>
                                    <div class="row">
                                        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                                            <label class="label-bold align-left" style=" font-size: 25px; color:grey;">Drag Marker to set Company's Position </label>
                                            <section style="border-style: solid; border-color: lightgrey; border-radius: 25px;margin-bottom: 10px;" >
                                                <div class="google_maps" style='height:300px; width:100%;   border-radius: 25px;' id="map_coprime" ></div>
                                            </section>
                                            <section>
                                                <label class="label-bold align-left" style="font-size: 25px; color:grey; display: inline; width: 25%; position: relative; left: 10px;">Latitude: </label>
                                                <input type="text" class="form-control"  id="lat" value="<?php echo $lat?>" style=" display: inline;width: 90%; position: relative; left: 28px; " />
                                            </section>
                                            <section>
                                                <label class="label-bold align-left" style="font-size: 25px; color:grey; display: inline; width: 25%; position: relative; left: 10px;">Longitude: </label>
                                                <input type="text" class="form-control"  id="lng" value="<?php echo $lng?>" style="display: inline;  width: 90%; position: relative; left: 10px;" />
                                            </section>
                                        </div>
                                    </div>
                                </section>
                            </div>
                </article>

                <!-- widget contact info-->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12" >
                    <div  class="jarviswidget jarviswidget-color-blueDark" id="wid-id-2" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-gears"></i> </span>
                            <h2>Contact Info </h2>
                        </header>
                        <!-- widget div-->

                        <!-- widget content -->
                        <div class="" style="padding: 10px; 10px; 10px; 10px;" >
                            <div class="">
                                <section>
                                    <div class="row">
                                        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                                            <section>
                                                <label class="label-bold align-left" style="width: 95%; position: relative; left: 10px;">Company Address: </label>
                                                <input type="text" class="form-control"  id="address" value="<?php echo $address?>" style="width: 95%; position: relative; left: 10px;"/>
                                            </section>
                                            <section>
                                                <label class="label-bold align-left" style="width: 95%; position: relative; left: 10px;">Phone Number: </label>
                                                <input type="text" class="form-control"  id="telephone" value="<?php echo $telephone?>" style="width: 95%; position: relative; left: 10px;" />
                                            </section>
                                            <section>
                                                <label class="label-bold align-left" style="width: 95%; position: relative; left: 10px;">Fax Number: </label>
                                                <input type="text" class="form-control"  id="fax" value="<?php echo $fax?>" style="width: 95%; position: relative; left: 10px;" />
                                            </section>
                                            <section>
                                                <label class="label-bold align-left" style="width: 95%; position: relative; left: 10px;">Sidebar email: </label>
                                                <input type="text" class="form-control"  id="sidebarEmail" value="<?php echo $sidebarEmail?>" style="width: 95%; position: relative; left: 10px;"/>
                                            </section>
                                            <section>
                                                <label class="label-bold align-left" style="width: 95%; position: relative; left: 10px;">Contact Form email: </label>
                                                <input type="text" class="form-control"  id="contactFormEmail" value="<?php echo $contactFormEmail?>" style="width: 95%; position: relative; left: 10px;"/>
                                            </section>
                                        </div>
                                    </div>
                                </section>
                            </div>
                </article>

                <!-- widget contact Types-->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12" >
                    <div  class="jarviswidget jarviswidget-color-blueDark" id="wid-id-3" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-gears"></i> </span>
                            <h2>Contact Types (Departments)</h2>
                        </header>
                        <!-- widget div-->

                        <!-- widget content -->
                        <div class="" style="padding: 10px; 10px; 10px; 10px;" >
                            <div class="">
                                <section>
                                    <div class="row">
                                        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                                            <section>
                                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTable" width="100%" border="0" cellpadding="0" cellspacing="0">
                                                    <thead>
                                                    <tr>
                                                        <th class='text-center'></th>
                                                        <th class='text-center'>#</th>
                                                        <th class='text-center'>Contact Type</th>
                                                        <th class='text-center'>Contact Email</th>
                                                        <th class='text-center'>Active</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php

                                                    $i=1;
                                                    $db->set_charset("utf8");
                                                    $stm = $db->prepare("SELECT  `contact_us_type_id`, `contact_us_type_name`, `emails`, `active` FROM `B2B_Contact_Us_Types` ");
                                                    $stm->execute();
                                                    $stm->bind_result($id,$name, $email, $active);

                                                    while ($stm->fetch()) {

                                                        if(strcmp($active, "yes")==0) {
                                                            $statusYes = 'selected';
                                                        } else {
                                                            $statusNo  = 'selected';
                                                        }

                                                        echo "<tr>";
                                                        echo "<td><img class='deletRowButton' src='img/deleteicon.png' style='width:20px;height:20px;'/></td>";
                                                        echo "<td class='index text-center' style='width:5%'><strong>$i</strong></td>";
                                                        echo "<td><input style='width:100%' class='customerCode text-center form-control' id='name' name='name' type='text' value='".$name."' /></td>";
                                                        echo "<td style='width:14%' class='text-center' ><input style='width:100%;' class='text-center form-control custom-textarea'  id='email' name='email' type='text'  value='".$email."'/></td>";
                                                        echo "<td><select id='active' style='width:100%;'><option value='yes' ".$statusYes.">Yes</option><option value='no' ".$statusNo.">No</option></select> </td>";
                                                        echo "</tr>";
                                                        $i++;
                                                    }
                                                    $stm->close();

                                                    if($i<=1)
                                                    {
                                                        echo "<tr>";
                                                        echo "<td><img class='deletRowButton' src='img/deleteicon.png' style='width:20px;height:20px;'/></td>";
                                                        echo "<td class='index text-center' style='width:5%'><strong>$i</strong></td>";
                                                        echo "<td><input style='width:100%' class='customerCode text-center form-control' id='name' name='name' type='text' value='test' ></td>";
                                                        echo "<td style='width:14%' class='text-center'  ><input style='width:100%;' class='text-center form-control custom-textarea'  id='email' name='email' type='text'  /></td>";
                                                        echo "<td><select id='active' style='width:100%;'><option value='yes' >Yes</option><option value='no' >No</option></select> </td>";
                                                        echo "</tr>";
                                                    }
                                                    ?>
                                                    </tbody>
                                                </table>
                                                <button style="width: 180px;margin-left:10px;" target="_blank" id="newLineButton" name='newLineButton' class="btn btn-primary btn-block newLineButton">
                                                    <i class="fa fa-plus"></i>&nbsp; Add Contact Type
                                                </button>
                                            </section>
                                        </div>
                                    </div>
                                </section>
                            </div>
                </article>

                <!-- widget Social Media-->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12" >
                    <div  class="jarviswidget jarviswidget-color-blueDark" id="wid-id-4" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-gears"></i> </span>
                            <h2>Social Media </h2>
                        </header>
                        <!-- widget div-->

                        <!-- widget content -->
                        <div class="" style="padding: 10px; 10px; 10px; 10px;" >
                            <div class="">
                                <section>
                                    <div class="row">
                                        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                                                    <section>
                                                        <label class="label-bold align-left" style="width: 95%; position: relative; left: 10px;">Facebook Link: </label>
                                                        <input type="text" class="form-control"  id="facebook" value="<?php echo $facebook?>" style="width: 95%; position: relative; left: 10px;"/>
                                                    </section>
                                                    <section>
                                                        <label class="label-bold align-left" style="width: 95%; position: relative; left: 10px;">Twitter Link: </label>
                                                        <input type="text" class="form-control"  id="twitter" value="<?php echo $twitter?>" style="width: 95%; position: relative; left: 10px;"/>
                                                    </section>
                                        </div>
                                    </div>
                                </section>
                            </div>
                </article>
            </div>

</div>




<script src="./js/plugin/dropzone/dropzone.min.js"></script>


<script type="text/javascript">


    function showPosition(position) {
        x.innerHTML = "Latitude: " + position.coords.latitude +
            "<br>Longitude: " + position.coords.longitude;
    }


    function savePost() {

        var lat               = $('#lat').val();
        var lng               = $('#lng').val();
        var address           = $('#address').val();
        var telephone         = $('#telephone').val();
        var fax               = $('#fax').val();
        var sidebarEmail      = $('#sidebarEmail').val();
        var contactFormEmail  = $('#contactFormEmail').val();
        var facebook          = $('#facebook').val();
        var twitter           = $('#twitter').val();
        var contactTypes     = $('#datatable_fixed_column').tableToJSON(
            {
                ignoreColumns: [0,1],
                textExtractor : {
                    0 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    1 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    2 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    3 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    4 : function(cellIndex, $cell) {
                        return $cell.find('select').val();
                    }
                },
                ignoreHiddenRows: false,
                ignoreEmptyRows: false
            }
        );




            $.ajax({
                type: 'POST',
                url: './concc/edit_contact_us.php',
                dataType: 'html',
                data: {
                    'lat': lat,
                    'lng': lng,
                    'facebook': facebook,
                    'address': address,
                    'telephone': telephone,
                    'fax': fax,
                    'sidebarEmail': sidebarEmail,
                    'contactFormEmail': contactFormEmail,
                    'twitter': twitter,
                    'contactTypes': contactTypes


                },
                success: function (result) {

                    $.smallBox({
                        title: 'Success!',
                        content: "Post successfully entered",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                }
            });

    }

    // End of SavePost()

    function initMap() {

        var lat = <?php echo $lat; ?>;
        var lng = <?php echo $lng; ?>;

        copMap = new google.maps.Map(document.getElementById('map_coprime'), {
            center: {lat: lat, lng: lng},
            zoom: 15,
            mapTypeControl: false,
            streetViewControl: false,
            zoomControl: true
        });

        var copMarker = new google.maps.Marker({
            position: {lat: lat, lng: lng},
            map: copMap,
            title: 'Company Location',
            draggable: true
        });

        copMarker.addListener('mouseout', function() {
            var newLat = copMarker.getPosition().lat();
            var newLng = copMarker.getPosition().lng();
            $('#lat').val(newLat);
            $('#lat').trigger('change');
            $('#lng').val(newLng);
            $('#lng').trigger('change');
        });

    }




    function addRowSwitchHelper(selector)
    {
        var fixHelperModified = function(e, tr) {
            var originals = tr.children();
            var helper = tr.clone();
            helper.children().each(function(tr) {
                $(this).width(originals.eq(tr).width())
            });
            return helper;
            },
            updateIndex = function(e, ui) {
                $('td.index', ui.item.parent()).each(function (i) {
                    $(this).text(i + 1);
                });
            };

        $(selector + "tbody").sortable({
            helper: fixHelperModified,
            stop: updateIndex
        });
    }

    function addEnterListener(selector)
    {
        $(selector).on('keydown', 'input', function (e) {
            var keyCode = e.keyCode;
            if (keyCode !== 13) return;
            var $this = $(this);

            var $thisTd = $(e.target).closest('tr');
            $lastTd = $('td:last', $thisTd);

            if (($(e.target).closest('td')).is($lastTd)) {
                $newTr = $thisTd.clone();
                $thisTd.after($newTr);
                $newTr.find("input").val("");
                $newTr.find("textarea").text("");
                $newTr.find("label").text("");
                $i = $newTr.find("td.index").text();
                $i++;
                $newTr.find("td.index").text($i);

                $(".deletRowButton").unbind('click').click(function () {
                    deleteRow(this,selector);
                });
                initProductAutocomplete();
            }

            updateTrNumbering(selector);
        });
    }

    function addTabListener(selector)
    {
        $(selector).on('keydown', 'input', function (e) {
            var keyCode = e.keyCode;
            if (keyCode !== 9) return;

            var $this = $(this),
                $lastTr = $('tr:last', $(selector)),
                $lastTd = $('td:last', $lastTr);
            if (($(e.target).closest('td')).is($lastTd)) {

                $newTr = $lastTr.clone();
                $lastTr.after($newTr);
                $newTr.find("input").val("");
                $newTr.find("textarea").text("");
                $newTr.find("label").text("");
                $i = $newTr.find("td.index").text();
                $i++;
                $newTr.find("td.index").text($i);

                $( ".deletRowButton" ).unbind('click').click(function() {
                    deleteRow(this,selector);
                });
                initProductAutocomplete();
            }

        });
    }

    function addNewLine(selector)
    {
        $lastTr = $('tr:last', $(selector));
        $lastTd = $('td:last', $lastTr);
        $newTr = $lastTr.clone();
        $lastTr.after($newTr);
        $newTr.find("input").val("");
        $newTr.find("textarea").text("");
        $newTr.find("label").text("");
        $i = $newTr.find("td.index").text();
        $i++;
        $newTr.find("td.index").text($i);

        $( ".deletRowButton" ).unbind('click').click(function() {
            deleteRow(this,selector);
        });

    }

    function deleteRow(row,selector)
    {
        var rowCount = $(selector + ' tr').length;

        if (rowCount > 2) {
            $(row).parents('tr').remove();
        }
        updateTrNumbering(selector);
    }


    function initContactTypeTable()
    {
        addRowSwitchHelper('#datatable_fixed_column');
        addEnterListener('#datatable_fixed_column');
        addTabListener('#datatable_fixed_column');

        $( "#newLineButton" ).click(function() {
            addNewLine('#datatable_fixed_column');
        });

        $( "#datatable_fixed_column img.deletRowButton" ).unbind('click').click(function() {
            deleteRow(this,'#datatable_fixed_column');
        });
    }

    $(document).ready(function() {

        pageSetUp();
        initMap();
        initContactTypeTable('#datatable_fixed_column');

        });



</script>
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAonEryABOdRQBcgEfH51-nOoXTca3XlWs"></script>
<script src="js/jquery.tabletojson.js"></script>
<script src="js/plugin/datatables/jquery.dataTables.min.js"></script>
<script src="js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="js/plugin/select2/select2.min.js"></script>
<script src="../platform/js/jqueryuitouchpunch/jquery.ui.touch-punch.min.js"></script>
<script src="js/plugin/select2/select2.min.js"></script>
<script src="js/notification/SmartNotification.min.js"></script>
