<?php

include_once("../../../../param.php");
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('dbinfo.php');
// DB table to use
$table = 'ZZ_Holiday_Time_Slots';

// Table's primary key
$primaryKey = "holiday_slots_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array('db' => '`s`.`zip_code_id`', 'dt' => 'logo', 'formatter' => function ($d, $row) {
        $GLOBALS['zip_code_id'] = $d;
        return '<i class="fa fa-map-marker" ></i>';
    }, 'field' => 'zip_code_id'),
    
    array('db' => '`s`.`date`',               'dt' => 'date',      'formatter' => function ($d, $row) {
        return date_format( date_create_from_format('Y-m-d', $d), 'd-m-Y');
    },'field' => 'date'),

    array('db' => '`z`.`zip_code_region`',               'dt' => 'region',      'formatter' => function ($d, $row) {
        return $d;
    },'field' => 'zip_code_region'),
    array('db' => '`z`.`zip_codes`',                     'dt' => 'codes',       'formatter' => function ($d, $row) {
        $id = $GLOBALS['zip_code_id'];
        $result = "<div style='display: none;' id='".$id."_zip'>".str_replace(',',', ',$d)."</div><button class='btn btn-return' onclick='viewInput(\"".$id."_zip\",this);'>View ZIP codes</button>";
        return $result;
    },'field' => 'zip_codes'),
    array('db' => '`s`.`time_slots`',                    'dt' => 'slots',       'formatter' => function ($d, $row) {
        return str_replace(',','<br>',$d);
    },'field' => 'time_slots'),
    array('db' => '`z`.`next_day_only_time_slots`',                    'dt' => 'nextDaySlots',       'formatter' => function ($d, $row) {
        return str_replace(',','<br>',$d);
    },'field' => 'next_day_only_time_slots'),
    array('db' => '`z`.`disable_slot_hours_before`',     'dt' => 'hrs',         'field' => 'disable_slot_hours_before'),
    array('db' => '`s`.`next_day_delivery_after_time`',  'dt' => 'nextdaytime', 'field' => 'next_day_delivery_after_time'),

    array('db' => '`s`.`holiday_slots_id`',                   'dt' => 'form',        'formatter' => function( $d, $row ) {
        $result = " <form action='edit_holiday_slots.php' target='_blank' method='post'>
                        <input type='hidden' name='area_id' value='$d'>
                        <button class='btn btn-primary' type='submit' >Edit Holiday</button>
                    </form>";
        return $result;
    }, 'field' => 'holiday_slots_id' )

);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db' => $database,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `ZZ_Holiday_Time_Slots` AS `s` LEFT JOIN `ZZ_Zip_Codes` AS `z` ON (`s`.`zip_code_id`=`z`.`zip_code_id`) ";
require('ssp2.class.php');

echo json_encode(
    SSP::simple($_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery)
);

