<?php

include_once("../../../../param.php");
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('dbinfo.php');
// DB table to use
$table = 'ZZ_Holiday_Time_Slots';

// Table's primary key
$primaryKey = "holiday_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(

    array('db' => '`s`.`date`',               'dt' => 'date',      'formatter' => function ($d, $row) {
        return date_format( date_create_from_format('Y-m-d', $d), 'd-m-Y');
    },'field' => 'date'),

    array('db' => '`s`.`time_slots`',                    'dt' => 'slots',       'formatter' => function ($d, $row) {
        return str_replace(',','<br>',$d);
    },'field' => 'time_slots'),

    array('db' => '`s`.`next_day_delivery_after_time`',  'dt' => 'nextdaytime', 'field' => 'next_day_delivery_after_time'),

    array('db' => '`s`.`holiday_id`',                   'dt' => 'form',        'formatter' => function( $d, $row ) {
        $result = " <form action='edit_b2b_scheduled_holiday.php' method='post'>
                        <input type='hidden' name='holidayID' value='$d'>
                        <button class='btn btn-primary' type='submit' >Edit Holiday</button>
                    </form>";
        return $result;
    }, 'field' => 'holiday_id' )

);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db' => $database,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `B2B_Scheduled_Holidays` AS `s` ";
require('ssp2.class.php');

echo json_encode(
    SSP::simple($_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery)
);

