<?php


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('dbinfo.php');
// DB table to use
$table = 'Promotions';

// Table's primary key
$primaryKey = "promotion_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array('db' => '`p`.`promotion_name`',  'dt' => 'name',  'field' => 'promotion_name'),
    array('db' => '`p`.`promotion_code`',  'dt' => 'code',  'field' => 'promotion_code'),
    array('db' => '`p`.`fixed_discount_amount`',      'dt' => 'amount',  'formatter' => function( $d, $row ) {if($d==0){return '-';}else{return $d;}},  'field' => 'fixed_discount_amount'),
    array('db' => '`p`.`fixed_discount_percent`',     'dt' => 'percent',  'formatter' => function( $d, $row ) {if($d==0){return '-';}else{return $d;}},  'field' => 'fixed_discount_percent'),
    array('db' => '`p`.`valid_from`',      'dt' => 'from',  'formatter' => function( $d, $row ) {return str_replace(' ','<br>',date_format( date_create_from_format('Y-m-d H:i:s', $d), 'd-m-Y H:i'));},  'field' => 'valid_from'),
    array('db' => '`p`.`valid_until`',     'dt' => 'until', 'formatter' => function( $d, $row ) {$GLOBALS['until']=$d;return str_replace(' ','<br>',date_format( date_create_from_format('Y-m-d H:i:s', $d), 'd-m-Y H:i'));},  'field' => 'valid_until'),
    array('db' => '`p`.`timestamp`',     'dt' => 'timestamp', 'formatter' => function( $d, $row ) {
        return str_replace(' ','<br>',date_format( date_create_from_format('Y-m-d H:i:s', $d), 'd-m-Y H:i'));
    },  'field' => 'timestamp'),

    array('db' => '`p`.`type`',            'dt' => 'type',  'formatter' => function( $d, $row ) {
        switch ($d){
            case '4':
                $result= "One Time Percentage Discount";
                break;
            case '5':
                $result= "One Time Price Discount";
                break;
            case '9':
                $result= "Competition";
                break;
            case '9999':
                $result= "Competition Entry";
                break;
            case '6':
                $result= "One Time Per User";
                break;
            case '6666':
                $result= "User Coupon Claim";
                break;
            case '7':
                $result= "One Time Per User";
                break;
            case '7777':
                $result= "User Coupon Claim";
                break;
            default:
                $result=$d;
        }
        return $result;

    }, 'field' => 'type'),

    array('db' => '`p`.`description`',   'dt' => 'description',  'formatter' => function( $d, $row ) {
        $GLOBALS['description']=$d;
        return $d;
    }, 'field' => 'description'),

    array('db' => '`p`.`status`',   'dt' => 'status',    'formatter' => function( $d, $row ) {
        $GLOBALS['active'] = '';
        if(strcmp($d,'yes')==0){

            if(strcmp($GLOBALS['description'],'')!=0){

                if(is_numeric($GLOBALS['description'])) {
                    $status = "<b style='color: darkgoldenrod'>Claimed";
                    require_once("dbinfo.php");
                    global $username, $password, $database;
                    $db = new mysqli('localhost', $username, $password, $database);
                    if (mysqli_connect_errno()) {
                        printf("Connect failed: %s\n", mysqli_connect_error());
                        exit();
                    }
                    $db->set_charset("utf8");
                    $stm = $db->prepare("SELECT first_name,last_name,mobile FROM B2B_User WHERE b2b_user_id = " . $GLOBALS['description']);
                    $stm->execute();
                    $stm->bind_result($firstName,$lastName,$mobile);
                    while ($stm->fetch()) {
                        if(strcmp($firstName,'')!=0){
                            $status .= " by $firstName $lastName ($mobile)";
                        }
                    }
                    $stm->close();
                    $status .="</b>";
                } else if (strcmp($GLOBALS['description'],'Used')==0) {
                    $status = "<b style='color: firebrick'>".$GLOBALS['description']."</b>";
                } else {
                    $status = "<b style='color: darkgoldenrod'>".$GLOBALS['description']."</b>";
                }

            } else {
                $status = "<b style='color: green'>Active</b>";
                if (date('Y-m-d H:i:s') > $GLOBALS['until']) {
                    $status = "<b style='color: fireBrick'>Expired</b>";
                    $GLOBALS['active'] = 'Expired';
                } else {
                    $GLOBALS['active'] = 'yes';
                }
            }

        } else if(strcmp($d,'no')==0){

            if(strcmp($GLOBALS['description'],'')!=0){

                if(is_numeric($GLOBALS['description'])) {
                    $status = "<b style='color: darkgoldenrod'>Claimed";
                    require_once("dbinfo.php");
                    global $username, $password, $database;
                    $db = new mysqli('localhost', $username, $password, $database);
                    if (mysqli_connect_errno()) {
                        printf("Connect failed: %s\n", mysqli_connect_error());
                        exit();
                    }
                    $db->set_charset("utf8");
                    $stm = $db->prepare("SELECT first_name,last_name,mobile FROM B2B_User WHERE b2b_user_id = " . $GLOBALS['description']);
                    $stm->execute();
                    $stm->bind_result($firstName,$lastName,$mobile);
                    while ($stm->fetch()) {
                        if(strcmp($firstName,'')!=0){
                            $status .= " by $firstName $lastName ($mobile)";
                        }
                    }
                    $stm->close();
                    $status .="</b>";
                } else if (strpos($GLOBALS['description'], 'Used') !== false) {
                    $status = "<b style='color: firebrick'>".$GLOBALS['description']."</b>";
                } else {
                    $status = "<b style='color: darkgoldenrod'>".$GLOBALS['description']."</b>";
                }

            } else {
                $GLOBALS['active'] = 'no';
                $status = 'Inactive';
            }

        } else {
            if(is_numeric($d)) {
                require_once("dbinfo.php");
                global $username, $password, $database;
                $db = new mysqli('localhost', $username, $password, $database);
                if (mysqli_connect_errno()) {
                    printf("Connect failed: %s\n", mysqli_connect_error());
                    exit();
                }
                $db->set_charset("utf8");
                $stm = $db->prepare("SELECT promotion_name FROM Promotions WHERE promotion_id = " . $d);
                $stm->execute();
                $stm->bind_result($status);
                while ($stm->fetch()) {}
                $stm->close();
                $db->set_charset("utf8");
                $stm = $db->prepare("SELECT first_name,last_name,mobile FROM B2B_User WHERE b2b_user_id = " . $GLOBALS['description']);
                $stm->execute();
                $stm->bind_result($firstName,$lastName,$mobile);
                while ($stm->fetch()) {}
                $stm->close();
                $status = "<b style='color: darkgoldenrod'>Claimed By $firstName $lastName ($mobile)</b>";
            } else {
                $status = $d;
            }

        }

        return $status;
    }, 'field' => 'status'),

    array('db' => '`p`.`promotion_id`',      'dt' => 'form',  'formatter' => function( $d, $row ) {
        if(strcmp($GLOBALS['active'],'yes')==0){
            return "<button type='button' class='btn btn-danger' onclick=\"disableCoupon($d,'no')\">Deactivate</button>";
        } else if (strcmp($GLOBALS['active'],'no')==0){
            return "<button type='button' class='btn btn-success' onclick=\"disableCoupon($d,'yes')\">Activate</button>";
        } else if (strcmp($GLOBALS['active'],'Expired')==0){
            return "<button type='button' class='btn btn-theme-dark' disabled readonly>Expired</button>";
        } else {
            return "<button type='button' class='btn btn-theme-dark' disabled readonly>Claimed</button>";
        }
    },  'field' => 'promotion_id'),


);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db' => $database,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Promotions` AS `p` ";
require('ssp2.class.php');

echo json_encode(
    SSP::simple($_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery)
);

