<?php

include_once("../../../../param.php");
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('dbinfo.php');
// DB table to use
$table = 'B2B_Grid_Menu';

// Table's primary key
$primaryKey = "b2b_grid_menu_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array('db' => '`g`.`timestamp`',            'dt' => 'time',         'field' => 'timestamp'),
    array('db' => '`g`.`class_outer`',          'dt' => 'classOuter',   'field' => 'class_outer'),
    array('db' => '`g`.`class_inner`',          'dt' => 'classInner',   'field' => 'class_inner'),
    array('db' => '`g`.`hover_text`',           'dt' => 'hoverText',    'field' => 'hover_text'),
    array('db' => '`g`.`position`',             'dt' => 'position',     'field' => 'position'),

    array('db' => '`g`.`b2b_grid_menu_id`',     'dt' => 'parent',   'formatter' => function( $d, $row ) {

        require("dbinfo.php");
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT title FROM B2B_Grid_Menu WHERE b2b_grid_menu_id LIKE (SELECT parent_id FROM B2B_Grid_Menu WHERE b2b_grid_menu_id = " . $d . ")");
        $stm->execute();
        $stm->bind_result($parent );
        while ($stm->fetch()) {}
        $stm->close();

        return $parent;
    },'field' => 'b2b_grid_menu_id'),

    array('db' => '`g`.`icon`', 'dt' => 'icon',     'formatter' => function( $d, $row ) {
        $d = ltrim($d, './');
        return '<img class="order" src="//'.HTML_PATH.'/cop/b2b/'.$d.'" height="42" width="42">';
    },'field' => 'icon'),

    array('db' => '`g`.`title`',                'dt' => 'title',    'formatter' => function( $d, $row ) {
        return '<div class="summernote">'.$d.'</div>';
    },'field' => 'title'),

    array('db' => '`g`.`url`',                  'dt' => 'url',      'formatter' => function( $d, $row ) {
        return '<a href="//' . HTML_PATH . '/cop/b2b/'.$d.'" target="_blank">'.$d.'</a>';
    },'field' => 'url'),

    array('db' => '`g`.`b2b_grid_menu_id`',     'dt' => 'form',     'formatter' => function( $d, $row ) {

        require("dbinfo.php");
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        return '<form id="'.$d.'"action="edit_grid_menu.php" method="post">
           		<input type="hidden" name="grid_menu_id" value="'.$d.'">	           			                   
			    <input style="font-size:13px;" type="submit" class="btn btn-primary" value="Edit" style="width:55px; display: inline; " >
			    </form>';},
        'field' => 'b2b_grid_menu_id')

);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db' => $database,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `B2B_Grid_Menu` AS `g` ";
require('ssp2.class.php');

echo json_encode(
    SSP::simple($_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery)
);

