<?php


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('dbinfo.php');
// DB table to use
$table = 'B2B_Pop_Up_Message';

// Table's primary key
$primaryKey = "b2b_pop_up_message_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array('db' => '`p`.`title`', 'dt' => 'title', 'formatter' => function( $d, $row ) {
        $GLOBALS["title"] = $d;
        return $d;
        },
        'field' => 'title' ),

    array('db' => '`p`.`value`', 'dt' => 'value', 'formatter' => function( $d, $row ) {
        $GLOBALS["body"] = $d;
        return $d;
    },
        'field' => 'value' ),

    array('db' => '`p`.`date_from`', 'dt' => 'dateFrom', 'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));
    },
        'field' => 'date_from' ),

    array('db' => '`p`.`date_to`', 'dt' => 'dateTo', 'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));
    },
        'field' => 'date_to' ),

//    array('db' => '`p`.`title`',            'dt' => 'title',      'field' => 'title'),
//    array('db' => '`p`.`value`',    'dt' => 'value',         'field' => 'value'),
//    array('db' => '`p`.`date_from`',        'dt' => 'dateFrom',     'field' => 'date_from'),
//    array('db' => '`p`.`date_to`',    'dt' => 'dateTo',   'field' => 'date_to'),
    array('db' => '`p`.`active`',   'dt' => 'active',  'field' => 'active'),
    array('db' => '`p`.`page`',        'dt' => 'page',     'field' => 'page'),
    array('db' => '`p`.`logged_in`',               'dt' => 'loggedIn',       'field' => 'logged_in'),
    array('db' => '`p`.`one_time`',               'dt' => 'oneTime',       'field' => 'one_time'),

    array('db' => '`p`.`b2b_pop_up_message_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {


        return '<form id="'.$d.'"action="edit_b2b_pop_up_message.php" method="post" target="_blank" style="display: inline;">
           		<input type="hidden" name="b2b_pop_up_message_id" value="'.$d.'">	           			                   
			    <input type="submit" class="btn btn-primary" value="Edit" style="font-size:13px; width:60px; display: inline; " >
			    </form>
			    <button class="btn btn-success" style="width:75px; font-size:13px; display: inline;" onclick="modalShow('.$d.')">Preview</button>
			    '

            ;},
        'field' => 'b2b_pop_up_message_id' )

);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db' => $database,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `B2B_Pop_Up_Message` AS `p` ";
require('ssp2.class.php');

echo json_encode(
    SSP::simple($_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery)
);

