<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);
session_start();
require("dbinfo.php");
require("dbhelper.php");

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

//include_once(ROOT . "libs/emailer/PHPMailer/PHPMailer.php");
//include_once(ROOT . "libs/emailer/PHPMailer/Exception.php");
//include_once(ROOT . "libs/emailer/PHPMailer/SMTP.php");

include_once(ROOT . "libs/emailer/PHPMailer8/vendor/autoload.php");


$groupID = 0;
$sendEmails = false;
$showStock = 'np';
$showPrices = 'no';
$showPromotions = 'no';

if(isset($_POST['group_id']) && $_POST['group_id'] > 0){
    $groupID = $_POST['group_id'];
}

if(isset($_POST['send_emails']) && $_POST['send_emails'] == 'yes'){
    $sendEmails = true;
}

if(isset($_POST['show_stock']) && $_POST['show_stock'] == 'yes'){
    $showStock = 'yes';
}

if(isset($_POST['show_prices']) && $_POST['show_prices'] == 'yes'){
    $showPrices = 'yes';
}

if(isset($_POST['show_promotions']) && $_POST['show_promotions'] == 'yes'){
    $showPromotions = 'yes';
}

if($groupID > 0) {
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $customersArray = array();
    $db->set_charset("utf8");
    $stmt = $db->prepare("SELECT Customers.customer_id,Customers.customer_code,Customers.customer_company_name,Customers.email,Customers.mobile FROM Customer_CustomersGroup,Customers WHERE Customer_CustomersGroup.customer_id=Customers.customer_id AND Customer_CustomersGroup.group_id=? AND Customers.customer_id NOT IN (SELECT customer_id FROM B2B_User)");
    $stmt->bind_param('i', $groupID);
    $stmt->execute();
    $stmt-> bind_result($customerID, $customerCode,$customerCompanyName,$email,$mobile);
    while ($stmt->fetch()) {
        $newUserCustomer = new stdClass();
        $newUserCustomer->customer_id = $customerID;
        $newUserCustomer->customer_code = $customerCode;
        $newUserCustomer->customer_company_name = $customerCompanyName;
        $newUserCustomer->email = $email;
        $newUserCustomer->mobile = "$mobile";
        array_push($customersArray, $newUserCustomer);
    }
    $stmt->close();

    foreach ($customersArray as $newUserCustomer){
        $newUserCustomer->username = generateUsername($db,$newUserCustomer->email,$newUserCustomer->customer_company_name,$newUserCustomer->mobile);
        $newUserCustomer->password = generateRandomPassword($db,12,false,true,true,false);

        $firstLastName = explode(' ', $newUserCustomer->customer_company_name);
        $countSpaces = count($firstLastName);
        $splitCounter = round($countSpaces / 2);

        if($splitCounter == 0){
            $splitCounter = 1;
        }

        foreach ($firstLastName as $key => $value) {
            if($key < $splitCounter){
                $newUserCustomer->first_name .= $value . " ";
            }else{
                $newUserCustomer->last_name .= $value . " ";
            }
        }

        $newUserCustomer->first_name = trim($newUserCustomer->first_name);
        $newUserCustomer->last_name = trim($newUserCustomer->last_name);
        if(emailExists($db, $newUserCustomer->email)){
            if(strcmp($newUserCustomer->email,'')==0){
               echo "<br>Empty Email: $newUserCustomer->customer_code - $newUserCustomer->customer_company_name ";
            } else {
                echo "<br>Email Exists: $newUserCustomer->customer_code - $newUserCustomer->customer_company_name (" . $newUserCustomer->email . ")";
            }
        } else {
            $b2bUserID = getNextKey("B2B_User", "b2b_user_id");
            $db->set_charset("utf8");
            $stmt = $db->prepare("INSERT INTO B2B_User (b2b_user_id,customer_id,username,identifier,email,first_name,last_name,mobile,show_stock, show_prices,show_promo, timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,NOW())");
            $stmt->bind_param('iisssssssss', $b2bUserID, $newUserCustomer->customer_id, $newUserCustomer->username, $newUserCustomer->password, $newUserCustomer->email, $newUserCustomer->first_name, $newUserCustomer->last_name, $newUserCustomer->mobile, $showStock, $showPrices, $showPromotions);
            $stmt->execute();
            $error = $stmt->error;
            echo "<br>New User for $newUserCustomer->customer_code - $newUserCustomer->customer_company_name (" . $newUserCustomer->email . "): $b2bUserID " . $error;
            $stmt->close();

            if(strcmp(trim($error),'')==0) {
                $db->set_charset("utf8");
                $stmt2 = $db->prepare("INSERT INTO B2B_Allow_Categories_User (category_id, b2b_user_id, timestamp) SELECT category_id, ?, NOW() FROM B2B_Categories");
                $stmt2->bind_param('i', $b2bUserID);
                $stmt2->execute();
                $error = $stmt2->error;
                echo $error;
                $stmt2->close();

                if(strcmp(trim($error),'')==0) {
                    if($sendEmails) {
                        sendWelcomeEmail($db, $b2bUserID);
                    }
                }

            }
        }


    }

}


function generateRandomPassword($db, $length = 12, $useUppercase = true, $useLowercase = true, $useNumbers = true, $useSpecialChars = true,$tries = 0){
    $uppercaseChars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $lowercaseChars = 'abcdefghijklmnopqrstuvwxyz';
    $numberChars = '0123456789';
    $specialChars = '!@#$%^&*()-_=+[]{}|;:,.<>?';

    $allChars = '';
    $userPassword = '';

    if ($useUppercase) {
        $allChars .= $uppercaseChars;
        $userPassword .= $uppercaseChars[random_int(0, strlen($uppercaseChars) - 1)];
    }

    if ($useLowercase) {
        $allChars .= $lowercaseChars;
        $userPassword .= $lowercaseChars[random_int(0, strlen($lowercaseChars) - 1)];
    }

    if ($useNumbers) {
        $allChars .= $numberChars;
        $userPassword .= $numberChars[random_int(0, strlen($numberChars) - 1)];
    }

    if ($useSpecialChars) {
        $allChars .= $specialChars;
        $userPassword .= $specialChars[random_int(0, strlen($specialChars) - 1)];
    }

    $remainingLength = $length - strlen($userPassword);

    for ($i = 0; $i < $remainingLength; $i++) {
        $userPassword .= $allChars[random_int(0, strlen($allChars) - 1)];
    }

    // Shuffle the password to make it more random
    $userPasswordArray = str_split($userPassword);
    shuffle($userPasswordArray);
    $userPassword = implode('', $userPasswordArray);

    if($tries > 0){
        $userPassword = $userPassword . $tries;
    }

    if(passwordExists($db, $userPassword)){
        $tries++;
        $userPassword = generateRandomPassword($db, $length, $useUppercase, $useLowercase, $useNumbers, $useSpecialChars,$tries);
    }

    return $userPassword;
}

function generateUsername($db,$email,$companyName,$phone,$tries= 0){

    if(strcmp($email, "") == 0){
        $email = $companyName;
    }
    if(strcmp($email, "") == 0){
        $email = $phone;
    }

    if($tries > 0){
        $email = $email . $tries;
    }

    $email = make_greeklish($email);
    $email = transliterateString($email);

    // Remove the domain part of the email address
    $userUsername = explode('@', $email)[0];

    $userUsernameSuffix = explode('.',explode('@', $email)[1])[0];

    if(strcmp($userUsernameSuffix, "") != 0){
        $userUsernameSuffix = ".".$userUsernameSuffix;
    }

    $userUsername = str_replace(' ', '.', $userUsername);

    $userUsername .= $userUsernameSuffix;

    // Remove any special characters and spaces
//    $userUsername = preg_replace('/[^A-Za-z0-9]/', '', $userUsername.$userUsernameSuffix);

    // Convert to lowercase
    $userUsername = strtolower($userUsername);

    if(usernameExists($db, $userUsername)){
        $tries++;
        $userUsername = generateUsername($db,$email,$companyName,$phone,$tries);
    }

    return $userUsername;
}

function usernameExists($db, $userUsername){
    $exists = false;
    $b2b_user_id = 0;
    $stmt = $db->prepare("SELECT b2b_user_id FROM B2B_User WHERE username=? LIMIT 1");
    $stmt->bind_param('s', $userUsername);
    $stmt->execute();
    $stmt-> bind_result($b2b_user_id);
    while ($stmt->fetch()) {
        if($b2b_user_id > 0){
            $exists = true;
        }
    }
    $stmt->close();

    return $exists;
}

function passwordExists($db, $userPasword){
    $exists = false;
    $b2b_user_id = 0;
    $stmt = $db->prepare("SELECT b2b_user_id FROM B2B_User WHERE username=? LIMIT 1");
    $stmt->bind_param('s', $userPasword);
    $stmt->execute();
    $stmt-> bind_result($b2b_user_id);
    while ($stmt->fetch()) {
        if($b2b_user_id > 0){
            $exists = true;
        }
    }
    $stmt->close();

    return $exists;
}

function emailExists($db, $userEmail){
    $exists = false;
    $b2b_user_id = 0;
    $stmt = $db->prepare("SELECT b2b_user_id FROM B2B_User WHERE email=? LIMIT 1");
    $stmt->bind_param('s', $userEmail);
    $stmt->execute();
    $stmt-> bind_result($b2b_user_id);
    while ($stmt->fetch()) {
        if($b2b_user_id > 0){
            $exists = true;
        }
    }
    $stmt->close();

    return $exists;
}



function sendWelcomeEmail($db,$ID){
    $stm = $db->prepare("SELECT CONCAT(last_name,' ',first_name),username, identifier, email, customer_id FROM B2B_User WHERE b2b_user_id='$ID'");
    $stm-> execute();
    $stm-> bind_result($b2bUser,$b2bUsername,$b2bPass,$userEmail, $customerID);
    while ($stm->fetch()) {}
    $stm-> close();

    $stm = $db->prepare("SELECT customer_company_name,customer_code,email FROM Customers WHERE customer_id='$customerID'");
    $stm-> execute();
    $stm-> bind_result($customerCompanyName,$customerCode,$companyEmail);
    while ($stm->fetch()) {}
    $stm-> close();

    $stm = $db->prepare("SELECT email_template_id, email_text, cc_emails,email_type FROM B2B_Email_Templates WHERE email_type = 'Welcome' AND default_template = 'yes' AND active = 'yes' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($emailTemplateID, $emailContent, $emailCC, $emailSubject);
    while ($stm->fetch()) {}
    $stm-> close();

    // If not exist Create Template
    if(empty($emailTemplateID)){

        $emailContent = "<html>
                                    <head></head>
                                    <body><div>
                                           <br />
                                           Dear {b2b_user_name}, <br />
                                           <br />
                                           Welcome to {company_name} B2B Commerce.<br />
                                           You are registered as a user of {customer_company_name}<br />
                                           <br />
                                           Username: {b2b_username}<br />
                                           Password: {b2b_user_password}<br />
                                           <br />
                                           If any data is Incorrect please contact us.<br />
                                           <br />
                                           Best Regards,<br />
                                           {company_name}
                                    </body></html>";
        $emailSubject = "Welcome to B2B Commerce";
        $emailCC      = "";

    } else {
        $emailContent = "<html><head></head><body><div>".$emailContent."</body></html>";
    }

    //If user has email, send to User email ELSE email send to company email
    if(empty($userEmail)){
        $email = $companyEmail;
    } else {
        $email = $userEmail;
    }

    $emailContent = str_replace("{action_details}"       ,$actionDetails      ,$emailContent);
    $emailContent = str_replace("{action_date}"          ,$actionDate         ,$emailContent);
    $emailContent = str_replace("{grand_total}"          ,$grandTotal         ,$emailContent);
    $emailContent = str_replace("{b2b_user_name}"        ,$b2bUser            ,$emailContent);
    $emailContent = str_replace("{b2b_username}"         ,$b2bUsername        ,$emailContent);
    $emailContent = str_replace("{b2b_user_password}"    ,$b2bPass            ,$emailContent);
    $emailContent = str_replace("{reset_password_link}"  ,$passwordLink       ,$emailContent);
    $emailContent = str_replace("{customer_company_name}",$customerCompanyName,$emailContent);
    $emailContent = str_replace("{customer_code}"        ,$customerCode       ,$emailContent);
    $emailContent = str_replace("{action_code}"          ,$actionCode         ,$emailContent);

    echo " Sending welcome email to $email ";


    sendEmail($email,$emailCC,$emailContent,$emailSubject);

}

function sendEmail($email,$emailCC,$emailHtml,$emailSubject)
{
    global $username;
    global $password;
    global $database;

    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT email_host, email_from, email_username, email_password, company_name FROM B2B_Configuration");
    $stm-> execute();
    $stm-> bind_result($emailHost,$emailFrom,$emailUsername,$emailPassword,$companyName);
    while ($stm->fetch()) {}
    $stm-> close();

    //If Company Logo variable exists replace variable with image element
    if (strpos($emailHtml, "{company_logo}") !== false) {
        $Companylogo = "<img src='http://".$_SERVER['HTTP_HOST']."/backend/pdfimage/logo.png' width='20%' height='20%'>";
        $emailHtml = str_replace("{company_logo}",$Companylogo,$emailHtml);
    }

    //If Company Name variable exists replace variable
    if (strpos($emailHtml, "{company_name}") !== false) {
        $emailHtml = str_replace("{company_name}",$companyName,$emailHtml);
    }
    //If email does not exist send email to sender
    if(strcmp($email,'') == 0){
        $emailSubject = "No Receiver Email found - ".$emailSubject;
        $email = $emailFrom;
    }


    $mail = new PHPMailer(true);                              // Passing `true` enables exceptions
    try {
//        $mail->SMTPDebug = 2;
        $mail->isSMTP();                                      // Set mailer to use SMTP
        $mail->Host = $emailHost;                             // Specify main and backup SMTP servers
        $mail->SMTPAuth = true;                               // Enable SMTP authentication
        $mail->Username = $emailUsername;                     // SMTP username
        $mail->Password = $emailPassword;                     // SMTP password
        $mail->SMTPSecure = 'tls';                            // Enable TLS encryption, `ssl` also accepted
        $mail->Port = 587;                                    // TCP port to connect to
        $mail->setFrom($emailFrom, $companyName);
        $mail->addAddress($email, $email);

        $ccArray = explode(';',$emailCC);
        foreach ($ccArray as $cc){
            if(strcmp($cc,'') != 0) {
                $mail->addCC($cc);
            }
        }

        $mail->CharSet = 'UTF-8';
        $mail->Encoding = "base64";
        $mail->isHTML(true);                                  // Set email format to HTML
        $mail->Subject = $emailSubject;
        $mail->Body = $emailHtml;
        $mail->send();

        echo " - email sent";

    }catch (Exception $ex){
        echo " - exception ".$ex;

        $fp = fopen('email_function_error.txt', 'w');
        fwrite($fp, "\nException: ".$ex);
        fclose($fp);

    }
}

function make_greeklish($text) {
    $expressions = array(
        '/[αΑ][ιίΙΊ]/u' => 'e',
        '/[οΟΕε][ιίΙΊ]/u' => 'i',
        '/[αΑ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'af$1',
        '/[αΑ][υύΥΎ]/u' => 'av',
        '/[εΕ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'ef$1',
        '/[εΕ][υύΥΎ]/u' => 'ev',
        '/[οΟ][υύΥΎ]/u' => 'ou',
        '/(^|\s)[μΜ][πΠ]/u' => '$1b',
        '/[μΜ][πΠ](\s|$)/u' => 'b$1',
        '/[μΜ][πΠ]/u' => 'mp',
        '/[νΝ][τΤ]/u' => 'nt',
        '/[τΤ][σΣ]/u' => 'ts',
        '/[τΤ][ζΖ]/u' => 'tz',
        '/[γΓ][γΓ]/u' => 'ng',
        '/[γΓ][κΚ]/u' => 'gk',
        '/[ηΗ][υΥ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'if$1',
        '/[ηΗ][υΥ]/u' => 'iu',
        '/[θΘ]/u' => 'th',
        '/[χΧ]/u' => 'ch',
        '/[ψΨ]/u' => 'ps',
        '/[αά]/u' => 'a',
        '/[βΒ]/u' => 'v',
        '/[γΓ]/u' => 'g',
        '/[δΔ]/u' => 'd',
        '/[εέΕΈ]/u' => 'e',
        '/[ζΖ]/u' => 'z',
        '/[ηήΗΉ]/u' => 'i',
        '/[ιίϊΙΊΪ]/u' => 'i',
        '/[κΚ]/u' => 'k',
        '/[λΛ]/u' => 'l',
        '/[μΜ]/u' => 'm',
        '/[νΝ]/u' => 'n',
        '/[ξΞ]/u' => 'x',
        '/[οόΟΌ]/u' => 'o',
        '/[πΠ]/u' => 'p',
        '/[ρΡ]/u' => 'r',
        '/[σςΣ]/u' => 's',
        '/[τΤ]/u' => 't',
        '/[υύϋΥΎΫ]/u' => 'i',
        '/[φΦ]/iu' => 'f',
        '/[ωώ]/iu' => 'o',
    );

    $text = preg_replace( array_keys($expressions), array_values($expressions), $text);
    return $text;
}


function transliterateString($txt) {
    $transliterationTable = array('á' => 'a', 'Á' => 'A', 'à' => 'a', 'À' => 'A', 'ă' => 'a', 'Ă' => 'A', 'â' => 'a', 'Â' => 'A', 'å' => 'a', 'Å' => 'A', 'ã' => 'a', 'Ã' => 'A', 'ą' => 'a', 'Ą' => 'A', 'ā' => 'a', 'Ā' => 'A', 'ä' => 'ae', 'Ä' => 'AE', 'æ' => 'ae', 'Æ' => 'AE', 'ḃ' => 'b', 'Ḃ' => 'B', 'ć' => 'c', 'Ć' => 'C', 'ĉ' => 'c', 'Ĉ' => 'C', 'č' => 'c', 'Č' => 'C', 'ċ' => 'c', 'Ċ' => 'C', 'ç' => 'c', 'Ç' => 'C', 'ď' => 'd', 'Ď' => 'D', 'ḋ' => 'd', 'Ḋ' => 'D', 'đ' => 'd', 'Đ' => 'D', 'ð' => 'dh', 'Ð' => 'Dh', 'é' => 'e', 'É' => 'E', 'è' => 'e', 'È' => 'E', 'ĕ' => 'e', 'Ĕ' => 'E', 'ê' => 'e', 'Ê' => 'E', 'ě' => 'e', 'Ě' => 'E', 'ë' => 'e', 'Ë' => 'E', 'ė' => 'e', 'Ė' => 'E', 'ę' => 'e', 'Ę' => 'E', 'ē' => 'e', 'Ē' => 'E', 'ḟ' => 'f', 'Ḟ' => 'F', 'ƒ' => 'f', 'Ƒ' => 'F', 'ğ' => 'g', 'Ğ' => 'G', 'ĝ' => 'g', 'Ĝ' => 'G', 'ġ' => 'g', 'Ġ' => 'G', 'ģ' => 'g', 'Ģ' => 'G', 'ĥ' => 'h', 'Ĥ' => 'H', 'ħ' => 'h', 'Ħ' => 'H', 'í' => 'i', 'Í' => 'I', 'ì' => 'i', 'Ì' => 'I', 'î' => 'i', 'Î' => 'I', 'ï' => 'i', 'Ï' => 'I', 'ĩ' => 'i', 'Ĩ' => 'I', 'į' => 'i', 'Į' => 'I', 'ī' => 'i', 'Ī' => 'I', 'ĵ' => 'j', 'Ĵ' => 'J', 'ķ' => 'k', 'Ķ' => 'K', 'ĺ' => 'l', 'Ĺ' => 'L', 'ľ' => 'l', 'Ľ' => 'L', 'ļ' => 'l', 'Ļ' => 'L', 'ł' => 'l', 'Ł' => 'L', 'ṁ' => 'm', 'Ṁ' => 'M', 'ń' => 'n', 'Ń' => 'N', 'ň' => 'n', 'Ň' => 'N', 'ñ' => 'n', 'Ñ' => 'N', 'ņ' => 'n', 'Ņ' => 'N', 'ó' => 'o', 'Ó' => 'O', 'ò' => 'o', 'Ò' => 'O', 'ô' => 'o', 'Ô' => 'O', 'ő' => 'o', 'Ő' => 'O', 'õ' => 'o', 'Õ' => 'O', 'ø' => 'oe', 'Ø' => 'OE', 'ō' => 'o', 'Ō' => 'O', 'ơ' => 'o', 'Ơ' => 'O', 'ö' => 'oe', 'Ö' => 'OE', 'ṗ' => 'p', 'Ṗ' => 'P', 'ŕ' => 'r', 'Ŕ' => 'R', 'ř' => 'r', 'Ř' => 'R', 'ŗ' => 'r', 'Ŗ' => 'R', 'ś' => 's', 'Ś' => 'S', 'ŝ' => 's', 'Ŝ' => 'S', 'š' => 's', 'Š' => 'S', 'ṡ' => 's', 'Ṡ' => 'S', 'ş' => 's', 'Ş' => 'S', 'ș' => 's', 'Ș' => 'S', 'ß' => 'SS', 'ť' => 't', 'Ť' => 'T', 'ṫ' => 't', 'Ṫ' => 'T', 'ţ' => 't', 'Ţ' => 'T', 'ț' => 't', 'Ț' => 'T', 'ŧ' => 't', 'Ŧ' => 'T', 'ú' => 'u', 'Ú' => 'U', 'ù' => 'u', 'Ù' => 'U', 'ŭ' => 'u', 'Ŭ' => 'U', 'û' => 'u', 'Û' => 'U', 'ů' => 'u', 'Ů' => 'U', 'ű' => 'u', 'Ű' => 'U', 'ũ' => 'u', 'Ũ' => 'U', 'ų' => 'u', 'Ų' => 'U', 'ū' => 'u', 'Ū' => 'U', 'ư' => 'u', 'Ư' => 'U', 'ü' => 'ue', 'Ü' => 'UE', 'ẃ' => 'w', 'Ẃ' => 'W', 'ẁ' => 'w', 'Ẁ' => 'W', 'ŵ' => 'w', 'Ŵ' => 'W', 'ẅ' => 'w', 'Ẅ' => 'W', 'ý' => 'y', 'Ý' => 'Y', 'ỳ' => 'y', 'Ỳ' => 'Y', 'ŷ' => 'y', 'Ŷ' => 'Y', 'ÿ' => 'y', 'Ÿ' => 'Y', 'ź' => 'z', 'Ź' => 'Z', 'ž' => 'z', 'Ž' => 'Z', 'ż' => 'z', 'Ż' => 'Z', 'þ' => 'th', 'Þ' => 'Th', 'µ' => 'u', 'а' => 'a', 'А' => 'a', 'б' => 'b', 'Б' => 'b', 'в' => 'v', 'В' => 'v', 'г' => 'g', 'Г' => 'g', 'д' => 'd', 'Д' => 'd', 'е' => 'e', 'Е' => 'E', 'ё' => 'e', 'Ё' => 'E', 'ж' => 'zh', 'Ж' => 'zh', 'з' => 'z', 'З' => 'z', 'и' => 'i', 'И' => 'i', 'й' => 'j', 'Й' => 'j', 'к' => 'k', 'К' => 'k', 'л' => 'l', 'Л' => 'l', 'м' => 'm', 'М' => 'm', 'н' => 'n', 'Н' => 'n', 'о' => 'o', 'О' => 'o', 'п' => 'p', 'П' => 'p', 'р' => 'r', 'Р' => 'r', 'с' => 's', 'С' => 's', 'т' => 't', 'Т' => 't', 'у' => 'u', 'У' => 'u', 'ф' => 'f', 'Ф' => 'f', 'х' => 'h', 'Х' => 'h', 'ц' => 'c', 'Ц' => 'c', 'ч' => 'ch', 'Ч' => 'ch', 'ш' => 'sh', 'Ш' => 'sh', 'щ' => 'sch', 'Щ' => 'sch', 'ъ' => '', 'Ъ' => '', 'ы' => 'y', 'Ы' => 'y', 'ь' => '', 'Ь' => '', 'э' => 'e', 'Э' => 'e', 'ю' => 'ju', 'Ю' => 'ju', 'я' => 'ja', 'Я' => 'ja');
    return str_replace(array_keys($transliterationTable), array_values($transliterationTable), $txt);
}

?>
