<?php
include_once("../../../param.php");

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT CustomerGroups.group_id,group_code,name,COUNT(Customer_CustomersGroup.customer_id) FROM CustomerGroups,Customer_CustomersGroup,B2B_User WHERE CustomerGroups.group_id=Customer_CustomersGroup.group_id AND Customer_CustomersGroup.customer_id=B2B_User.customer_id GROUP BY CustomerGroups.group_id");
$stm-> execute();
$stm-> bind_result($groupID, $groupCode, $groupName,$countCustomers);
while ($stm->fetch()) {
    $customerSelection .= "<option value='$groupID'>$groupCode - $groupName ($countCustomers B2B Customers)</option>";
}


function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}
?>

<div id="main" role="main" class="background-color-whitish">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Reports / B2B Customers / Group Categories</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
                <h3 style="display:inline;margin-left:10px;" class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-users"></i>
                    B2B Customers - Group Categories
                </h3>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="" style="margin-top:10px;">
            <!-- row -->
            <div class="row">

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>B2B Customers / Groups</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">
                                <center>
                                <label style="display: block; margin-top: 10px"><b>Select Customer Group:</b></label>
                                <select name="customerGroup" id="customerGroup" class="form-control" style="width: 50%">
                                    <?php echo $customerSelection; ?>
                                </select>



                                <br>
                                <br>


                                    <button type="button" name="generateReport" id="generateReport" class="btn btn-primary btn-block" onclick="getCategories(true)" style="width: 50%" >Get Categories</button>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-3" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Report</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">

                                <div name="reportResult" id="reportResult"></div>
                                <form method="POST" action="#" name="xlsForm" id="xlsForm" >
                                    <input type="hidden" name="inputResult" id="inputResult" value=""/>
                                    <input type="hidden" name="inputTitle" id="inputTitle" value="groupSendEmails"/>
                                </form>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

            </div>


    </div>
    <!-- end widget content -->

    <!-- end row -->
    </section>

</div>

<script src="js/plugin/datatables/jquery.dataTables.min.js"></script>
<script src="js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="js/plugin/datatable-responsive/datatables.responsive.min.js"></script>

<script type="text/javascript">

    $(document).ready(function() {

        pageSetUp();
        $('#customerGroup').select2();
        $('#emailType').select2();



    });

    function getCategories(){

        var customerGroup = $('#customerGroup').val();


        $('#reportResult').html('<center><b>Getting Categories..</b></center>');

        $.ajax({
            type: "POST",
            url: './concc/getCustomerGroupCategories.php',
            data: {'customerGroup':customerGroup},

            success: function (result) {
                $('#reportResult').html(result);
            }
        });

    }

    function denyAll(categoryID,groupID,buttonElement,bothButtons){

        $.ajax({
            type: "POST",
            url: './concc/allowCustomerGroupCategories.php',
            data: {'groupID':groupID,'categoryID':categoryID,'status':'D'},

            success: function (result) {


                if (bothButtons) {
                    $(buttonElement).parent().find('.btn').show();
                    $(buttonElement).hide();
                } else {
                    $(buttonElement).attr("onclick", "allowAll(" + categoryID + "," + groupID + ",this,false)");
                    $(buttonElement).removeClass("btn-danger");
                    $(buttonElement).addClass("btn-success");
                    $(buttonElement).html('Allow All');
                }
                $(buttonElement).parent().parent().parent().find('.allowance').html('No Group Users Allowed');

            }
        });
    }

    function allowAll(categoryID,groupID,buttonElement,bothButtons){

        $.ajax({
            type: "POST",
            url: './concc/allowCustomerGroupCategories.php',
            data: {'groupID':groupID,'categoryID':categoryID,'status':'A'},

            success: function (result) {

                if (bothButtons) {
                    $(buttonElement).parent().find('.btn').show();
                    $(buttonElement).hide();
                } else {
                    $(buttonElement).attr("onclick", "denyAll(" + categoryID + "," + groupID + ",this,false)");
                    $(buttonElement).removeClass("btn-success");
                    $(buttonElement).addClass("btn-danger");
                    $(buttonElement).html('Deny All');
                }
                $(buttonElement).parent().parent().parent().find('.allowance').html('<b>Allowed For All Group Users</b>');

            }
        });
    }



</script>


