<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 include_once('../../../../param.php');
// DB table to use
$table = 'Orders';
 
// Table's primary key
$primaryKey = "order_code";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`o`.`order_id`', 'dt' => 'id', 'formatter' => function( $d, $row ) {
        $GLOBALS['tender_id']=$d;
        return '';}, 'field' => 'order_id' ),

    array( 'db' => '`o`.`order_id`', 'dt' => 'pick', 'formatter' => function( $d, $row ) {
        global $username;
        global $password;
        global $database;
        $db1 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $z=0;
        $db1->set_charset("utf8");
        $stm1 = $db1->prepare("SELECT COUNT(pick_id) FROM Pick_Order WHERE order_id='$d'");
        $stm1-> execute();
        $stm1-> bind_result($counter);
        while ($stm1->fetch()) {
            $z=$counter;
        }
        $stm1->close();
        return $z;}, 'field' => 'order_id' ),
    array( 'db' => '`o`.`order_code`', 'dt' => 'img', 'formatter' => function( $d, $row ) {
        $id = $GLOBALS['tender_id'];
        return '<img class="custom-rounded-image order center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/ordericon.png" width="30" height="30" onclick="actionHistory('.$id.',\'Orders\')" title="Track Order" ></td>';},
        'field' => 'order_code' ),
     array( 'db' => '`o`.`order_code`', 'dt' =>  'code', 'field' =>'order_code' ),
     array( 'db' => '`o`.`details`', 'dt' =>  'details', 'field' =>'details' ),
    array( 'db' => '`o`.`status`', 'dt' =>  'status', 'field' =>'status' ),
    array( 'db' => '`c`.`customer_code`', 'dt' => 'customercode', 'field' => 'customer_code' ),
       array( 'db' => '`c`.`customer_company_name`', 'dt' => 'customer', 'field' => 'customer_company_name' ),
     array( 'db' => '`o`.`order_date`', 'dt' => 'date' , 'formatter' => function( $d, $row ) {
         return date('d-m-Y',strtotime($d));},'field' => 'order_date' ),

    array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson',

        'formatter' => function( $d, $row ) {


            global $username;
            global $password;
            global $database;
            $db1 = new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }

            $db1->set_charset("utf8");
            $stm1 = $db1->prepare("SELECT first_name,last_name FROM SalesPersons WHERE salesperson_code='$d'");
            $stm1-> execute();
            $stm1-> bind_result($fname,$lname);
            while ($stm1->fetch()) {

            }
            $stm1->close();

            return "$d - $fname $lname";



        },


        'field' => 'salesperson_code' ),
             array( 'db' => '`o`.`delivery_date`', 'dt' => 'delivery', 'formatter' => function( $d, $row ) {
                 if(strcmp($d,'0000-00-00') == 0){
                     return "";
                 } else {
                     return date('d-m-Y',strtotime($d));}
                 },'field' => 'delivery_date' ),
             array( 'db' => '`o`.`grand_total`', 'dt' => 'grand', 'formatter' => function( $d, $row ) {
                return currencySymbol . strval(number_format($d,2));},
          'field' => 'grand_total' ),
         
     array( 'db' => '`o`.`order_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
                return '<!--<form style="display:inline;" target="_blank" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/core/views/view/view_order.php" method="post">
           		<input type="hidden" name="order_id" value="'.$d.'">	           			                   
			<input style="font-size:13px;" type="submit" class="btn btn-primary" value="View" style="width:60px">
			</form>-->
			<form style="display:none;" class="tableRowForm" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/modules/OrdersQualityControl/views/create_order_for_quality_control.php" method="post">
           		<input type="hidden" class="orderID" name="order_id" value="'.$d.'">
			<input style="font-size:13px;" type="submit" class="btn btn-invoice" value="Edit">
			</form>
			<!-- <form style="display:inline;" class="tableRowForm" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/core/views/addedit/create_invoice.php" method="post">
           		<input type="hidden" class="orderID" name="order_id" value="'.$d.'">
			<input style="" type="submit" class="btn btn-invoice" value="Convert To Invoice">
			</form>
			<form style="display:inline;" class="tableRowForm" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/core/views/addedit/create_warehouse_transfer.php" method="post">
           		<input type="hidden" class="orderID" name="order_id" value="'.$d.'">
			<input style="" type="submit" class="btn btn-invoice" value="Convert To WT">
			</form> -->
						
			';},
            'field' => 'order_id' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
$where = ' NOT `o`.`status`=\'Canceled\' AND NOT `p`.`status`=\'Canceled\' AND NOT `o`.`status`=\'Ready to Invoice\' ';
if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= "`c`.`customer_id` IN (".$_SESSION['Allow_Customers'].")";
}
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `o`.`salesperson_id` IN (".$_SESSION['Allow_Salespersons'].")";
}
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Orders` AS `o` INNER JOIN `Pick_Order` AS `po` ON (`o`.`order_id` = `po`.`order_id`) INNER JOIN `Pick` AS `p` ON (`po`.`pick_id` = `p`.`pick_id`) LEFT JOIN `Customers` AS `c` ON (`o`.`customer_id` = `c`.`customer_id`) LEFT JOIN `SalesPersons` AS `s` ON (`o`.`salesperson_id` = `p`.`salesperson_id`)";
require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>