<?php
include_once("../../../../param.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

if(isset($_GET['tenderID']))
{

    $tenderID = $_GET['tenderID'];
    $_POST['tender_id'] = $tenderID;
}

if(isset($_POST['tender_id']))
{

	$tenderID=$_POST['tender_id'];
	$_SESSION['tender_id'] = $tenderID;
}
else
{
	$tenderID=$_SESSION['tender_id'];
}
global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
	printf("Connect failed: %s\n", mysqli_connect_error());
	exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT tender_id,tender_code,company_id,salesperson_id,customer_id,tender_date,valid_until,name,address_line_1,address_line_2,city,country,region,subtotal,grand_total,vat_amount,discount_amount,status,vat_i_e,print_count,details,timestamp FROM Tenders WHERE tender_id='$tenderID'");
$stm-> execute();
$stm-> bind_result($tenderID,$tenderCode,$companyID,$salespersonID,$customerID,$tenderDate,$validUntil,$name,$addressLine1,$addressLine2,$city,$country,$region,$subtotal,$grandTotal,$totalVatAmount,$discountAmount,$status,$vatIE,$printCount,$details,$timestamp);
while ($stm->fetch()) {


	$db2 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
		printf("Connect failed: %s\n", mysqli_connect_error());
		exit();
	}
	$db2->set_charset("utf8");
	$stm3 = $db2->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
	$stm3-> execute();
	$stm3-> bind_result($customerCode,$customerName);
	while ($stm3->fetch()) {


	}
	$stm3-> close();

    $db2->set_charset("utf8");
    $stm3 = $db2->prepare("SELECT salesperson_code, first_name, last_name FROM SalesPersons WHERE salesperson_id='$salespersonID'");
    $stm3-> execute();
    $stm3-> bind_result($salespersonCode,$salespersonFirstName, $salespersonLastName);
    while ($stm3->fetch()) {}
    $stm3-> close();
	if(!isset($customerName))
	{
		$customerName =$name;
		$customerCode ="";
	}

	$tenderAddress = "";

	if(isset($addressLine1))
	{
		$tenderAddress = $addressLine1."<br>";
	}
	if(isset($addressLine2))
	{
		$tenderAddress =  $tenderAddress . $addressLine2 . "<br>";
	}
	if(isset($city))
	{
		$tenderAddress =  $tenderAddress . $city;

	}
	if(isset($postcode) && false)
	{
		$tenderAddress = $tenderAddress . $postcode." , ".$region. "</br>".$city."</br>".$country;
	}
	if(strcmp($status,'Canceled') != 0)
	{
		$cancelButton = '<button class="form-control btn btn-primary" type="button" style="display:block;width:120px;padding-top:50px;" id="cancelTenderButton">Cancel Tender</button>';
	}

	$tenderAddress = str_replace("null", "", $tenderAddress);

    $db2->set_charset("utf8");
    $stm3 = $db2->prepare("SELECT lat,lng FROM Schedule_Object_Actions WHERE action_id='$tenderCode' AND action_type='Tender' LIMIT 1");
    $stm3-> execute();
    $stm3-> bind_result($scheduleLat,$scheduleLng);
    while ($stm3->fetch()) {
        if($scheduleLat > 0 && $scheduleLng > 0){
            $map = '<section>
                        <label class="label-bold form-label-space" >Tablet Location: </label>
                        <div class="google_maps " style="height:180px;display: inline-block" id="map_coprime" ></div>
                    </section>
                    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAonEryABOdRQBcgEfH51-nOoXTca3XlWs"></script>
                    <script type="text/javascript">
                        $(document).ready(function() {
                             copMap = new google.maps.Map(document.getElementById(\'map_coprime\'), {
                                center: {lat: '.$scheduleLat.', lng: '.$scheduleLng.'},
                               mapTypeControl: false,
                               draggable: true,
                               scaleControl: true,
                               scrollwheel: true,
                               navigationControl: false,
                               streetViewControl: false,
                                zoom: 17
                             });
                             marker = new google.maps.Marker({
                                position: new google.maps.LatLng('.$scheduleLat.','.$scheduleLng.'),
                                map: copMap,
                                url: "https://www.google.com/maps/search/?api=1&query='.$scheduleLat.','.$scheduleLng.'"
                            });
                            google.maps.event.addListener(marker, \'click\', function() {window.open( marker.url,\'_blank\');});
                         });
                    </script>';
        }
    }
    $stm3-> close();


}
$stm-> close();

if(strcmp($validUntil, '0000-00-00' ) == 0){
    $validUntil = "Not Set";
}



function redirect($url)
{
	if (headers_sent())
	{
		die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
	}
	else
	{
		header('Location: ' . $url);
		die();
	}
}
$custForm= new CustomForm('Tenders',$tenderID);
$custTable= new CustomTable('Tenders',$tenderID);

?>
<div id="main" role="main">

	<!-- Start CUSTOM CODE-->

	<!-- RIBBON -->
	<div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment"> 
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span> 
				</span>

		<!-- breadcrumb -->
		<ol class="breadcrumb">
			<li class="txt-color-white">Home / View Tender</li>
		</ol>
		<!-- end breadcrumb -->

	</div>
	<!-- END RIBBON -->
	<!-- MAIN CONTENT -->
	<div id="content">

		<div class="row">
			<div class="col-xs-12 col-sm-8 col-md-9 col-lg-8">

                 <h3 class="page-title txt-color-blueDark header-margin">
                     <i class="glyphicon glyphicon-comment"></i>
                     View Tender
                 </h3>

			</div>
            <div class='col-xs-12 col-sm-4 col-md-3 col-lg-2'>
                <form method='POST' action='//<?php echo HTML_PATH?>/cop/backend/core/templates/xls/generateTenderXLS.php' target='_blank' >
                    <input type='hidden' name='tenderID' value='<?php echo $tenderID?>'/>
                    <input type='hidden' name='tenderCode' value='<?php echo $tenderCode?>'/>
                    <input type='submit' class='show-stat-buttons btn btn-waybill' style='text-transform: capitalize;'id='orderXLSButton' value='Generate Excel'/>
                </form>
            </div>
			<div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
                    <?php
                    if(file_exists(ROOT."media/pdfs/tenders/Tender$tenderCode.pdf")){
                        echo "<form method='POST' action='//" . HTML_PATH . "/cop/readPDF.php' target='_blank' >
                                <input type='hidden' name='code' value='$tenderCode'/>
                                <input type='hidden' name='type' value='tenders'/>
                                <button type='submit' class='show-stat-buttons btn btn-tender btn-block' style='text-transform: capitalize;'id='invoicePDFButton'><i class='fa fa-file-pdf-o'></i>&nbsp; View PDF</button>
                              </form>";
                    } else {
                        echo "<form method='POST' action='//" . HTML_PATH . "/cop/backend/core/templates/pdf/generateTenderPDF.php' target='_blank' >
                                <input type='hidden' name='tenderID' value='$tenderID'/>
                                <input type='hidden' name='tenderCode' value='$tenderCode'/>
                                <button type='submit' class='show-stat-buttons btn btn-tender btn-block' style='text-transform: capitalize;'id='invoicePDFButton'><i class='fa fa-file-pdf-o'></i>&nbsp; Create PDF</button>
                              </form>";
                    }
                    ?>
			</div>


		</div>

		<!-- row -->
		<section id="widget-grid" class="">

			<div class="row">


				<!-- NEW WIDGET START -->
				<!-- NEW WIDGET START -->
				<article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

					<div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-5" data-widget-editbutton="false" data-widget-deletebutton="false">
						<header>

							<span class="widget-icon"> <i class="fa fa-table"></i> </span>
							<h2>Tender Details</h2>


						</header>

						<!-- widget div-->
						<div>

							<!-- widget content -->
							<div class="widget-body">

								<div>

									<form action="" id="checkout-form" class="smart-form no-padding">

										<fieldset class="no-padding">
											<div class="row">
												<section class="col col-4 no-margin" >
													<section>
														<img class="custom-rounded-image-padding tender" style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/tendericon.png" width="35" height="22">
														<h1 style="display: inline;margin-left:6px;vertical-align: middle"> Tender Details</h1>
                                                        <?php

                                                        if(isset($tenderCode) && strcmp($tenderCode,'')!=0){
                                                            require_once(ROOT . "backend/core/model/CopNavigation.php");

                                                            $where='';
                                                            if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0){
                                                                $where .= "customer_id IN (".$_SESSION['Allow_Customers'].")";
                                                            }

                                                            $navigation = new CopNavigation("Tenders","view_tender","$tenderCode","$where");
                                                            $navigation->simpleNavigationTable("tenderID");
                                                        }


                                                        ?>
													</section>
													<section class="no-margin">
														<div class="">
															<label class="label-bold form-label-space" >Tender Number: </label>
															<label class="label-text" ><?php echo $tenderCode?> </label>
														</div>

													</section class="no-margin">
													<section class="no-margin">
														<label class="label-bold form-label-space" > Tender Date:</label>
														<label class="label-text"> <?php  echo date('d-m-Y',strtotime($tenderDate))?></label>
													</section>
													<section class="no-margin">
														<label class="label-bold form-label-space" > Valid Until:</label>
														<label class="label-text"> <?php echo $validUntil?></label>
													</section>
                                                    <section class="no-margin">
                                                        <label class="label-bold form-label-space" > Sales Person:</label>
                                                        <label class="label-text"> <?php echo "$salespersonCode - $salespersonFirstName $salespersonLastName"?></label>
                                                    </section>
													<section class="no-margin">
														<label class="label-bold form-label-space" > Notes:</label>
														<label class="label-text"> <?php echo $details?></label>
													</section>
                                                    <?php if(isset($map)){echo $map;}?>

												</section>
												<section class="col col-4 no-margin" style="padding-left:20px;border-left:1px dotted #ADD8E6;border-right:1px dotted #ADD8E6;">
													<section>
														<img style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/customerdefault.jpg" width="40" height="40">
														<h1 style="display: inline;margin-left:6px;vertical-align: middle"> Customer Details</h1>
													</section>
													<section class="no-margin" >
														<div class="">
															<label class="label-bold form-label-space" >Customer Code: </label>
															<label class="label-text"><?php echo $customerCode?> </label>
														</div>

													</section>
													<section class="no-margin">
														<label class="label-bold form-label-space" > Customer Name: </label>
														<label class="label-text"> <?php echo $customerName?> </label>

													</section>

													<section class="no-margin">
														<label class="label-bold form-label-space" style="display: block;" > Tender Address: </label>
														<label class="label-text"> <?php echo $tenderAddress?> </label>
													</section>

												</section>

												<section class="col col-4 no-margin" style="padding-left:20px;">
													<section>
														<img class="custom-rounded-image-padding tender" style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/tendericon.png" width="35" height="22">
														<h1 style="display: inline;margin-left:6px;vertical-align: middle"> Actions</h1>

													</section>
													<section>
														<?php echo $cancelButton?>
													</section>
                                                    <?php
                                                    $custForm->viewCustomFormValues();
                                                    $custTable->viewCustomTableValues();

                                                    ?>
												</section>
												<div>
										</fieldset>
									</form>

								</div>

								<div>



									<h1> Tender Products</h1>
                                    <div style="width:100%; overflow-x: scroll;">
									<table id="datatable_fixed_column" class="table table-striped table-hover dataTable" width="100%">

										<thead>

										<tr>
											<th class='text-center'>Item Code</th>
											<th class='text-center'>Details</th>
											<th class='text-center'>Unit Price</th>
											<th class='text-center'>Qty</th>
											<th class='text-center'>VAT Percent</th>
											<th class='text-center'>Line Total</th>
										</tr>
										</thead>

										<tbody>
										<?php

                                        global $username, $password, $database;
										require(ROOT . "concc/dbhelpers/functions/subunitsFunctions.php");


										$db = new mysqli(localhost,$username,$password,$database);
										if (mysqli_connect_errno()) {
											printf("Connect failed: %s\n", mysqli_connect_error());
											exit();
										}
										$db->set_charset("utf8");
										// WHERE compani code in  Session
										$stm = $db->prepare("SELECT tender_item_id,tender_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,description,timestamp FROM Tender_Item WHERE tender_id='$tenderID'");
										$stm-> execute();
										$stm-> bind_result($tenderItemID,$tender_id,$itemID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount,$pricetypeID,$vatID,$description,$timestamp);
										while ($stm->fetch()) {
											echo"<tr>";
											// WHERE compani code in  Session
											$db2 = new mysqli(localhost,$username,$password,$database);
											if (mysqli_connect_errno()) {
												printf("Connect failed: %s\n", mysqli_connect_error());
												exit();
											}
											$db2->set_charset("utf8");
											$stm2 = $db2->prepare("SELECT item_code,name FROM Items WHERE item_id='$itemID'");
											$stm2-> execute();
											$stm2-> bind_result($itemCode,$name);
											while ($stm2->fetch()) {
												echo"<td class='text-center'><label> $itemCode</label> </td>";
												echo"<td class='text-center'><label> $name   $description</label> </td>";
											}
											$stm2->close();
                                            $unitPriceDisplay=number_format($unitPrice,2);
											echo"<td class='text-center'><label> $unitPriceDisplay</label> </td>";

											$subunits = getSubUnits($itemID);
											if($subunits==1)
											{
												echo"<td class='text-center'><label> $qty</label> </td>";
											}
											else
											{

												$msg = displayQty($qty,$subunits);
												echo"<td class='text-center'><label> $msg</label> </td>";
											}


											$stm3 = $db2->prepare("SELECT percentage FROM Vats WHERE vat_id='$vatID'");
											$stm3-> execute();
											$stm3-> bind_result($percentage);
											while ($stm3->fetch()) {
												echo"<td class='text-center'><label> $percentage %</label> </td>";
											}
											$stm3->close();

											$discount = $lineDiscount+$globalDiscount;
											$lineTotal=0;
											$subunits = getSubUnits($itemID);
											if($subunits==1)
											{
												$lineTotal= $unitPrice*$qty;
												$vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;



											}
											else
											{

												$units = getUntis($qty,$subunits);
												$sub = getSub($qty,$subunits);
												$lineTotal = $unitPrice*$units+ $unitPrice*$sub/$subunits;

												$vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;



											}





											$lineTotal=number_format($lineTotal,2);
											echo"<td class='text-center'><label> $lineTotal</label> </td>";


											echo"</td>";
											echo"</tr>";
										}
										$stm->close();

										$subtotal=number_format($subtotal,2);
										$discountAmount=number_format($discountAmount,2);
										$totalVatAmount=number_format($totalVatAmount,2);
										$grandTotal=number_format($grandTotal,2);


										?>

										</tbody>

									</table>
                                    </div>

								</div>

								<div class="row">

									<div class="col-sm-9 col-md-9 col-lg-9">

									</div>
                                    <div class="col-xs-12 col-sm-3" style="padding-right:20px;margin-bottom: 10px;">
										<div>
											<div class="font-md">
												<strong>Subtotal :</strong>
												<span class="pull-right"><?php echo currencySymbol . $subtotal?> </span>
											</div>

										</div>

										<div>
											<div class="font-md">
												<strong>Discount :</strong>
												<span class="pull-right"> - <?php echo $discountAmount?> </span>
											</div>

										</div>
										<div>
											<div class="font-md">
												<strong>VAT :</strong>
												<span class="pull-right"> + <?php echo $totalVatAmount?> </span>
											</div>

										</div>
										<br>
										<div class="well well-sm  bg-color-darken txt-color-white no-border">
											<div class="fa-lg">
												Grand Total :
												<span class="pull-right"><?php echo currencySymbol . $grandTotal?></span>
											</div>
										</div>
										<br>
										<br>
									</div>
								</div>
							</div>
							<!-- end widget content -->

						</div>
						<!-- end widget div -->

                        <?php
                            if($tenderID > 0){
                                require_once(ROOT . "backend/core/model/ActionReplies.php");
                                $actionReplies = new ActionReplies('Tender',$tenderID);
                                echo $actionReplies->toggleButton();
                                echo $actionReplies->repliesForm();
                            }
                        ?>

					</div>
					<!-- end widget -->





			</div>














			<!-- end row -->

		</section>





















	</div>
</div>


<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/jquery.dataTables.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/notification/SmartNotification.min.js"></script>

<script type="text/javascript">

    function viewPDF(url)
    {
        if(urlExists(url))
        {
            window.open(url, '_blank');
        }
        else
        {
            alert("PDF not created on the Mobile Device, please create the PDF and then sync to the Cloud");
        }
    }

    function urlExists(url)
    {
        var http = new XMLHttpRequest();
        http.open('HEAD', url, false);
        http.send();
        return http.status!=404;
    }

	$(document).ready(function() {

		pageSetUp();

		$("#cancelTenderButton").click(function(){

			var tenderid = <?php echo "$tenderID"; ?>;

			$("#cancelTenderButton").hide();

			$.ajax({
				type: "POST",
				url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/delete/cancelTender.php",
				data: {tenderID:tenderid},
				success: function(result){
					$.smallBox({
						title : "Success!",
						content : "Tender Successfully Cancelled",
						color : "#739E73",
						timeout: 3000,
						icon : "fa fa-user swing animated"
					});
                    window.location.href="//<?php echo HTML_PATH ?>/cop/backend/core/views/manage/manage_tenders.php";
				}});
		});

		$("#chooseParentSelect").select2({
			placeholder: "No Parent Selected",
			allowClear: true

		});

		var responsiveHelper_dt_basic = undefined;
		var responsiveHelper_datatable_fixed_column = undefined;
		var responsiveHelper_datatable_col_reorder = undefined;
		var responsiveHelper_datatable_tabletools = undefined;

		var breakpointDefinition = {
			tablet : 1024,
			phone : 480
		};

		/* COLUMN FILTER  */
		var otable = $('#datatable_fixed_column').DataTable({
			"sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' T C l>r>"+
			"t"+
			"<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
			"autoWidth" : true,
			"oTableTools": {
				"aButtons": [
					"copy",
					"csv",
					"xls",
					{
						"sExtends": "pdf",
						"sTitle": "Coprime PDF",
						"sPdfMessage": "Coprime PDF Export",
						"sPdfSize": "letter"
					},
					{
						"sExtends": "print",
						"sMessage": "Generated by Coprime<i>(press Esc to close)</i>"
					}
				],
				"sSwfPath": "js/plugin/datatables/swf/copy_csv_xls_pdf.swf"
			},
			"preDrawCallback" : function() {
				// Initialize the responsive datatables helper once.
				if (!responsiveHelper_datatable_fixed_column) {
					responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
				}
			},
			"rowCallback" : function(nRow) {
				responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
			},
			"drawCallback" : function(oSettings) {
				responsiveHelper_datatable_fixed_column.respond();
			}

		});

		// Apply the filter
		$("#datatable_fixed_column thead th input[type=text]").on( 'keyup change', function () {

			otable
				.column( $(this).parent().index()+':visible' )
				.search( this.value )
				.draw();

		} );
		/* END COLUMN FILTER */


		/* COLUMN FILTER  */
		var otable2 = $('#datatable_fixed_column2').DataTable({
			"sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' T C l>r>"+
			"t"+
			"<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
			"autoWidth" : true,
			"oTableTools": {
				"aButtons": [
					"copy",
					"csv",
					"xls",
					{
						"sExtends": "pdf",
						"sTitle": "Coprime PDF",
						"sPdfMessage": "Coprime PDF Export",
						"sPdfSize": "letter"
					},
					{
						"sExtends": "print",
						"sMessage": "Generated by Coprime<i>(press Esc to close)</i>"
					}
				],
				"sSwfPath": "js/plugin/datatables/swf/copy_csv_xls_pdf.swf"
			},
			"preDrawCallback" : function() {
				// Initialize the responsive datatables helper once.
				if (!responsiveHelper_datatable_fixed_column) {
					responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column2'), breakpointDefinition);
				}
			},
			"rowCallback" : function(nRow) {
				responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
			},
			"drawCallback" : function(oSettings) {
				responsiveHelper_datatable_fixed_column.respond();
			}

		});

		// Apply the filter
		$("#datatable_fixed_column2 thead th input[type=text]").on( 'keyup change', function () {

			otable2
				.column( $(this).parent().index()+':visible' )
				.search( this.value )
				.draw();

		} );
		/* END COLUMN FILTER */



	})

</script>



<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>