<?php
include_once("../../../../param.php");

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$whereSP = '';
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    $whereSP .= " WHERE salesperson_id IN (".$_SESSION['Allow_Salespersons'].")";
}

$stm = $db->prepare("SELECT CONCAT(salesperson_code, ' - ',first_name, ' ', last_name), salesperson_id FROM SalesPersons $whereSP");
$stm-> execute();
$stm-> bind_result($salespersonName, $salespersonID);
while ($stm->fetch()) {
    $salespersonSelection .= "<option value='$salespersonID'>$salespersonName</option>";
}

$stm = $db->prepare("SELECT reason FROM Visit_Reasons WHERE 1=1");
$stm-> execute();
$stm-> bind_result($visitReason);
while ($stm->fetch()) {
    $visitReasonOptions .= "<option value='$visitReason%'>$visitReason</option>";
}

$stm-> close();

function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}
?>

<div id="main" role="main" class="background-color-whitish">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Reports / Single  Report</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
                <span>  <a onclick="backToReports()" class="btn btn-primary"><i class="fa fa-arrow-left"></i>&nbsp; Back to Reports</a> </span>
                <h3 style="display:inline;margin-left:10px;" class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-signal"></i>
                    Reports
                </h3>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="" style="margin-top:10px;">
            <!-- row -->
            <div class="row">

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Salesperson Report Criteria</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">
                                <label style="display: block"><b>Select Date Range:</b></label>
                                <input type="date" name="dateFrom" id="dateFrom" class="form-control" style="display: inline-block;width: 25%" value="<?php echo date('Y-m-d')?>" >
                                <input type="date" name="dateTo" id="dateTo" class="form-control" style="display: inline-block;width: 25%" value="<?php echo date('Y-m-d')?>">
                                <label style="display: block; margin-top: 10px"><b>Select Sales Person:</b></label>
                                <select name="salesPerson" id="salesPerson" class="form-control" style="width: 50%">
                                    <?php echo $salespersonSelection; ?>
                                </select>
                                <label style="display: block; margin-top: 5px;"><b>Hide Analytic Action Lines:</b></label>
                                <select name="hideLines" id="hideLines" class="form-control" style="width: 50%">
                                    <option value="no">No</option>
                                    <option value="yes">Yes</option>
                                </select>
                                <label style="display: block; margin-top: 5px;"><b>Include Coordinates:</b></label>
                                <select name="coordinates" id="coordinates" class="form-control" style="width: 50%">
                                    <option value="no">No</option>
                                    <option value="yes">Yes</option>
                                </select>

                                <label style="display: block; margin-top: 5px;"><b>Filter Visit Reasons:</b></label>
                                <select name="visitReasonsFilter" id="visitReasonsFilter" class="form-control" style="width: 50%" multiple="multiple">
                                    <?php echo $visitReasonOptions;?>
                                </select>
                                <label style="display: block; margin-top: 5px;"><b>Select Actions:</b></label>
                                <table style="width: 50%;margin-bottom: 30px;border: 1px solid lightgrey;">
                                    <tr>
                                        <td><label style="display: block; margin-top: 5px;"><b>Tenders</b></label></td>
                                        <td><label style="display: block; margin-top: 5px;"><b>Orders</b></label></td>
                                        <td><label style="display: block; margin-top: 5px;"><b>Waybills</b></label></td>
                                        <td><label style="display: block; margin-top: 5px;"><b>Invoices</b></label></td>
                                        <td><label style="display: block; margin-top: 5px;"><b>Returns</b></label></td>
                                        <td><label style="display: block; margin-top: 5px;"><b>Receipts</b></label></td>
                                        <td><label style="display: block; margin-top: 5px;"><b>Visits</b></label></td>
                                        <td><label style="display: block; margin-top: 5px;"><b>Warehouse<br>Transfers</b></label></td>
                                    </tr>
                                    <tr >
                                        <td><input type="checkbox" class="form-control" id="incTenders"  value="yes"></td>
                                        <td><input type="checkbox" class="form-control" id="incOrders"   value="yes"></td>
                                        <td><input type="checkbox" class="form-control" id="incWaybills" value="yes"></td>
                                        <td><input type="checkbox" class="form-control" id="incInvoices" value="yes"></td>
                                        <td><input type="checkbox" class="form-control" id="incReturns"  value="yes"></td>
                                        <td><input type="checkbox" class="form-control" id="incReceipts" value="yes"></td>
                                        <td><input type="checkbox" class="form-control" id="incVisits"   value="yes"></td>
                                        <td><input type="checkbox" class="form-control" id="incWHTransfers"   value="yes"></td>
                                    </tr>
                                    <tr ><td colspan="7">&nbsp;</td></tr>
                                </table>

                                <button type="button" name="generateReport" id="generateReport" class="btn btn-primary" onclick="getReport()" >Generate Report</button>
                                <button type="button" name="generateExcel"  id="generateExcel"  class="btn btn-waybill" onclick="exportXLS()" >Export to Excel</button>
                                <button type="button" name="generatePDF"    id="generatePDF"    class="btn btn-danger"  onclick="exportPDF()" >Export PDF</button>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Schedule Report</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">

                            <div name="reportResult" id="reportResult"></div>
                                <form method="POST" action="#" name="xlsForm" id="xlsForm" >
                                    <input type="hidden" name="inputResult" id="inputResult" value=""/>
                                    <input type="hidden" name="inputTitle" id="inputTitle" value="SalespersonAction"/>
                                </form>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

            </div>


    </div>
    <!-- end widget content -->

    <!-- end row -->
    </section>

</div>

<script type="text/javascript">

    $(document).ready(function() {

        pageSetUp();
        $('#visitReasonsFilter').select2();
        $('#visitReasonsFilter').change(function(){
            $('#incVisits').prop( "checked", true );
        });


    });

    function getReport(){

        var salesperson = $('#salesPerson').val();
        var dateFrom    = $('#dateFrom').val();
        var dateTo      = $('#dateTo').val();
        var coordinates = $('#coordinates').val();
        var hideLines   = $('#hideLines').val();
        var visitReasonsFilter   = $('#visitReasonsFilter').val();


        var incTenders  = $('#incTenders:checked').val();
        var incOrders   = $('#incOrders:checked').val();
        var incWaybills = $('#incWaybills:checked').val();
        var incInvoices = $('#incInvoices:checked').val();
        var incReturns  = $('#incReturns:checked').val();
        var incReceipts = $('#incReceipts:checked').val();
        var incVisits   = $('#incVisits:checked').val();

        var incWHTransfers   = $('#incWHTransfers:checked').val();

        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateSalespersonActionReport.php',
            data: {
                'coordinates':coordinates,
                'salesperson':salesperson,
                'dateFrom':dateFrom,
                'dateTo':dateTo,
                'incTenders':incTenders,
                'incOrders':incOrders,
                'incWaybills':incWaybills,
                'incInvoices':incInvoices,
                'incReturns':incReturns,
                'incReceipts':incReceipts,
                'incWHTransfers':incWHTransfers,
                'hideLines':hideLines,
                'visitReasonsFilter':visitReasonsFilter,
                'incVisits':incVisits

            },

            success: function (result) {
                $('#reportResult').html(result);
            }
        });

    }

    function exportXLS(){

        var coordinates = $('#coordinates').val();
        var salesperson = $('#salesPerson').val();
        var dateFrom    = $('#dateFrom').val();
        var dateTo      = $('#dateTo').val();
        var hideLines   = $('#hideLines').val();
        var visitReasonsFilter   = $('#visitReasonsFilter').val();


        var incTenders  = $('#incTenders:checked').val();
        var incOrders   = $('#incOrders:checked').val();
        var incWaybills = $('#incWaybills:checked').val();
        var incInvoices = $('#incInvoices:checked').val();
        var incReturns  = $('#incReturns:checked').val();
        var incReceipts = $('#incReceipts:checked').val();
        var incVisits   = $('#incVisits:checked').val();

        var incWHTransfers   = $('#incWHTransfers:checked').val();

        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateSalespersonActionReport.php',
            data: {
                'coordinates':coordinates,
                'salesperson':salesperson,
                'dateFrom':dateFrom,
                'dateTo':dateTo,
                'incTenders':incTenders,
                'incOrders':incOrders,
                'incWaybills':incWaybills,
                'incInvoices':incInvoices,
                'incReturns':incReturns,
                'incReceipts':incReceipts,
                'incWHTransfers':incWHTransfers,
                'hideLines':hideLines,
                'visitReasonsFilter':visitReasonsFilter,
                'incVisits':incVisits

            },

            success: function (result) {
                $('#reportResult').html(result);
                $('#inputResult').val(result);
                $('#xlsForm').attr('action','//<?php echo HTML_PATH ?>/cop/backend/core/templates/xls/generateGeneralXLS.php').submit();
            }
        });


    }

    function exportPDF(){

        var coordinates = $('#coordinates').val();
        var salesperson = $('#salesPerson').val();
        var dateFrom    = $('#dateFrom').val();
        var dateTo      = $('#dateTo').val();
        var hideLines   = $('#hideLines').val();
        var visitReasonsFilter   = $('#visitReasonsFilter').val();


        var incTenders  = $('#incTenders:checked').val();
        var incOrders   = $('#incOrders:checked').val();
        var incWaybills = $('#incWaybills:checked').val();
        var incInvoices = $('#incInvoices:checked').val();
        var incReturns  = $('#incReturns:checked').val();
        var incReceipts = $('#incReceipts:checked').val();
        var incVisits   = $('#incVisits:checked').val();

        var incWHTransfers   = $('#incWHTransfers:checked').val();

        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateSalespersonActionReport.php',
            data: {
                'coordinates':coordinates,
                'salesperson':salesperson,
                'dateFrom':dateFrom,
                'dateTo':dateTo,
                'incTenders':incTenders,
                'incOrders':incOrders,
                'incWaybills':incWaybills,
                'incInvoices':incInvoices,
                'incReturns':incReturns,
                'incReceipts':incReceipts,
                'incWHTransfers':incWHTransfers,
                'hideLines':hideLines,
                'visitReasonsFilter':visitReasonsFilter,
                'incVisits':incVisits

            },

            success: function (result) {
                $('#reportResult').html(result);
                $('#inputResult').val(result);
                $('#xlsForm').attr('action','//<?php echo HTML_PATH ?>/cop/backend/core/templates/pdf/generatePDFFromHTML.php').submit();
            }
        });


    }

    function backToReports() {
        try {
            $(".swLinkMenu")[0].click();
        }
        catch(err)
        {

        }

        setTimeout(function() {
            window.location = "reports_list.php";
        }, 1000);


    }

</script>


