<?php
include_once("../../../../param.php");
require_once(ROOT . 'libs/mPDF/vendor/autoload.php');


function getWaybillPDFForPrinting($orderID)
{
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT waybill_code,waybill_date,paymenttype_id,salesperson_id,subtotal,grand_total,vat_amount,customer_id,company_id,waybill_address_id,delivery_address_id,currency_id FROM Waybills WHERE waybill_id='$orderID'");
    $stm->execute();
    $stm->bind_result($orderCode, $orderDate, $paymentTypeID,$salespersonID,$subtotal, $grandTotal, $vatAmount,$customerID,$companyID,$orderAddressID,$deliveryAddress,$currencyID);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT currency_id,currency_code,currency_sign FROM Display_Currency WHERE currency_id='$currencyID' LIMIT 1");
    $stm->execute();
    $stm->bind_result($displayCurrencyID,$displayCurrencyCode,$displayCurrencySign);
    while ($stm->fetch()) {}
    $stm->close();

    if(strcmp($displayCurrencySign,'')==0){
        $stm = $db->prepare("SELECT currency_id,currency_code,currency_sign FROM Display_Currency ORDER BY default_currency DESC LIMIT 1");
        $stm->execute();
        $stm->bind_result($displayCurrencyID,$displayCurrencyCode,$displayCurrencySign);
        while ($stm->fetch()) {}
    }



    $orderDate = date_format( date_create_from_format('Y-m-d', $orderDate), 'd-m-Y');


    $subtotal = number_format($subtotal,2);
    $grandTotal = number_format($grandTotal,2);
    $vatAmount = number_format($vatAmount,2);


    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
    $stm->execute();
    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$orderAddressID'");
    $stm->execute();
    $stm->bind_result($addressLine1, $addressLine2,$postcode,$city,$landline);

    while ($stm->fetch()) {


    }
    $stm->close();

    $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$deliveryAddress'");
    $stm->execute();
    $stm->bind_result($addressLine1D, $addressLine2D,$postcodeD,$cityD,$landlineD);
    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT name FROM PaymentTypes WHERE paymenttype_id='$paymentTypeID'");
    $stm->execute();
    $stm->bind_result($paymentType);

    while ($stm->fetch()) {


    }
    $stm->close();

    $stm = $db->prepare("SELECT salesperson_code FROM SalesPersons WHERE salesperson_id='$salespersonID'");
    $stm->execute();
    $stm->bind_result($salespersonDisplayName);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT CONCAT(warehouse_code,' - ',name) FROM Warehouses,Waybill_Item WHERE Warehouses.warehouse_id=Waybill_Item.warehouse_id AND waybill_id=$orderID");
    $stm->execute();
    $stm->bind_result($warehouseDisplay);

    while ($stm->fetch()) {


    }
    $stm->close();
    $displayDate =$orderDate;



    $result= "



<style>


        body
        {


        }

        p
        {

        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {

        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_body
        {

        }

        td {
          font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;
        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size: 11px;
            border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

        #table_info td {
           font-size: 12px;
           padding:0;

        }

    </style>


<htmlpageheader name='myHTMLHeader1'>
  <table class='heading' >
  <tr>
  <td valign='top' style='width:33%'>
      <img style='max-width: 200px;' src='//" . HTML_PATH . "/cop/media/pdfimage/logo.png'/>
  </td>
  <td  valign='top' style='width:33%' align='center'>
     <p style='font-weight:bold; font-size:22px;'>Waybill</p>
  </td>
  <td valign='top' style='width:33%' align='right'>
     <h1 class='heading' style='padding-top:2px;padding-bottom:2px;'>$line1</h1>
                <h2 class='heading'>
                    $line2<br/>
                    $line3<br/>
                    $line4<br/>
                    $line5<br/>
                    $line6<br/>
                    $line7
                </h2>
  </td>
   </tr>
  </table>

</htmlpageheader>

<table id='table_info' style='width:100%;margin-top:0;padding-top:0;'>
        <tr>
             <td rowspan='2' valign='top' align='left' style='width:33%'>
                <h4>Waybill Details</h4>
                <table>
                    <tr><td>Waybill No: </td><td>$orderCode</td></tr>
                    <tr><td>Waybill Date: </td><td>$displayDate</td></tr>
                    <tr><td >Due Date : </td><td>$dueDate</td></tr>
                    <tr><td >Payment Method: </td><td>$paymentType</td></tr>
                    <tr><td >Salesperson Code: </td><td>$salespersonDisplayName</td></tr>
                    <tr><td >Store : </td><td>$warehouseDisplay</td></tr>
                </table>
            </td>
                     <td rowspan='1' valign='top' align='center' style='width:33%'>
                      <h4 >Billing Address</h4>
                <table>
                  <tr><td >Account Code: $customerCode</td></tr>
                    <tr><td style='text-align: center'>$customerName</td></tr>
                    <tr><td style='text-align: center'>$addressLine1</td></tr>
                    <tr><td style='text-align: center'>$addressLine2</td></tr>
                    <tr><td style='text-align: center'>$city</td></tr>
                    <tr><td style='text-align: center'>$landline</td></tr>
                </table>
            </td>
             <td rowspan='1' valign='top' align='right' style='width:33%'>
              <h4 >Delivery Address</h4>
                <table>
                    <tr><td>Account Code: $customerCode</td></tr>
                    <tr><td style='text-align: right'>$customerName</td></tr>
                    <tr><td style='text-align: right'>$addressLine1D</td></tr>
                    <tr><td style='text-align: right'>$addressLine2D</td></tr>
                    <tr><td style='text-align: right'>$cityD</td></tr>
                    <tr><td style='text-align: right'>$landlineD</td></tr>
                </table>
            </td>

        </tr>

    </table>

   <div id='item_table' style='height:500px;'>

   <div style='height:500px;'>

     <table repeat_header='1' id='tableHeader' style='border-top: 1px solid #a7c6f9;border-bottom: 1px solid #a7c6f9;padding:0;background:#cadbf7;'>
            <tr>
                <td style='width:5%' ><b>No.</b></td>
                <td style='width:15%'><b>Code</b></td>
                <td style='width:25%'><b>Description</b></td>
                <td style='width:10%;text-align:center;'><b>UOM</b></td>
                <td style='width:8%;text-align: right'><b>Quantity</b></td>
                <td style='width:15%;text-align: right'><b>Unit Price</b></td>
                <td style='width:10%;text-align:center;'><b>VAT</b></td>
                <td style='width:12%;text-align: right'><b>Total</b></td>
            </tr>
            </table>


            <table style='overflow:hidden;width:100%'>

            ";

    $vatsArray = Array();
    $stm = $db->prepare("SELECT vat_id,vat_code,percentage FROM Vats");
    $stm->execute();
    $stm->bind_result($vatID,$vatCode,$percentage);
    while ($stm->fetch()) {
        $vatObject = new stdClass();
        $vatObject->id=$vatID;
        $vatObject->code=$vatCode;
        $vatObject->percentage=$percentage;
        $vatObject->vatAmount=0;
        $vatObject->goods=0;
        array_push($vatsArray,$vatObject);
    }
    $stm->close();






    $counter = 0;
    $stm = $db->prepare("SELECT Waybill_Item.item_id,Items.sales_units,qty,subunits,unit_price,Items.vat_id,Vats.vat_code,Waybill_Item.vat_amount,item_code,name FROM Waybill_Item,Items,Vats WHERE Vats.vat_id = Waybill_Item.vat_id AND Waybill_Item.item_id=Items.item_id AND Waybill_Item.waybill_id='$orderID'");
    $stm->execute();
    $stm->bind_result($itemID, $uom,$qty, $subunits,$unitPrice, $vatID, $vatCode,$vatLineAmount,$itemCode, $name);

    $unitPrice = number_format(floatval($unitPrice),2);

    while ($stm->fetch()) {
        $counter++;
        $lineTotal = $unitPrice * $qty/$subunits;

        $unitPrice = number_format($unitPrice,2);
        $lineTotal = number_format($lineTotal,2);

        $result.= "<tr>
                <td style='width:5%;font-size:12px'> $counter</td >
                <td style='width:15%;font-size:12px' > $itemCode  </td >
                <td style='width:25%;font-size:12px'> $name </td >
                 <td style='width:10%;text-align:center;font-size:12px;'> $uom</td >
                <td style='width:8%;text-align:right;font-size:12px;'  > $qty</td >
                <td style='width:15%;text-align:right;font-size:12px' > $displayCurrencySign$unitPrice</td >
                <td style='width:10%;text-align:center;font-size:12px'> $vatCode</td >
                <td style='width:12%;text-align:right;font-size:12px'  > $displayCurrencySign$lineTotal</td >
            </tr >";

        foreach($vatsArray as $vatObject)
        {
            if($vatObject->id==$vatID)
            {
                $vatObject->vatAmount+=$vatLineAmount;
                $vatObject->goods+=$lineTotal;
            }
        }

    }
    $stm->close();

    $result.=
        "  </table>

        </div>";

    $result.=
        "




<htmlpagefooter name='myFooter1'>

 <div id='invoice_total' style='margin-top:20px;border-top: 1px solid #222;border-bottom: 1px solid #222;'>

           <table style='width: 100%'>
             <tr>
               <td style='width:50%;'>

               <table>
                  <tr>
                    <td style='text-align:center'>
                     <p style='display: inline;text-align:center;'><b> VAT Summary</b></p>
                    </td>
                 </tr>
                 </table>
                 <table>
                 <tr>
                   <td style='width:25%;text-align:center;'>
                       <p> Code</p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p > %</p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p > Goods:</p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p> VAT</p>
                   </td>
                 </tr>";


    foreach($vatsArray as $vatObject) {

        if($vatObject->goods>0) {

            $vatObject->goods = number_format($vatObject->goods,2);
            $vatObject->vatAmount = number_format($vatObject->vatAmount,2);
            $result .= "<tr>
                <td style='width:25%;font-size:12px;text-align:center;'> $vatObject->code</td >
                <td style='width:25%;font-size:12px;text-align:center;' > $vatObject->percentage  </td >
                <td style='width:25%;font-size:12px;text-align:center;'>  $displayCurrencySign$vatObject->goods </td >
                 <td style='width:25%;text-align:center;font-size:12px;'> $displayCurrencySign$vatObject->vatAmount</td >
            </tr >";
        }

    }


    $result.="
               </table>

              </td>
              <td style='width:20%'></td>
              <td  style='width:30%;'>
               <table>
                <tr>
                    <td style='text-align:right;font-weight:bold;'> Subtotal</td>
                    <td style='text-align:right;' >$displayCurrencySign$subtotal</td>
                </tr>
                <tr>
                    <td style='text-align:right;font-weight:bold'> Vat</td>
                    <td style='text-align:right;' >$displayCurrencySign$vatAmount</td>
                </tr>
                <tr>
                    <td style='text-align:right;font-weight:bold'> Grand Total</td>
                    <td style='text-align:right;' >$displayCurrencySign$grandTotal</td>
                </tr>
            </table>
              </td>
            </tr>
          </table>


        </div>

        <div>
          <p style='margin-top:5px;font-size:10px;font-family: Helvetica Neue, Helvetica, Arial, sans-serif'> Powered by Coprime Mobile Commerce: 25-311504 </p>
        </div>

        <div style='margin-top:30px;width:100%;'>
           <table style='width:100%;'>
               <tr>
                  <td style='width:50%;'>
                    <table style='width:100%;'>
                       <tr>
                       <td style='width:33%'>

                       </td>
                        <td style='border-top: 1px solid #000000;width:33%;text-align:center'>
                            <p style='font-size:11px;'>Seller Signature</p>
                       </td>
                        <td style='width:33%'>

                       </td>
                       </tr>
                    </table>
                  </td>
                 <td style='width:50%;'>
                    <table style='width:100%;'>
                       <tr>
                       <td style='width:33%'>

                       </td>
                        <td style='border-top: 1px solid #000000;width:33%;text-align:center'>
                            <p style='font-size:11px;'>Buyer Signature</p>
                       </td>
                        <td style='width:33%'>

                       </td>
                       </tr>
                    </table>
                  </td>
              </tr>
           </table>

        </div>


            <table width='100%' style='vertical-align: bottom; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 8pt;
                color: #000000;  '><tr>
                <td width='33%'><span style=''>{DATE d-m-Y}</span></td>
                <td width='33%' align='center' style=''>{PAGENO} of {nbpg}</td>
                <td width='33%' style='text-align: right; '>$orderCode</td>
                </tr></table>
            </htmlpagefooter>



";


    return $result;
}


$waybillID =$_POST['waybillID'];
$waybillCode =$_POST['waybillCode'];
$result = getWaybillPDFForPrinting($waybillID);


$mpdf=new mPDF();
//$mpdf->SetHTMLHeaderByName('myHTMLHeader1');
$mpdf->setAutoTopMargin='stretch';
$mpdf->setAutoBottomMargin='stretch';
$mpdf->keep_table_proportions=true;

$mpdf->WriteHTML($result);

$mpdf->Output("$waybillCode.pdf","I");




?>