<?php
include_once("../../../../param.php");

$schedule    = trim($_POST['schedule']);
$salesperson = trim($_POST['salesperson']);
$day =  trim($_POST['day']);
$report = '';
$filter = '';

header("content-type: text/html;charset=utf-8");


if(strcmp($salesperson, '') != 0) {


    $scheduleObjects = array();

    if(strcmp($schedule, '')!=0){
        $filter  .= "AND Schedules.schedule_id = '$schedule'";
    }

    if (strcmp($day, '') != 0 ) {
        $filter .= "AND (Schedules.day = '$day' OR Schedules.repeat_period=1 AND Schedules.day = 0)";
    }

    if (strcmp($salesperson, '0') != 0) {
        $filter .= "AND Schedule_Salesperson.salesperson_id  = '$salesperson'";
    }


    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT Schedules.schedule_id,
                                      Schedules.name,
                                      Schedules.date,
                                      Schedules.type,
                                      Schedules.repeat_period,
                                      Schedules.day,
                                      Schedules.week,
                                      Schedules.month,
                                      Schedules.notes,
                                      Customers.customer_id,
                                      Customers.customer_code,
                                      Customers.customer_company_name,
                                      Schedule_Salesperson.salesperson_id,
                                      SalesPersons.salesperson_code,
                                      SalesPersons.first_name,
                                      SalesPersons.last_name,
                                      Schedule_Customer.position
                                FROM Schedules 
                                LEFT JOIN Schedule_Customer on Schedules.schedule_id = Schedule_Customer.schedule_id 
                                LEFT JOIN Schedule_Salesperson on Schedule_Salesperson.schedule_id = Schedules.schedule_id     
                                LEFT JOIN Customers on Schedule_Customer.customer_id = Customers.customer_id   
                                LEFT JOIN SalesPersons on Schedule_Salesperson.salesperson_id = SalesPersons.salesperson_id
                                WHERE 1=1 
                                $filter
                                ORDER BY Schedules.schedule_id DESC,Schedule_Customer.position ASC");
    $stm->execute();
    $stm->bind_result($sheduleID,
                       $sheduleName,
                            $scheduleDate,
                            $scheduleType,
                            $scheduleRepeatPeriod,
                            $scheduleDay,
                            $scheduleWeek,
                            $scheduleMonth,
                            $scheduleNotes,
                            $customerID,
                            $customerCode,
                            $customerName,
                            $salespersonID,
                            $salespersonCode,
                            $salespersonFirstName,
                            $salespersonLastName,
                            $customerPosition
                       );
    while ($stm->fetch()) {



        if($day > 0 && strcmp($scheduleType,'Single Date')==0){
            $weekday = getWeekday($scheduleDate);
            if($weekday != $day){continue;}
        }

        $scheduleDisplay = verbalConfiguration($scheduleDate,$scheduleDay,$scheduleWeek,$scheduleMonth,$scheduleType,$scheduleRepeatPeriod);


        $scheduleObjects["$sheduleID"]['id'] = $sheduleID;
        $scheduleObjects["$sheduleID"]['name'] = $sheduleName;
        $scheduleObjects["$sheduleID"]['date'] = $scheduleDate;
        $scheduleObjects["$sheduleID"]['type'] = $scheduleType;
        $scheduleObjects["$sheduleID"]['verbal'] = $scheduleDisplay;

        $scheduleCustomers["$sheduleID"]["$customerID"]['code'] = $customerCode;
        $scheduleCustomers["$sheduleID"]["$customerID"]['name'] = $customerName;
        $scheduleCustomers["$sheduleID"]["$customerID"]['position'] = $customerPosition;

        $scheduleSalespersons["$sheduleID"]["$salespersonID"]['code'] = $salespersonCode;
        $scheduleSalespersons["$sheduleID"]["$salespersonID"]['firstName'] = $salespersonFirstName;
        $scheduleSalespersons["$sheduleID"]["$salespersonID"]['lastName'] = $salespersonLastName;

        usort($scheduleCustomers["$sheduleID"], function($a, $b) {return $a['position'] - $b['position'];});



    }
    $stm->close();



    $result = "<table class='table table-bordered' style='width: 100%' >";
    foreach ($scheduleObjects as $scheduleObject) {


        $result .="<tr>";
        $result .="<td colspan='3' style='background-color: lightblue;border: 1px solid gray;'><center><h3><b>".$scheduleObject['name']."</h3></td>";
        $result .="</tr>";

        $result .="<tr>";
        $result .="<td style='background-color: lightblue;border: 1px solid gray'>Schedule Type</td>";
        $result .="<td colspan='2' style='border: 1px solid gray;background-color: whitesmoke'>".$scheduleObject['type']."</td>";
        $result .="</tr>";

        $result .="<tr>";
        $result .="<td style='background-color: lightblue;border: 1px solid gray'>Frequency</td>";
        $result .="<td colspan='2' style='border: 1px solid gray;background-color: whitesmoke'>".$scheduleObject['verbal']."</td>";
        $result .="</tr>";

//        $result .="<tr>";
//        $result .="<td colspan='3'>Customers</td>";
//        $result .="</tr>";

        $result .="<tr>";
        $result .="<td style='background-color: lightblue;border: 1px solid gray'>Salesperson(s)</td>";
        $result .="<td style='border: 1px solid gray;background-color: whitesmoke' colspan='2'>";

        foreach ($scheduleSalespersons[$scheduleObject['id']] as $scheduleSalespersonID => $scheduleSalesperson){

            $result .= $scheduleSalesperson['code']." - ".$scheduleSalesperson['firstName']." ".$scheduleSalesperson['lastName']."<br>";
        }
        $result .="</td></tr>";


        $result .="<tr style='background-color: lightblue'>";
        $result .="<td style='border: 1px solid gray'>Customer Position</td>";
        $result .="<td style='border: 1px solid gray'>Customer Code</td>";
        $result .="<td style='border: 1px solid gray'>Customer Name</td>";
        $result .="</tr>";

        foreach ($scheduleCustomers[$scheduleObject['id']] as $scheduleCustomerID => $scheduleCustomer){
            $result .="<tr>";
            $result .="<td style='border: 1px solid gray'><center>".$scheduleCustomer['position']."</td>";
            $result .="<td style='border: 1px solid gray'>".$scheduleCustomer['code']."</td>";
            $result .="<td style='border: 1px solid gray'>".$scheduleCustomer['name']."</td>";
            $result .="</tr>";
        }

        $result .="<tr style='border-color: transparent;'>";
        $result .="<td style='border-color: transparent;'>&nbsp;</td>";
        $result .="<td style='border-color: transparent;'>&nbsp;</td>";
        $result .="<td style='border-color: transparent;'>&nbsp;</td>";
        $result .="</tr>";

    }
    $result .= "</table>";


}

if(strcmp($result,'') == 0){$result = '<center><b>No Data Found</b></center>';}
echo $result;


function verbalConfiguration($scheduleDate,$scheduleDay,$scheduleWeek,$scheduleMonth,$scheduleType,$scheduleRepeatPeriod){

    $scheduleDisplay = '';

    $arrayDays  = array('0'=>'Day','1'=>'Monday','2'=>'Tuesday','3'=>'Wednesday','4'=>'Thursday','5'=>'Friday','6'=>'Saturday','7'=>'Sunday',);
    $arrayWeeks = array('0'=>'','1'=>'1st week','2'=>'2nd week','3'=>'3rd week','4'=>'4th week');
    $arrayDayWeeks = array('0'=>'','1'=>'1st','2'=>'2nd','3'=>'3rd','4'=>'4th');
    $arrayRepeatPeriod =  array('1'=>'','7'=>'','14'=>'Every Two Weeks','21'=>'Every Three Weeks','28'=>'Every Four Weeks');

    $scheduleDayWeeksDisplay = $arrayDayWeeks["$scheduleWeek"];
    $scheduleDayDisplay  = $arrayDays["$scheduleDay"];
    $scheduleWeekDisplay = $arrayWeeks["$scheduleWeek"];
    $scheduleRepeatPeriodDisplay = $arrayRepeatPeriod["$scheduleRepeatPeriod"];

    if($scheduleMonth == 0){
        if($scheduleWeek > 0) {
            $scheduleMonthDisplay = ' of every month';
        } else {
            $scheduleMonthDisplay = '';
        }
    } else {
        $scheduleMonthDisplay = "of ".date("F",mktime(0,0,0,$scheduleMonth,1,date('Y')));
    }

    if(strcmp($scheduleType,'Custom')==0){
        $scheduleDisplay = "Every $scheduleDayWeeksDisplay $scheduleDayDisplay $scheduleMonthDisplay";
    } else if(strcmp($scheduleType,'Single Date')!=0){
        $scheduleDisplay = "Every $scheduleDayDisplay $scheduleWeekDisplay $scheduleRepeatPeriodDisplay $scheduleMonthDisplay";
    } else {
        $scheduleDisplay = 'On '.date_format( date_create_from_format('Y-m-d', $scheduleDate), 'l d F Y');;
    }

    return $scheduleDisplay;

}

function getWeekday($date) {
    return date('w', strtotime($date));
}
?>