<div id="main" role="main">
    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">
        <span class="ribbon-button-alignment">
            <span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
                <i class="fa fa-refresh"></i>
            </span>
        </span>
        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Manage Stock Updates</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->





    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-8">
                <h3 class="page-title txt-color-blueDark" style="margin-top: 5px; margin-bottom: 15px;">
                    Stock Updates
                </h3>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="">

            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Stock Updates Table </h2>
                        </header>
                        <!-- widget div-->
                        <div>

                            <!-- widget content -->
                            <div class="widget-body no-padding">
                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTabl" width="100%">
                                    <thead>
                                        <tr>
                                           
                                            <th class="hasinput">
                                                <input type="text" class="form-control text-center" placeholder="Filter Warehouse Code" style="font-size: 12px;" />
                                            </th>
                                            <th class="hasinput">
                                                <input type="text" class="form-control text-center" placeholder="Filter Warehouse Name" style="font-size: 12px;" />
                                            </th>
                                            <th class="hasinput">
                                                <input type="text" class="form-control text-center" placeholder="Filter Item Code" style="font-size: 12px;" />
                                            </th>
                                             <th class="hasinput">
                                                <input type="text" class="form-control text-center" placeholder="Filter Batch Number" style="font-size: 12px;" />
                                            </th>
                                            
                                            <th class="hasinput">
                                                <input type="text" class="form-control text-center" placeholder="Filter Available" style="font-size: 12px;" />
                                            </th>
                                            <th class="hasinput">
                                                <input type="text" class="form-control text-center" placeholder="Filter Action Code" style="font-size: 12px;" />
                                            </th>
                                            <th class="hasinput">
                                                <input type="text" class="form-control text-center" placeholder="Filter Reason" style="font-size: 12px;" />
                                            </th>
                                            <th class="hasinput">
                                                <input type="text" id="fromDate" class="form-control text-center datepicker" placeholder="From Date" style="font-size: 12px;" />
                                                <input type="text" id="toDate" class="form-control text-center datepicker" placeholder="To Date" style="font-size: 12px; margin-top: 5px;" />
                                            </th>
                                            
                                            
                                        </tr>
                                        <tr>
                                            <th class="text-center">Warehouse Code</th>
                                            <th class="text-center">Warehouse Name</th>
                                            <th class="text-center">Item Code</th>
                                            <th class="text-center">Batch Number</th>
                                            <th class="text-center">Available</th>
                                            <th class="text-center">Action code</th>
                                            <th class="text-center">Reason</th>
                                            <th class="text-center">Time Stamp</th>

                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- WIDGET END -->
            </div>
            <!-- end row -->
        </section>

    </div>
</div>


<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>

<script type="text/javascript">



$(document).ready(function() {
    
    pageSetUp();
 

    var responsiveHelper_datatable_fixed_column = undefined;

    var breakpointDefinition = {
        tablet: 1024,
        phone: 480
    };

    /* COLUMN FILTER  */
    var otable = $('#datatable_fixed_column').DataTable({
        "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
        "autoWidth": true,
        "processing": false,
        "serverSide": true,
        "ajax": {
            "type": "GET",
            "url": "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/get/getStockUpdates.php",
            "data": function(data){
                    data.fromDate =  $('#fromDate').val();
                    data.toDate = $('#toDate').val();
                 }        
        },
        "columns": [
            { "data": "warehouse_code" },
            { "data": "warehouse_name" },
            { "data": "item_code" },
            { "data": "batch_number" },
            { "data": "available" },
            { "data": "action_code" },
            { "data": "reason" },
            { "data": "timestamp" }     
        ],
        "deferRender": true,
        "autoWidth": true,
        "buttons": [
            "copyHtml5",
            "excelHtml5",
            "csvHtml5",
            {
                extend: 'pdfHtml5',
                orientation: 'landscape',
                pageSize: 'LEGAL'
            }
        ],
        "preDrawCallback": function() {
            // Initialize the responsive datatables helper once.
            if (!responsiveHelper_datatable_fixed_column) {
                responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
            }
        },
        "rowCallback": function(nRow) {
            responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
        },
        "drawCallback": function(oSettings) {
            responsiveHelper_datatable_fixed_column.respond();
        }
    });

    // Apply the filter
    $("#datatable_fixed_column thead th input[type=text]").on('keyup change', function() {
        var filterID = $(this).attr('id');
        if(filterID !== undefined && ( filterID.localeCompare('fromDate') == 0 ||  filterID.localeCompare('toDate') == 0)){
             otable.draw();
        }
        else{
        otable
            .column($(this).parent().index() + ':visible')
            .search(this.value)
            .draw();
        }
    });
});
</script>

