<?php
include_once("../../../../param.php");

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT  pricetype_id, price_code, name     
                            FROM PriceTypes ORDER BY  price_code ASC");
$stm->execute();
$stm->bind_result($priceTypeID, $code, $name);
$optionsPC = "<option value='0' selected='selected' style='color: silver;'> - </option>";
while ($stm->fetch()) {
    $optionsPC .= "<option value='$priceTypeID' >$code $name</option>";
}
$stm->close();


?>
<div id="main" role="main">
    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">
        <span class="ribbon-button-alignment">
            <span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
                <i class="fa fa-refresh"></i>
            </span>
        </span>
        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Manage Contract/Tier Pricing</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->





    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-8">
                <h3 class="page-title txt-color-blueDark" style="margin-top: 5px; margin-bottom: 15px;">
                    <i class="fa fa-money"></i>
                    Contract Prices
                </h3>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">

            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
                <span class="pull-right show-stat-buttons"><span> <a  href="//<?php echo HTML_PATH ?>/cop/backend/core/views/addedit/batch_import_contract_prices.php" class="btn btn-success btn-block"> <i class="fa fa-upload"></i>&nbsp; Batch Import Contract Prices</a> </span> </span>

            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="">

            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Contract Prices Table </h2>
                        </header>
                        <!-- widget div-->
                        <div>

                            <!-- widget content -->
                            <div class="widget-body no-padding">

                                <table class="table table-bordered" style="background-color: #b0d1de;padding: 5px;" id="addContractPriceTable">
                                    <thead>
                                    <tr>
                                        <th  class="text-center"  style="background-color: #b0d1de;"></th>
                                        <th class="text-center" style="background-color: #b0d1de;">Customer</th>
                                        <th class="text-center" style="background-color: #b0d1de;">Item</th>
                                        <th class="text-center" style="background-color: #b0d1de;">Price Code</th>
                                        <th class="text-center" style="background-color: #b0d1de;">Price</th>
                                        <th class="text-center" style="background-color: #b0d1de;">Percentage</th>
                                        <th class="text-center" style="background-color: #b0d1de;">Min Qty</th>
                                        <th class="text-center" style="background-color: #b0d1de;">Valid From</th>
                                        <th class="text-center" style="background-color: #b0d1de;">Valid Until</th>
                                        <th class="text-center" style=" background-color: #b0d1de;"></th>

                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td style="width: 1%;white-space: nowrap">
                                            <div style="margin: 0px;font-size: 14px">New Price <i class="fa fa-arrow-right"></i></div>
                                        </td>
                                        <td>
                                            <input style='display:inline;' class='text-center form-control' id='customerSearch' name='customerSearch' placeholder="Customer" type='text' value="">
                                            <input type="hidden" id="customerSearchID" value="">
                                        </td>
                                        <td>
                                            <input style='display:inline;' class='text-center form-control' id='itemSearch' name='itemSearch' placeholder="Item" type='text' value="">
                                            <input type="hidden" id="itemSearchID" value="">
                                        </td>
                                        <td style="width: 8%;white-space: nowrap">
                                            <select class="form-control text-center"  id="priceCodeSelection" >
                                                <?php echo $optionsPC; ?>                                            </select>
                                        </td>
                                        <td>
                                            <input type="number" min="0" class="form-control text-center" placeholder="Price" id="priceSelection" />
                                        </td>
                                        <td>
                                            <input type="number" class="form-control text-center" placeholder="Percentage" id="percentageSelection"  />
                                        </td>
                                        <td>
                                            <input type="number" class="form-control text-center" placeholder="Min qty" id="minQtySelection"  />
                                        </td>
                                        <td>
                                            <input type="text" class="form-control text-center datepicker" data-dateformat="dd/mm/yy" data-mask="99/99/9999" data-mask-placeholder="-" placeholder="Valid From" id="validFromSelection"  />
                                        </td>
                                        <td>
                                            <input type="text" class="form-control text-center datepicker" placeholder="Valid Until" id="validToSelection"   data-dateformat="dd/mm/yy" data-mask="99/99/9999" data-mask-placeholder="-" />
                                        </td>
                                        <td style="width: 1%;white-space: nowrap">
                                            <button class="btn btn-primary btn-block" onclick="addContractPrice();">Add Price</button>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>

                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTabl" width="100%">
                                    <thead>
                                    <tr>
                                        <th class="hasinput" style="width:3%">
                                        </th>
                                        <th class="hasinput" style="width:20%">
                                            <input type="text" class="form-control text-center" placeholder="Filter Customer" />
                                        </th>
                                        <th class="hasinput" style="width:20%">
                                            <input type="text" class="form-control text-center" placeholder="Filter Item" />
                                        </th>
                                        <th class="hasinput"  style="width:8%">
                                            <input type="text" class="form-control text-center" placeholder="Filter Price" />
                                        </th>
                                        <th class="hasinput"  style="width:8%">
                                            <input type="text" class="form-control text-center" placeholder="Filter PC" />
                                        </th>
                                        <th class="hasinput"  style="width:7%">
                                            <input type="text" class="form-control text-center" placeholder="Filter Percent." />
                                        </th>
                                        <th class="hasinput"  style="width:8%">
                                            <input type="text" class="form-control text-center" placeholder="Filter Qty" />
                                        </th>
                                        <th class="hasinput"  style="width:10%">
                                            <input type="text" class="form-control text-center" placeholder="Filter date" />
                                        </th>
                                        <th class="hasinput"  style="width:10%">
                                            <input type="text" class="form-control text-center" placeholder="Filter date" />
                                        </th>

                                    </tr>
                                    <tr>
                                        <th class="text-center"></th>
                                        <th class="text-center">Customer</th>
                                        <th class="text-center">Item</th>
                                        <th class="text-center">Price</th>
                                        <th class="text-center">Price Code</th>
                                        <th class="text-center">Percentage</th>
                                        <th class="text-center">Min Qty</th>
                                        <th class="text-center">Valid From</th>
                                        <th class="text-center">Valid Until</th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- WIDGET END -->
            </div>
            <!-- end row -->
        </section>

    </div>
</div>


<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>

<style>
    table#datatable_fixed_column tr td img { display:none;}
    table#datatable_fixed_column tr:hover td img { display:inline-block;}
</style>


<script type="text/javascript">
    function parseDate(dateStr) {
        var parts = dateStr.split('/');
        return new Date(parts[2], parts[1] - 1, parts[0]);
    }

    function addContractPrice(){
        var itemID = $('#itemSearchID').val();
        var customerID = $('#customerSearchID').val();
        var priceTypeID =  $('#priceCodeSelection').val();

        var price = $('#priceSelection').val();
        var percentage = $('#percentageSelection').val();
        var minQty = $('#minQtySelection').val();
        var validFrom = $('#validFromSelection').val();
        var validUntil = $('#validToSelection').val();

        var hasError = false;
        if (!itemID) {
            highlightDataError($('#itemSearch'));
            hasError = true;
        }
        if (!customerID) {
            highlightDataError($('#customerSearch'));
            hasError = true;
        }

        if (!validFrom) {
            highlightDataError($('#validFromSelection'));
            hasError = true;
        }
        if (!validUntil) {
            highlightDataError($('#validToSelection'));
            hasError = true;
        }
        // if (!price) {
        //     highlightDataError($('#priceSelection'));
        //     hasError = true;
        // }


        if(hasError){
            $.smallBox({
                title: "Warning!",
                content: "Please fill in all fields.",
                color: '#b22222',
                timeout: 3000,
                icon: "fa fa-exclamation-triangle swing animated"
            });
            return;
        }

        if (validFrom && validUntil) {
            var fromDate = parseDate(validFrom);
            var toDate = parseDate(validUntil);

            if (fromDate >= toDate) {
                highlightDataError($('#validToSelection'));
                highlightDataError($('#validFromSelection'));

                $.smallBox({
                    title: "Warning!",
                    content: "Valid From date must be before Valid To date.",
                    color: '#b22222',
                    timeout: 3000,
                    icon: "fa fa-exclamation-triangle swing animated"
                });
                return;
            }
        }



        $.ajax({
            type: "POST",
            url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/add/addContractPrice.php",
            data: {itemID: itemID, priceTypeID: priceTypeID, customerID:customerID, price: price, percentage: percentage, minQty: minQty, validFrom: validFrom, validUntil: validUntil},
            success: function (data) {
                if(data.localeCompare('error')==0){
                    $('#addContractPriceTable').css('background-color','#a95454');
                    setTimeout(function(){
                        $('#addContractPriceTable').css('background-color','#b0d1de');
                    }, 1000);
                } else {
                    $('#addContractPriceTable').css('background-color','#7df58e');
                    setTimeout(function(){
                        $('#addContractPriceTable').css('background-color','#b0d1de');
                    }, 1000);
                    $('#itemSearch').val('');
                    $('#itemSearchID').val('');
                   // $('#customerSearch').val('');
                    //$('#customerSearchID').val('');
                    $('#priceSelection').val('');
                    $('#percentageSelection').val('');
                    $('#minQtySelection').val('');
                    //$('#validFromSelection').val('');
                    //$('#validToSelection').val('');


                    $('#datatable_fixed_column').DataTable().ajax.reload(null,false);
                }
            }
        });
    }

    function initItemAutocomplete() {
        $("#itemSearch").autocomplete({
            source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/item_autocomplete.php",
            autoFocus: true,
            open: function(){
                $('.ui-autocomplete').css('width', '400px');
            },
            select: function (event, ui) {
                $('#itemSearchID').val(ui.item.item_id);
                $(this).blur();//remove focus

            }
        });
    }

    function initCustomerAutocomplete() {
        $("#customerSearch").autocomplete({
            source: "//<?php echo HTML_PATH . "/cop/backend/core/controllers/autocomplete/customer_autocomplete.php"?>",
            autoFocus: true,
            open: function(){
                $('.ui-autocomplete').css('width', '400px');
            },
            select: function (event, ui) {
                $('#customerSearchID').val(ui.item.customer_id);
                $(this).blur();//remove focus


                return true;
            }
        });
    }

    function openEditField(uniqueID, elementName, element){


        var suffix = '-' + elementName + '-' + uniqueID;
        var value ;

       if($('#input' + suffix).attr('type') === 'date') {
           var dateStr = $('#value' + suffix).text();
           var parts = dateStr.split('/');
           value = parts[2] + "-" + parts[1] + "-" + parts[0];

       }
       else if ($('#input' + suffix).is('select')) {
               value  = $('#input' + suffix).val();
        }
        else{
            value  = $('#value' + suffix).text();
        }

        $('#input' + suffix).val(value);




        $('#value' + suffix).hide();
        $('#pen' + suffix).hide();
        $('#input' + suffix).show();
        $('#input' + suffix).focus();
        $('#save' + suffix).show();


        $('#save' + suffix).unbind().on('click', function() {
            var newValue;
            if (elementName === "customer" || elementName === "item") {
                 newValue = $('#inputID' + suffix).val().trim();

            }
            else{
                newValue = $('#input' + suffix).val().trim();
            }

            if(value.localeCompare(newValue)!=0 ){
                saveStatusField(uniqueID, elementName, newValue,suffix);
            }
            else {
                closeEditFields(suffix);
            }
        });




        $('#input' + suffix).focusout(function(event){
            var isSaveClicked = $(event.relatedTarget).is('#save' + suffix);

            if (!isSaveClicked) {
                $('#input' + suffix).val(value);
                closeEditFields(suffix);
            }
        });

    }

    function saveStatusField(id, elementName, newValue, suffix) {

        if((elementName==="customer" && newValue === "") || (elementName==="item" && newValue === "") || (elementName==="min_qty" && newValue === "")){
            $.smallBox({
                title: "Warning!",
                content: "The Field  cannot be empty.",
                color: '#b22222',
                timeout: 3000,
                icon: "fa fa-exclamation-triangle swing animated"
            });
            closeEditFields(suffix);
            return;
        }

        $.ajax({
            type: "POST",
            url: "//<?php echo HTML_PATH; ?>/cop/backend/core/controllers/edit/edit_contract_price_field.php",
            data: {
                'uniqueID': id,
                'fieldName': elementName,
                'fieldValue': newValue
            }
            ,
            success: function(result) {

                if(result ==="existingKey"){
                    $.smallBox({
                        title: "Warning!",
                        content: "Contract price for this item already exists.",
                        color: "#b22222",
                        timeout: 3000,
                        icon: "fa fa-exclamation-triangle swing animated"
                    });

                }
                else{

                    $.smallBox({
                        title: "Success!",
                        content: "Field successfully updated.",
                        color: "#739E73",
                        timeout: 2000,
                        icon: "fa fa-check swing animated"
                    });

                    $('#value' + suffix).html(newValue);
                    closeEditFields(suffix);
                    $('#datatable_fixed_column').DataTable().draw(null, false);
            }
                }
        });
    }

    function  closeEditFields(suffix) {
        if ($('#input' + suffix).is('input,textarea')) {
            $('#input' + suffix).val('');
        }
        $('#input' + suffix).hide();
        $('#value' + suffix).show();
        $('#pen' + suffix).show();
        $('#save' + suffix).hide();


    }

    function highlightDataError(element,error){
        element.css('border-color','firebrick').css('background-color','#ffd0bd');
        window.setTimeout(function(){
            element.css('border-color','').css('background-color','');
            element.next('.error-message').fadeOut(500);

        },3000);
    }

    function deleteRow(uniqueID) {
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH?>/cop/backend/core/controllers/delete/delete_contract_price.php',
            data: {
                'uniqueID': uniqueID,
            },
            success: function(result) {
                if (result.localeCompare('error') == 0) {

                    $.smallBox({
                        title: "Warning!",
                        content: "Something Went Wrong.",
                        color: '#b22222',
                        timeout: 3000,
                        icon: "fa fa-exclamation-triangle swing animated"
                    });


                } else {

                    $.smallBox({
                        title: "Success!",
                        content: "Row has been deleted.",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-check swing animated"
                    });

                }
                $('#datatable_fixed_column').DataTable().draw(null, false);

            }
        });

    }



    $(document).ready(function() {

        pageSetUp();
        initItemAutocomplete();
        initCustomerAutocomplete();
       // $('#priceCodeSelection').select2();





        var responsiveHelper_datatable_fixed_column = undefined;

        var breakpointDefinition = {
            tablet: 1024,
            phone: 480
        };

        /* COLUMN FILTER  */
        var otable = $('#datatable_fixed_column').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'><'col-sm-6 col-xs-6 hidden-xs' B C l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "autoWidth": true,
            "processing": false,
            "serverSide": true,
            "ajax": {
                "type": "GET",
                "url": "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/getAll/getAllContractPrices.php",
            },
            "columns": [
                { "data": "deleteImg" },
                { "data": "customer" },
                { "data": "item" },
                { "data": "price" },
                { "data": "price_type" },
                { "data": "percentage" },
                { "data": "min_qty" },
                { "data": "valid_from" },
                { "data": "valid_until" }

            ],
            "deferRender": true,
            "autoWidth": true,
            "buttons": [
                "copyHtml5",
                "excelHtml5",
                "csvHtml5",
                {
                    extend: 'pdfHtml5',
                    orientation: 'landscape',
                    pageSize: 'LEGAL'
                }
            ],
            "preDrawCallback": function() {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
            "rowCallback": function(nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback": function(oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }
        });

        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on('keyup change', function() {
            otable
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();
        });
    });
</script>
