<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);
include_once("../../../../param.php");
$validDocuments = array('Orders','Invoices','Tenders');
$request         = $_POST['typeRequest'];
$requestDocument = $_POST['requestDocument'];
$dateFilter      = $_POST['dateFilter'];
$selectFieldShow = $_POST['selectFieldShow'];
$yearLinear      = $_POST['linearYear'];
$displayCurrencySign = getDisplayCurrencySign();


if (strcmp($request,'getSales')==0 && in_array($requestDocument,$validDocuments)){
    if (strcmp($requestDocument,'Orders')==0){
        $salesObject = getSalesObj('Orders',$selectFieldShow,'order_date','Orders',$displayCurrencySign);
        echo json_encode($salesObject);
    }elseif (strcmp($requestDocument,'Invoices')==0){
        $salesObject = getSalesObj('Invoices',$selectFieldShow,'invoice_date','Sales',$displayCurrencySign);
        echo json_encode($salesObject);
    }elseif (strcmp($requestDocument,'Tenders')==0){
        $salesObject = getSalesObj('Tenders',$selectFieldShow,'tender_date','Tenders',$displayCurrencySign);
        echo json_encode($salesObject);
    }else{
        echo "here";
    }
}elseif (strcmp($request,'getBestCustomers')==0 && in_array($requestDocument,$validDocuments)){
    $datesObj = getDatesObjSearch($dateFilter);
    if (strcmp($requestDocument,'Orders')==0){
        $salesObject = returnPerson('Orders','subtotal','order_date',$datesObj->dateFrom,$datesObj->dateTo,'Customers');
        echo json_encode($salesObject);
    }elseif(strcmp($requestDocument,'Invoices')==0){
        $salesObject = returnPerson('Invoices','subtotal','invoice_date',$datesObj->dateFrom,$datesObj->dateTo,'Customers');
        echo json_encode($salesObject);
    }elseif(strcmp($requestDocument,'Tenders')==0){
        $salesObject = returnPerson('Tenders','subtotal','tender_date',$datesObj->dateFrom,$datesObj->dateTo,'Customers');
        echo json_encode($salesObject);
    }
}elseif (strcmp($request,'getBestSalesperson')==0 && in_array($requestDocument,$validDocuments)){
    $datesObj = getDatesObjSearch($dateFilter);
    if (strcmp($requestDocument,'Orders')==0){
        $salesObject = returnPerson('Orders','subtotal','order_date',$datesObj->dateFrom,$datesObj->dateTo,'Salespersons');
        echo json_encode($salesObject);
    }elseif(strcmp($requestDocument,'Invoices')==0){
        $salesObject = returnPerson('Invoices','subtotal','invoice_date',$datesObj->dateFrom,$datesObj->dateTo,'Salespersons');
        echo json_encode($salesObject);
    }elseif(strcmp($requestDocument,'Tenders')==0){
        $salesObject = returnPerson('Tenders','subtotal','tender_date',$datesObj->dateFrom,$datesObj->dateTo,'Salespersons');
        echo json_encode($salesObject);
    }
}elseif (strcmp($request,'getBestItems')==0 && in_array($requestDocument,$validDocuments)){
    $datesObj = getDatesObjSearch($dateFilter);
    if (strcmp($requestDocument,'Orders')==0){
        $salesObject = returnItems('Orders','Order_Item','order_id','qty','order_date',$datesObj->dateFrom,$datesObj->dateTo);
        $salesObject = getDataPoints($salesObject);
        echo json_encode($salesObject);
    }elseif(strcmp($requestDocument,'Invoices')==0){
        $salesObject = returnItems('Invoices','Invoice_Item','invoice_id','qty','invoice_date',$datesObj->dateFrom,$datesObj->dateTo);
        $salesObject = getDataPoints($salesObject);
        echo json_encode($salesObject);
    }elseif(strcmp($requestDocument,'Tenders')==0){
        $salesObject = returnItems('Tenders','Tender_Item','tender_id','qty','tender_date',$datesObj->dateFrom,$datesObj->dateTo);
        $salesObject = getDataPoints($salesObject);
        echo json_encode($salesObject);
    }
}elseif (strcmp($request,'getBestItemsAmounts')==0 && in_array($requestDocument,$validDocuments)){
    $datesObj = getDatesObjSearch($dateFilter);
    if (strcmp($requestDocument,'Orders')==0){
        $salesObject = returnItems('Orders','Order_Item','order_id','qty*unit_price','order_date',$datesObj->dateFrom,$datesObj->dateTo);
        $salesObject = getDataPoints($salesObject);
        echo json_encode($salesObject);
    }elseif(strcmp($requestDocument,'Invoices')==0){
        $salesObject = returnItems('Invoices','Invoice_Item','invoice_id','qty*unit_price','invoice_date',$datesObj->dateFrom,$datesObj->dateTo);
        $salesObject = getDataPoints($salesObject);
        echo json_encode($salesObject);
    }elseif(strcmp($requestDocument,'Tenders')==0){
        $salesObject = returnItems('Tenders','Tender_Item','tender_id','qty*unit_price','tender_date',$datesObj->dateFrom,$datesObj->dateTo);
        $salesObject = getDataPoints($salesObject);
        echo json_encode($salesObject);
    }
}elseif (strcmp($request,'getLinearGraph')==0 && in_array($requestDocument,$validDocuments)){
    $getPeriod = getCustomPeriod($yearLinear);


    if (strcmp($requestDocument,'Orders')==0){
        $salesObject = getSalesLinear('Orders',$selectFieldShow,'order_date',$getPeriod,$displayCurrencySign);
        echo json_encode($salesObject, JSON_NUMERIC_CHECK);
    }elseif (strcmp($requestDocument,'Invoices')==0){
        $salesObject = getSalesLinear('Invoices',$selectFieldShow,'invoice_date',$getPeriod,$displayCurrencySign);
        echo json_encode($salesObject, JSON_NUMERIC_CHECK);
    }elseif (strcmp($requestDocument,'Tenders')==0){
        $salesObject = getSalesLinear('Tenders',$selectFieldShow,'tender_date',$getPeriod,$displayCurrencySign);
        echo json_encode($salesObject, JSON_NUMERIC_CHECK);
    }else{
        echo "here";
    }
}elseif (strcmp($request,'getYearAnalysisSales')==0 && in_array($requestDocument,$validDocuments)){
    $getPeriod = getCustomPeriod($yearLinear);


    if (strcmp($requestDocument,'Orders')==0){
//        viewArray($getPeriod);
        $salesObject = getYearsAnalysisSalesperson('Orders',$selectFieldShow,'order_date',$getPeriod,$displayCurrencySign);
        echo json_encode($salesObject, JSON_NUMERIC_CHECK);
    }elseif (strcmp($requestDocument,'Invoices')==0){
        $salesObject = getYearsAnalysisSalesperson('Invoices',$selectFieldShow,'invoice_date',$getPeriod,$displayCurrencySign);
        echo json_encode($salesObject, JSON_NUMERIC_CHECK);
    }elseif (strcmp($requestDocument,'Tenders')==0){
        $salesObject = getYearsAnalysisSalesperson('Tenders',$selectFieldShow,'tender_date',$getPeriod,$displayCurrencySign);
        echo json_encode($salesObject, JSON_NUMERIC_CHECK);
    }else{
        echo "here";
    }
}
function getSalesLinear($requestTable,$field,$dateFromField,$getPeriod,$displayCurrencySign){
    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $dataPoints = array();
    $extraFilter         = getExtraFilter();

    foreach ($getPeriod as $period){
        $stm = $db->prepare("SELECT SUM($field) FROM $requestTable WHERE  $dateFromField>='$period->first_date' AND $dateFromField<='$period->last_date' $extraFilter");
        $stm->execute();
        $stm->bind_result($sumToday);
        while ($stm->fetch()) {}
        $stm->close();
        $period->sum = $sumToday;

        $dataPoints[] = [
            "y" => $sumToday,
            "label" => $period->month
        ];
    }

    return $dataPoints;
}

function getYearsAnalysisSalesperson($requestTable,$field,$dateFromField,$getPeriod,$displayCurrencySign){
    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $extraFilter         = getExtraFilter();
    $dataPoints = array();
    $counterDash = 0;
    $colorMonths = array(
        "#D49F56", // Απαλό σκουρόχρωμο πορτοκαλί (Ιανουάριος)
        "#A6D2A1", // Απαλό πράσινο (Φεβρουάριος)
        "#5A7FC7", // Απαλό μπλε (Μάρτιος)
        "#F4A5BB", // Απαλό ροζ (Απρίλιος)
        "#D6D156", // Απαλό κίτρινο (Μάιος)
        "#A0D9E2", // Απαλό γαλάζιο (Ιούνιος)
        "#B57F94", // Απαλό μωβ (Ιούλιος)
        "#D38F56", // Απαλό πορτοκαλί (Αύγουστος)
        "#7FB7D4", // Απαλό μπλε (Σεπτέμβριος)
        "#E5A3C0", // Απαλό ροζ (Οκτώβριος)
        "#9C7FBC", // Απαλό μωβ (Νοέμβριος)
        "#82C6A0"  // Απαλό πράσινο (Δεκέμβριος)
    );    foreach ($getPeriod as $period){
        $arrayYearsAnalysisSalesperson = array();
        $stm = $db->prepare("SELECT salesperson_id,SUM($field) FROM $requestTable WHERE  $dateFromField>='$period->first_date' AND $dateFromField<='$period->last_date' $extraFilter GROUP BY salesperson_id");
        $stm->execute();
        $stm->bind_result($salespersonID,$sumToday);
        while ($stm->fetch()) {
            $objSales = new stdClass();
            $objSales->salespersonInfo = getSalespersonInfo($salespersonID);
            $objSales->amount          = $sumToday;
            array_push($arrayYearsAnalysisSalesperson,$objSales);
        }
        $stm->close();
        usort($arrayYearsAnalysisSalesperson, function ($a, $b) {
            return $b->amount > $a->amount;
        });

        $topThree = array_slice($arrayYearsAnalysisSalesperson, 0, 3);
        foreach ($topThree as $three){
            $salespersonInfo = $three->salespersonInfo;
//            $counterDash++;
            $dataPoints[] = [
                "y" => $three->amount,
                "label" => $period->month." $salespersonInfo->personID $salespersonInfo->name",
                "color"=> $colorMonths[$counterDash]
            ];
        }
        $counterDash++;
    }

    return $dataPoints;
}

function getCustomPeriod($year){
    $currentMonth = date('n');
    $months = array();
    for ($month = 1; $month <= $currentMonth; $month++) {
        $monthNum  = $month;
        $dateObj   = DateTime::createFromFormat('!m', $monthNum);
        $monthName = $dateObj->format('F'); // March


        $formattedMonth = str_pad($month, 2, '0', STR_PAD_LEFT);
        $firstDay = "$year-$formattedMonth-01";
        $lastDay = date("Y-m-t", strtotime($firstDay));

        $monthObj = new stdClass();
        $monthObj->month        = $monthName;
        $monthObj->first_date   = $firstDay;
        $monthObj->last_date    = $lastDay;
        array_push($months,$monthObj);

    }
    return $months;
}

function getDataPoints($salesObject){
    $dataPoints = array();
    $itemArray = $salesObject->arrayPersons;
    $qtyArray  = $salesObject->arrayPercentage;
    $arrayColors = ["#57889c", "#99aff6", "#e8acc7", "#e7c69a", "#8ca765"];

    for ($i=0; $i<=count($itemArray); $i++){
        if (strcmp($itemArray[$i],'')!=0){
            $json = new stdClass();
            $json->y = $qtyArray[$i];
            $json->name = explode(' ',$itemArray[$i])[0];
            $json->indexLabel = $itemArray[$i];
            $json->indexLabelFontSize = 15;
            $json->indexLabelFontColor = $arrayColors[$i];
            $json->indexLabelOrientation = 'horizontal';
            $json->indexLabelPlacement = 'inside';
            array_push($dataPoints,$json);
        }
    }

    $salesObject->datapoints = $dataPoints;
    return $salesObject;
}

function getDatesObjSearch($dateFilter){
    switch ($dateFilter){
        case 'today':
            $dateFrom = date('Y-m-d');
            $dateTo   = date('Y-m-d');
            break;
        case 'week':
            $dateFrom           = date('Y-m-d', strtotime('monday this week'));
            $dateTo             = date('Y-m-d');
            break;
        case 'month':
            $dateToday          = date('Y-m-d');
            $month              = date("m",strtotime($dateToday));
            $year               = date("Y",strtotime($dateToday));
            $dateFromNew        = "{$year}-{$month}-01";
            $dateFrom           = $dateFromNew;
            $dateTo             = date('Y-m-d');
            break;
        case 'year':
            $dateToday          = date('Y-m-d');
            $month              = date("m",strtotime($dateToday));
            $year               = date("Y",strtotime($dateToday));
            $dateFromNew        = "{$year}-01-01";
            $dateFrom           = $dateFromNew;
            $dateTo             = date('Y-m-d');
            break;
    }
    $returnObj = new stdClass();
    $returnObj->dateFrom = $dateFrom;
    $returnObj->dateTo   = $dateTo;

    return $returnObj;
}

function getSalesObj($requestTable,$field,$dateField,$titleCustom,$displayCurrencySign){
    $table          = $requestTable;
    $fieldCalculate = $field;
    $dateFromField  = $dateField;

    $orderSalesObj = new stdClass();

    $dateToday          = date('Y-m-d');
    $month = date("m",strtotime($dateToday));
    $year  = date("Y",strtotime($dateToday));
    $dateFromNew = "{$year}-{$month}-01";
    $dateStartYear = "{$year}-01-01";
    $yesterday      = date( 'Y-m-d', strtotime( 'yesterday' ) );
    //1o TODAY YESTERDSY
    $amountObj = returnAmount($table,$fieldCalculate,$dateFromField,$dateToday,$dateToday,$yesterday,$yesterday);
    $sumToday = $amountObj->current;
    $sumYesterday = $amountObj->next;
    if ($sumToday>$sumYesterday){
        if ($sumToday==0){
            $percentage = '';
        }else{
            if ($sumYesterday==0){
                $percentage = 100;
                $percentagePointer = 1;
            }else{
                $percentage = round(($sumToday/$sumYesterday)*100);
                $percentagePointer = 100;
            }
        }
    }else{
        if ($sumYesterday==0){
            $percentage = '';
        }else{
            $percentage = round((($sumYesterday- $sumToday)/$sumYesterday)*100);
            $percentagePointer = 0;
        }
    }
    if (strcmp($percentage,'')==0 || $percentage==0){
        $percentage = 100;
    }
    $orderSalesObj->todayPercentage = $percentage;
    $orderSalesObj->todayPercentagePointer = $percentagePointer;
    $orderSalesObj->todaySUM  =  "$displayCurrencySign".number_format( round($sumToday,2),2);
    $orderSalesObj->todayDate =  $dateToday;
    $orderSalesObj->yesterdaySUM  =  $sumYesterday;
    $orderSalesObj->yesterdayDate =  $yesterday;
    $orderSalesObj->todayTitle    = "$titleCustom Today";
    $sumYesterdayFormat = number_format( round($sumYesterday,2),2);
    $orderSalesObj->todayTitleVS  = "vs last yesterday $displayCurrencySign$sumYesterdayFormat";
    //2o WEEK LAST WEEK
    $mondayCurrentWeek  = date('Y-m-d', strtotime('monday this week'));
    $mondayLastWeek     = date('Y-m-d', strtotime('monday last week'));
    $dayNameToday       = date('l', strtotime($dateToday));
    $dateCurrentWeek    = date('Y-m-d', strtotime("$dayNameToday this week"));
    $dateLastWeek       = date('Y-m-d', strtotime("$dayNameToday last week"));

    $amountObj = returnAmount($table,$fieldCalculate,$dateFromField,$mondayCurrentWeek,$dateCurrentWeek,$mondayLastWeek,$dateLastWeek);
    $sumToday = $amountObj->current;
    $sumYesterday = $amountObj->next;
    if ($sumToday>$sumYesterday){
        if ($sumToday==0){
            $percentage = '';
        }else{
            if ($sumYesterday==0){
                $percentage = 100;
                $percentagePointer = 1;
            }else{
                $percentage = round(($sumToday/$sumYesterday)*100);
                $percentagePointer = 100;
            }
        }
    }else{
        if ($sumYesterday==0){
            $percentage = '';
        }else{
            $percentage = round((($sumYesterday- $sumToday)/$sumYesterday)*100);
            $percentagePointer = 0;
        }
    }
    if (strcmp($percentage,'')==0 || $percentage==0){
        $percentage = 100;
    }
    $orderSalesObj->weekPercentage = $percentage;
    $orderSalesObj->weekPercentagePointer = $percentagePointer;
    $orderSalesObj->weekSUM  =  "$displayCurrencySign".number_format( round($sumToday,2),2);
    $orderSalesObj->weekDate =  "$mondayCurrentWeek->$dateCurrentWeek";
    $orderSalesObj->lastweekSUM  =  $sumYesterday;
    $orderSalesObj->lastweekDate =  "$mondayLastWeek->$dateLastWeek";
    $orderSalesObj->weekTitle    = "$titleCustom Week";
    $sumYesterdayFormat = number_format( round($sumYesterday,2),2);
    $orderSalesObj->weekTitleVS  = "vs last week $displayCurrencySign$sumYesterdayFormat";
    //3o MONTH LAST MONTH
    $beforeOneMonthStart = date('Y-m-d', strtotime("$dateFromNew -1 month"));
    $beforeOneMonthEnd = date('Y-m-d', strtotime("$dateToday -1 month"));
    $amountObj = returnAmount($table,$fieldCalculate,$dateFromField,$dateFromNew,$dateToday,$beforeOneMonthStart,$beforeOneMonthEnd);
    $sumToday = $amountObj->current;
    $sumYesterday = $amountObj->next;
    if ($sumToday>$sumYesterday){
        if ($sumToday==0){
            $percentage = '';
        }else{
            if ($sumYesterday==0){
                $percentage = 100;
                $percentagePointer = 1;
            }else{
                $percentage = round(($sumToday/$sumYesterday)*100);
                $percentagePointer = 100;
            }
        }
    }else{
        if ($sumYesterday==0){
            $percentage = '';
        }else{
            $percentage = round((($sumYesterday- $sumToday)/$sumYesterday)*100);
            $percentagePointer = 0;
        }
    }
    if (strcmp($percentage,'')==0 || $percentage==0){
        $percentage = 100;
    }
    $orderSalesObj->monthPercentage = $percentage;
    $orderSalesObj->monthPercentagePointer = $percentagePointer;
    $orderSalesObj->monthSUM  =  "$displayCurrencySign".number_format( round($sumToday,2),2);
    $orderSalesObj->monthDate =  "$dateFromNew->$dateToday";
    $orderSalesObj->lastmonthSUM  =  $sumYesterday;
    $orderSalesObj->lastmonthDate =  "$beforeOneMonthStart->$beforeOneMonthEnd";
    $orderSalesObj->monthTitle    = "$titleCustom Month";
    $sumYesterdayFormat = number_format( round($sumYesterday,2),2);
    $orderSalesObj->monthTitleVS  = "vs last month $displayCurrencySign$sumYesterdayFormat";
    //4o YEAR LAST YEAR
    $beforeOneYearStart = date('Y-m-d', strtotime("$dateStartYear -1 year"));
    $beforeOneYearEnd = date('Y-m-d', strtotime("$dateToday -1 year"));
    $amountObj = returnAmount($table,$fieldCalculate,$dateFromField,$dateStartYear,$dateToday,$beforeOneYearStart,$beforeOneYearEnd);
    $sumToday = $amountObj->current;
    $sumYesterday = $amountObj->next;
    if ($sumToday>$sumYesterday){
        if ($sumToday==0){
            $percentage = '';
        }else{
            if ($sumYesterday==0){
                $percentage = 100;
                $percentagePointer = 1;
            }else{
                $percentage = round(($sumToday/$sumYesterday)*100);
                $percentagePointer = 100;
            }
        }
    }else{
        if ($sumYesterday==0){
            $percentage = '';
        }else{
            $percentage = round((($sumYesterday- $sumToday)/$sumYesterday)*100);
            $percentagePointer = 0;
        }
    }
    if (strcmp($percentage,'')==0 || $percentage==0){
        $percentage = 100;
    }
    $orderSalesObj->yearPercentage = $percentage;
    $orderSalesObj->yearPercentagePointer = $percentagePointer;
    $orderSalesObj->yearSUM  =  "$displayCurrencySign".number_format( round($sumToday,2),2);
    $orderSalesObj->yearDate =  "$dateFromNew->$dateToday";
    $orderSalesObj->lastyearSUM  =  $sumYesterday;
    $orderSalesObj->lastyearDate =  "$beforeOneMonthStart->$beforeOneMonthEnd";
    $orderSalesObj->yearTitle    = "$titleCustom Year";
    $sumYesterdayFormat = number_format( round($sumYesterday,2),2);
    $orderSalesObj->yearTitleVS  = "vs last year $displayCurrencySign$sumYesterdayFormat";

    return $orderSalesObj;
}


function returnAmount($table,$fieldCalculate,$dateFromField,$dateFrom,$dateTo,$nextFrom,$nextTo){
    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $extraFilter         = getExtraFilter();

    $stm = $db->prepare("SELECT SUM($fieldCalculate) FROM $table WHERE  $dateFromField>='$dateFrom' AND $dateFromField<='$dateTo' $extraFilter");
    $stm->execute();
    $stm->bind_result($sumToday);
    while ($stm->fetch()) {}
    $stm->close();
    $stm = $db->prepare("SELECT SUM($fieldCalculate) FROM $table WHERE  $dateFromField>='$nextFrom' AND $dateFromField<='$nextTo' $extraFilter");
    $stm->execute();
    $stm->bind_result($sumYesterday);
    while ($stm->fetch()) {}
    $stm->close();
    if (strcmp($sumToday,'')==0){
        $sumToday = 0;
    }
    if (strcmp($sumYesterday,'')==0){
        $sumYesterday = 0;
    }
    $objReturn = new stdClass();
    $objReturn->current = $sumToday;
    $objReturn->next = $sumYesterday;

    return $objReturn;
}

function returnPerson($table,$fieldCalculate,$dateFromField,$dateFrom,$dateTo,$personField){
    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $extraFilter         = getExtraFilter();

    $arrayReturn = array();
    if (strcmp($personField,'Customers')==0){
        $stm = $db->prepare("SELECT COUNT(customer_id),SUM($fieldCalculate),customer_id FROM $table WHERE  $dateFromField>='$dateFrom' AND $dateFromField<='$dateTo' $extraFilter GROUP BY customer_id");
        $stm->execute();
        $stm->bind_result($counter,$sumToday,$personID);
        while ($stm->fetch()) {
            $objDoc = new stdClass();
            $objDoc->personID = $personID;
            $objDoc->sum      = $sumToday;
            $objDoc->counter  = $counter;
            array_push($arrayReturn,$objDoc);
            $total += $sumToday;
        }
        $stm->close();

        usort($arrayReturn,function($first,$second){
            return $first->sum < $second->sum;
        });
        $newArray = array_slice($arrayReturn, 0, 5, true);
        $arrayReturnPersons    = array();
        $arrayReturnDiscounts  = array();
        foreach ($newArray as $obj){
            $personInfo = getPersonInfo($personField,$obj->personID);
            $percentage = round(($obj->sum/$total)*100);
            $elementArray = "$personInfo->personCode $personInfo->name";
            array_push($arrayReturnPersons,$elementArray);
            array_push($arrayReturnDiscounts,$percentage);
        }
    }elseif (strcmp($personField,'Salespersons')==0){
        $stm = $db->prepare("SELECT COUNT(salesperson_id),SUM($fieldCalculate),salesperson_id FROM $table WHERE  $dateFromField>='$dateFrom' AND $dateFromField<='$dateTo' $extraFilter GROUP BY salesperson_id");
        $stm->execute();
        $stm->bind_result($counter,$sumToday,$personID);
        while ($stm->fetch()) {
            $objDoc = new stdClass();
            $objDoc->personID = $personID;
            $objDoc->sum      = $sumToday;
            $objDoc->counter  = $counter;
            array_push($arrayReturn,$objDoc);
            $total += $sumToday;
        }
        $stm->close();

        usort($arrayReturn,function($first,$second){
            return $first->sum < $second->sum;
        });
        $newArray = array_slice($arrayReturn, 0, 5, true);
        $arrayReturnPersons    = array();
        $arrayReturnDiscounts  = array();
        foreach ($newArray as $obj){
            $personInfo = getPersonInfo($personField,$obj->personID);
            $percentage = round(($obj->sum/$total)*100);
            $elementArray = "$personInfo->personCode $personInfo->name";
            array_push($arrayReturnPersons,$elementArray);
            array_push($arrayReturnDiscounts,$percentage);
        }
    }else{

    }

    $objReturn = new stdClass();
    $objReturn->arrayPersons    = $arrayReturnPersons;
    $objReturn->arrayPercentage = $arrayReturnDiscounts;

    return $objReturn;
}

function returnItems($headerTable,$table,$connectField,$fieldCalculate,$dateFromField,$dateFrom,$dateTo){
    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $extraFilter         = getExtraFilter();

    $arrayReturn = array();

    $stm = $db->prepare("SELECT COUNT(item_id),SUM($fieldCalculate),item_id FROM $headerTable,$table WHERE  $headerTable.$connectField=$table.$connectField AND  $dateFromField>='$dateFrom' AND $dateFromField<='$dateTo' $extraFilter GROUP BY item_id");
    $stm->execute();
    $stm->bind_result($counter,$sumToday,$itemID);
    while ($stm->fetch()) {
        $objDoc = new stdClass();
        $objDoc->itemID   = $itemID;
        $objDoc->sum      = $sumToday;
        $objDoc->counter  = $counter;
        array_push($arrayReturn,$objDoc);
    }
    $stm->close();

    usort($arrayReturn,function($first,$second){
        return $first->sum < $second->sum;
    });

    $newArray = array_slice($arrayReturn, 0, 5, true);
    $arrayReturnItems    = array();
    $arrayReturnQty  = array();
    foreach ($newArray as $obj){
        $personInfo = getItemInfo($obj->itemID);
        $elementArray = "$personInfo->itemCode $personInfo->name";
        array_push($arrayReturnItems,$elementArray);
        array_push($arrayReturnQty,$obj->sum);
    }

    $objReturn = new stdClass();
    $objReturn->arrayPersons    = $arrayReturnItems;
    $objReturn->arrayPercentage = $arrayReturnQty;

    return $objReturn;
}

function getItemInfo($itemID){
    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $objItem = new stdClass();
    $stm = $db->prepare("SELECT item_code,name FROM Items WHERE  item_id='$itemID'");
    $stm->execute();
    $stm->bind_result($itemCode,$itemName);
    while ($stm->fetch()) {
        $objItem->itemCode  = $itemCode;
        $objItem->name      = $itemName;
    }
    $stm->close();

    return $objItem;
}

function getPersonInfo($personField,$personID){
    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $objPerson = new stdClass();
    if (strcmp($personField,'Customers')==0){
        $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE  customer_id='$personID'");
        $stm->execute();
        $stm->bind_result($customerCode,$customerName);
        while ($stm->fetch()) {
            $objPerson->personCode = $customerCode;
            $objPerson->name      = $customerName;
        }
        $stm->close();
    }elseif (strcmp($personField,'Salespersons')==0){
        $stm = $db->prepare("SELECT salesperson_code,first_name,last_name FROM SalesPersons WHERE  salesperson_id='$personID'");
        $stm->execute();
        $stm->bind_result($salesCode,$first,$last);
        while ($stm->fetch()) {
            $objPerson = new stdClass();
            $objPerson->personID = $salesCode;
            $objPerson->name     = "$first-$last";
        }
        $stm->close();
    }

    return $objPerson;
}


function viewArray($arr){
    echo "<pre>";
    var_dump($arr);
    echo "</pre>";
}

function viewJson($json){
    echo "<pre>";
    echo json_encode($json);
    echo "</pre>";
}

function getDisplayCurrencySign(){
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT currency_id,currency_code,currency_sign FROM Display_Currency ORDER BY default_currency DESC LIMIT 1");
    $stm->execute();
    $stm->bind_result($displayCurrencyID,$displayCurrencyCode,$displayCurrencySign);
    while ($stm->fetch()) {}
    $stm->close();

    return $displayCurrencySign;
}

function getExtraFilter(){
    $filter = " AND NOT status='Canceled'";

    return $filter;
}

function getSalespersonInfo($personID){
    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $objPerson = new stdClass();

    $stm = $db->prepare("SELECT salesperson_code,first_name,last_name FROM SalesPersons WHERE  salesperson_id='$personID'");
    $stm->execute();
    $stm->bind_result($salesCode,$first,$last);
    while ($stm->fetch()) {
        $objPerson = new stdClass();
        $objPerson->personID = $salesCode;
        $objPerson->name     = "$first-$last";
    }
    $stm->close();

    return $objPerson;
}

//global $username,$password,$database;
//$db = new mysqli('localhost',$username,$password,$database);
//if (mysqli_connect_errno()) {
//    printf("Connect failed: %s\n", mysqli_connect_error());
//    exit();
//}
//$db->set_charset("utf8");
//
//$stm = $db->prepare("SELECT company_code,company_name FROM Companies LIMIT 1");
//$stm->execute();
//$stm->bind_result($companyCode,$companyName);
//while ($stm->fetch()) {}
//$stm->close();

?>