<?php
include_once("../../../../param.php");

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT company_code,company_name FROM Companies LIMIT 1");
$stm->execute();
$stm->bind_result($companyCode,$companyName);
while ($stm->fetch()) {}
$stm->close();


$dataPoints = array(
    array("y" => 25, "label" => "March"),
    array("y" => 15, "label" => "Monday"),
    array("y" => 25, "label" => "Tuesday"),
    array("y" => 5, "label" => "Wednesday"),
    array("y" => 10, "label" => "Thursday"),
    array("y" => 0, "label" => "Friday"),
    array("y" => 20, "label" => "Saturday")
);

?>



<div id="main" role="main" class="bg-color-whitish" style="background: linear-gradient(#ececec,#ADD8E6);">
    <div id="content">
        <div class="row">
            <div class="col-xs-12 col-sm-7 col-md-10 col-lg-8">
                <h1 class="page-title txt-color-blueDark header1"><b> Dashboard  <?php echo "$companyName " ?><span id="titleDashboard" style="color: #0a6ebd">Orders</span></b</h1>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-2 col-lg-2">
                <select id="selectAmountShow" class="form-control text-center">
                    <option value="subtotal" style="color: blue;">Subtotal</option>
                    <option value="grand_total" style="color: #006666">Grand Total</option>
                </select>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-2 col-lg-2">
                <select id="selectDashBoard" class="form-control text-center">
                    <option value="Orders" style="color: blue;">Orders</option>
                    <option value="Invoices" style="color: #006666">Invoices</option>
                    <option value="Tenders" style="color: #994949">Tenders</option>
                </select>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12 col-sm-3 col-md-3 col-lg-3 salesAmount fade-in">
                <div class="salesAmountElement">
                    <div class="salesAmountElementTitle" id="todayTitle"></div>
                    <div class="salesAmountElementAmount" id="todaySUM"></div>
                    <div class="salesAmountElementPercentage" id="todayPercentage"></div>
                    <div class="salesAmountElementPercentageReason" id="todayTitleVS"></div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-3 col-md-3 col-lg-3 salesAmount fade-in">
                <div class="salesAmountElement">
                    <div class="salesAmountElementTitle" id="weekTitle"></div>
                    <div class="salesAmountElementAmount" id="weekSUM"></div>
                    <div class="salesAmountElementPercentage" id="weekPercentage"></div>
                    <div class="salesAmountElementPercentageReason" id="weekTitleVS"></div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-3 col-md-3 col-lg-3 salesAmount fade-in">
                <div class="salesAmountElement">
                    <div class="salesAmountElementTitle" id="monthTitle"></div>
                    <div class="salesAmountElementAmount" id="monthSUM"></div>
                    <div class="salesAmountElementPercentage" id="monthPercentage"></div>
                    <div class="salesAmountElementPercentageReason" id="monthTitleVS"></div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-3 col-md-4 col-lg-3 salesAmount fade-in">
                <div class="salesAmountElement">
                    <div class="salesAmountElementTitle" id="yearTitle"></div>
                    <div class="salesAmountElementAmount" id="yearSUM"></div>
                    <div class="salesAmountElementPercentage" id="yearPercentage"></div>
                    <div class="salesAmountElementPercentageReason" id="yearTitleVS">vs last year</div>
                </div>
            </div>
        </div>

        <div class='elementRow' style="display: flex;flex-wrap: wrap;">
            <div class="graphics fade-in">
                <div class="salesAmountElementTitle">Top Salespersons
                <select class="pull-right" id="selectPeriodSalesperson">
                    <option value="today">TODAY</option>
                    <option value="week">WEEK</option>
                    <option value="month" selected>MONTH</option>
                    <option value="year">YEAR</option>
                </select>
                </div>
                <div id="notFoundSalesperson" class="notFountData" style="">
                    <i class="fa fa-search" style=""></i>
                    NO DATA FOUND
                </div>
                <div id="graphics1" class="graphicsElement" style="padding-right: 34px !important;display: none"></div>
            </div>
            <div class="graphics fade-in">
                <div class="salesAmountElementTitle" >Top Customers
                    <select class="pull-right" id="selectPeriodCustomer">
                        <option value="today">TODAY</option>
                        <option value="week">WEEK</option>
                        <option value="month" selected>MONTH</option>
                        <option value="year">YEAR</option>
                    </select>
                </div>
                <div id="notFoundCustomer" class="notFountData" style="">
                    <i class="fa fa-search" style=""></i>
                    NO DATA FOUND
                </div>
                <div id="graphics2" class="graphicsElement" style="padding-right: 34px !important;"></div>
            </div>

        </div>

        <div class='elementRow' style="display: flex;flex-wrap: wrap;">
            <div class="graphics fade-in">
                <div class="salesAmountElementTitleCustom">Top Items Qty
                    <select class="pull-right" id="selectPeriodItem">
                        <option value="today">TODAY</option>
                        <option value="week">WEEK</option>
                        <option value="month" selected>MONTH</option>
                        <option value="year">YEAR</option>
                    </select>
                </div>
                <div id="notFoundItem" class="notFountData" style="">
                    <i class="fa fa-search" style=""></i>
                    NO DATA FOUND
                </div>
                <div id="chartPieItem" class="graphicsElement" style="padding-right: 34px !important;height: 300px; width:80%; margin-left:1%; margin-top:1%"></div>
            </div>
            <div class="graphics fade-in">
                <div class="salesAmountElementTitleCustom">Top Items Amount
                    <select class="pull-right" id="selectPeriodItemAmount">
                        <option value="today">TODAY</option>
                        <option value="week">WEEK</option>
                        <option value="month" selected>MONTH</option>
                        <option value="year">YEAR</option>
                    </select>
                </div>
                <div id="notFoundItemAmount" class="notFountData" style="">
                    <i class="fa fa-search" style=""></i>
                    NO DATA FOUND
                </div>
                <div id="chartPieItemAmount" class="graphicsElement" style="padding-right: 34px !important;height: 300px; width:80%; margin-left:1%; margin-top:1%;display: none"></div>
            </div>

        </div>

        <div class='' style="">
            <div class="graphicsLinear fade-in">

                <div class="salesAmountElementTitleCustom">Year's Analysis
                    <select class="pull-right" id="selectPeriodLinear">
                        <option value="2023">2023</option>
                        <option value="2024" selected>2024</option>
                        <option value="2025">2025</option>
                    </select>
                    <select class="pull-right" id="selectTypeYearAnalysis">
                        <option value="splineArea">Spline Area</option>
                        <option value="line">Line</option>
                        <option value="bar">Bar</option>
                        <option value="doughnut">Doughnut</option>
                    </select>
                </div>
                <div id="notFoundLinear" class="notFountData" style="display:none">
                    <i class="fa fa-search" style=""></i>
                    NO DATA FOUND
                </div>
                <div id="graphicsLinear" class="" style="height: 400px; width: 80%; margin: 0 auto; padding-bottom: 10px;position: relative;"></div>
            </div>
        </div>

        <div class='' style="">
            <div class="graphicsLinear fade-in">

                <div class="salesAmountElementTitleCustom">Year's Analysis Salespersons
                    <select class="pull-right" id="selectPeriodAnalysisSalesperson">
                        <option value="2023">2023</option>
                        <option value="2024" selected>2024</option>
                        <option value="2025">2025</option>
                    </select>
                </div>
                <div id="notFoundAnalysisSales" class="notFountData" style="display:none">
                    <i class="fa fa-search" style=""></i>
                    NO DATA FOUND
                </div>
                <div id="graphicsSalespersonAnalysis" class="" style="height: 400px; width: 80%; margin: 0 auto; padding-bottom: 10px;position: relative;"></div>
            </div>
        </div>

        <div style="display: flex;flex-wrap: wrap;">
            <div class="graphicsMap fade-in">
                <div class="salesAmountElementTitle">Latest Salesperson Positions
                <button type="button" class="pull-right" onclick="redirectDailyRoutes();" id="buttonDailyRoutes">ROUTES</button>
                </div>
                <div class="graphicsElementMap google_maps" id="salespersonMap"></div>
            </div>
            <div class="graphicsMap fade-in">
                <div class="salesAmountElementTitle">Customers Position</div>
                <div class="graphicsElementMap google_maps" id="customerMap"></div>
            </div>

        </div>
    </div>
</div>

<style>
    #selectDashBoard{
        cursor: pointer;
        display: inline-block;
        position: relative;
    }
    .header1{
        font-family: "Gill Sans", sans-serif;
        font-size: 20px;
        letter-spacing: 0.2px;
        animation-duration: 10s;
    }
    .run-animation {
        animation: my-fancy-animation 5s 1;
    }
    .fade-in {
        opacity: 0;
        transition: opacity 1s ease-in-out;
    }
    .fade-in.visible {
        opacity: 1;
    }
    .salesAmountElement{
        width: 100%;
        height: 200px;
        background-color: white;
        border-radius: 25px;
        margin-top: 5%;
        box-shadow: rgba(100, 100, 111, 0.2) 0px 7px 29px 0px;
    }
    .salesAmountElementTitle{
        justify-content: center;
        padding-top: 2%;
        padding-bottom: 2%;
        padding-left: 2%;
        padding-right: 2%;
        color: slategrey;
        font-size: 17px;
    }
    .salesAmountElementTitleCustom{
        justify-content: center;
        padding-top: 2%;
        padding-bottom: 1%;
        padding-left: 2%;
        padding-right: 2%;
        color: slategrey;
        font-size: 17px;
    }
    .salesAmountElementAmount{
        text-align: center;
        font-size: 5vh;
    }
    .salesAmountElementPercentage{
        text-align: center;
        font-size: 15px;
        color: green;
        opacity: 0.7;
    }
    .salesAmountElementPercentageNegative{
        text-align: center;
        font-size: 15px;
        color: red;
        opacity: 0.7;
    }
    .salesAmountElementPercentageReason{
        text-align: center;
        font-size: 12px;
        color: darkgrey;
        margin-top: 5px;
    }

    .notFountData{
        text-align: center;
        justify-content: center;
        font-size: 18px;
        color: darkgrey;
        margin-top: 5px;
        padding-bottom: 5%;
    }

    .graphics{
        flex: 1 1 500px;
        width: 50%;
        margin-left: 5px;
        height: auto;
        background-color: white;
        border-radius: 25px;
        margin-top: 2%;
        box-shadow: rgba(100, 100, 111, 0.2) 0px 7px 29px 0px;
    }

    .graphicsLinear{
        width: 100%;
        margin-left: 5px;
        height: auto;
        background-color: white;
        border-radius: 25px;
        margin-top: 2%;
        box-shadow: rgba(100, 100, 111, 0.2) 0px 7px 29px 0px;
    }

    .graphicsMap{
        flex: 1 1 500px;
        width: 50%;
        margin-left: 5px;
        height: 600px;
        background-color: white;
        border-radius: 25px;
        margin-top: 2%;
        box-shadow: rgba(100, 100, 111, 0.2) 0px 7px 29px 0px;
    }
    .graphicsElement{
        width: 90%;
        padding-left: 5%;
    }
    .graphicsElementMap{
        width: 90%;
        margin-left: 5%;
        height: 500px;
    }

    @media (max-width: 876px) {
        .salesAmountElementTitle{
            font-size: 15px;
        }
        .salesAmountElementAmount{
            font-size: 35px;
        }
        .salesAmountElementPercentage{
            font-size: 20px;
        }
        .salesAmountElementPercentageReason{
            font-size: 13px;
        }
        .elementRow{
            display: none;
        }
    }

    #selectPeriodSalesperson{
        /*border: 1px solid darkgrey;*/
        /*border-radius: 25px;*/
        border: none;
        padding: 1%;
        box-shadow: rgba(0, 0, 0, 0.24) 0px 3px 8px;
        font-size: 14px;
        background: linear-gradient(#ececec, #d9e0e3);
    }

    #selectPeriodCustomer{
        /*border: 1px solid darkgrey;*/
        /*border-radius: 25px;*/
        border: none;
        padding: 1%;
        box-shadow: rgba(0, 0, 0, 0.24) 0px 3px 8px;
        font-size: 14px;
        background: linear-gradient(#ececec,#d9e0e3);
    }
    #selectPeriodItem{
        border: none;
        padding: 1%;
        box-shadow: rgba(0, 0, 0, 0.24) 0px 3px 8px;
        font-size: 14px;
        background: linear-gradient(#ececec,#d9e0e3);
    }
    #selectPeriodItemAmount{
        border: none;
        padding: 1%;
        box-shadow: rgba(0, 0, 0, 0.24) 0px 3px 8px;
        font-size: 14px;
        background: linear-gradient(#ececec,#d9e0e3);
    }

    #selectPeriodLinear{
        border: none;
        padding: 0.5%;
        font-size: 14px;
        background: linear-gradient(#ececec,#d9e0e3);
    }

    #selectPeriodAnalysisSalesperson{
        border: none;
        padding: 0.5%;
        font-size: 14px;
        background: linear-gradient(#ececec,#d9e0e3);
    }

    #selectTypeYearAnalysis{
        border: none;
        padding: 0.5%;
        margin-right: 2%;
        font-size: 14px;
        background: linear-gradient(#ececec,#d9e0e3);
    }

    #buttonDailyRoutes{
        border: none;
        padding: 1%;
        /*margin-right: 1%;*/
        /*box-shadow: rgba(0, 0, 0, 0.24) 0px 3px 8px;*/
        font-size: 14px;
        background: linear-gradient(#ececec,#d9e0e3);

    }

    #selectDashBoard{
        border: none;
        padding: 1%;
        box-shadow: rgba(0, 0, 0, 0.24) 0px 3px 8px;
        justify-content: center;
        padding-top: 5%;
        padding-left: 2%;
        padding-right: 2%;
        color: slategrey;
        font-size: 14px;
    }
    #selectAmountShow{
        border: none;
        padding: 1%;
        box-shadow: rgba(0, 0, 0, 0.24) 0px 3px 8px;
        justify-content: center;
        padding-top: 5%;
        padding-left: 2%;
        padding-right: 2%;
        color: slategrey;
        font-size: 14px;
    }
    a{
        display: none;
    }

    @media (min-width: 1200px) {
        .salesAmountElement-text {
            font-size: 2vw;
        }
    }
</style>

<script
        src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAonEryABOdRQBcgEfH51-nOoXTca3XlWs">
</script>
<script src="//<?php echo HTML_PATH; ?>/cop/backend/themes/<?php echo THEME_NAME; ?>/js/coprimecanvas.min.js"></script>
<!--<script src="https://cdn.canvasjs.com/canvasjs.min.js"></script>-->
<!--<script src="https://cdnjs.cloudflare.com/ajax/libs/canvasjs/1.7.0/canvasjs.js"></script>-->
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>
<script src="//<?php echo HTML_PATH; ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/justgage/raphael-2.1.4.min.js"></script>
<script src="//<?php echo HTML_PATH; ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/justgage/justgage.js"></script>
<script src="//<?php echo HTML_PATH; ?>/cop/backend/themes/<?php echo THEME_NAME; ?>/js/basichorizonalbarchart/rumca.js"></script>
<link rel="stylesheet" href="//<?php echo HTML_PATH; ?>/cop/backend/themes/<?php echo THEME_NAME; ?>/js/basichorizonalbarchart/rumca.css">
<script>
    function redirectDailyRoutes(){
        window.open("//<?php echo HTML_PATH ?>/cop/backend/core/views/maps/fullscreenSalespersonRouteMap.php", "_blank");
    }


    $('#selectAmountShow').on('change', function() {
        getDash();
    });

    $('#selectDashBoard').on('change', function() {
        getDash();
    });

    $('#selectPeriodSalesperson').on('change', function() {
        var dashRequest = $('#selectDashBoard').val();
        getBestSalesPerson(dashRequest);
    });

    $('#selectPeriodItem').on('change', function() {
        var dashRequest = $('#selectDashBoard').val();
        getBestItems(dashRequest);
    });
    $('#selectPeriodItemAmount').on('change', function() {
        var dashRequest = $('#selectDashBoard').val();
        getBestItemsAmount(dashRequest);
    });



    $('#selectPeriodCustomer').on('change', function() {
        var dashRequest = $('#selectDashBoard').val();
        getBestCustomers(dashRequest);
    });

    $('#selectPeriodLinear,#selectTypeYearAnalysis').on('change', function() {
        var dashRequest = $('#selectDashBoard').val();
        getLinear(dashRequest);
    });

    $('#selectPeriodAnalysisSalesperson').on('change', function() {
        var dashRequest = $('#selectDashBoard').val();
        getYearsAnalysisSales(dashRequest);
    });

    function getDash(){
        var dashRequest = $('#selectDashBoard').val();
        if (dashRequest=='Orders'){
            $('#main').css('background', 'linear-gradient(#ececec, #ADD8E6)');
            $('#titleDashboard').html(dashRequest);
            $('#titleDashboard').css('color', 'blue');
            getSales(dashRequest);
            getBestSalesPerson(dashRequest);
            getBestCustomers(dashRequest);
            getBestItems(dashRequest);
            getBestItemsAmount(dashRequest);
            getLinear(dashRequest);
            getYearsAnalysisSales(dashRequest);
        }else if(dashRequest=='Invoices'){
            $('#main').css('background', 'linear-gradient(#ececec, #006666)');
            $('#titleDashboard').html(dashRequest);
            $('#titleDashboard').css('color', '#006666');
            getSales(dashRequest);
            getBestSalesPerson(dashRequest);
            getBestCustomers(dashRequest);
            getBestItems(dashRequest);
            getBestItemsAmount(dashRequest);
            getLinear(dashRequest);
            getYearsAnalysisSales(dashRequest);
        }else if(dashRequest=='Tenders'){
            $('#main').css('background', 'linear-gradient(#ececec, #994949)');
            $('#titleDashboard').html(dashRequest);
            $('#titleDashboard').css('color', '#994949');
            getSales(dashRequest);
            getBestSalesPerson(dashRequest);
            getBestCustomers(dashRequest);
            getBestItems(dashRequest);
            getBestItemsAmount(dashRequest);
            getLinear(dashRequest);
            getYearsAnalysisSales(dashRequest);
        }
    }

    function getBestItemsAmount(request){
        var typeRequest = 'getBestItemsAmounts';
        var dateFilter = $('#selectPeriodItemAmount').val();
        var selectFieldShow= $('#selectAmountShow').val();
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/dashboards/getDashboardData.php',
            data: {
                'typeRequest':typeRequest,
                'requestDocument':request,
                'dateFilter':dateFilter,
                'selectFieldShow':selectFieldShow
            },
            success: function (result) {

                var dataReturn = JSON.parse(result);
                var items = dataReturn.arrayPersons;
                var itemsCount      = dataReturn.arrayPercentage;
                var datapoints      = dataReturn.datapoints;

                if (datapoints.length>0){
                    $("#notFoundItemAmount").css("display", "none");
                    $("#chartPieItemAmount").css("display", "block");
                    CanvasJS.addColorSet("customColors4", ["#57889c", "#99aff6", "#e8acc7", "#e7c69a", "#8ca765"]);
                    var chartPlanned = new CanvasJS.Chart("chartPieItemAmount", {
                        colorSet: "customColors4",
                        title:{
                            text: '',
                            verticalAlign: "center",
                            dockInsidePlotArea: true,
                            fontColor: "#527a7d",
                            fontSize: 46,
                            fontFamily: "arial"
                        },
                        legend: {
                            verticalAlign: "top"
                        },
                        data: [{
                            type: "doughnut",
                            startAngle: -90,
                            innerRadius: "65%",
                            showInLegend: true,
                            legendMarkerType: "square",
                            dataPoints:datapoints
                        }]
                    });
                    chartPlanned.render();

                }else{
                    $("#notFoundItemAmount").css("display", "block");
                    $("#chartPieItemAmount").css("display", "none");
                }

            }
        });
    }

    function getLinear(request){
        var typeRequest = 'getLinearGraph';
        var linearYear = $('#selectPeriodLinear').val();
        var selectFieldShow= $('#selectAmountShow').val();
        var typeDash    = $('#selectTypeYearAnalysis').val();
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/dashboards/getDashboardData.php',
            data: {
                'typeRequest':typeRequest,
                'requestDocument':request,
                'linearYear':linearYear,
                'selectFieldShow':selectFieldShow
            },
            success: function (result) {
                console.log(result);
                var dataReturn = JSON.parse(result);

                if (dataReturn.length>0) {
                    $("#notFoundLinear").css("display", "none");
                    $("#graphicsLinear").css("display", "block");

                    var chart = new CanvasJS.Chart("graphicsLinear", {
                        title: {
                            text: linearYear
                        },
                        axisY: {
                            title: "Amounts"
                        },
                        data: [{
                            type: typeDash,
                            dataPoints: dataReturn
                        }]
                    });
                    chart.render();
                }else{
                    $("#notFoundLinear").css("display", "block");
                    $("#graphicsLinear").css("display", "none");
                }
            }
        });
    }


    function getBestItems(request){
            var typeRequest = 'getBestItems';
            var dateFilter = $('#selectPeriodItem').val();
            var selectFieldShow= $('#selectAmountShow').val();
            $.ajax({
                type: "POST",
                url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/dashboards/getDashboardData.php',
                data: {
                    'typeRequest':typeRequest,
                    'requestDocument':request,
                    'dateFilter':dateFilter,
                    'selectFieldShow':selectFieldShow
                },
                success: function (result) {

                    var dataReturn = JSON.parse(result);
                    var items = dataReturn.arrayPersons;
                    var itemsCount      = dataReturn.arrayPercentage;
                    var datapoints      = dataReturn.datapoints;

                    if (datapoints.length>0) {
                        $("#notFoundItem").css("display", "none");
                        $("#chartPieItem").css("display", "block");

                        CanvasJS.addColorSet("customColors3", ["#57889c", "#99aff6", "#e8acc7", "#e7c69a", "#8ca765"]);
                        var chartPlanned = new CanvasJS.Chart("chartPieItem", {
                            colorSet: "customColors3",
                            title:{
                                text: '',
                                verticalAlign: "center",
                                dockInsidePlotArea: true,
                                fontColor: "#527a7d",
                                fontSize: 46,
                                fontFamily: "arial"
                            },
                            legend: {
                                verticalAlign: "top"
                            },
                            data: [{
                                type: "doughnut",
                                startAngle: -90,
                                innerRadius: "65%",
                                showInLegend: true,
                                legendMarkerType: "square",
                                dataPoints:datapoints
                            }]
                        });
                        chartPlanned.render();
                    }else{
                        $("#notFoundItem").css("display", "block");
                        $("#chartPieItem").css("display", "none");
                    }


                }
            });
    }

    function getBestSalesPerson(request){
        var typeRequest = 'getBestSalesperson';
        var dateFilter = $('#selectPeriodSalesperson').val();
        var selectFieldShow= $('#selectAmountShow').val();
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/dashboards/getDashboardData.php',
            data: {
                'typeRequest':typeRequest,
                'requestDocument':request,
                'dateFilter':dateFilter,
                'selectFieldShow':selectFieldShow
            },
            success: function (result) {

                var dataReturn = JSON.parse(result);
                var salesperson = dataReturn.arrayPersons;

                var salespersonPercantage      = dataReturn.arrayPercentage;
                if (salesperson.length>0){
                    $("#notFoundSalesperson").css("display", "none");
                    $("#graphics1").css("display", "block");
                    salespersonAnalitcs.updateAxisY(salesperson);
                    salespersonAnalitcs.updateBars(salespersonPercantage);
                    salespersonAnalitcs.sortByValue();
                    salespersonAnalitcs.runAnimation();
                }else{
                    $("#notFoundSalesperson").css("display", "block");
                    $("#graphics1").css("display", "none");
                }

            }
        });
    }

    function getBestCustomers(request){
        var typeRequest = 'getBestCustomers';
        var dateFilter = $('#selectPeriodCustomer').val();
        var selectFieldShow= $('#selectAmountShow').val();
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/dashboards/getDashboardData.php',
            data: {
                'typeRequest':typeRequest,
                'requestDocument':request,
                'dateFilter':dateFilter,
                'selectFieldShow':selectFieldShow
            },
            success: function (result) {

                var dataReturn = JSON.parse(result);

                var salesperson = dataReturn.arrayPersons;

                var salespersonPercantage      = dataReturn.arrayPercentage;
                if (salesperson.length){
                    $("#notFoundCustomer").css("display", "none");
                    $("#graphics2").css("display", "block");
                    customerAnalitcs.updateAxisY(salesperson);
                    customerAnalitcs.updateBars(salespersonPercantage);
                    customerAnalitcs.sortByValue();
                    customerAnalitcs.runAnimation();
                }else{
                    $("#notFoundCustomer").css("display", "block");
                    $("#graphics2").css("display", "none");
                }

            }
        });
    }

    function getYearsAnalysisSales(request){
        var typeRequest = 'getYearAnalysisSales';
        var linearYear = $('#selectPeriodAnalysisSalesperson').val();
        var selectFieldShow= $('#selectAmountShow').val();
        var typeDash    = $('#selectTypeYearAnalysis').val();
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/dashboards/getDashboardData.php',
            data: {
                'typeRequest':typeRequest,
                'requestDocument':request,
                'linearYear':linearYear,
                'selectFieldShow':selectFieldShow
            },
            success: function (result) {
                var dataReturn = JSON.parse(result);

                if (dataReturn.length>0) {
                    $("#notFoundAnalysisSales").css("display", "none");
                    $("#graphicsSalespersonAnalysis").css("display", "block");

                    $("#notFoundLinear").css("display", "none");
                    $("#graphicsLinear").css("display", "block");
                    var months = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
                    var counterMonth = -1;
                    var myBarChart = new CanvasJS.Chart("graphicsSalespersonAnalysis", {
                        theme: "light2",
                        axisX: {
                            interval: 1,
                            labelFormatter: function(e) {
                                var monthIndex = Math.floor(e.value / 3)
                                return e.value % 3 === 0 ? months[monthIndex] : "";
                            }
                        },
                        data: [
                            {
                                type: "column",
                                indexLabel: "",
                                dataPoints: dataReturn
                            }
                        ]
                    });
                    myBarChart.render();
                }else{
                    $("#notFoundAnalysisSales").css("display", "block");
                    $("#graphicsSalespersonAnalysis").css("display", "none");
                }
            }
        });
    }

    function getSales(request){
        var selectFieldShow= $('#selectAmountShow').val();
        var typeRequest = 'getSales';
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/dashboards/getDashboardData.php',
            data: {
                'typeRequest':typeRequest,
                'requestDocument':request,
                'selectFieldShow':selectFieldShow
            },
            success: function (result) {

                var dataReturn = JSON.parse(result);

                var todaySUM = dataReturn.todaySUM;
                var todayTitle = dataReturn.todayTitle;
                var todayTitleVS = dataReturn.todayTitleVS;
                var todayPercentage = dataReturn.todayPercentage;
                var todayPercentagePointer = dataReturn.todayPercentagePointer;
                if (todayPercentagePointer>0){
                    $('#todayPercentage').css('color','green');
                    var percentageElement = '<i class="fa fa-arrow-up"></i>'+todayPercentage+'%';
                }else{
                    var percentageElement = '<i class="fa fa-arrow-down"></i>'+todayPercentage+'%';
                    $('#todayPercentage').css('color','red');
                }
                $('#todayTitleVS').html(todayTitleVS);
                $('#todayTitle').html(todayTitle);
                $('#todaySUM').html(todaySUM);
                $('#todayPercentage').html(percentageElement);


                var todaySUM = dataReturn.weekSUM;
                var todayTitle = dataReturn.weekTitle;
                var todayTitleVS = dataReturn.weekTitleVS;
                var todayPercentage = dataReturn.weekPercentage;
                var todayPercentagePointer = dataReturn.weekPercentagePointer;
                if (todayPercentagePointer>0){
                    $('#weekPercentage').css('color','green');
                    var percentageElement = '<i class="fa fa-arrow-up"></i>'+todayPercentage+'%';
                }else{
                    var percentageElement = '<i class="fa fa-arrow-down"></i>'+todayPercentage+'%';
                    $('#weekPercentage').css('color','red');
                }
                $('#weekTitleVS').html(todayTitleVS);
                $('#weekTitle').html(todayTitle);
                $('#weekSUM').html(todaySUM);
                $('#weekPercentage').html(percentageElement);

                var todaySUM = dataReturn.monthSUM;
                var todayTitle = dataReturn.monthTitle;
                var todayTitleVS = dataReturn.monthTitleVS;
                var todayPercentage = dataReturn.monthPercentage;
                var todayPercentagePointer = dataReturn.monthPercentagePointer;
                if (todayPercentagePointer>0){
                    $('#monthPercentage').css('color','green');
                    var percentageElement = '<i class="fa fa-arrow-up"></i>'+todayPercentage+'%';
                }else{
                    var percentageElement = '<i class="fa fa-arrow-down"></i>'+todayPercentage+'%';
                    $('#monthPercentage').css('color','red');
                }
                $('#monthTitleVS').html(todayTitleVS);
                $('#monthTitle').html(todayTitle);
                $('#monthSUM').html(todaySUM);
                $('#monthPercentage').html(percentageElement);

                var todaySUM = dataReturn.yearSUM;
                var todayTitle = dataReturn.yearTitle;
                var todayTitleVS = dataReturn.yearTitleVS;
                var todayPercentage = dataReturn.yearPercentage;
                var todayPercentagePointer = dataReturn.yearPercentagePointer;
                if (todayPercentagePointer>0){
                    $('#yearPercentage').css('color','green');
                    var percentageElement = '<i class="fa fa-arrow-up"></i>'+todayPercentage+'%';
                }else{
                    var percentageElement = '<i class="fa fa-arrow-down"></i>'+todayPercentage+'%';
                    $('#yearPercentage').css('color','red');
                }
                $('#yearTitleVS').html(todayTitleVS);
                $('#yearTitle').html(todayTitle);
                $('#yearSUM').html(todaySUM);
                $('#yearPercentage').html(percentageElement);

            }
        });
    }

    var copMap;
    var copMapCustomers;
    var markers=[];
    var markersCustomers=[];
    document.addEventListener('DOMContentLoaded', () => {
        const elements = document.querySelectorAll('.fade-in');

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('visible');
                }
            });
        }, {
            threshold: 0.1
        });

        elements.forEach(element => observer.observe(element));
    });

    var salespersonAnalitcs = $('#graphics1').rumcaJS({
        data: {
            "axisX": ["10%", "20%", "30%", "40%", "50%", "60%", "70%", "80%", "90%", "100%"],         // Data for axis X labels
            "axisY": [""],         // Data for axis Y labels
            "bars": [0]       // Data for bars value
        },
        showValues: true,
        showHorizontalLines: true,
        animation: true,
        animationOffset: 0,
        labelsAboveBars: true,
        animationRepeat:false,

    });




    var customerAnalitcs = $('#graphics2').rumcaJS({
        data: {
            "axisX": ["10%", "20%", "30%", "40%", "50%", "60%", "70%", "80%", "90%", "100%"],         // Data for axis X labels
            "axisY": [""],         // Data for axis Y labels
            "bars": [0]       // Data for bars value
        },
        showValues: true,
        showHorizontalLines: true,
        animation: true,
        animationOffset: 0,
        labelsAboveBars: true,
    });

    // var items = ['Iphone','Mango','Truck','Box','Other'];
    // var itemsPercantage      = [50,15,20,10,5];
    // salespersonAnalitcs1.updateAxisY(items);
    // salespersonAnalitcs1.updateBars(itemsPercantage);
    // salespersonAnalitcs1.sortByValue();
    // salespersonAnalitcs1.runAnimation();



    //MAPS

    function initMapCustomer() {
        copMapCustomers = new google.maps.Map(document.getElementById('customerMap'), {
            center: {lat: 34.92, lng: 33.63},
            zoom: 8
        });
    }

    function updateMarkersCustomer()
    {
        $.ajax({
            dataType: "json",
            url: '<?php echo "//" . HTML_PATH . "/cop/backend/core/controllers/get/getDailyCustomerMarkers.php"?>',
            data: "",
            success: function(data) {

                for (var i = 0; i < markersCustomers.length; i++) {
                    markersCustomers[i].setMap(null);
                }

                $.each(data, function(index,value)
                {
                    markersCustomers[index] = new google.maps.Marker({
                        position: new google.maps.LatLng(value.lat,value.lng),
                        map: copMapCustomers,
                        title: value.label,
                        label: value.label.charAt(0),
                        url: value.url
                    });

                    google.maps.event.addListener(markersCustomers[index], 'click', function() {
                        window.location.href = this.url;
                    });
                });


            }
        });
    }

    function initMap() {
        copMap = new google.maps.Map(document.getElementById('salespersonMap'), {
            center: {lat: 34.92, lng: 33.63},
            zoom: 8
        });
    }

    function updateMarkers()
    {
        $.ajax({
            dataType: "json",
            url: '<?php echo "//" . HTML_PATH . "/cop/backend/core/controllers/get/getLastMarkers.php"?>',
            data: "",
            success: function(data) {
                for (var i = 0; i < markers.length; i++) {
                    markers[i].setMap(null);
                }

                $.each(data, function(index,value)
                {
                    markers[index] = new google.maps.Marker({
                        position: new google.maps.LatLng(value.lat,value.lng),
                        map: copMap,
                        title: value.label,
                        label: value.label.charAt(0)
                    });
                });
            }
        });
    }

    $(document).ready(function() {
        initMapCustomer();
        updateMarkersCustomer();
        initMap();
        updateMarkers();


        // DASHBOARD REQUEST
        getSales('Orders');
        getBestSalesPerson('Orders');
        getBestCustomers('Orders');
        getBestItems('Orders');
        getBestItemsAmount('Orders');
        getLinear('Orders');
        getYearsAnalysisSales('Orders');
    });
</script>