<?php
include_once("../../../../param.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

global $username, $password, $database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$warehousesArray = array();
$stm = $db->prepare("SELECT warehouse_id,warehouse_code,name FROM Warehouses");
$stm-> execute();
$stm-> bind_result($id,$code,$name);
while ($stm->fetch()) {
    $warehousesArray["$id"] = "$code - $name";
}
$stm->close();

$categoriesArray = array();
$stm = $db->prepare("SELECT category_id,category_code,name FROM Categories");
$stm-> execute();
$stm-> bind_result($id,$code,$name);
while ($stm->fetch()) {
    $categoriesArray["$id"] = "$code - $name";
}
$stm->close();

$groupsArray = array();
$stm = $db->prepare("SELECT group_id,group_code,name FROM CustomerGroups");
$stm-> execute();
$stm-> bind_result($id,$code,$name);
while ($stm->fetch()) {
    $groupsArray["$id"] = "$code - $name";
}
$stm->close();

$pricesArray = array();
$stm = $db->prepare("SELECT pricetype_id,price_code,name FROM PriceTypes");
$stm-> execute();
$stm-> bind_result($id,$code,$name);
while ($stm->fetch()) {
    $pricesArray["$id"] = "$code - $name";
}
$stm->close();

$crmTypesArray = array();
$stm = $db->prepare("SELECT type_id,type_name FROM CRM_Types");
$stm-> execute();
$stm-> bind_result($id,$name);
while ($stm->fetch()) {
    $crmTypesArray["$id"] = "$name";
}
$stm->close();

$edit = false;
$copy = false;
$viewOnly = false;

$spAllowedCategories = array();
$spAllowedGroups = array();
$spAllowedPrices = array();
$spAllowWarehouses = array();
$spAllowedCrmTypes = array();

if(isset($_GET['edit_salesperson_id'])){
    $salespersonID = $_GET['edit_salesperson_id'];
    $edit = true;
}

if(isset($_POST['edit_salesperson_id'])){
    $salespersonID = $_POST['edit_salesperson_id'];
    $edit = true;
}

if(isset($_GET['copy_salesperson_id'])){
    $salespersonID = $_GET['copy_salesperson_id'];
    $edit = true;
    $copy = true;
}

if(isset($_POST['copy_salesperson_id'])){
    $salespersonID = $_POST['copy_salesperson_id'];
    $edit = true;
    $copy = true;
}

if(isset($_GET['view_salesperson_id'])){
    $salespersonID = $_GET['view_salesperson_id'];
    $edit = true;
    $viewOnly = true;
}

if(isset($_POST['view_salesperson_id'])){
    $salespersonID = $_POST['view_salesperson_id'];
    $edit = true;
    $viewOnly = true;
}

if($edit) {
    $stm = $db->prepare("SELECT salesperson_code, first_name, last_name, landline, mobile, email, username, password, app_settings_password, default_warehouse_id, discard_warehouse_id, discount_allowance, allow_tenders, allow_invoices, allow_orders, allow_waybills, allow_returns, allow_receipts, allow_visits, allow_load, allow_unload, view_history, allow_anonymous_customer, allow_negative_stock, only_from_truck, order_stock_info, discount_allowance_line, anonymous_group_id, edit_schedule, create_schedule, allow_discount_receipt, gps_track, gps_track_distance, gps_track_time, take_picture, start_end_km_schedules, load_negative_qty, invoice_type_prefer, stock_reserved_calculation, erp_popular_products, default_qty, search_item_in_category, level_navigation, show_last_price, erp_last_price, show_price_after_discount, no_action_before_schedule, visit_all_before_end_schedule, allow_statements, waybill_show_prices_pdf, waybill_to_invoice_include_items, allow_customer_stock_taking, show_customer_stock_taking_info, allow_crm, cheque_mandatory, credit_limit_warning, stock_warning, allow_load_request, round_up_to_box, auto_generate_statement, allow_credit_note, post_dated_cheque_limit, return_only_from_invoice, post_dated_cheque_credit_limit, use_batch_numbers, return_policy, select_promotion_group, type, status, receivables_account, timestamp FROM SalesPersons WHERE salesperson_id = '$salespersonID' LIMIT 1");
    $stm->execute();
    $stm->bind_result($salespersonCode, $firstName, $lastName, $landline, $mobile, $email, $appUsername, $appPassword, $appSettingsPassword, $defaultWarehouseId, $discardWarehouseId, $discountAllowance, $allowTenders, $allowInvoices, $allowOrders, $allowWaybills, $allowReturns, $allowReceipts, $allowVisits, $allowLoad, $allowUnload, $viewHistory, $allowAnonymousCustomer, $allowNegativeStock, $onlyFromTruck, $orderStockInfo, $discountAllowanceLine, $anonymousGroupId, $editSchedule, $createSchedule, $allowDiscountReceipt, $gpsTrack, $gpsTrackDistance, $gpsTrackTime, $takePicture, $startEndKmSchedules, $loadNegativeQty, $invoiceTypePrefer, $stockReservedCalculation, $erpPopularProducts, $defaultQty, $searchItemInCategory, $levelNavigation, $showLastPrice, $erpLastPrice, $showPriceAfterDiscount, $noActionBeforeSchedule, $visitAllBeforeEndSchedule, $allowStatements, $waybillShowPricesPdf, $waybillToInvoiceIncludeItems, $allowCustomerStockTaking, $showCustomerStockTakingInfo, $allowCrm, $chequeMandatory, $creditLimitWarning, $stockWarning, $allowLoadRequest, $roundUpToBox, $autoGenerateStatement, $allowCreditNote, $postDatedChequeLimit, $returnOnlyFromInvoice, $postDatedChequeCreditLimit, $useBatchNumbers, $returnPolicy, $selectPromotionGroup, $type, $status, $receivablesAccount, $timestamp);
    while ($stm->fetch()) {}
    $stm->close();

    $gpsTrackTime = $gpsTrackTime / 1000 / 60;


    $stm = $db->prepare("SELECT category_id FROM Allow_Categories WHERE salesperson_id = '$salespersonID'");
    $stm->execute();
    $stm->bind_result($spAllowedCategorYId);
    while ($stm->fetch()) {
        array_push($spAllowedCategories,$spAllowedCategorYId);
    }
    $stm->close();


    $stm = $db->prepare("SELECT group_id FROM Allow_CustomerGroups WHERE salesperson_id = '$salespersonID'");
    $stm->execute();
    $stm->bind_result($spAllowedGroupId);
    while ($stm->fetch()) {
        array_push($spAllowedGroups,$spAllowedGroupId);
    }
    $stm->close();


    $stm = $db->prepare("SELECT pricetype_id FROM Allow_Prices WHERE salesperson_id = '$salespersonID'");
    $stm->execute();
    $stm->bind_result($spAllowedPriceId);
    while ($stm->fetch()) {
        array_push($spAllowedPrices,$spAllowedPriceId);
    }
    $stm->close();


    $stm = $db->prepare("SELECT warehouse_id FROM Allow_Warehouses WHERE salesperson_id = '$salespersonID'");
    $stm->execute();
    $stm->bind_result($spAllowWarehouseId);
    while ($stm->fetch()) {
        array_push($spAllowWarehouses,$spAllowWarehouseId);
    }
    $stm->close();


    $stm = $db->prepare("SELECT crm_type_id FROM Allow_CRM_Types WHERE salesperson_id = '$salespersonID'");
    $stm->execute();
    $stm->bind_result($spAllowedCrmTypeId);
    while ($stm->fetch()) {
        array_push($spAllowedCrmTypes,$spAllowedCrmTypeId);
    }
    $stm->close();

    if(strcmp($viewHistory,'yes')==0){$viewHistorySelectedYes = "selected";}
    if(strcmp($viewHistory,'no')==0){$viewHistorySelectedNo = "selected";}
    if(strcmp($viewHistory,'some')==0){$viewHistorySelectedSome = "selected";}

    if(strcmp($invoiceTypePrefer,'Cash')==0){$invoiceTypePreferSelectedCash = "selected";}
    if(strcmp($invoiceTypePrefer,'Credit')==0){$invoiceTypePreferSelectedCredit = "selected";}

    if(strcmp($status,'active')==0){$statusSelectedActive = "selected";}
    if(strcmp($status,'disabled')==0){$statusSelectedDisabled = "selected";}


    if($returnOnlyFromInvoice == 1){$returnOnlyFromInvoiceChecked = "checked";} else {$returnOnlyFromInvoiceChecked = "";}


    if(strcmp($allowLoad,'yes')==0){$allowLoadChecked = "checked";} else {$allowLoadChecked = "";}
    if(strcmp($allowUnload,'yes')==0){$allowUnloadChecked = "checked";} else {$allowUnloadChecked = "";}
    if(strcmp($allowVisits,'yes')==0){$allowVisitsChecked = "checked";} else {$allowVisitsChecked = "";}
    if(strcmp($allowOrders,'yes')==0){$allowOrdersChecked = "checked";} else {$allowOrdersChecked = "";}
    if(strcmp($allowWaybills,'yes')==0){$allowWaybillsChecked = "checked";} else {$allowWaybillsChecked = "";}
    if(strcmp($allowReturns,'yes')==0){$allowReturnsChecked = "checked";} else {$allowReturnsChecked = "";}
    if(strcmp($allowReceipts,'yes')==0){$allowReceiptsChecked = "checked";} else {$allowReceiptsChecked = "";}
    if(strcmp($allowTenders,'yes')==0){$allowTendersChecked = "checked";} else {$allowTendersChecked = "";}
    if(strcmp($allowInvoices,'yes')==0){$allowInvoicesChecked = "checked";} else {$allowInvoicesChecked = "";}
    if(strcmp($allowAnonymousCustomer,'yes')==0){$allowAnonymousCustomerChecked = "checked";} else {$allowAnonymousCustomerChecked = "";}
    if(strcmp($allowNegativeStock,'yes')==0){$allowNegativeStockChecked = "checked";} else {$allowNegativeStockChecked = "";}
    if(strcmp($onlyFromTruck,'yes')==0){$onlyFromTruckChecked = "checked";} else {$onlyFromTruckChecked = "";}
    if(strcmp($orderStockInfo,'yes')==0){$orderStockInfoChecked = "checked";} else {$orderStockInfoChecked = "";}
    if(strcmp($discountAllowanceLine,'yes')==0){$discountAllowanceLineChecked = "checked";} else {$discountAllowanceLineChecked = "";}
    if(strcmp($editSchedule,'yes')==0){$editScheduleChecked = "checked";} else {$editScheduleChecked = "";}
    if(strcmp($createSchedule,'yes')==0){$createScheduleChecked = "checked";} else {$createScheduleChecked = "";}
    if(strcmp($allowDiscountReceipt,'yes')==0){$allowDiscountReceiptChecked = "checked";} else {$allowDiscountReceiptChecked = "";}
    if(strcmp($gpsTrack,'yes')==0){$gpsTrackChecked = "checked";} else {$gpsTrackChecked = "";}
    if(strcmp($takePicture,'yes')==0){$takePictureChecked = "checked";} else {$takePictureChecked = "";}
    if(strcmp($startEndKmSchedules,'yes')==0){$startEndKmSchedulesChecked = "checked";} else {$startEndKmSchedulesChecked = "";}
    if(strcmp($loadNegativeQty,'yes')==0){$loadNegativeQtyChecked = "checked";} else {$loadNegativeQtyChecked = "";}
    if(strcmp($showLastPrice,'yes')==0){$showLastPriceChecked = "checked";} else {$showLastPriceChecked = "";}
    if(strcmp($erpLastPrice,'yes')==0){$erpLastPriceChecked = "checked";} else {$erpLastPriceChecked = "";}
    if(strcmp($showPriceAfterDiscount,'yes')==0){$showPriceAfterDiscountChecked = "checked";} else {$showPriceAfterDiscountChecked = "";}
    if(strcmp($noActionBeforeSchedule,'yes')==0){$noActionBeforeScheduleChecked = "checked";} else {$noActionBeforeScheduleChecked = "";}
    if(strcmp($visitAllBeforeEndSchedule,'yes')==0){$visitAllBeforeEndScheduleChecked = "checked";} else {$visitAllBeforeEndScheduleChecked = "";}
    if(strcmp($stockWarning,'yes')==0){$stockWarningChecked = "checked";} else {$stockWarningChecked = "";}
    if(strcmp($allowLoadRequest,'yes')==0){$allowLoadRequestChecked = "checked";} else {$allowLoadRequestChecked = "";}
    if(strcmp($stockReservedCalculation,'yes')==0){$stockReservedCalculationChecked = "checked";} else {$stockReservedCalculationChecked = "";}
    if(strcmp($allowCrm,'yes')==0){$allowCrmChecked = "checked";} else {$allowCrmChecked = "";}
    if(strcmp($allowCreditNote,'yes')==0){$allowCreditNoteChecked = "checked";} else {$allowCreditNoteChecked = "";}
    if(strcmp($allowStatements,'yes')==0){$allowStatementsChecked = "checked";} else {$allowStatementsChecked = "";}
    if(strcmp($allowCustomerStockTaking,'yes')==0){$allowCustomerStockTakingChecked = "checked";} else {$allowCustomerStockTakingChecked = "";}
    if(strcmp($waybillShowPricesPdf,'yes')==0){$waybillShowPricesPdfChecked = "checked";} else {$waybillShowPricesPdfChecked = "";}
    if(strcmp($waybillToInvoiceIncludeItems,'yes')==0){$waybillToInvoiceIncludeItemsChecked = "checked";} else {$waybillToInvoiceIncludeItemsChecked = "";}
    if(strcmp($showCustomerStockTakingInfo,'yes')==0){$showCustomerStockTakingInfoChecked = "checked";} else {$showCustomerStockTakingInfoChecked = "";}
    if(strcmp($creditLimitWarning,'yes')==0){$creditLimitWarningChecked = "checked";} else {$creditLimitWarningChecked = "";}
    if(strcmp($returnPolicy,'yes')==0){$returnPolicyChecked = "checked";} else {$returnPolicyChecked = "";}
    if(strcmp($autoGenerateStatement,'yes')==0){$autoGenerateStatementChecked = "checked";} else {$autoGenerateStatementChecked = "";}
    if(strcmp($chequeMandatory,'yes')==0){$chequeMandatoryChecked = "checked";} else {$chequeMandatoryChecked = "";}
    if(strcmp($postDatedChequeLimit,'yes')==0){$postDatedChequeLimitChecked = "checked";} else {$postDatedChequeLimitChecked = "";}
    if(strcmp($postDatedChequeCreditLimit,'yes')==0){$postDatedChequeCreditLimitChecked = "checked";} else {$postDatedChequeCreditLimitChecked = "";}
    if(strcmp($selectPromotionGroup,'yes')==0){$selectPromotionGroupChecked = "checked";} else {$selectPromotionGroupChecked = "";}
    if(strcmp($erpPopularProducts,'yes')==0){$erpPopularProductsChecked = "checked";} else {$erpPopularProductsChecked = "";}
    if(strcmp($searchItemInCategory,'yes')==0){$searchItemInCategoryChecked = "checked";} else {$searchItemInCategoryChecked = "";}
    if(strcmp($levelNavigation,'yes')==0){$levelNavigationChecked = "checked";} else {$levelNavigationChecked = "";}

    if(strcmp($roundUpToBox,'yes')==0){$roundUpToBoxSelectedYes = "selected";}
    if(strcmp($roundUpToBox,'no')==0){$roundUpToBoxSelectedNo = "selected";}
    if(strcmp($roundUpToBox,'multiply')==0){$roundUpToBoxSelectedMultiply = "selected";}

    if(strcmp($useBatchNumbers,'yes')==0){$useBatchNumbersSelectedYes = "selected";}
    if(strcmp($useBatchNumbers,'no')==0){$useBatchNumbersSelectedNo = "selected";}
    if(strcmp($useBatchNumbers,'perItem')==0){$useBatchNumbersSelectedPerItem = "selected";}



}

$custForm= new CustomForm('SalesPersons',$salespersonID);
$custTable = new CustomTable('SalesPersons',$salespersonID);
?>
<style>
    .select2-container, .select2-selection--single { height: auto; }
    .tableSingleLines tr td { border-right: 1px transparent !important;border-left: 1px transparent !important; }
    .checkbox { padding-right: 3px !important; border: 2px transparent }
</style>
		<div id="main" role="main">
			
			<!-- Start CUSTOM CODE-->		
			

			<!-- RIBBON -->
			<div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment"> 
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span> 
				</span>

				<!-- breadcrumb -->
				<ol class="breadcrumb">
					<li class="txt-color-white">Home / Add a new User</li>
				</ol>
				<!-- end breadcrumb -->
				

			</div>
			<!-- END RIBBON -->

			<!-- MAIN CONTENT -->
			<div id="content">

<div class="row">
	<div class="col-xs-12 col-sm-8 col-md-8 col-lg-8">
		<h3 class="page-title txt-color-blueDark header-margin">
			<i class="fa-fw fa fa-user"></i>
			<?php if($viewOnly){echo "View"; } else if($edit && !$copy){echo "Edit";} else {echo "Add";} ?> User
		</h3>
	</div>
    <div class="col-xs-12 col-sm-2 col-md-2 col-lg-2">
        <?php
        if($viewOnly){
            echo "<a href='//".HTML_PATH."/cop/backend/core/views/addedit/new_user.php?edit_salesperson_id=$salespersonID' id='editRedirectButton' class='btn btn-block btn-primary' style='margin-top: 2px;margin-bottom: 2px;' ><i class='fa fa-pencil'></i>&nbsp; Edit User</a>";
        }
        ?>
    </div>
    <div class="col-xs-12 col-sm-2 col-md-2 col-lg-2">
            <?php
            if($viewOnly){
                echo "<a href='//".HTML_PATH."/cop/backend/core/views/addedit/new_user.php?copy_salesperson_id=$salespersonID' id='copyRedirectButton' class='btn btn-block btn-return' style='margin-top: 2px;margin-bottom: 2px;' ><i class='fa fa-copy'></i>&nbsp; Copy User</a>";
            } else {
                echo '<button type="button"  class="btn btn-success btn-block pull-right" id="saveButton" onclick="saveSalesperson();" ><i class="fa fa-check"></i>&nbsp; ';
                if($edit && !$copy){echo 'Save';}else{echo "Create";}
                echo ' User</button>';
            }
            ?>
    </div>
</div>






<!-- row -->
            <section id="widget-grid" class="">
					<!-- row -->
					<div class="row">

						<article class="col-xs-12 col-sm-12 col-md-12 col-lg-12" >
											
							<div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-0451" data-widget-editbutton="false" data-widget-deletebutton="false">
								<header>
									<span class="widget-icon"> <i class="fa fa-user"></i> </span>
									<h2>User Settings</h2>
				
								</header>
				
								<!-- widget div-->
								<div>
									<!-- widget content -->
									<div class="widget-body">
										<form id="smart-form-salesperson" method="post" class="smart-form" action="#" style="border: solid 1px #ccc" >
		                                <fieldset>

						
						                    <div class="row">
									            <section class="col col-4">
                                                    <section>
                                                        <section>
                                                            <i class="fa-fw fa fa-user fa-lg"></i>
                                                            <h3 style="display: inline;margin-left:6px;vertical-align: middle"> User Info</h3>
                                                        </section>
                                                    </section>
                                                    <section >
                                                        <input type="hidden" id="salespersonID" value="<?php if($edit){echo "$salespersonID";}else{ echo "0";}?>">
                                                        <label class="input" style="margin-right:20px;"> <i class="icon-prepend fa fa-code"></i>
                                                            <input id="salespersonCode" type="text" placeholder="User Code" name="salespersonCode" data-validation="length" data-validation-length="2-30" value="<?php if($edit && !$copy){echo "$salespersonCode";}?>" >
                                                            <b class="tooltip tooltip-bottom-right">User Code</b>
                                                        </label>
                                                    </section>
                                                    <div class="row">
                                                        <section class="col col-6">
                                                            <label class="input" style="margin-right:20px;"> <i class="icon-prepend fa fa-user"></i>
                                                                <input id="firstName" type="text" placeholder="First Name" name="firstName" data-validation="length" data-validation-length="2-30" value="<?php if($edit){echo "$firstName";}?>" >
                                                                <b class="tooltip tooltip-bottom-right">User First Name</b>
                                                            </label>
                                                        </section>
                                                        <section class="col col-6">
                                                            <label class="input" style="margin-right:20px;"> <i class="icon-prepend fa fa-user"></i>
                                                                <input id="lastName" type="text" placeholder="Last Name" name="lastName" data-validation="length" data-validation-length="2-30" value="<?php if($edit){echo "$lastName";}?>" >
                                                                <b class="tooltip tooltip-bottom-right">User Last Name</b>
                                                            </label>
                                                        </section>
                                                    </div>
                                                    <section >
                                                        <label class="input" style="margin-right:20px;"> <i class="icon-prepend fa fa-filter"></i>
                                                            <input id="type" type="text" placeholder="User Type (Optional)" name="type" data-validation="length" data-validation-length="2-30" value="<?php if($edit){echo "$type";}?>" >
                                                            <b class="tooltip tooltip-bottom-right">User Type</b>
                                                        </label>
                                                    </section>

                                                    <div class="row">
                                                        <section class="col col-6">
                                                            <label class="input" style="margin-right:20px;"> <i class="icon-prepend fa fa-phone"></i>
                                                                <input id="mobile" type="text" placeholder="Mobile Phone (Optional)" name="mobile" data-validation="length" data-validation-length="2-30" value="<?php if($edit){echo "$mobile";}?>">
                                                                <b class="tooltip tooltip-bottom-right">User Mobile Number</b> </label>
                                                        </section>

                                                        <section class="col col-6">
                                                            <label class="input" style="margin-right:20px;"> <i class="icon-prepend fa fa-phone"></i>
                                                                <input id="landline" type="text" placeholder="Landline (Optional)" name="landline" data-validation="length" data-validation-length="2-30" value="<?php if($edit){echo "$landline";}?>">
                                                                <b class="tooltip tooltip-bottom-right">User Landline</b> </label>
                                                        </section>
                                                    </div>
                                                    <section>
                                                        <label class="input" style="margin-right:20px;"> <i class="icon-prepend fa fa-envelope-o"></i>
                                                            <input id="email" type="email" placeholder="Email Address (Optional)" name="email" data-validation="length" data-validation-length="5-50" value="<?php if($edit){echo "$email";}?>">
                                                            <b class="tooltip tooltip-bottom-right">User Email</b>
                                                        </label>
                                                    </section>

                                                    <section>
                                                        <label class="input" style="margin-right:20px;"> <i class="icon-prepend fa fa-money"></i>
                                                            <input id="receivablesAccount" type="text" placeholder="Receivables Account (Optional)" name="receivablesAccount" data-validation="length" data-validation-length="5-50" value="<?php if($edit){echo "$receivablesAccount";}?>">
                                                            <b class="tooltip tooltip-bottom-right">Receivables Account</b>
                                                        </label>
                                                    </section>

                                                    <section>
                                                        <section>
                                                            <i class="fa-fw fa fa-mobile fa-lg"></i>
                                                            <h3 style="display: inline;margin-left:6px;vertical-align: middle"> App Access</h3>
                                                        </section>
                                                    </section>
                                                    <div class="row">
                                                        <section class="col col-6">
                                                            <label class="input" style="margin-right:20px;"> <i class="icon-prepend fa fa-lock"></i>
                                                                <input id="username" type="text" placeholder="App Username" name="username" data-validation="length" data-validation-length="2-30" value="<?php if($edit){echo "$appUsername";}?>">
                                                                <b class="tooltip tooltip-bottom-right">App Username</b>
                                                            </label>
                                                        </section>
                                                        <section class="col col-6">
                                                            <label class="input" style="margin-right:20px;">
                                                                <i class="icon-prepend fa fa-lock"></i>
                                                                <input id="password" type="text" placeholder="App Password" name="password" data-validation="strength" data-validation-strength="1"  autocomplete="off" value="<?php if($edit){echo "$appPassword";}?>" >
                                                                <b class="tooltip tooltip-bottom-right">App Password</b>
                                                            </label>
                                                        </section>
                                                    </div>
                                                    <section>
                                                        <label class="input" style="margin-right:20px;">
                                                            <i class="icon-prepend fa fa-mobile"></i>
                                                            <input id="appSettingsPassword" type="text" placeholder="App Settings Password" name="appSettingsPassword" data-validation="strength" data-validation-strength="1"  autocomplete="off" value="<?php if($edit){echo "$appSettingsPassword";}?>">
                                                            <b class="tooltip tooltip-bottom-right">App Settings Password</b>
                                                        </label>
                                                    </section>

                                                    <section>
                                                        <section>
                                                            <i class="fa-fw fa fa-wrench fa-lg"></i>
                                                            <h3 style="display: inline;margin-left:6px;vertical-align: middle"> User Preferences</h3>
                                                        </section>
                                                    </section>

                                                    <section>
                                                        <table style="width: 100%;">
                                                            <tr>
                                                                <td><label class="label">&nbsp; User Status:</label></td>
                                                                <td>
                                                                    <select style="width:95%;margin-right: 20px;" name="status" id="status" class="js-example-basic-single">
                                                                        <option value="active" <?php echo $statusSelectedActive; ?>>Active</option>
                                                                        <option value="disabled" <?php echo $statusSelectedDisabled; ?>>Disabled</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td><label class="label">&nbsp; Default Warehouse:</label></td>
                                                                <td>
                                                                    <select style="width:95%;margin-right: 20px;" name="defaultWarehouse" id="defaultWarehouse" class="js-example-basic-single">
                                                                        <option value=""></option>
                                                                        <?php
                                                                        foreach ($warehousesArray as $id => $name){
                                                                            if($edit && $id == $defaultWarehouseId) {
                                                                                echo "<option value='$id' selected>$name</option>";
                                                                            } else{
                                                                                echo "<option value='$id'>$name</option>";

                                                                            }
                                                                        }
                                                                        ?>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td><label class="label">&nbsp; Discard Warehouse:</label></td>
                                                                <td>
                                                                    <select style="width:95%;margin-right: 20px;" name="discardWarehouse" id="discardWarehouse" class="js-example-basic-single">
                                                                        <option value=""></option>
                                                                        <?php
                                                                        foreach ($warehousesArray as $id => $name){
                                                                            if($edit && $id == $discardWarehouseId) {
                                                                                echo "<option value='$id' selected>$name</option>";
                                                                            } else{
                                                                                echo "<option value='$id'>$name</option>";

                                                                            }
                                                                        }
                                                                        ?>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td><label class="label">&nbsp; Anonymous Group:</label></td>
                                                                <td>
                                                                    <select style="width:95%;margin-right: 20px;" name="anonymousGroup" id="anonymousGroup" class="js-example-basic-single">
                                                                        <option value=""></option>
                                                                        <?php
                                                                        foreach ($groupsArray as $id => $name){
                                                                            if($edit && $id == $anonymousGroupId) {
                                                                                echo "<option value='$id' selected>$name</option>";
                                                                            } else{
                                                                                echo "<option value='$id'>$name</option>";

                                                                            }}
                                                                        ?>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td><label class="label">&nbsp; View Actions History:</label></td>
                                                                <td>
                                                                    <select style="width:95%;margin-right: 20px;" name="viewHistory" id="viewHistory" class="js-example-basic-single">
                                                                        <option value="yes" <?php echo $viewHistorySelectedYes; ?>>Yes</option>
                                                                        <option value="some" <?php echo $viewHistorySelectedSome; ?>>Some</option>
                                                                        <option value="no" <?php echo $viewHistorySelectedNo; ?>>No</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td><label class="label">&nbsp; Invoice Preferred Type:</label></td>
                                                                <td>
                                                                    <select style="width:95%;margin-right: 20px;" name="invoiceTypePrefer" id="invoiceTypePrefer" class="js-example-basic-single">
                                                                        <option value="Cash" <?php echo $invoiceTypePreferSelectedCash; ?>>Cash</option>
                                                                        <option value="Credit" <?php echo $invoiceTypePreferSelectedCredit; ?>>Credit</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                        </table>
                                                    </section>

							                    </section>
                                                <section class="col col-4">
                                                    <section>
                                                        <section>
                                                            <i class="fa-fw fa fa-archive fa-lg"></i>
                                                            <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Stock Settings</h3>
                                                        </section>
                                                    </section>
                                                    <section>
                                                        <table style="width: 100%;">
                                                            <tr>
                                                                <td >
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="allowLoad" id="allowLoad" <?php echo $allowLoadChecked; ?> value ="yes">
                                                                        <i></i>Allow Load
                                                                    </label>
                                                                </td>
                                                                <td>
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="stockWarning" id="stockWarning" <?php echo $stockWarningChecked; ?> value ="yes">
                                                                        <i></i>Stock Warning
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td >
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="allowUnload" id="allowUnload" <?php echo $allowUnloadChecked; ?> value ="yes">
                                                                        <i></i>Allow Unload
                                                                    </label>
                                                                </td>
                                                                <td>
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="allowNegativeStock" id="allowNegativeStock" <?php echo $allowNegativeStockChecked; ?> value ="yes">
                                                                        <i></i>Allow Negative Stock
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="loadNegativeQty" id="loadNegativeQty" <?php echo $loadNegativeQtyChecked; ?> value ="yes">
                                                                        <i></i>Load negative qty
                                                                    </label>

                                                                </td>
                                                                <td>
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="onlyFromTruck" id="onlyFromTruck" <?php echo $onlyFromTruckChecked; ?> value ="yes">
                                                                        <i></i>Stock Only From Truck
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="allowLoadRequest" id="allowLoadRequest" <?php echo $allowLoadRequestChecked; ?> value ="yes">
                                                                        <i></i>Allow Load Request
                                                                    </label>
                                                                </td>
                                                                <td>
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="orderStockInfo" id="orderStockInfo" <?php echo $orderStockInfoChecked; ?> value ="yes">
                                                                        <i></i>Show stock info on Order
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>

                                                                <td>
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="stockReservedCalculation" id="stockReservedCalculation" <?php echo $stockReservedCalculationChecked; ?> value ="yes">
                                                                        <i></i>Stock Reserved Calculation
                                                                    </label>
                                                                </td>

                                                               <td></td>

                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td><label class="label">Use Batch Numbers:</label></td>
                                                                <td >
                                                                    <select style="width:100%;margin-right: 20px;" name="useBatchNumbers" id="useBatchNumbers" class="js-example-basic-single">
                                                                        <option value="no" <?php echo $useBatchNumbersSelectedNo; ?>>No</option>
                                                                        <option value="yes" <?php echo $useBatchNumbersSelectedYes; ?>>Yes</option>
                                                                        <option value="perItem" <?php echo $useBatchNumbersSelectedPerItem; ?>>Per Item</option>
                                                                    </select>

                                                                </td>
                                                            </tr>

                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>

                                                        </table>
                                                    </section>

                                                    <section>
                                                        <section>
                                                            <i class="fa-fw fa fa-calendar fa-lg"></i>
                                                            <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Schedule Settings</h3>
                                                        </section>
                                                    </section>

                                                    <section>
                                                        <table style="width: 100%;">
                                                            <tr>
                                                                <td >
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="createSchedule" id="createSchedule" <?php echo $createScheduleChecked; ?> value ="yes">
                                                                        <i></i>Create Schedule
                                                                    </label>
                                                                </td>
                                                                <td>
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="visitAllBeforeSchedule" id="visitAllBeforeEndSchedule" <?php echo $visitAllBeforeEndScheduleChecked; ?> value ="yes">
                                                                        <i></i>Visit All to finish Schedule.
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td >
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="editSchedule" id="editSchedule" <?php echo $editScheduleChecked; ?> value ="yes">
                                                                        <i></i>Allow Edit Schedule
                                                                    </label>
                                                                </td>
                                                                <td>
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="noActionBeforeSchedule" id="noActionBeforeSchedule" <?php echo $noActionBeforeScheduleChecked; ?> value ="yes">
                                                                        <i></i>No Action before Schedule
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td >
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="startEndKmSchedules" id="startEndKmSchedules" <?php echo $startEndKmSchedulesChecked; ?> value ="yes">
                                                                        <i></i>Enable Start/End Km
                                                                    </label>
                                                                </td>
                                                                <td>

                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                        </table>
                                                    </section>

                                                    <section>
                                                        <section>
                                                            <i class="fa-fw fa fa-location-arrow fa-lg"></i>
                                                            <h3 style="display: inline;margin-left:6px;vertical-align: middle"> GPS Settings</h3>
                                                        </section>
                                                    </section>

                                                    <section>
                                                        <table style="width: 100%;">
                                                            <tr>
                                                                <td >
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="gpsTrack" id="gpsTrack" <?php echo $gpsTrackChecked; ?> value ="yes">
                                                                        <i></i>GPS Track
                                                                    </label>
                                                                </td>
                                                                <td>
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="takePicture" id="takePicture" <?php echo $takePictureChecked; ?> value ="yes">
                                                                        <i></i>Take Picture
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 8px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td><label class="label">Track Distance (meters):</label></td>
                                                                <td>
                                                                    <label class="input">
                                                                        <i class="icon-prepend fa fa-road"></i>
                                                                        <input name="gpsTrackDistance" id="gpsTrackDistance" type="number" placeholder="Track Distance (meters)" class="" value="<?php if($gpsTrackDistance > 0){echo $gpsTrackDistance;} ?>">
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td><label class="label">Track Time (minutes):</label></td>
                                                                <td>
                                                                    <label class="input">
                                                                        <i class="icon-prepend fa fa-clock-o"></i>
                                                                        <input name="gpsTrackTime" id="gpsTrackTime" type="number" placeholder="Track Time (minutes)" class="" value="<?php if($gpsTrackTime > 0){echo $gpsTrackTime;} ?>">
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                        </table>
                                                    </section>

                                                    <section>
                                                        <section>
                                                            <i class="fa-fw fa fa-money fa-lg"></i>
                                                            <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Discount Settings</h3>
                                                        </section>
                                                    </section>

                                                    <section>
                                                        <table style="width: 100%;">
                                                            <tr>
                                                                <td >
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="allowDiscountReceipt" id="allowDiscountReceipt" <?php echo $allowDiscountReceiptChecked; ?> value ="yes">
                                                                        <i></i>Allow Discount Receipt
                                                                    </label>
                                                                </td>
                                                                <td>
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="showPriceAfterDiscount" id="showPriceAfterDiscount" <?php echo $showPriceAfterDiscountChecked; ?> value ="yes">
                                                                        <i></i>Show Price After Discount
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 8px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td><label class="label">Discount Allowance:</label></td>
                                                                <td>
                                                                    <label class="input">
                                                                        <i class="icon-prepend fa fa-money"></i>
                                                                        <input name="discountAllowance" id="discountAllowance" type="number" placeholder="Discount Allowance" class="" value="<?php if($discountAllowance > 0){echo $discountAllowance;} ?>">
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td><label class="label">Discount Allowance Line:</label></td>
                                                                <td>
                                                                    <label class="input">
                                                                        <i class="icon-prepend fa fa-file-text"></i>
                                                                        <input name="discountAllowanceLine" id="discountAllowanceLine" type="number" placeholder="Discount Allowance Line" class="" value="<?php if($discountAllowanceLine > 0){echo $discountAllowanceLine;} ?>">
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                        </table>
                                                    </section>



							                    </section>

                                                <section class="col col-4">

                                                    <section>
                                                        <section>
                                                            <i class="fa-fw fa fa-file fa-lg"></i>
                                                            <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Allow Actions</h3>
                                                        </section>
                                                    </section>

                                                    <section>
                                                        <div class="row">
                                                            <div class="col col-5">
                                                                <label class="checkbox">
                                                                    <input type="checkbox" name="allowTenders" id="allowTenders" <?php echo $allowTendersChecked; ?> value ="yes">
                                                                    <i></i>Allow Tenders
                                                                </label>
                                                                <label class="checkbox">
                                                                    <input type="checkbox" name="allowOrders" id="allowOrders" <?php echo $allowOrdersChecked; ?> value ="yes">
                                                                    <i></i>Allow Orders
                                                                </label>
                                                                <label class="checkbox">
                                                                    <input type="checkbox" name="allowWaybills" id="allowWaybills" <?php echo $allowWaybillsChecked; ?> value ="yes">
                                                                    <i></i>Allow Waybills
                                                                </label>
                                                                <label class="checkbox">
                                                                    <input type="checkbox" name="allowVisits" id="allowVisits" <?php echo $allowVisitsChecked; ?> value ="yes">
                                                                    <i></i>Allow Visits
                                                                </label>
                                                                <label class="checkbox">
                                                                    <input type="checkbox" name="allowCrm" id="allowCrm" <?php echo $allowCrmChecked; ?> value ="yes">
                                                                    <i></i>Allow CRM
                                                                </label>
                                                                <label class="checkbox">
                                                                    <input type="checkbox" name="allowCreditNote" id="allowCreditNote" <?php echo $allowCreditNoteChecked; ?> value ="yes">
                                                                    <i></i>Allow Credit Note
                                                                </label>
                                                            </div>
                                                            <div class="col col-7">
                                                                <label class="checkbox">
                                                                    <input type="checkbox" name="allowInvoices" id="allowInvoices" <?php echo $allowInvoicesChecked; ?> value ="yes">
                                                                    <i></i>Allow Invoices
                                                                </label>
                                                                <label class="checkbox">
                                                                    <input type="checkbox" name="allowReturns" id="allowReturns" <?php echo $allowReturnsChecked; ?> value ="yes">
                                                                    <i></i>Allow Returns
                                                                </label>
                                                                <label class="checkbox">
                                                                    <input type="checkbox" name="allowReceipts" id="allowReceipts" <?php echo $allowReceiptsChecked; ?> value ="yes">
                                                                    <i></i>Allow Receipts
                                                                </label>
                                                                <label class="checkbox">
                                                                    <input type="checkbox" name="allowStatements" id="allowStatements" <?php echo $allowStatementsChecked; ?> value ="yes">
                                                                    <i></i>Allow Statements
                                                                </label>
                                                                <label class="checkbox">
                                                                    <input type="checkbox" name="allowCustomerStockTaking" id="allowCustomerStockTaking" <?php echo $allowCustomerStockTakingChecked; ?> value ="yes">
                                                                    <i></i>Customer Stock Taking
                                                                </label>
                                                                <label class="checkbox">
                                                                    <input type="checkbox" name="allowAnonymousCustomer" id="allowAnonymousCustomer" <?php echo $allowAnonymousCustomerChecked; ?> value ="yes">
                                                                    <i></i>Anonymous Customer
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </section>

                                                    <section>
                                                        <section>
                                                            <i class="fa-fw fa fa-file-text fa-lg"></i>
                                                            <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Actions Settings</h3>
                                                        </section>
                                                    </section>

                                                    <section>
                                                        <table style="width: 100%;">

                                                            <tr>
                                                                <td>
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="showLastPrice" id="showLastPrice" <?php echo $showLastPriceChecked; ?> value ="yes">
                                                                        <i></i>Show Last Prices
                                                                    </label>
                                                                </td>
                                                                <td >
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="erpLastPrice" id="erpLastPrice" <?php echo $erpLastPriceChecked; ?> value ="yes">
                                                                        <i></i>ERP Last Prices
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td >
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="waybillShowPricesPdf" id="waybillShowPricesPdf" <?php echo $waybillShowPricesPdfChecked; ?> value ="yes">
                                                                        <i></i>Waybill Prices on PDF
                                                                    </label>
                                                                </td>
                                                                <td>
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="waybillToInvoiceIncludeItems" id="waybillToInvoiceIncludeItems" <?php echo $waybillToInvoiceIncludeItemsChecked; ?> value ="yes">
                                                                        <i></i>Waybill to Invoice With Items
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="showCustomerStockTakingInfo" id="showCustomerStockTakingInfo" <?php echo $showCustomerStockTakingInfoChecked; ?> value ="yes">
                                                                        <i></i>Customer Stock Taking Info
                                                                    </label>
                                                                </td>
                                                                <td >
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="creditLimitWarning" id="creditLimitWarning" <?php echo $creditLimitWarningChecked; ?> value ="yes">
                                                                        <i></i>Credit Limit Warning
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="returnOnlyFromInvoice" id="returnOnlyFromInvoice" <?php echo $returnOnlyFromInvoiceChecked; ?> value ="yes">
                                                                        <i></i>Return Only Invoice
                                                                    </label>
                                                                </td>
                                                                <td >
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="returnPolicy" id="returnPolicy" <?php echo $returnPolicyChecked; ?> value ="yes">
                                                                        <i></i>Return Policy
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="autoGenerateStatement" id="autoGenerateStatement" <?php echo $autoGenerateStatementChecked; ?> value ="yes">
                                                                        <i></i>Auto Generate Statement
                                                                    </label>
                                                                </td>
                                                                <td >
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="chequeMandatory" id="chequeMandatory" <?php echo $chequeMandatoryChecked; ?> value ="yes">
                                                                        <i></i>Cheque is Mandatory
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="postDatedChequeLimit" id="postDatedChequeLimit" <?php echo $postDatedChequeLimitChecked; ?> value ="yes">
                                                                        <i></i>Post Dated Cheque Limit
                                                                    </label>
                                                                </td>
                                                                <td >
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="postDatedChequeCreditLimit" id="postDatedChequeCreditLimit" <?php echo $postDatedChequeCreditLimitChecked; ?> value ="yes">
                                                                        <i></i>Post Dated Cheque Credit Limit
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="selectPromotionGroup" id="selectPromotionGroup" <?php echo $selectPromotionGroupChecked; ?> value ="yes">
                                                                        <i></i>Select Promo Group
                                                                    </label>
                                                                </td>
                                                                <td >

                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 8px;">&nbsp;</td>
                                                            </tr>


                                                        </table>
                                                    </section>

                                                    <section>
                                                        <section>
                                                            <i class="fa-fw fa fa-gift fa-lg"></i>
                                                            <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Product Settings</h3>
                                                        </section>
                                                    </section>

                                                    <section>
                                                        <table style="width: 100%;">
                                                            <tr>
                                                                <td >
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="erpPopularProducts" id="erpPopularProducts" <?php echo $erpPopularProductsChecked; ?> value ="yes">
                                                                        <i></i>ERP Popular Products
                                                                    </label>
                                                                </td>
                                                                <td>
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="searchItemInCategory" id="searchItemInCategory" <?php echo $searchItemInCategoryChecked; ?> value ="yes">
                                                                        <i></i>Search Item In Category
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td >
                                                                    <label class="checkbox pull-left">
                                                                        <input type="checkbox" name="levelNavigation" id="levelNavigation" <?php echo $levelNavigationChecked; ?> value ="yes">
                                                                        <i></i>Level Navigation
                                                                    </label>
                                                                </td>
                                                                <td>

                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 5px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td><label class="label">Round Up to Box:</label></td>
                                                                <td >
                                                                    <select style="width:100%;margin-right: 20px;" name="roundUpToBox" id="roundUpToBox" class="js-example-basic-single">
                                                                        <option value="no" <?php echo $roundUpToBoxSelectedNo; ?>>No</option>
                                                                        <option value="yes" <?php echo $roundUpToBoxSelectedYes; ?>>Yes</option>
                                                                        <option value="multiply" <?php echo $roundUpToBoxSelectedMultiply; ?>>Multiply</option>
                                                                    </select>

                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td><label class="label">Default Product qty:</label></td>
                                                                <td>
                                                                    <label class="input">
                                                                        <i class="icon-prepend fa fa-gift"></i>
                                                                        <input name="defaultQty" id="defaultQty" type="number" placeholder="Default qty" class="" value="<?php if($defaultQty > 0){echo $defaultQty;} ?>">
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size: 3px;">&nbsp;</td>
                                                            </tr>
                                                        </table>
                                                    </section>

                                                    <!-- Custom Fields-->
                                                    <section>
                                                        <?php
                                                        $custTable->editCustomTableValues();
                                                        $custForm->editCustomFormValues();
                                                        ?>
                                                    </section>
                                                    <!-- Custom Fields/-->

                                                </section>
                                            </div>
						 	            </fieldset>

                               </form>
                            </div>
									<!-- end widget content -->
				        </div>
								<!-- end widget div -->
                     </div>

                        </article>


                        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12" >

                            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-0575" data-widget-editbutton="false" data-widget-deletebutton="false" >
                                <header>
                                    <span class="widget-icon"> <i class="fa fa-filter"></i> </span>
                                    <h2>User Restrictions</h2>

                                </header>

                                <div>

                                    <div class="widget-body" >
                                        <table class="table table-bordered tableSingleLines" style="width: 100%">
                                            <tr>
                                                <td style="width: auto;"><span class="widget-icon"> <i class="fa fa-sitemap"></i> </span></td>
                                                <td style="width: 27%;"><h5 style="text-align: left">Allow Categories: </h5></td>
                                                <td>
                                                    <select style="" name="allowCategories" id="allowCategories" class="form-control block" multiple="multiple">
                                                        <?php
                                                        foreach ($categoriesArray as $id => $name){
                                                            if(in_array($id,$spAllowedCategories)){
                                                                echo "<option value='$id' selected>$name</option>";
                                                            } else {
                                                                echo "<option value='$id'>$name</option>";
                                                            }

                                                        }
                                                        ?>
                                                    </select>
                                                </td>
                                            <tr>
                                                <td><span class="widget-icon"> <i class="fa fa-users"></i> </span></td>
                                                <td><h5 style="text-align: left">Allow Customer Groups: </h5></td>
                                                <td>
                                                    <select style="" name="allowCustomerGroups" id="allowCustomerGroups" class="form-control block" multiple="multiple">

                                                        <?php
                                                        foreach ($groupsArray as $id => $name){
                                                            if(in_array($id,$spAllowedGroups)){
                                                                echo "<option value='$id' selected>$name</option>";
                                                            } else {
                                                                echo "<option value='$id'>$name</option>";
                                                            }

                                                        }
                                                        ?>

                                                    </select>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><span class="widget-icon"> <i class="fa fa-money"></i> </span></td>
                                                <td><h5 style="text-align: left">Allow Prices: </h5></td>
                                                <td>
                                                    <select style="" name="allowPrices" id="allowPrices" class="form-control block" multiple="multiple">

                                                        <?php
                                                        foreach ($pricesArray as $id => $name){
                                                            if(in_array($id,$spAllowedPrices)){
                                                                echo "<option value='$id' selected>$name</option>";
                                                            } else {
                                                                echo "<option value='$id'>$name</option>";
                                                            }
                                                        }
                                                        // added by iliada

                                                        if(in_array(98,$spAllowedPrices)){
                                                            echo "<option value='98' selected>Manual Price</option>";
                                                        }
                                                        else if(!in_array(98,$spAllowedPrices)){
                                                            echo "<option value='98' >Manual Price</option>";
                                                        }

                                                        ?>

                                                    </select>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><span class="widget-icon"> <i class="fa fa-archive"></i> </span></td>
                                                <td><h5 style="text-align: left">Allow Warehouses: </h5></td>
                                                <td>
                                                    <select style="" name="allowWarehouses" id="allowWarehouses" class="form-control block" multiple="multiple">

                                                        <?php
                                                        foreach ($warehousesArray as $id => $name){
                                                            if(in_array($id,$spAllowWarehouses)){
                                                                echo "<option value='$id' selected>$name</option>";
                                                            } else {
                                                                echo "<option value='$id'>$name</option>";
                                                            }

                                                        }
                                                        ?>

                                                    </select>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><span class="widget-icon"> <i class="fa fa-tasks"></i> </span></td>
                                                <td><h5 style="text-align: left">Allow CRM Types: </h5></td>
                                                <td>
                                                    <select style="" name="allowCrmTypes" id="allowCrmTypes" class="form-control block" multiple="multiple">

                                                        <?php
                                                        foreach ($crmTypesArray as $id => $name){
                                                            if(in_array($id,$spAllowedCrmTypes)){
                                                                echo "<option value='$id' selected>$name</option>";
                                                            } else {
                                                                echo "<option value='$id'>$name</option>";
                                                            }

                                                        }
                                                        ?>

                                                    </select>
                                                </td>
                                            </tr>
                                        </table>

                                    </div>

                                </div>
                            </div>

                        </article>


					
	                </div>



            </section>




	 

</div>



					
					
					



					
				
					<!-- end row -->
				


	
		</div>
		</div>
	
	
	<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/jquery.dataTables.min.js"></script>
    <script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
    <script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
    <script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
    <script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
    <script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/jquery.tabletojson.js"></script>
	<script type="text/javascript">

        function saveSalesperson(){

            $("#saveButton").attr("disabled", true);
            var salespersonID = $("#salespersonID").val();
            var salespersonCode = getSanitizedValue("salespersonCode");
            var firstName = getSanitizedValue("firstName");
            var lastName = getSanitizedValue("lastName");
            var landline = getSanitizedValue("landline");
            var mobile = getSanitizedValue("mobile");
            var email = getSanitizedValue("email");
            var username = getSanitizedValue("username");
            var password = getSanitizedValue("password");
            var appSettingsPassword = getSanitizedValue("appSettingsPassword");
            var defaultWarehouseID = getSanitizedValue("defaultWarehouse");
            var discardWarehouseID = getSanitizedValue("discardWarehouse");
            var discountAllowance = getSanitizedValue("discountAllowance");
            var allowTenders = getSanitizedValue("allowTenders");
            var allowInvoices = getSanitizedValue("allowInvoices");
            var allowOrders = getSanitizedValue("allowOrders");
            var allowWaybills = getSanitizedValue("allowWaybills");
            var allowReturns = getSanitizedValue("allowReturns");
            var allowReceipts = getSanitizedValue("allowReceipts");
            var allowVisits = getSanitizedValue("allowVisits");
            var allowLoad = getSanitizedValue("allowLoad");
            var allowUnload = getSanitizedValue("allowUnload");
            var viewHistory = getSanitizedValue("viewHistory");
            var allowAnonymousCustomer = getSanitizedValue("allowAnonymousCustomer");
            var allowNegativeStock = getSanitizedValue("allowNegativeStock");
            var onlyFromTruck = getSanitizedValue("onlyFromTruck");
            var orderStockInfo = getSanitizedValue("orderStockInfo");
            var discountAllowanceLine = getSanitizedValue("discountAllowanceLine");
            var anonymousGroupID = getSanitizedValue("anonymousGroup");
            var editSchedule = getSanitizedValue("editSchedule");
            var createSchedule = getSanitizedValue("createSchedule");
            var allowDiscountReceipt = getSanitizedValue("allowDiscountReceipt");
            var gpsTrack = getSanitizedValue("gpsTrack");
            var gpsTrackDistance = getSanitizedValue("gpsTrackDistance");
            var gpsTrackTime = getSanitizedValue("gpsTrackTime");
            var takePicture = getSanitizedValue("takePicture");
            var startEndKmSchedules = getSanitizedValue("startEndKmSchedules");
            var loadNegativeQty = getSanitizedValue("loadNegativeQty");
            var invoiceTypePrefer = getSanitizedValue("invoiceTypePrefer");
            var stockReservedCalculation = getSanitizedValue("stockReservedCalculation");
            var erpPopularProducts = getSanitizedValue("erpPopularProducts");
            var defaultQty = getSanitizedValue("defaultQty");
            var searchItemInCategory = getSanitizedValue("searchItemInCategory");
            var levelNavigation = getSanitizedValue("levelNavigation");
            var showLastPrice = getSanitizedValue("showLastPrice");
            var erpLastPrice = getSanitizedValue("erpLastPrice");
            var showPriceAfterDiscount = getSanitizedValue("showPriceAfterDiscount");
            var noActionBeforeSchedule = getSanitizedValue("noActionBeforeSchedule");
            var visitAllBeforeEndSchedule = getSanitizedValue("visitAllBeforeEndSchedule");
            var allowStatements = getSanitizedValue("allowStatements");
            var waybillShowPricesPdf = getSanitizedValue("waybillShowPricesPdf");
            var waybillToInvoiceIncludeItems = getSanitizedValue("waybillToInvoiceIncludeItems");
            var allowCustomerStockTaking = getSanitizedValue("allowCustomerStockTaking");
            var showCustomerStockTakingInfo = getSanitizedValue("showCustomerStockTakingInfo");
            var allowCrm = getSanitizedValue("allowCrm");
            var chequeMandatory = getSanitizedValue("chequeMandatory");
            var creditLimitWarning = getSanitizedValue("creditLimitWarning");
            var stockWarning = getSanitizedValue("stockWarning");
            var allowLoadRequest = getSanitizedValue("allowLoadRequest");
            var roundUpToBox = getSanitizedValue("roundUpToBox");
            var autoGenerateStatement = getSanitizedValue("autoGenerateStatement");
            var allowCreditNote = getSanitizedValue("allowCreditNote");
            var postDatedChequeLimit = getSanitizedValue("postDatedChequeLimit");
            var returnOnlyFromInvoice = getSanitizedValue("returnOnlyFromInvoice");
            var postDatedChequeCreditLimit = getSanitizedValue("postDatedChequeCreditLimit");
            var useBatchNumbers = getSanitizedValue("useBatchNumbers");
            var returnPolicy = getSanitizedValue("returnPolicy");
            var selectPromotionGroup = getSanitizedValue("selectPromotionGroup");
            var type = getSanitizedValue("type");
            var status = getSanitizedValue("status");
            var receivablesAccount = getSanitizedValue("receivablesAccount");

            var allowCategories = getSanitizedValue("allowCategories");
            var allowCustomerGroups = getSanitizedValue("allowCustomerGroups");
            var allowPrices = getSanitizedValue("allowPrices");
            var allowWarehouses = getSanitizedValue("allowWarehouses");
            var allowCrmTypes = getSanitizedValue("allowCrmTypes");



            var run=true;

            if(!salespersonCode){highlightDataError($('#salespersonCode'));run=false;}
            if(!firstName){highlightDataError($('#firstName'));run=false;}

            <?php
            $custForm->declareJsonVariables();
            $custTable->declareCustomTableJsonVariables();
            ?>

            if(run) {
                $.ajax({
                    <?php
                    if ($edit && !$copy) {
                        echo "url: '//" . HTML_PATH . "/cop/backend/core/controllers/edit/edit_user.php',";
                    } else {
                        echo "url: '//" . HTML_PATH . "/cop/backend/core/controllers/add/add_user.php',";
                    }
                    ?>
                    type: "POST",
                    data: {
                        salespersonID: salespersonID,
                        salespersonCode: salespersonCode,
                        firstName: firstName,
                        lastName: lastName,
                        landline: landline,
                        mobile: mobile,
                        email: email,
                        username: username,
                        password: password,
                        appSettingsPassword: appSettingsPassword,
                        defaultWarehouseID: defaultWarehouseID,
                        discardWarehouseID: discardWarehouseID,
                        discountAllowance: discountAllowance,
                        allowTenders: allowTenders,
                        allowInvoices: allowInvoices,
                        allowOrders: allowOrders,
                        allowWaybills: allowWaybills,
                        allowReturns: allowReturns,
                        allowReceipts: allowReceipts,
                        allowVisits: allowVisits,
                        allowLoad: allowLoad,
                        allowUnload: allowUnload,
                        viewHistory: viewHistory,
                        allowAnonymousCustomer: allowAnonymousCustomer,
                        allowNegativeStock: allowNegativeStock,
                        onlyFromTruck: onlyFromTruck,
                        orderStockInfo: orderStockInfo,
                        discountAllowanceLine: discountAllowanceLine,
                        anonymousGroupID: anonymousGroupID,
                        editSchedule: editSchedule,
                        createSchedule: createSchedule,
                        allowDiscountReceipt: allowDiscountReceipt,
                        gpsTrack: gpsTrack,
                        gpsTrackDistance: gpsTrackDistance,
                        gpsTrackTime: gpsTrackTime,
                        takePicture: takePicture,
                        startEndKmSchedules: startEndKmSchedules,
                        loadNegativeQty: loadNegativeQty,
                        invoiceTypePrefer: invoiceTypePrefer,
                        stockReservedCalculation: stockReservedCalculation,
                        erpPopularProducts: erpPopularProducts,
                        defaultQty: defaultQty,
                        searchItemInCategory: searchItemInCategory,
                        levelNavigation: levelNavigation,
                        showLastPrice: showLastPrice,
                        erpLastPrice: erpLastPrice,
                        showPriceAfterDiscount: showPriceAfterDiscount,
                        noActionBeforeSchedule: noActionBeforeSchedule,
                        visitAllBeforeEndSchedule: visitAllBeforeEndSchedule,
                        allowStatements: allowStatements,
                        waybillShowPricesPdf: waybillShowPricesPdf,
                        waybillToInvoiceIncludeItems: waybillToInvoiceIncludeItems,
                        allowCustomerStockTaking: allowCustomerStockTaking,
                        showCustomerStockTakingInfo: showCustomerStockTakingInfo,
                        allowCrm: allowCrm,
                        chequeMandatory: chequeMandatory,
                        creditLimitWarning: creditLimitWarning,
                        stockWarning: stockWarning,
                        allowLoadRequest: allowLoadRequest,
                        roundUpToBox: roundUpToBox,
                        autoGenerateStatement: autoGenerateStatement,
                        allowCreditNote: allowCreditNote,
                        postDatedChequeLimit: postDatedChequeLimit,
                        returnOnlyFromInvoice: returnOnlyFromInvoice,
                        postDatedChequeCreditLimit: postDatedChequeCreditLimit,
                        useBatchNumbers: useBatchNumbers,
                        returnPolicy: returnPolicy,
                        selectPromotionGroup: selectPromotionGroup,
                        type: type,
                        status: status,
                        receivablesAccount: receivablesAccount,
                        allowCategories: allowCategories,
                        allowCustomerGroups: allowCustomerGroups,
                        allowPrices: allowPrices,
                        allowWarehouses: allowWarehouses,
                        allowCrmTypes: allowCrmTypes
                        <?php
                        $custForm->passJsonVariables();
                        $custTable->passCustomTableJsonVariables();
                        ?>
                    },
                    success: function (result) {
                        if (result.localeCompare('error') === 0) {
                            $.smallBox({
                                title: "Warning!",
                                content: "Something Went Wrong Please Try again.",
                                color: '#b22222',
                                timeout: 3000,
                                icon: "fa fa-user swing animated"
                            });
                            $("#saveButton").attr("disabled", false);
                        } else {
                            $.smallBox({
                                title: "Success!",
                                content: "User Saved!",
                                color: "#739E73",
                                timeout: 3000,
                                icon: "fa fa-user swing animated"
                            });
                            window.location.replace('//<?php echo HTML_PATH ?>/cop/backend/core/views/addedit/new_user.php?edit_salesperson_id=' + result);
                        }
                    }
                });
            } else {
                $("#saveButton").attr("disabled", false);
            }

        }

        function getSanitizedValue(input){
            var value = '';
            if($('#' + input).is(':checkbox')){
                if($('#' + input).is(':checked')){
                    value = $('#' + input).val();
                }else{
                    value = 'no';
                }
            } else {
                value = $('#' + input).val();
            }
            // console.log(input + ': ' + value)
            return value;
        }

        function highlightDataError(element){
            element.css('border-color','firebrick').css('background-color','#ffd0bd');
            window.setTimeout(function(){element.css('border-color','').css('background-color','');
            },2500);
        }

        function adjustHeight(selectElement,parentElement){
            // Get the number of selected options
            var selectedOptionsCount = $('#' + selectElement).val().length;

            var selectedOptionsCount = selectedOptionsCount / 5;

            if(selectedOptionsCount < 1){
                selectedOptionsCount = 1;
            }

            // Calculate the new height for the div
            var newDivHeight = selectedOptionsCount * 30 + 20; // You can adjust the height based on your requirements

            // Set the new height for the div and select element
            $('#' + parentElement).css('height', newDivHeight + 'px');
            $('#' + selectElement).css('height', newDivHeight + 'px');

        }

		$(document).ready(function() {
			
			pageSetUp();		


            $("#defaultWarehouse").select2({
              placeholder: "No Warehouse Selected",
              allowClear: true
            });

            $("#roundUpToBox").select2({
                placeholder: "No Round Up To Box Selected",
                allowClear: false
            });

            $("#useBatchNumbers").select2({
                placeholder: "No Round Up To Box Selected",
                allowClear: false
            });

            $("#discardWarehouse").select2({
              placeholder: "No Warehouse Selected",
              allowClear: true
            });

            $("#anonymousGroup").select2({
                placeholder: "No Group Selected",
                allowClear: true
            });

            $("#invoiceTypePrefer").select2({
              placeholder: "No Type Selected",
              allowClear: false
            });

            $("#viewHistory").select2({
              placeholder: "No Type Selected",
              allowClear: false
            });

            $("#status").select2({
              placeholder: "No Status Selected",
              allowClear: false
            });

            $("#allowCategories").select2({
              placeholder: "No Categories Selected",
              allowClear: true
            });

            $("#allowCustomerGroups").select2({
              placeholder: "No Groups Selected",
              allowClear: true
            });

            $("#allowPrices").select2({
              placeholder: "No Prices Selected",
              allowClear: true
            });

            $("#allowWarehouses").select2({
              placeholder: "No Warehouses Selected",
              allowClear: true
            });

            $("#allowCrmTypes").select2({
              placeholder: "No Types Selected",
              allowClear: true
            });

            $('input').on("change", function() {
                $(this).css('border','2px solid #169818').css('background-color','#f0ffe1');
            });
            $("input[type='checkbox']").on("change", function() {
                $(this).parent().css('border','2px solid #169818');
            });
            $('select').on("change", function() {
                $(this).parent().parent().css('border','2px solid #169818').css('background-color','#f0ffe1');
            });

            var viewOnly = <?php if($viewOnly){echo 'true';} else{ echo 'false';} ?>;

            if(viewOnly){
                $('input').attr('disabled',true).css('cursor','unset');
                $('select').attr('disabled',true).css('cursor','unset');
                $('textarea').attr('disabled',true).css('cursor','unset');
                $('.checkbox').css('cursor','unset');
            }

		});

		</script>



<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>