<?php
include_once("../../../../param.php");
$edit=false;
if(isset($_POST['companyBankID']))
{
    $companyBankID=$_POST['companyBankID'];
    $edit=true;
}
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$companies = array();
$stm = $db->prepare("SELECT company_id, company_code,company_name FROM Companies ORDER BY company_code");
$stm->execute();
$stm->bind_result($companyID, $companyCode,$companyName);
while ($stm->fetch()) {
    $company = new stdClass();
    $company->id = $companyID;
    $company->code = $companyCode;
    $company->name = $companyName;
    $companies[] = $company;
}
$stm->close();

$paymentTerms = array();
$stm = $db->prepare("SELECT payment_term_id, payment_term_code FROM Payment_Terms ORDER BY payment_term_code");
$stm->execute();
$stm->bind_result($paymentTermID, $paymentTermCode);
while ($stm->fetch()) {
    $paymentTerm = new stdClass();
    $paymentTerm->id = $paymentTermID;
    $paymentTerm->code = $paymentTermCode;
    $paymentTerms[] =$paymentTerm;
}
$stm->close();

$stm = $db->prepare("SELECT b.company_bank_id, b.company_id, b.type, b.bank_name, b.sort_code, b.account_number, b.iban, b.bic, b.payment_term_id, b.position, b.details, b.timestamp, c.company_code, p.payment_term_code 
                     FROM Company_Bank_Details b 
                     LEFT JOIN Companies c ON b.company_id = c.company_id 
                     LEFT JOIN Payment_Terms p ON b.payment_term_id = p.payment_term_id 
                     WHERE b.company_bank_id=?");

$stm->bind_param("i",$companyBankID);
$stm->execute();
$stm->bind_result($companyBankID, $companyID, $type, $bankName, $sortCode, $accountNumber, $iban, $bic, $paymentTermID, $position, $details, $timestamp, $companyCode, $paymentTermCode);
while ($stm->fetch()) {
}
$stm->close();


?>

<div id="main" role="main">
    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">
        <span class="ribbon-button-alignment">
            <span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
                <i class="fa fa-refresh"></i>
            </span>
        </span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / <?php if($edit){echo "Edit";}else{echo "New";}?> Bank Details</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">
        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-10">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-university"></i>
                    <?php if($edit){echo "Edit";}else{echo "New";}?> Bank Details
                </h3>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
                <span class="pull-right show-stat-buttons"> <span><a onclick="saveBankDetails();" class="btn btn-success btn-block"><i class="fa fa-check"></i>&nbsp; Save Bank Details</a> </span>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="">
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div class="jarviswidget jarviswidget-color-blueDark no-margin" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2> Bank Details Form</h2>
                        </header>

                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">
                                <form action="" id="checkout-form" class="smart-form">
                                    <fieldset>
                                        <div class="row">
                                            <section class="col col-6 no-margin" style="border-right:1px dotted #ADD8E6;padding-right:2px">
                                                <section>
                                                    <i class="fa-fw fa fa-university fa-lg"></i>
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle">Bank Information</h3>
                                                </section>
                                                <table id="basicDetailsTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0">

                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Company: </label></td>
                                                        <td class="custom-td-input">
                                                            <select class="text-center form-control" id="companyID" name="companyID" required>
                                                                <option value=""></option>
                                                                <?php foreach($companies as $company): ?>
                                                                    <option value="<?php echo $company->id; ?>" <?php if($edit && $companyID == $company->id) echo "selected"; ?>><?php echo $company->code ." - ".$company->name ?></option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Type: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control' id='type' name='type' type='text' value="<?php if($edit){echo "$type";} ?>"></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Bank Name: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control' id='bankName' name='bankName' type='text' value="<?php if($edit){echo "$bankName";} ?>"></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Sort Code: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control' id='sortCode' name='sortCode' type='text' value="<?php if($edit){echo "$sortCode";} ?>"></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Account Number: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control' id='accountNumber' name='accountNumber' type='text' value="<?php if($edit){echo "$accountNumber";} ?>"></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">IBAN: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control' id='iban' name='iban' type='text' value="<?php if($edit){echo "$iban";} ?>"></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">BIC: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control' id='bic' name='bic' type='text' value="<?php if($edit){echo "$bic";} ?>"></td>
                                                    </tr>

                                                </table>
                                            </section>
                                            <section class="col col-6 no-margin" style="padding-right:2px;">
                                                <section>
                                                    <i class="fa-fw fa fa-info fa-lg"></i>
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle">Additional Details</h3>
                                                </section>
                                                <section>
                                                    <table id="detailsTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0">

                                                        <tr>
                                                            <td class="custom-td-label"><label class="label-bold align-left">Payment Terms: </label></td>
                                                            <td class="custom-td-input">
                                                                <select class="text-center form-control" id="paymentTermID" name="paymentTermID" required>
                                                                    <option value=""></option>
                                                                    <?php foreach($paymentTerms as $paymentTerm): ?>
                                                                        <option value="<?php echo $paymentTerm->id; ?>" <?php if($edit && $paymentTermID == $paymentTerm->id) echo "selected"; ?>><?php echo $paymentTerm->code ?></option>
                                                                    <?php endforeach; ?>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="custom-td-label"><label class="label-bold align-left">Position: </label></td>
                                                            <td class="custom-td-input"><input class='text-center form-control' id='position' name='position' type='number' value="<?php if($edit){echo "$position";} ?>"></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="custom-td-label"><label class="label-bold align-left">Details: </label></td>
                                                            <td class="custom-td-input"><textarea class='text-center form-control' id='details' name='details' rows="3"><?php if($edit){echo "$details";} ?></textarea></td>
                                                        </tr>
                                                    </table>
                                                </section>
                                            </section>
                                    </fieldset>
                                </form>
                            </div>
                            <!-- end widget content -->
                        </div>
                        <!-- end widget div -->
                    </div>
                    <!-- end widget -->
                </article>
            </div>
        </section>
    </div>
</div>

<script type="text/javascript">
    function highlightDataError(element, error) {
        element.css('border-color', 'firebrick').css('background-color', '#ffd0bd');
        window.setTimeout(function() {
            element .css('border-color', '').css('background-color', '');
            element.next('.error-message').fadeOut(500);
        }, 2500);
    }


    function saveBankDetails(){
        var companyBankID = "<?php echo $companyBankID;?>";
        var companyID = $('#companyID').val();
        var type = $('#type').val();
        var bankName = $('#bankName').val();
        var sortCode = $('#sortCode').val();
        var accountNumber = $('#accountNumber').val();
        var iban = $('#iban').val();
        var bic = $('#bic').val();
        var paymentTermID = $('#paymentTermID').val();
        var position = $('#position').val();
        var details = $('#details').val();

        if(companyID ==='' || companyID==0){
            $.smallBox({
                title: "Warning!",
                content: "The Company cannot be empty.",
                color: '#b22222',
                timeout: 3000,
                icon: "fa fa-exclamation-triangle swing animated"
            });
            highlightDataError($('#companyID'));

            return;
        }



        $.ajax({
            type: "POST",
            <?php
            if($edit){
                echo " url: '//" . HTML_PATH . "/cop/backend/core/controllers/edit/edit_company_bank_details.php',";
            } else {
                echo " url: '//" . HTML_PATH . "/cop/backend/core/controllers/add/add_company_bank_details.php',";
            }
            ?>
            data: {
                'companyBankID': companyBankID,
                'companyID': companyID,
                'type': type,
                'bankName': bankName,
                'sortCode': sortCode,
                'accountNumber': accountNumber,
                'iban': iban,
                'bic': bic,
                'paymentTermID': paymentTermID,
                'position': position,
                'details': details
            },
            success: function (result) {
                $.smallBox({
                    title : "Success!",
                    content : "Bank details successfully saved",
                    color : "#739E73",
                    timeout: 3000,
                    icon : "fa fa-check swing animated"
                });
                window.location.replace("//<?php echo HTML_PATH ?>/cop/backend/core/views/manage/manage_company_bank_details.php");
            }
        });
    }

    $(document).ready(function() {
        pageSetUp();
    });
</script>