<?php
include_once("../../../../param.php");
$edit=false;
if(isset($_POST['barcodeSchemaID']))
{
    $barcodeSchemaID=$_POST['barcodeSchemaID'];
    $edit=true;
}

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT barcode_schema_id, barcode_schema_code, barcode_schema_text, prefix, code_start, code_end, qty_start, qty_end, price_start, price_end, qty_factor, price_factor, timestamp 
                     FROM Barcode_Schema 
                     WHERE barcode_schema_id=?");
$stm->bind_param("i",$barcodeSchemaID);
$stm->execute();
$stm->bind_result($barcodeSchemaID, $barcodeSchemaCode, $barcodeSchemaText, $prefix, $codeStart, $codeEnd, $qtyStart, $qtyEnd, $priceStart, $priceEnd, $qtyFactor, $priceFactor, $timestamp);
while ($stm->fetch()) {
}
$stm->close();
?>
<div id="main" role="main">
    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">
        <span class="ribbon-button-alignment">
            <span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
                <i class="fa fa-refresh"></i>
            </span>
        </span>
        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / <?php if($edit){echo "Edit";}else{echo "New";}?> Barcode Schema</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">
        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-8">
                <h3 class="page-title txt-color-blueDark" style="margin-top: 5px; margin-bottom: 15px;">
                    <i class="fa fa-wrench "> </i> <?php if($edit){echo "Edit";}else{echo "New";}?> Barcode Schema
                </h3>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
                <span class="pull-right show-stat-buttons"><span id="saveButton"><a onclick="saveBarcodeSchema();" class="btn btn-success btn-block"><i class="fa fa-check"></i>&nbsp; Save Barcode Schema</a></span></span>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="">
            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Barcode Schema Form</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">
                                <form action="" class="smart-form">
                                    <fieldset>
                                        <div class="row">
                                            <section class="col col-4 no-margin" style="border-right:1px dotted #ADD8E6;padding-right:2px">
                                                <section>
                                                    <i class="fa-fw fa fa-info fa-lg"></i>
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle">Basic Details</h3>
                                                </section>
                                                <table id="codeTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0">
                                                    <thead>
                                                    </thead>
                                                    <tbody>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Barcode Schema Code: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control' id='barcodeSchemaCode' name='barcodeSchemaCode' type='text' value="<?php if($edit){echo "$barcodeSchemaCode";} ?>"></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Barcode Schema Text: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control' id='barcodeSchemaText' name='barcodeSchemaText' type='text' value="<?php if($edit){echo "$barcodeSchemaText";} ?>"></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Prefix: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control' id='prefix' name='prefix' type='text' value="<?php if($edit){echo "$prefix";} ?>"></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Code Start: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control' id='codeStart' name='codeStart' type='number' value="<?php if($edit){echo "$codeStart";} ?>"></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Code End: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control' id='codeEnd' name='codeEnd' type='number' value="<?php if($edit){echo "$codeEnd";} ?>"></td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                            </section>
                                            <section class="col col-4 no-margin" style="border-right:1px dotted #ADD8E6;padding-right:2px">
                                                <section>
                                                    <i class="fa-fw fa fa-money fa-lg"></i>
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle">Price Details</h3>
                                                </section>
                                                <table id="priceTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0">
                                                    <thead>
                                                    </thead>
                                                    <tbody>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Price Start: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control' id='priceStart' name='priceStart' type='number' step="0.01" value="<?php if($edit){echo "$priceStart";} ?>"></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Price End: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control' id='priceEnd' name='priceEnd' type='number' step="0.01" value="<?php if($edit){echo "$priceEnd";} ?>"></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Price Factor: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control' id='priceFactor' name='priceFactor' type='number' step="0.01" value="<?php if($edit){echo "$priceFactor";} ?>"></td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                            </section>
                                            <section class="col col-4 no-margin">
                                                <section>
                                                    <i class="fa-fw fa fa-wrench fa-lg"></i>
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle">Quantity Details</h3>
                                                </section>
                                                <table id="qtyTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0">
                                                    <thead>
                                                    </thead>
                                                    <tbody>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Quantity Start: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control' id='qtyStart' name='qtyStart' type='number' value="<?php if($edit){echo "$qtyStart";} ?>"></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Quantity End: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control' id='qtyEnd' name='qtyEnd' type='number' value="<?php if($edit){echo "$qtyEnd";} ?>"></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Quantity Factor: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control' id='qtyFactor' name='qtyFactor' type='number' step="0.01" value="<?php if($edit){echo "$qtyFactor";} ?>"></td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                            </section>
                                        </div>
                                    </fieldset>
                                </form>
                            </div>
                            <!-- end widget content -->
                        </div>
                        <!-- end widget div -->
                    </div>
                    <!-- end widget -->
                </article>
                <!-- WIDGET END -->
            </div>
            <!-- end row -->
        </section>
    </div>
</div>

<script type="text/javascript">
    function highlightDataError(element, error) {
        element.css('border-color', 'firebrick').css('background-color', '#ffd0bd');
        window.setTimeout(function() {
            element .css('border-color', '').css('background-color', '');
            element.next('.error-message').fadeOut(500);
        }, 2500);
    }

    function saveBarcodeSchema(){
        var barcodeSchemaID = "<?php echo $barcodeSchemaID;?>";
        var barcodeSchemaCode = $('#barcodeSchemaCode').val().trim();
        var barcodeSchemaText = $('#barcodeSchemaText').val().trim();
        var prefix = $('#prefix').val();
        var codeStart = $('#codeStart').val();
        var codeEnd = $('#codeEnd').val();
        var qtyStart = $('#qtyStart').val();
        var qtyEnd = $('#qtyEnd').val();
        var priceStart = $('#priceStart').val();
        var priceEnd = $('#priceEnd').val();
        var qtyFactor = $('#qtyFactor').val();
        var priceFactor = $('#priceFactor').val();

        if(barcodeSchemaCode===''){
            $.smallBox({
                title: "Warning!",
                content: "The Code cannot be empty.",
                color: '#b22222',
                timeout: 3000,
                icon: "fa fa-warning swing animated"
            });
            highlightDataError($('#barcodeSchemaCode'));

            return;
        }

        $('#saveButton').hide();

        $.ajax({
            type: "POST",
            <?php
            if($edit){
                echo " url: '//" . HTML_PATH . "/cop/backend/core/controllers/edit/edit_barcode_schema.php',";
            } else {
                echo " url: '//" . HTML_PATH . "/cop/backend/core/controllers/add/add_barcode_schema.php',";
            }
            ?>
            data: {
                'barcodeSchemaID': barcodeSchemaID,
                'barcodeSchemaCode': barcodeSchemaCode,
                'barcodeSchemaText': barcodeSchemaText,
                'prefix': prefix,
                'codeStart': codeStart,
                'codeEnd': codeEnd,
                'qtyStart': qtyStart,
                'qtyEnd': qtyEnd,
                'priceStart': priceStart,
                'priceEnd': priceEnd,
                'qtyFactor': qtyFactor,
                'priceFactor': priceFactor
            },
            success: function (result) {
                if(result.localeCompare('existingCode') == 0){
                    $.smallBox({
                        title: "Warning!",
                        content: "Barcode Schema Code already exists.",
                        color: '#b22222',
                        timeout: 3000,
                        icon: "fa fa-warning swing animated"
                    });

                    highlightDataError($('#barcodeSchemaCode'));

                    $('#saveButton').show();

                } else if (result === "success") {
                    $.smallBox({
                        title : "Success!",
                        content : "Barcode schema successfully saved",
                        color : "#739E73",
                        timeout: 3000,
                        icon : "fa fa-check swing animated"
                    });
                    window.location.replace("//<?php echo HTML_PATH ?>/cop/backend/core/views/manage/manage_barcode_schemas.php");
                } else {
                    $.smallBox({
                        title : "Error!",
                        content : "Failed to save Barcode schema",
                        color : "#C46A69",
                        timeout: 3000,
                        icon : "fa fa-times swing animated"
                    });
                    $('#saveButton').show();
                }
            }
        });
    }

    $(document).ready(function() {
        pageSetUp();
    });
</script> 