<?php
include_once("../../../../param.php");
require_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");
require_once(ROOT . "concc/dbhelpers/classes/DBItem.php");

$dbHelbelItem= new DBItem();
$edit=false;
$showDiscountPrices = false;
$priceTypeID = 0;

if(isset($_POST['pricetype_id']) && strcmp(trim($_POST['pricetype_id']),"")!=0 && intval($_POST['pricetype_id'])>0) {
    $edit=true;
    $priceTypeID = $_POST['pricetype_id'];
}

if(isset($_GET['pricetype_id']) && strcmp(trim($_GET['pricetype_id']),"")!=0 && intval($_GET['pricetype_id'])>0) {
    $edit=true;
    $priceTypeID = $_GET['pricetype_id'];
}

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
	printf("Connect failed: %s\n", mysqli_connect_error());
	exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT enable_discount_on_prices FROM Cloud_Configuration LIMIT 1");
$stm->execute();
$stm->bind_result($enable_discount_on_prices);
while ($stm->fetch()) {
    if(strcmp("$enable_discount_on_prices","yes")==0){
        $showDiscountPrices = true;
    }
}
$stm->close();


if($edit) {

    $stm = $db->prepare("SELECT price_code,name,allow_discount,default_type FROM PriceTypes WHERE pricetype_id = ?");
    $stm->bind_param('i', $priceTypeID);
    $stm->execute();
    $stm->bind_result($priceCode, $name, $allowDiscount, $defaultType);
    while ($stm->fetch()) {}
    $stm->close();

}




$custForm = new CustomForm('PriceTypes',$priceTypeID);
$custTable = new CustomTable('PriceTypes',$priceTypeID);

?>
<div id="main" role="main" class="background-color-whitish">
    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Price Lists / <?php if($edit){echo "$priceCode - $name";}?></li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->
    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-8 col-lg-10">
                <h3 class="page-title txt-color-blueDark" style="margin-top: 3px;margin-bottom: 5px;">
                    <span class="custom-rounded-image-padding waybill" style="padding: 3px 6px;"><i class="fa fa-money" style="color: white;font-size: 16px;"></i></span>
                    <?php if($edit){echo "$priceCode - $name";}?>
                </h3>
            </div>


            <div class="col-xs-12 col-sm-4 col-md-4 col-lg-2">
                <a href="//<?php echo HTML_PATH ?>/cop/backend/core/views/manage/manage_price_lists.php"><button type="button" class="btn btn-primary btn-block"><i class="fa fa-arrow-left"></i>&nbsp; PriceLists</button> </a>
            </div>

        </div>

        <!-- row -->
        <section id="widget-grid" class="">
            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1058" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Prices Table </h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">
                                <table class="table table-bordered" style="background-color: #b0d1de;padding: 5px;" id="addItemPriceTable">
                                    <tr>
                                        <td style="width: 1%;white-space: nowrap">
                                            <h3 style="margin: 0px;">New Price <i class="fa fa-arrow-right"></i></h3>
                                        </td>
                                        <td>
                                            <input style='display:inline;' class='text-center form-control' id='itemSearch' name='itemSearch' placeholder="Product" type='text' value="">
                                            <input type="hidden" id="itemSearchID" value="">
                                        </td>
                                        <td>
                                            <input type="number" class="form-control text-center" placeholder="Price" id="itemSearchPrice" />
                                        </td>
                                        <?php
                                        if($showDiscountPrices){
                                            echo'<td>
                                                    <input type="text" class="form-control text-center" placeholder="Discount %" id="itemSearchDiscount" />
                                                 </td>';
                                        }
                                        ?>
                                        <td>
                                            <button class="btn btn-primary btn-block" onclick="addPrice();">Add Price</button>
                                        </td>
                                    </tr>
                                </table>
                                <table id="datatable_fixed_column" class="table dataTable" width="100%">
                                    <thead>
                                    <tr>
                                        <th class="hasinput" >
                                        </th>
                                        <th class="hasinput" >
                                        </th>
                                        <th class="hasinput" >
                                            <input type="text" class="form-control text-center" placeholder="Filter Item Code" id="codeFilter" />
                                        </th>
                                        <th class="hasinput" >
                                            <input class="form-control text-center" placeholder="Filter Name" type="text"  id="nameFilter"/>
                                        </th>
                                        <th class="hasinput" >
                                            <input type="text" class="form-control text-center" placeholder="Filter Item Sku" id="skuFilter"/>
                                        </th>
                                        <th class="hasinput" >
                                            <input class="form-control text-center" placeholder="Filter VAT" type="text" id="vatFilter"/>
                                        </th>
                                        <th class="hasinput" >
                                            <input class="form-control text-center" placeholder="Filter Price" type="text" id="priceFilter"/>
                                        </th>
                                        <?php
                                        if($showDiscountPrices){
                                            echo'<th class="hasinput" >
                                                    <input class="form-control text-center" placeholder="Filter Discount" type="text" id="discountFilter"/>
                                                 </th>
                                                 <th class="hasinput" >
                                                    <input class="form-control text-center" placeholder="Filter Price" type="text" id="finalPriceFilter"/>
                                                 </th>';
                                        }
                                        ?>
                                        <th class="hasinput" >
                                            <input class="form-control text-center" placeholder="Filter Vat" type="text" id="incVatFilter"/>
                                        </th>

                                    </tr>
                                    <tr>
                                        <th class='text-center'></th>
                                        <th class='text-center'>Image</th>
                                        <th class='text-center'>Item Code</th>
                                        <th class='text-center'>Name</th>
                                        <th class='text-center'>Item Sku</th>
                                        <th class='text-center'>VAT</th>
                                        <th class='text-center'>Unit Price</th>
                                        <?php
                                        if($showDiscountPrices){
                                            echo'<th class="text-center">Discount %</th>
                                                 <th class="text-center">Final Price</th>';
                                        }
                                        ?>
                                        <th class='text-center' style="width: 1%;white-space: nowrap;">Included Vat</th>

                                    </tr>
                                    </thead>

                                </table>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->

                </article>
                <!-- WIDGET END -->

            </div>

            <!-- end row -->

        </section>
    </div>


</div>

<!-- Modal -->
<div class="modal fade" id="imageModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document" >
        <div class="modal-content">
            <div class="modal-body">

                <img class="img-responsive img-rounded center-canvas" src="" id='modalImage'>


            </div>

        </div>
    </div>
</div>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>

<script type="text/javascript">

    function addPrice(){
        var itemID = $('#itemSearchID').val();
        var price = $('#itemSearchPrice').val();
        var allowDiscount = $('#itemSearchDiscount').val();
        var priceTypeID = <?php echo intval($priceTypeID); ?>;
        $.ajax({
            type: "POST",
            url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/change/changePriceListPrice.php",
            data: {itemID: itemID, priceTypeID: priceTypeID, price: price, allowDiscount: allowDiscount},
            success: function (data) {
                if(data.localeCompare('error')==0){
                    $('#itemSearch').css('background-color','#a95454');
                    setTimeout(function(){
                        $('#itemSearch').css('background-color','#b0d1de');
                    }, 1000);
                } else {
                    $('#addItemPriceTable').css('background-color','#7df58e');
                    setTimeout(function(){
                        $('#addItemPriceTable').css('background-color','#b0d1de');
                        $('#datatable_fixed_column').DataTable().ajax.reload(null,false);
                    }, 1000);
                    $('#itemSearch').val('');
                    $('#itemSearchID').val('');
                    $('#itemSearchPrice').val('');
                    $('#itemSearchDiscount').val('');
                    $('#nameFilter').val('').trigger('change');
                    $('#codeFilter').val('').trigger('change');
                    $('#datatable_fixed_column').DataTable().ajax.reload(null,false);
                }
            }
        });
    }

    function initAutocomplete()
    {
        $("#itemSearch").on('keyup change', function(){
            if($(this).val().length==0){
                $('#itemSearchID').val('');
                $('#nameFilter').val('').trigger('change');
                $('#codeFilter').val('').trigger('change');
            }
        });
        $("#itemSearch").autocomplete({
            source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/item_autocomplete.php",
            autoFocus: true,
            open: function(){
                $('#codeFilter').val('').trigger('change');
                $('#nameFilter').val('').trigger('change');
                $('.ui-autocomplete').css('width', '400px');
            },
            select: function (event, ui) {

                $('#itemSearchID').val(ui.item.item_id);
                $('#nameFilter').val(ui.item.name).trigger('change');
                $('#codeFilter').val(ui.item.item_code).trigger('change');


            }
        });
    }

    function showImage(url){
        $('#modalImage').attr("src",url);
    }


    function deleteRow(element)
    {
        var row = $(element).closest('tr');
        var itemID = $(element).data('item');
        var priceTypeID = <?php echo intval($priceTypeID); ?>;
        var r = confirm("Are you sure you want to delete selected Price?");
        if (r == true) {
            $.ajax({
                type: "POST",
                url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/delete/deletePriceListPrice.php",
                data: {itemID: itemID, priceTypeID: priceTypeID},
                success: function (data) {
                    if(data.localeCompare('error')==0){
                        row.css('background-color','#a95454');
                        setTimeout(function(){
                            row.css('background-color','');
                        }, 1000);
                    } else {
                        $('#datatable_fixed_column').DataTable().ajax.reload(null,false);
                    }
                }
            });
        }
    }

    function changePrice(element,itemID){
        var row = $(element).closest('tr');
        var allowDiscount = row.find('#allowDiscount').val();
        var price = row.find('#price').val();
        var incVat = row.find('#incVat').val();
        var priceTypeID = <?php echo intval($priceTypeID); ?>;



        $.ajax({
            type: "POST",
            url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/change/changePriceListPrice.php",
            data: {itemID: itemID, priceTypeID: priceTypeID, price: price, allowDiscount: allowDiscount,incVat: incVat},
            success: function (data) {
                if(data.localeCompare('error')==0){
                    row.css('background-color','#a95454');
                    setTimeout(function(){
                        row.css('background-color','');
                    }, 1000);
                } else {
                    row.css('background-color','#7df58e');
                    setTimeout(function(){
                        row.css('background-color','');
                        $('#datatable_fixed_column').DataTable().ajax.reload(null,false);
                    }, 1000);


                }
            }
        });



    }


    $(document).ready(function() {

        pageSetUp();
        initAutocomplete();

        var responsiveHelper_datatable_fixed_column = undefined;


        var breakpointDefinition = {
            tablet : 1024,
            phone : 480
        };

        /* COLUMN FILTER  */
        var otable = $('#datatable_fixed_column').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>"+
                "t"+
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "processing": false,
            "serverSide": true,
            "ajax": "//<?php echo HTML_PATH . "/cop/backend/core/controllers/get/getPriceListPrices.php?priceTypeID=".intval("$priceTypeID");?>",
            "columns": [
                { "data": "delete" },
                { "data": "image" },
                { "data": "code" },
                { "data": "name" },
                { "data": "sku" },
                { "data": "vat" },
                { "data": "price" },
                <?php
                if($showDiscountPrices){
                   echo '{ "data": "allow_discount" },
                         { "data": "final_price" },';
                }
                ?>
                { "data": "inc_vat" },



            ],
            "order": [[ 2, "asc" ],[ 1, "asc" ]],
            "page": 'last',
            "deferRender": true,
            "autoWidth" : true,
            "buttons": ["copyHtml5",
                "excelHtml5",
                "csvHtml5",
                {
                    extend: 'pdfHtml5',
                    orientation: 'landscape',
                    pageSize: 'LEGAL'
                }
            ],
            "preDrawCallback" : function() {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
            "rowCallback" : function(nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback" : function(oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }
        });

        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on( 'keyup change', function () {
            otable
                .column( $(this).parent().index()+':visible' )
                .search( this.value )
                .draw();
        } );
        /* END COLUMN FILTER */


    })

</script>