<?php

error_reporting(100);
include_once("../../../../param.php");
require_once(ROOT . 'libs/phpexcel/vendor/autoload.php');

$orderID = '10002';
$orderCode = 'OH100006';

$db = new mysqli('localhost', $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");



$stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies LIMIT 1");
$stm->execute();
$stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
while ($stm->fetch()) {}
$stm->close();


$objPHPExcel = new PHPExcel();


//$objPHPExcel->getActiveSheet()->mergeCells('D1:F1');
$objPHPExcel->getActiveSheet()->mergeCells('C1:D1');
$objPHPExcel->getActiveSheet()->mergeCells('D2:E2');
$objPHPExcel->getActiveSheet()->mergeCells('D3:E3');
$objPHPExcel->getActiveSheet()->mergeCells('D4:E4');
$objPHPExcel->getActiveSheet()->mergeCells('D5:E5');
$objPHPExcel->getActiveSheet()->mergeCells('D6:E6');
$objPHPExcel->getActiveSheet()->mergeCells('D7:E7');

$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
$objPHPExcel->getActiveSheet()->mergeCells('D11:F11');



$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('C1', 'ΠΡΟΙΟΝΤΑ - PRODUCTS')
    //-- COMPANY DETAILS --//
    ->setCellValue('E1', $line1)
    ->setCellValue('D2', $line2)
    ->setCellValue('D3', $line3)
    ->setCellValue('D4', $line4)
    ->setCellValue('D5', $line5)
    ->setCellValue('D6', $line6)
    ->setCellValue('D7', $line7)
;



$objDrawing = new PHPExcel_Worksheet_Drawing();
IF(file_exists(ROOT . 'media/pdfimage/logo.png')) {
    $objDrawing->setName('logo');
    $objDrawing->setDescription('logo');
    $objDrawing->setPath(ROOT . 'media/pdfimage/logo.png');
    $objDrawing->setCoordinates('A1');
    $objDrawing->setWidthAndHeight(300, 300);
    $objDrawing->setOffsetY(100);
    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());
}

$row = $objPHPExcel->getActiveSheet()->getHighestRow()+1;
$row2 = $objPHPExcel->getActiveSheet()->getHighestRow()+2;


$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A'.$row, "No.")
    ->setCellValue('A'.$row2,"Αρ.")
    ->setCellValue('B'.$row, "ΕΙΚΟΝΑ")
    ->setCellValue('B'.$row2,"IMAGE")
    ->setCellValue('C'.$row, "ΚΩΔΙΚΟΣ")
    ->setCellValue('C'.$row2, "CODE")
    ->setCellValue('D'.$row, "ΠΕΡΙΓΡΑΦΗ")
    ->setCellValue('D'.$row2, "DESCRIPTION")
    ->setCellValue('E'.$row, "ΓΡΑΜΜΟΚΩΔΙΚΑΣ")
    ->setCellValue('E'.$row2,"BARCODE")

;


$vatsArray = Array();
$stm = $db->prepare("SELECT vat_id,vat_code,percentage FROM Vats");
$stm->execute();
$stm->bind_result($vatID,$vatCode,$percentage);
while ($stm->fetch()) {
    $vatObject="";
    $vatObject->id=$vatID;
    $vatObject->code=$vatCode;
    $vatObject->percentage=$percentage;
    $vatObject->vatAmount=0;
    $vatObject->goods=0;
    array_push($vatsArray,$vatObject);
}
$stm->close();


$counter = 0;
$stm = $db->prepare("SELECT Items.item_id,sales_units,thumbnail_url,subunits,Items.vat_id,Items.item_code,Items.name,price FROM Items, Prices, PriceTypes WHERE Prices.item_id=Items.item_id AND Prices.pricetype_id=PriceTypes.pricetype_id AND default_type = 'yes' AND NOT status = 'inactive'");
$stm->execute();
$stm->bind_result($itemID, $uom,$image,$subunits, $vatID, $itemCode,$name, $unitPrice);


$items = array();
while ($stm->fetch()){

    $db2 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $stm2 = $db2->prepare("SELECT barcode FROM Item_Barcode WHERE item_id='$itemID'");
    $stm2->execute();
    $stm2->bind_result($barcode);
    while ($stm2->fetch()){}
    $stm2->close();

    $counter++;


    $item = "";
    $item->counter   = $counter;
    $item->code      = $itemCode;
    $item->name      = $name;
    $item->uom       = $uom;
    $item->qty       = $qty;
    $item->barcode   = $barcode;
    $item->unitPrice = $unitPrice;
    $item->vatCode   = $vatCode;
    $item->image     = $image;

    array_push($items, $item);

}
$stm->close();


foreach ($items as $item){

    if(strcmp($item->image,'')!=0) {
        $imageURL = ROOT.'media/productImages/' . $item->image . '.jpg';
        if(!file_exists($imageURL)){
            $imageURL = ROOT."backend/themes/" . THEME_NAME . "/img/itemdefaulticon.jpg";
        }
    } else {
        $imageURL = ROOT."backend/themes/" . THEME_NAME . "/img/itemdefaulticon.jpg";
    }

    $styleRow = $objPHPExcel->getActiveSheet()->getHighestRow()+1;
    $row = $objPHPExcel->getActiveSheet()->getHighestRow()+1;
    $objPHPExcel->setActiveSheetIndex(0)
        ->setCellValue('A'.$row, $item->counter)
        ->setCellValue('C'.$row, $item->code)
        ->setCellValue('D'.$row, $item->name)
        ->setCellValue('E'.$row, $item->barcode)
    ;

    $objDrawing = new PHPExcel_Worksheet_Drawing();
    $objDrawing->setName('item');
    $objDrawing->setDescription('item');
    $objDrawing->setPath($imageURL);
    $objDrawing->setCoordinates('B'.$row);
    $objDrawing->setWidthAndHeight(100, 100); // Previous 50 , 50
    $objDrawing->setOffsetX(32); // Previous 62
    $objDrawing->setOffsetY(10);
    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());
    $objPHPExcel->getActiveSheet()->getRowDimension($row)->setRowHeight(100); // Previous 50

    $objPHPExcel->getActiveSheet()->getStyle('E'.$row)->getNumberFormat()->setFormatCode('0');



    $objPHPExcel->getActiveSheet()->getStyle('E'.$row)->applyFromArray(
        array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
            )
        )
    );

    $objPHPExcel->getActiveSheet()->getStyle('J'.$row)->applyFromArray(
        array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
            )
        )
    );
}



$remarksRow = $objPHPExcel->getActiveSheet()->getHighestRow()+1;




$objPHPExcel->getActiveSheet()->getStyle('A13:J'.$row)->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    )
);


$objPHPExcel->getActiveSheet()->getStyle('B1:D1')->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
        )
    )
);


$objPHPExcel->getActiveSheet()->getStyle('E1:G11')->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
            'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    )
);


$objPHPExcel->getActiveSheet()->getStyle('A1:E11')->applyFromArray(
    array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => 'FFFFFF')
            )
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle('A12:E13')->applyFromArray(
    array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => '000000')
            )
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'color' => array('rgb' => '000000')
        ),
        'font'  => array(
            'bold'  => true,
            'color' => array('rgb' => 'FFFFFF'),
            'size'  => 10
        )
    )
);


$objPHPExcel->getActiveSheet()->getStyle('D2:E13')->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle('D2:D8')->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle("A1:J".$row)->getFont()->setBold( true );
foreach(range('C','E') as $columnID) {
    $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)
        ->setAutoSize(true);
}

$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(24);


// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="ProductList.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');


?>