<?php

error_reporting(100);
include_once("../../../../param.php");
require(ROOT . 'libs/phpexcel/vendor/autoload.php');

$from = trim($_POST['dateFrom']);
$to   = trim($_POST['dateTo']);
$cost = trim($_POST['priceType']);
$salesPerson = trim($_POST['salesPerson']);

if(isset($salesPerson) && strcmp($salesPerson,'')!=0){
    $Allow_Salespersons = " AND salesperson_id IN (".$salesPerson.")";
}

if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0) {
    $Allow_Customers_invoices = "AND Invoices.customer_id IN(".$_SESSION['Allow_Customers'].")";
    $Allow_Customers_returns = "AND Returns.customer_id IN(".$_SESSION['Allow_Customers'].")";
}

if(isset($_SESSION['Allow_Items']) && strcmp($_SESSION['Allow_Items'],'')!=0) {
    $Allow_Items = "AND Items.item_id IN(".$_SESSION['Allow_Items'].")";
}

if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    $Allow_Salespersons = " AND salesperson_id IN (".$_SESSION['Allow_Salespersons'].")";
}

$db = new mysqli('localhost', $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT invoice_id FROM Invoices WHERE invoice_date BETWEEN '$from' AND '$to' $Allow_Customers_invoices $Allow_Salespersons");
$stm->execute();
$stm->bind_result($invoiceID);
$countInvoices=0;
while ($stm->fetch()) {
    $countInvoices++;
    $db2 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $stm2 = $db2->prepare("SELECT Items.item_id, Items.subunits, Invoice_Item.qty, Invoice_Item.unit_price, Invoice_Item.line_discount, Invoice_Item.global_discount FROM Invoice_Item, Items WHERE Invoice_Item.item_id = Items.item_id AND Invoice_Item.invoice_id = $invoiceID  $Allow_Items");
    $stm2->execute();
    $stm2->bind_result($itemID, $subunits, $qty, $unitPrice, $lineDiscount, $globalDiscount);
    while ($stm2->fetch()) {

        $db3 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $stm3 = $db3->prepare("SELECT price FROM Prices WHERE item_id = '$itemID' AND pricetype_id = $cost ");
        $stm3->execute();
        $stm3->bind_result($itemCost);
        while ($stm3->fetch()) {}
        $stm3->close();

        $itemsPrice    = ($unitPrice/$subunits)*$qty;
        $itemsCost     = ($itemCost/$subunits)*$qty;
        $totalDiscount = $lineDiscount+$globalDiscount;

        $invoiceTotal  += $itemsPrice - $totalDiscount;
        $discountTotal += $totalDiscount;
        $costTotal     += $itemsCost;
        $invoiceSUM    += $itemsPrice - $itemsCost - $totalDiscount;
    }
    $stm2->close();

}
$stm->close();

$stm = $db->prepare("SELECT return_id FROM Returns WHERE return_date BETWEEN '$from' AND '$to' $Allow_Customers_returns $Allow_Salespersons");
$stm->execute();
$stm->bind_result($returnID);
$countReturns=0;
while ($stm->fetch()) {
    $countReturns++;
    $db2 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $stm2 = $db2->prepare("SELECT Items.item_id, Items.subunits, Return_Item.qty, Return_Item.unit_price, Return_Item.line_discount, Return_Item.global_discount FROM Return_Item, Items WHERE Return_Item.item_id = Items.item_id AND Return_Item.return_id = $returnID  $Allow_Items");
    $stm2->execute();
    $stm2->bind_result($itemID,$subunits, $qty, $unitPrice, $lineDiscount, $globalDiscount);
    while ($stm2->fetch()) {

        $db3 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $stm3 = $db3->prepare("SELECT price FROM Prices WHERE item_id = '$itemID' AND pricetype_id = $cost ");
        $stm3->execute();
        $stm3->bind_result($itemCost);
        while ($stm3->fetch()) {}
        $stm3->close();


        $itemsPrice    = ($unitPrice/$subunits)*$qty;
        $itemsCost     = ($itemCost/$subunits)*$qty;
        $totalDiscount = $lineDiscount+$globalDiscount;

        $returnTotal         += $itemsPrice - $totalDiscount;
        $discountReturnTotal += $totalDiscount;
        $returnCostTotal     += $itemsCost;
        $returnSUM           += $itemsPrice - $itemsCost - $totalDiscount;
    }
    $stm2->close();



}
$stm->close();

$invoiceSUM    = number_format(floatVal($invoiceSUM),2);
$discountTotal = number_format(floatVal($discountTotal),2);
$costTotal     = number_format(floatVal($costTotal),2);
$invoiceTotal  = number_format(floatVal($invoiceTotal),2);

$returnSUM    = number_format(floatVal($returnSUM),2);
$returnTotal  = number_format(floatVal($returnTotal),2);

$profitability      = number_format(floatVal($invoiceSUM - $returnSUM),2);
if(floatval($invoiceSUM)==0){
    $profitabilityIndex = 0;
} else {
    $profitabilityIndex = number_format(floatVal((($invoiceSUM - $returnSUM) / $invoiceSUM) * 100), 2, '.', '');;
}

if(strcmp("$from","")!=0){
    $fromDate = date_format( date_create_from_format('Y-m-d', $from), 'd-m-Y');
} else {
    $fromDate = '';
}

if(strcmp("$to","")!=0){
    $toDate = date_format( date_create_from_format('Y-m-d', $to  ), 'd-m-Y');
} else {
    $toDate = '';
}



$stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies LIMIT 1");
$stm->execute();
$stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
while ($stm->fetch()) {}
$stm->close();

$objPHPExcel = new PHPExcel();

$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('D1', 'Profitability Report')
    //-- COMPANY DETAILS --//
    ->setCellValue('E1', $line1)
    ->setCellValue('E2', $line2)
    ->setCellValue('E3', $line3)
    ->setCellValue('E4', $line4)
    ->setCellValue('E5', $line5)
    ->setCellValue('E6', $line6)
    ->setCellValue('E7', $line7)
;


if(isset($salesPerson) && strcmp($salesPerson,'')!=0) {

    $stm = $db->prepare("SELECT salesperson_code,CONCAT(first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id='$salesPerson' LIMIT 1");
    $stm->execute();
    $stm->bind_result($spCode,$spName);
    while ($stm->fetch()) {}
    $stm->close();

    $objPHPExcel->setActiveSheetIndex(0)
        ->setCellValue('A7', "PERSON:")
        ->setCellValue('B7', $spCode." - ".$spName);
}


//-- COMPANY LOGO --//
$objDrawing = new PHPExcel_Worksheet_Drawing();
$objDrawing->setName('logo');
$objDrawing->setDescription('logo');
$objDrawing->setPath(ROOT . 'media/pdfimage/logo.png');
$objDrawing->setCoordinates('A1');
$objDrawing->setWidthAndHeight(200, 200);
$objDrawing->setOffsetY(100);
$objDrawing->setWorksheet($objPHPExcel->getActiveSheet());


$row = $objPHPExcel->getActiveSheet()->getHighestRow()+1;

$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A'.$row, "FROM:")
    ->setCellValue('B'.$row, $fromDate)
;

$row = $objPHPExcel->getActiveSheet()->getHighestRow()+1;


$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A'.$row, "TO:")
    ->setCellValue('B'.$row, $toDate)
;

//--SUMMARY--//
$row = $objPHPExcel->getActiveSheet()->getHighestRow()+2;

$objPHPExcel->getActiveSheet()->getStyle('A'.$row.':C'.$row)->applyFromArray(
    array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => '000000')
            )
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'color' => array('rgb' => '000000')
        ),
        'font'  => array(
            'bold'  => true,
            'color' => array('rgb' => 'FFFFFF'),
            'size'  => 10
        )
    )
);

$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A'.$row, "PROFIT")
    ->setCellValue('B'.$row, "PROFIT LOSS")
    ->setCellValue('C'.$row, "PROFITABILITY AMOUNT")

;


$row = $objPHPExcel->getActiveSheet()->getHighestRow()+1;
$objPHPExcel->getActiveSheet()->getStyle("A".$row.":C".$row)->getNumberFormat()->setFormatCode('0.00');
$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A'.$row, $invoiceSUM)
    ->setCellValue('B'.$row, $returnSUM)
    ->setCellValue('C'.$row, $profitability)

;

$styleRow = $objPHPExcel->getActiveSheet()->getHighestRow()+1;


$objPHPExcel->getActiveSheet()->getStyle('A'.$row.':C'.$row)->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    )
);
$objPHPExcel->getActiveSheet()->getStyle('A'.$styleRow.':C'.$row)->applyFromArray(
    array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => '000000')
            )
        )
    )
);

//--SUMMARY END--//

//--ANALYTICS--//
$row = $objPHPExcel->getActiveSheet()->getHighestRow()+2;

$objPHPExcel->getActiveSheet()->getStyle('A'.$row.':D'.$row)->applyFromArray(
    array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => '000000')
            )
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'color' => array('rgb' => '000000')
        ),
        'font'  => array(
            'bold'  => true,
            'color' => array('rgb' => 'FFFFFF'),
            'size'  => 10
        )
    )
);

$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A'.$row, "NO. OF INVOICES")
    ->setCellValue('B'.$row, "INVOICES TOTAL")
    ->setCellValue('C'.$row, "PRODUCT COST")
    ->setCellValue('D'.$row, "PROFIT")

;

$row = $objPHPExcel->getActiveSheet()->getHighestRow()+1;
$objPHPExcel->getActiveSheet()->getStyle("B".$row.":D".$row)->getNumberFormat()->setFormatCode('0.00');
$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A'.$row, $countInvoices)
    ->setCellValue('B'.$row, $invoiceTotal)
    ->setCellValue('C'.$row, $costTotal)
    ->setCellValue('D'.$row, $invoiceSUM)

;

$row = $objPHPExcel->getActiveSheet()->getHighestRow()+2;

$objPHPExcel->getActiveSheet()->getStyle('A'.$row.':D'.$row)->applyFromArray(
    array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => '000000')
            )
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'color' => array('rgb' => '000000')
        ),
        'font'  => array(
            'bold'  => true,
            'color' => array('rgb' => 'FFFFFF'),
            'size'  => 10
        )
    )
);

$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A'.$row, "NO. OF RETURNS")
    ->setCellValue('B'.$row, "RETURNS TOTAL")
    ->setCellValue('C'.$row, "PRODUCT COST")
    ->setCellValue('D'.$row, "PROFIT LOSS")

;

$row = $objPHPExcel->getActiveSheet()->getHighestRow()+1;
$objPHPExcel->getActiveSheet()->getStyle("B".$row.":D".$row)->getNumberFormat()->setFormatCode('0.00');
$objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A'.$row, $countReturns)
    ->setCellValue('B'.$row, $returnTotal)
    ->setCellValue('C'.$row, $returnCostTotal)
    ->setCellValue('D'.$row, $returnSUM)

;

//--ANALYTICS END--//



$objPHPExcel->getActiveSheet()->getStyle('A'.$row.':D'.$row)->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    )
);



$objPHPExcel->getActiveSheet()->getStyle('E'.$styleRow.':E'.$row)->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
            'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    )
);


$objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle('A1:E'.$row)->applyFromArray(
    array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => 'FFFFFF')
            )
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle('A11:C12')->applyFromArray(
    array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => '000000')
            )
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle('A14:D15')->applyFromArray(
    array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => '000000')
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER
            )
        )
    )
);
$endRow   = $objPHPExcel->getActiveSheet()->getHighestRow();
$objPHPExcel->getActiveSheet()->getStyle('A17:D'.$endRow)->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => '000000')
            )
        )
    )
);
$objPHPExcel->getActiveSheet()->getStyle('E1:E7')->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle('A7:C9')->applyFromArray(
    array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle("A1:E".$row)->getFont()->setBold( true );
foreach(range('A','G') as $columnID) {
    $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)
        ->setAutoSize(true);
}




// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="profitability.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');


?>