<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/functions/subunitsFunctions.php");

require_once (ROOT . "libs/mPDF/vendor/autoload.php");

$showDiscount = true;
$showBarcode = false;
$zreportCode = $_POST['zreportCode']; //'Z1100040';
$zreportCode = 'Z1100040';


global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

$arrayReceiptID = array();
$stm = $db->prepare("SELECT document_id FROM ZE_Z_Report WHERE lock_number='$zreportCode' AND document_type='Receipts'");
$stm->execute();
$stm->bind_result($docID);
while ($stm->fetch()) {
    array_push($arrayReceiptID,$docID);
}
$stm->close();

if (count($arrayReceiptID)>0){
    $arrayReceiptIDImpode = implode(',',$arrayReceiptID);
    $arrayReceiptTotals = array();
    $arrayReceiptInfo = array();
    $arrayReceiptInfoMultiple = array();
    $hasMultiple = false;
    $stm = $db->prepare("SELECT receipt_id,receipt_code,customer_id,salesperson_id,cheque_number,payment_method,amount FROM Receipts WHERE receipt_id IN ($arrayReceiptIDImpode) ");
    $stm->execute();
    $stm->bind_result($receiptID,$receiptCode,$customerID,$salespersonID,$checkNumber,$paymentMethod,$amount);
    while ($stm->fetch()) {
            $objectReceipt = new stdClass();
            $objectReceipt->receipt_id = $receiptID;
            $objectReceipt->receipt_code = $receiptCode;
            $objectReceipt->customer_id = $customerID;
            $objectReceipt->salesperson_id = $salespersonID;
            $objectReceipt->cheque_number = $checkNumber;
            $objectReceipt->payment_method = $paymentMethod;
            $objectReceipt->amount = $amount;
            $arrayReceiptTotals["$paymentMethod"] += $amount;
            array_push($arrayReceiptInfo,$objectReceipt);
    }
    $stm->close();
}
function viewArray($arr){
    echo "<pre>";
    var_dump($arr);
    echo "</pre>";
}

function getInvoicePDFForPrinting($receiptID)
{
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }


    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT receipt_code, customer_id, company_id, salesperson_id, order_id, invoice_id, address_id, amount, payment_method, cash_discount, bank, branch, cheque_number, cheque_date, receipt_date, notes, status FROM Receipts WHERE receipt_id=$receiptID");
    $stm->execute();
    $stm->bind_result($receiptCode, $customerID,$companyID,$salespersonID,$orderID,$invoiceID,$receiptAddressID,$amount,$paymentMethod,$cashDiscount,$bank, $branch, $chequeNumber, $chequeDate,$receiptDate, $notes, $status);
    while ($stm->fetch()) {}
    $stm->close();

    $invoiceReference = array();
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT invoice_code, grand_total FROM Invoices,Invoice_Receipt WHERE Invoices.invoice_id = Invoice_Receipt.invoice_id AND receipt_id=$receiptID");
    $stm->execute();
    $stm->bind_result($invoiceCode, $invoiceTotal);
    while ($stm->fetch()) {

        $invoice = new stdClass();
        $invoice->code  = $invoiceCode;
        $invoice->total = $invoiceTotal;

        array_push($invoiceReference, $invoice);
    }
    $stm->close();
    $amountForText = $amount;
    $amount       = number_format($amount,2);
    $cashDiscount = number_format($cashDiscount,2);
    $receiptDate  = date_format( date_create_from_format('Y-m-d', $receiptDate), 'd-m-Y');
    $chequeDate   = date_format( date_create_from_format('Y-m-d',  $chequeDate), 'd-m-Y');


    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
    $stm->execute();
    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
    while ($stm->fetch()) {}
    $stm->close();


    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName);
    while ($stm->fetch()) {}
    $stm->close();


    $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$receiptAddressID'");
    $stm->execute();
    $stm->bind_result($addressLine1, $addressLine2,$postcode,$city,$landline);
    while ($stm->fetch()) {}
    $stm->close();


    $stm = $db->prepare("SELECT CONCAT(salesperson_code,' - ',first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id='$salespersonID'");
    $stm->execute();
    $stm->bind_result($salespersonDisplayName);
    while ($stm->fetch()) {}
    $stm->close();


    $whole = floor($amountForText);      // 1
    $decimal = round(($amountForText - $whole)*100); // .25

    $money = convertNumber($whole);
    $cents = convertNumber($decimal);

    $stringAmount = strtoupper("$money and $cents cents ");

    $result= "



<style>


        body
        {


        }

        p
        {

        }

        #wrapper
        {
            width:190mm;
            margin:0 10mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {

        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_body
        {

        }

        td {
          font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;
        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size: 11px;
            border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

        #table_info td {
           font-size: 12px;
           padding:0;

        }

    </style>


<htmlpageheader name='myHTMLHeader1'>
  <table class='heading' >
  <tr>
  <td valign='top' style='width:33%'>
      <img style='width:33%;height:auto;' src='//" . HTML_PATH . "/cop/media/pdfimage/logo.png'/>
  </td>
  <td  valign='top' style='width:33%' align='center'>
     <p style='font-weight:bold; font-size:22px;'>Receipt</p>
  </td>
  <td valign='top' style='width:33%' align='right'>
     <h1 class='heading' style='padding-top:2px;padding-bottom:2px;'>$line1</h1>
                <div class='heading' style='font-size:11px;'>
                    $line2<br/>
                    $line3<br/>
                    $line4<br/>
                    $line5<br/>
                    $line6<br/>
                    $line7
                </div>
  </td>
   </tr>
  </table>

</htmlpageheader>
<h4>$customerName</h4>
<table id='table_info' style='width:100%;margin-top:0;padding-top:0;'>
        <tr>
             <td rowspan='2' valign='top' align='left' style='width:33%'>
                <h4>Customer Details</h4>
                <table>

                    <tr><td >$customerName</td></tr>
                    <tr><td >$addressLine1</td></tr>
                    <tr><td >$addressLine2</td></tr>
                    <tr><td >$postcode    </td></tr>
                    <tr><td >$city        </td></tr>
                    <tr><td >$landline    </td></tr>
                </table>
            </td>
            <td rowspan='1' valign='top' align='center' style='width:33%'>
                <h4 >Additional Details</h4>
                <table>
                  <tr><td >Account Code: </td><td>$customerCode</td></tr>
                  <tr><td colspan='2'>SP: $salespersonDisplayName</td></tr>

                </table>
            </td>
            <td rowspan='1' valign='top' align='right' style='width:33%'>
                <h4 >Receipt Details</h4>
                <table>
                  <tr><td >Receipt Number: $receiptCode  </td></tr>
                  <tr><td >Receipt Date:   $receiptDate  </td></tr>
                  <tr><td >Payment Method: $paymentMethod</td></tr>
                </table>
            </td>

        </tr>

    </table>
    <br/>
    <table repeat_header='1' id='tableHeader' style='width:100%;border-top: 1px solid #222222;border-bottom: 1px solid #222222;background:#f5f8ff;padding-top:3px;padding-bottom:3px;'>
        <tr>
            <td style='font-size:13px;width:5%;text-align:center;' ><b>Receipt Amount</b></td>
        </tr>
        <tr>
            <td style='font-size:13px;width:5%;text-align:center;' ><h1 style='color: #0a6ebd'> &euro;$amount</h1></td>
        </tr>
        <tr>
            <td style='font-size:13px;width:5%;text-align:center;' >$stringAmount</td>
        </tr>
    </table>
    <br/>
    <table id='table_info' style='width:100%;margin-top:0;padding-top:0;'>
        <tr>
             <td rowspan='2' valign='top' align='left' style='width:33%'>";

    if(!empty($invoiceReference)) {
        $result .= "<h4 >Invoice Reference</h4>
                <br/>
                <table>";

        foreach ($invoiceReference as $invoice){
            $result .= " <tr><td>$invoice->code : &euro;$invoice->total</td></tr>";
        }

        $result .= " </table>";
    }

    $result.="</td>
            <td rowspan='1' valign='top' align='center' style='width:33%'>";

    if(strcmp($notes,'') != 0){
        $result .= "<h4 >Receipt Notes</h4>
                <br/>
                 <table>
                  <tr><td >$notes</td></tr>
                 </table>";
    }
    $result.="</td>
            <td rowspan='1' valign='top' align='right' style='width:33%'>";

    if($cashDiscount > 0) {
        $result .= "    <h4 >Cash Discount: &euro;$cashDiscount</h4><br/>";
    }
    if(strcmp($paymentMethod,'Cheque') == 0) {
        $result .= " <table>
                  <tr><td colspan='2'> <h4 >Cheque Details</h4> </td></tr>
                  <tr><td >Bank:         </td><td >$bank        </td></tr>
                  <tr><td >Branch:       </td><td >$branch      </td></tr>
                  <tr><td >Cheque Number:</td><td >$chequeNumber</td></tr>
                  <tr><td >Cheque Date:  </td><td >$chequeDate  </td></tr>
                 </table>";
    }
    $result.=" </td>

        </tr>

    </table>
        <div style='margin-top:80px;width:100%;'>
           <table style='width:100%;'>
               <tr>
                 <td style='width:50%;'>
                    <table style='width:100%;'>
                       <tr>
                       <td style='width:40%'>

                       </td>
                        <td style='border-top: 1px solid #000000;width:20%;text-align:center'>
                            <p style='font-size:11px;'>Salesperson Signature</p>
                       </td>
                        <td style='width:40%'>

                       </td>
                       </tr>
                    </table>
                  </td>
              </tr>
           </table>

        </div>
        <htmlpagefooter name='myFooter1'>
        <div>
          <p style='margin-top:5px;font-size:10px;font-family: Helvetica Neue, Helvetica, Arial, sans-serif'> Powered by Coprime Mobile Commerce: 25-311504 </p>
        </div>

            <table width='100%' style='vertical-align: bottom; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 8pt;
                color: #000000;  '><tr>
                <td width='33%'><span style=''></span></td>
                <td width='33%' align='center' style=''>Page {PAGENO} of {nbpg}</td>
                <td width='33%' style='text-align: right; '></td>
                </tr></table>
            </htmlpagefooter>



";


    return $result;
}

//viewArray($arrayReceiptInfo);
$filesArray = array();
echo "start Loop<br>";
foreach ($arrayReceiptInfo as $receiptObj){
    if(file_exists(ROOT."media/pdfs/receipts/Receipt$receiptObj->receipt_code.pdf")){
        continue;
    }else{
        $result = getInvoicePDFForPrinting($receiptObj->receipt_id);
        $mpdf=new mPDF();
        $mpdf->setAutoTopMargin='stretch';
        $mpdf->setAutoBottomMargin='stretch';
        $mpdf->keep_table_proportions=true;
        $mpdf->WriteHTML($result);
        $mpdf->Output("ReceiptZreportExport-$receiptObj->receipt_id.pdf","F");
        echo "ReceiptZreportExport-$receiptObj->receipt_id.pdf<br>";
        array_push($filesArray,"ReceiptZreportExport-$receiptObj->receipt_id.pdf");
    }
}
echo "end Loop <br>";
//mergeAndDownloadPDFFiles($filesArray,'ReceiptZreportExport.pdf',new mPDF());


function mergeAndDownloadPDFFiles(Array $filenames, $outFile,$mpdf)
{
    if ($filenames) {

        $filesTotal = sizeof($filenames);
        $fileNumber = 1;

        $mpdf->SetImportUse(); // this line comment out if method doesnt exist

        if (!file_exists($outFile)) {
            $handle = fopen($outFile, 'w');
            fclose($handle);
        }

        foreach ($filenames as $fileName) {
            if (file_exists($fileName)) {
                $pagesInFile = $mpdf->SetSourceFile($fileName);
                for ($i = 1; $i <= $pagesInFile; $i++) {
                    $tplId = $mpdf->ImportPage($i); // in mPdf v8 should be 'importPage($i)'
                    $mpdf->UseTemplate($tplId);
//                    $mpdf->SetHTMLFooter($footer);
                    if (($fileNumber < $filesTotal) || ($i != $pagesInFile)) {
                        $mpdf->WriteHTML('<pagebreak />');
                    }
                }
            }
            $fileNumber++;
        }

        $mpdf->Output($outFile,"I");

        foreach (glob("ReceiptZreportExport-*.*") as $filename) {
            unlink($filename);
        }

    }

}









function convertNumber($number)
{
    list($integer, $fraction) = explode(".", (string) $number);

    $output = "";

    if ($integer[0] == "-")
    {
        $output = "negative ";
        $integer    = ltrim($integer, "-");
    }
    else if ($integer[0] == "+")
    {
        $output = "positive ";
        $integer    = ltrim($integer, "+");
    }

    if ($integer[0] == "0")
    {
        $output .= "zero";
    }
    else
    {
        $integer = str_pad($integer, 36, "0", STR_PAD_LEFT);
        $group   = rtrim(chunk_split($integer, 3, " "), " ");
        $groups  = explode(" ", $group);

        $groups2 = array();
        foreach ($groups as $g)
        {
            $groups2[] = convertThreeDigit($g[0], $g[1], $g[2]);
        }

        for ($z = 0; $z < count($groups2); $z++)
        {
            if ($groups2[$z] != "")
            {
                $output .= $groups2[$z] . convertGroup(11 - $z) . (
                    $z < 11
                    && !array_search('', array_slice($groups2, $z + 1, -1))
                    && $groups2[11] != ''
                    && $groups[11][0] == '0'
                        ? " and "
                        : ", "
                    );
            }
        }

        $output = rtrim($output, ", ");
    }

    if ($fraction > 0)
    {
        $output .= " point";
        for ($i = 0; $i < strlen($fraction); $i++)
        {
            $output .= " " . convertDigit($fraction[$i]);
        }
    }

    return $output;
}

function convertGroup($index)
{
    switch ($index)
    {
        case 11:
            return " decillion";
        case 10:
            return " nonillion";
        case 9:
            return " octillion";
        case 8:
            return " septillion";
        case 7:
            return " sextillion";
        case 6:
            return " quintrillion";
        case 5:
            return " quadrillion";
        case 4:
            return " trillion";
        case 3:
            return " billion";
        case 2:
            return " million";
        case 1:
            return " thousand";
        case 0:
            return "";
    }
}

function convertThreeDigit($digit1, $digit2, $digit3)
{
    $buffer = "";

    if ($digit1 == "0" && $digit2 == "0" && $digit3 == "0")
    {
        return "";
    }

    if ($digit1 != "0")
    {
        $buffer .= convertDigit($digit1) . " hundred";
        if ($digit2 != "0" || $digit3 != "0")
        {
            $buffer .= " ";
        }
    }

    if ($digit2 != "0")
    {
        $buffer .= convertTwoDigit($digit2, $digit3);
    }
    else if ($digit3 != "0")
    {
        $buffer .= convertDigit($digit3);
    }

    return $buffer;
}

function convertTwoDigit($digit1, $digit2)
{
    if ($digit2 == "0")
    {
        switch ($digit1)
        {
            case "1":
                return "ten";
            case "2":
                return "twenty";
            case "3":
                return "thirty";
            case "4":
                return "forty";
            case "5":
                return "fifty";
            case "6":
                return "sixty";
            case "7":
                return "seventy";
            case "8":
                return "eighty";
            case "9":
                return "ninety";
        }
    } else if ($digit1 == "1")
    {
        switch ($digit2)
        {
            case "1":
                return "eleven";
            case "2":
                return "twelve";
            case "3":
                return "thirteen";
            case "4":
                return "fourteen";
            case "5":
                return "fifteen";
            case "6":
                return "sixteen";
            case "7":
                return "seventeen";
            case "8":
                return "eighteen";
            case "9":
                return "nineteen";
        }
    } else
    {
        $temp = convertDigit($digit2);
        switch ($digit1)
        {
            case "2":
                return "twenty $temp";
            case "3":
                return "thirty $temp";
            case "4":
                return "forty $temp";
            case "5":
                return "fifty $temp";
            case "6":
                return "sixty $temp";
            case "7":
                return "seventy $temp";
            case "8":
                return "eighty $temp";
            case "9":
                return "ninety $temp";
        }
    }
}

function convertDigit($digit)
{
    switch ($digit)
    {
        case "0":
            return "zero";
        case "1":
            return "one";
        case "2":
            return "two";
        case "3":
            return "three";
        case "4":
            return "four";
        case "5":
            return "five";
        case "6":
            return "six";
        case "7":
            return "seven";
        case "8":
            return "eight";
        case "9":
            return "nine";
    }
}
?>