<?php
class Stock
{
    public $item;
    public $warehouse;
    public $batchNumber;
    public $available;
    public $reserved;
    public $delivered;
    public $onOrder;
    public $requested;
    public $sold;
    public $expiryDate;

    /**
     * Stock constructor.
     * @param $item
     * @param $warehouse
     * @param $batchNumber
     * @param $available
     * @param $reserved
     * @param $delivered
     * @param $onOrder
     * @param $requested
     * @param $sold
     * @param $expiryDate
     */
    public function __construct($item, $warehouse, $batchNumber, $available, $reserved, $delivered, $onOrder, $requested, $sold, $expiryDate)
    {
        $this->item = $item;
        $this->warehouse = $warehouse;
        $this->batchNumber = $batchNumber;
        $this->available = $available;
        $this->reserved = $reserved;
        $this->delivered = $delivered;
        $this->onOrder = $onOrder;
        $this->requested = $requested;
        $this->sold = $sold;
        $this->expiryDate = $expiryDate;
    }

    /**
     * @return mixed
     */
    public function getItem()
    {
        return $this->item;
    }

    /**
     * @param mixed $item
     * @return Stock
     */
    public function setItem($item)
    {
        $this->item = $item;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getWarehouse()
    {
        return $this->warehouse;
    }

    /**
     * @param mixed $warehouse
     * @return Stock
     */
    public function setWarehouse($warehouse)
    {
        $this->warehouse = $warehouse;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getBatchNumber()
    {
        return $this->batchNumber;
    }

    /**
     * @param mixed $batchNumber
     * @return Stock
     */
    public function setBatchNumber($batchNumber)
    {
        $this->batchNumber = $batchNumber;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getAvailable()
    {
        return $this->available;
    }

    /**
     * @param mixed $available
     * @return Stock
     */
    public function setAvailable($available)
    {
        $this->available = $available;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getReserved()
    {
        return $this->reserved;
    }

    /**
     * @param mixed $reserved
     * @return Stock
     */
    public function setReserved($reserved)
    {
        $this->reserved = $reserved;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getDelivered()
    {
        return $this->delivered;
    }

    /**
     * @param mixed $delivered
     * @return Stock
     */
    public function setDelivered($delivered)
    {
        $this->delivered = $delivered;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getOnOrder()
    {
        return $this->onOrder;
    }

    /**
     * @param mixed $onOrder
     * @return Stock
     */
    public function setOnOrder($onOrder)
    {
        $this->onOrder = $onOrder;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getRequested()
    {
        return $this->requested;
    }

    /**
     * @param mixed $requested
     * @return Stock
     */
    public function setRequested($requested)
    {
        $this->requested = $requested;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getSold()
    {
        return $this->sold;
    }

    /**
     * @param mixed $sold
     * @return Stock
     */
    public function setSold($sold)
    {
        $this->sold = $sold;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getExpiryDate()
    {
        return $this->expiryDate;
    }

    /**
     * @param mixed $expiryDate
     * @return Stock
     */
    public function setExpiryDate($expiryDate)
    {
        $this->expiryDate = $expiryDate;
        return $this;
    }



}

?>