<?php
class Schedule
{
    public $scheduleID;
    public $name;
    public $creationDate;
    public $creatorID;
    public $type;
    public $date;
    public $repeatPeriod;
    public $day;
    public $week;
    public $month;
    public $notes;

    public $scheduleCustomers = array();


    public function __construct($scheduleID, $name, $creationDate, $creatorID, $type, $date, $repeatPeriod, $day, $week, $month, $notes, $scheduleCustomers)
    {
        $this->scheduleID = $scheduleID;
        $this->name = $name;
        $this->creationDate = $creationDate;
        $this->creatorID = $creatorID;
        $this->type = $type;
        $this->date = $date;
        $this->repeatPeriod = $repeatPeriod;
        $this->day = $day;
        $this->week = $week;
        $this->month = $month;
        $this->notes = $notes;
        $this->scheduleCustomers = $scheduleCustomers;
    }

    /**
     * @return mixed
     */
    public function getScheduleID()
    {
        return $this->scheduleID;
    }

    /**
     * @param mixed $scheduleID
     * @return Schedule
     */
    public function setScheduleID($scheduleID)
    {
        $this->scheduleID = $scheduleID;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param mixed $name
     * @return Schedule
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getCreationDate()
    {
        return $this->creationDate;
    }

    /**
     * @param mixed $creationDate
     * @return Schedule
     */
    public function setCreationDate($creationDate)
    {
        $this->creationDate = $creationDate;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getCreatorID()
    {
        return $this->creatorID;
    }

    /**
     * @param mixed $creatorID
     * @return Schedule
     */
    public function setCreatorID($creatorID)
    {
        $this->creatorID = $creatorID;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param mixed $type
     * @return Schedule
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @param mixed $date
     * @return Schedule
     */
    public function setDate($date)
    {
        $this->date = $date;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getRepeatPeriod()
    {
        return $this->repeatPeriod;
    }

    /**
     * @param mixed $repeatPeriod
     * @return Schedule
     */
    public function setRepeatPeriod($repeatPeriod)
    {
        $this->repeatPeriod = $repeatPeriod;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getDay()
    {
        return $this->day;
    }

    /**
     * @param mixed $day
     * @return Schedule
     */
    public function setDay($day)
    {
        $this->day = $day;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getWeek()
    {
        return $this->week;
    }

    /**
     * @param mixed $week
     * @return Schedule
     */
    public function setWeek($week)
    {
        $this->week = $week;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getMonth()
    {
        return $this->month;
    }

    /**
     * @param mixed $month
     * @return Schedule
     */
    public function setMonth($month)
    {
        $this->month = $month;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getNotes()
    {
        return $this->notes;
    }

    /**
     * @param mixed $notes
     * @return Schedule
     */
    public function setNotes($notes)
    {
        $this->notes = $notes;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getScheduleCustomers()
    {
        return $this->scheduleCustomers;
    }

    /**
     * @param mixed $scheduleCustomers
     * @return Schedule
     */
    public function setScheduleCustomers($scheduleCustomers)
    {
        $this->scheduleCustomers = $scheduleCustomers;
        return $this;
    }

    public function addScheduleCustomer($scheduleCustomer)
    {
        array_push($this->scheduleCustomers , $scheduleCustomer);
        return $this;
    }


}
?>