<?php
class PriceGroup
{
    public $priceGroupDefinitionID;
    public $priceGroupCode;
    public $name;
    public $type;

    public $customerGroups = array();
    public $customers = array();
    public $priceGroupRules = array();


    public function __construct($priceGroupDefinitionID, $priceGroupCode, $name, $type)
    {
        $this->priceGroupDefinitionID = $priceGroupDefinitionID;
        $this->priceGroupCode = $priceGroupCode;
        $this->name = $name;
        $this->type = $type;
    }

    /**
     * @return mixed
     */
    public function getPriceGroupDefinitionID()
    {
        return $this->priceGroupDefinitionID;
    }

    /**
     * @param mixed $priceGroupDefinitionID
     */
    public function setPriceGroupDefinitionID($priceGroupDefinitionID)
    {
        $this->priceGroupDefinitionID = $priceGroupDefinitionID;
    }

    /**
     * @return mixed
     */
    public function getPriceGroupCode()
    {
        return $this->priceGroupCode;
    }

    /**
     * @param mixed $priceGroupCode
     */
    public function setPriceGroupCode($priceGroupCode)
    {
        $this->priceGroupCode = $priceGroupCode;
    }

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param mixed $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return mixed
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param mixed $type
     */
    public function setType($type)
    {
        $this->type = $type;
    }

    /**
     * @return mixed
     */
    public function getCustomerGroups()
    {
        return $this->customerGroups;
    }

    /**
     * @param mixed $customerGroups
     */
    public function setCustomerGroups($customerGroups)
    {
        $this->customerGroups = $customerGroups;
    }

    /**
     * @return mixed
     */
    public function getCustomers()
    {
        return $this->customers;
    }

    /**
     * @param mixed $customers
     */
    public function setCustomers($customers)
    {
        $this->customers = $customers;
    }


    public function addCustomer($customer)
    {
        array_push($this->customers,$customer);
        return $this;
    }

    public function addCustomerGroup($customerGroup)
    {
        array_push($this->customerGroups,$customerGroup);
        return $this;
    }

    /**
     * @return mixed
     */
    public function getPriceGroupRules()
    {
        return $this->priceGroupRules;
    }

    /**
     * @param mixed $priceGroupRules
     */
    public function setPriceGroupRules($priceGroupRules)
    {
        $this->priceGroupRules = $priceGroupRules;
    }

    public function addPriceGroupRule($priceGroupRule)
    {
        array_push($this->priceGroupRules,$priceGroupRule);
        return $this;
    }




}
