<?php

/**
 * Created by PhpStorm.
 * User: hp
 * Date: 11/02/2016
 * Time: 16:30
 */
class Item
{
    public  $itemID;
    public  $itemCode;
    public  $itemSKU;
    public  $companyID;
    public  $vatID;
    public  $subunits;
    public $salesUnits;
    public $manufacturerID;
    public  $name;
    public  $shortDescription;
    public  $longDescription;
    public  $thumbnailUrl;
    public $reorderLevel;
    public  $targetQty;
    public  $bundle;
    public  $maxStock;
    public  $minStock;
    public  $packing;
    public  $stockControl;
    public  $sellable;
    public  $weight;
    public  $cbm;
    public  $status;

    public $itemCategories = array();
    public $itemBarcodes = array();

    /**
     * Item constructor.
     * @param $itemID
     * @param $itemCode
     * @param $itemSKU
     * @param $companyID
     * @param $vatID
     * @param $subunits
     * @param $salesUnits
     * @param $manufacturerID
     * @param $name
     * @param $shortDescription
     * @param $longDescription
     * @param $thumbnailUrl
     * @param $reorderLevel
     * @param $targetQty
     * @param $bundle
     * @param $maxStock
     * @param $minStock
     * @param $packing
     * @param $stockControl
     * @param $sellable
     * @param $weight
     * @param $cbm
     * @param $status
     */
    public function __construct($itemID, $itemCode, $itemSKU, $companyID, $vatID, $subunits, $salesUnits, $manufacturerID, $name, $shortDescription, $longDescription, $thumbnailUrl, $reorderLevel, $targetQty, $bundle, $maxStock, $minStock, $packing, $stockControl, $sellable, $weight, $cbm, $status)
    {
        $this->itemID = $itemID;
        $this->itemCode = $itemCode;
        $this->itemSKU = $itemSKU;
        $this->companyID = $companyID;
        $this->vatID = $vatID;
        $this->subunits = $subunits;
        $this->salesUnits = $salesUnits;
        $this->manufacturerID = $manufacturerID;
        $this->name = $name;
        $this->shortDescription = $shortDescription;
        $this->longDescription = $longDescription;
        $this->thumbnailUrl = $thumbnailUrl;
        $this->reorderLevel = $reorderLevel;
        $this->targetQty = $targetQty;
        $this->bundle = $bundle;
        $this->maxStock = $maxStock;
        $this->minStock = $minStock;
        $this->packing = $packing;
        $this->stockControl = $stockControl;
        $this->sellable = $sellable;
        $this->weight = $weight;
        $this->cbm = $cbm;
        $this->status = $status;
    }

    /**
     * @return mixed
     */
    public function getItemID()
    {
        return $this->itemID;
    }

    /**
     * @param mixed $itemID
     */
    public function setItemID($itemID)
    {
        $this->itemID = $itemID;
    }

    /**
     * @return mixed
     */
    public function getItemCode()
    {
        return $this->itemCode;
    }

    /**
     * @param mixed $itemCode
     */
    public function setItemCode($itemCode)
    {
        $this->itemCode = $itemCode;
    }

    /**
     * @return mixed
     */
    public function getItemSKU()
    {
        return $this->itemSKU;
    }

    /**
     * @param mixed $itemSKU
     */
    public function setItemSKU($itemSKU)
    {
        $this->itemSKU = $itemSKU;
    }

    /**
     * @return mixed
     */
    public function getCompanyID()
    {
        return $this->companyID;
    }

    /**
     * @param mixed $companyID
     */
    public function setCompanyID($companyID)
    {
        $this->companyID = $companyID;
    }

    /**
     * @return mixed
     */
    public function getVatID()
    {
        return $this->vatID;
    }

    /**
     * @param mixed $vatID
     */
    public function setVatID($vatID)
    {
        $this->vatID = $vatID;
    }

    /**
     * @return mixed
     */
    public function getSubunits()
    {
        return $this->subunits;
    }

    /**
     * @param mixed $subunits
     */
    public function setSubunits($subunits)
    {
        $this->subunits = $subunits;
    }

    /**
     * @return mixed
     */
    public function getSalesUnits()
    {
        return $this->salesUnits;
    }

    /**
     * @param mixed $salesUnits
     */
    public function setSalesUnits($salesUnits)
    {
        $this->salesUnits = $salesUnits;
    }

    /**
     * @return mixed
     */
    public function getManufacturerID()
    {
        return $this->manufacturerID;
    }

    /**
     * @param mixed $manufacturerID
     */
    public function setManufacturerID($manufacturerID)
    {
        $this->manufacturerID = $manufacturerID;
    }

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param mixed $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return mixed
     */
    public function getShortDescription()
    {
        return $this->shortDescription;
    }

    /**
     * @param mixed $shortDescription
     */
    public function setShortDescription($shortDescription)
    {
        $this->shortDescription = $shortDescription;
    }

    /**
     * @return mixed
     */
    public function getLongDescription()
    {
        return $this->longDescription;
    }

    /**
     * @param mixed $longDescription
     */
    public function setLongDescription($longDescription)
    {
        $this->longDescription = $longDescription;
    }

    /**
     * @return mixed
     */
    public function getThumbnailUrl()
    {
        return $this->thumbnailUrl;
    }

    /**
     * @param mixed $thumbnailUrl
     */
    public function setThumbnailUrl($thumbnailUrl)
    {
        $this->thumbnailUrl = $thumbnailUrl;
    }

    /**
     * @return mixed
     */
    public function getReorderLevel()
    {
        return $this->reorderLevel;
    }

    /**
     * @param mixed $reorderLevel
     */
    public function setReorderLevel($reorderLevel)
    {
        $this->reorderLevel = $reorderLevel;
    }

    /**
     * @return mixed
     */
    public function getTargetQty()
    {
        return $this->targetQty;
    }

    /**
     * @param mixed $targetQty
     */
    public function setTargetQty($targetQty)
    {
        $this->targetQty = $targetQty;
    }

    /**
     * @return mixed
     */
    public function getBundle()
    {
        return $this->bundle;
    }

    /**
     * @param mixed $bundle
     */
    public function setBundle($bundle)
    {
        $this->bundle = $bundle;
    }

    /**
     * @return mixed
     */
    public function getMaxStock()
    {
        return $this->maxStock;
    }

    /**
     * @param mixed $maxStock
     */
    public function setMaxStock($maxStock)
    {
        $this->maxStock = $maxStock;
    }

    /**
     * @return mixed
     */
    public function getMinStock()
    {
        return $this->minStock;
    }

    /**
     * @param mixed $minStock
     */
    public function setMinStock($minStock)
    {
        $this->minStock = $minStock;
    }

    /**
     * @return mixed
     */
    public function getPacking()
    {
        return $this->packing;
    }

    /**
     * @param mixed $packing
     */
    public function setPacking($packing)
    {
        $this->packing = $packing;
    }

    /**
     * @return mixed
     */
    public function getStockControl()
    {
        return $this->stockControl;
    }

    /**
     * @param mixed $stockControl
     */
    public function setStockControl($stockControl)
    {
        $this->stockControl = $stockControl;
    }

    /**
     * @return mixed
     */
    public function getSellable()
    {
        return $this->sellable;
    }

    /**
     * @param mixed $sellable
     */
    public function setSellable($sellable)
    {
        $this->sellable = $sellable;
    }

    /**
     * @return mixed
     */
    public function getWeight()
    {
        return $this->weight;
    }

    /**
     * @param mixed $weight
     */
    public function setWeight($weight)
    {
        $this->weight = $weight;
    }

    /**
     * @return mixed
     */
    public function getCbm()
    {
        return $this->cbm;
    }

    /**
     * @param mixed $cbm
     */
    public function setCbm($cbm)
    {
        $this->cbm = $cbm;
    }

    /**
     * @return mixed
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param mixed $status
     */
    public function setStatus($status)
    {
        $this->status = $status;
    }

    /**
     * @return array
     */
    public function getItemCategories()
    {
        return $this->itemCategories;
    }

    /**
     * @param array $itemCategories
     * @return Item
     */
    public function setItemCategories($itemCategories)
    {
        $this->itemCategories = $itemCategories;
        return $this;
    }




    public function addItemCategory($itemCategory)
    {
        array_push($this->itemCategories,$itemCategory);
        return $this;
    }

    /**
     * @return array
     */
    public function getItemBarcodes()
    {
        return $this->itemBarcodes;
    }

    /**
     * @param array $itemBarcodes
     * @return Item
     */
    public function setItemBarcodes($itemBarcodes)
    {
        $this->itemBarcodes = $itemBarcodes;
        return $this;
    }

    public function addItemBarcode($itemBarcode)
    {
        array_push($this->itemBarcodes,$itemBarcode);
        return $this;
    }



}