<?php
/**
 * PDO mysql database helper class
 *
 * @author    wildantea <wildannudin@gmail.com>
 * @copyright june 2013
 */
class Database
{

    protected $pdo;
    private $prefix = 1000;
    private $charset = 'utf8';
    private $datasec = array();
    private $ctrl_dir = array();
    private $eof_ctrl_dir = "\x50\x4b\x05\x06\x00\x00\x00\x00";
    private $old_offset = 0;
    private $error_message = '';
    public  $is_transaction = 0;
    private $data_exist;
    public  $documentStatusTypes = array('Tenders'=>'1','Orders'=>'2','Waybills'=>'3','Returns'=>'4','Invoices'=>'5','Receipts'=>'6','Transfers'=>'7');
    public  $affectedRecords = 0;
    public  $deletedRecords = 0;
    public  $deleteStatementRecords = 0;

    public function __construct($hostname, $username_db, $password_db, $db_name,$prefix=1000,$charset='utf8')
    {
        try {
            if(is_int((int)$prefix) && (int)$prefix > 0){$this->prefix = (int)$prefix;} else {echo 'Error Database Prefix Must Be integer.<br>';}
            if(strcmp($charset,'')!=0){$this->charset = $charset;}
            $this->pdo = new PDO("mysql:host=" . $hostname . ";dbname=" . $db_name . ";charset=" . $this->charset , $username_db, $password_db);
            $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->pdo->setAttribute(PDO::MYSQL_ATTR_INIT_COMMAND, "SET sql_mode=(SELECT REPLACE(@@sql_mode,'ONLY_FULL_GROUP_BY',''))");



        }
        catch (PDOException $e) {
            echo "error " . $e->getMessage();
        }
    }


    public function getAffectedRecords()
    {
        return $this->affectedRecords;
    }

    public function setAffectedRecords($affectedRecords)
    {
        $this->affectedRecords = $affectedRecords;
        return $this;
    }

    public function addAffectedRecord(){
        $this->affectedRecords += 1;
    }

    public function removeAffectedRecord(){
        $this->affectedRecords -= 1;
    }


    public function getDeletedRecords()
    {
        return $this->deletedRecords;
    }

    public function setDeletedRecords($deletedRecords)
    {
        $this->deletedRecords = $deletedRecords;
        return $this;
    }

    public function addDeletedRecord(){
        $this->deletedRecords += 1;
    }

    public function removeDeletedRecord(){
        $this->deletedRecords -= 1;
    }


    public function getDeleteStatementRecords()
    {
        return $this->deleteStatementRecords;
    }

    public function setDeleteStatementRecords($deleteStatementRecords)
    {
        $this->deleteStatementRecords = $deleteStatementRecords;
        return $this;
    }

    public function addDeleteStatementRecord(){
        $this->deleteStatementRecords += 1;
    }

    public function removeDeleteStatementRecord(){
        $this->deleteStatementRecords -= 1;
    }


    public function resetAffectedRecords(){
        $this->affectedRecords = 0;
        $this->deletedRecords = 0;
        $this->deleteStatementRecords = 0;
    }

    public function getDocumentStatusTypes()
    {
        return $this->documentStatusTypes;
    }

    public function setDocumentStatusTypes($documentStatusTypes)
    {
        $this->documentStatusTypes = $documentStatusTypes;
        return $this;
    }

    public function addDocumentStatusType($documentStatusType)
    {
        array_push($this->documentStatusTypes , $documentStatusType);
        return $this;
    }

    public function getPrefix()
    {
        return $this->prefix;
    }


    public function setPrefix($prefix)
    {
        $this->prefix = $prefix;
        return $this;
    }


    public function getCharset()
    {
        return $this->charset;
    }


    public function setCharset($charset)
    {
        $this->charset = $charset;
        return $this;
    }

    /**
     * custom query , joining multiple table, aritmathic etc
     *
     * @param  string $sql  custom query
     * @param  array  $data associative array
     * @return array  recordset
     */
    public function query($sql, $data = null)
    {
        if ($data !== null) {
            $dat = array_values($data);
        }
        $sel = $this->pdo->prepare($sql);

        try {
            if ($data !== null) {
                $sel->execute($dat);
            } else {
                $sel->execute();
            }
            $sel->setFetchMode(PDO::FETCH_OBJ);
            return $sel;
        }
        catch (PDOException $exception) {
            $this->setErrorMessage($exception->getMessage());
            echo $this->getErrorMessage();
            exit();
        }

    }

    /**
     * begin a transaction.
     */
    public function begin_transaction()
    {
        $this->pdo->setAttribute(PDO::ATTR_AUTOCOMMIT, 0);
        $this->pdo->beginTransaction();
    }
    /**
     * commit the transaction.
     */
    public function commit()
    {
        $this->pdo->commit();
        $this->pdo->setAttribute(PDO::ATTR_AUTOCOMMIT, 1);
    }
    /**
     * rollback the transaction.
     */
    public function rollback()
    {
        $this->pdo->rollBack();
        $this->pdo->setAttribute(PDO::ATTR_AUTOCOMMIT, 1);
    }

    /**
     * [getErrorMessage return string throw exception
     *
     * @return string return string error
     */
    function getErrorMessage()
    {
        return $this->error_message;
    }

    /**
     * [setErrorMessage set error message]
     *
     * @param [type] $error [description]
     */
    function setErrorMessage($error)
    {
        $this->error_message = $error;
    }

    /**
     * fetch only one row
     *
     * @param  string $table table name
     * @param  string $col   condition column
     * @param  string $val   value column
     * @return array recordset
     */
    public function fetchSingleRow($table, $col, $val)
    {
        $nilai = array(
            $val
        );
        $sel   = $this->pdo->prepare("SELECT * FROM $table WHERE $col=?");
        try {
            $sel->execute($nilai);
            $sel->setFetchMode(PDO::FETCH_OBJ);
            $obj = $sel->fetch();
            return $obj;
        }
        catch (PDOException $exception) {
            $this->setErrorMessage($exception->getMessage());
            echo $this->getErrorMessage();
        }
    }

    public function fetchCustomSingle($sql, $data = null)
    {
        if ($data !== null) {
            $dat = array_values($data);
        }
        $sel = $this->pdo->prepare($sql);
        try {
            if ($data !== null) {
                $sel->execute($dat);
            } else {
                $sel->execute();
            }
            $sel->setFetchMode(PDO::FETCH_OBJ);
            $obj = $sel->fetch();
            return $obj;
        }
        catch (PDOException $exception) {
            $this->setErrorMessage($exception->getMessage());
            echo $this->getErrorMessage();
        }
    }

    /**
     * fetch all data
     *
     * @param  string $table table name
     * @return array recordset
     */
    public function fetchAll($table)
    {
        $sel = $this->pdo->prepare("SELECT * FROM $table");
        try {
            $sel->execute();
            $sel->setFetchMode(PDO::FETCH_OBJ);
            return $sel;
        }
        catch (PDOException $exception) {
            $this->setErrorMessage($exception->getMessage());
            echo $this->getErrorMessage();
        }
    }

    /**
     * check if there is exist data
     *
     * @param  string $table table name
     * @param  array  $dat   array list of data to find
     * @return true or false
     */
    public function checkExist($table, $dat)
    {

        $data = array_values($dat);
        //grab keys
        $cols = array_keys($dat);
        $col  = implode(', ', $cols);

        foreach ($cols as $key) {
            $keys   = $key . "=?";
            $mark[] = $keys;
        }

        $count = count($dat);
        if ($count > 1) {
            $im  = implode(' and  ', $mark);
            $sel = $this->pdo->prepare("SELECT * from $table WHERE $im");
        } else {
            $im  = implode('', $mark);
            $sel = $this->pdo->prepare("SELECT * from $table WHERE $im");
        }
        $sel->execute($data);
        $sel->setFetchMode(PDO::FETCH_OBJ);
        $count = $sel->rowCount();
        if ($count > 0) {
            $obj              = $sel->fetch();
            $this->data_exist = $obj;
            return $this;
        } else {
            return false;
        }
    }

    /**
     * return data from checkExist function
     *
     * @return [type] [description]
     */
    public function getData()
    {
        return $this->data_exist;
    }

    /**
     * search data
     *
     * @param  string $table table name
     * @param  array  $col   column name
     * @param  array  $where where condition
     * @return array recordset
     */
    public function search($table, $where, $col=null)
    {
        $data = array_values($where);
        foreach ($data as $key) {
            $val     = '%' . $key . '%';
            $value[] = $val;
        }
        //grab keys
        $cols  = array_keys($where);
        if(count($col) > 0 && $col !== null) {
            $colum = implode(', ', $col);
        } else {
            $colum = '*';
        }
        foreach ($cols as $key) {
            $keys   = $key . " LIKE ?";
            $mark[] = $keys;
        }
        $count = count($where);
        if ($count > 1) {
            $im  = implode(' OR  ', $mark);
            $sel = $this->pdo->prepare("SELECT $colum from $table WHERE $im");
        } else {
            $im  = implode('', $mark);
            $sel = $this->pdo->prepare("SELECT $colum from $table WHERE $im");
        }

        $sel->execute($value);
        $sel->setFetchMode(PDO::FETCH_OBJ);
        return $sel;
    }
    /**
     * insert data to table
     *
     * @param string $table table name
     * @param array  $dat   associative array 'column_name'=>'val'
     */
    public function insert($table, $dat)
    {

        if ($dat !== null) {
            $data = array_values($dat);
        }
        //grab keys
        $cols = array_keys($dat);
        $col  = implode(', ', $cols);

        //grab values and change it value
        $mark = array();
        foreach ($data as $key) {
            $keys   = '?';
            $mark[] = $keys;
        }
        $im  = implode(', ', $mark);
        $ins = $this->pdo->prepare("INSERT INTO $table ($col) values ($im)");
        try {
            $ins->execute($data);
            $this->addAffectedRecord();
            return true;
        }
        catch (PDOException $exception) {
            $this->setErrorMessage($exception->getMessage());
            return false;
        }
    }

    /**
     * updateMulti mapper array
     * @param  array $update_value      array recordset 
     * @param  array $primary_key_value primary key value recordset
     * @return array                    array recordset
     */
    public function mapper($update_value,$primary_key_value) {
      $index=0;
      foreach ($update_value as $value) {
      $primary_value = $primary_key_value[$index];
      $append[] = array_map(function ($str) use($primary_value) { return "WHEN '".$primary_value."' THEN '$str'"; }, $value);
      $index++;
      }
      return $append;
    }

    /**
     * [updateMulti update bulk sql]
     * @param  [string] $table_name    table name
     * @param  array $update_value        array recordset with key value column_name and value of record
     * @param  string $primary_key_name   primary key column_name
     * @param  array $primary_key_value primary key value (single array )
     * @return boolean update query
     */

    public function updateMulti($table_name,$update_value,$primary_key_name,$primary_key_value) {

        $data_mapper_update = $this->mapper($update_value,$primary_key_value);
        $data_mapper = array_keys($data_mapper_update[0]);

          $collection = [];

        foreach ($data_mapper as $key) {
          $collection[] = "$key = (CASE $primary_key_name ".implode(' ', array_unique(
              // `array_column` will give you all values under `$key`
              array_column($data_mapper_update, $key)
          ))." END)";
        }
        $primary_key_quote = sprintf("'%s'", implode("','", $primary_key_value ) );
        $query = "UPDATE $table_name SET ".implode(",", $collection)." WHERE $primary_key_name IN ($primary_key_quote)";
        $ins = $this->pdo->prepare($query);
        try {
            $ins->execute();
            return true;
        }
        catch (PDOException $exception) {
            $this->setErrorMessage($exception->getMessage());
            return false;
        }
    }

    /**
     * insert multiple row at once
     *
     * @param  [type] $table      table name
     * @param  [type] $array_data multi array
     * @return [type]             boolen
     */
    public function insertMulti($table_name, $values)
    {
        $column_name = array_keys($values[0]);
        $column_name = implode(',', $column_name);

        $value_data = array();
        foreach ($values as $data => $val) {

            $value_data[] = '("' . implode('","', array_values($val)) . '")';
        }
        $string_value = implode(",", $value_data);

        $sql = "INSERT INTO $table_name ($column_name) VALUES " . $string_value;
        $ins = $this->pdo->prepare($sql);
        try {
            $ins->execute();
            return true;
        }
        catch (PDOException $exception) {
            $this->setErrorMessage($exception->getMessage());
            return false;
        }
    }
    

    public function getLastInsertID($table,$id)
    {
        try {
            $sel = $this->pdo->prepare("SELECT $id FROM $table WHERE $id LIKE ? ORDER BY $id DESC LIMIT 1");
            $sel->execute(array($this->prefix.'%'));
            $sel->setFetchMode(PDO::FETCH_ASSOC);
            foreach ($sel as $object) {return $object[$id];}
        }
        catch (PDOException $exception) {
            $this->setErrorMessage($exception->getMessage());
            echo $this->getErrorMessage();
            exit();
        }
    }

    public function getNextInsertID($table,$id)
    {
        $prevID = $this->getLastInsertID($table,$id);
        $nextID = substr($prevID,strlen($this->prefix),strlen($prevID));
        $nextID += 1;

        return $this->prefix.$nextID;
    }

    /**
     * update record
     *
     * @param string $table table name
     * @param array  $dat   associative array 'col'=>'val'
     * @param string $id    primary key column name
     * @param int    $val   key value
     */
    public function update($table, $dat, $id, $val)
    {
        if ($dat !== null) {
            $data = array_values($dat);
        }
        if($val>0) {
            array_push($data, $val);
            //grab keys
            $cols = array_keys($dat);
            $mark = array();
            foreach ($cols as $col) {
                $mark[] = $col . "=?";
            }
            $im = implode(', ', $mark);
            $ins = $this->pdo->prepare("UPDATE $table SET $im where $id=?");
            try {
                $ins->execute($data);
                $this->addAffectedRecord();
                return true;
            } catch (PDOException $exception) {
                $this->setErrorMessage($exception->getMessage());
                return false;
            }
        } else {
            $this->setErrorMessage(' error Missing ID');
            return false;
        }

    }



    /**
     * delete record
     *
     * @param string $table table name
     * @param string $where column name for condition (commonly primay key column name)
     * @param int    $id    key value
     */
    public function delete($table, $where, $id)
    {
        $data = array(
            $id
        );
        $sel  = $this->pdo->prepare("Delete from $table where $where=?");
        try {
            $sel->execute($data);
            $this->addDeletedRecord();
            return true;
        }
        catch (PDOException $exception) {
            $this->setErrorMessage($exception->getMessage());
            return false;
        }
    }

    public function deleteFromLinkedTable($table, $idColumnsValues)
    {
        $data  = array_values($idColumnsValues);
        $cols  = array_keys($idColumnsValues);

        foreach ($cols as $col){
            $mark[] = $col . '=?';
        }

        $im = implode(' AND ',$mark);

        $sel  = $this->pdo->prepare("Delete from $table where $im");
        try {
            $sel->execute($data);
            $this->addDeletedRecord();
            return true;
        }
        catch (PDOException $exception) {
            $this->setErrorMessage($exception->getMessage());
            return false;
        }
    }


    //write file
    function createFile($file, $isi)
    {
        $fp = fopen($file, 'w');
        if (!$fp) {
            return 0;
        }
        fwrite($fp, $isi);
        fclose($fp);
        return 1;

    }
    //hapus directory
    function deleteDirectory($dir)
    {
        if (!file_exists($dir)) {
            return true;
        }
        if (!is_dir($dir) || is_link($dir)) {
            return unlink($dir);
        }
        foreach (scandir($dir) as $item) {
            if ($item == '.' || $item == '..') {
                continue;
            }
            if (!$this->deleteDirectory($dir . "/" . $item)) {
                chmod($dir . "/" . $item, 0777);
                if (!$this->deleteDirectory($dir . "/" . $item)) {
                    return false;
                }
            }
            ;
        }
        return rmdir($dir);
    }



    //selected active menu
    public function terpilih($nav, $group_id)
    {
        $pilih = "";
        //  $mod = $this->fetchSingleRow('sys_menu','nav_act',$nav);
        if ($nav != '') {
            $menu = $this->query(
                "select * from sys_menu where url=?", array(
                'url' => $nav
                )
            );

            foreach ($menu as $men) {

                $id_group[] = $group_id;
                if ($men->parent != 0) {
                    $data = $this->fetchSingleRow('sys_menu', 'id', $men->parent);


                    if ($group_id == $men->parent || $data->parent == $group_id) {



                        $pilih = 'active';
                    } else {
                        $pilih = "";
                    }

                } else {
                    $data = $this->fetchSingleRow('sys_menu', 'id', $men->parent);


                    if ($group_id == $men->parent) {


                        $pilih = 'active';
                    } else {
                        $pilih = "";
                    }
                }



            }
        }



        return $pilih;
    }
    // Menu builder function, parentId 0 is the root
    function buildMenu($url, $parent, $menu)
    {
        $html = "";
        if (isset($menu['parents'][$parent])) {
            foreach ($menu['parents'][$parent] as $itemId) {

                if (!isset($menu['parents'][$itemId])) {
                    if ($menu['items'][$itemId]['type_menu'] == 'separator') {
                        $html .= "<li class='header'>" . ucwords($menu['items'][$itemId]['page_name']) . "</li>";
                    } else {
                        $html .= "<li ";
                        $html .= ($url == $menu['items'][$itemId]['url']) ? 'class="active"' : '';
                        $html .= ">
                     <a href='" . base_index() . $menu['items'][$itemId]['url'] . "'>";
                        if ($menu['items'][$itemId]['icon'] != '') {
                            $html .= "<i class='fa " . $menu['items'][$itemId]['icon'] . "'></i>";
                        } else {
                            $html .= "<i class='fa fa-square'></i>";
                        }
                        $html .= ucwords($menu['items'][$itemId]['page_name']) . "</a></li>";
                    }

                }

                if (isset($menu['parents'][$itemId])) {



                    $html .= "<li class='treeview " . $this->terpilih($url, $menu['items'][$itemId]['id']);

                    $html .= "'><a href='#'>";
                    if ($menu['items'][$itemId]['icon'] != '') {
                        $html .= "<i class='fa " . $menu['items'][$itemId]['icon'] . "'></i>";
                    } else {
                        $html .= "<i class='fa fa-square'></i>";
                    }
                    $html .= "<span>" . ucwords($menu['items'][$itemId]['page_name']) . "</span>
                                    <i class='fa fa-angle-left pull-right'></i>
                                </a>";
                    $html .= "<ul class='treeview-menu'>";
                    $html .= $this->buildMenu($url, $itemId, $menu);
                    $html .= "</ul></li>";
                }
            }

        }
        return $html;
    }

    public function createMenu()
    {
        // Select all entries from the menu table
        $result=$this->query(
            "select sys_menu.*,sys_menu_role.read_act,sys_menu_role.insert_act,sys_menu_role.update_act,sys_menu_role.delete_act,sys_menu_role.group_level from sys_menu
        left join sys_menu_role on sys_menu.id=sys_menu_role.id_menu
        where sys_menu_role.group_level=? and sys_menu_role.read_act=? and tampil=? and hide=? ORDER BY parent, urutan_menu asc",
            array(
            'sys_menu_role.group_level'=>$_SESSION['group_level'],
            'sys_menu_role.read_act'=>'Y',
            'tampil'=>'Y',
            'hide' => 'N'
            )
        );


        // Create a multidimensional array to list items and parents
        $menu = array(
            'items' => array(),
            'parents' => array()
        );
        // Builds the array lists with data from the menu table
        foreach ($result as $items) {

            $items = $this->converObjToArray($items);

              // Creates entry into items array with current menu item id ie.
            $menu['items'][$items['id']] = $items;
            // Creates entry into parents array. Parents array contains a list of all items with children
            $menu['parents'][$items['parent']][] = $items['id'];
        }
        return $this->buildMenu(uri_segment(0), 0, $menu);
    }

    //obj to array
    function converObjToArray($obj)
    {
        if (is_object($obj)) {
            $obj = (array) $obj;
        }
        if (is_array($obj)) {
            $new = array();
            foreach ($obj as $key => $val) {
                $new[$key] = $this->converObjToArray($val);
            }
        } else {
            $new = $obj;
        }

        return $new;
    }


    //search function
    public function getRawWhereFilterForColumns($filter, $search_columns)
    {
        $filter           = addslashes($filter);
        $search_terms     = explode(' ', $filter);
        $search_condition = "";

        for ($i = 0; $i < count($search_terms); $i++) {
            $term = $search_terms[$i];

            for ($j = 0; $j < count($search_columns); $j++) {
                if ($j == 0) {
                    $search_condition .= "(";
                }
                $search_field_name = $search_columns[$j];
                $search_condition .= "$search_field_name LIKE '%" . $term . "%'";
                if ($j + 1 < count($search_columns)) {
                    $search_condition .= " OR ";
                }
                if ($j + 1 == count($search_columns)) {
                    $search_condition .= ")";
                }
            }
            if ($i + 1 < count($search_terms)) {
                $search_condition .= " AND ";
            }
        }
        return $search_condition;
    }


    /**
     * upload image if image width more than 1200 then upload and compress to 1200, otherwise just upload it
     *
     * @param  [type] $ext               [description]
     * @param  [type] $uploadedfile      [description]
     * @param  [type] $path              [description]
     * @param  [type] $actual_image_name [description]
     * @return [type]                    [description]
     */
    public function uploadImageCustom($ext, $uploadedfile, $path, $actual_image_name)
    {
        $image_size = getimagesize($uploadedfile);
        if ($image_size[0] >= 1200) {
            $this->compressImage($ext, $uploadedfile, $path, $actual_image_name, 1200);
        } else {
            $file = $uploadedfile;
            $path = $path . $actual_image_name;
            copy($uploadedfile, $path);
        }

    }

    public function uploadFile($uploadedfile, $path, $actual_image_name)
    {
        $file = $uploadedfile;
        $path = $path . $actual_image_name;
        copy($uploadedfile, $path);
    }


    function compressImage($ext, $uploadedfile, $path, $actual_image_name, $newwidth, $tinggi = null)
    {



        if ($ext == "image/jpeg" || $ext == "image/jpg") {

            $src = imagecreatefromjpeg($uploadedfile);
        } else if ($ext == "image/png") {
            $src = @imagecreatefrompng($uploadedfile);
        } else if ($ext == "image/gif") {
            $src = imagecreatefromgif($uploadedfile);
        } else {

            $src = imagecreatefrombmp($uploadedfile);
        }

        list($width, $height) = getimagesize($uploadedfile);
        if ($tinggi != null) {
            $newheight = $tinggi;
        } else {
            $newheight = ($height / $width) * $newwidth;
        }

        $tmp = imagecreatetruecolor($newwidth, $newheight);
        imagecopyresampled($tmp, $src, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
        $filename = $path . $actual_image_name; //PixelSize_TimeStamp.jpg
        imagejpeg($tmp, $filename, 100);
        imagedestroy($tmp);
        return $filename;
    }

    function getDir($dir)
    {
        $modul_dir = explode(DIRECTORY_SEPARATOR, $dir);
        array_pop($modul_dir);
        array_pop($modul_dir);

        $modul_dir = implode(DIRECTORY_SEPARATOR, $modul_dir);
        return $modul_dir . DIRECTORY_SEPARATOR . "modul" . DIRECTORY_SEPARATOR;
    }



    /**
     * get uniqure name from filename
     *
     * @param  string $file_name filename
     * @return string            new unique filename
     */
    public function uniqueName($file_name)
    {
        $filename = $file_name;
        $filename = preg_replace("#[^a-z.0-9]#i", "", $filename);
        $ex       = explode(".", $filename); // split filename
        $fileExt  = end($ex); // ekstensi akhir
        $filename = time() . rand() . "." . $fileExt; //rename nama file';
        return $filename;
    }

    function addDir($name)
    {
        $name = str_replace("\\", "/", $name);
        $fr   = "\x50\x4b\x03\x04";
        $fr .= "\x0a\x00";
        $fr .= "\x00\x00";
        $fr .= "\x00\x00";
        $fr .= "\x00\x00\x00\x00";
        $fr .= pack("V", 0);
        $fr .= pack("V", 0);
        $fr .= pack("V", 0);
        $fr .= pack("v", strlen($name));
        $fr .= pack("v", 0);
        $fr .= $name;
        /*    $fr .= pack("V",$crc);
        $fr .= pack("V",$c_len);
        $fr .= pack("V",$unc_len);*/
        $this->datasec[] = $fr;
        $new_offset      = strlen(implode("", $this->datasec));
        $cdrec           = "\x50\x4b\x01\x02";
        $cdrec .= "\x00\x00";
        $cdrec .= "\x0a\x00";
        $cdrec .= "\x00\x00";
        $cdrec .= "\x00\x00";
        $cdrec .= "\x00\x00\x00\x00";
        $cdrec .= pack("V", 0);
        $cdrec .= pack("V", 0);
        $cdrec .= pack("V", 0);
        $cdrec .= pack("v", strlen($name));
        $cdrec .= pack("v", 0);
        $cdrec .= pack("v", 0);
        $cdrec .= pack("v", 0);
        $cdrec .= pack("v", 0);
        $ext = "\x00\x00\x10\x00";
        $ext = "\xff\xff\xff\xff";
        $cdrec .= pack("V", 16);
        $cdrec .= pack("V", $this->old_offset);
        $this->old_offset = $new_offset;
        $cdrec .= $name;
        $this->ctrl_dir[] = $cdrec;
    }
    function addFile($data, $name)
    {
        $name = str_replace("\\", "/", $name);
        $fr   = "\x50\x4b\x03\x04";
        $fr .= "\x14\x00";
        $fr .= "\x00\x00";
        $fr .= "\x08\x00";
        $fr .= "\x00\x00\x00\x00";
        $unc_len = strlen($data);
        $crc     = crc32($data);
        $zdata   = gzcompress($data);
        $zdata   = substr(substr($zdata, 0, strlen($zdata) - 4), 2);
        $c_len   = strlen($zdata);
        $fr .= pack("V", $crc);
        $fr .= pack("V", $c_len);
        $fr .= pack("V", $unc_len);
        $fr .= pack("v", strlen($name));
        $fr .= pack("v", 0);
        $fr .= $name;
        $fr .= $zdata;
        $fr .= pack("V", $crc);
        $fr .= pack("V", $c_len);
        $fr .= pack("V", $unc_len);
        $this->datasec[] = $fr;
        $new_offset      = strlen(implode("", $this->datasec));
        $cdrec           = "\x50\x4b\x01\x02";
        $cdrec .= "\x00\x00";
        $cdrec .= "\x14\x00";
        $cdrec .= "\x00\x00";
        $cdrec .= "\x08\x00";
        $cdrec .= "\x00\x00\x00\x00";
        $cdrec .= pack("V", $crc);
        $cdrec .= pack("V", $c_len);
        $cdrec .= pack("V", $unc_len);
        $cdrec .= pack("v", strlen($name));
        $cdrec .= pack("v", 0);
        $cdrec .= pack("v", 0);
        $cdrec .= pack("v", 0);
        $cdrec .= pack("v", 0);
        $cdrec .= pack("V", 32);
        $cdrec .= pack("V", $this->old_offset);
        $this->old_offset = $new_offset;
        $cdrec .= $name;
        $this->ctrl_dir[] = $cdrec;
    }
    function file()
    {
        $data    = implode("", $this->datasec);
        $ctrldir = implode("", $this->ctrl_dir);
        return $data . $ctrldir . $this->eof_ctrl_dir . pack("v", sizeof($this->ctrl_dir)) . pack("v", sizeof($this->ctrl_dir)) . pack("V", strlen($ctrldir)) . pack("V", strlen($data)) . "\x00\x00";
    }

    function getFilesFromFolder($directory, $put_into)
    {
        $sp = DIRECTORY_SEPARATOR;
        if ($handle = opendir($directory)) {
            while (false !== ($file = readdir($handle))) {
                if (is_file($directory . $file)) {
                    $fileContents = file_get_contents($directory . $file);
                    $this->addFile($fileContents, $put_into . $file);
                } elseif ($file != '.' && $file != '..' && is_dir($directory . $file)) {
                    $this->addDir($put_into . $file . $sp);
                    $this->getFilesFromFolder($directory . $file . $sp, $put_into . $file . $sp);
                }
            }
        }
        closedir($handle);
    }
    function downloadfolder($fd, $str_data, $put_into)
    {
        $this->getFilesFromFolder($fd, $put_into . '/');
        $this->addFile($str_data, "write.php");
        header("Content-Disposition: attachment; filename=" . $this->cs(basename($fd)) . ".zip");
        header("Content-Type: application/zip");
        header("Content-Length: " . strlen($this->file()));
        flush();
        echo $this->file();
        exit();
    }


    function getDirExcel($dir)
    {
        $modul_dir = explode(DIRECTORY_SEPARATOR, $dir);
        array_pop($modul_dir);
        array_pop($modul_dir);

        $modul_dir = implode(DIRECTORY_SEPARATOR, $modul_dir);
        return $modul_dir . DIRECTORY_SEPARATOR . "modul" . DIRECTORY_SEPARATOR . "excel" . DIRECTORY_SEPARATOR . 'result' . DIRECTORY_SEPARATOR;
    }

    function downloadfolderExcel($fd, $str_data, $put_into)
    {
        $this->getFilesFromFolder($fd, 'template/');
        foreach ($str_data as $str => $value) {
            $this->addFile($str, $value);

        }

        header("Content-Disposition: attachment; filename=" . $this->cs(basename($put_into)) . ".zip");
        header("Content-Type: application/zip");
        header("Content-Length: " . strlen($this->file()));
        flush();
        echo $this->file();
        unlink($fd . $put_into . '.xlsx');
        exit();
    }
    function cs($t)
    {
        return str_replace(" ", "_", $t);
    }

    public function urlAccess($url)
    {
        $check_access = $this->fetchCustomSingle(
            "select sys_menu.url from sys_menu inner join sys_menu_role on sys_menu.id=sys_menu_role.id_menu
    where sys_menu_role.group_level=? and sys_menu_role.read_act=?", array(
            'group_level' => $_SESSION['group_level'],
            'read_act' => 'Y',
            'url' => $url
            )
        );
        if ($check_access) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * what can user do, if you call this function from modal, you have to prepare $url param
     *
     * @param  [type] $role_act
     * @param  string $url
     * @return void
     */
    public function userCan($role_act,$url="")
    {

        $array_act = array(
            'read' => 'read_act',
            'insert' => 'insert_act',
            'update' => 'update_act',
            'delete' => 'delete_act',
            'import' => 'import_act'
        );
        if($url!="") {
            $url = $url;
        } else {
            $url = uri_segment(0);
        }

        $check_access = $this->fetchCustomSingle(
            "select read_act,insert_act,update_act,delete_act,sys_menu.url from sys_menu inner join sys_menu_role on sys_menu.id=sys_menu_role.id_menu
        where hide='N' and sys_menu_role.group_level=? and $array_act[$role_act]=? and url=?", array(
            'group_level' => $_SESSION['group_level'],
            "$array_act[$role_act]" => 'Y',
            'url' => $url
            )
        );
        if ($check_access) {
            return true;
        } else {
            return false;
        }
    }
    public function roleUserMenu()
    {
        //simpan role url page user di array sesuai login session level
        $role_user=array();
        foreach ($this->query(
            "select sys_menu.url from sys_menu inner join sys_menu_role on sys_menu.id=sys_menu_role.id_menu
          where hide='N' and sys_menu_role.group_level=? and sys_menu_role.read_act=?", array('sys_menu_role.group_level'=>$_SESSION['group_level'],'sys_menu_role.read_act'=>'Y')
        ) as $role) {
            $role_user[]=$role->url;
        }
        return $role_user;
    }

    public function __destruct()
    {
        $this->pdo = null;
    }


    /** Coprime Internal Methods */
    /** GENERAL METHODS */
    public function insertUpdateRecordByFilter($table,$columnID,$columnFilter,$valueFilter,$editArray,$addArray,$verbalTable=''){
        $object = null;
        $errorCode = null;
        $errorStatus = null;
        $errorMessage = null;

        if(strlen($verbalTable) == 0){$verbalTable = rtrim($table,'s');}

        if($this->checkExist($table,array($columnFilter=>$valueFilter))) {

            $errorMessage .= "[".date('Y-m-d H:i:s')."] ";

            $id = $this->converObjToArray($this->getData())[$columnID];
            if($id > 0) {
                if ($this->update($table, $editArray, $columnID, $id)) {
                    $errorCode = 0;
                    $errorStatus = "OK";
                    $errorMessage .= "Update $verbalTable $valueFilter [$id]";
                } else {
                    $errorCode = 1;
                    $errorStatus = "ERROR";
                    $errorMessage .= $this->getErrorMessage();
                }
                $object = $this->getData();
            } else {
                $errorCode = 1;
                $errorStatus = "ERROR";
                $errorMessage .= " error Update $verbalTable $valueFilter Empty ID [$id]";
                $object = $this->getData();
            }
        } else {

            $errorMessage .= "[".date('Y-m-d H:i:s')."] ";
            if(strcmp($valueFilter,'')!=0) {
                $id = $this->getNextInsertID($table, $columnID);
                if($id > 0) {
                    $addArray[$columnID] = $id;
                    if ($this->insert($table, $addArray)) {
                        $errorCode = 0;
                        $errorStatus = "OK";
                        $errorMessage .= "Insert $verbalTable $valueFilter [$id]";



                        if ($this->checkExist($table, array($columnFilter => $valueFilter))) {
                            $object = $this->getData();
                        } else {
                            $errorCode = 1;
                            $errorStatus = "ERROR";
                            $errorMessage .= " error $verbalTable Insert Fail ";
                        }
                    } else {
                        $errorCode = 1;
                        $errorStatus = "ERROR";
                        $errorMessage .= $this->getErrorMessage();
                    }
                } else {
                    $errorCode = 1;
                    $errorStatus = "ERROR";
                    $errorMessage .= " error getNextInsertID($table, $columnID) Failed [id=$id] ";
                }
            } else {
                $errorCode = 2;
                $errorStatus = "NOTICE";
                $errorMessage .= "Insert $verbalTable [Empty ".ucwords(str_replace('_',' ',$columnFilter))."] No Record Added";
            }


        }

        $result['response']['code']=$errorCode;
        $result['response']['status']=$errorStatus;
        $result['response']['message']=$errorMessage;
        $result['data']=$object;

        return $result;

    }

    public function insertRecordByFilter($table,$columnID,$columnFilter,$valueFilter,$addArray,$verbalTable=''){
        $object = null;
        $errorCode = null;
        $errorStatus = null;
        $errorMessage = null;

        if(strlen($verbalTable) == 0){$verbalTable = rtrim($table,'s');}

        $errorMessage .= "[".date('Y-m-d H:i:s')."] ";


        if(strcmp($valueFilter,'')!=0) {
            $id = $this->getNextInsertID($table, $columnID);
            if($id > 0) {
                $addArray[$columnID] = $id;
                if ($this->insert($table, $addArray)) {
                        $errorCode = 0;
                        $errorStatus = "OK";
                        $errorMessage .= "Insert $verbalTable $valueFilter [$id]";



                        if ($this->checkExist($table, array($columnFilter => $valueFilter))) {
                            $object = $this->getData();
                        } else {
                            $errorCode = 1;
                            $errorStatus = "ERROR";
                            $errorMessage .= " error $verbalTable Insert Fail ";
                        }
                    } else {
                        $errorCode = 1;
                        $errorStatus = "ERROR";
                        $errorMessage .= $this->getErrorMessage();
                    }
            } else {
                    $errorCode = 1;
                    $errorStatus = "ERROR";
                    $errorMessage .= " error getNextInsertID($table, $columnID) Failed [id=$id] ";
                }
        } else {
           $errorCode = 2;
           $errorStatus = "NOTICE";
           $errorMessage .= "Insert $verbalTable [Empty ".ucwords(str_replace('_',' ',$columnFilter))."] No Record Added";
        }

        $result['response']['code']=$errorCode;
        $result['response']['status']=$errorStatus;
        $result['response']['message']=$errorMessage;
        $result['data']=$object;

        return $result;

    }

    public function insertUpdateRecordByObject($table,$columnID,$columnFilter,$object,$excludeUpdateColumns=array(),$verbalTable=''){

        $response = null;
        if(strlen($verbalTable) == 0){$verbalTable = rtrim($table,'s');}

        $addArray  = $this->mapArrayToObject("$table",$object);
        $editArray = $this->excludeUpdateColumnsOfArray("$table",$addArray,$excludeUpdateColumns);

        if(!empty($addArray)) {

            $query = $this->insertUpdateRecordByFilter("$table", "$columnID", "$columnFilter", $addArray["$columnFilter"], $editArray, $addArray, "$verbalTable");

            $response["$table"] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

        } else {
            $response["$table"] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [$table]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }



        return $response;
    }

    public function insertRecordByObject($table,$columnID,$columnFilter,$object,$verbalTable=''){

        $response = null;
        if(strlen($verbalTable) == 0){$verbalTable = rtrim($table,'s');}

        $addArray  = $this->mapArrayToObject("$table",$object);
        if(!empty($addArray)) {

            $query = $this->insertRecordByFilter("$table", "$columnID", "$columnFilter", $addArray["$columnFilter"], $addArray, "$verbalTable");

            $response["$table"] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

        } else {
            $response["$table"] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [$table]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }



        return $response;
    }

    public function insertUpdateLinkedTable($table, $insertColumnValues, $updateColumnValues, $idColumnValues,$verbalTable=''){

        $object = null;
        $errorCode = null;
        $errorStatus = null;
        $errorMessage = null;

        if(strlen($verbalTable) == 0){$verbalTable = rtrim($table,'s');}

        if ($insertColumnValues !== null) {
            $data = array_values($insertColumnValues);
        }
        if ($idColumnValues !== null) {
            $idData = array_values($idColumnValues);

            foreach ($idColumnValues as $idColumn => $idValue){
                if($idValue > 0 || strcmp(trim($idValue),'')!=0){

                } else {
                    $result['response']['code']=1;
                    $result['response']['status']="ERROR";
                    $result['response']['message']= "[".date('Y-m-d H:i:s')."] error Missing ID [$idColumn = $idValue]";
                    $result['data']=null;
                    return $result;
                }
            }

        } else {
            $result['response']['code']=1;
            $result['response']['status']="ERROR";
            $result['response']['message']= "[".date('Y-m-d H:i:s')."] Missing $idColumnValues Variable";
            $result['data']=null;
            return $result;
        }
        //grab keys
        $cols = array_keys($insertColumnValues);
        $idCols = array_keys($idColumnValues);
        $updateCols = array_keys($updateColumnValues);

        foreach ($cols as $col) {
            $mark[] = $col . "=?";
            $insMark[] = "?";
        }

        foreach ($idCols as $idCol) {
            $idMark[] = $idCol . "=?";
            $insMark[] = "?";
            $messageMark[] = $idCol . "=" . $idColumnValues[$idCol];
        }

        foreach ($updateCols as $updateCol) {
            $updateMark[] = $updateCol . "=?";
        }

        $im  = implode(', ', $mark);
        $idIm  = implode(' AND ', $idMark);
        $insIm = implode(', ', $insMark);
        $updateIm = implode(', ', $updateMark);
        $messageIm = implode(' AND ', $messageMark);


        if($this->checkExist($table,$idColumnValues)) {

            $errorMessage .= "[".date('Y-m-d H:i:s')."] ";
            $errorMessage .= "Update $verbalTable [$messageIm]";

            $data = array_merge(array_values($updateColumnValues),array_values($idColumnValues));
            $ins = $this->pdo->prepare("UPDATE $table SET $updateIm WHERE $idIm");

        } else {

            $errorMessage .= "[".date('Y-m-d H:i:s')."] ";
            $errorMessage .= "Insert $verbalTable [$messageIm]";

            $columns = array_merge($idCols, $cols);
            $data = array_merge($idData,$data);
            $insertColumns = implode(', ', $columns);

            $ins = $this->pdo->prepare("INSERT INTO $table ($insertColumns) values ($insIm)");
        }

        try {
            $ins->execute($data);

            $result['response']['code']=0;
            $result['response']['status']="OK";
            $result['response']['message']=$errorMessage;
            $result['data']=$this->getData();
            $this->addAffectedRecord();

            return $result;
        }
        catch (PDOException $exception) {
            $this->setErrorMessage($exception->getMessage());

            $result['response']['code']=1;
            $result['response']['status']="ERROR";
            $result['response']['message']=$exception->getMessage();
            $result['data']=null;


            return $result;
        }

    }

    public function deleteRecordByID($table,$columnID,$fieldID,$insertDeleteStatement = false,$verbalTable = ''){
        $errorCode = null;
        $errorStatus = null;
        $errorMessage = null;

        if($fieldID > 0) {
            if ($this->delete($table, $columnID, $fieldID)) {

                if (strlen($verbalTable) == 0) {$verbalTable = rtrim($table, 's');}
                $errorMessage .= "[" . date('Y-m-d H:i:s') . "] ";
                $errorMessage .= "Delete $verbalTable ";
                $errorCode =0;

                if ($insertDeleteStatement) {
                    if ($this->insert('Deletes', array('statement' => "DELETE FROM $table WHERE $columnID=$fieldID"))) {
                        $this->removeAffectedRecord();
                        $this->addDeleteStatementRecord();
                        $errorMessage .= "(Insert Delete Statement For APP)";
                        $errorCode =0;
                        $errorStatus = "OK";
                    } else {
                        $errorMessage .= "\n[" . date('Y-m-d H:i:s') . "] ";
                        $errorMessage .= $this->getErrorMessage();
                        $errorCode =1;
                        $errorStatus = "ERROR";
                    }
                }

            } else {
                $errorMessage .= "[" . date('Y-m-d H:i:s') . "] ";
                $errorMessage .= $this->getErrorMessage();
                $errorCode =1;
            }
        } else {
            $errorCode =1;
            $errorStatus = "ERROR";
            $errorMessage .= "[" . date('Y-m-d H:i:s') . "] error Delete $verbalTable [Missing ID] ";
        }

        $result['response']['code']=$errorCode;
        $result['response']['status']=$errorStatus;
        $result['response']['message']=$errorMessage;

        return $result;
    }

    public function deleteRecordByMultipleIDs($table,$idColumnsValues,$insertDeleteStatement = false,$verbalTable = ''){
        $errorCode = null;
        $errorStatus = null;
        $errorMessage = null;
        $deleteStatementWhere = array();



        foreach ($idColumnsValues as $column => $value){
            $deleteStatementWhere[] = "$column = '$value'";

        }
        $deleteStatementWhereIm = implode(' AND ',$deleteStatementWhere);


        if(!empty($idColumnsValues) && strcmp($deleteStatementWhereIm,'')!=0) {
            if ($this->deleteFromLinkedTable($table, $idColumnsValues)) {
                if (strlen($verbalTable) == 0) {$verbalTable = rtrim($table, 's');}
                $errorMessage .= "[" . date('Y-m-d H:i:s') . "] ";
                $errorMessage .= "Delete $verbalTable ";
                $errorCode =0;

                if ($insertDeleteStatement) {
                    if ($this->insert('Deletes', array('statement' => "DELETE FROM $table WHERE $deleteStatementWhereIm"))) {
                        $this->removeAffectedRecord();
                        $this->addDeleteStatementRecord();
                        $errorMessage .= "(Insert Delete Statement For APP)";
                        $errorCode =0;
                        $errorStatus = "OK";
                    } else {
                        $errorMessage .= "\n[" . date('Y-m-d H:i:s') . "] ";
                        $errorMessage .= $this->getErrorMessage();
                        $errorCode =1;
                        $errorStatus = "ERROR";
                    }
                }

            } else {
                $errorMessage .= "[" . date('Y-m-d H:i:s') . "] ";
                $errorMessage .= $this->getErrorMessage();
                $errorCode =1;
            }
        } else {
            $errorCode =1;
            $errorStatus = "ERROR";
            $errorMessage .= "[" . date('Y-m-d H:i:s') . "] error Delete $verbalTable [Missing IDs] ";
        }

        $result['response']['code']=$errorCode;
        $result['response']['status']=$errorStatus;
        $result['response']['message']=$errorMessage;

        return $result;
    }

    public function displayObject($object){
        echo "<pre>";
        var_dump($object);
        echo "</pre>";
    }

    public Function compactQuery($table,$filterColumn,$filterValue,$selectFields='*'){
        $objectsArray = array();
        $query=$this->query("SELECT $selectFields FROM $table WHERE $filterColumn=?",array($filterValue));
        foreach ($query as $object) {
            array_push($objectsArray,$object);
        }
        return $objectsArray;
    }

    public Function compactQueryMultipleFilters($table,$filterColumnsValues,$selectFields='*'){
        $objectsArray = array();

        $data  = array_values($filterColumnsValues);
        $cols  = array_keys($filterColumnsValues);

        foreach ($cols as $col){
            $mark[] = $col . '=?';
        }

        $im = implode(' AND ',$mark);

        $query=$this->query("SELECT $selectFields FROM $table WHERE $im",$data);
        foreach ($query as $object) {
            array_push($objectsArray,$object);
        }
        return $objectsArray;
    }

    public function excludeUpdateColumnsOfArray($table,$completeArray,$filtersArray){
        if(isset($filtersArray[$table])) {
            foreach ($filtersArray[$table] as $excludeField) {
                unset($completeArray[$excludeField]);
            }
        }
        return $completeArray;
    }

    public function hashObject($object){
        return hash('sha256',json_encode($object));
    }

    public function convertImageFromPngToJpg($rootDir,$imageName){
        $image = imagecreatefrompng("$rootDir/$imageName.png");
        imagejpeg($image, "$rootDir/$imageName.jpg", 70);
        imagedestroy($image);
    }

    public function fetchNested($table,$selectField,$filerField,$in,$nestedTable,$nestedID,$nestedField,$nestedValue,$extraWhere='')
    {


        try {
            $sel = $this->pdo->prepare("SELECT $selectField FROM $table WHERE $filerField $in (SELECT $nestedID FROM $nestedTable WHERE $nestedField = ?) AND timestamp <= NOW() - INTERVAL 1 MINUTE $extraWhere");
            $sel->execute(array($nestedValue));
            $sel->setFetchMode(PDO::FETCH_OBJ);
            $obj = $sel->fetchAll();
            return $obj;
        }
        catch (PDOException $exception) {
            $this->setErrorMessage($exception->getMessage());
            echo $this->getErrorMessage();
            exit();
        }

    }

    /** Coprime Internal Getters */
    /** ID GETTERS */
    public function getItemObjectByID($id){
        $object = $this->fetchSingleRow('Items', 'item_id', $id);

        $item = new Item(
            $itemID           = "$object->item_id",
            $itemCode         = "$object->item_code",
            $itemSKU          = "$object->item_sku",
            $companyID        = "$object->company_id",
            $vatID            = "$object->vat_id",
            $subunits         = "$object->subunits",
            $salesUnits       = "$object->sales_units",
            $manufacturerID   = "$object->manufacturer_id",
            $name             = "$object->name",
            $shortDescription = "$object->short_description",
            $longDescription  = "$object->long_description",
            $thumbnailUrl     = "$object->thumbnail_url",
            $reorderLevel     = "$object->reorder_level",
            $targetQty        = "$object->target_qty",
            $bundle           = "$object->bundled",
            $maxStock         = "$object->max_stock",
            $minStock         = "$object->min_stock",
            $packing          = "$object->packing",
            $stockControl     = "$object->stock_control",
            $sellable         = "$object->sellable",
            $weight           = "$object->weight",
            $cbm              = "$object->cbm",
            $status           = "$object->status"
        );

        return $item;
    }

    public function getWarehouseObjectByID($id){
        $object = $this->fetchSingleRow('Warehouses', 'warehouse_id', $id);

        $warehouse = new Warehouse(
            $warehouseID = "$object->warehouse_id",
            $warehouseCode = "$object->warehouse_code",
            $companyID = "$object->company_id",
            $name = "$object->name",
            $type = "$object->type",
            $landline = "$object->landline",
            $fax = "$object->fax",
            $email = "$object->email",
            $country = "$object->country",
            $city = "$object->city",
            $addressLine1 = "$object->address_line_1",
            $addressLine2 = "$object->address_line_2",
            $postcode = "$object->postcode",
            $region = "$object->region",
            $lat = "$object->lat",
            $lng = "$object->lng",
            $pobox = "$object->pobox",
            $salespersonID = "$object->salesperson_id"
        );

        return $warehouse;
    }

    public function getPriceTypeObjectByID($id){
        $object = $this->fetchSingleRow('PriceTypes', 'pricetype_id', $id);

        $priceType = new PriceType(
            $priceTypeID   = "$object->pricetype_id",
            $priceCode     = "$object->price_code",
            $name          = "$object->name",
            $allowDiscount = "$object->allow_discount",
            $defaultType   = "$object->default_type"
        );

        return $priceType;
    }

    public function getCustomerObjectByID($id){
        $object = $this->fetchSingleRow('Customers', 'customer_id', $id);

        $customer = new Customer(
            $customerID          = "$object->customer_id",
            $customerCode        = "$object->customer_code",
            $companyName         = "$object->customer_company_name",
            $reportName          = "$object->customer_report_name",
            $logo                = "$object->logo",
            $registrationCode    = "$object->registration_code",
            $mobile              = "$object->mobile",
            $website             = "$object->website",
            $email               = "$object->email",
            $description         = "$object->description",
            $typeOfBusiness      = "$object->type_of_business",
            $ticCode             = "$object->tic_code",
            $vatCode             = "$object->vat_code",
            $creditLimit         = "$object->credit_limit",
            $typeOfCustomer      = "$object->customer_type",
            $balance             = "$object->balance",
            $addressCodeEurosoft = "$object->address_code_eurosoft"
        );

        return $customer;
    }

    public function getCustomerPriceListObjectByCustomerID($id){
        $object = $this->fetchSingleRow('Customer_Pricelist', 'customer_id', $id);

        if($object->pricetype_id > 0){
            return $this->getPriceTypeObjectByID($object->pricetype_id);
        } else {
            return $this->getDefaultPriceTypeObject();
        }


    }

    public function getAddressObjectByCustomerID($id){
        if($this->checkExist('CustomerAddress',array('customer_id'=>$id ,'primary_address'=>'yes'))){
            $object = $this->getData();
        } else {
            $object = $this->fetchSingleRow('CustomerAddress', 'customer_id', $id);
        }

        $address = new CustomerAddress(
            $addressID      = "$object->customer_address_id",
            $addressCode    = "$object->address_code",
            $customerID     = "$object->customer_id",
            $country        = "$object->country",
            $city           = "$object->city",
            $addressLine1   = "$object->address_line_1",
            $addressLine2   = "$object->address_line_2",
            $postcode       = "$object->postcode",
            $region         = "$object->region",
            $lat            = "$object->lat",
            $lng            = "$object->lng",
            $pobox          = "$object->pobox",
            $landline       = "$object->landline",
            $fax            = "$object->fax",
            $primaryAddress = "$object->primary_address"
        );

        return $address;
    }

    public function getVatObjectByID($id){
        $object = $this->fetchSingleRow('Vats', 'vat_id', $id);

        $vat = new Vat(
            $vatID = "$object->vat_id",
            $vatCode = "$object->vat_code",
            $vatDisplayName = "$object->vat_display_name",
            $percentage = "$object->percentage"
        );

        return $vat;
    }

    public function getCategoryObjectByID($id){
        $object = $this->fetchSingleRow('Categories', 'category_id', $id);

        $category = new Category(
            $categoryID = "$object->category_id",
            $categoryCode = "$object->category_code",
            $categoryName = "$object->name",
            $description = "$object->description",
            $creationDate = "$object->creation_date",
            $allowSubcategories = "$object->allow_subcategories",
            $allowItems = "$object->allow_items",
            $level = "$object->level",
            $customOrder = "$object->custom_order"
        );

        return $category;
    }

    public function getBankObjectByID($id){
        $object = $this->fetchSingleRow('Banks', 'bank_id', $id);

        $bank = new Bank(
            $bankID = "$object->bank_id",
            $bankCode = "$object->code",
            $name = "$object->name",
            $status = "$object->status"
        );

        return $bank;
    }

    public function getPaymentTypeObjectByID($id){
        $object = $this->fetchSingleRow('PaymentTypes', 'paymenttype_id', $id);

        $paymentType = new PaymentType(
            $paymentTypeID = "$object->paymenttype_id",
            $paymentTypeCode = "$object->paymenttype_code",
            $name = "$object->name"
        );

        return $paymentType;
    }

    public function getServiceCallObjectByID($id,$includeReplies=true){
        $object = $this->fetchSingleRow('Service_Calls', 'service_call_id', $id);

        $serviceCall = new ServiceCall(
            $serviceCallID      = "$object->service_call_id",
            $serviceCallCode    = "$object->service_call_code",
            $salespersonID      = "$object->salesperson_id",
            $assignTo           = "$object->assign_to",
            $customerID         = "$object->customer_id",
            $customerAddressID  = "$object->customer_address_id",
            $itemID             = "$object->item_id",
            $serialNumberID     = "$object->serial_number_id",
            $sourceID           = "$object->source_id",
            $typeID             = "$object->type_id",
            $statusID           = "$object->status_id",
            $priorityID         = "$object->priority_id",
            $topic              = "$object->topic",
            $details            = "$object->details	",
            $sourceName         = "$object->source_name",
            $sourceDetails      = "$object->source_details",
            $date               = "$object->date",
            $dueDate            = "$object->due_date",
            $scheduleStartDate  = "$object->schedule_start_date",
            $scheduleEndDate    = "$object->schedule_end_date",
            $parentID           = "$object->parent_id",
            $progress           = "$object->progress",
            $assignTo2          = "$object->assign_to_2",
            $actionHash         = "$object->action_hash",
            $actionTime         = "$object->action_time",
            $serviceCallReplies = array()
        );
        if($includeReplies) {
            $items = $this->search('Service_Call_Reply', array('service_call_id' => "$id"));
            foreach ($items as $item) {
                $serviceCall->addReply(
                    new ServiceCallReply(
                        $serviceCallReplyID = "$item->service_call_reply_id",
                        $serviceCallID = "$item->service_call_id",
                        $salesPersonID = "$item->salesperson_id",
                        $statusID = "$item->status_id",
                        $date = "$item->date",
                        $replyTypeID = "$item->reply_type_id",
                        $details = "$item->details",
                        $documentID = "$item->document_id",
                        $documentType = "$item->document_type",
                        $salesPersonTo = "$item->salesperson_to",
                        $emailResponse = "$item->email_response",
                        $priorityID = "$item->priority_id"
                    )
                );
            }
        }
        return $serviceCall;
    }

    public function getTenderObjectByID($id,$includeItems=true){
        $object = $this->fetchSingleRow('Tenders', 'tender_id', $id);

        $tender = new Tender(
            $tenderID           = "$object->tender_id",
            $tenderCode         = "$object->tender_code",
            $companyID          = "$object->company_id",
            $salesPersonID      = "$object->salesperson_id",
            $customerID         = "$object->customer_id",
            $tenderDate         = "$object->tender_date",
            $validUntil         = "$object->valid_until",
            $name               = "$object->name",
            $addressLine1       = "$object->address_line_1",
            $addressLine2       = "$object->address_line_2",
            $city               = "$object->city",
            $country            = "$object->country",
            $region             = "$object->region",
            $subTotal           = "$object->subtotal	",
            $grandTotal         = "$object->grand_total",
            $vatAmount          = "$object->vat_amount",
            $discountAmount     = "$object->discount_amount",
            $status             = "$object->status",
            $vatIorE            = "$object->vat_i_e",
            $printCount         = "$object->print_count",
            $details            = "$object->details",
            $currencyID         = "$object->currency_id",
            $deliveryMethod     = "$object->delivery_method",
            $globalDiscPercent  = "$object->global_discount_percentage",
            $currentVersion     = "$object->current_version",
            $editedBy           = "$object->edited_by",
            $actionHash         = "$object->action_hash",
            $actionTime         = "$object->action_time",
            $orderItems         = array()
        );
        if($includeItems) {
            $items = $this->search('Tender_Item', array('tender_id' => "$id"));
            foreach ($items as $item) {
                $tender->addTenderItem(
                    new TenderItem(
                        $tenderItemID           = "$item->tender_item_id",
                        $tenderID               = "$item->tender_id",
                        $itemID                 = "$item->item_id",
                        $qty                    = "$item->qty",
                        $unitPrice              = "$item->unit_price",
                        $lineDiscount           = "$item->line_discount",
                        $globalDiscount         = "$item->global_discount",
                        $lineDiscountPercentage = "$item->line_discount_percentage",
                        $vatAmount              = "$item->vat_amount",
                        $priceTypeID            = "$item->pricetype_id",
                        $vatID                  = "$item->vat_id",
                        $description            = "$item->description",
                        $promotionID            = "$item->promotion_id",
                        $promotionNumber        = "$item->promotion_number",
                        $masterItem             = "$item->master_item"

                    )
                );
            }
        }
        return $tender;
    }

    public function getOrderObjectByID($id,$includeItems=true){
        $object = $this->fetchSingleRow('Orders', 'order_id', $id);

        $order = new Order(
            $orderID            = "$object->order_id",
            $orderCode          = "$object->order_code",
            $companyID          = "$object->company_id",
            $customerID         = "$object->customer_id",
            $salespersonID      = "$object->salesperson_id",
            $paymentTypeID      = "$object->paymenttype_id",
            $orderDate          = "$object->order_date",
            $subTotal           = "$object->subtotal",
            $grandTotal         = "$object->grand_total",
            $vatAmount          = "$object->vat_amount",
            $discountAmount     = "$object->discount_amount",
            $printCount         = "$object->print_count",
            $orderAddressID     = "$object->order_address_id",
            $deliveryAddressID  = "$object->delivery_address_id	",
            $tenderID           = "$object->tender_id",
            $vatIorE            = "$object->vat_i_or_e",
            $deliveryDate       = "$object->delivery_date",
            $depositAmount      = "$object->deposit_amount",
            $details            = "$object->details",
            $status             = "$object->status",
            $currencyID         = "$object->currency_id",
            $globalDiscPercent  = "$object->global_discount_percentage",
            $deliveryMethod     = "$object->delivery_method",
            $onlineOrderID      = "$object->online_order_id",
            $actionHash         = "$object->action_hash",
            $actionTime         = "$object->action_time",
            $orderItems         = array()
        );
        if($includeItems) {
            $items = $this->search('Order_Item', array('order_id' => "$id"));
            foreach ($items as $item) {
                $order->addOrderItem(
                    new OrderItem(
                        $orderItemID = "$item->order_item_id",
                        $orderID = "$item->order_id",
                        $itemID = "$item->item_id",
                        $qty = "$item->qty",
                        $qtyPicked = "$item->qty_picked",
                        $qtyDelivered = "$item->qty_delivered",
                        $qtyInvoiced = "$item->qty_invoiced",
                        $unitPrice = "$item->unit_price",
                        $lineDiscount = "$item->line_discount",
                        $globalDiscount = "$item->global_discount",
                        $lineDiscountPercentage = "$item->line_discount_percentage",
                        $vatAmount = "$item->vat_amount",
                        $priceTypeID = "$item->pricetype_id",
                        $vatID = "$item->vat_id",
                        $description = "$item->description",
                        $promotionID = "$item->promotion_id",
                        $promotionNumber = "$item->promotion_number",
                        $masterItem = "$item->master_item"
                    )
                );
            }
        }
        return $order;
    }

    public function getWaybillObjectByID($id,$includeItems=true){
        $object = $this->fetchSingleRow('Waybills', 'waybill_id', $id);

        $waybill = new Waybill(
            $waybillID          = "$object->waybill_id",
            $waybillCode        = "$object->waybill_code",
            $companyID          = "$object->company_id",
            $customerID         = "$object->customer_id",
            $salespersonID      = "$object->salesperson_id",
            $paymentTypeID      = "$object->paymenttype_id",
            $orderID            = "$object->order_id",
            $tenderID           = "$object->tender_id",
            $subTotal           = "$object->subtotal",
            $grandTotal         = "$object->grand_total",
            $vatAmount          = "$object->vat_amount",
            $vatIorE            = "$object->vat_i_e",
            $discountAmount     = "$object->discount_amount",
            $waybillAddressID   = "$object->waybill_address_id	",
            $deliveryAddressID  = "$object->delivery_address_id",
            $printCount         = "$object->print_count",
            $waybillDate        = "$object->waybill_date",
            $details            = "$object->details",
            $status             = "$object->status",
            $currencyID         = "$object->currency_id",
            $globalDiscPercent  = "$object->global_discount_percentage",
            $actionHash         = "$object->action_hash",
            $actionTime         = "$object->action_time",
            $waybillItems       = array()
        );
        if($includeItems) {
            $items = $this->search('Waybill_Item', array('waybill_id' => "$id"));
            foreach ($items as $item) {
                $waybill->addWaybillItem(
                    new WaybillItem(
                        $waybillItemID   = "$item->waybill_item_id",
                        $waybillID       = "$item->waybill_id",
                        $itemID          = "$item->item_id",
                        $batchNumber     = "$item->batch_number",
                        $warehouseID     = "$item->warehouse_id",
                        $qty             = "$item->qty",
                        $qtyInvoiced     = "$item->qty_invoiced",
                        $unitPrice       = "$item->unit_price",
                        $lineDiscount    = "$item->line_discount",
                        $globalDiscount  = "$item->global_discount",
                        $lineDiscPercent = "$item->line_discount_percentage",
                        $vatAmount       = "$item->vat_amount",
                        $priceTypeID     = "$item->pricetype_id",
                        $vatID           = "$item->vat_id",
                        $serialNumber    = "$item->serialnumber",
                        $description     = "$item->description",
                        $cost            = "$item->cost"

                    )
                );
            }
        }
        return $waybill;
    }

    public function getInvoiceObjectByID($id,$includeItems=true){
        $object = $this->fetchSingleRow('Invoices', 'invoice_id', $id);

        $invoice = new Invoice(
            $invoiceID         = "$object->invoice_id",
            $invoiceCode       = "$object->invoice_code",
            $companyID         = "$object->company_id",
            $customerID        = "$object->customer_id",
            $salespersonID     = "$object->salesperson_id",
            $paymentTypeID     = "$object->paymenttype_id",
            $orderID           = "$object->order_id",
            $tenderID          = "$object->tender_id",
            $subTotal          = "$object->subtotal",
            $grandTotal        = "$object->grand_total",
            $vatAmount         = "$object->vat_amount",
            $vatIorE           = "$object->vat_i_e",
            $discountAmount    = "$object->discount_amount",
            $invoiceAddressID  = "$object->invoice_address_id",
            $deliveryAddressID = "$object->delivery_address_id",
            $printCount        = "$object->print_count",
            $invoiceDate       = "$object->invoice_date",
            $details           = "$object->details",
            $invoiceType       = "$object->invoice_type",
            $dueDate           = "$object->due_date",
            $status            = "$object->status",
            $currencyID        = "$object->currency_id",
            $globalDiscPercent = "$object->global_discount_percentage",
            $actionHash        = "$object->action_hash",
            $actionTime        = "$object->action_time",
            $invoiceItems      = array()
        );
        if($includeItems) {
            $items = $this->search('Invoice_Item', array('invoice_id' => "$id"));
            foreach ($items as $item) {
                $invoice->addInvoiceItem(
                    new InvoiceItem(
                        $invoiceItemID   = "$item->invoice_item_id",
                        $invoiceID       = "$item->invoice_id",
                        $itemID          = "$item->item_id",
                        $batchNumber     = "$item->batch_number",
                        $warehouseID     = "$item->warehouse_id",
                        $qty             = "$item->qty",
                        $unitPrice       = "$item->unit_price",
                        $lineDiscount    = "$item->line_discount",
                        $globalDiscount  = "$item->global_discount",
                        $lineDiscPercent = "$item->line_discount_percentage",
                        $vatAmount       = "$item->vat_amount",
                        $priceTypeID     = "$item->pricetype_id",
                        $vatID           = "$item->vat_id",
                        $serialNumber    = "$item->serialnumber",
                        $description     = "$item->description",
                        $cost            = "$item->cost",
                        $promotionID     = "$item->promotion_id",
                        $promotionNumber = "$item->promotion_number",
                        $masterItem      = "$item->master_item"

                    )
                );
            }
        }
        return $invoice;
    }

    public function getReturnObjectByID($id,$includeItems=true){
        $object = $this->fetchSingleRow('Returns', 'return_id', $id);

        $return = new SalesReturn(
            $returnID          = "$object->return_id",
            $returnCode        = "$object->return_code",
            $companyID         = "$object->company_id",
            $customerID        = "$object->customer_id",
            $salespersonID     = "$object->salesperson_id",
            $paymentTypeID     = "$object->paymenttype_id",
            $orderID           = "$object->order_id",
            $subTotal          = "$object->subtotal",
            $grandTotal        = "$object->grand_total",
            $vatAmount         = "$object->vat_amount",
            $vatIorE           = "$object->vat_i_e",
            $discountAmount    = "$object->discount_amount",
            $returnAddressID   = "$object->return_address_id",
            $printCount        = "$object->print_count",
            $returnDate        = "$object->return_date",
            $details           = "$object->details",
            $status            = "$object->status",
            $currencyID        = "$object->currency_id",
            $globalDiscPercent = "$object->global_discount_percentage",
            $returnType        = "$object->return_type",
            $actionHash        = "$object->action_hash",
            $actionTime        = "$object->action_time",
            $invoiceItems      = array()
        );
        if($includeItems) {
            $items = $this->search('Return_Item', array('return_id' => "$id"));
            foreach ($items as $item) {
                $return->addReturnItem(
                    new ReturnItem(
                        $invoiceItemID   = "$item->return_item_id",
                        $invoiceID       = "$item->return_id",
                        $itemID          = "$item->item_id",
                        $batchNumber     = "$item->batch_number",
                        $warehouseID     = "$item->warehouse_id",
                        $qty             = "$item->qty",
                        $unitPrice       = "$item->unit_price",
                        $lineDiscount    = "$item->line_discount",
                        $globalDiscount  = "$item->global_discount",
                        $lineDiscPercent = "$item->line_discount_percentage",
                        $vatAmount       = "$item->vat_amount",
                        $priceTypeID     = "$item->pricetype_id",
                        $vatID           = "$item->vat_id",
                        $serialNumber    = "$item->serialnumber",
                        $description     = "$item->description",
                        $status          = "$item->status",
                        $cost            = "$item->cost"
                    )
                );
            }
        }
        return $return;
    }

    public function getReceiptObjectByID($id,$includeItems=true){

        $object = $this->fetchSingleRow('Receipts', 'receipt_id', $id);
        $result = $this->createObjectByDbCall('Receipts',$object,$includeItems);
        return $result;

    }

    public function getWarehouseTransactionObjectByID($id,$includeItems=true){

        $object = $this->fetchSingleRow('Warehouse_Transactions', 'warehouse_transaction_id', $id);
        $result = $this->createObjectByDbCall('Warehouse_Transactions',$object,$includeItems);
        return $result;

    }


    /** CODE GETTERS */
    public function getItemObjectByCode($code){
        $object = $this->fetchSingleRow('Items', 'item_code', $code);

        $item = new Item(
            $itemID           = "$object->item_id",
            $itemCode         = "$object->item_code",
            $itemSKU          = "$object->item_sku",
            $companyID        = "$object->company_id",
            $vatID            = "$object->vat_id",
            $subunits         = "$object->subunits",
            $salesUnits       = "$object->sales_units",
            $manufacturerID   = "$object->manufacturer_id",
            $name             = "$object->name",
            $shortDescription = "$object->short_description",
            $longDescription  = "$object->long_description",
            $thumbnailUrl     = "$object->thumbnail_url",
            $reorderLevel     = "$object->reorder_level",
            $targetQty        = "$object->target_qty",
            $bundle           = "$object->bundled",
            $maxStock         = "$object->max_stock",
            $minStock         = "$object->min_stock",
            $packing          = "$object->packing",
            $stockControl     = "$object->stock_control",
            $sellable         = "$object->sellable",
            $weight           = "$object->weight",
            $cbm              = "$object->cbm",
            $status           = "$object->status"
        );

        return $item;
    }

    public function getPriceTypeObjectByCode($code){
        $object = $this->fetchSingleRow('PriceTypes', 'price_code', $code);

        $priceType = new PriceType(
            $priceTypeID   = "$object->pricetype_id",
            $priceCode     = "$object->price_code",
            $name          = "$object->name",
            $allowDiscount = "$object->allow_discount",
            $defaultType   = "$object->default_type"
        );

        return $priceType;
    }

    public function getDefaultPriceTypeObject(){
        $object = $this->fetchSingleRow('PriceTypes', 'default_type', 'yes');

        $priceType = new PriceType(
            $priceTypeID   = "$object->pricetype_id",
            $priceCode     = "$object->price_code",
            $name          = "$object->name",
            $allowDiscount = "$object->allow_discount",
            $defaultType   = "$object->default_type"
        );

        return $priceType;
    }

    public function getWarehouseObjectByCode($code){
        $object = $this->fetchSingleRow('Warehouses', 'warehouse_code', $code);

        $warehouse = new Warehouse(
            $warehouseID = "$object->warehouse_id",
            $warehouseCode = "$object->warehouse_code",
            $companyID = "$object->company_id",
            $name = "$object->name",
            $type = "$object->type",
            $landline = "$object->landline",
            $fax = "$object->fax",
            $email = "$object->email",
            $country = "$object->country",
            $city = "$object->city",
            $addressLine1 = "$object->address_line_1",
            $addressLine2 = "$object->address_line_2",
            $postcode = "$object->postcode",
            $region = "$object->region",
            $lat = "$object->lat",
            $lng = "$object->lng",
            $pobox = "$object->pobox",
            $salespersonID = "$object->salesperson_id"
        );

        return $warehouse;
    }

    public function getCustomerObjectByCode($code){
        $object = $this->fetchSingleRow('Customers', 'customer_code', $code);

        $customer = new Customer(
            $customerID          = "$object->customer_id",
            $customerCode        = "$object->customer_code",
            $companyName         = "$object->customer_company_name",
            $reportName          = "$object->customer_report_name",
            $logo                = "$object->logo",
            $registrationCode    = "$object->registration_code",
            $mobile              = "$object->mobile",
            $website             = "$object->website",
            $email               = "$object->email",
            $description         = "$object->description",
            $typeOfBusiness      = "$object->type_of_business",
            $ticCode             = "$object->tic_code",
            $vatCode             = "$object->vat_code",
            $creditLimit         = "$object->credit_limit",
            $typeOfCustomer      = "$object->customer_type",
            $balance             = "$object->balance",
            $addressCodeEurosoft = "$object->address_code_eurosoft"
        );

        return $customer;
    }

    public function getVatObjectByCode($code){
        $object = $this->fetchSingleRow('Vats', 'vat_code', $code);

        $vat = new Vat(
            $vatID = "$object->vat_id",
            $vatCode = "$object->vat_code",
            $vatDisplayName = "$object->vat_display_name",
            $percentage = "$object->percentage"
        );

        return $vat;
    }

    public function getCategoryObjectByCode($code){
        $object = $this->fetchSingleRow('Categories', 'category_code', $code);

        $category = new Category(
            $categoryID = "$object->category_id",
            $categoryCode = "$object->category_code",
            $categoryName = "$object->name",
            $description = "$object->description",
            $creationDate = "$object->creation_date",
            $allowSubcategories = "$object->allow_subcategories",
            $allowItems = "$object->allow_items",
            $level = "$object->level",
            $customOrder = "$object->custom_order"
        );

        return $category;
    }

    public function getCustomerGroupObjectByCode($code){
        $object = $this->fetchSingleRow('CustomerGroups', 'group_code', $code);

        $customerGroup = new CustomerGroup(
            $groupID      = "$object->group_id",
            $groupCode    = "$object->group_code",
            $name         = "$object->name",
            $description  = "$object->description",
            $creationDate = "$object->creation_date"
        );

        return $customerGroup;
    }


    public function getBankObjectByCode($code){
        $object = $this->fetchSingleRow('Banks', 'code', $code);

        $bank = new Bank(
            $bankID = "$object->bank_id",
            $bankCode = "$object->code",
            $name = "$object->name",
            $status = "$object->status"
        );

        return $bank;
    }

    public function getPaymentTypeObjectByCode($code){
        $object = $this->fetchSingleRow('PaymentTypes', 'paymenttype_code', $code);

        $paymentType = new PaymentType(
            $paymentTypeID = "$object->paymenttype_id",
            $paymentTypeCode = "$object->paymenttype_code",
            $name = "$object->name"
        );

        return $paymentType;
    }

    public function getDocumentStatusTypeByTable($table)
    {
        $types  = $this->documentStatusTypes;
        $number = $types[$table];
        if(strcmp($number,'')==0){$number=0;}

        return $number;

    }

    public function getDocumentStatusIDByExportCode($code){
        $object = $this->fetchSingleRow('Documents_Status', 'export_code', $code);
        $id = 0;
        if(strcmp($object->id,'')!=0 && $object->id > 0){
            $id = $object->id;
        }

        return $id;
    }

    public function getTenderObjectByCode($code,$includeItems=true){
        $object = $this->fetchSingleRow('Tenders', 'tender_code', $code);

        $tender = new Tender(
            $tenderID           = "$object->tender_id",
            $tenderCode         = "$object->tender_code",
            $companyID          = "$object->company_id",
            $salesPersonID      = "$object->salesperson_id",
            $customerID         = "$object->customer_id",
            $tenderDate         = "$object->tender_date",
            $validUntil         = "$object->valid_until",
            $name               = "$object->name",
            $addressLine1       = "$object->address_line_1",
            $addressLine2       = "$object->address_line_2",
            $city               = "$object->city",
            $country            = "$object->country",
            $region             = "$object->region",
            $subTotal           = "$object->subtotal	",
            $grandTotal         = "$object->grand_total",
            $vatAmount          = "$object->vat_amount",
            $discountAmount     = "$object->discount_amount",
            $status             = "$object->status",
            $vatIorE            = "$object->vat_i_e",
            $printCount         = "$object->print_count",
            $details            = "$object->details",
            $currencyID         = "$object->currency_id",
            $deliveryMethod     = "$object->delivery_method",
            $globalDiscPercent  = "$object->global_discount_percentage",
            $currentVersion     = "$object->current_version",
            $editedBy           = "$object->edited_by",
            $actionHash         = "$object->action_hash",
            $actionTime         = "$object->action_time",
            $orderItems         = array()
        );
        if($includeItems) {
            $items = $this->search('Tender_Item', array('tender_id' => "$object->tender_id"));
            foreach ($items as $item) {
                $tender->addTenderItem(
                    new TenderItem(
                        $tenderItemID           = "$item->tender_item_id",
                        $tenderID               = "$item->tender_id",
                        $itemID                 = "$item->item_id",
                        $qty                    = "$item->qty",
                        $unitPrice              = "$item->unit_price",
                        $lineDiscount           = "$item->line_discount",
                        $globalDiscount         = "$item->global_discount",
                        $lineDiscountPercentage = "$item->line_discount_percentage",
                        $vatAmount              = "$item->vat_amount",
                        $priceTypeID            = "$item->pricetype_id",
                        $vatID                  = "$item->vat_id",
                        $description            = "$item->description",
                        $promotionID            = "$item->promotion_id",
                        $promotionNumber        = "$item->promotion_number",
                        $masterItem             = "$item->master_item"

                    )
                );
            }
        }
        return $tender;
    }

    public function getOrderObjectByCode($code,$includeItems=true){
        $object = $this->fetchSingleRow('Orders', 'order_code', $code);

        $order = new Order(
            $orderID            = "$object->order_id",
            $orderCode          = "$object->order_code",
            $companyID          = "$object->company_id",
            $customerID         = "$object->customer_id",
            $salespersonID      = "$object->salesperson_id",
            $paymentTypeID      = "$object->paymenttype_id",
            $orderDate          = "$object->order_date",
            $subTotal           = "$object->subtotal",
            $grandTotal         = "$object->grand_total",
            $vatAmount          = "$object->vat_amount",
            $discountAmount     = "$object->discount_amount",
            $printCount         = "$object->print_count",
            $orderAddressID     = "$object->order_address_id",
            $deliveryAddressID  = "$object->delivery_address_id	",
            $tenderID           = "$object->tender_id",
            $vatIorE            = "$object->vat_i_or_e",
            $deliveryDate       = "$object->delivery_date",
            $depositAmount      = "$object->deposit_amount",
            $details            = "$object->details",
            $status             = "$object->status",
            $currencyID         = "$object->currency_id",
            $globalDiscPercent  = "$object->global_discount_percentage",
            $deliveryMethod     = "$object->delivery_method",
            $onlineOrderID      = "$object->online_order_id",
            $actionHash         = "$object->action_hash",
            $actionTime         = "$object->action_time",
            $orderItems         = array()
        );
        if($includeItems) {
            $items = $this->search('Order_Item', array('order_id' => "$object->order_id"));
            foreach ($items as $item) {
                $order->addOrderItem(
                    new OrderItem(
                        $orderItemID = "$item->order_item_id",
                        $orderID = "$item->order_id",
                        $itemID = "$item->item_id",
                        $qty = "$item->qty",
                        $qtyPicked = "$item->qty_picked",
                        $qtyDelivered = "$item->qty_delivered",
                        $qtyInvoiced = "$item->qty_invoiced",
                        $unitPrice = "$item->unit_price",
                        $lineDiscount = "$item->line_discount",
                        $globalDiscount = "$item->global_discount",
                        $lineDiscountPercentage = "$item->line_discount_percentage",
                        $vatAmount = "$item->vat_amount",
                        $priceTypeID = "$item->pricetype_id",
                        $vatID = "$item->vat_id",
                        $description = "$item->description",
                        $promotionID = "$item->promotion_id",
                        $promotionNumber = "$item->promotion_number",
                        $masterItem = "$item->master_item"
                    )
                );
            }
        }
        return $order;
    }

    public function getWaybillObjectByCode($code,$includeItems=true){
        $object = $this->fetchSingleRow('Waybills', 'waybill_code', $code);

        $waybill = new Waybill(
            $waybillID          = "$object->waybill_id",
            $waybillCode        = "$object->waybill_code",
            $companyID          = "$object->company_id",
            $customerID         = "$object->customer_id",
            $salespersonID      = "$object->salesperson_id",
            $paymentTypeID      = "$object->paymenttype_id",
            $orderID            = "$object->order_id",
            $tenderID           = "$object->tender_id",
            $subTotal           = "$object->subtotal",
            $grandTotal         = "$object->grand_total",
            $vatAmount          = "$object->vat_amount",
            $vatIorE            = "$object->vat_i_e",
            $discountAmount     = "$object->discount_amount",
            $waybillAddressID   = "$object->waybill_address_id	",
            $deliveryAddressID  = "$object->delivery_address_id",
            $printCount         = "$object->print_count",
            $waybillDate        = "$object->waybill_date",
            $details            = "$object->details",
            $status             = "$object->status",
            $currencyID         = "$object->currency_id",
            $globalDiscPercent  = "$object->global_discount_percentage",
            $actionHash         = "$object->action_hash",
            $actionTime         = "$object->action_time",
            $waybillItems       = array()
        );
        if($includeItems) {
            $items = $this->search('Waybill_Item', array('waybill_id' => "$object->waybill_id"));
            foreach ($items as $item) {
                $waybill->addWaybillItem(
                    new WaybillItem(
                        $waybillItemID   = "$item->waybill_item_id",
                        $waybillID       = "$item->waybill_id",
                        $itemID          = "$item->item_id",
                        $batchNumber     = "$item->batch_number",
                        $warehouseID     = "$item->warehouse_id",
                        $qty             = "$item->qty",
                        $qtyInvoiced     = "$item->qty_invoiced",
                        $unitPrice       = "$item->unit_price",
                        $lineDiscount    = "$item->line_discount",
                        $globalDiscount  = "$item->global_discount",
                        $lineDiscPercent = "$item->line_discount_percentage",
                        $vatAmount       = "$item->vat_amount",
                        $priceTypeID     = "$item->pricetype_id",
                        $vatID           = "$item->vat_id",
                        $serialNumber    = "$item->serialnumber",
                        $description     = "$item->description",
                        $cost            = "$item->cost"

                    )
                );
            }
        }
        return $waybill;
    }

    public function getInvoiceObjectByCode($code,$includeItems=true){
        $object = $this->fetchSingleRow('Invoices', 'invoice_code', $code);

        $invoice = new Invoice(
            $invoiceID         = "$object->invoice_id",
            $invoiceCode       = "$object->invoice_code",
            $companyID         = "$object->company_id",
            $customerID        = "$object->customer_id",
            $salespersonID     = "$object->salesperson_id",
            $paymentTypeID     = "$object->paymenttype_id",
            $orderID           = "$object->order_id",
            $tenderID          = "$object->tender_id",
            $subTotal          = "$object->subtotal",
            $grandTotal        = "$object->grand_total",
            $vatAmount         = "$object->vat_amount",
            $vatIorE           = "$object->vat_i_e",
            $discountAmount    = "$object->discount_amount",
            $invoiceAddressID  = "$object->invoice_address_id",
            $deliveryAddressID = "$object->delivery_address_id",
            $printCount        = "$object->print_count",
            $invoiceDate       = "$object->invoice_date",
            $details           = "$object->details",
            $invoiceType       = "$object->invoice_type",
            $dueDate           = "$object->due_date",
            $status            = "$object->status",
            $currencyID        = "$object->currency_id",
            $globalDiscPercent = "$object->global_discount_percentage",
            $actionHash        = "$object->action_hash",
            $actionTime        = "$object->action_time",
            $invoiceItems      = array()
        );
        if($includeItems) {
            $items = $this->search('Invoice_Item', array('invoice_id' => "$object->invoice_id"));
            foreach ($items as $item) {
                $invoice->addInvoiceItem(
                    new InvoiceItem(
                        $invoiceItemID   = "$item->invoice_item_id",
                        $invoiceID       = "$item->invoice_id",
                        $itemID          = "$item->item_id",
                        $batchNumber     = "$item->batch_number",
                        $warehouseID     = "$item->warehouse_id",
                        $qty             = "$item->qty",
                        $unitPrice       = "$item->unit_price",
                        $lineDiscount    = "$item->line_discount",
                        $globalDiscount  = "$item->global_discount",
                        $lineDiscPercent = "$item->line_discount_percentage",
                        $vatAmount       = "$item->vat_amount",
                        $priceTypeID     = "$item->pricetype_id",
                        $vatID           = "$item->vat_id",
                        $serialNumber    = "$item->serialnumber",
                        $description     = "$item->description",
                        $cost            = "$item->cost",
                        $promotionID     = "$item->promotion_id",
                        $promotionNumber = "$item->promotion_number",
                        $masterItem      = "$item->master_item"

                    )
                );
            }
        }
        return $invoice;
    }

    public function getReturnObjectByCode($code,$includeItems=true){
        $object = $this->fetchSingleRow('Returns', 'return_code', $code);

        $return = new SalesReturn(
            $returnID          = "$object->return_id",
            $returnCode        = "$object->return_code",
            $companyID         = "$object->company_id",
            $customerID        = "$object->customer_id",
            $salespersonID     = "$object->salesperson_id",
            $paymentTypeID     = "$object->paymenttype_id",
            $orderID           = "$object->order_id",
            $subTotal          = "$object->subtotal",
            $grandTotal        = "$object->grand_total",
            $vatAmount         = "$object->vat_amount",
            $vatIorE           = "$object->vat_i_e",
            $discountAmount    = "$object->discount_amount",
            $returnAddressID   = "$object->return_address_id",
            $printCount        = "$object->print_count",
            $returnDate        = "$object->return_date",
            $details           = "$object->details",
            $status            = "$object->status",
            $currencyID        = "$object->currency_id",
            $globalDiscPercent = "$object->global_discount_percentage",
            $returnType        = "$object->return_type",
            $actionHash        = "$object->action_hash",
            $actionTime        = "$object->action_time",
            $invoiceItems      = array()
        );
        if($includeItems) {
            $items = $this->search('Return_Item', array('return_id' => "$object->return_id"));
            foreach ($items as $item) {
                $return->addReturnItem(
                    new ReturnItem(
                        $invoiceItemID   = "$item->return_item_id",
                        $invoiceID       = "$item->return_id",
                        $itemID          = "$item->item_id",
                        $batchNumber     = "$item->batch_number",
                        $warehouseID     = "$item->warehouse_id",
                        $qty             = "$item->qty",
                        $unitPrice       = "$item->unit_price",
                        $lineDiscount    = "$item->line_discount",
                        $globalDiscount  = "$item->global_discount",
                        $lineDiscPercent = "$item->line_discount_percentage",
                        $vatAmount       = "$item->vat_amount",
                        $priceTypeID     = "$item->pricetype_id",
                        $vatID           = "$item->vat_id",
                        $serialNumber    = "$item->serialnumber",
                        $description     = "$item->description",
                        $status          = "$item->status",
                        $cost            = "$item->cost"
                    )
                );
            }
        }
        return $return;
    }

    public function getReceiptObjectByCode($code,$includeItems=true){

        $object = $this->fetchSingleRow('Receipts', 'receipt_code', $code);
        $result = $this->createObjectByDbCall('Receipts',$object,$includeItems);
        return $result;

    }

    public function getWarehouseTransactionObjectByCode($code,$includeItems=true){

        $object = $this->fetchSingleRow('Warehouse_Transactions', 'warehouse_transaction_code', $code);
        $result = $this->createObjectByDbCall('Warehouse_Transactions',$object,$includeItems);
        return $result;

    }


    /** GENERAL GETTERS */
    public function getCategoryTreeByObject($category){

        $root = $this->getCategoryTreeRootByObject($category);
        $root->subCategories = array($this->getCategoryTreeBranchesByObject($category));

        return $root;

    }

    public function getCategoryTreeRootByObject($category,$existingCategories = array()){

        $result = $category;
        array_push($existingCategories, $category->categoryID);

        $tree = $this->compactQuery('Subcategories','subcategory_id',$category->categoryID,'category_id');
        foreach($tree as $branch){

            $parentCategory = $this->getCategoryObjectByID($branch->category_id);
            if(!in_array($branch->category_id,$existingCategories)) {
                $parentCategory->addSubCategory($category);
                $result = $this->getCategoryTreeRootByObject($parentCategory, $existingCategories);
            } else {
                echo "Infinite Loop Prevention. Category $parentCategory->categoryCode - $parentCategory->categoryName ($parentCategory->categoryID) Exists Multiple Times in Tree Root Structure";
            }
        }

        return $result;

    }

    public function getCategoryTreeBranchesByObject($category,$existingCategories = array()){

        $result = $category;
        array_push($existingCategories, $category->categoryID);

        $tree = $this->compactQuery('Subcategories','category_id',$category->categoryID,'subcategory_id');
        foreach($tree as $branch){

            $subCategory = $this->getCategoryObjectByID($branch->subcategory_id);
            if(!in_array($branch->subcategory_id,$existingCategories)) {
                $subCategory = $this->getCategoryTreeBranchesByObject($subCategory, $existingCategories);
                $category->addSubCategory($subCategory);
                $result = $category;
            } else {
                echo "Infinite Loop Prevention. Category $subCategory->categoryCode - $subCategory->categoryName ($subCategory->categoryID) Exists Multiple Times in Tree Branches Structure";
            }
        }

        return $result;

    }

    public function getCategoryArrayByCategoryTree($tree,$array = array()){
        array_push($array,$tree->categoryID);
        foreach ($tree->subCategories as $branch) {
            $subArray = $this->getCategoryArrayByCategoryTree($branch,$array);
            $array = array_merge($array,$subArray);

        }
        return array_unique($array);
    }

    public function getSubCategoriesArrayByObject($category){
        $tree = $this->getCategoryTreeBranchesByObject($category);
        $array = $this->getCategoryArrayByCategoryTree($tree);
        unset($array[0]);
        return $array;
    }

    public function getDocumentForExports($documentType,$includeItems=true,$extraWhere='')
    {
        $documents=array();


        $docNumber=$this->documentStatusTypes[$documentType];

        if($docNumber==1)
        {
            $documentIDs= $this->fetchNested("$documentType","*","tender_id","NOT IN","Documents_Status","id","type",$docNumber,$extraWhere);
            foreach ($documentIDs as $tender)
            {
                array_push($documents,$this->createObjectByDbCall("Tenders",$tender,$includeItems));
            }

        } else if($docNumber==2) {
            $documentIDs= $this->fetchNested("$documentType","*","order_id","NOT IN","Documents_Status","id","type",$docNumber,$extraWhere);
            foreach ($documentIDs as $order)
            {
                array_push($documents,$this->createObjectByDbCall("Orders",$order,$includeItems));
            }

        } else if($docNumber==3) {
            $documentIDs= $this->fetchNested("$documentType","*","waybill_id","NOT IN","Documents_Status","id","type",$docNumber,$extraWhere);
            foreach ($documentIDs as $waybill)
            {
                array_push($documents,$this->createObjectByDbCall("Waybills",$waybill,$includeItems));
            }

        } else if($docNumber==4) {
            $documentIDs= $this->fetchNested("$documentType","*","return_id","NOT IN","Documents_Status","id","type",$docNumber,$extraWhere);
            foreach ($documentIDs as $return)
            {
                array_push($documents,$this->createObjectByDbCall("Returns",$return,$includeItems));
            }

        } else if($docNumber==5) {
            $documentIDs= $this->fetchNested("$documentType","*","invoice_id","NOT IN","Documents_Status","id","type",$docNumber,$extraWhere);
            foreach ($documentIDs as $invoice)
            {
                array_push($documents,$this->createObjectByDbCall("Invoices",$invoice,$includeItems));
            }

        } else if($docNumber==6) {
            $documentIDs= $this->fetchNested("$documentType","*","receipt_id","NOT IN","Documents_Status","id","type",$docNumber,$extraWhere);
            foreach ($documentIDs as $receipt)
            {
                array_push($documents,$this->createObjectByDbCall("Receipts",$receipt,$includeItems));
            }

        } else if($docNumber==7) {
            $documentIDs= $this->fetchNested("Warehouse_Transactions","*","warehouse_transaction_id","NOT IN","Documents_Status","id","type",$docNumber,$extraWhere);
            foreach ($documentIDs as $warehouseTransaction)
            {
                array_push($documents,$this->createObjectByDbCall("Warehouse_Transactions",$warehouseTransaction,$includeItems));
            }

        } else {

            echo "<br>NOTICE - Function getDocumentForExports($documentType Not Mapped).<br>";

        }

        return $documents;
    }

    public function getImageBase64ByDirectory($path){

        $type = pathinfo($path, PATHINFO_EXTENSION);
        $data = file_get_contents($path);
        $data = str_replace('dataimage/pngbase64','',base64_encode($data));
        $data = str_replace('dataimage/jpgbase64','',base64_encode($data));
        $base64 = 'data:image/' . $type . ';base64,' . $data;

        return $base64;
    }

    public function getDayNameByNumber($number){
        $nameDays = array('1'=>'Monday','2'=>'Tuesday','3'=>'Wednesday','4'=>'Thursday','5'=>'Friday','6'=>'Saturday','7'=>'Sunday');

        return $nameDays[$number];
    }

    public function getItemPriceFromPriceType($itemID,$priceTypeID){
        $result = $this->fetchCustomSingle('SELECT price FROM Prices WHERE item_id=? AND pricetype_id=?',array($itemID,$priceTypeID))->price;

        return $result;
    }

    public function getBankObjectByName($name){
        $object = $this->fetchSingleRow('Banks', 'name', $name);
        $bank = new Bank(
            $bankID = "$object->bank_id",
            $bankCode = "$object->code",
            $name = "$object->name",
            $status = "$object->status"
        );

        return $bank;
    }

    public function getContactPersonObjectsByCustomerID($customerID){

        $objects = $this->compactQuery('Contact_Person', 'customer_id', $customerID, '*');

        $contactPersons = array();

        foreach ($objects as $object) {
            $contactPerson = new ContactPerson(
                $id = "$object->contact_person_id",
                $firstName = "$object->first_name",
                $lastName = "$object->last_name",
                $position = "$object->position",
                $landline = "$object->landline",
                $mobile = "$object->mobile",
                $tax = "$object->fax",
                $email = "$object->email",
                $notes = "$object->notes",
                $customerID = "$object->customer_id"
            );
            array_push($contactPersons,$contactPerson);
        }

        return $contactPersons;
    }

    public function getCustomerGroupObjectsByCustomerID($customerID){

        $objects= $this->fetchNested("CustomerGroups","*","group_id","IN","Customer_CustomersGroup","group_id","customer_id",$customerID,'');

        $customerGroups = array();

        foreach ($objects as $object) {
            $customerGroup = new CustomerGroup(
                $groupID      = "$object->group_id",
                $groupCode    = "$object->group_code",
                $name         = "$object->name",
                $description  = "$object->description",
                $creationDate = "$object->creation_date"
            );
            array_push($customerGroups,$customerGroup);
        }

        return $customerGroups;
    }

    public function getCustomerScheduleObjectsByCustomerID($customerID){

        $objects= $this->fetchNested("Schedules","*","schedule_id","IN","Schedule_Customer","schedule_id","customer_id",$customerID,'');

        $customerSchedules = array();

        foreach ($objects as $object) {
            $schedule = new Schedule(
                $scheduleID   = "$object->schedule_id",
                $name         = "$object->name",
                $creationDate = "$object->creation_date",
                $creatorID    = "$object->creator_id",
                $type         = "$object->type",
                $date         = "$object->date",
                $repeatPeriod = "$object->repeat_period",
                $day          = "$object->day",
                $week         = "$object->week",
                $month        = "$object->month",
                $notes        = "$object->notes",
                $customers = array()
            );
            array_push($customerSchedules,$schedule);
        }

        return $customerSchedules;
    }

    public function getErpCustomerAgeingObjectByCustomerID($customerID){
        $object = $this->fetchSingleRow('ERP_Customer_Ageing', 'customer_id', $customerID);
        $erpCustomerAgeing = new ErpCustomerAgeing(
            $customerID = "$object->customer_id",
            $period1= "$object->period1",
            $period2= "$object->period2",
            $period3= "$object->period3",
            $period4= "$object->period4",
            $period5= "$object->period5",
            $period6= "$object->period6",
            $period7= "$object->period7",
            $period8= "$object->period8",
            $period9= "$object->period9",
            $balance = "$object->balance",
            $notes = "$object->notes",
            $details = "$object->details",
            $date = "$object->date"
        );

        return $erpCustomerAgeing;
    }

    public function getSalesPersonIDByCode($code){
        $object = $this->fetchSingleRow('SalesPersons', 'salesperson_code', "$code");

        if((int)$object->salesperson_id > 0) {
            return $object->salesperson_id;
        } else {
            return 0;
        }
    }

    public function getMultipleCustomerObjectsByFilter($filterColumn,$filterValue){
        $customers = array();
        $objects = $this->compactQuery('Customers',$filterColumn,$filterValue,'*');
        foreach($objects as $object) {
            $customer = new Customer(
                $customerID = "$object->customer_id",
                $customerCode = "$object->customer_code",
                $companyName = "$object->customer_company_name",
                $reportName = "$object->customer_report_name",
                $logo = "$object->logo",
                $registrationCode = "$object->registration_code",
                $mobile = "$object->mobile",
                $website = "$object->website",
                $email = "$object->email",
                $description = "$object->description",
                $typeOfBusiness = "$object->type_of_business",
                $ticCode = "$object->tic_code",
                $vatCode = "$object->vat_code",
                $creditLimit = "$object->credit_limit",
                $typeOfCustomer = "$object->customer_type",
                $balance = "$object->balance",
                $addressCodeEurosoft = "$object->address_code_eurosoft"
            );
            array_push($customers,$customer);
        }

        return $customers;
    }

    public function getInvoicesOfReceiptByID($receiptID){
        $invoices = array();
        $objects = $this->compactQuery('Invoice_Receipt','receipt_id',$receiptID,'*');
        foreach($objects as $object) {

            $invoice = $this->getInvoiceObjectByID($object->invoice_id,$includeItems=false);

            $invoiceOfReceipt = new stdClass();
            $invoiceOfReceipt->invoiceID = $invoice->invoiceID;
            $invoiceOfReceipt->invoiceCode = $invoice->invoiceCode;
            $invoiceOfReceipt->amount = $object->amount;
            array_push($invoices,$invoiceOfReceipt);


        }

        return $invoices;
    }

    public function getLastValueOfCustomForm($customFormID,$customFieldID,$tableName,$tableID)
    {

        $result = $this->fetchCustomSingle('SELECT value FROM ZA_Custom_Field_Object,ZA_Custom_Form_Object,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Object.custom_form_id=? AND ZA_Custom_Form_Object.custom_form_id =ZA_Custom_Form_Usage.custom_form_id AND ZA_Custom_Form_Usage.linked_table=? AND  ZA_Custom_Form_Object.linked_table_id=? AND ZA_Custom_Form_Object.custom_form_object_id=ZA_Custom_Field_Object.custom_form_object_id AND ZA_Custom_Field_Object.custom_field_id=?',array($customFormID,$tableName,$tableID,$customFieldID))->value;

        return $result;

    }


    /** Coprime Internal Object Mapping */
    public function mapArrayToObject($table,$object){
        switch ($table){
            case 'Service_Call':
                $array = array(
                    'service_call_code'=>"$object->serviceCallCode",
                    'salesperson_id'=>"$object->salesPersonID",
                    'assign_to'=>"$object->assignTo",
                    'customer_id'=>"$object->customerID",
                    'customer_address_id'=>"$object->customerAddressID",
                    'item_id'=>"$object->mobile",
                    'serial_number_id'=>"$object->serialNumberID",
                    'source_id'=>"$object->sourceID",
                    'type_id'=>"$object->typeID",
                    'status_id'=>"$object->statusID",
                    'priority_id'=>"$object->priorityID",
                    'topic'=>"$object->topic",
                    'details'=>"$object->details",
                    'source_name'=>"$object->sourceName",
                    'source_details'=>"$object->sourceDetails",
                    'date'=>"$object->date",
                    'due_date'=>"$object->dueDate",
                    'schedule_start_date'=>"$object->scheduleStartDate",
                    'schedule_end_date'=>"$object->scheduleEndDate",
                    'parent_id'=>"$object->parentID",
                    'progress'=>"$object->progress",
                    'assign_to_2'=>"$object->assignTo2",
                    'action_hash'=>"$object->actionHash",
                    'action_time'=>"$object->actionTime"
                );
                break;
            case 'Service_Call_Reply':
                $array = array(
                    'service_call_id'=>"$object->serviceCallID",
                    'salesperson_id'=>"$object->salesPersonID",
                    'status_id'=>"$object->statusID",
                    'date'=>"$object->date",
                    'reply_type_id'=>"$object->replyTypeID",
                    'details'=>"$object->details",
                    'document_id'=>"$object->documentID",
                    'document_type'=>"$object->documentType",
                    'salesperson_to'=>"$object->salesPersonTo",
                    'email_response'=>"$object->emailResponse",
                    'priority_id'=>"$object->priorityID"
                );
                break;
            case 'Customers':
                $array = array(
                    'customer_code'=>"$object->customerCode",
                    'customer_company_name'=>"$object->companyName",
                    'customer_report_name'=>"$object->reportName",
                    'logo'=>"$object->logo",
                    'registration_code'=>"$object->registrationCode",
                    'mobile'=>"$object->mobile",
                    'website'=>"$object->website",
                    'email'=>"$object->email",
                    'description'=>"$object->description",
                    'type_of_business'=>"$object->typeOfBusiness",
                    'tic_code'=>"$object->ticCode",
                    'vat_code'=>"$object->vatCode",
                    'credit_limit'=>"$object->creditLimit",
                    'address_code_eurosoft'=>"$object->addressCodeEurosoft",
                    'customer_type'=>"$object->typeOfCustomer",
                    'balance'=>"$object->balance"
                );
                break;
            case 'CustomerAddress':
                $array  = array(
                    'address_code'=>"$object->addressCode",
                    'customer_id'=>"$object->customer_id",
                    'country'=>"$object->country",
                    'city'=>"$object->city",
                    'address_line_1'=>"$object->addressLine1",
                    'address_line_2'=>"$object->addressLine2",
                    'postcode'=>"$object->postcode",
                    'region'=>"$object->region",
                    'lat'=>"$object->lat",
                    'lng'=>"$object->lng",
                    'pobox'=>"$object->pobox",
                    'landline'=>"$object->landline",
                    'fax'=>"$object->fax",
                    'primary_address'=>"$object->primaryAddress"
                );
                break;
            case 'Suppliers':
                $array = array(
                    'customer_code'=>"$object->customerCode",
                    'customer_company_name'=>"$object->companyName",
                    'customer_report_name'=>"$object->reportName",
                    'logo'=>"$object->logo",
                    'registration_code'=>"$object->registrationCode",
                    'mobile'=>"$object->mobile",
                    'website'=>"$object->website",
                    'email'=>"$object->email",
                    'description'=>"$object->description",
                    'type_of_business'=>"$object->typeOfBusiness",
                    'tic_code'=>"$object->ticCode",
                    'vat_code'=>"$object->vatCode",
                    'credit_limit'=>"$object->creditLimit",
                    'address_code_eurosoft'=>"$object->addressCodeEurosoft",
                    'customer_type'=>"$object->typeOfCustomer",
                    'balance'=>"$object->balance"
                );
                break;
            case 'SupplierAddress':
                $array  = array(
                    'address_code'=>"$object->addressCode",
                    'supplier_id'=>"$object->supplier_id",
                    'country'=>"$object->country",
                    'city'=>"$object->city",
                    'address_line_1'=>"$object->addressLine1",
                    'address_line_2'=>"$object->addressLine2",
                    'postcode'=>"$object->postcode",
                    'region'=>"$object->region",
                    'lat'=>"$object->lat",
                    'lng'=>"$object->lng",
                    'pobox'=>"$object->pobox",
                    'landline'=>"$object->landline",
                    'fax'=>"$object->fax",
                    'primary_address'=>"$object->primaryAddress"
                );
                break;
            case 'CustomerGroups':
                $array  = array(
                    'group_code'=>"$object->groupCode",
                    'name'=>"$object->name",
                    'description'=>"$object->description",
                    'creation_date'=>"$object->creationDate"
                );
                break;
            case 'Contact_Person':
                $array  = array(
                    'contact_person_id'=>"$object->id",
                    'first_name'=>"$object->firstName",
                    'last_name'=>"$object->lastName",
                    'position'=>"$object->position",
                    'landline'=>"$object->landline",
                    'mobile'=>"$object->mobile",
                    'fax'=>"$object->tax",
                    'email'=>"$object->email",
                    'customer_id'=>"$object->customerID",
                    'notes'=>"$object->notes"
                );
                break;
            case 'ContractPrices':
                $array  = array(
                    'customer_id'=>"$object->customerID",
                    'item_id'=>"$object->itemID",
                    'price'=>"$object->price",
                    'pricetype_id'=>"$object->priceTypeID",
                    'percentage'=>"$object->percentage",
                    'min_qty'=>"$object->minQty",
                    'valid_from'=>"$object->validFrom",
                    'valid_until'=>"$object->validUntil"
                );
                break;
            case 'Items':
                $array  = array(
                    'item_code'=>"$object->itemCode",
                    'item_sku'=>"$object->itemSKU",
                    'company_id'=>"$object->companyID",
                    'vat_id'=>"$object->vatID",
                    'subunits'=>"$object->subunits",
                    'sales_units'=>"$object->salesUnits",
                    'manufacturer_id'=>"$object->manufacturerID",
                    'name'=>"$object->name",
                    'short_description'=>"$object->shortDescription",
                    'long_description'=>"$object->longDescription",
                    'thumbnail_url'=>"$object->thumbnailUrl",
                    'reorder_level'=>"$object->reorderLevel",
                    'target_qty'=>"$object->targetQty",
                    'bundled'=>"$object->bundle",
                    'max_stock'=>"$object->maxStock",
                    'min_stock'=>"$object->minStock",
                    'packing'=>"$object->packing",
                    'stock_control'=>"$object->stockControl",
                    'sellable'=>"$object->sellable",
                    'weight'=>"$object->weight",
                    'cbm'=>"$object->cbm",
                    'status'=>"$object->status"
                );
                break;
            case 'Categories':
                $array  = array(
                    'category_code'=>"$object->categoryCode",
                    'name'=>"$object->categoryName",
                    'description'=>"$object->description",
                    'creation_date'=>"$object->creationDate",
                    'allow_subcategories'=>"$object->allowSubcategories",
                    'allow_items'=>"$object->allowItems",
                    'level'=>"$object->level",
                    'custom_order'=>"$object->customOrder"
                );
                break;
            case 'Subcategories':
                $array  = array(
                    'category_id'=>"$object->categoryID",
                    'subcategory_id'=>"$object->subCategoryID",
                    'date_added'=>"$object->dateAdded",
                );
                break;
            case 'Vats':
                $array  = array(
                    'vat_code'=>"$object->vatCode",
                    'vat_display_name'=>"$object->vatDisplayName",
                    'percentage'=>"$object->percentage"
                );
                break;
            case 'Banks':
                $array  = array(
                    'code'=>"$object->bankCode",
                    'name'=>"$object->name",
                    'status'=>"$object->status"
                );
                break;
            case 'PaymentTypes':
                $array  = array(
                    'paymenttype_code'=>"$object->paymentTypeCode",
                    'name'=>"$object->name"
                );
                break;
            case 'Payment_Terms':
                $array  = array(
                    'payment_term_code'=>"$object->paymentTermCode",
                    'payment_term_text'=>"$object->paymentTermText",
                    'payment_terms_days'=>"$object->paymentTermDays"
                );
                break;
            case 'PriceTypes':
                $array  = array(
                    'price_code'=>"$object->priceCode",
                    'name'=>"$object->name",
                    'allow_discount'=>"$object->allowDiscount",
                    'default_type'=>"$object->defaultType"
                );
                break;
            case 'Price_Group_Definitions':
                $array  = array(
                    'price_group_code'=>"$object->priceGroupCode",
                    'name'=>"$object->name",
                    'type'=>"$object->type"
                );
                break;
            case 'Price_Group_Rules':
                $array  = array(
                    'price_group_definition_id'=>"$object->priceGroupDefinitionID",
                    'category_id'=>"$object->categoryID",
                    'discount_percent'=>"$object->discountPercent",
                    'price_type_id'=>"$object->priceTypeID",
                );
                break;
            case 'Stock':
                $warehouseObject = $object->warehouse;
                $itemObject = $object->item;
                $array  = array(
                    'warehouse_id'=>"$warehouseObject->warehouseID",
                    'item_id'=>"$itemObject->itemID",
                    'batch_number'=>"$object->batchNumber",
                    'available'=>"$object->available",
                    'reserved'=>"$object->reserved",
                    'delivered'=>"$object->delivered",
                    'on_order'=>"$object->onOrder",
                    'requested'=>"$object->requested",
                    'sold'=>"$object->sold",
                    'expiry_date'=>"$object->expiryDate"
                );
                break;
            case 'Customer_Pricelist':
                $customerObject = $object->customer;
                $priceTypeObject = $object->priceType;
                $array  = array(
                    'customer_id'=>"$customerObject->customerID",
                    'pricetype_id'=>"$priceTypeObject->priceTypeID",
                    'discount_percentage'=>"$object->discountPercentage",
                    'fix_amount'=>"$object->fixAmount",
                    'allow_discount'=>"$object->allowDiscount",
                    'start_date'=>"$object->startDate",
                    'end_date'=>"$object->endDate",
                    'periodic'=>"$object->periodic"
                );
                break;
            case 'Schedules':
                $array  = array(
                    'name'=>"$object->name",
                    'creation_date'=>"$object->creationDate",
                    'creator_id'=>"$object->creatorID",
                    'type'=>"$object->type",
                    'date'=>"$object->date",
                    'repeat_period'=>"$object->repeatPeriod",
                    'day'=>"$object->day",
                    'week'=>"$object->week",
                    'month'=>"$object->month",
                    'notes'=>"$object->notes"
                );
                break;
            case 'Item_Barcode':
                $itemObject = $object->item;
                $array  = array(
                    'item_id'=>"$itemObject->itemID",
                    'barcode'=>"$object->barcode",
                    'multiplier'=>"$object->multiplier",
                    'default_barcode'=>"$object->defaultBarcode"
                );
                break;
            case 'Prices':
                $itemObject = $object->item;
                $priceTypeObject = $object->priceType;
                $array  = array(
                    'item_id'=>"$itemObject->itemID",
                    'pricetype_id'=>"$priceTypeObject->priceTypeID",
                    'price'=>"$object->price",
                    'allow_discount'=>"$object->allowDiscount",
                    'inc_vat'=>"$object->incVat"
                );
                break;
            case 'Warehouses':
                $array  = array(
                    'warehouse_code'=>"$object->warehouseCode",
                    'company_id'=>"$object->companyID",
                    'name'=>"$object->name",
                    'type'=>"$object->type",
                    'landline'=>"$object->landline",
                    'fax'=>"$object->fax",
                    'email'=>"$object->email",
                    'country'=>"$object->country",
                    'city'=>"$object->city",
                    'address_line_1'=>"$object->addressLine1",
                    'address_line_2'=>"$object->addressLine2",
                    'postcode'=>"$object->postcode",
                    'region'=>"$object->region",
                    'lat'=>"$object->lat",
                    'lng'=>"$object->lng",
                    'pobox'=>"$object->pobox",
                    'salesperson_id'=>"$object->salespersonID"
                );
                break;
            case 'ERP_Customer_Ageing':
                $array  = array(
                    'customer_id'=>"$object->customerID",
                    'period1'=>"$object->period1",
                    'period2'=>"$object->period2",
                    'period3'=>"$object->period3",
                    'period4'=>"$object->period4",
                    'period5'=>"$object->period5",
                    'period6'=>"$object->period6",
                    'period7'=>"$object->period7",
                    'period8'=>"$object->period8",
                    'period9'=>"$object->period9",
                    'balance'=>"$object->balance",
                    'notes'=>"$object->notes",
                    'details'=>"$object->details",
                    'date'=>"$object->date"
                );
                break;
            case 'Tenders':
                $array  = array(
                    'tender_code'=>"$object->tenderCode",
                    'company_id'=>"$object->companyID",
                    'salesperson_id'=>"$object->salesPersonID",
                    'customer_id'=>"$object->customerID",
                    'tender_date'=>"$object->tenderDate",
                    'valid_until'=>"$object->validUntil",
                    'name'=>"$object->name",
                    'address_line_1'=>"$object->addressLine1",
                    'address_line_2'=>"$object->addressLine2",
                    'city'=>"$object->city",
                    'country'=>"$object->country",
                    'region'=>"$object->region",
                    'subtotal'=>"$object->subTotal",
                    'grand_total'=>"$object->grandTotal",
                    'vat_amount'=>"$object->vatAmount",
                    'discount_amount'=>"$object->discountAmount",
                    'status'=>"$object->status",
                    'vat_i_e'=>"$object->vatIorE",
                    'print_count'=>"$object->printCount",
                    'details'=>"$object->details",
                    'currency_id'=>"$object->currencyID",
                    'delivery_method'=>"$object->deliveryMethod",
                    'global_discount_percentage'=>"$object->globalDiscountPercentage",
                    'current_version'=>"$object->currentVersion",
                    'edited_by'=>"$object->editedBy",
                    'action_hash'=>"$object->actionHash",
                    'action_time'=>"$object->actionTime"
                );
                break;
            case 'Tender_Item':
                $array  = array(
                    'tender_id'=>"$object->tenderID",
                    'item_id'=>"$object->itemID",
                    'qty'=>"$object->qty",
                    'unit_price'=>"$object->unitPrice",
                    'line_discount'=>"$object->lineDiscount",
                    'global_discount'=>"$object->globalDiscount",
                    'line_discount_percentage'=>"$object->lineDiscountPercentage",
                    'vat_amount'=>"$object->vatAmount",
                    'pricetype_id'=>"$object->priceTypeID",
                    'vat_id'=>"$object->vatID",
                    'description'=>"$object->description",
                    'promotion_id'=>"$object->promotionID",
                    'promotion_number'=>"$object->promotionNumber",
                    'master_item'=>"$object->masterItem"
                );
                break;
            case 'Orders':
                $array  = array(
                    'order_code'=>"$object->orderCode",
                    'company_id'=>"$object->companyID",
                    'customer_id'=>"$object->customerID",
                    'salesperson_id'=>"$object->salespersonID",
                    'paymenttype_id'=>"$object->paymentTypeID",
                    'order_date'=>"$object->orderDate",
                    'subtotal'=>"$object->subTotal",
                    'grand_total'=>"$object->grandTotal",
                    'vat_amount'=>"$object->vatAmount",
                    'discount_amount'=>"$object->discountAmount",
                    'print_count'=>"$object->printCount",
                    'order_address_id'=>"$object->orderAddressID",
                    'delivery_address_id'=>"$object->deliveryAddressID",
                    'tender_id'=>"$object->tenderID",
                    'vat_i_or_e'=>"$object->vatIorE",
                    'delivery_date'=>"$object->deliveryDate",
                    'deposit_amount'=>"$object->depositAmount",
                    'details'=>"$object->details",
                    'status'=>"$object->status",
                    'currency_id'=>"$object->currencyID",
                    'global_discount_percentage'=>"$object->globalDiscountPercentage",
                    'delivery_method'=>"$object->deliveryMethod",
                    'online_order_id'=>"$object->onlineOrderID",
                    'action_hash'=>"$object->actionHash",
                    'action_time'=>"$object->actionTime"
                );
                break;
            case 'Order_Item':
                $array  = array(
                    'order_id'=>"$object->orderID",
                    'item_id'=>"$object->itemID",
                    'qty'=>"$object->qty",
                    'qty_picked'=>"$object->qtyPicked",
                    'qty_delivered'=>"$object->qtyDelivered",
                    'qty_invoiced'=>"$object->qtyInvoiced",
                    'unit_price'=>"$object->unitPrice",
                    'line_discount'=>"$object->lineDiscount",
                    'global_discount'=>"$object->globalDiscount",
                    'line_discount_percentage'=>"$object->lineDiscountPercentage",
                    'vat_amount'=>"$object->vatAmount",
                    'pricetype_id'=>"$object->priceTypeID",
                    'vat_id'=>"$object->vatID",
                    'description'=>"$object->description",
                    'promotion_id'=>"$object->promotionID",
                    'promotion_number'=>"$object->promotionNumber",
                    'master_item'=>"$object->masterItem"
                );
                break;
            case 'Waybills':
                $array  = array(
                    'waybill_code'=>"$object->waybillCode",
                    'company_id'=>"$object->companyID",
                    'customer_id'=>"$object->customerID",
                    'salesperson_id'=>"$object->salespersonID",
                    'paymenttype_id'=>"$object->paymentTypeID",
                    'order_id'=>"$object->orderID",
                    'tender_id'=>"$object->tenderID",
                    'subtotal'=>"$object->subTotal",
                    'grand_total'=>"$object->grandTotal",
                    'vat_amount'=>"$object->vatAmount",
                    'vat_i_e'=>"$object->vatIorE",
                    'discount_amount'=>"$object->discountAmount",
                    'waybill_address_id'=>"$object->waybillAddressID",
                    'delivery_address_id'=>"$object->deliveryAddressID",
                    'print_count'=>"$object->printCount",
                    'waybill_date'=>"$object->waybillDate",
                    'details'=>"$object->details",
                    'status'=>"$object->status",
                    'currency_id'=>"$object->currencyID",
                    'global_discount_percentage'=>"$object->globalDiscountPercentage",
                    'action_hash'=>"$object->actionHash",
                    'action_time'=>"$object->actionTime"
                );
                break;
            case 'Waybill_Item':
                $array  = array(
                    'waybill_id'=>"$object->waybillID",
                    'item_id'=>"$object->itemID",
                    'batch_number'=>"$object->batchNumber",
                    'warehouse_id'=>"$object->warehouseID",
                    'qty'=>"$object->qty",
                    'qty_invoiced'=>"$object->qtyInvoiced",
                    'unit_price'=>"$object->unitPrice",
                    'line_discount'=>"$object->lineDiscount",
                    'global_discount'=>"$object->globalDiscount",
                    'line_discount_percentage'=>"$object->lineDiscountPercentage",
                    'vat_amount'=>"$object->vatAmount",
                    'pricetype_id'=>"$object->priceTypeID",
                    'vat_id'=>"$object->vatID",
                    'serialnumber'=>"$object->serialNumber",
                    'description'=>"$object->description",
                    'cost'=>"$object->cost"
                );
                break;
            case 'Invoices':
                $array  = array(
                    'invoice_code'=>"$object->invoiceCode",
                    'company_id'=>"$object->companyID",
                    'customer_id'=>"$object->customerID",
                    'salesperson_id'=>"$object->salespersonID",
                    'paymenttype_id'=>"$object->paymentTypeID",
                    'order_id'=>"$object->orderID",
                    'tender_id'=>"$object->tenderID",
                    'subtotal'=>"$object->subTotal",
                    'grand_total'=>"$object->grandTotal",
                    'vat_amount'=>"$object->vatAmount",
                    'vat_i_e'=>"$object->vatIorE",
                    'discount_amount'=>"$object->discountAmount",
                    'invoice_address_id'=>"$object->invoiceAddressID",
                    'delivery_address_id'=>"$object->deliveryAddressID",
                    'print_count'=>"$object->printCount",
                    'invoice_date'=>"$object->invoiceDate",
                    'details'=>"$object->details",
                    'invoice_type'=>"$object->invoiceType",
                    'due_date'=>"$object->dueDate",
                    'status'=>"$object->status",
                    'currency_id'=>"$object->currencyID",
                    'global_discount_percentage'=>"$object->globalDiscountPercentage",
                    'action_hash'=>"$object->actionHash",
                    'action_time'=>"$object->actionTime"
                );
                break;
            case 'Invoice_Item':
                $array  = array(
                    'invoice_id'=>"$object->invoiceID",
                    'item_id'=>"$object->itemID",
                    'batch_number'=>"$object->batchNumber",
                    'warehouse_id'=>"$object->warehouseID",
                    'qty'=>"$object->qty",
                    'unit_price'=>"$object->unitPrice",
                    'line_discount'=>"$object->lineDiscount",
                    'global_discount'=>"$object->globalDiscount",
                    'line_discount_percentage'=>"$object->lineDiscountPercentage",
                    'vat_amount'=>"$object->vatAmount",
                    'pricetype_id'=>"$object->priceTypeID",
                    'vat_id'=>"$object->vatID",
                    'serialnumber'=>"$object->serialNumber",
                    'description'=>"$object->description",
                    'cost'=>"$object->cost",
                    'promotion_id'=>"$object->promotionID",
                    'promotion_number'=>"$object->promotionNumber",
                    'master_item'=>"$object->masterItem",
                );
                break;
            case 'Returns':
                $array  = array(
                    'return_code'=>"$object->returnCode",
                    'company_id'=>"$object->companyID",
                    'customer_id'=>"$object->customerID",
                    'salesperson_id'=>"$object->salespersonID",
                    'paymenttype_id'=>"$object->paymentTypeID",
                    'order_id'=>"$object->orderID",
                    'subtotal'=>"$object->subTotal",
                    'grand_total'=>"$object->grandTotal",
                    'vat_amount'=>"$object->vatAmount",
                    'vat_i_e'=>"$object->vatIorE",
                    'discount_amount'=>"$object->discountAmount",
                    'return_address_id'=>"$object->returnAddressID",
                    'print_count'=>"$object->printCount",
                    'return_date'=>"$object->returnDate",
                    'details'=>"$object->details",
                    'status'=>"$object->status",
                    'currency_id'=>"$object->currencyID",
                    'global_discount_percentage'=>"$object->globalDiscountPercentage",
                    'return_type'=>"$object->returnType",
                    'action_hash'=>"$object->actionHash",
                    'action_time'=>"$object->actionTime"
                );
                break;
            case 'Return_Item':
                $array  = array(
                    'return_id'=>"$object->returnID",
                    'item_id'=>"$object->itemID",
                    'batch_number'=>"$object->batchNumber",
                    'warehouse_id'=>"$object->warehouseID",
                    'qty'=>"$object->qty",
                    'unit_price'=>"$object->unitPrice",
                    'line_discount'=>"$object->lineDiscount",
                    'global_discount'=>"$object->globalDiscount",
                    'line_discount_percentage'=>"$object->lineDiscountPercentage",
                    'vat_amount'=>"$object->vatAmount",
                    'pricetype_id'=>"$object->priceTypeID",
                    'vat_id'=>"$object->vatID",
                    'serialnumber'=>"$object->serialNumber",
                    'description'=>"$object->description",
                    'status'=>"$object->status",
                    'cost'=>"$object->cost",

                );
                break;
            case 'Receipts':
                $array  = array(
                    'receipt_code'=>"$object->receiptCode",
                    'customer_id'=>"$object->customerID",
                    'company_id'=>"$object->companyID",
                    'salesperson_id'=>"$object->salesPersonID",
                    'order_id'=>"$object->orderID",
                    'invoice_id'=>"$object->invoiceID",
                    'address_id'=>"$object->addressID",
                    'amount'=>"$object->amount",
                    'payment_method'=>"$object->paymentMethod",
                    'cash_discount'=>"$object->cashDiscount",
                    'bank'=>"$object->bank",
                    'branch'=>"$object->branch",
                    'cheque_number'=>"$object->chequeNumber",
                    'cheque_date'=>"$object->chequeDate",
                    'receipt_date'=>"$object->receiptDate",
                    'notes'=>"$object->notes",
                    'status'=>"$object->status",
                    'action_hash'=>"$object->actionHash",
                    'action_time'=>"$object->actionTime"
                );
                break;
            case 'Receipt_Item':
                $array  = array(
                    'receipt_id'=>"$object->receiptID",
                    'amount'=>"$object->amount",
                    'payment_method'=>"$object->paymentMethod",
                    'cash_discount'=>"$object->cashDiscount",
                    'bank'=>"$object->bank",
                    'branch'=>"$object->branch",
                    'cheque_number'=>"$object->chequeNumber",
                    'cheque_date'=>"$object->chequeDate",
                    'notes'=>"$object->notes"
                );
                break;
            case 'Warehouse_Transactions':
                $array  = array(
                    'warehouse_transaction_code'=>"$object->warehouseTransactionCode",
                    'warehouse_id_from'=>"$object->warehouseIdFrom",
                    'warehouse_id_to'=>"$object->warehouseIdTo",
                    'company_id'=>"$object->companyID",
                    'salesperson_id'=>"$object->salespersonID",
                    'type'=>"$object->type",
                    'transaction_date'=>"$object->transactionDate",
                    'details'=>"$object->details",
                    'action_hash'=>"$object->actionHash",
                    'action_time'=>"$object->actionTime"
                );
                break;
            case 'Warehouse_Transaction_Item':
                $array  = array(
                    'warehouse_transaction_id'=>"$object->warehouseTransactionID",
                    'item_id'=>"$object->itemID",
                    'batch_number'=>"$object->batchNumber",
                    'warehouse_id'=>"$object->warehouseID",
                    'qty'=>"$object->qty",
                    'serialnumber'=>"$object->serialNumber"
                );
                break;
            default:
                $array = array();
                break;
        }

        return $array;
    }

    public function createObjectByDbCall($table,$object,$includeItems=false){
        switch ($table){
            case 'Orders':
                $docObject = new Order(
                    $orderID            = "$object->order_id",
                    $orderCode          = "$object->order_code",
                    $companyID          = "$object->company_id",
                    $customerID         = "$object->customer_id",
                    $salespersonID      = "$object->salesperson_id",
                    $paymentTypeID      = "$object->paymenttype_id",
                    $orderDate          = "$object->order_date",
                    $subTotal           = "$object->subtotal",
                    $grandTotal         = "$object->grand_total",
                    $vatAmount          = "$object->vat_amount",
                    $discountAmount     = "$object->discount_amount",
                    $printCount         = "$object->print_count",
                    $orderAddressID     = "$object->order_address_id",
                    $deliveryAddressID  = "$object->delivery_address_id	",
                    $tenderID           = "$object->tender_id",
                    $vatIorE            = "$object->vat_i_or_e",
                    $deliveryDate       = "$object->delivery_date",
                    $depositAmount      = "$object->deposit_amount",
                    $details            = "$object->details",
                    $status             = "$object->status",
                    $currencyID         = "$object->currency_id",
                    $globalDiscPercent  = "$object->global_discount_percentage",
                    $deliveryMethod     = "$object->delivery_method",
                    $onlineOrderID      = "$object->online_order_id",
                    $actionHash         = "$object->action_hash",
                    $actionTime         = "$object->action_time",
                    $orderItems         = array()
                );

                if($includeItems){
                    $items = $this->search('Order_Item', array('order_id'=>"$object->order_id"));
                    foreach($items as $item){
                        $docObject->addOrderItem(
                            new OrderItem(
                                $orderItemID            = "$item->order_item_id",
                                $orderID                = "$item->order_id",
                                $itemID                 = "$item->item_id",
                                $qty                    = "$item->qty",
                                $qtyPicked              = "$item->qty_picked",
                                $qtyDelivered           = "$item->qty_delivered",
                                $qtyInvoiced            = "$item->qty_invoiced",
                                $unitPrice              = "$item->unit_price",
                                $lineDiscount           = "$item->line_discount",
                                $globalDiscount         = "$item->global_discount",
                                $lineDiscountPercentage = "$item->line_discount_percentage",
                                $vatAmount              = "$item->vat_amount",
                                $priceTypeID            = "$item->pricetype_id",
                                $vatID                  = "$item->vat_id",
                                $description            = "$item->description",
                                $promotionID            = "$item->promotion_id",
                                $promotionNumber        = "$item->promotion_number",
                                $masterItem             = "$item->master_item"
                            )
                        );
                    }
                }

                break;
            case 'Tenders':
                $docObject = new Tender(
                    $tenderID           = "$object->tender_id",
                    $tenderCode         = "$object->tender_code",
                    $companyID          = "$object->company_id",
                    $salesPersonID      = "$object->salesperson_id",
                    $customerID         = "$object->customer_id",
                    $tenderDate         = "$object->tender_date",
                    $validUntil         = "$object->valid_until",
                    $name               = "$object->name",
                    $addressLine1       = "$object->address_line_1",
                    $addressLine2       = "$object->address_line_2",
                    $city               = "$object->city",
                    $country            = "$object->country",
                    $region             = "$object->region",
                    $subTotal           = "$object->subtotal	",
                    $grandTotal         = "$object->grand_total",
                    $vatAmount          = "$object->vat_amount",
                    $discountAmount     = "$object->discount_amount",
                    $status             = "$object->status",
                    $vatIorE            = "$object->vat_i_e",
                    $printCount         = "$object->print_count",
                    $details            = "$object->details",
                    $currencyID         = "$object->currency_id",
                    $deliveryMethod     = "$object->delivery_method",
                    $globalDiscPercent  = "$object->global_discount_percentage",
                    $currentVersion     = "$object->current_version",
                    $editedBy           = "$object->edited_by",
                    $actionHash         = "$object->action_hash",
                    $actionTime         = "$object->action_time",
                    $orderItems         = array()
                );

                if($includeItems){
                    $items = $this->search('Tender_Item', array('tender_id'=>"$object->tender_id"));
                    foreach($items as $item){
                        $docObject->addTenderItem(
                            new TenderItem(
                                $tenderItemID           = "$item->tender_item_id",
                                $tenderID               = "$item->tender_id",
                                $itemID                 = "$item->item_id",
                                $qty                    = "$item->qty",
                                $unitPrice              = "$item->unit_price",
                                $lineDiscount           = "$item->line_discount",
                                $globalDiscount         = "$item->global_discount",
                                $lineDiscountPercentage = "$item->line_discount_percentage",
                                $vatAmount              = "$item->vat_amount",
                                $priceTypeID            = "$item->pricetype_id",
                                $vatID                  = "$item->vat_id",
                                $description            = "$item->description",
                                $promotionID            = "$item->promotion_id",
                                $promotionNumber        = "$item->promotion_number",
                                $masterItem             = "$item->master_item"

                            )
                        );
                    }
                }

                break;
            case 'Waybills':
                $docObject = new Waybill(
                    $waybillID          = "$object->waybill_id",
                    $waybillCode        = "$object->waybill_code",
                    $companyID          = "$object->company_id",
                    $customerID         = "$object->customer_id",
                    $salespersonID      = "$object->salesperson_id",
                    $paymentTypeID      = "$object->paymenttype_id",
                    $orderID            = "$object->order_id",
                    $tenderID           = "$object->tender_id",
                    $subTotal           = "$object->subtotal",
                    $grandTotal         = "$object->grand_total",
                    $vatAmount          = "$object->vat_amount",
                    $vatIorE            = "$object->vat_i_e",
                    $discountAmount     = "$object->discount_amount",
                    $waybillAddressID   = "$object->waybill_address_id",
                    $deliveryAddressID  = "$object->delivery_address_id",
                    $printCount         = "$object->print_count",
                    $waybillDate        = "$object->waybill_date",
                    $details            = "$object->details",
                    $status             = "$object->status",
                    $currencyID         = "$object->currency_id",
                    $globalDiscPercent  = "$object->global_discount_percentage",
                    $actionHash         = "$object->action_hash",
                    $actionTime         = "$object->action_time",
                    $waybillItems       = array()
                );

                if($includeItems){
                    $items = $this->search('Waybill_Item', array('waybill_id'=>"$object->waybill_id"));
                    foreach($items as $item){
                        $docObject->addWaybillItem(
                            new WaybillItem(
                                $waybillItemID   = "$item->waybill_item_id",
                                $waybillID       = "$item->waybill_id",
                                $itemID          = "$item->item_id",
                                $batchNumber     = "$item->batch_number",
                                $warehouseID     = "$item->warehouse_id",
                                $qty             = "$item->qty",
                                $qtyInvoiced     = "$item->qty_invoiced",
                                $unitPrice       = "$item->unit_price",
                                $lineDiscount    = "$item->line_discount",
                                $globalDiscount  = "$item->global_discount",
                                $lineDiscPercent = "$item->line_discount_percentage",
                                $vatAmount       = "$item->vat_amount",
                                $priceTypeID     = "$item->pricetype_id",
                                $vatID           = "$item->vat_id",
                                $serialNumber    = "$item->serialnumber",
                                $description     = "$item->description",
                                $cost            = "$item->cost"
                            )
                        );
                    }
                }

                break;
            case 'Invoices':
                $docObject = new Invoice(
                    $invoiceID         = "$object->invoice_id",
                    $invoiceCode       = "$object->invoice_code",
                    $companyID         = "$object->company_id",
                    $customerID        = "$object->customer_id",
                    $salespersonID     = "$object->salesperson_id",
                    $paymentTypeID     = "$object->paymenttype_id",
                    $orderID           = "$object->order_id",
                    $tenderID          = "$object->tender_id",
                    $subTotal          = "$object->subtotal",
                    $grandTotal        = "$object->grand_total",
                    $vatAmount         = "$object->vat_amount",
                    $vatIorE           = "$object->vat_i_e",
                    $discountAmount    = "$object->discount_amount",
                    $invoiceAddressID  = "$object->invoice_address_id",
                    $deliveryAddressID = "$object->delivery_address_id",
                    $printCount        = "$object->print_count",
                    $invoiceDate       = "$object->invoice_date",
                    $details           = "$object->details",
                    $invoiceType       = "$object->invoice_type",
                    $dueDate           = "$object->due_date",
                    $status            = "$object->status",
                    $currencyID        = "$object->currency_id",
                    $globalDiscPercent = "$object->global_discount_percentage",
                    $actionHash        = "$object->action_hash",
                    $actionTime        = "$object->action_time",
                    $invoiceItems      = array()
                );

                if($includeItems){
                    $items = $this->search('Invoice_Item', array('invoice_id'=>"$object->invoice_id"));
                    foreach($items as $item){
                        $docObject->addInvoiceItem(
                            new InvoiceItem(
                                $invoiceItemID   = "$item->invoice_item_id",
                                $invoiceID       = "$item->invoice_id",
                                $itemID          = "$item->item_id",
                                $batchNumber     = "$item->batch_number",
                                $warehouseID     = "$item->warehouse_id",
                                $qty             = "$item->qty",
                                $unitPrice       = "$item->unit_price",
                                $lineDiscount    = "$item->line_discount",
                                $globalDiscount  = "$item->global_discount",
                                $lineDiscPercent = "$item->line_discount_percentage",
                                $vatAmount       = "$item->vat_amount",
                                $priceTypeID     = "$item->pricetype_id",
                                $vatID           = "$item->vat_id",
                                $serialNumber    = "$item->serialnumber",
                                $description     = "$item->description",
                                $cost            = "$item->cost",
                                $promotionID     = "$item->promotion_id",
                                $promotionNumber = "$item->promotion_number",
                                $masterItem      = "$item->master_item"

                            )
                        );
                    }
                }

                break;
            case 'Returns':
                $docObject = new SalesReturn(
                    $returnID          = "$object->return_id",
                    $returnCode        = "$object->return_code",
                    $companyID         = "$object->company_id",
                    $customerID        = "$object->customer_id",
                    $salespersonID     = "$object->salesperson_id",
                    $paymentTypeID     = "$object->paymenttype_id",
                    $orderID           = "$object->order_id",
                    $subTotal          = "$object->subtotal",
                    $grandTotal        = "$object->grand_total",
                    $vatAmount         = "$object->vat_amount",
                    $vatIorE           = "$object->vat_i_e",
                    $discountAmount    = "$object->discount_amount",
                    $returnAddressID   = "$object->return_address_id",
                    $printCount        = "$object->print_count",
                    $returnDate        = "$object->return_date",
                    $details           = "$object->details",
                    $status            = "$object->status",
                    $currencyID        = "$object->currency_id",
                    $globalDiscPercent = "$object->global_discount_percentage",
                    $returnType        = "$object->return_type",
                    $actionHash        = "$object->action_hash",
                    $actionTime        = "$object->action_time",
                    $invoiceItems      = array()
                );

                if($includeItems){
                    $items = $this->search('Return_Item', array('return_id'=>"$object->return_id"));
                    foreach($items as $item){
                        $docObject->addReturnItem(
                            new ReturnItem(
                                $invoiceItemID   = "$item->return_item_id",
                                $invoiceID       = "$item->return_id",
                                $itemID          = "$item->item_id",
                                $batchNumber     = "$item->batch_number",
                                $warehouseID     = "$item->warehouse_id",
                                $qty             = "$item->qty",
                                $unitPrice       = "$item->unit_price",
                                $lineDiscount    = "$item->line_discount",
                                $globalDiscount  = "$item->global_discount",
                                $lineDiscPercent = "$item->line_discount_percentage",
                                $vatAmount       = "$item->vat_amount",
                                $priceTypeID     = "$item->pricetype_id",
                                $vatID           = "$item->vat_id",
                                $serialNumber    = "$item->serialnumber",
                                $description     = "$item->description",
                                $status          = "$item->status",
                                $cost            = "$item->cost"
                            )
                        );
                    }
                }

                break;
            case 'Receipts':
                $docObject = new Receipt(
                    $receiptID     = "$object->receipt_id",
                    $receiptCode   = "$object->receipt_code",
                    $customerID    = "$object->customer_id",
                    $companyID     = "$object->company_id",
                    $salesPersonID = "$object->salesperson_id",
                    $orderID       = "$object->order_id",
                    $invoiceID     = "$object->invoice_id",
                    $addressID     = "$object->address_id",
                    $amount        = "$object->amount",
                    $paymentMethod = "$object->payment_method",
                    $cashDiscount  = "$object->cash_discount",
                    $bank          = "$object->bank",
                    $branch        = "$object->branch",
                    $chequeNumber  = "$object->cheque_number",
                    $chequeDate    = "$object->cheque_date",
                    $receiptDate   = "$object->receipt_date",
                    $notes         = "$object->notes",
                    $status        = "$object->status",
                    $actionHash    = "$object->action_hash",
                    $actionTime    = "$object->action_time",
                    $receiptItems  = array()
                );

                if($includeItems){
                    $items = $this->search('Receipt_Item', array('receipt_id'=>"$object->receipt_id"));
                    foreach($items as $item){
                        $docObject->addReceiptItem(
                            new ReceiptItem(
                                $receiptItemID = "$item->receipt_item_id",
                                $receiptID     = "$item->receipt_id",
                                $amount        = "$item->amount",
                                $paymentMethod = "$item->payment_method",
                                $cashDiscount  = "$item->cash_discount",
                                $bank          = "$item->bank",
                                $branch        = "$item->branch",
                                $chequeNumber  = "$item->cheque_number",
                                $chequeDate    = "$item->cheque_date",
                                $notes         = "$item->notes"

                            )
                        );
                    }
                }

                break;
            case 'Warehouse_Transactions':
                $docObject = new WarehouseTransaction(
                    $warehouseTransactionID     = "$object->warehouse_transaction_id",
                    $warehouseTransactionCode   = "$object->warehouse_transaction_code",
                    $warehouseIdFrom            = "$object->warehouse_id_from",
                    $warehouseIdTo              = "$object->warehouse_id_to",
                    $companyID                  = "$object->company_id",
                    $salespersonID              = "$object->salesperson_id",
                    $type                       = "$object->type",
                    $transactionDate            = "$object->transaction_date",
                    $details                    = "$object->details",
                    $actionHash                 = "$object->action_hash",
                    $actionTime                 = "$object->action_time",
                    $warehouseTransactionItems  = array()
                );

                if($includeItems){
                    $items = $this->search('Warehouse_Transaction_Item', array('warehouse_transaction_id'=>"$object->warehouse_transaction_id"));
                    foreach($items as $item){
                        $docObject->addWarehouseTransactionItem(
                            new WarehouseTransactionItem(
                                $warehouseTransactionItemID = "$item->warehouse_transaction_item_id",
                                $warehouseTransaction       = "$item->warehouse_transaction_id",
                                $itemID                     = "$item->item_id",
                                $batchNumber                = "$item->batch_number",
                                $warehouseID                = "$item->warehouse_id",
                                $qty                        = "$item->qty",
                                $serialNumber               = "$item->serialnumber"

                            )
                        );
                    }
                }

                break;
            default:
                $docObject = false;
                break;

        }

        return $docObject;
    }


    /** Coprime Internal Connection Methods */
    public function updateItemVatByObject($item,$vat){

        $object = null;
        $errorCode = null;
        $errorStatus = null;
        $errorMessage = "[" . date('Y-m-d H:i:s') . "] ";

        $verbalTable  = 'Item';



        if(strcmp(trim($item->itemID),'')!=0 && $this->checkExist('Items',array('item_id'=>$item->itemID))) {
            if(strcmp(trim($vat->vatID),'')!=0 && $this->checkExist('Vats',array('vat_id'=>$vat->vatID))) {


                if ($item->itemID > 0) {
                    if ($this->update('Items', array('vat_id'=>$vat->vatID), "item_id", $item->itemID)) {
                        $errorCode = 0;
                        $errorStatus = "OK";
                        $errorMessage .= "Update $verbalTable $item->itemCode [$item->itemID] Set Vat $vat->vatCode [$vat->vatID]";
                    } else {
                        $errorCode = 1;
                        $errorStatus = "ERROR";
                        $errorMessage .= $this->getErrorMessage();
                    }
                    $object = $this->getData();
                } else {
                    $errorCode = 1;
                    $errorStatus = "ERROR";
                    $errorMessage .= " error Update $verbalTable $item->itemCode Empty ID [Item_id = $item->itemID]";
                    $object = $this->getData();
                }
            } else {
                $errorCode = 1;
                $errorStatus = "NOTICE";
                $errorMessage .= " VAT Missing On $verbalTable  $item->itemCode No Record Changed";
                $object = $this->getData();
            }
        } else {
            $errorCode = 1;
            $errorStatus = "ERROR";
            $errorMessage .= " error Update $verbalTable $item->itemCode Empty ID [Item_id = $item->itemID]";
            $object = $this->getData();
        }

        $result['response']['code']=$errorCode;
        $result['response']['status']=$errorStatus;
        $result['response']['message']=$errorMessage;
        $result['data']=$object;

        $response['Item Vat'] = $result['response']['message'] . " - " . $result['response']['status'] . "\n";
        return $response;

    }

    public function updateCustomerByObjectID($customer,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        $addCustomerArray  = $this->mapArrayToObject('Customers',$customer);
        $editCustomerArray = $this->excludeUpdateColumnsOfArray('Customers',$addCustomerArray,$excludeUpdateColumns);

        if(!empty($addCustomerArray)) {

            $query = $this->insertUpdateRecordByFilter('Customers', 'customer_id', 'customer_id', "$customer->customerID", $editCustomerArray, $addCustomerArray, 'Customer');

            $customerResult = $query['data'];
            $response['Customers'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

        } else {
            $response['Customers'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [Customers]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }

        if($deleteRecordsNotSent['CustomerAddress'] == true) {
            $existingCustomerAddresses = $this->compactQuery('CustomerAddress', 'customer_id', $customerResult->customer_id, 'customer_address_id,address_code');
        }

        if($deleteRecordsNotSent['CustomerGroups'] == true) {
            $existingCustomerGroups = $this->compactQuery('Customer_CustomersGroup', 'customer_id', $customerResult->customer_id, 'group_id');
        }

        $newCustomerAddresses = array();
        foreach($customer->customerAddresses as $address){

            $address->customer_id = $customerResult->customer_id;
            $addAddressArray  = $this->mapArrayToObject('CustomerAddress',$address);
            $editAddressArray = $this->excludeUpdateColumnsOfArray('CustomerAddress',$addAddressArray,$excludeUpdateColumns);

            if(!empty($addAddressArray)) {
                $query = $this->insertUpdateRecordByFilter('CustomerAddress', 'customer_address_id', 'address_code', $addAddressArray['address_code'], $editAddressArray, $addAddressArray, 'Customer Address');
                $addressResult = $query['data'];
                array_push($newCustomerAddresses,$addressResult->customer_address_id);

                $response['Customers'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

            } else {
                $response['Customers'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [CustomerAddress]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
            }

        }

        if($deleteRecordsNotSent['CustomerAddress'] == true) {
            foreach ($existingCustomerAddresses as $existingCustomerAddress) {
                if(!in_array($existingCustomerAddress->customer_address_id,$newCustomerAddresses)){
                    $query = $this->deleteRecordByID('CustomerAddress','customer_address_id',$existingCustomerAddress->customer_address_id,$insertDeleteStatement = true,$verbalTable = 'Customer Address '.$existingCustomerAddress->address_code);
                    $response['Customers'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                }
            }
        }

        $newCustomerGroups = array();
        foreach($customer->customerGroups as $group){

            $addGroupArray  = $this->mapArrayToObject('CustomerGroups',$group);
            $editGroupArray = $this->excludeUpdateColumnsOfArray('CustomerGroups',$addGroupArray,$excludeUpdateColumns);

            if(!empty($addGroupArray)) {
                $query = $this->insertUpdateRecordByFilter('CustomerGroups', 'group_id', 'group_code', $addGroupArray['group_code'], $editGroupArray, $addGroupArray, 'Customer Group');
                $groupResult = $query['data'];
                array_push($newCustomerGroups,$groupResult->group_id);

                $response['Customers'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                $groupResult = $query['data'];

                if(strcmp($groupResult->group_id,'')!=0) {
                    $updateColumnValues = array('timestamp' => date('Y-m-d H:i:s'));
                    $insertColumnValues = array('added_date' => date('Y-m-d'), 'salesperson_id' => '0');
                    $idColumnValues = array('group_id' => "$groupResult->group_id", 'customer_id' => "$customerResult->customer_id");

                    $query = $this->insertUpdateLinkedTable('Customer_CustomersGroup', $insertColumnValues, $updateColumnValues, $idColumnValues);
                    $response['Customers'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                    $customerInGroupResult = $query['data'];
                }

            } else {
                $response['Customers'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [CustomerGroups]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
            }
        }

        if($deleteRecordsNotSent['CustomerGroups'] == true) {
            foreach ($existingCustomerGroups as $existingCustomerGroup) {
                if(!in_array($existingCustomerGroup->group_id,$newCustomerGroups)){
                    $query = $this->deleteRecordByMultipleIDs('Customer_CustomersGroup', array('customer_id'=>"$customerResult->customer_id",'group_id'=>"$existingCustomerGroup->group_id"),$insertDeleteStatement = true,$verbalTable = 'Customer From Group [customer_id = '.$customerResult->customer_id.' AND group_id='.$existingCustomerGroup->group_id.']');
                    $response['Customers'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                }
            }
        }

        return $response;
    }

    public function insertUpdateCategoryByObject($category,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){
        $response = null;

        $addArray  = $this->mapArrayToObject('Categories',$category);
        $editArray = $this->excludeUpdateColumnsOfArray('Categories',$addArray,$excludeUpdateColumns);

        if(!empty($addArray)) {

            $query = $this->insertUpdateRecordByFilter('Categories', 'category_id', 'category_code', $addArray['category_code'], $editArray, $addArray, 'Category');
            $categoryResult = $query['data'];
            $response['Categories'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

        } else {
            $response['Categories'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [Categories]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }

        if($deleteRecordsNotSent['Subcategories'] == true) {
            $existingSubCategories = $this->compactQuery('Subcategories', 'category_id', $categoryResult->category_id, 'subcategory_id');
        }

        $newSubCategories = array();
        foreach($category->subCategories as $subCategory){

            $addSubCategoryArray  = $this->mapArrayToObject('Categories',$subCategory);
            $editSubCategoryArray = $this->excludeUpdateColumnsOfArray('Categories',$addSubCategoryArray,$excludeUpdateColumns);

            if(!empty($addSubCategoryArray)) {

                $query = $this->insertUpdateRecordByFilter('Categories', 'category_id', 'category_code', $addSubCategoryArray['category_code'], $editSubCategoryArray, $addSubCategoryArray, 'Category');
                $subCategoryResult = $query['data'];
                $response['Categories'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

                $updateColumnValues = array('timestamp'=>'now()');
                $insertColumnValues = array('date_added'=>date('y-m-d'));
                $idColumnValues     = array('category_id'=>"$categoryResult->category_id",'subcategory_id'=>"$subCategoryResult->category_id");

                $query = $this->insertUpdateLinkedTable('Subcategories',$insertColumnValues, $updateColumnValues, $idColumnValues);
                $response['Subcategories'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

                array_push($newSubCategories,$subCategoryResult->category_id);

            } else {
                $response['Categories'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [Categories]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
            }
        }

        if($deleteRecordsNotSent['Subcategories'] == true) {
            foreach ($existingSubCategories as $existingSubCategory) {
                if(!in_array($existingSubCategory->category_id,$newSubCategories)){
                    $query = $this->deleteRecordByMultipleIDs('Subcategories', array('category_id'=>"$categoryResult->category_id",'subcategory_id'=>"$existingSubCategory->subcategory_id"),$insertDeleteStatement = true,$verbalTable = ' SubCategory [category_id = '.$categoryResult->category_id.' AND subcategory_id='.$existingSubCategory->subcategory_id.']');
                    $response['Subcategories'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                }
            }
        }

        return $response;
    }

    public function insertUpdatePriceGroupByObject($priceGroup,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){
        $response = null;

        $addArray  = $this->mapArrayToObject('Price_Group_Definitions',$priceGroup);
        $editArray = $this->excludeUpdateColumnsOfArray('Price_Group_Definitions',$addArray,$excludeUpdateColumns);

        if(!empty($addArray)) {

            $query = $this->insertUpdateRecordByFilter('Price_Group_Definitions', 'price_group_definition_id', 'price_group_code', $addArray['price_group_code'], $editArray, $addArray, 'Price Group');
            $priceGroupResult = $query['data'];
            $response['Price Group'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

        } else {
            $response['Price Group'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [Price Group]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }



        if($deleteRecordsNotSent['Price_Group_Customer'] == true) {
            $existingCustomers = $this->compactQuery('Price_Group_Customer', 'price_group_definition_id', $priceGroupResult->price_group_definition_id, 'customer_id');
        }
        if($deleteRecordsNotSent['Price_Group_Customer_Group'] == true) {
            $existingCustomerGroups = $this->compactQuery('Price_Group_Customer_Group', 'price_group_definition_id', $priceGroupResult->price_group_definition_id, 'customer_group_id');
        }

        if($deleteRecordsNotSent['Price_Group_Rules'] == true) {
            $existingGroupRules = $this->compactQuery('Price_Group_Rules', 'price_group_definition_id', $priceGroupResult->price_group_definition_id, 'price_group_rule_id');
        }

        $newGroupRules = array();
        foreach($priceGroup->priceGroupRules as $priceGroupRule){

            $priceGroupRule->priceGroupDefinitionID = $priceGroupResult->price_group_definition_id;
            $addRuleArray  = $this->mapArrayToObject('Price_Group_Rules',$priceGroupRule);
            $editRuleArray = $this->excludeUpdateColumnsOfArray('Price_Group_Rules',$addRuleArray,array());

            if(!empty($addRuleArray)) {

                $query = $this->insertUpdateRecordByFilter('Price_Group_Rules', 'price_group_rule_id', 'price_group_definition_id', $addRuleArray['price_group_definition_id'], $editRuleArray, $addRuleArray, 'Price Group Rule');
                $priceGroupRulesResult = $query['data'];
                $response['Price Group Rules'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

            } else {
                $response['Price Group'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [Price Group Rules]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
            }

            array_push($newGroupRules,$priceGroupRulesResult->price_group_rule_id);


        }


        $newCustomers = array();
        foreach($priceGroup->customers as $customer){


            $updateColumnValues = array('timestamp'=>'now()');
            $insertColumnValues = array('timestamp'=>'now()');
            $idColumnValues     = array('price_group_definition_id'=>"$priceGroupResult->price_group_definition_id",'customer_id'=>"$customer->customerID");

            $query = $this->insertUpdateLinkedTable('Price_Group_Customer',$insertColumnValues, $updateColumnValues, $idColumnValues, 'Price Group Customer');
            $response['Price_Group_Customer'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

            array_push($newCustomers,$customer->customerID);


        }

        $newCustomerGroups = array();
        foreach($priceGroup->customerGroups as $customerGroup){


            $updateColumnValues = array('timestamp'=>'now()');
            $insertColumnValues = array('timestamp'=>'now()');
            $idColumnValues     = array('price_group_definition_id'=>"$priceGroupResult->price_group_definition_id",'customer_group_id'=>"$customerGroup->groupID");

            $query = $this->insertUpdateLinkedTable('Price_Group_Customer_Group',$insertColumnValues, $updateColumnValues, $idColumnValues,"Price Group Customer Group");
            $response['Price_Group_Customer_Group'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

            array_push($newCustomerGroups,$customerGroup->groupID);


        }

        if($deleteRecordsNotSent['Price_Group_Customer'] == true) {
            foreach ($existingCustomers as $existingCustomer) {
                if(!in_array($existingCustomer->customer_id,$newCustomers)){
                    $query = $this->deleteRecordByMultipleIDs('Price_Group_Customer', array('price_group_definition_id'=>"$priceGroupResult->price_group_definition_id",'customer_id'=>"$existingCustomer->customer_id"),$insertDeleteStatement = true,$verbalTable = ' Price Group Customer [price_group_definition_id = '.$priceGroupResult->price_group_definition_id.' AND customer_id='.$existingCustomer->customer_id.']');
                    $response['Price_Group_Customer'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                }
            }
        }

        if($deleteRecordsNotSent['Price_Group_Customer_Group'] == true) {
            foreach ($existingCustomerGroups as $existingCustomerGroup) {
                if(!in_array($existingCustomerGroup->customer_group_id,$newCustomerGroups)){
                    $query = $this->deleteRecordByMultipleIDs('Price_Group_Customer_Group', array('price_group_definition_id'=>"$priceGroupResult->price_group_definition_id",'customer_group_id'=>"$existingCustomerGroup->group_id"),$insertDeleteStatement = true,$verbalTable = ' Price Group Customer Group [price_group_definition_id = '.$priceGroupResult->price_group_definition_id.' AND group_id='.$existingCustomerGroup->customer_group_id.']');
                    $response['Price_Group_Customer_Group'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                }
            }
        }

        if($deleteRecordsNotSent['Price_Group_Rules'] == true) {
            foreach ($existingGroupRules as $existingGroupRule) {
                if(!in_array($existingGroupRule->price_group_rule_id,$newGroupRules)){
                    $query = $this->deleteRecordByMultipleIDs('Price_Group_Rules', array('price_group_definition_id'=>"$priceGroupResult->price_group_definition_id",'price_group_rule_id'=>"$existingGroupRule->price_group_rule_id"),$insertDeleteStatement = true,$verbalTable = ' Price Group Customer Group [price_group_definition_id = '.$priceGroupResult->price_group_definition_id.' AND price_group_rule_id='.$existingGroupRule->price_group_rule_id.']');
                    $response['Price_Group_Customer_Group'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                }
            }
        }

        return $response;
    }

    public function insertUpdateCustomerByObject($customer,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        $addCustomerArray  = $this->mapArrayToObject('Customers',$customer);
        $editCustomerArray = $this->excludeUpdateColumnsOfArray('Customers',$addCustomerArray,$excludeUpdateColumns);

        if(!empty($addCustomerArray)) {

            $query = $this->insertUpdateRecordByFilter('Customers', 'customer_id', 'customer_code', $addCustomerArray['customer_code'], $editCustomerArray, $addCustomerArray, 'Customer');

            $customerResult = $query['data'];
            $response['Customers'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

        } else {
            $response['Customers'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [Customers]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }

        if($deleteRecordsNotSent['CustomerAddress'] == true) {
            $existingCustomerAddresses = $this->compactQuery('CustomerAddress', 'customer_id', $customerResult->customer_id, 'customer_address_id,address_code');
        }

        if($deleteRecordsNotSent['CustomerGroups'] == true) {
            $existingCustomerGroups = $this->compactQuery('Customer_CustomersGroup', 'customer_id', $customerResult->customer_id, 'group_id');
        }

        $newCustomerAddresses = array();
        foreach($customer->customerAddresses as $address){

            $address->customer_id = $customerResult->customer_id;
            $addAddressArray  = $this->mapArrayToObject('CustomerAddress',$address);
            $editAddressArray = $this->excludeUpdateColumnsOfArray('CustomerAddress',$addAddressArray,$excludeUpdateColumns);

            if(!empty($addAddressArray)) {
                $query = $this->insertUpdateRecordByFilter('CustomerAddress', 'customer_address_id', 'address_code', $addAddressArray['address_code'], $editAddressArray, $addAddressArray, 'Customer Address');
                $addressResult = $query['data'];
                array_push($newCustomerAddresses,$addressResult->customer_address_id);

                $response['Customers'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

            } else {
                $response['Customers'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [CustomerAddress]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
            }

        }

        if($deleteRecordsNotSent['CustomerAddress'] == true) {
            foreach ($existingCustomerAddresses as $existingCustomerAddress) {
                if(!in_array($existingCustomerAddress->customer_address_id,$newCustomerAddresses)){
                    $query = $this->deleteRecordByID('CustomerAddress','customer_address_id',$existingCustomerAddress->customer_address_id,$insertDeleteStatement = true,$verbalTable = 'Customer Address '.$existingCustomerAddress->address_code);
                    $response['Customers'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                }
            }
        }

        $newCustomerGroups = array();
        foreach($customer->customerGroups as $group){

            $addGroupArray  = $this->mapArrayToObject('CustomerGroups',$group);
            $editGroupArray = $this->excludeUpdateColumnsOfArray('CustomerGroups',$addGroupArray,$excludeUpdateColumns);

            if(!empty($addGroupArray)) {
                $query = $this->insertUpdateRecordByFilter('CustomerGroups', 'group_id', 'group_code', $addGroupArray['group_code'], $editGroupArray, $addGroupArray, 'Customer Group');
                $groupResult = $query['data'];
                array_push($newCustomerGroups,$groupResult->group_id);

                $response['Customers'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                $groupResult = $query['data'];

                if(strcmp($groupResult->group_id,'')!=0) {
                    $updateColumnValues = array('timestamp' => date('Y-m-d H:i:s'));
                    $insertColumnValues = array('added_date' => date('Y-m-d'), 'salesperson_id' => '0');
                    $idColumnValues = array('group_id' => "$groupResult->group_id", 'customer_id' => "$customerResult->customer_id");

                    $query = $this->insertUpdateLinkedTable('Customer_CustomersGroup', $insertColumnValues, $updateColumnValues, $idColumnValues);
                    $response['Customers'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                    $customerInGroupResult = $query['data'];
                }

            } else {
                $response['Customers'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [CustomerGroups]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
            }
        }

        if($deleteRecordsNotSent['CustomerGroups'] == true) {
            foreach ($existingCustomerGroups as $existingCustomerGroup) {
                if(!in_array($existingCustomerGroup->group_id,$newCustomerGroups)){
                    $query = $this->deleteRecordByMultipleIDs('Customer_CustomersGroup', array('customer_id'=>"$customerResult->customer_id",'group_id'=>"$existingCustomerGroup->group_id"),$insertDeleteStatement = true,$verbalTable = 'Customer From Group [customer_id = '.$customerResult->customer_id.' AND group_id='.$existingCustomerGroup->group_id.']');
                    $response['Customers'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                }
            }
        }

        return $response;
    }

    public function insertUpdateSupplierByObject($supplier,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        $addSupplierArray  = $this->mapArrayToObject('Suppliers',$supplier);
        $editSupplierArray = $this->excludeUpdateColumnsOfArray('Suppliers',$addSupplierArray,$excludeUpdateColumns);

        if(!empty($addSupplierArray)) {

            $query = $this->insertUpdateRecordByFilter('Suppliers', 'customer_id', 'customer_code', $addSupplierArray['customer_code'], $editSupplierArray, $addSupplierArray, 'Supplier');

            $supplierResult = $query['data'];
            $response['Suppliers'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

        } else {
            $response['Suppliers'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [Suppliers]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }

        if($deleteRecordsNotSent['SupplierAddress'] == true) {
            $existingCustomerAddresses = $this->compactQuery('SupplierAddress', 'supplier_id', $supplierResult->customer_id, 'supplier_address_id,address_code');
        }

        $newCustomerAddresses = array();
        foreach($supplier->customerAddresses as $address){

            $address->supplier_id = $supplierResult->customer_id;
            $addAddressArray  = $this->mapArrayToObject('SupplierAddress',$address);
            $editAddressArray = $this->excludeUpdateColumnsOfArray('SupplierAddress',$addAddressArray,$excludeUpdateColumns);

            if(!empty($addAddressArray)) {
                $query = $this->insertUpdateRecordByFilter('SupplierAddress', 'supplier_address_id', 'address_code', $addAddressArray['address_code'], $editAddressArray, $addAddressArray, 'Supplier Address');
                $addressResult = $query['data'];
                array_push($newCustomerAddresses,$addressResult->supplier_address_id);

                $response['Suppliers'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

            } else {
                $response['Suppliers'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [SupplierAddress]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
            }

        }

        if($deleteRecordsNotSent['SupplierAddress'] == true) {
            foreach ($existingCustomerAddresses as $existingCustomerAddress) {
                if(!in_array($existingCustomerAddress->customer_address_id,$newCustomerAddresses)){
                    $query = $this->deleteRecordByID('SupplierAddress','customer_address_id',$existingCustomerAddress->supplier_address_id,$insertDeleteStatement = true,$verbalTable = 'Supplier Address '.$existingCustomerAddress->address_code);
                    $response['Suppliers'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                }
            }
        }


        return $response;
    }

    public function insertUpdateItemByObject($item,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        $addArray  = $this->mapArrayToObject('Items',$item);
        $editArray = $this->excludeUpdateColumnsOfArray('Items',$addArray,$excludeUpdateColumns);

        if(!empty($addArray)) {

            $query = $this->insertUpdateRecordByFilter('Items', 'item_id', 'item_code', $addArray['item_code'], $editArray, $addArray, 'Item');

            $itemResult = $query['data'];
            $response['Items'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

        } else {
            $response['Items'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [Items]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }

        if($deleteRecordsNotSent['Categories'] == true) {
            $existingItemCategories = $this->compactQuery('Category_Item', 'item_id', $itemResult->item_id, 'category_id');
        }

        $newItemCategories = array();
        foreach($item->itemCategories as $category){
            $addCategoryArray  = $this->mapArrayToObject('Categories',$category);
            $editCategoryArray = $this->excludeUpdateColumnsOfArray('Categories',$addCategoryArray,$excludeUpdateColumns);

            if(!empty($addCategoryArray)) {

                $query = $this->insertUpdateRecordByFilter('Categories', 'category_id', 'category_code', $addCategoryArray['category_code'], $editCategoryArray, $addCategoryArray, 'Item Category');
                $categoryResult = $query['data'];
                array_push($newItemCategories,$categoryResult->category_id);

                $response['Items'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

                if(strcmp($categoryResult->category_id,'')!=0) {
                    $updateColumnValues = array('timestamp' => date('Y-m-d H:i:s'));
                    $insertColumnValues = array('position' => '0','timestamp' => date('Y-m-d H:i:s'));
                    $idColumnValues = array('category_id' => "$categoryResult->category_id", 'item_id' => "$itemResult->item_id");

                    $query = $this->insertUpdateLinkedTable('Category_Item', $insertColumnValues, $updateColumnValues, $idColumnValues);
                    $response['Items'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                    $itemInCategoryResult = $query['data'];
                }

            } else {
                $response['Items'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [Categories]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
            }
        }

        if($deleteRecordsNotSent['Categories'] == true) {
            foreach ($existingItemCategories as $existingItemCategory) {
                if(!in_array($existingItemCategory->category_id,$newItemCategories)){
                    $query = $this->deleteRecordByMultipleIDs('Category_Item', array('item_id'=>"$itemResult->item_id",'category_id'=>"$existingItemCategory->category_id"),$insertDeleteStatement = true,$verbalTable = 'Item From Category [item_id = '.$itemResult->item_id.' AND category_id='.$existingItemCategory->category_id.']');
                    $response['Items'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                }
            }
        }


        if($deleteRecordsNotSent['Item_Barcode'] == true) {
            $existingItemBarcodes = $this->compactQuery('Item_Barcode', 'item_id', $itemResult->item_id, 'barcode');
        }

        $newItemBarcodes = array();
        foreach($item->itemBarcodes as $barcode){
            $addBarcodeArray  = $this->mapArrayToObject('Item_Barcode',$barcode);
            $editBarcodeArray = $this->excludeUpdateColumnsOfArray('Item_Barcode',$addBarcodeArray,$excludeUpdateColumns);

            if(!empty($addBarcodeArray)) {

                if(strcmp($barcode->barcode,'')!=0) {
                    $updateColumnValues = array('multiplier' => "$barcode->multiplier", 'default_barcode' => "$barcode->defaultBarcode");
                    $insertColumnValues = array('multiplier' => "$barcode->multiplier", 'default_barcode' => "$barcode->defaultBarcode");
                    $idColumnValues = array('item_id' => "$itemResult->item_id", 'barcode' => "$barcode->barcode");

                    $query = $this->insertUpdateLinkedTable('Item_Barcode', $insertColumnValues, $updateColumnValues, $idColumnValues);
                    $response['Items'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                    $itemBarcodeResult = $query['data'];

                    array_push($newItemBarcodes, $itemBarcodeResult->barcode);
                } else {
                    $response['Items'] .= "[".date('Y-m-d H:i:s')."] Insert Item Barcode [Barcode Empty] No Record Added - NOTICE\n";
                }

            } else {
                $response['Items'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [Item_Barcode]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
            }
        }

        if($deleteRecordsNotSent['Item_Barcode'] == true) {
            foreach ($existingItemBarcodes as $existingItemBarcode) {
                if(!in_array($existingItemBarcode->barcode,$newItemBarcodes)){
                    $query = $this->deleteRecordByMultipleIDs('Item_Barcode', array('item_id'=>"$itemResult->item_id",'barcode'=>"$existingItemBarcode->barcode"),$insertDeleteStatement = true,$verbalTable = 'Item Barcode [item_id = '.$itemResult->item_id.' AND barcode='.$existingItemBarcode->barcode.']');
                    $response['Barcodes'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                }
            }
        }

        return $response;
    }

    public function insertUpdateContactPersonByObject($contactPerson,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        if($this->checkExist("Contact_Person",array('first_name'=> "$contactPerson->firstName",'last_name'=>"$contactPerson->lastName",'customer_id'=>"$contactPerson->customerID"))){
            $contactPerson->id = $this->getData()->contact_person_id;
        } else {
            $contactPerson->id = $this->getNextInsertID('Contact_Person','contact_person_id');
        }

        $idColumnValues = array();
        $tableIDsArray  = array('contact_person_id','customer_id');

        if(!isset($excludeUpdateColumns['Contact_Person'])) {
            $excludeUpdateColumns['Contact_Person'] = array();
        }

        $addArray  = $this->mapArrayToObject('Contact_Person',$contactPerson);
        $editArray = $this->excludeUpdateColumnsOfArray('Contact_Person',$addArray,array_merge($excludeUpdateColumns['Contact_Person'],$tableIDsArray));

        foreach($addArray as $addColumn=>$addID){
            if(in_array($addColumn,$tableIDsArray)){
                $idColumnValues[$addColumn] = $addID;
                unset($addArray[$addColumn]);
            }
        }

        if(!empty($addArray)) {
            if(!empty($idColumnValues)) {
                $query = $this->insertUpdateLinkedTable('Contact_Person', $addArray, $editArray, $idColumnValues, $verbalTable = 'Contact Person');

                $contactPersonResult = $query['data'];
                $response['Contact_Person'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
            } else {
                $response['Contact_Person'] .= "[".date('Y-m-d H:i:s')."] Error Empty IDs - ERROR\n";
            }
        } else {
            $response['Contact_Person'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [Contact_Persons]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }



        return $response;

    }

    public function insertUpdatePriceTypeByObject($priceType,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        $addArray  = $this->mapArrayToObject('PriceTypes',$priceType);
        $editArray = $this->excludeUpdateColumnsOfArray('PriceTypes',$addArray,$excludeUpdateColumns);

        if(!empty($addArray)) {

            $query = $this->insertUpdateRecordByFilter('PriceTypes', 'pricetype_id', 'price_code', $addArray['price_code'], $editArray, $addArray, 'PriceType');

            $priceTypeResult = $query['data'];
            $response['PriceTypes'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

        } else {
            $response['PriceTypes'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [PriceTypes]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }



        return $response;
    }

    public function insertUpdatePaymentTermsByObject($paymentTerm,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        $addArray  = $this->mapArrayToObject('Payment_Terms',$paymentTerm);
        $editArray = $this->excludeUpdateColumnsOfArray('Payment_Terms',$addArray,$excludeUpdateColumns);

        if(!empty($addArray)) {

            $query = $this->insertUpdateRecordByFilter('Payment_Terms', 'payment_term_id', 'payment_term_code', $addArray['payment_term_code'], $editArray, $addArray, 'Payment Term');

            $paymentTermResult = $query['data'];
            $response['Payment Terms'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

        } else {
            $response['Payment Terms'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [Payment Terms]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }



        return $response;
    }

    public function insertUpdateStockByObject($stock,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        $idColumnValues = array();
        $tableIDsArray  = array('warehouse_id','item_id','batch_number');

        if(!isset($excludeUpdateColumns['Stock'])) {
            $excludeUpdateColumns['Stock'] = array();
        }

        $addArray  = $this->mapArrayToObject('Stock',$stock);
        $editArray = $this->excludeUpdateColumnsOfArray('Stock',$addArray,array_merge($excludeUpdateColumns['Stock'],$tableIDsArray));

        foreach($addArray as $addColumn=>$addID){
            if(in_array($addColumn,$tableIDsArray)){
                $idColumnValues[$addColumn] = $addID;
                unset($addArray[$addColumn]);
            }
        }

        if(!empty($addArray)) {
            if(!empty($idColumnValues)) {
                $query = $this->insertUpdateLinkedTable('Stock', $addArray, $editArray, $idColumnValues, $verbalTable = 'Stock');

                $stockResult = $query['data'];
                $response['Stock'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
            } else {
                $response['Stock'] .= "[".date('Y-m-d H:i:s')."] Error Empty IDs - ERROR\n";
            }
        } else {
            $response['Stock'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [PriceTypes]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }



        return $response;
    }

    public function insertUpdateWarehouseByObject($warehouse,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        $addArray  = $this->mapArrayToObject('Warehouses',$warehouse);
        $editArray = $this->excludeUpdateColumnsOfArray('Warehouses',$addArray,$excludeUpdateColumns);

        if(!empty($addArray)) {

            $query = $this->insertUpdateRecordByFilter('Warehouses', 'warehouse_id', 'warehouse_code', $addArray['warehouse_code'], $editArray, $addArray, 'Warehouse');

            $warehouseResult = $query['data'];
            $response['Warehouses'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

        } else {
            $response['Warehouses'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [Warehouses]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }



        return $response;
    }

    public function insertUpdateItemPriceByObject($itemPrice,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        $idColumnValues = array();
        $tableIDsArray  = array('item_id','pricetype_id');

        if(!isset($excludeUpdateColumns['Prices'])) {
            $excludeUpdateColumns['Prices'] = array();
        }

        $addArray  = $this->mapArrayToObject('Prices',$itemPrice);
        $editArray = $this->excludeUpdateColumnsOfArray('Prices',$addArray,array_merge($excludeUpdateColumns['Prices'],$tableIDsArray));

        foreach($addArray as $addColumn=>$addID){
            if(in_array($addColumn,$tableIDsArray)){
                $idColumnValues[$addColumn] = $addID;
                unset($addArray[$addColumn]);
            }
        }

        if(!empty($addArray)) {
            if(!empty($idColumnValues)) {
                $query = $this->insertUpdateLinkedTable('Prices', $addArray, $editArray, $idColumnValues, $verbalTable = 'Item Price');

                $priceResult = $query['data'];
                $response['Prices'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
            } else {
                $response['Prices'] .= "[".date('Y-m-d H:i:s')."] Error Empty IDs - ERROR\n";
            }
        } else {
            $response['Prices'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [PriceTypes]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }



        return $response;
    }

    public function insertUpdateCustomerPriceListByObject($customerPriceList,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        $idColumnValues = array();
        $tableIDsArray  = array('customer_id','pricetype_id');

        if(!isset($excludeUpdateColumns['Customer_Pricelist'])) {
            $excludeUpdateColumns['Customer_Pricelist'] = array();
        }

        $addArray  = $this->mapArrayToObject('Customer_Pricelist',$customerPriceList);
        $editArray = $this->excludeUpdateColumnsOfArray('Customer_Pricelist',$addArray,array_merge($excludeUpdateColumns['Customer_Pricelist'],$tableIDsArray));

        foreach($addArray as $addColumn=>$addID){
            if(in_array($addColumn,$tableIDsArray)){
                $idColumnValues[$addColumn] = $addID;
                unset($addArray[$addColumn]);
            }
        }

        if(!empty($addArray)) {
            if(!empty($idColumnValues)) {
                $query = $this->insertUpdateLinkedTable('Customer_Pricelist', $addArray, $editArray, $idColumnValues, $verbalTable = 'Customer Price List');

                $priceResult = $query['data'];
                $response['Customer_Pricelist'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
            } else {
                $response['Customer_Pricelist'] .= "[".date('Y-m-d H:i:s')."] Error Empty IDs - ERROR\n";
            }
        } else {
            $response['Customer_Pricelist'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [Customer_Pricelist]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }



        return $response;
    }

    public function insertUpdateVatByObject($vat,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        $addArray  = $this->mapArrayToObject('Vats',$vat);
        $editArray = $this->excludeUpdateColumnsOfArray('Vats',$addArray,$excludeUpdateColumns);

        if(!empty($addArray)) {

            $query = $this->insertUpdateRecordByFilter('Vats', 'vat_id', 'vat_code', $addArray['vat_code'], $editArray, $addArray, 'Vat');

            $vatResult = $query['data'];
            $response['Vats'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

        } else {
            $response['Vats'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [Vats]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }



        return $response;
    }

    public function insertUpdateBankByObject($bank,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        $addArray  = $this->mapArrayToObject('Banks',$bank);
        $editArray = $this->excludeUpdateColumnsOfArray('Banks',$addArray,$excludeUpdateColumns);

        if(!empty($addArray)) {

            $query = $this->insertUpdateRecordByFilter('Banks', 'bank_id', 'code', $addArray['code'], $editArray, $addArray, 'Bank');

            $bankResult = $query['data'];
            $response['Banks'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

        } else {
            $response['Banks'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [Banks]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }



        return $response;
    }

    public function insertUpdatePaymentTypeByObject($paymentType,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        $addArray  = $this->mapArrayToObject('PaymentTypes',$paymentType);
        $editArray = $this->excludeUpdateColumnsOfArray('PaymentTypes',$addArray,$excludeUpdateColumns);

        if(!empty($addArray)) {

            $query = $this->insertUpdateRecordByFilter('PaymentTypes', 'paymenttype_id', 'paymenttype_code', $addArray['paymenttype_code'], $editArray, $addArray, 'PaymentType');

            $bankResult = $query['data'];
            $response['PaymentTypes'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

        } else {
            $response['PaymentTypes'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [PaymentTypes]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }



        return $response;
    }

    public function insertUpdateCustomerGroupByObject($customerGroup,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){
        $response = null;


        $addArray  = $this->mapArrayToObject('CustomerGroups',$customerGroup);
        $editArray = $this->excludeUpdateColumnsOfArray('CustomerGroups',$addArray,$excludeUpdateColumns);

        if(!empty($addArray)) {

            $query = $this->insertUpdateRecordByFilter('CustomerGroups', 'group_id', 'group_code', $addArray['group_code'], $editArray, $addArray, 'CustomerGroups');

            $Result = $query['data'];
            $response['CustomerGroups'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

        } else {
            $response['CustomerGroups'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [CustomerGroups]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }



        return $response;

    }

    public function insertUpdateScheduleByObject($schedule,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array(),$singleCustomerOnSchedule=true){

        $response = null;

        $addArray  = $this->mapArrayToObject('Schedules',$schedule);
        $editArray = $this->excludeUpdateColumnsOfArray('Schedules',$addArray,$excludeUpdateColumns);

        if(!empty($addArray)) {

            $query = $this->insertUpdateRecordByFilter('Schedules', 'schedule_id', 'name', $addArray['name'], $editArray, $addArray, 'Schedule');

            $scheduleResult = $query['data'];
            $response['Schedules'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

            if($deleteRecordsNotSent['Schedule_Customer'] == true) {
                $existingScheduleCustomers = $this->compactQuery('Schedule_Customer', 'schedule_id', $scheduleResult->schedule_id, 'schedule_customer_id');
            }

            $newScheduleCustomers = array();
            foreach($schedule->scheduleCustomers as $scheduleCustomer){

                $positionCounter++;

                if($singleCustomerOnSchedule){
                    $foreignKeyArray = array('schedule_id'=> "$scheduleResult->schedule_id",'customer_id'=>"$scheduleCustomer->customerID");
                } else {
                    $foreignKeyArray = array('schedule_id'=> "$scheduleResult->schedule_id",'customer_id'=>"$scheduleCustomer->customerID",'appointment_time'=>"$scheduleCustomer->appointmentTime");
                }

                if($this->checkExist("Schedule_Customer",$foreignKeyArray)){
                    $scheduleCustomer->scheduleCustomerID = $this->getData()->schedule_customer_id;
                } else {
                    $scheduleCustomer->scheduleCustomerID = $this->getNextInsertID('Schedule_Customer','schedule_customer_id');
                }
                if(strcmp($scheduleResult->schedule_id,'')!=0) {
                    $updateColumnValues = array('position' => "$scheduleCustomer->position", 'timestamp' => date('Y-m-d H:i:s'));
                    $insertColumnValues = array('position' => "$scheduleCustomer->position");
                    $idColumnValues = array('schedule_customer_id' => "$scheduleCustomer->scheduleCustomerID", 'schedule_id' => "$scheduleResult->schedule_id", 'customer_id' => "$scheduleCustomer->customerID", 'appointment_time' => "$scheduleCustomer->appointmentTime");

                    $query = $this->insertUpdateLinkedTable('Schedule_Customer', $insertColumnValues, $updateColumnValues, $idColumnValues);
                    $response['Schedule_Customer'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

                    array_push($newScheduleCustomers, $scheduleCustomer->scheduleCustomerID);
                }
            }

            if($deleteRecordsNotSent['Schedule_Customer'] == true) {
                foreach ($existingScheduleCustomers as $existingScheduleCustomer) {
                    if(!in_array($existingScheduleCustomer->schedule_customer_id,$newScheduleCustomers)){
                        $query = $this->deleteRecordByID('Schedule_Customer','schedule_customer_id',$existingScheduleCustomer->schedule_customer_id,$insertDeleteStatement = true,$verbalTable = 'Scheduled Customer '.$existingScheduleCustomer->schedule_customer_id);
                        $response['Schedule_Customer'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                    }
                }
            }

        } else {
            $response['Schedules'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [Schedules]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }



        return $response;
    }

    public function deleteContractPriceByObject($contractPrice){
        $response = null;
        if($this->checkExist('ContractPrices',array('customer_id' => "$contractPrice->customerID", 'item_id' => "$contractPrice->itemID", 'min_qty' => "$contractPrice->minQty"))) {
            $query = $this->deleteRecordByMultipleIDs('ContractPrices', array('customer_id' => "$contractPrice->customerID", 'item_id' => "$contractPrice->itemID", 'min_qty' => "$contractPrice->minQty"), true, "ContractPrices [customer_id=$contractPrice->customerID AND item_id=$contractPrice->itemID AND min_qty=$contractPrice->minQty ]");
            $response['Deletes'] = $query['response']['message'] . " - " . $query['response']['status'] . "\n";
        }
        return $response;
    }

    public function insertUpdateItemImageByBase64String($itemID,$itemImageName,$base64String){
        $response = null;

        if (strpos($base64String, "data:image/") !== false) {
            $imagePostFix = '.'.explode('data:image/', explode(';base64', $base64String)[0])[1];
        } else {
            $imagePostFix = '.jpg';
        }

        $newImage = false;
        $rootDir  = explode('cop/',__DIR__)[0].'cop/media/productImages/';
        $imageDir = $rootDir.$itemImageName.$imagePostFix;

        if(file_exists($imageDir)){
            $existingBase64String = $this->getImageBase64ByDirectory($imageDir);
            if(strcmp($existingBase64String,$base64String)!=0){
                $newImage = true;
                $response['Item_Images'] .= "[".date('Y-m-d H:i:s')."] Image $itemImageName$imagePostFix Altered - Adding Record \n";
            } else {
                $response['Item_Images'] .= "[".date('Y-m-d H:i:s')."] Image $itemImageName$imagePostFix Already Exists - No Record Added \n";
            }
        } else {
            $newImage = true;
        }

        if($newImage) {

            file_put_contents("$imageDir", base64_decode(explode('base64,', $base64String)[1]));

            if (strcmp($imagePostFix, '.png') == 0) {
                $this->convertImageFromPngToJpg($rootDir, $itemImageName);
            }
        }

        $newImageRecord = false;
        if($this->checkExist('Item_Images',array('item_id'=>$itemID,'image_url'=>$itemImageName))){
            $itemImageID = $this->getData()->item_image_id;
            if($newImage){$newImageRecord=true;}
        } else {
            $itemImageID = $this->getNextInsertID('Item_Images','item_image_id');
            $newImageRecord = true;
        }

        if($newImageRecord) {
            $updateColumnValues = array('timestamp' => date('Y-m-d H:i:s'));
            $insertColumnValues = array('image_url' => "$itemImageName", 'image_name' => "$itemImageName");
            $idColumnValues = array('item_image_id' => "$itemImageID", 'item_id' => "$itemID");

            $query = $this->insertUpdateLinkedTable('Item_Images', $insertColumnValues, $updateColumnValues, $idColumnValues);
            $response['Item_Images'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

            $query = $this->addThumbnailUrlToItem($itemID,$itemImageName);
            $response['Item_Images'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
        }

        return $response;
    }

    public function insertUpdateContractPriceByObject($contractPrice,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        $idColumnValues = array();
        $tableIDsArray  = array('customer_id','item_id','min_qty');

        if(!isset($excludeUpdateColumns['ContractPrices'])) {
            $excludeUpdateColumns['ContractPrices'] = array();
        }

        $addArray  = $this->mapArrayToObject('ContractPrices',$contractPrice);
        $editArray = $this->excludeUpdateColumnsOfArray('ContractPrices',$addArray,array_merge($excludeUpdateColumns['ContractPrices'],$tableIDsArray));

        foreach($addArray as $addColumn=>$addID){
            if(in_array($addColumn,$tableIDsArray)){
                $idColumnValues[$addColumn] = $addID;
                unset($addArray[$addColumn]);
            }
        }

        if(!empty($addArray)) {
            if(!empty($idColumnValues)) {
                $query = $this->insertUpdateLinkedTable('ContractPrices', $addArray, $editArray, $idColumnValues, $verbalTable = 'Contract Price ');

                $priceResult = $query['data'];
                $response['ContractPrices'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
            } else {
                $response['ContractPrices'] .= "[".date('Y-m-d H:i:s')."] Error Empty IDs - ERROR\n";
            }
        } else {
            $response['ContractPrices'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [ContractPrices]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }



        return $response;
    }

    public function insertUpdateErpCustomerAgeingByObject($erpCustomerAgeing,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        $idColumnValues = array();
        $tableIDsArray  = array('customer_id');

        if(!isset($excludeUpdateColumns['ERP_Customer_Ageing'])) {
            $excludeUpdateColumns['ERP_Customer_Ageing'] = array();
        }

        $addArray  = $this->mapArrayToObject('ERP_Customer_Ageing',$erpCustomerAgeing);
        $editArray = $this->excludeUpdateColumnsOfArray('ERP_Customer_Ageing',$addArray,array_merge($excludeUpdateColumns['ERP_Customer_Ageing'],$tableIDsArray));

        foreach($addArray as $addColumn=>$addID){
            if(in_array($addColumn,$tableIDsArray)){
                $idColumnValues[$addColumn] = $addID;
                unset($addArray[$addColumn]);
            }
        }

        if(!empty($addArray)) {
            if(!empty($idColumnValues)) {
                $query = $this->insertUpdateLinkedTable('ERP_Customer_Ageing', $addArray, $editArray, $idColumnValues, $verbalTable = 'ERP Customer Ageing ');

                $erpCustomerAgeingResult = $query['data'];
                $response['ContractPrices'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
            } else {
                $response['ContractPrices'] .= "[".date('Y-m-d H:i:s')."] Error Empty IDs - ERROR\n";
            }
        } else {
            $response['ContractPrices'] .= "[".date('Y-m-d H:i:s')."] Not Mapped Fields For Object [ContractPrices]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
        }



        return $response;
    }

    public function addThumbnailUrlToItem($itemID,$imageName){
        $object = null;
        $errorCode = null;
        $errorStatus = null;
        $errorMessage = null;

        if($this->update("Items", array('thumbnail_url'=>$imageName), "item_id", $itemID)){
            $errorCode = 0;
            $errorStatus = "OK";
            $errorMessage .= "Update Item [$itemID] Set Primary Image [$imageName.jpg]";
        } else {
            $errorCode = 1;
            $errorStatus = "ERROR";
            $errorMessage .= $this->getErrorMessage();
        }
        $object = $this->getData();

        $result['response']['code']=$errorCode;
        $result['response']['status']=$errorStatus;
        $result['response']['message']=$errorMessage;
        $result['data']=$object;

        return $result;

    }

    public function removeCustomerFromSchedule($customerID,$scheduleID){
        $response = null;
        $scheduleCustomerArray = $this->compactQueryMultipleFilters('Schedule_Customer',array('schedule_id'=>"$scheduleID",'customer_id'=>"$customerID"),$selectFields='*');
        foreach($scheduleCustomerArray as $scheduleCustomerObject) {
            $query = $this->deleteRecordByID('Schedule_Customer', 'schedule_customer_id', $scheduleCustomerObject->schedule_customer_id, $insertDeleteStatement = true, $verbalTable = 'Scheduled Customer ' . $scheduleCustomerObject->schedule_customer_id);
            $response['Schedule_Customer'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
        }
        return $response;
    }

    public function updateCustomerBalance($customerID,$balance){

        $object = null;
        $errorCode = null;
        $errorStatus = null;
        $errorMessage = "[".date('Y-m-d H:i:s')."] ";

        if($customerID > 0) {
            if ($this->update('Customers', array('balance'=>"$balance"), 'customer_id', $customerID)) {
                $errorCode = 0;
                $errorStatus = "OK";
                $errorMessage .= "Update Customer Balance [$customerID] - Balance $balance";
                $this->removeAffectedRecord();
            } else {
                $errorCode = 1;
                $errorStatus = "ERROR";
                $errorMessage .= $this->getErrorMessage();
            }
            $object = $this->getData();

        } else {
            $errorCode = 1;
            $errorStatus = "ERROR";
            $errorMessage .= " error Update  Customer Balance - Empty ID [$customerID]";
        }


        $result['response']['code']=$errorCode;
        $result['response']['status']=$errorStatus;
        $result['response']['message']=$errorMessage;
        $result['data']=$object;

        return $result;
    }

    public function insertCustomerSubAccountLink($customerID,$subCustomerID,$type='sub'){


        $idColumnValues  = array('customer_id'=>"$customerID",'subcustomer_id'=>"$subCustomerID",'type'=>"$type");
        $etcColumnValues = array('date_added'=>date('Y-m-d H:i:s'),'position'=>"0",'user_id'=>'0','notes'=>'');
        if($customerID > 0 && $subCustomerID > 0) {
            if (!$this->checkExist('SubCustomers', $idColumnValues)) {
                $query = $this->insertUpdateLinkedTable('SubCustomers', $etcColumnValues, $etcColumnValues, $idColumnValues, 'Sub Customer Link');
            }
        }

        return $query;

    }

    public function insertUpdateCustomerPaymentTerms($customerID,$paymentTermDays,$paymentTermText){

        $paymentTermDays = (int)$paymentTermDays;
        $idColumnValues  = array('customer_id'=>"$customerID");
        $etcColumnValues = array('payment_term_days'=>"$paymentTermDays",'payment_term_text'=>"$paymentTermText");
        if($customerID > 0) {
                $query = $this->insertUpdateLinkedTable('Customer_Payment_Terms', $etcColumnValues, $etcColumnValues, $idColumnValues, 'Customer Payment Terms');
        }

        return $query;

    }


    /** DOCUMENT HANDLE METHODS */
    public function insertUpdateServiceCallByObject($serviceCall,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        if($this->checkExist('Service_Call',array('service_call_code'=>$serviceCall->serviceCallCode,'action_hash'=>$serviceCall->actionHash)))  {

            $response['Service_Calls'] .= "[" . date('Y-m-d H:i:s') . "] Service Call $serviceCall->serviceCallCode Exists. (No Change Detected) - No Record Added\n";

        } else {

            $addArray = $this->mapArrayToObject('Service_Call', $serviceCall);
            $editArray = $this->excludeUpdateColumnsOfArray('Service_Call', $addArray, $excludeUpdateColumns);

            if (!empty($addArray)) {

                $query = $this->insertUpdateRecordByFilter('Service_Call', 'service_call_id', 'service_call_code', $addArray['service_call_code'], $editArray, $addArray, 'Service Call');
                $response['Service_Calls'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

                $serviceCallResult   = $query['data'];


                foreach ($serviceCall->serviceCallReplies as $reply) {
                    $reply->serviceCallID = $serviceCallResult->service_call_id;

                    if($this->checkExist('Service_Call_Reply',array('service_call_id'=>$reply->serviceCallID,'salesperson_id'=>$reply->salesPersonID,'reply_type_id'=>$reply->replyTypeID,'details'=>$reply->details,'document_id'=>$reply->documentID,'document_type'=>$reply->documentType,'salesperson_to'=>$reply->salesPersonTo)))  {

                        $response['Service_Calls'] .= "[" . date('Y-m-d H:i:s') . "] Service Call Reply  Exists. (No Change Detected) - No Record Added\n";

                    } else {

                        $query = $this->insertRecordByObject('Service_Call_Reply', 'service_call_reply_id', 'service_call_id', $reply, $verbalTable = 'Service Call Reply');
                        $response['Service_Call_Reply'] .= $query['Service_Call_Reply'];
                    }

                }

            } else {
                $response['Service_Calls'] .= "[" . date('Y-m-d H:i:s') . "] Not Mapped Fields For Object [Service Call]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
            }

        }

        return $response;
    }

    public function insertUpdateTenderByObject($tender,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        if($this->checkExist('Tenders',array('tender_code'=>$tender->tenderCode,'action_hash'=>$tender->actionHash)))  {

            $response['Tenders'] .= "[" . date('Y-m-d H:i:s') . "] Tender $tender->tenderCode Exists. (No Change Detected) - No Record Added\n";

        } else {

            $addArray = $this->mapArrayToObject('Tenders', $tender);
            $editArray = $this->excludeUpdateColumnsOfArray('Tenders', $addArray, $excludeUpdateColumns);

            if (!empty($addArray)) {

                $query = $this->insertUpdateRecordByFilter('Tenders', 'tender_id', 'tender_code', $addArray['tender_code'], $editArray, $addArray, 'Tender');
                $response['Tenders'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

                $tenderResult   = $query['data'];

                $existingItems = count($this->compactQuery('Tender_Item', 'tender_id', $tenderResult->tender_id, 'tender_item_id'));
                if($existingItems > 0){
                    $query = $this->deleteRecordByMultipleIDs('Tender_Item', array('tender_id' => "$tenderResult->tender_id"), $insertDeleteStatement = true, $verbalTable = 'Tender Items [tender_id=' . $tenderResult->order_id . ']');
                    $response['Deletes'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                }

                foreach ($tender->tenderItems as $item) {
                    $item->tenderID = $tenderResult->tender_id;

                    $query = $this->insertRecordByObject('Tender_Item','tender_item_id','tender_id',$item,$verbalTable='Tender Item');
                    $response['Tender_Item'] .= $query['Tender_Item'];

                }

            } else {
                $response['Tenders'] .= "[" . date('Y-m-d H:i:s') . "] Not Mapped Fields For Object [Tenders]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
            }

        }

        return $response;
    }

    public function insertUpdateOrderByObject($order,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        if($this->checkExist('Orders',array('order_code'=>$order->orderCode,'action_hash'=>$order->actionHash)))  {

            $response['Orders'] .= "[" . date('Y-m-d H:i:s') . "] Order $order->orderCode Exists. (No Change Detected) - No Record Added\n";

        } else {

            $addArray = $this->mapArrayToObject('Orders', $order);
            $editArray = $this->excludeUpdateColumnsOfArray('Orders', $addArray, $excludeUpdateColumns);

            if (!empty($addArray)) {

                $query = $this->insertUpdateRecordByFilter('Orders', 'order_id', 'order_code', $addArray['order_code'], $editArray, $addArray, 'Order');
                $response['Orders'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

                $orderResult   = $query['data'];

                $existingItems = count($this->compactQuery('Order_Item', 'order_id', $orderResult->order_id, 'order_item_id'));
                if($existingItems > 0){
                    $query = $this->deleteRecordByMultipleIDs('Order_Item', array('order_id' => "$orderResult->order_id"), $insertDeleteStatement = true, $verbalTable = 'Order Items [order_id=' . $orderResult->order_id . ']');
                    $response['Deletes'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                }

                foreach ($order->orderItems as $item) {
                    $item->orderID = $orderResult->order_id;

                    $query = $this->insertRecordByObject('Order_Item','order_item_id','order_id',$item,$verbalTable='Order Item');
                    $response['Order_Item'] .= $query['Order_Item'];

                }

            } else {
                $response['Orders'] .= "[" . date('Y-m-d H:i:s') . "] Not Mapped Fields For Object [Orders]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
            }

        }

        return $response;
    }

    public function insertUpdateWaybillByObject($waybill,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        if($this->checkExist('Waybills',array('waybill_code'=>$waybill->waybillCode,'action_hash'=>$waybill->actionHash)))  {

            $response['Waybills'] .= "[" . date('Y-m-d H:i:s') . "] Waybill $waybill->waybillCode Exists. (No Change Detected) - No Record Added\n";

        } else {

            $addArray = $this->mapArrayToObject('Waybills', $waybill);
            $editArray = $this->excludeUpdateColumnsOfArray('Waybills', $addArray, $excludeUpdateColumns);

            if (!empty($addArray)) {

                $query = $this->insertUpdateRecordByFilter('Waybills', 'waybill_id', 'waybill_code', $addArray['waybill_code'], $editArray, $addArray, 'Waybill');
                $response['Waybills'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

                $waybillResult   = $query['data'];

                $existingItems = count($this->compactQuery('Waybill_Item', 'waybill_id', $waybillResult->waybill_id, 'waybill_item_id'));
                if($existingItems > 0){
                    $query = $this->deleteRecordByMultipleIDs('Waybill_Item', array('waybill_id' => "$waybillResult->waybill_id"), $insertDeleteStatement = true, $verbalTable = 'Waybill Items [waybill_id=' . $waybillResult->waybill_id . ']');
                    $response['Deletes'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                }

                foreach ($waybill->waybillItems as $item) {
                    $item->orderID = $waybillResult->order_id;

                    $query = $this->insertRecordByObject('Waybill_Item','waybill_item_id','waybill_id',$item,$verbalTable='Waybill Item');
                    $response['Waybill_Item'] .= $query['Waybill_Item'];

                }

            } else {
                $response['Waybills'] .= "[" . date('Y-m-d H:i:s') . "] Not Mapped Fields For Object [Waybills]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
            }

        }

        return $response;
    }

    public function insertUpdateInvoiceByObject($invoice,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        if($this->checkExist('Invoices',array('invoice_code'=>$invoice->invoiceCode,'action_hash'=>$invoice->actionHash)))  {

            $response['Invoices'] .= "[" . date('Y-m-d H:i:s') . "] Invoice $invoice->invoiceCode Exists. (No Change Detected) - No Record Added\n";

        } else {

            $addArray = $this->mapArrayToObject('Invoices', $invoice);
            $editArray = $this->excludeUpdateColumnsOfArray('Invoices', $addArray, $excludeUpdateColumns);

            if (!empty($addArray)) {

                $query = $this->insertUpdateRecordByFilter('Invoices', 'invoice_id', 'invoice_code', $addArray['invoice_code'], $editArray, $addArray, 'Invoice');
                $response['Invoices'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

                $invoiceResult   = $query['data'];

                $existingItems = count($this->compactQuery('Invoice_Item', 'invoice_id', $invoiceResult->invoice_id, 'invoice_item_id'));
                if($existingItems > 0){
                    $query = $this->deleteRecordByMultipleIDs('Invoice_Item', array('invoice_id' => "$invoiceResult->invoice_id"), true, "Invoice Items [invoice_id=$invoiceResult->invoice_id ]");
                    $response['Deletes'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                }

                foreach ($invoice->invoiceItems as $item) {
                    $item->invoiceID = $invoiceResult->invoice_id;

                    $query = $this->insertRecordByObject('Invoice_Item','invoice_item_id','invoice_id',$item,'Invoice Item');
                    $response['Invoice_Item'] .= $query['Invoice_Item'];

                }

            } else {
                $response['Invoices'] .= "[" . date('Y-m-d H:i:s') . "] Not Mapped Fields For Object [Invoices]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
            }

        }

        return $response;
    }

    public function insertUpdateReturnByObject($return,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        if($this->checkExist('Returns',array('return_code'=>$return->returnCode,'action_hash'=>$return->actionHash)))  {

            $response['Returns'] .= "[" . date('Y-m-d H:i:s') . "] Return $return->returnCode Exists. (No Change Detected) - No Record Added\n";

        } else {

            $addArray = $this->mapArrayToObject('Returns', $return);
            $editArray = $this->excludeUpdateColumnsOfArray('Returns', $addArray, $excludeUpdateColumns);

            if (!empty($addArray)) {

                $query = $this->insertUpdateRecordByFilter('Returns', 'return_id', 'return_code', $addArray['return_code'], $editArray, $addArray, 'Return');
                $response['Returns'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

                $returnResult   = $query['data'];

                $existingItems = count($this->compactQuery('Return_Item', 'return_id', $returnResult->return_id, 'return_item_id'));
                if($existingItems > 0){
                    $query = $this->deleteRecordByMultipleIDs('Return_Item', array('return_id' => "$returnResult->return_id"), true, "Return Items [return_id=$returnResult->return_id ]");
                    $response['Deletes'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                }

                foreach ($return->returnItems as $item) {
                    $item->returnID = $returnResult->return_id;

                    $query = $this->insertRecordByObject('Return_Item','return_item_id','return_id',$item,'Return Item');
                    $response['Return_Item'] .= $query['Return_Item'];

                }

            } else {
                $response['Returns'] .= "[" . date('Y-m-d H:i:s') . "] Not Mapped Fields For Object [Returns]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
            }

        }

        return $response;
    }

    public function insertUpdateReceiptByObject($receipt,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()){

        $response = null;

        if($this->checkExist('Receipts',array('receipt_code'=>$receipt->receiptCode,'action_hash'=>$receipt->actionHash)))  {

            $response['Receipts'] .= "[" . date('Y-m-d H:i:s') . "] Receipt $receipt->receiptCode Exists. (No Change Detected) - No Record Added\n";

        } else {

            $addArray = $this->mapArrayToObject('Receipts', $receipt);
            $editArray = $this->excludeUpdateColumnsOfArray('Receipts', $addArray, $excludeUpdateColumns);

            if (!empty($addArray)) {

                $query = $this->insertUpdateRecordByFilter('Receipts', 'receipt_id', 'receipt_code', $addArray['receipt_code'], $editArray, $addArray, 'Receipt');
                $response['Receipts'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";

                $receiptResult   = $query['data'];

                $existingItems = count($this->compactQuery('Receipt_Item', 'receipt_id', $receiptResult->receipt_id, 'receipt_item_id'));
                if($existingItems > 0){
                    $query = $this->deleteRecordByMultipleIDs('Receipt_Item', array('receipt_id' => "$receiptResult->receipt_id"), true, "Receipt Items [receipt_id=$receiptResult->receipt_id ]");
                    $response['Deletes'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
                }

                foreach ($receipt->receiptItems as $item) {
                    $item->receiptID = $receiptResult->receipt_id;

                    $query = $this->insertRecordByObject('Receipt_Item','receipt_item_id','receipt_id',$item,'Receipt Item');
                    $response['Receipt_Item'] .= $query['Receipt_Item'];

                }

            } else {
                $response['Receipts'] .= "[" . date('Y-m-d H:i:s') . "] Not Mapped Fields For Object [Receipts]. Map Object To DB Structure [function DataBase->mapArrayToObject()] - ERROR\n";
            }

        }

        return $response;
    }

    public function insertUpdateDocumentStatusByObject($documentStatus,$errorEmail=''){

        $response = null;

        if($this->checkExist('Documents_Status',array('id'=>$documentStatus->id,'type'=>$documentStatus->type)))  {
            $existingDocumentStatus = $this->getData();
            $response['Documents_Status'] .= "[" . date('Y-m-d H:i:s') . "] Documents Status [$documentStatus->table (ID:$documentStatus->id , Export Code: $existingDocumentStatus->exportCode)] Already Exists (Duplicate Notice). - NOTICE\n";
        }

        $updateColumnValues = array('status'=>"$documentStatus->status",'reason'=>"$documentStatus->reason",'export_id'=>"$documentStatus->exportID",'export_code'=>"$documentStatus->exportCode");
        $insertColumnValues = array('status'=>"$documentStatus->status",'reason'=>"$documentStatus->reason",'export_id'=>"$documentStatus->exportID",'export_code'=>"$documentStatus->exportCode");
        $idColumnValues     = array('id'=>"$documentStatus->id",'type'=>"$documentStatus->type");

        $query = $this->insertUpdateLinkedTable('Documents_Status',$insertColumnValues, $updateColumnValues, $idColumnValues);

        $response['Documents_Status'] .= $query['response']['message'] . " - " . $query['response']['status'] . "\n";
        $documentStatusResult = $query['data'];

        if((int)$documentStatus->status < 0 && strcmp($errorEmail,'')!=0 && strpos($errorEmail, "@") !== false){
            $docType = array_search($documentStatus->type, $this->documentStatusTypes);
            $subject = "";
            $context = "$docType - SYNC ERROR - $documentStatus->exportCode<br><br>$documentStatus->reason<br><br>";
            $this->sendSmtpMail($subject,$context,$errorEmail,$fromName='Coprime Cloud');
        }

        return $response;
    }

    public function insertUpdateErpImportByObject($erpImport){

        $updateColumnValues = array('end_time'=>"$erpImport->endTime",'result_log'=>"$erpImport->resultLog",'affected_records'=>"$erpImport->affectedRecords",'deleted_records'=>"$erpImport->deletedRecords",'delete_statements'=>"$erpImport->deleteStatementRecords",'source_method'=>"$erpImport->sourceMethod",'status'=>"$erpImport->status");
        $insertColumnValues = array('end_time'=>"$erpImport->endTime",'name'=>"$erpImport->name",'type'=>"$erpImport->type",'result_log'=>"$erpImport->resultLog",'affected_records'=>"$erpImport->affectedRecords",'deleted_records'=>"$erpImport->deletedRecords",'delete_statements'=>"$erpImport->deleteStatementRecords",'source_name'=>"$erpImport->sourceName",'source_method'=>"$erpImport->sourceMethod",'source_ip'=>"$erpImport->sourceIP",'status'=>"$erpImport->status",'parent_id'=>"$erpImport->parentID");
        $idColumnValues     = array('erp_import_id'=>"$erpImport->erpImportID",'start_time'=>"$erpImport->startTime");

        $query = $this->insertUpdateLinkedTable('ERP_Import',$insertColumnValues, $updateColumnValues, $idColumnValues,'DB Log');
        $this->removeAffectedRecord();

        return $query;

    }

    public function changeDocumentStatus($table,$columnID,$id,$status){
        $object = null;
        $errorCode = null;
        $errorStatus = null;
        $errorMessage = "[".date('Y-m-d H:i:s')."] ";

        if($id > 0) {
            $this->lockDocument($id,$table);
            if ($this->update($table, array('status'=>"$status"), $columnID, $id)) {
                $errorCode = 0;
                $errorStatus = "OK";
                $errorMessage .= "Update $table [$id] Status to $status ";
                $this->removeAffectedRecord();
            } else {
                $errorCode = 1;
                $errorStatus = "ERROR";
                $errorMessage .= $this->getErrorMessage();
            }
            $object = $this->getData();
        } else {
            $errorCode = 1;
            $errorStatus = "ERROR";
            $errorMessage .= " error Update $table Status - Empty ID [$id]";
            $object = $this->getData();
        }

        $result['response']['code']=$errorCode;
        $result['response']['status']=$errorStatus;
        $result['response']['message']=$errorMessage;
        $result['data']=$object;

        return $result;

    }

    public function insertOrderInvoiceLink($orderID,$invoiceID){


        $idColumnValues     = array('order_id'=>"$orderID",'invoice_id'=>"$invoiceID");

        if(!$this->checkExist('Order_Invoice',$idColumnValues)) {
            $query = $this->insertUpdateLinkedTable('Order_Invoice', array(), array(), $idColumnValues, 'Order Invoice Link');
            $this->removeAffectedRecord();
        }

        return $query;

    }

    public function lockDocument($documentID,$table,$lockType=""){

        $object = null;
        $errorCode = null;
        $errorStatus = null;
        $errorMessage = "[".date('Y-m-d H:i:s')."] ";

        $idColumnValues     = array('document_id'=>"$documentID",'document_type'=>"$table",'lock_type'=>"$lockType");

        if(!$this->checkExist('ZD_Lock_Document',$idColumnValues)) {

            $this->insert('ZD_Lock_Document', $idColumnValues);
            $this->removeAffectedRecord();

            $errorCode = 0;
            $errorStatus = "OK";
            $errorMessage .= " Locked $table [$documentID] ";
            $object = $this->getData();
        } else {

            $errorCode = 0;
            $errorStatus = "NOTICE";
            $errorMessage .= " $table [$documentID] - Document Already Locked";
        }

        $result['response']['code']=$errorCode;
        $result['response']['status']=$errorStatus;
        $result['response']['message']=$errorMessage;
        $result['data']=$object;

        return $result;

    }

    public function sendSmtpMail($subject,$context,$to,$fromName=''){

        $object = null;
        $errorCode = null;
        $errorStatus = null;
        $errorMessage = "[".date('Y-m-d H:i:s')."] ";

        $rootDirectory = explode('cop/',__DIR__)[0];

//        require_once($rootDirectory.'cop/libs/emailer/PHPMailer/Exception.php');
//        require_once($rootDirectory.'cop/libs/emailer/PHPMailer/PHPMailer.php');
//        require_once($rootDirectory.'cop/libs/emailer/PHPMailer/SMTP.php');

        include_once($rootDirectory . "libs/emailer/PHPMailer8/vendor/autoload.php");

        $mailObject = $this->fetchSingleRow('Cloud_Configuration', 'id', 1);

        $mailHost     = $mailObject->email_host;
        $senderEmail  = $mailObject->email_from;
        $senderName   = $mailObject->email_from;
        $mailUsername = $mailObject->email_username;
        $mailPassword = $mailObject->email_password;
        if(strcmp($fromName,'')!=0){$senderName = $fromName;}

        $toAddresses = explode(';',$to);

        try {
            foreach ($toAddresses as $to) {
                $mail = new PHPMailer\PHPMailer\PHPMailer(true);
                $mail->SMTPDebug = 0;                                               // Enable verbose debug output
                $mail->isSMTP();                                                    // Set mailer to use SMTP
                $mail->Host = $mailHost;                                            // Specify main and backup SMTP servers
                $mail->SMTPAuth = true;                                             // Enable SMTP authentication
                $mail->Username = $mailUsername;                                    // SMTP username
                $mail->Password = $mailPassword;                                    // SMTP password
                $mail->SMTPSecure = 'tls';                                          // Enable TLS encryption, `ssl` also accepted
                $mail->Port = 587;                                                  // TCP port to connect to
                $mail->setFrom($senderEmail, $senderName);                           //Recipients
                $mail->addAddress($to);
                $mail->CharSet = 'UTF-8';
                $mail->Encoding = "base64";
                $mail->isHTML(true);
                $mail->Subject = $subject;
                $mail->Body = $context;
                $mail->send();

                $errorCode = 1;
                $errorStatus = 'ok';
                $errorMessage .= "Mail Sent from $senderName ($senderEmail) to $to ";

                $this->insert('Document_Email', array('document_id' => '0', 'document_code' => "Simple Mail (No Attachment)", 'document_type' => "Attachment", 'email' => "$to"));
                $this->removeAffectedRecord();
            }

        } catch (Exception $e) {
            $errorCode     =-1;
            $errorStatus   ='ERROR';
            $errorMessage .= $e->getMessage();
        }

        $result['response']['code']=$errorCode;
        $result['response']['status']=$errorStatus;
        $result['response']['message']=$errorMessage;
        $result['data']=$object;

        return $result;

    }

    public function customQuery($query)
    {

        $ins = $this->pdo->prepare("$query");
        try {
            $ins->execute($data);
            return true;
        } catch (PDOException $exception) {
            $this->setErrorMessage($exception->getMessage());
            return false;
        }


    }





}
?>
