<?php
class CustomTable {

    public $linkedTableID;
    public $linkedTable;
    public $type;

    function __construct($linkedTable='',$linkedTableID='',$type='UDT')
    {
        $this->linkedTable = $linkedTable;
        $this->linkedTableID = $linkedTableID;
        $this->type = $type;
    }

    private function getCustomTables($status = 'yes')
    {
        if(strcmp($this->type,'')==0){$this->type = 'UDT';}

        global $username, $password, $database;
        $db2 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $customTables = array();
        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SELECT custom_table_id, custom_table_code, custom_table_name, display_name, linked_table, status, type, position FROM ZA_Custom_Tables WHERE NOT linked_table='' AND linked_table='$this->linkedTable' AND status = '$status' AND type='$this->type' ORDER BY position,custom_table_code");
        $stm2->execute();
        $stm2->bind_result($customTableID, $customTableCode, $customTableName,$displayName,$linkedTable,$customTableStatus,$customTableType,$position);
        while ($stm2->fetch()) {
            $line = new stdClass();
            $line->customTableID = $customTableID;
            $line->customTableCode = $customTableCode;
            $line->customTableName = $customTableName;
            $line->displayName = $displayName;
            $line->linkedTable = $linkedTable;
            $line->customTableStatus = $customTableStatus;
            $line->customTableType = $customTableType;
            $line->position = $position;

            array_push($customTables,$line);

        }
        $stm2->close();

        return $customTables;
    }

    private function getAllCustomTables($status = 'yes')
    {
        global $username, $password, $database;
        $db2 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $customTables = array();
        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SELECT custom_table_id, custom_table_code, custom_table_name, display_name, linked_table, status, type, position FROM ZA_Custom_Tables WHERE NOT linked_table='' AND status = '$status'");
        $stm2->execute();
        $stm2->bind_result($customTableID, $customTableCode, $customTableName,$displayName,$linkedTable,$customTableStatus,$customTableType,$position);
        while ($stm2->fetch()) {
            $line = new stdClass();
            $line->customTableID = $customTableID;
            $line->customTableCode = $customTableCode;
            $line->customTableName = $customTableName;
            $line->displayName = $displayName;
            $line->linkedTable = $linkedTable;
            $line->customTableStatus = $customTableStatus;
            $line->customTableType = $customTableType;
            $line->position = $position;

            array_push($customTables,$line);

        }
        $stm2->close();

        return $customTables;
    }

    private function getCustomTableFields($customTableID,$visible = 'yes')
    {
        global $username, $password, $database;
        $db2 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $customTableFields = array();

        if(strcmp("$visible","")!=0){
            $visibleFilter = "AND visible = '$visible'";
        } else {
            $visibleFilter = '';
        }

        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SELECT custom_table_field, display_name, type,  position, default_values, css_style, class FROM ZA_Custom_Table_Fields WHERE custom_table_id='$customTableID' $visibleFilter ORDER BY position ASC");
        $stm2->execute();
        $stm2->bind_result($customTableField, $displayName,$type,$position,$defaultValues,$css,$class);
        while ($stm2->fetch()) {
            $line = new stdClass();
            $line->customTableField = $customTableField;
            $line->displayName = $displayName;
            $line->type = $type;
            $line->position = $position;
            $line->defaultValues = $defaultValues;
            $line->css = $css;
            $line->class = $class;

            array_push($customTableFields,$line);

        }
        $stm2->close();

        return $customTableFields;
    }

    private function customTableExists($customTableName)
    {
        global $username, $password, $database;
        $db2 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $z = false;
        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SHOW TABLES LIKE '$customTableName';");
        $stm2->execute();
        $stm2->bind_result($tableName);
        while ($stm2->fetch()) {
            if(strcmp($tableName,$customTableName)==0){$z = true;}
        }
        $stm2->close();

        return $z;
    }

    private function customTableFieldExists($customTableName,$customTableField)
    {
        global $username, $password, $database;
        $db2 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $z = false;
        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SHOW COLUMNS FROM $customTableName LIKE '$customTableField'");
        $stm2->execute();
        $stm2->bind_result($field,$type,$null,$key,$default,$extra);
        while ($stm2->fetch()) {
            if(strcmp($field,$customTableField)==0){$z = true;}
        }
        $stm2->close();

        return $z;
    }

    private function getCustomTableInputType($type,$cssStyle,$class,$customFieldName,$lastValue,$valuesRange,$disabled,$editable,$required,$b2bEmptyEqualsAll=false,$allLabel = '- All -'){
        if($disabled || !$editable){$disable = 'disabled';}else{$disable = '';}
        if($required){$required = 'required';}else{$required = '';}

        switch ($type){
            case 'text':
                $defaultValue = "$valuesRange";
                if (strcmp("$lastValue",'')==0){
                    $lastValue = $defaultValue;
                }
                $input = "<input type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' value='$lastValue' $disable $required/>";
                break;
            case 'combobox':


                $input = "<select style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' $disable>";

                $values = explode(';',$valuesRange);
                $optionCount=0;
                foreach ($values as $value){
                    $value = str_replace("\n", '', $value);
                    $value = trim($value);

                    if(strcmp($lastValue,$value)==0){

                        $valueLabel = $lastValue;

                        if($b2bEmptyEqualsAll && strcmp($value,'')==0){
                            $valueLabel = $allLabel;
                        }

                        $input.= "<option value='$lastValue' selected>$valueLabel</option>";
                    } else {

                        $valueLabel = $value;

                        if($b2bEmptyEqualsAll && strcmp($value,'')==0){
                            $valueLabel = $allLabel;
                        }

                        $input.= "<option value='$value'>$valueLabel</option>";
                    }
                    $optionCount++;
                }
                $input.= "</select>";
                break;
            case 'checkbox':
                if(strcmp($lastValue,'yes')==0 || strcmp($lastValue,'true')==0){$presetValue = "$lastValue"; $checked = "checked";} else {$presetValue = "true"; $checked = '';}
                $input = "<center><label class='cop-switch' style='margin-top: 4px;'><input type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' value='$presetValue' $checked $disable/><span class='cop-switch-slider'></span></label></center>";
                break;
            case 'label':
                $input = "<label class='label text-center'>$lastValue</label>";
                break;
            case 'textarea':
                $input = "<textarea type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' $disable $required>$lastValue</textarea>";

                break;
            case 'JSONArray':

                $valuesJson = str_replace('#quote#','"',$valuesRange);
                $values = json_decode($valuesJson);
                $optionCount=0;
                $input = "<select style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' $disable>";
                $input.= "<option value=''></option>";

                foreach ($values as $value){

                    $value = json_encode($value);
                    $value = str_replace('"','#quote#',$value);

                    $lastValueArray = str_replace('#quote#','"',$lastValue);
                    $lastValueArray = json_decode($lastValueArray);
                    $lastValueDisplay = '';
                    $lastValueArrayDB = array();
                    $firstValueOption = true;
                    foreach ($lastValueArray as $key => $data){
                        array_push($lastValueArrayDB,"#quote#$key#quote#:#quote#$data#quote#");
                        if($firstValueOption) {
                            $lastValueDisplay .= "$key: $data";
                            $firstValueOption = false;
                        } else {
                            $lastValueDisplay .= "</option><option disabled style='font-style:italic' >&nbsp;&#9679;&nbsp;$key: $data";
                        }
                    }
                    $lastValueDB = "{".implode(',',$lastValueArrayDB)."}";

                    $valueArray = str_replace('#quote#','"',$value);
                    $valueArray = json_decode($valueArray);
                    $valueDisplay = '';
                    $valueArrayDB = array();
                    $firstValueOption = true;
                    foreach ($valueArray as $key => $data){
                        array_push($valueArrayDB,"#quote#$key#quote#:#quote#$data#quote#");
                        if($firstValueOption) {
                            $valueDisplay .= "$key: $data";
                            $firstValueOption = false;
                        } else {
                            $valueDisplay .= "</option><option disabled style='font-style:italic' >&nbsp;&#9679;&nbsp;$key: $data";
                        }
                    }
                    $valueDB = "{".implode(',',$valueArrayDB)."}";

                    if(strcmp($lastValueDB,$valueDB)==0){
                        $input.= "<option value='$lastValueDB' selected>$lastValueDisplay</option>";
                    }else{
                        $input.= "<option value='$valueDB'>$valueDisplay</option>";
                    }
                    $optionCount++;
                }
                $input.= "</select>";

                break;
            default:
                $input = "<input type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' value='$lastValue' $disable $required/>";
        }

        return $input;
    }

    public function getCustomTableCodes($db=''){
        if(is_string($db) && strcmp($db,'')==0) {
            global $username, $password, $database;
            $db = new mysqli(localhost, $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
        }
        $codes = array();
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT custom_table_id,custom_table_code FROM ZA_Custom_Tables WHERE linked_table='$this->linkedTable'");
        $stm->execute();
        $stm->bind_result($customFormID,$customFormCode);
        while ($stm->fetch()) {
            $code = new stdClass();
            $code->tableCode = $customFormCode;
            $code->formCode = "UDT_".$customFormID."_$customFormCode";
            array_push($codes,$code);
        }
        $stm->close();

        return $codes;
    }

    public function insertVariablesToCustomTable($post, $code='',$db=''){

        if(strcmp($code,'')!=0){$where = "AND custom_table_code='$code'" ;}else{$where='';}

        $postValues = array();
        foreach($post as $postValue){
            $postValues[$postValue['id']] = $postValue['avalue'];
        }

        if(is_string($db) && strcmp($db,'')==0) {
            global $username, $password, $database;
            $db = new mysqli(localhost, $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $singleTransactionDB = false;
        } else {
            $singleTransactionDB = true;
        }

        $customTables = array();
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT custom_table_id,custom_table_name FROM ZA_Custom_Tables WHERE linked_table='$this->linkedTable' $where");
        $stm->execute();
        $stm->bind_result($customTableID,$customTableName);
        while ($stm->fetch()) {
            $customTable = new stdClass();
            $customTable->id = $customTableID;
            $customTable->table = $customTableName;
            array_push($customTables,$customTable);
        }
        $stm->close();

        foreach ($customTables as $customTable){
            $customTableFields = array();
            $customTableInsertValues = array();
            $customTableUpdateValues = array();
            $fieldMarkers = '';
            $db->set_charset("utf8");
            $stm = $db->prepare("SELECT custom_table_field FROM ZA_Custom_Table_Fields WHERE custom_table_id='$customTable->id'");
            $stm->execute();
            $stm->bind_result($customTableField);
            while ($stm->fetch()) {
                $customTablePostValue = "'".$postValues["$customTableField"]."'";
                array_push($customTableFields,$customTableField);
                array_push($customTableInsertValues,$customTablePostValue);
                array_push($customTableUpdateValues,"$customTableField=$customTablePostValue");

            }
            $stm->close();

            array_push($customTableFields,'timestamp');
            array_push($customTableInsertValues,'NOW()');
            array_push($customTableUpdateValues,"timestamp=NOW()");

            $impFields = implode(',',$customTableFields);
            $impInsertValues = implode(',',$customTableInsertValues);
            $impUpdateValues = implode(',',$customTableUpdateValues);

            $query = "INSERT INTO $customTable->table (id,$impFields) VALUES ('$this->linkedTableID',$impInsertValues) ON DUPLICATE KEY UPDATE $impUpdateValues ";

            $db->set_charset("utf8");
            $stm = $db->prepare($query);
            $stm->execute();
            if($singleTransactionDB && strcmp($stm->error,"")!=0) {throw new Exception();}
            $stm->close();


        }

    }

    public function insertVariablesToCustomTableLine($post, $code='',$db=''){

        if(strcmp($code,'')!=0){$where = "AND custom_table_code='$code'" ;}else{$where='';}


        if(is_string($db) && strcmp($db,'')==0) {
            global $username, $password, $database;
            $db = new mysqli(localhost, $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $singleTransactionDB = false;
        } else {
            $singleTransactionDB = true;
        }

        $customTables = array();
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT custom_table_id,custom_table_name FROM ZA_Custom_Tables WHERE linked_table='$this->linkedTable' $where");
        $stm->execute();
        $stm->bind_result($customTableID,$customTableName);
        while ($stm->fetch()) {
            $customTable = new stdClass();
            $customTable->id = $customTableID;
            $customTable->table = $customTableName;
            array_push($customTables,$customTable);
        }
        $stm->close();

        foreach ($customTables as $customTable){
            $customTableFields = array();
            $customTableInsertValues = array();
            $customTableUpdateValues = array();
            $fieldMarkers = '';
            $db->set_charset("utf8");
            $stm = $db->prepare("SELECT custom_table_field,display_name FROM ZA_Custom_Table_Fields WHERE custom_table_id='$customTable->id'");
            $stm->execute();
            $stm->bind_result($customTableField,$displayName);
            while ($stm->fetch()) {
                $customTablePostValue = "'".$post["$displayName"]."'";
                array_push($customTableFields,$customTableField);
                array_push($customTableInsertValues,$customTablePostValue);
                array_push($customTableUpdateValues,"$customTableField=$customTablePostValue");

            }
            $stm->close();

            array_push($customTableFields,'timestamp');
            array_push($customTableInsertValues,'NOW()');
            array_push($customTableUpdateValues,"timestamp=NOW()");

            $impFields = implode(',',$customTableFields);
            $impInsertValues = implode(',',$customTableInsertValues);
            $impUpdateValues = implode(',',$customTableUpdateValues);

            $query = "INSERT INTO $customTable->table (id,$impFields) VALUES ('$this->linkedTableID',$impInsertValues) ON DUPLICATE KEY UPDATE $impUpdateValues ";

            $db->set_charset("utf8");
            $stm = $db->prepare($query);
            $stm->execute();
            if($singleTransactionDB && strcmp($stm->error,"")!=0) {throw new Exception();}
            $stm->close();


        }

    }

    private function createCustomTableForm($edit,$disabled,$viewOnly=false,$embed=false)
    {
        $customTables = $this->getCustomTables();
        $counter      = 0;
        $lis          = '';
        $tabs         = '';
        $activeIn     = "active in";
        $active       = "active";
        $emptyForms  = true;

        if($embed){$activeIn = $active = '';}

        foreach ($customTables as $customTable){

            if($this->customTableExists($customTable->customTableName)){

                $customFields = $this->getCustomTableFields($customTable->customTableID);
                $values = $this->getCustomTableValues("$customTable->customTableName","$this->linkedTableID");
                $values = (array)$values;

                $count = count(array_filter($values));

                if($count > 0 || $viewOnly){

                    $lis .="<li id='ctliactivation$counter' class='$active'>";
                    $lis .="<a data-toggle='tab' href='#ct$counter' id='ctlink$counter' ><i class='fa fa-table' style='margin-right: 5px;color: #0a0a0a;'></i><span class='hidden-mobile hidden-tablet' style='color: #0a0a0a;'>$customTable->displayName</span></a>";
                    $lis .="</li>";


                    $tabs .= "<div class='tab-pane fade $activeIn ' id='ct$counter' ><br/><br/><br/>";
                    $tabs .= "<form>";
                    $tabs .= "<table class='custom-form' id='UDT_".$customTable->customTableID."_$customTable->customTableCode' style='width: 100%;'>";
                    $tabs .= "<thead> <tr> <th style='display:none'  class='text-center'>label</th> <th style='display:none' class='text-center'>id</th> <th style='display:none'  class='text-center'>avalue</th></tr></thead>";
                    $tabs .= "<tbody>";

                    $active = $activeIn = '';
                    $emptyForms = false;

                    foreach ($customFields as $customField) {

                        if($this->customTableFieldExists($customTable->customTableName,$customField->customTableField)){

                            $lastValue = $values["$customField->customTableField"];
                            if($viewOnly){$customField->type = 'label';}

                            $input = $this->getCustomTableInputType($customField->type,$customField->css,$customField->class,$customField->customTableField,"$lastValue",$customField->defaultValues,$disabled,!$disabled,$required='no');

                            $tabs .= "<tr>";
                            $tabs .= "<td style='border-bottom: 0.5px solid lightgrey;border-right: 0.5px solid lightgrey;'><label style='color:#222'>$customField->displayName</label></td>";
                            $tabs .= "<td style='display:none;border-bottom: 0.5px solid lightgrey;'><input id='$customTable->customTableName|$customField->customTableField' name='$customTable->customTableName|$customField->customTableField' value='$customField->customTableField' hidden></td>";
                            $tabs .= "<td class='form-control' style='margin-left:5px;border-bottom: 0.5px solid lightgrey;'>$input</td>";
                            $tabs .= "</tr>";
                        }

                    }

                    $tabs .= "</tbody>";
                    $tabs .= "</table>";
                    $tabs .= "</form>";
                    $tabs .= "</div>";



                } else {

                    $lis .="<li id='ctliactivation$counter' class='' onclick='loadCustomTableFormFromClass(\"$customTable->customTableName\",\"$customTable->customTableCode\",\"$customTable->customTableID\",\"$this->linkedTableID\",\"$counter\",$disabled)'>";
                    $lis .="<a data-toggle='tab' href='#ct$counter' id='ctlink$counter' ><i class='fa fa-table' style='margin-right: 5px;color: #0a0a0a;'></i><span class='hidden-mobile hidden-tablet' style='color: #0a0a0a;'>$customTable->displayName</span></a>";
                    $lis .="</li>";


                    $tabs .= "<div class='tab-pane fade' id='ct$counter' ><br/><br/><br/>";
                    $tabs .= "</div>";
                }

            }


            $counter++;

        }

        if($emptyForms && !$embed){
            echo "<script>
                                $(document).ready(function() {
                                $('#ctliactivation0').addClass('active');
                                $('#ct0').addClass('active in');
                                $('#ctlink0').click();
                                });
                               </script>";
        }

        if(!$viewOnly) {
            echo "<script>
                                function loadCustomTableFormFromClass(customTableName,customTableCode,customTableID,linkedTableID,formID,disabled){
                                    $.ajax({
                                        type: 'POST',
                                        url: '//" . HTML_PATH . "/cop/backend/core/model/CustomTable.php',
                                        data: {
                                            'customTableCode': customTableCode,
                                            'customTableID': customTableID,
                                            'linkedTableID': linkedTableID,
                                            'customTableName': customTableName,
                                            'disabled': disabled,
                                            
                                            },
                                        success: function (result) { 
                                            $('#ct'+formID).html(result);
                                            $('#ctliactivation'+formID).prop(\"onclick\", null).off(\"click\");
                                        }
                                    });
                                            
                                }
                              </script>";
        }

        if($embed){
            $result = new stdClass();
            $result->lis = $lis;
            $result->tabs = $tabs;
            return $result;

        } else {
            echo "<ul class=\"nav nav-tabs pull-left in\" id=\"myCustTable\" style='padding-top: 5px;'>";
            echo $lis;
            echo "</ul>";
            echo "<div id=\"myTabContent\" class=\"tab-content\" style='padding-bottom: 5px;'>";
            echo $tabs;
            echo "</div>";
            return '';
        }



    }

    private function createCustomTableLines($edit,$disabled,$viewOnly=false,$nextLineNumber=0)
    {
        $customTables = $this->getCustomTables();
        $headers      = '';
        $lines        = '';


        foreach ($customTables as $customTable){

            if($this->customTableExists($customTable->customTableName)){

                $customFields = $this->getCustomTableFields($customTable->customTableID);
                $values = $this->getCustomTableValues("$customTable->customTableName","$this->linkedTableID");
                $values = (array)$values;


                foreach ($customFields as $customField) {

                    if($this->customTableFieldExists($customTable->customTableName,$customField->customTableField)){

                        $lastValue = $values["$customField->customTableField"];
                        if($viewOnly){$customField->type = 'label';}

                        $input = $this->getCustomTableInputType($customField->type,$customField->css,$customField->class,$customField->customTableField,"$lastValue",$customField->defaultValues,$disabled,!$disabled,$required='no');

                        $headers .= "<th class='text-center'>$customField->displayName</th>";
                        $lines .= "<td class='text-center' >$input</td>";

                        if(strcmp($customField->type,'checkbox')==0){$customField->customTableField .= ":checked";}

                        $jsonLines .= ",
                                        $nextLineNumber: function(cellIndex, cell) {
                                            var valueTXT='';
                                            var valueSLCT='';
                                            var valueCHK='';
                                            var valueTXTAREA='';
                                            if(cell.find('input').val() != null){
                                                if(cell.find('input').is(':checkbox')){
                                                    if(cell.find('input').prop('checked')){
                                                        valueTXT = 'yes';
                                                    } else {
                                                        valueTXT = 'no';
                                                    }
                                                } else {
                                                    valueTXT = cell.find('input').val();
                                                }
                                            }
                                            if(cell.find('select').val() != null){
                                                valueSLCT = cell.find('select').val();
                                            } 
                                            if(cell.find('textarea').val() != null){
                                                valueTXTAREA = cell.find('textarea').val();
                                            }
                                            var value = valueTXT+valueSLCT+valueTXTAREA;
                                            
                                            return value;
                                       }";

                        $nextLineNumber++;
                    }

                }

            }

        }




        $result = new stdClass();
        $result->headers = $headers;
        $result->lines = $lines;
        $result->jsonLines = $jsonLines;
        return $result;





    }

    private function createCustomTableB2BFilters($edit,$disabled,$viewOnly=false,$nextLineNumber=3,$customTableID=0,$allLabel=' - All - ')
    {
        $customTables = $this->getCustomTables();
        $result = '';
        $json = '';
        $counter = 0;

        foreach ($customTables as $customTable){

            if($customTable->customTableID != $customTableID && $customTableID > 0){continue;}

            if($this->customTableExists($customTable->customTableName)){

                $customFields = $this->getCustomTableFields($customTable->customTableID);
                $values = $this->getCustomTableValues("$customTable->customTableName","$this->linkedTableID");
                $values = (array)$values;

                $colspan = $nextLineNumber*4;

                $result = "</tr>
                            <tr><td colspan='$colspan' class='text-capitalize text-center' style='font-size: 24px;padding: 5px;'>$customTable->displayName</td>
                            <tr><td colspan='$colspan' class='text-capitalize text-center'>&nbsp;</td>
                            </tr>";

                foreach ($customFields as $customField) {

                    if($this->customTableFieldExists($customTable->customTableName,$customField->customTableField)){
                        $counter++;

                        $lastValue = $values["$customField->customTableField"];
                        if($viewOnly){$customField->type = 'label';}

                        $input = $this->getCustomTableInputType($customField->type,$customField->css,$customField->class,$customField->customTableField,"$lastValue",$customField->defaultValues,$disabled,!$disabled,$required='no',true,$allLabel);

                        $result .= "<td>&nbsp;</td>";
                        $result .= "<td class='text-center text-capitalize' style='font-weight: bolder;'>$customField->displayName:</td>";
                        $result .= "<td class='text-center'>$input</td>";
                        $result .= "<td>&nbsp;&nbsp;&nbsp;</td>";


                        $jsonVars .= 'var '.$customField->customTableField.' = $("#'.$customField->customTableField.'").val();'."\n";
                        $jsonVarsPass .= ",$customField->customTableField:$customField->customTableField";
                        $json .= '$(\'#'.$customField->customTableField.'\').on(\'change\', function() {performAdvancedSearch(\''.$customTable->customTableName.'\','.$customTable->customTableID.');});'."\n";




                        if($counter%$nextLineNumber  == 0){
                            $result .= "</tr><tr>";
                        }



                    }

                }

            }

        }

        if(strcmp($result,'')!=0){
            $result = "<table style='width: 100%;'><tr>$result</tr><tr><td colspan='$colspan' class='text-capitalize text-center'>&nbsp;</td></table>";
            $result .= "<script type='text/javascript'> 
                        $json
                        
                        function performAdvancedSearch(custTable,ctid){
                            $jsonVars
                            
                            run_waitMe('bounce');
                            var categorySelect = $.cookie('currentCategory');
                    
                            $.ajax({
                                type: 'POST',
                                url: './dbaccess/getItems.php',
                                data: {advancedSearch:'yes',custTable:custTable,ctid:ctid,pageNumber:pageNumber,numItemsInPage:recordsPerPage,categorySelect:categorySelect $jsonVarsPass },
                                success: function (result) {
                    
                                   $('#productGrid').empty();
                                   $('#productGrid').append(result);
                                   addButtonListeners();
                    
                    
                                   $('.pagination').hide();
                    
                                   var totalNumRecords = $('#productGrid').find('#counter').val();
                    
                                   stop_waitMe();
                    
                                   if (recordsPerPage < totalNumRecords) {
                                       AdvancedPagination(recordsPerPage, totalNumRecords,false,custTable,ctid);
                                   }
                                }
                            });
                        }
                        
                        function AdvancedPagination(recordsPerPage, totalNumRecords,notLoaded,custTable,ctid){
                            //Show the pagination controls
                            $('.pagination').show();
                        
                            //loop through all of the divs and hide them by default.
                            for (var i=1; i <= totalNumRecords; i++) {
                                $('#productGrid').find('#div' + i).hide();
                            }
                        
                            //then only display the number of divs the user dictated
                            for (var i = 1; i <= recordsPerPage; i++) {
                                $('#productGrid').find('#div' + i).show();
                            }
                        
                            //maxPages is the maximum amount of pages needed for pagination. (round up)
                            var maxPages = Math.ceil(totalNumRecords/recordsPerPage);
                        
                            var pageNumber =  $.cookie('pageNumber');
                        
                            var pageToSet;
                        
                            if(pageNumber != null)
                            {
                                pageToSet = pageNumber;
                            }
                            else {
                                pageToSet = 1;
                            }
                        
                            $('.pagination').jqPagination({
                                link_string : '/?page={page_number}',
                                max_page     : maxPages,
                                current_page : pageToSet,
                                paged        : function(page) {
                        
                                    $.cookie('pageNumber', page);
                        
                                    //a new page has been requested
                        
                                    //loop through all of the divs and hide them all.
                                    for (var i = 1; i <= totalNumRecords; i++) {
                                        $('#productGrid').find('#div' + i).hide();
                                    }
                        
                                    //Find the range of the records for the page:
                                    var recordsFrom = recordsPerPage * (page - 1) + 1;
                                    var recordsTo = recordsPerPage * (page);
                        
                                    //then display only the records on the specified page
                                    for (var i = recordsFrom; i <= recordsTo; i++) {
                                        $('#productGrid').find('#div' + i).show();
                                    }
                        
                                    //scroll to the top of the page if the page is changed
                                    $('html, body').animate({scrollTop: 0}, 'slow');
                        
                        
                                    var currentCategory = $.cookie('currentCategory');
                        
                                    if (currentCategory == 'search') {
                                        var searchString = $.cookie('searchString');
                        
                                        performSearchInPage(searchString, page, recordsPerPage);
                        
                                        $('#searchButton').val(searchString);
                                    }
                                    else {
                                        AdvancedGetItemsInCategoryInPage(currentCategory, page, recordsPerPage,custTable,ctid);
                                    }
                                }
                            });
                        
                            $('.pagination').jqPagination('option', 'current_page', pageToSet);
                        }
                        
                        function AdvancedGetItemsInCategoryInPage(categorySelect,pageNumber,numItemsInPage,custTable,ctid)
                        {
                            var  queryText= $('#searchButton').val('');
                            $jsonVars
                            run_waitMe('bounce');
                            $.ajax({
                                type: 'POST',
                                url: './dbaccess/getItems.php',
                                data: {advancedSearch:'yes',custTable:custTable,ctid:ctid,pageNumber:pageNumber,numItemsInPage:recordsPerPage,categorySelect:categorySelect $jsonVarsPass },
                                success: function (result) {
                        
                        
                                    $('#productGrid').empty();
                                    $('#productGrid').append(result);
                                    addButtonListeners();
                        
                        
                                }
                            });
                        }
                         
                        </script>";
        }

        return $result;

    }

    private function make_greeklish($text) {
        $expressions = array(
            '/[αΑ][ιίΙΊ]/u' => 'e',
            '/[οΟΕε][ιίΙΊ]/u' => 'i',
            '/[αΑ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'af$1',
            '/[αΑ][υύΥΎ]/u' => 'av',
            '/[εΕ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'ef$1',
            '/[εΕ][υύΥΎ]/u' => 'ev',
            '/[οΟ][υύΥΎ]/u' => 'ou',
            '/(^|\s)[μΜ][πΠ]/u' => '$1b',
            '/[μΜ][πΠ](\s|$)/u' => 'b$1',
            '/[μΜ][πΠ]/u' => 'mp',
            '/[νΝ][τΤ]/u' => 'nt',
            '/[τΤ][σΣ]/u' => 'ts',
            '/[τΤ][ζΖ]/u' => 'tz',
            '/[γΓ][γΓ]/u' => 'ng',
            '/[γΓ][κΚ]/u' => 'gk',
            '/[ηΗ][υΥ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'if$1',
            '/[ηΗ][υΥ]/u' => 'iu',
            '/[θΘ]/u' => 'th',
            '/[χΧ]/u' => 'ch',
            '/[ψΨ]/u' => 'ps',
            '/[αά]/u' => 'a',
            '/[βΒ]/u' => 'v',
            '/[γΓ]/u' => 'g',
            '/[δΔ]/u' => 'd',
            '/[εέΕΈ]/u' => 'e',
            '/[ζΖ]/u' => 'z',
            '/[ηήΗΉ]/u' => 'i',
            '/[ιίϊΙΊΪ]/u' => 'i',
            '/[κΚ]/u' => 'k',
            '/[λΛ]/u' => 'l',
            '/[μΜ]/u' => 'm',
            '/[νΝ]/u' => 'n',
            '/[ξΞ]/u' => 'x',
            '/[οόΟΌ]/u' => 'o',
            '/[πΠ]/u' => 'p',
            '/[ρΡ]/u' => 'r',
            '/[σςΣ]/u' => 's',
            '/[τΤ]/u' => 't',
            '/[υύϋΥΎΫ]/u' => 'i',
            '/[φΦ]/iu' => 'f',
            '/[ωώ]/iu' => 'o',
        );

        $text = preg_replace( array_keys($expressions), array_values($expressions), $text);
        return $text;
    }

    private function transliterateString($txt) {
        $transliterationTable = array('á' => 'a', 'Á' => 'A', 'à' => 'a', 'À' => 'A', 'ă' => 'a', 'Ă' => 'A', 'â' => 'a', 'Â' => 'A', 'å' => 'a', 'Å' => 'A', 'ã' => 'a', 'Ã' => 'A', 'ą' => 'a', 'Ą' => 'A', 'ā' => 'a', 'Ā' => 'A', 'ä' => 'ae', 'Ä' => 'AE', 'æ' => 'ae', 'Æ' => 'AE', 'ḃ' => 'b', 'Ḃ' => 'B', 'ć' => 'c', 'Ć' => 'C', 'ĉ' => 'c', 'Ĉ' => 'C', 'č' => 'c', 'Č' => 'C', 'ċ' => 'c', 'Ċ' => 'C', 'ç' => 'c', 'Ç' => 'C', 'ď' => 'd', 'Ď' => 'D', 'ḋ' => 'd', 'Ḋ' => 'D', 'đ' => 'd', 'Đ' => 'D', 'ð' => 'dh', 'Ð' => 'Dh', 'é' => 'e', 'É' => 'E', 'è' => 'e', 'È' => 'E', 'ĕ' => 'e', 'Ĕ' => 'E', 'ê' => 'e', 'Ê' => 'E', 'ě' => 'e', 'Ě' => 'E', 'ë' => 'e', 'Ë' => 'E', 'ė' => 'e', 'Ė' => 'E', 'ę' => 'e', 'Ę' => 'E', 'ē' => 'e', 'Ē' => 'E', 'ḟ' => 'f', 'Ḟ' => 'F', 'ƒ' => 'f', 'Ƒ' => 'F', 'ğ' => 'g', 'Ğ' => 'G', 'ĝ' => 'g', 'Ĝ' => 'G', 'ġ' => 'g', 'Ġ' => 'G', 'ģ' => 'g', 'Ģ' => 'G', 'ĥ' => 'h', 'Ĥ' => 'H', 'ħ' => 'h', 'Ħ' => 'H', 'í' => 'i', 'Í' => 'I', 'ì' => 'i', 'Ì' => 'I', 'î' => 'i', 'Î' => 'I', 'ï' => 'i', 'Ï' => 'I', 'ĩ' => 'i', 'Ĩ' => 'I', 'į' => 'i', 'Į' => 'I', 'ī' => 'i', 'Ī' => 'I', 'ĵ' => 'j', 'Ĵ' => 'J', 'ķ' => 'k', 'Ķ' => 'K', 'ĺ' => 'l', 'Ĺ' => 'L', 'ľ' => 'l', 'Ľ' => 'L', 'ļ' => 'l', 'Ļ' => 'L', 'ł' => 'l', 'Ł' => 'L', 'ṁ' => 'm', 'Ṁ' => 'M', 'ń' => 'n', 'Ń' => 'N', 'ň' => 'n', 'Ň' => 'N', 'ñ' => 'n', 'Ñ' => 'N', 'ņ' => 'n', 'Ņ' => 'N', 'ó' => 'o', 'Ó' => 'O', 'ò' => 'o', 'Ò' => 'O', 'ô' => 'o', 'Ô' => 'O', 'ő' => 'o', 'Ő' => 'O', 'õ' => 'o', 'Õ' => 'O', 'ø' => 'oe', 'Ø' => 'OE', 'ō' => 'o', 'Ō' => 'O', 'ơ' => 'o', 'Ơ' => 'O', 'ö' => 'oe', 'Ö' => 'OE', 'ṗ' => 'p', 'Ṗ' => 'P', 'ŕ' => 'r', 'Ŕ' => 'R', 'ř' => 'r', 'Ř' => 'R', 'ŗ' => 'r', 'Ŗ' => 'R', 'ś' => 's', 'Ś' => 'S', 'ŝ' => 's', 'Ŝ' => 'S', 'š' => 's', 'Š' => 'S', 'ṡ' => 's', 'Ṡ' => 'S', 'ş' => 's', 'Ş' => 'S', 'ș' => 's', 'Ș' => 'S', 'ß' => 'SS', 'ť' => 't', 'Ť' => 'T', 'ṫ' => 't', 'Ṫ' => 'T', 'ţ' => 't', 'Ţ' => 'T', 'ț' => 't', 'Ț' => 'T', 'ŧ' => 't', 'Ŧ' => 'T', 'ú' => 'u', 'Ú' => 'U', 'ù' => 'u', 'Ù' => 'U', 'ŭ' => 'u', 'Ŭ' => 'U', 'û' => 'u', 'Û' => 'U', 'ů' => 'u', 'Ů' => 'U', 'ű' => 'u', 'Ű' => 'U', 'ũ' => 'u', 'Ũ' => 'U', 'ų' => 'u', 'Ų' => 'U', 'ū' => 'u', 'Ū' => 'U', 'ư' => 'u', 'Ư' => 'U', 'ü' => 'ue', 'Ü' => 'UE', 'ẃ' => 'w', 'Ẃ' => 'W', 'ẁ' => 'w', 'Ẁ' => 'W', 'ŵ' => 'w', 'Ŵ' => 'W', 'ẅ' => 'w', 'Ẅ' => 'W', 'ý' => 'y', 'Ý' => 'Y', 'ỳ' => 'y', 'Ỳ' => 'Y', 'ŷ' => 'y', 'Ŷ' => 'Y', 'ÿ' => 'y', 'Ÿ' => 'Y', 'ź' => 'z', 'Ź' => 'Z', 'ž' => 'z', 'Ž' => 'Z', 'ż' => 'z', 'Ż' => 'Z', 'þ' => 'th', 'Þ' => 'Th', 'µ' => 'u', 'а' => 'a', 'А' => 'a', 'б' => 'b', 'Б' => 'b', 'в' => 'v', 'В' => 'v', 'г' => 'g', 'Г' => 'g', 'д' => 'd', 'Д' => 'd', 'е' => 'e', 'Е' => 'E', 'ё' => 'e', 'Ё' => 'E', 'ж' => 'zh', 'Ж' => 'zh', 'з' => 'z', 'З' => 'z', 'и' => 'i', 'И' => 'i', 'й' => 'j', 'Й' => 'j', 'к' => 'k', 'К' => 'k', 'л' => 'l', 'Л' => 'l', 'м' => 'm', 'М' => 'm', 'н' => 'n', 'Н' => 'n', 'о' => 'o', 'О' => 'o', 'п' => 'p', 'П' => 'p', 'р' => 'r', 'Р' => 'r', 'с' => 's', 'С' => 's', 'т' => 't', 'Т' => 't', 'у' => 'u', 'У' => 'u', 'ф' => 'f', 'Ф' => 'f', 'х' => 'h', 'Х' => 'h', 'ц' => 'c', 'Ц' => 'c', 'ч' => 'ch', 'Ч' => 'ch', 'ш' => 'sh', 'Ш' => 'sh', 'щ' => 'sch', 'Щ' => 'sch', 'ъ' => '', 'Ъ' => '', 'ы' => 'y', 'Ы' => 'y', 'ь' => '', 'Ь' => '', 'э' => 'e', 'Э' => 'e', 'ю' => 'ju', 'Ю' => 'ju', 'я' => 'ja', 'Я' => 'ja');
        return str_replace(array_keys($transliterationTable), array_values($transliterationTable), $txt);
    }

    private function getLastValueOfCustomFormForUDT($customFormID,$customFieldID,$tableName,$tableID)
    {
        global $username, $password, $database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $value="test";
        $stm = $db->prepare("SELECT value FROM ZA_Custom_Field_Object,ZA_Custom_Form_Object,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Object.custom_form_id='$customFormID' AND ZA_Custom_Form_Object.custom_form_id =ZA_Custom_Form_Usage.custom_form_id AND ZA_Custom_Form_Usage.linked_table='$tableName' AND  ZA_Custom_Form_Object.linked_table_id='$tableID' AND ZA_Custom_Form_Object.custom_form_object_id=ZA_Custom_Field_Object.custom_form_object_id AND ZA_Custom_Field_Object.custom_field_id='$customFieldID' LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($value);
        while ($stm->fetch()) {


        }
        $stm-> close();

        return $value;
    }

    public function generateTablesInApp()
    {
        $arrayOfCommands = array();
        $customTables = $this->getAllCustomTables();

        foreach ($customTables as $customTable){

            $customFields = $this->getCustomTableFields($customTable->customTableID,'');
            $customTable->customFields = $customFields;

            $queryFields = '';
            foreach ($customFields as $customField) {
                $queryFields .= " $customField->customTableField VARCHAR(300) NOT NULL,";
            }

            $query  = "CREATE TABLE IF NOT EXISTS";
            $query .= " $customTable->customTableName ";
            $query .= "(id INT NOT NULL,$queryFields timestamp TIMESTAMP on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,PRIMARY KEY (id))";

            $sqlLiteQuery = mysqlToSqlite($query);

            array_push($arrayOfCommands,$sqlLiteQuery);

        }

        return $arrayOfCommands;

    }
    public function createTables()
    {
        $customTables = $this->getAllCustomTables();

        foreach ($customTables as $customTable){

            $customFields = $this->getCustomTableFields($customTable->customTableID,'');
            $customTable->customFields = $customFields;

            if(!$this->customTableExists($customTable->customTableName)){

                $queryFields = '';
                foreach ($customFields as $customField) {
                    $queryFields .= " $customField->customTableField VARCHAR(300) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,";
                }

                $query  = "CREATE TABLE";
                $query .= " $customTable->customTableName ";
                $query .= "(id INT NOT NULL,$queryFields timestamp TIMESTAMP on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,PRIMARY KEY (id))";

                global $username, $password, $database;
                $db2 = new mysqli(localhost, $username, $password, $database);
                if (mysqli_connect_errno()) {
                    printf("Connect failed: %s\n", mysqli_connect_error());
                    exit();
                }

                $db2->set_charset("utf8");
                $stm2 = $db2->prepare("$query");
                $stm2->execute();
                $stm2->close();

                $sqlLiteQuery = mysqlToSqlite($query);
                $db2->set_charset("utf8");
                $stm2 = $db2->prepare("INSERT INTO ZA_Custom_Tables_App_Sync (command) VALUES (?)");
                $stm2->bind_param('s',$sqlLiteQuery);
                $stm2->execute();
                $stm2->close();

            } else {

                global $username, $password, $database;
                $db2 = new mysqli(localhost, $username, $password, $database);
                if (mysqli_connect_errno()) {
                    printf("Connect failed: %s\n", mysqli_connect_error());
                    exit();
                }
                $db2->set_charset("utf8");

                $notExistingFields = array();
                foreach ($customFields as $customField) {
                    if(!$this->customTableFieldExists($customTable->customTableName,$customField->customTableField)){

                        $stm2 = $db2->prepare("SELECT COLUMN_NAME FROM information_schema.columns WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? ORDER BY ORDINAL_POSITION DESC LIMIT 1, 1");
                        $stm2-> bind_param('ss',$database,$customTable->customTableName);
                        $stm2-> execute();
                        $stm2-> bind_result($lastColumnName);
                        while ($stm2->fetch()) {}
                        $stm2-> close();

                        $query  = "ALTER TABLE $customTable->customTableName ADD $customField->customTableField VARCHAR(300) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL AFTER $lastColumnName";
                        $stm2 = $db2->prepare("$query");
                        $stm2->execute();
                        $stm2->close();

                        array_push($notExistingFields,$customField->customTableField);

                    }
                }

                // -------------- APP SYNC ----------------
                if(count($notExistingFields) > 0) {
                    $replaceSqlLiteFields = '';
                    $oldSqlLiteFields = '';
                    $newSqlLiteFields = '';

                    foreach ($this->getCustomTableFields($customTable->customTableID,'') as $sqlLiteCustomField) {
                        $replaceSqlLiteFields .= " $sqlLiteCustomField->customTableField, ";

                        if (!in_array($sqlLiteCustomField->customTableField, $notExistingFields) == 0) {
                            $oldSqlLiteFields .= " '', ";
                        } else {
                            $oldSqlLiteFields .= " $sqlLiteCustomField->customTableField, ";
                        }

                        $newSqlLiteFields .= " $sqlLiteCustomField->customTableField VARCHAR(300) NOT NULL DEFAULT '',";
                    }

                    $sqlLiteQuery = "ALTER TABLE $customTable->customTableName RENAME TO $customTable->customTableName" . "OLD";
                    $stm2 = $db2->prepare("INSERT INTO ZA_Custom_Tables_App_Sync (command) VALUES (?)");
                    $stm2->bind_param('s', $sqlLiteQuery);
                    $stm2->execute();
                    $stm2->close();

                    $sqlLiteQuery = mysqlToSqlite("CREATE TABLE $customTable->customTableName (id INT NOT NULL,$newSqlLiteFields timestamp TIMESTAMP on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,PRIMARY KEY (id))");
                    $stm2 = $db2->prepare("INSERT INTO ZA_Custom_Tables_App_Sync (command) VALUES (?)");
                    $stm2->bind_param('s', $sqlLiteQuery);
                    $stm2->execute();
                    $stm2->close();

                    $sqlLiteQuery = "INSERT INTO $customTable->customTableName(id,$replaceSqlLiteFields timestamp) SELECT id,$oldSqlLiteFields timestamp FROM $customTable->customTableName" . "OLD";
                    $stm2 = $db2->prepare("INSERT INTO ZA_Custom_Tables_App_Sync (command) VALUES (?)");
                    $stm2->bind_param('s', $sqlLiteQuery);
                    $stm2->execute();
                    $stm2->close();

                    $sqlLiteQuery = "DROP TABLE IF EXISTS $customTable->customTableName" . "OLD";
                    $stm2 = $db2->prepare("INSERT INTO ZA_Custom_Tables_App_Sync (command) VALUES (?)");
                    $stm2->bind_param('s', $sqlLiteQuery);
                    $stm2->execute();
                    $stm2->close();
                }
                // -------------- APP SYNC/----------------

            }



        }

        return $customTables;

    }

    public function checkTable($customTableID)
    {
        $query = '';
        global $username, $password, $database;
        $db2 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $customTables = array();
        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SELECT custom_table_id, custom_table_code, custom_table_name, display_name, linked_table, status, type, position FROM ZA_Custom_Tables WHERE custom_table_id='$customTableID' LIMIT 1");
        $stm2->execute();
        $stm2->bind_result($customTableID, $customTableCode, $customTableName,$displayName,$linkedTable,$customTableStatus,$customTableType,$position);
        while ($stm2->fetch()) {
            $line = new stdClass();
            $line->customTableID = $customTableID;
            $line->customTableCode = $customTableCode;
            $line->customTableName = $customTableName;
            $line->displayName = $displayName;
            $line->linkedTable = $linkedTable;
            $line->customTableStatus = $customTableStatus;
            $line->customTableType = $customTableType;
            $line->position = $position;

            array_push($customTables,$line);

        }
        $stm2->close();;

        foreach ($customTables as $customTable){

            $customFields = $this->getCustomTableFields($customTable->customTableID);
            $customTable->customFields = $customFields;

            if(!$this->customTableExists($customTable->customTableName)){

                $queryFields = '';
                foreach ($customFields as $customField) {
                    $queryFields .= " $customField->customTableField VARCHAR() CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,";
                }

                $query  = "CREATE TABLE";


            } else {

                foreach ($customFields as $customField) {
                    if(!$this->customTableFieldExists($customTable->customTableName,$customField->customTableField)){
                        $query  = "COMMIT CHANGES";


                    }
                }

            }

            return $query;

        }

        return $customTables;

    }

    public function convertCustomFormToCustomTable($customFormID,$linkedTable='')
    {
        require_once(ROOT . "concc/dbhelpers/dbhelper.php");
        global $username, $password, $database;
        $db2 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $customForms = array();

        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SELECT custom_form_definition_id,custom_form_code,custom_form_name FROM ZA_Custom_Form_Definition WHERE custom_form_definition_id='$customFormID' LIMIT 1");
        $stm2->execute();
        $stm2->bind_result($customFormID, $customFormCode, $customFormName);
        while ($stm2->fetch()) {

            $customForm = new stdClass();
            $customForm->id = $customFormID;
            $customForm->code = $customFormCode;
            $customForm->name = $customFormName;
            $customForm->linkedTable = $linkedTable;

            array_push($customForms,$customForm);

        }
        $stm2->close();

        foreach ($customForms as $customForm) {

            $customFormObjects = array();
            $db2->set_charset("utf8");
            $stm2 = $db2->prepare("SELECT custom_form_object_id,linked_table_id FROM ZA_Custom_Form_Object WHERE custom_form_id='$customForm->id' AND custom_form_code='$customForm->code'");
            $stm2->execute();
            $stm2->bind_result($customFormObjectID,$linkedTableID);
            while ($stm2->fetch()) {

                $customFormObject = new stdClass();
                $customFormObject->id = $customFormObjectID;
                $customFormObject->linkedTableID = $linkedTableID;


                array_push($customFormObjects,$customFormObject);

            }
            $stm2->close();

            $customForm->objects = $customFormObjects;

            $customFields = array();
            $db2->set_charset("utf8");
            $stm2 = $db2->prepare("SELECT ZA_Custom_Field_Definition.custom_field_id,ZA_Custom_Form_Custom_Field.position,custom_field_name,type,values_range,css_style,class FROM ZA_Custom_Form_Custom_Field,ZA_Custom_Field_Definition WHERE ZA_Custom_Form_Custom_Field.custom_field_id = ZA_Custom_Field_Definition.custom_field_id AND custom_form_id='$customForm->id'");
            $stm2->execute();
            $stm2->bind_result($customFieldID,$customFieldPosition,$customfieldName,$type,$valuesRange,$css,$class);
            while ($stm2->fetch()) {

                $customField = new stdClass();
                $customField->id = $customFieldID;
                $customField->name = $customfieldName;
                $customField->position = $customFieldPosition;
                $customField->type = $type;
                $customField->valuesRange = $valuesRange;
                $customField->css = $css;
                $customField->class = $class;

                array_push($customFields,$customField);

            }
            $stm2->close();

            $customForm->customFields = $customFields;

        }


        foreach ($customForms as $customForm) {

            $customTableID = getNextKey("ZA_Custom_Tables","custom_table_id");
            $displayCode   = $customForm->code;
            $displayName   = $customForm->name;
            $linkedTable   = $customForm->linkedTable;
            $status        = 'yes';
            $type          = 'UDT';
            $position      = '1';
            $updateApp     = 'no';


            global $username,$password,$database;
            $db = new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno())
            {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }

            $tableNumber = 0;
            $db->set_charset("utf8");
            $stmt = $db->prepare("SELECT count(*) FROM ZA_Custom_Tables");
            $stmt->execute();
            $stmt->bind_result($tablesCounter);
            while ($stmt->fetch()) {
                if($tablesCounter > $tableNumber){$tableNumber = $tablesCounter;}
            }
            $stmt->close();

            $tableNumber++;
            $customTableName = $displayName;
            $customTableName = str_replace(' ','_',$customTableName);
            $customTableName = $this->make_greeklish($customTableName);
            $customTableName = $this->transliterateString($customTableName);
            $customTableName = preg_replace("/[^a-zA-Z_0-9]+/", "", $customTableName);
            $customTableName = 'ZA_CT_'.$tableNumber.'_'.$customTableName;

            $customTableCode = $displayCode;
            $customTableCode = str_replace(' ','_',$customTableCode);
            $customTableCode = $this->make_greeklish($customTableCode);
            $customTableCode = $this->transliterateString($customTableCode);
            $customTableCode = preg_replace("/[^a-zA-Z_0-9]+/", "", $customTableCode);
            $customTableCode = 'CF_'.$tableNumber.'_'.$customTableCode;

            $customForm->customTableName = $customTableName;

            $db->set_charset("utf8");
            $stmt = $db->prepare("INSERT INTO ZA_Custom_Tables (custom_table_id, custom_table_code, custom_table_name, display_name, linked_table, status, type, position, update_app, timestamp) VALUES (?,?,?,?,?,?,?,?,?,NOW())");
            $stmt->bind_param('sssssssss',$customTableID,$customTableCode,$customTableName,$displayName,$linkedTable,$status,$type,$position,$updateApp);
            $stmt->execute();
            $stmt->close();

            $fieldCounter=0;
            foreach($customForm->customFields as $customField)
            {
                if(strcmp(trim($customField->name),'')!=0){
                    $fieldCounter++;

                    $linePosition = $customField->position;
                    $fieldName = $customField->name;
                    $fieldType = $customField->type;
                    $visible = 'yes';
                    $defaultValues = $customField->valuesRange;
                    $css = $customField->css;
                    $class = $customField->class;

                    if(strcmp($class,'')==0){$class='form-control';}

                    $customTableField = $fieldName;
                    $customTableField = str_replace(' ','_',$customTableField);
                    $customTableField = $this->make_greeklish($customTableField);
                    $customTableField = $this->transliterateString($customTableField);
                    $customTableField = preg_replace("/[^a-zA-Z_0-9]+/", "", $customTableField);
                    $customTableField = "CF_".$fieldCounter."_".$customTableField;

                    $customField->customTableField = $customTableField;


                    $db->set_charset("utf8");
                    $stmt = $db->prepare("INSERT INTO ZA_Custom_Table_Fields (custom_table_id, custom_table_field, display_name, type, visible, position, default_values, css_style, class, timestamp) VALUES (?,?,?,?,?,?,?,?,?,NOW())");
                    $stmt->bind_param('sssssssss',$customTableID,$customTableField,$fieldName,$fieldType,$visible,$linePosition,$defaultValues,$css,$class);
                    $stmt->execute();
                    $stmt->close();

                }

            }

        }

        $this->createTables();

        foreach ($customForms as $customForm){
            foreach ($customForm->objects as $object) {

                $linkedTableID = $object->linkedTableID;

                $insertColumns       = array();
                $insertValues        = array();

                foreach ($customFields as $customField) {
                    $customFormID = $customForm->id;
                    $customFieldID = $customField->id;

                    $value = $this->getLastValueOfCustomFormForUDT($customFormID,$customFieldID,$linkedTable,$linkedTableID);

                    array_push($insertColumns,$customField->customTableField);
                    array_push($insertValues,"'$value'");

                }
                $imColumns = implode(',',$insertColumns);
                $imInsertValues = implode(',',$insertValues);
                $query = "INSERT IGNORE INTO $customForm->customTableName (id,$imColumns,timestamp) VALUES ($linkedTableID,$imInsertValues,NOW())";

                $db->set_charset("utf8");
                $stmt = $db->prepare("$query");
                $stmt->execute();
                $stmt->close();
            }
        }

    }


    public function getCustomTableValues($customTableName,$id,$idColumn='id')
    {
        $values = '';
        if($this->customTableExists($customTableName)) {
            global $username, $password, $database;
            $db2 = new mysqli(localhost, $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $z = false;
            $db2->set_charset("utf8");
            $result = $db2->query("SELECT * FROM $customTableName WHERE $idColumn='$id' LIMIT 1") or die("SQL Error: " . $db2->error);
            while ($row = $result->fetch_object()) {
                $values = $row;
            }
        }

        return $values;

    }

    public function getAllCustomTablesWithValues($db=''){

        if(is_string($db) && strcmp($db,'')==0) {
            global $username, $password, $database;
            $db = new mysqli(localhost, $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db->set_charset("utf8");
        }

        $customTables = array();
        $stm = $db->prepare("SELECT custom_table_id,custom_table_code,custom_table_name,display_name FROM ZA_Custom_Tables WHERE linked_table='$this->linkedTable'");
        $stm->execute();
        $stm->bind_result($customTableID,$customTableCode,$customTableTable,$customTableName);
        while ($stm->fetch()) {
            $customTable = new stdClass();
            $customTable->id = $customTableID;
            $customTable->code = $customTableCode;
            $customTable->form = $customTableName;
            $customTable->table = $customTableTable;
            $customTables["$customTableTable"] = $customTable;
        }
        $stm->close();

        foreach($customTables as $customTable) {
            $customTableFields = array();
            $stm = $db->prepare("SELECT custom_table_field,display_name,default_values,type FROM ZA_Custom_Table_Fields WHERE custom_table_id='$customTable->id' AND visible='yes'");
            $stm->execute();
            $stm->bind_result($customTableField,$customTableFieldName,$default_values,$type);
            while ($stm->fetch()) {
                $customTableFields["$customTableField"]["field"] = $customTableFieldName;
                $customTableFields["$customTableField"]["defaultValues"] = $default_values;
                $customTableFields["$customTableField"]["type"] = $type;
            }
            $stm->close();

            $customTableValues = array();
            $result = $db->query("SELECT * FROM $customTable->table WHERE id='$this->linkedTableID' LIMIT 1") or die("SQL Error: " . $db->error);
            while ($row = $result->fetch_assoc()) {
                $customTableValues = $row;
            }

            $resultArray = array();
            foreach($customTableFields as $key => $array2) {
                foreach ($array2 as $key2 => $value){
                    $resultArray["$key"]["$key2"] = $value;
                }
                $resultArray["$key"]["value"] = $customTableValues["$key"];
            }

            $customTable->fields = $resultArray;
            unset($customTable->id);
            unset($customTable->table);
            unset($customTable->code);
        }

        return $customTables;
    }

    public function declareCustomTableJsonVariables(){
        global $username, $password, $database;
        $db2 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");

        $stm2 = $db2->prepare("SELECT custom_table_id,custom_table_code FROM ZA_Custom_Tables WHERE linked_table='$this->linkedTable' AND NOT linked_table=''");
        $stm2->execute();
        $stm2->bind_result( $customFormID,$customFormCode);
        while ($stm2->fetch()) {
            echo "var UDT_".$customFormID."_$customFormCode = $('#UDT_".$customFormID."_$customFormCode').tableToJSON(
               {
                ignoreHiddenRows: false,
               	ignoreColumns: [0],
				textExtractor : {
						0 : function(cellIndex, cell) {
							return cell.find('input').val();
						},
						1 : function(cellIndex, cell) {
							return cell.find('input').val();
						},
						2 : function(cellIndex, cell) {
						    var valueTXT='';
						    var valueSLCT='';
						    var valueCHK='';
						    var valueTXTAREA='';
						    if(cell.find('input').val() != null){
						        if(cell.find('input').is(':checkbox')){
						            if(cell.find('input').prop('checked')){
						                valueTXT = 'true';
						            } else {
						                valueTXT = 'false';
						            }
						        } else {
						            valueTXT = cell.find('input').val();
						        }
						    }
						    if(cell.find('select').val() != null){
						        valueSLCT = cell.find('select').val();
						    } 
						    if(cell.find('textarea').val() != null){
						        valueTXTAREA = cell.find('textarea').val();
						    }
						    var value = valueTXT+valueSLCT+valueTXTAREA;
							return value;
						}
                  }
               }
			  );
               ";
        }
        $stm2->close();
    }

    public function getCustomTableB2BFields($customTableID)
    {
        return $this->getCustomTableFields($customTableID,$visible = 'yes');
    }

    public function passCustomTableJsonVariables(){
        global $username, $password, $database;
        $db2 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");

        $stm2 = $db2->prepare("SELECT custom_table_id,custom_table_code FROM ZA_Custom_Tables WHERE linked_table='$this->linkedTable' AND NOT linked_table=''");
        $stm2->execute();
        $stm2->bind_result($customFormID,$customFormCode);
        while ($stm2->fetch()) {
            echo ",\n";
            echo "'UDT_".$customFormID."_$customFormCode':UDT_".$customFormID."_$customFormCode";

        }
        $stm2->close();
        echo "\n";
    }


    public function editCustomTableValues(){

        $this->createCustomTableForm(true,false);

    }

    public function disabledCustomTableValues(){

        $this->createCustomTableForm(false,true);

    }

    public function embedCustomTableAsLines($nextLineNumber=0){

        return $this->createCustomTableLines(true,false,false,$nextLineNumber);

    }

    public function embedCustomTableToB2B($nextLineNumber=3,$customTableID=0,$allLabel=' - All - '){

        return $this->createCustomTableB2BFilters(true,false,false,$nextLineNumber,$customTableID,$allLabel);

    }

    public function viewCustomTableValues(){

        $this->createCustomTableForm(true,true,true);

    }

    public function embedCustomTableValues(){
        return $this->createCustomTableForm(true,false,false,true);
    }


    public function copyCustomTableValues($to_ID,$db=''){

        if(is_string($db) && strcmp($db,'')==0) {
            global $username, $password, $database;
            $db = new mysqli(localhost, $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $singleTransactionDB = false;
        } else {
            $singleTransactionDB = true;
        }

        $customTables = array();
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT custom_table_id,custom_table_name FROM ZA_Custom_Tables WHERE linked_table='$this->linkedTable'");
        $stm->execute();
        $stm->bind_result($customTableID,$customTableName);
        while ($stm->fetch()) {
            $customTable = new stdClass();
            $customTable->id = $customTableID;
            $customTable->table = $customTableName;
            array_push($customTables,$customTable);
        }
        $stm->close();

        foreach ($customTables as $customTable){
            $customTableFields = array();
            $db->set_charset("utf8");
            $stm = $db->prepare("SELECT custom_table_field FROM ZA_Custom_Table_Fields WHERE custom_table_id='$customTable->id'");
            $stm->execute();
            $stm->bind_result($customTableField);
            while ($stm->fetch()) {
                array_push($customTableFields,$customTableField);
            }
            $stm->close();

            $impFields = implode(',',$customTableFields);

            $query = "INSERT INTO $customTable->table (id,$impFields) SELECT '$to_ID',$impFields FROM $customTable->table WHERE id='$this->linkedTableID'";

            $db->set_charset("utf8");
            $stm = $db->prepare($query);
            $stm->execute();
            if($singleTransactionDB && strcmp($stm->error,"")!=0) {throw new Exception();}
            $stm->close();

        }
    }



}


if(isset($_POST['customTableCode']) && isset($_POST['customTableID']) && isset($_POST['linkedTableID']) && isset($_POST['customTableName'])){

    include_once('../../../param.php');
    $customTableCode = $_POST['customTableCode'];
    $customTableID = $_POST['customTableID'];
    $linkedTableID = $_POST['linkedTableID'];
    $customTableName = $_POST['customTableName'];
    $disabled = $_POST['disabled'];
    echo "<br/><br/><br/><form>";
    echo "<table class='custom-form' id='UDT_".$customTableID."_$customTableCode' style='width: 100%;'>";
    echo "<thead> <tr> <th style='display:none'  class='text-center'>label</th> <th style='display:none' class='text-center'>id</th> <th style='display:none'  class='text-center'>avalue</th></tr></thead>";
    echo "<tbody>";


    $customFields = getPostCustomTableFields($customTableID);
    $values = getPostCustomTableValues("$customTableName",'id',"$linkedTableID");
    $values = (array)$values;


    foreach ($customFields as $customField) {


        $lastValue = $values["$customField->customTableField"];

        $input = getPostCustomTableInputType($customField->type, $customField->css, $customField->class, $customField->customTableField, "$lastValue", $customField->defaultValues, $disabled, !$disabled, $required = 'no');

        echo "<tr>";
        echo "<td style='border-bottom: 0.5px solid lightgrey;border-right: 0.5px solid lightgrey;'><label style='color:#222'>$customField->displayName</label></td>";
        echo "<td style='display:none;border-bottom: 0.5px solid lightgrey;'><input id='$customTableName|$customField->customTableField' name='$customTableName|$customField->customTableField' value='$customField->customTableField' hidden></td>";
        echo "<td class='form-control' style='margin-left:5px;border-bottom: 0.5px solid lightgrey;'>$input</td>";
        echo "</tr>";

    }



    echo "</tbody>";
    echo "</table>";
    echo "</form>";





}

function getPostCustomTableFields($customTableID,$visible = 'yes')
{
    global $username, $password, $database;
    $db2 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $customTableFields = array();
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT custom_table_field, display_name, type,  position, default_values, css_style, class FROM ZA_Custom_Table_Fields WHERE custom_table_id='$customTableID' AND visible = '$visible' ORDER BY position ASC");
    $stm2->execute();
    $stm2->bind_result($customTableField, $displayName,$type,$position,$defaultValues,$css,$class);
    while ($stm2->fetch()) {
        $line = new stdClass();
        $line->customTableField = $customTableField;
        $line->displayName = $displayName;
        $line->type = $type;
        $line->position = $position;
        $line->defaultValues = $defaultValues;
        $line->css = $css;
        $line->class = $class;

        array_push($customTableFields,$line);

    }
    $stm2->close();

    return $customTableFields;
}

function getPostCustomTableValues($customTableName,$columnID,$customTableRowID)
{
    $values = '';
    global $username, $password, $database;
    $db2 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $z = false;
    $db2->set_charset("utf8");
    $result = $db2->query("SELECT * FROM $customTableName WHERE $columnID='$customTableRowID' LIMIT 1") or die("SQL Error: " . $db2->error);
    while ($row = $result->fetch_object()) {
        $values = $row;
    }

    return $values;

}

function getPostCustomTableInputType($type,$cssStyle,$class,$customFieldName,$lastValue,$valuesRange,$disabled,$editable,$required){
    if($disabled || !$editable){$disable = 'disabled';}else{$disable = '';}
    if($required){$required = 'required';}else{$required = '';}

    switch ($type){
        case 'text':
            $input = "<input type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' value='$lastValue' $disable $required/>";
            break;
        case 'combobox':


            $input = "<select style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' $disable>";

            $values = explode(';',$valuesRange);
            $optionCount=0;
            foreach ($values as $value){
                if(strcmp($lastValue,$value)==0){
                    $input.= "<option value='$lastValue' selected>$lastValue</option>";
                }else{
                    $input.= "<option value='$value'>$value</option>";
                }
                $optionCount++;
            }
            $input.= "</select>";
            break;
        case 'checkbox':
            if(strcmp($lastValue,'yes')==0){$checked = "checked";} else {$checked = '';}
            $input = "<center><input type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' value='yes' $checked $disable/></center>";
            break;
        case 'label':
            $input = "<label class='label'>$lastValue</label>";
            break;
        case 'textarea':
            $input = "<textarea type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' $disable $required>$lastValue</textarea>";

            break;
        case 'JSONArray':

            $valuesJson = str_replace('#quote#','"',$valuesRange);
            $values = json_decode($valuesJson);
            $optionCount=0;
            $input = "<select style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' $disable>";
            $input.= "<option value=''></option>";

            foreach ($values as $value){

                $value = json_encode($value);
                $value = str_replace('"','#quote#',$value);

                $lastValueArray = str_replace('#quote#','"',$lastValue);
                $lastValueArray = json_decode($lastValueArray);
                $lastValueDisplay = '';
                $lastValueArrayDB = array();
                $firstValueOption = true;
                foreach ($lastValueArray as $key => $data){
                    array_push($lastValueArrayDB,"#quote#$key#quote#:#quote#$data#quote#");
                    if($firstValueOption) {
                        $lastValueDisplay .= "$key: $data";
                        $firstValueOption = false;
                    } else {
                        $lastValueDisplay .= "</option><option disabled style='font-style:italic' >&nbsp;&#9679;&nbsp;$key: $data";
                    }
                }
                $lastValueDB = "{".implode(',',$lastValueArrayDB)."}";

                $valueArray = str_replace('#quote#','"',$value);
                $valueArray = json_decode($valueArray);
                $valueDisplay = '';
                $valueArrayDB = array();
                $firstValueOption = true;
                foreach ($valueArray as $key => $data){
                    array_push($valueArrayDB,"#quote#$key#quote#:#quote#$data#quote#");
                    if($firstValueOption) {
                        $valueDisplay .= "$key: $data";
                        $firstValueOption = false;
                    } else {
                        $valueDisplay .= "</option><option disabled style='font-style:italic' >&nbsp;&#9679;&nbsp;$key: $data";
                    }
                }
                $valueDB = "{".implode(',',$valueArrayDB)."}";

                if(strcmp($lastValueDB,$valueDB)==0){
                    $input.= "<option value='$lastValueDB' selected>$lastValueDisplay</option>";
                }else{
                    $input.= "<option value='$valueDB'>$valueDisplay</option>";
                }
                $optionCount++;
            }
            $input.= "</select>";

            break;
        default:
            $input = "<input type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' value='$lastValue' $disable $required/>";
    }

    return $input;
}

function mysqlToSqlite($mysql) {

    // Convert AUTO_INCREMENT to AUTOINCREMENT
    $mysql = preg_replace('/AUTO_INCREMENT/i', 'AUTOINCREMENT', $mysql);

    // Convert VARCHAR to TEXT (though VARCHAR works in SQLite, TEXT is more canonical)
    $mysql = preg_replace('/VARCHAR(\(\d+\))?/i', 'TEXT', $mysql);

    // Convert BIGINT to INTEGER
    $mysql = preg_replace('/BIGINT/i', 'INTEGER', $mysql);

    // Convert DOUBLE to REAL
    $mysql = preg_replace('/DOUBLE/i', 'REAL', $mysql);

    // Remove CHARACTER SET and COLLATE clauses
    $mysql = preg_replace('/CHARACTER SET [^ ]+ /i', '', $mysql);
    $mysql = preg_replace('/COLLATE [^ ]+ /i', '', $mysql);

    // Convert COMMENT ON to SQLite-compatible comment syntax
    $mysql = str_replace('timestamp TIMESTAMP on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP', 'timestamp  DATETIME  DEFAULT CURRENT_TIMESTAMP NOT NULL', $mysql);


    return $mysql;
}