<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
include_once(ROOT."/libs/phpexcel/vendor/autoload.php");

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
 printf("Connect failed: %s\n", mysqli_connect_error());
 exit();
}

$scheduleTypeValuesArray = array('Custom'=>'Custom','Single Date'=>'SingleDate','Daily'=>'Repeat','Weekly'=>'Repeat','Two Weeks'=>'Repeat','Three Weeks'=>'Repeat','Four Weeks'=>'Repeat');
$repeatPeriodValuesArray = array('Custom'=>1,'Single Date'=>1,'Daily'=>1,'Weekly'=>7,'Two Weeks'=>14,'Three Weeks'=>21,'Four Weeks'=>28);
$customPeriodDayValuesArray = array('Monday'=>1,'Tuesday'=>2,'Wednesday'=>3,'Thursday'=>4,'Friday'=>5,'Saturday'=>6,'Sunday'=>7);
$customPeriodWeekValuesArray = array('All Weeks'=>0,'1st week of month'=>1,'2nd week of month'=>2,'3rd week of month'=>3,'4th week of month'=>4);
$customPeriodMonthValuesArray = array('All Months'=>0,'January'=>1,'February'=>2,'March'=>3,'April'=>4,'May'=>5,'June'=>6,'July'=>7,'August'=>8,'September'=>9,'October'=>10,'November'=>11,'December'=>12);

$insertSchedules = $_POST['insertSchedules'];
$file = $_FILES['excelScheduleFile'];
$tmpFileExtension = pathinfo($file['name'], PATHINFO_EXTENSION);
$tmpFileName = date('YmdHis').'-'.$_SESSION['adminID'].'.'.$tmpFileExtension;
     
if(move_uploaded_file($file['tmp_name'], "./$tmpFileName")) {

      $files = processXLSX("$tmpFileName");
      $errors = '';
      foreach ($files as $file){


         if(file_exists("./$file")){

            $content = file_get_contents("./$file");
            unlink("./$file");
            $rows= explode("\n", $content);
            array_shift($rows);
            array_shift($rows);
            array_shift($rows);

            $schedulesArray = array();
            $excelRows = 1;
            foreach ($rows as $row) {
                $excelRows++;
                $errorReason = '';
                $data = explode("|", $row);

                $customerCode = $data[0];
                $salesPersonCode = $data[1];
                $startDate = $data[2];
                $repeatPeriod = $data[3];
                $customDay = $data[4];
                $customWeek = $data[5];
                $customMonth = $data[6];

                // handle multiple custom weeks
                $customWeekArray = [];
                if (strpos($customWeek, ",") !== false) {
                    $parts = explode(",", $customWeek);
                    foreach ($parts as $part) {
                        $numberOfWeek = explode(" ", trim($part))[0];
                        $customWeekArray[] = $numberOfWeek . " week of month";
                    }

                } else {
                   $customWeekArray = [$customWeek];

                }



                $startDateDisplay = '';
                if(intval($startDate) > 0){
                    $startDate = date('Y-m-d', PHPExcel_Shared_Date::ExcelToPHP($startDate));
                    $startDateDisplay = date('d/m/y', strtotime($startDate));
                    if(strcmp(trim("$customDay"),"")!=0){
                        if(strcmp(trim("$customDay"),date('l', strtotime($startDate)))!=0){
                            $startDate = date('Y-m-d', strtotime('next '.$customDay, strtotime($startDate)));
                            $startDateDisplay = date('d/m/y', strtotime($startDate));
                        }
                    }
                } else {
                    if(strcmp(trim("$customDay"),"")!=0){
                        if(strcmp(trim("$customDay"),date('l'))==0){
                            $startDate = date('Y-m-d');
                            $startDateDisplay = date('d/m/y', strtotime($startDate));
                        } else {
                            $startDate = date('Y-m-d', strtotime('next '.$customDay));
                            $startDateDisplay = date('d/m/y', strtotime($startDate));
                        }
                    } else {
                        $startDate = date('Y-m-d');
                        $startDateDisplay = date('d/m/y', strtotime($startDate));
                    }
                }

                if($startDate < date('Y-m-d')){$startDate = date('Y-m-d');}

                if(strcmp(trim("$repeatPeriod"),"Single Date")==0){$customDay = '';}
                else {$startDateDisplay='';}

                if(strcmp(trim("$repeatPeriod"),"Daily")==0){$customDay = '';}

                if(strcmp(trim("$customerCode"),"")==0){continue;}

                $salesPersonName = getSalesPersonExcelName($db,$salesPersonCode);
                $customerID = getCustomerID($db,$customerCode);
                $salesPersonID = getSalesPersonID($db,$salesPersonCode);

                if(strcmp(trim("$salesPersonName"),"")==0){$scheduleNameSpName = 'General';}
                else {$scheduleNameSpName = $salesPersonName;}

                foreach ($customWeekArray as $customWeek) {
                    $scheduleName = trim("$scheduleNameSpName $customDay $repeatPeriod $customWeek $customMonth $startDateDisplay");
                    $scheduleName = str_replace('Custom', '', $scheduleName);
                    $scheduleName = str_replace('All Weeks', 'All Weeks of', $scheduleName);
                    $scheduleName = str_replace('Two Weeks', 'Every Two Weeks', $scheduleName);
                    $scheduleName = str_replace('Three Weeks', 'Every Three Weeks', $scheduleName);
                    $scheduleName = str_replace('Four Weeks', 'Every Month', $scheduleName);
                    $scheduleName = str_replace('  ', ' ', $scheduleName);
                    $scheduleName = str_replace('  ', ' ', $scheduleName);

                    if(!is_array($schedulesArray["$scheduleName"])){$schedulesArray["$scheduleName"] = array();}

                    $scheduleLineArray = array('customer_code' =>$customerCode,'customer_id' =>$customerID,'salesperson' =>$salesPersonCode,'salesperson_id' =>$salesPersonID,'start_date' =>$startDate,'repeat_period' =>$repeatPeriod,'custom_day' =>$customDay,'custom_week' =>$customWeek,'custom_month' =>$customMonth);
                    array_push($schedulesArray["$scheduleName"],$scheduleLineArray);

                    // ---------------- ERROR CHECKS ----------------

                    if(intval($customerID) == 0){
                        $errorReason = "Customer <b>'$customerCode'</b> not found in the system.";
                        $errors .= "<tr ><td>$excelRows</td><td style='background-color: #f6a48e;font-weight: bold;'>$customerCode</td><td>$salesPersonCode</td><td>$startDate</td><td>$repeatPeriod</td><td>$customDay</td><td>$customWeek</td><td>$customMonth</td><td>$errorReason</td></tr>";
                    }

                    if(intval($salesPersonID) == 0 && strcmp(trim("$salesPersonCode"),"")!=0){
                        $errorReason = "Sales Person <b>'$salesPersonCode'</b> not found in the system.";
                        $errors .= "<tr ><td>$excelRows</td><td>$customerCode</td><td style='background-color: #f6a48e;font-weight: bold;'>$salesPersonCode</td><td>$startDate</td><td>$repeatPeriod</td><td>$customDay</td><td>$customWeek</td><td>$customMonth</td><td>$errorReason</td></tr>";
                    }

                    if(strcmp(trim("$repeatPeriod"),"Custom")==0) {

                        if(strcmp(trim("$customWeek"),"")==0 && strcmp(trim("$customMonth"),"")==0) {

                            if(strcmp(trim("$customMonth"),"")==0){$customMonthErrorStyle = 'background-color: #f6a48e;font-weight: bold;';} else {$customMonthErrorStyle = '';}
                            if(strcmp(trim("$customWeek"),"")==0){$customWeekErrorStyle = 'background-color: #f6a48e;font-weight: bold;';} else {$customWeekErrorStyle = '';}

                            $errorReason = "<b>Custom Week</b> or <b>Custom Month</b> must be <b>selected</b> for Repeat Period <b>'$repeatPeriod'</b>.";
                            $errors .= "<tr ><td>$excelRows</td><td>$customerCode</td><td>$salesPersonCode</td><td>$startDate</td><td style='background-color: #f6a48e;font-weight: bold;'>$repeatPeriod</td><td>$customDay</td><td style='$customWeekErrorStyle'>$customWeek</td><td style='$customMonthErrorStyle'>$customMonth</td><td>$errorReason</td></tr>";
                        }

                    } else if(strcmp(trim("$repeatPeriod"),"")==0){

                        $errorReason = "<b>Repeat Period</b> must be <b>selected</b>.";
                        $errors .= "<tr ><td>$excelRows</td><td>$customerCode</td><td>$salesPersonCode</td><td>$startDate</td><td style='background-color: #f6a48e;font-weight: bold;'>$repeatPeriod</td><td>$customDay</td><td style='$customWeekErrorStyle'>$customWeek</td><td style='$customMonthErrorStyle'>$customMonth</td><td>$errorReason</td></tr>";

                    } else {

                        if(strcmp(trim("$customWeek"),"")!=0 || strcmp(trim("$customMonth"),"")!=0) {

                            if(strcmp(trim("$customMonth"),"")!=0){$customMonthErrorStyle = 'background-color: #f6a48e;font-weight: bold;';} else {$customMonthErrorStyle = '';}
                            if(strcmp(trim("$customWeek"),"")!=0){$customWeekErrorStyle = 'background-color: #f6a48e;font-weight: bold;';} else {$customWeekErrorStyle = '';}

                            $errorReason = "<b>Custom Week</b> and <b>Custom Month</b> must be <b>empty</b> for Repeat Period <b>'$repeatPeriod'</b>.";
                            $errors .= "<tr ><td>$excelRows</td><td>$customerCode</td><td>$salesPersonCode</td><td>$startDate</td><td style='background-color: #f6a48e;font-weight: bold;'>$repeatPeriod</td><td>$customDay</td><td style='$customWeekErrorStyle'>$customWeek</td><td style='$customMonthErrorStyle'>$customMonth</td><td>$errorReason</td></tr>";
                        }
                    }

                    // ---------------- /ERROR CHECKS ----------------
                }

            }

            if(strcmp("$errors","")!=0) {
                echo "<center><h1 style='color: firebrick;'><b>Template Errors</b></h1></center><br>";
                echo "<table class='table table-bordered' style='color: black;'>";
                echo "<tr style='background-color: #a7d1e0;font-weight: bold;'><td>Excel Row</td><td>Customer Code</td><td>Sales Person Code</td><td>Start Date</td><td>Repeat Period</td><td>Custom Day</td><td>Custom Week</td><td>Custom Month</td><td>Error</td></tr>";
                echo "$errors";
                echo "</table>";
                echo "<br><center><h3 style=''><b>Fix the errors in the template and Import Schedules again</b></h3></center><br>";

                $hasErrors = true;
            } else {
                $hasErrors = false;
            }

            if(!$hasErrors) {

                try {

                    $db->begin_transaction();

                    if(strcmp("$insertSchedules",'yes')==0){
                        echo "<center><h1><b>Processed Schedules From Template</b></h1></center><br>";
                        $backgroundColor = '#a7d1e0';
                    } else {
                        echo "<center><h1><b>Schedules From Template Preview</b></h1></center><br>";
                        $backgroundColor = 'silver';
                    }
                    echo "<table class='table table-bordered' style='color: black;'>";

                    $existingSchedules = array();
                    $existingScheduleIDs = array();
                    $isFirst = true;

                    foreach ($schedulesArray as $scheduleName => $scheduleArray) {

                        $newSchedule = true;
                        if (in_array($scheduleName, $existingSchedules)) {
                            $scheduleID = $existingScheduleIDs["$scheduleName"];
                            $newSchedule = false;
                        }

                        if ($newSchedule) {
                            $scheduleID = getScheduleIdByName($db, $scheduleName);
                            if ($scheduleID > 0) {
                                array_push($existingSchedules, $scheduleName);
                                $existingScheduleIDs["$scheduleName"] = $scheduleID;
                                $newSchedule = false;
                            }
                        }

                        $lineCounter = 0;
                        $startingDate = $scheduleArray[0]['start_date'];
                        $scheduleType = $scheduleArray[0]['repeat_period'];
                        $customDay = $scheduleArray[0]['custom_day'];
                        $customWeek = $scheduleArray[0]['custom_week'];
                        $customMonth = $scheduleArray[0]['custom_month'];
                        $startingDateDisplay = date('d/m/Y', strtotime($startingDate));

                        if (strcmp("$customDay", "") == 0) {
                            $customDay = date('l', strtotime($startingDate));
                        }

                        // ------------INSERT OR UPDATE VALUES AND QUERIES-----------------
                        $scheduleCreatorID = intval($_SESSION['adminID']);
                        $scheduleRepeatPeriod = intval($repeatPeriodValuesArray["$scheduleType"]);
                        $scheduleDay = intval($customPeriodDayValuesArray["$customDay"]);
                        $scheduleWeek = intval($customPeriodWeekValuesArray["$customWeek"]);
                        $scheduleMonth = intval($customPeriodMonthValuesArray["$customMonth"]);
                        $salesPersonID = intval($scheduleArray[0]['salesperson_id']);
                        $scheduleSystemType = $scheduleTypeValuesArray["$scheduleType"];

                        $queryScheduleSalesperson = '';
                        $queryDeleteSalespersons = '';
                        $queryDeleteCustomers = '';

                        if ($newSchedule) {
                            $scheduleID = getNextKeySingleTransaction('Schedules', 'schedule_id', $db);
                            $querySchedule = "INSERT INTO Schedules (schedule_id, name, creation_date, creator_id, type, date, repeat_period, day, week, month, notes) VALUES ($scheduleID, '$scheduleName', NOW(), $scheduleCreatorID, '$scheduleSystemType', '$startingDate', $scheduleRepeatPeriod, $scheduleDay, $scheduleWeek, $scheduleMonth, '')";
                        } else {
                            $queryDeleteCustomers = "DELETE FROM Schedule_Customer WHERE schedule_id=$scheduleID";
                            $querySchedule = "UPDATE Schedules SET creator_id=$scheduleCreatorID, type='$scheduleSystemType', date='$startingDate', repeat_period=$scheduleRepeatPeriod, day=$scheduleDay, week=$scheduleWeek, month=$scheduleMonth WHERE schedule_id=$scheduleID";
                        }

                        if ($salesPersonID > 0 && !$newSchedule) {
                            $queryDeleteSalespersons = "DELETE FROM Schedule_Salesperson WHERE schedule_id=$scheduleID";
                        }

                        if ($salesPersonID > 0) {
                            $queryScheduleSalesperson = "INSERT INTO Schedule_Salesperson (schedule_id, salesperson_id) VALUES ($scheduleID, $salesPersonID)";
                        }

                        $queryError = executeQuery($db, $queryDeleteCustomers, true);
                        if(strcmp(trim("$queryError"), "") != 0){throw new Exception($queryError);}

                        $queryError = executeQuery($db, $queryDeleteSalespersons, true);
                        if(strcmp(trim("$queryError"), "") != 0) {throw new Exception($queryError);}

                        $queryError = executeQuery($db, $querySchedule, false);
                        if(strcmp(trim("$queryError"), "") != 0){throw new Exception($queryError);}

                        $queryError = executeQuery($db, $queryScheduleSalesperson, false);
                        if(strcmp(trim("$queryError"), "") != 0){throw new Exception($queryError);}

                        // ------------/INSERT OR UPDATE VALUES AND QUERIES/-----------------

                        if ($isFirst) {
                            $isFirst = false;
                        } else {
                            echo "<tr style='border-color: transparent;border-top: 3px solid $backgroundColor;'><td colspan='8' style='border-color: transparent'><b><br></b></td></tr>";
                        }

                        echo "<tr style='background-color: $backgroundColor;border-right: 3px solid $backgroundColor;'><td colspan='8'><b>$scheduleName</b> <span class='pull-right'><b>Starting:</b> $customDay $startingDateDisplay</span></td></tr>";

                        foreach ($scheduleArray as $scheduleLineArray) {
                            $lineCounter++;
                            $customerCode = $scheduleLineArray['customer_code'];
                            $customerID = $scheduleLineArray['customer_id'];
                            $salesPersonCode = $scheduleLineArray['salesperson'];
                            $salesPersonID = $scheduleLineArray['salesperson_id'];
                            $startDate = $scheduleLineArray['start_date'];
                            $repeatPeriod = $scheduleLineArray['repeat_period'];
                            $customDay = $scheduleLineArray['custom_day'];
                            $customWeek = $scheduleLineArray['custom_week'];
                            $customMonth = $scheduleLineArray['custom_month'];

                            $customerName = getCustomerName($db, $customerID);
                            $scheduleCustomerID = getNextKeySingleTransaction('Schedule_Customer', 'schedule_customer_id', $db);
                            $queryScheduleCustomer = "INSERT INTO Schedule_Customer (schedule_customer_id, schedule_id, customer_id, position, appointment_time) VALUES ($scheduleCustomerID, $scheduleID, $customerID, $lineCounter, '')";

                            $queryError = executeQuery($db, $queryScheduleCustomer);
                            if(strcmp(trim("$queryError"), "") != 0){throw new Exception($queryError);}

                            echo "<tr><td style='background-color: $backgroundColor;color: black;'><b>$lineCounter</b></td><td style='text-align: left !important;border-right: 3px solid $backgroundColor;'>$customerCode - $customerName</td></tr>";
                        }
                    }
                    echo "<tr style='border-color: transparent;border-top: 3px solid $backgroundColor;'><td colspan='8' style='border-color: transparent'><b><br></b></td></tr>";
                    echo "</table>";

                    $db->commit(true);

                } catch (Exception $e) {
                    echo "<table class='table table-bordered' style='color: black;'>";
                    echo "<tr style='background-color: $backgroundColor;'><td colspan='8'><b>System Error</b></td></tr>";
                    echo "<tr><td colspan='8'><b>" . $e->getMessage() . "</b></td></tr>";
                    echo "</table>";
                }

            }

         } else {

            echo "File $file not found!<br>";

         }
      }

} else {
      echo "Error Uploading File! $tmpFileName";
}



function processXLSX($inputFile)
{

 $inputDirectory = "./";
 $outputDirectory = "./";
 $archiveDirectory = "./";

 $inputDelimiter = "";
 $outputDelimiter = "|";

 $startingRow = 0;
 $endingRow = 0;
 if(file_exists($inputDirectory.$inputFile)) {

//  echo "<br><b>-------------------- File Processing Start --------------------</b><br>";

  $objReader1 = PHPExcel_IOFactory::createReader('Excel2007');
  $objReader1->setReadDataOnly(true);

  $objPHPExcel1 = $objReader1->load($inputDirectory . $inputFile);
  $filesCreated = "";
  $convertedFiles = array();
  for ($i = 0; $i < 1; $i++) {

   $sheetNameDisplay = date('YmdHis').'-'.$_SESSION['adminID'].'.txt';
   $sheetNumber = $i + 1;
   $lastColumn = $objPHPExcel1->setActiveSheetIndex($i)->getHighestColumn();
   $lastColumnNumber = PHPExcel_Cell::columnIndexFromString($lastColumn);
   $sheetName = strtolower(str_replace(' ', '_', $sheetNameDisplay));
   $outputFile = "$sheetName";
   $ColumnArray = array();
   $lastColumnNumber += 1;
   for ($c = 0; $c <= $lastColumnNumber; $c++) {
    array_push($ColumnArray, $c);
   }
//   echo "<br><b>Processing Sheet $sheetNumber (</b>$sheetName<b>):</b> <br>";
   $fileCreated = convert($inputFile, $outputFile, $inputDirectory, $outputDirectory, $inputDelimiter, $outputDelimiter, $startingRow, $endingRow, $ColumnArray, $i);
   array_push($convertedFiles, $fileCreated);
   $filesCreated .= basename($fileCreated) . "<br>";

//   echo " <i class='fa fa-arrow-right'></i><b style='color: green'> Sheet $sheetNumber Complete! </b><br>";
  }

//  echo "<br><b>-------------------- File Processing Complete -------------------- </b><br>";

  unlink($inputDirectory . $inputFile);
  return $convertedFiles;
 } else {
  echo "<b>$inputFile File not Found!</b>";
  return array();
 }
}


function convert($inputFile, $outputFile, $inputDirectory, $outputDirectory, $inputDelimiter, $outputDelimiter, $startingRow, $endingRow,$ColumnArray,$getSheet=0)
{
 $inputFileDirectory  = $inputDirectory.$inputFile;
 $outputFileDirectory = $outputDirectory.$outputFile;


 return XLSInput($inputFileDirectory,$startingRow,$endingRow,$ColumnArray,$outputDelimiter,$outputFileDirectory,$getSheet);

}

function XLSInput($inputFileDirectory,$startingRow,$endingRow,$ColumnArray,$outputDelimiter,$outputFileDirectory,$getSheet = 0)
{
 $file = fopen($outputFileDirectory, "w");
 $objReader = PHPExcel_IOFactory::createReader('Excel2007');
 $objReader->setReadDataOnly(true);

 $objPHPExcel = $objReader->load($inputFileDirectory);
 $sheet = $objPHPExcel->getSheet($getSheet);
 $highestRow = $sheet->getHighestRow();
 $highestColumn = $sheet->getHighestColumn();
 $highestColumn++;
 $colNumber = PHPExcel_Cell::columnIndexFromString($highestColumn);

 if($endingRow == 0){
  $endingRow = $highestRow;
 }

// echo "<b>Records (Including Headers):</b> $endingRow <i class='fa fa-arrow-right'></i> ";

//  Loop through each row of the worksheet in turn
 for ($row = $startingRow; $row <= $endingRow; $row++) {
  fwrite($file, "\n");
  for($column='A';$column != $highestColumn;$column++) {
   $cell = $sheet->getCell($column.$row);
   if($cell->isFormula()){
    $rowData = $cell->getOldCalculatedValue();

   } else {
    $rowData = $cell->getValue();
   }

   fwrite($file, $rowData);
   fwrite($file, $outputDelimiter);


  }
 }
 $displayRowsProcessed = $row - 1;
// echo "<b style='color: green'> $displayRowsProcessed rows Processed.</b><br>";
// echo "<b>File Created:</b> ".basename($outputFileDirectory).PHP_EOL." ";
 fclose($file);

 return $outputFileDirectory;

}

function getSalesPersonExcelName($db,$salesPersonCode){

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT salesperson_code,first_name,last_name FROM SalesPersons WHERE salesperson_code=? LIMIT 1");
    $stm->bind_param('s',$salesPersonCode);
    $stm->execute();
    $stm->bind_result($salesperson_code,$first_name,$last_name);
    while ($stm->fetch()) {}
    $stm->close();

    $result = $salesPersonCode;
    if(strcmp(trim("$first_name"),"")!=0){
        $result = trim("$first_name $last_name");
    } else {
        $result = trim("$salesPersonCode $last_name");
    }

    return $result;

}

function getCustomerID($db,$customerCode){

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT customer_id FROM Customers WHERE customer_code=? LIMIT 1");
    $stm->bind_param('s',$customerCode);
    $stm->execute();
    $stm->bind_result($customer_id);
    while ($stm->fetch()) {}
    $stm->close();

    return intval($customer_id);

}

function getSalespersonID($db,$salespersonCode) {

 $z=0;
 $stm1 = $db->prepare("SELECT salesperson_id FROM SalesPersons WHERE salesperson_code='$salespersonCode' LIMIT 1");
 $stm1-> execute();
 $stm1-> bind_result($counter);
 while ($stm1->fetch()) {
  if($counter > 0) {
   $z = $counter;
  }
 }
 $stm1->close();


 return $z;
}

function getCustomerName($db,$customerID){

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT customer_company_name FROM Customers WHERE customer_id=? LIMIT 1");
    $stm->bind_param('i',$customerID);
    $stm->execute();
    $stm->bind_result($customer_name);
    while ($stm->fetch()) {}
    $stm->close();

    return $customer_name;

}

function getScheduleIdByName($db,$scheduleName){

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT schedule_id FROM Schedules WHERE name=? LIMIT 1");
    $stm->bind_param('s',$scheduleName);
    $stm->execute();
    $stm->bind_result($schedule_id);
    while ($stm->fetch()) {}
    $stm->close();

    return intval($schedule_id);

}

function executeQuery($db,$query,$insertIntoDeletes = false){

    global $insertSchedules;

    if(isset($insertSchedules) && strcmp("$insertSchedules",'yes')==0){

        if(strcmp(trim("$query"),"")==0){return "";}

//        echo "<tr style='border-color: transparent;border-top: 3px solid transparent;background-color: silver'><td colspan='8' style='border-color: transparent'><b>$query</b></td></tr>";


        $db->set_charset("utf8");
        $stm = $db->prepare($query);
        $stm->execute();
        $error = $stm->error;
        $stm->close();

        if(strcmp(trim("$error"),"")!=0){return $error;}

        if($insertIntoDeletes){

            $deleteID = getNextKeySingleTransaction('Deletes','delete_id',$db);

//            echo "<tr style='border-color: transparent;border-top: 3px solid transparent;background-color: silver'><td colspan='8' style='border-color: transparent'><b>INSERT INTO Deletes (delete_id,statement) VALUES ($deleteID,\"$query\")</b></td></tr>";

            $stm = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES (?,?)");
            $stm->bind_param('is',$deleteID,$query);
            $stm->execute();
            $error = $stm->error;
            $stm->close();
        }

        return $error;

    } else {
        return "";
    }

}
?>
 