<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
include_once(ROOT."/libs/phpexcel/vendor/autoload.php");

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
 printf("Connect failed: %s\n", mysqli_connect_error());
 exit();
}

$insertContractPrices = $_POST['insertContractPrices'];
$file = $_FILES['excelContractPricesFile'];
$tmpFileExtension = pathinfo($file['name'], PATHINFO_EXTENSION);
$tmpFileName = date('YmdHis').'-'.$_SESSION['adminID'].'.'.$tmpFileExtension;
     
if(move_uploaded_file($file['tmp_name'], "./$tmpFileName")) {

      $files = processXLSX("$tmpFileName");
      $errors = '';
      foreach ($files as $file){


         if(file_exists("./$file")){

            $content = file_get_contents("./$file");
            unlink("./$file");
            $rows= explode("\n", $content);
            array_shift($rows);
            array_shift($rows);
            array_shift($rows);

            $contractPricesArray = array();
            $excelRows = 1;

            foreach ($rows as $row) {
                $lineError = false;
                $excelRows++;
                $errorReason = '';
                $data = explode("|", $row);

                $customerCode = $data[0];
                $itemCode = $data[1];
                $price = $data[2];
                $priceListCode = $data[3];
                $percentage = $data[4];
                $fixedAmountDiscount = $data[5];
                $minimumQty = $data[6];
                $validFrom = $data[7];
                $validUntil = $data[8];

                $rowDataCheck = "$customerCode$itemCode$price$priceListCode$percentage$minimumQty$validFrom$validUntil";

                if(strcmp(trim("$rowDataCheck"),"")!=0){

                    if(strcmp(trim("$customerCode"),"")!=0){$customerID = getCustomerID($db,$customerCode);} else {$customerID = 0;}
                    if(strcmp(trim("$itemCode"),"")!=0){$itemID = getItemID($db,$itemCode);} else {$itemID = 0;}
                    if(strcmp(trim("$priceListCode"),"")!=0){$priceListID = getPriceListID($db,$priceListCode);} else {$priceListID = 0;}

                    if(strcmp(trim("$price"),"")==0 && intval($priceListID) > 0 && floatval($percentage) !=0){
                        $defaultPrice = getPriceFromPriceList($db,$priceListID,$itemID);
                        $price = $defaultPrice - ($defaultPrice * (floatval($percentage)/100));
                    } else if(strcmp(trim("$price"),"")==0 && intval($priceListID) > 0 && floatval($fixedAmountDiscount) !=0){
                        $defaultPrice = getPriceFromPriceList($db,$priceListID,$itemID);
                        $price = $defaultPrice - floatval($fixedAmountDiscount);
                    } else if(strcmp(trim("$price"),"")==0 && intval($priceListID) > 0 ){
                        $defaultPrice = getPriceFromPriceList($db,$priceListID,$itemID);
                        $price = $defaultPrice;
                    }

                    $customWeekErrorStyle = '';
                    $errorReason = '';
                    if(intval($customerID) == 0){
                        $errorReason .= "<b>Customer Not Found.</b>";
                        $customCustomerErrorStyle = 'background-color: #f6a48e;font-weight: bold;';
                        $lineError = true;
                    } else {
                        $customCustomerErrorStyle = '';
                    }

                    if(intval($itemID) == 0){
                        $errorReason .= "<b>Item Not Found.</b>";
                        $customItemErrorStyle = 'background-color: #f6a48e;font-weight: bold;';
                        $lineError = true;
                    } else {
                        $customItemErrorStyle = '';
                    }

                    if(strcmp(trim("$validFrom"),"")==0){
                        $errorReason .= "<b>Valid From Date Missing.</b>";
                        $customValidFromErrorStyle = 'background-color: #f6a48e;font-weight: bold;';
                        $lineError = true;
                    } else {
                        $validFrom = date('Y-m-d', PHPExcel_Shared_Date::ExcelToPHP($validFrom));
                        $validFromDisplay = date('d/m/y', strtotime($validFrom));
                        $customValidFromErrorStyle = '';
                    }

                    if(strcmp(trim("$validUntil"),"")==0){
                        $errorReason .= "<b>Valid Until Date Missing.</b>";
                        $customValidUntilErrorStyle = 'background-color: #f6a48e;font-weight: bold;';
                        $lineError = true;
                    } else {
                        if(strcmp(trim("$validFrom"),"")!=0 && strcmp(trim("$validUntil"),"")!=0){
                            $validUntil = date('Y-m-d', PHPExcel_Shared_Date::ExcelToPHP($validUntil));
                            $validUntilDisplay = date('d/m/y', strtotime($validUntil));

                            if(strtotime($validUntil) < strtotime($validFrom)){
                                $errorReason .= "<b>Valid Until Date Before Valid From Date.</b>";
                                $customValidUntilErrorStyle = 'background-color: #f6a48e;font-weight: bold;';
                                $lineError = true;
                            } else {
                                $customValidUntilErrorStyle = '';
                            }
                        }
                    }

                    if(floatval($price) < 0){
                        $errorReason .= "<b>Negative Price.</b>";
                        $customPriceErrorStyle = 'background-color: #f6a48e;font-weight: bold;';
                        $lineError = true;
                    } else {
                        $customPriceErrorStyle = '';
                    }

                    if(strcmp(trim("$priceListCode"),"")!=0 && intval($priceListID) == 0){
                        $errorReason .= "<b>Price List Not Found.</b>";
                        $customPriceListErrorStyle = 'background-color: #f6a48e;font-weight: bold;';
                        $lineError = true;
                    } else {
                        $customPriceListErrorStyle = '';
                    }

                    if(intval($percentage) < 0){
                        $errorReason .= "<b>Negative Percentage.</b>";
                        $customPercentageErrorStyle = 'background-color: #f6a48e;font-weight: bold;';
                        $lineError = true;
                    } else {
                        if(intval($percentage) > 100){
                            $errorReason .= "<b>Percentage Greater Than 100%.</b>";
                            $customPercentageErrorStyle = 'background-color: #f6a48e;font-weight: bold;';
                            $lineError = true;
                        } else {
                            $customPercentageErrorStyle = '';
                        }
                    }

                    if(intval($fixedAmountDiscount) > 0 && floatval($price) < 0){
                        $errorReason .= "<b>Discount Grater than Price.</b>";
                        $customFixedAmountErrorStyle = 'background-color: #f6a48e;font-weight: bold;';
                        $lineError = true;
                    } else {
                        $customFixedAmountErrorStyle = '';
                    }

                    if(intval($minimumQty) < 0){
                        $errorReason .= "<b>Negative Minimum Quantity.</b>";
                        $customMinimumQtyErrorStyle = 'background-color: #f6a48e;font-weight: bold;';
                        $lineError = true;
                    } else {
                        $customMinimumQtyErrorStyle = '';
                    }


                    if($lineError) {
                        $errors .= "<tr >";
                        $errors .= "<td>$excelRows</td>";
                        $errors .= "<td style='$customCustomerErrorStyle'>$customerCode</td>";
                        $errors .= "<td style='$customItemErrorStyle'>$itemCode</td>";
                        $errors .= "<td style='$customPriceErrorStyle'>$price</td>";
                        $errors .= "<td style='$customPriceListErrorStyle'>$priceListCode</td>";
                        $errors .= "<td style='$customPercentageErrorStyle'>$percentage</td>";
                        $errors .= "<td style='$customFixedAmountErrorStyle'>$fixedAmountDiscount</td>";
                        $errors .= "<td style='$customMinimumQtyErrorStyle'>$minimumQty</td>";
                        $errors .= "<td style='$customValidFromErrorStyle'>$validFromDisplay</td>";
                        $errors .= "<td style='$customValidUntilErrorStyle'>$validUntilDisplay</td>";
                        $errors .= "<td>$errorReason</td>";
                        $errors .= "</tr>";
                    } else {

                        $price = floatval($price);
                        $percentage = floatval($percentage);
                        $minimumQty = floatval($minimumQty);
                        $priceListID = intval($priceListID);

                        $queryContractPrice = "INSERT INTO ContractPrices (customer_id,item_id,price,pricetype_id,percentage,min_qty,valid_from,valid_until) VALUES ($customerID,$itemID,$price,$priceListID,$percentage,$minimumQty,'$validFrom','$validUntil') ON DUPLICATE KEY UPDATE price=$price,pricetype_id=$priceListID,percentage=$percentage,valid_from='$validFrom',valid_until='$validUntil'";


                        $contractPriceObject = new stdClass();
                        $contractPriceObject->excelRow = $excelRows;
                        $contractPriceObject->customerCode = $customerCode;
                        $contractPriceObject->customerName = getCustomerName($db,$customerID);
                        $contractPriceObject->itemCode = $itemCode;
                        $contractPriceObject->itemName = getItemName($db,$itemID);
                        $contractPriceObject->price = $price;
                        $contractPriceObject->priceListCode = $priceListCode;
                        $contractPriceObject->priceListName = getPriceListName($db,$priceListID);
                        $contractPriceObject->percentage = $percentage;
                        $contractPriceObject->fixedAmountDiscount = $fixedAmountDiscount;
                        $contractPriceObject->minimumQty = $minimumQty;
                        $contractPriceObject->validFrom = $validFrom;
                        $contractPriceObject->validFromDisplay = $validFromDisplay;
                        $contractPriceObject->validUntil = $validUntil;
                        $contractPriceObject->validUntilDisplay = $validUntilDisplay;
                        $contractPriceObject->query = $queryContractPrice;
                        array_push($contractPricesArray, $contractPriceObject);
                    }

                }


            }

            // ---------------- /ERROR CHECKS ----------------


            if(strcmp("$errors","")!=0) {
                echo "<center><h1 style='color: firebrick;'><b>Template Errors</b></h1></center><br>";
                echo "<table class='table table-bordered' style='color: black;'>";
                echo "<tr style='background-color: #a7d1e0;font-weight: bold;'>";
                echo "<td>Row</td>";
                echo "<td>Customer Code</td>";
                echo "<td>Item Code</td>";
                echo "<td>Price</td>";
                echo "<td>Price List Code</td>";
                echo "<td>Discount Percentage</td>";
                echo "<td>Fixed Discount Amount</td>";
                echo "<td>Minimum Quantity</td>";
                echo "<td>Valid From</td>";
                echo "<td>Valid Until</td>";
                echo "<td>Errors</td>";
                echo "$errors";
                echo "</table>";
                echo "<br><center><h3 style=''><b>Fix the errors in the template and Import Contract Prices again</b></h3></center><br>";

                $hasErrors = true;
            } else {
                $hasErrors = false;
            }

            if(!$hasErrors) {

                try {

                    $db->begin_transaction();



                    echo "<table class='table table-bordered' style='color: black;'>";
                    echo "<tr style='background-color: #a7d1e0;font-weight: bold;'>";
                    echo "<td>Row</td>";
                    echo "<td>Customer</td>";
                    echo "<td>Item</td>";
                    echo "<td>Price</td>";
                    echo "<td>Price List</td>";
                    echo "<td>Discount Percentage</td>";
                    echo "<td>Fixed Discount Amount</td>";
                    echo "<td>Minimum Quantity</td>";
                    echo "<td>Valid From</td>";
                    echo "<td>Valid Until</td>";
                    if(strcmp("$insertContractPrices",'yes')==0) {
                        echo "<td>Process</td>";
                    }
                    echo "</tr>";



                    foreach ($contractPricesArray as $contractPriceObject) {

                        if(strcmp("$insertContractPrices",'yes')==0){

                            $queryError = executeQuery($db, $contractPriceObject->query);

                            if(strcmp(trim("$queryError"), "") != 0){
                                $process = "Failed!";
                                $processStyle = 'color: firebrick;font-weight: bold;';
                            } else {
                                $process = "Success!";
                                $processStyle = 'color: green;font-weight: bold;';
                            }

                        }

                        if(strtotime($contractPriceObject->validUntil) < strtotime(date('Y-m-d'))){
                            $expiredValidUntilStyle = 'color: firebrick;font-weight: bold;';
                            $expiredLabel = '<br>(Expired)';
                        } else {
                            $expiredValidUntilStyle = '';
                            $expiredLabel = '';
                        }

                        echo "<tr >";
                        echo "<td>$contractPriceObject->excelRow</td>";
                        echo "<td>$contractPriceObject->customerCode - $contractPriceObject->customerName</td>";
                        echo "<td>$contractPriceObject->itemCode - $contractPriceObject->itemName</td>";
                        echo "<td>".round($contractPriceObject->price,4)."</td>";
                        echo "<td>$contractPriceObject->priceListCode - $contractPriceObject->priceListName</td>";
                        echo "<td>$contractPriceObject->percentage%</td>";
                        echo "<td>$contractPriceObject->fixedAmountDiscount</td>";
                        echo "<td>$contractPriceObject->minimumQty</td>";
                        echo "<td>$contractPriceObject->validFromDisplay</td>";
                        echo "<td style='$expiredValidUntilStyle' >$contractPriceObject->validUntilDisplay$expiredLabel</td>";
                        if(strcmp("$insertContractPrices",'yes')==0) {
                            echo "<td style='$processStyle'>$process</td>";
                        }
                        echo "</tr>";


                        if(strcmp(trim("$queryError"), "") != 0) {
                            echo "</table>";
                            throw new Exception($queryError);
                        }



                    }

                    echo "</table>";



                    $db->commit(true);

                } catch (Exception $e) {
                    $db->rollback();
                }

            }

         } else {

            echo "File $file not found!<br>";

         }
      }

} else {
      echo "Error Uploading File! $tmpFileName";
}



function processXLSX($inputFile)
{

 $inputDirectory = "./";
 $outputDirectory = "./";
 $archiveDirectory = "./";

 $inputDelimiter = "";
 $outputDelimiter = "|";

 $startingRow = 0;
 $endingRow = 0;
 if(file_exists($inputDirectory.$inputFile)) {

//  echo "<br><b>-------------------- File Processing Start --------------------</b><br>";

  $objReader1 = PHPExcel_IOFactory::createReader('Excel2007');
  $objReader1->setReadDataOnly(true);

  $objPHPExcel1 = $objReader1->load($inputDirectory . $inputFile);
  $filesCreated = "";
  $convertedFiles = array();
  for ($i = 0; $i < 1; $i++) {

   $sheetNameDisplay = date('YmdHis').'-'.$_SESSION['adminID'].'.txt';
   $sheetNumber = $i + 1;
   $lastColumn = $objPHPExcel1->setActiveSheetIndex($i)->getHighestColumn();
   $lastColumnNumber = PHPExcel_Cell::columnIndexFromString($lastColumn);
   $sheetName = strtolower(str_replace(' ', '_', $sheetNameDisplay));
   $outputFile = "$sheetName";
   $ColumnArray = array();
   $lastColumnNumber += 1;
   for ($c = 0; $c <= $lastColumnNumber; $c++) {
    array_push($ColumnArray, $c);
   }
//   echo "<br><b>Processing Sheet $sheetNumber (</b>$sheetName<b>):</b> <br>";
   $fileCreated = convert($inputFile, $outputFile, $inputDirectory, $outputDirectory, $inputDelimiter, $outputDelimiter, $startingRow, $endingRow, $ColumnArray, $i);
   array_push($convertedFiles, $fileCreated);
   $filesCreated .= basename($fileCreated) . "<br>";

//   echo " <i class='fa fa-arrow-right'></i><b style='color: green'> Sheet $sheetNumber Complete! </b><br>";
  }

//  echo "<br><b>-------------------- File Processing Complete -------------------- </b><br>";

  unlink($inputDirectory . $inputFile);
  return $convertedFiles;
 } else {
  echo "<b>$inputFile File not Found!</b>";
  return array();
 }
}


function convert($inputFile, $outputFile, $inputDirectory, $outputDirectory, $inputDelimiter, $outputDelimiter, $startingRow, $endingRow,$ColumnArray,$getSheet=0)
{
 $inputFileDirectory  = $inputDirectory.$inputFile;
 $outputFileDirectory = $outputDirectory.$outputFile;


 return XLSInput($inputFileDirectory,$startingRow,$endingRow,$ColumnArray,$outputDelimiter,$outputFileDirectory,$getSheet);

}

function XLSInput($inputFileDirectory,$startingRow,$endingRow,$ColumnArray,$outputDelimiter,$outputFileDirectory,$getSheet = 0)
{
 $file = fopen($outputFileDirectory, "w");
 $objReader = PHPExcel_IOFactory::createReader('Excel2007');
 $objReader->setReadDataOnly(true);

 $objPHPExcel = $objReader->load($inputFileDirectory);
 $sheet = $objPHPExcel->getSheet($getSheet);
 $highestRow = $sheet->getHighestRow();
 $highestColumn = $sheet->getHighestColumn();
 $highestColumn++;
 $colNumber = PHPExcel_Cell::columnIndexFromString($highestColumn);

 if($endingRow == 0){
  $endingRow = $highestRow;
 }

// echo "<b>Records (Including Headers):</b> $endingRow <i class='fa fa-arrow-right'></i> ";

//  Loop through each row of the worksheet in turn
 for ($row = $startingRow; $row <= $endingRow; $row++) {
  fwrite($file, "\n");
  for($column='A';$column != $highestColumn;$column++) {
   $cell = $sheet->getCell($column.$row);
   if($cell->isFormula()){
    $rowData = $cell->getOldCalculatedValue();

   } else {
    $rowData = $cell->getValue();
   }

   fwrite($file, $rowData);
   fwrite($file, $outputDelimiter);


  }
 }
 $displayRowsProcessed = $row - 1;
// echo "<b style='color: green'> $displayRowsProcessed rows Processed.</b><br>";
// echo "<b>File Created:</b> ".basename($outputFileDirectory).PHP_EOL." ";
 fclose($file);

 return $outputFileDirectory;

}

function getSalesPersonExcelName($db,$salesPersonCode){

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT salesperson_code,first_name,last_name FROM SalesPersons WHERE salesperson_code=? LIMIT 1");
    $stm->bind_param('s',$salesPersonCode);
    $stm->execute();
    $stm->bind_result($salesperson_code,$first_name,$last_name);
    while ($stm->fetch()) {}
    $stm->close();

    $result = $salesPersonCode;
    if(strcmp(trim("$first_name"),"")!=0){
        $result = trim("$first_name $last_name");
    } else {
        $result = trim("$salesPersonCode $last_name");
    }

    return $result;

}

function getCustomerID($db,$customerCode){

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT customer_id FROM Customers WHERE customer_code=? LIMIT 1");
    $stm->bind_param('s',$customerCode);
    $stm->execute();
    $stm->bind_result($customer_id);
    while ($stm->fetch()) {}
    $stm->close();

    return intval($customer_id);

}

function getItemID($db,$itemCode) {

 $z=0;
 $stm1 = $db->prepare("SELECT item_id FROM Items WHERE item_code='$itemCode' LIMIT 1");
 $stm1-> execute();
 $stm1-> bind_result($item_id);
 while ($stm1->fetch()) {
  if($item_id > 0) {
   $z = $item_id;
  }
 }
 $stm1->close();


 return $z;
}

function getPriceListID($db,$priceListCode) {

    $z=0;
    $stm1 = $db->prepare("SELECT pricetype_id FROM PriceTypes WHERE price_code='$priceListCode' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($pricetype_id);
    while ($stm1->fetch()) {
        if($pricetype_id> 0) {
            $z = $pricetype_id;
        }
    }
    $stm1->close();


    return $z;
}

function getPriceFromPriceList($db,$pricetype_id,$item_id) {

    $z=0;
    $stm1 = $db->prepare("SELECT price FROM Prices WHERE pricetype_id=? AND item_id=? LIMIT 1");
    $stm1->bind_param('ii',$pricetype_id,$item_id);
    $stm1-> execute();
    $stm1-> bind_result($price);
    while ($stm1->fetch()) {
        if($price> 0) {
            $z = $price;
        }
    }
    $stm1->close();


    return $z;
}

function getCustomerName($db,$customerID){

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT customer_company_name FROM Customers WHERE customer_id=? LIMIT 1");
    $stm->bind_param('i',$customerID);
    $stm->execute();
    $stm->bind_result($customer_name);
    while ($stm->fetch()) {}
    $stm->close();

    return $customer_name;

}

function getItemName($db,$itemID){

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT name FROM Items WHERE item_id=? LIMIT 1");
    $stm->bind_param('i',$itemID);
    $stm->execute();
    $stm->bind_result($item_name);
    while ($stm->fetch()) {}
    $stm->close();

    return $item_name;

}

function getPriceListName($db,$priceTypeID){

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT name FROM PriceTypes WHERE pricetype_id=? LIMIT 1");
    $stm->bind_param('i',$priceTypeID);
    $stm->execute();
    $stm->bind_result($name);
    while ($stm->fetch()) {}
    $stm->close();

    return $name;

}

function getScheduleIdByName($db,$scheduleName){

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT schedule_id FROM Schedules WHERE name=? LIMIT 1");
    $stm->bind_param('s',$scheduleName);
    $stm->execute();
    $stm->bind_result($schedule_id);
    while ($stm->fetch()) {}
    $stm->close();

    return intval($schedule_id);

}

function executeQuery($db,$query,$insertIntoDeletes = false){

    global $insertContractPrices;

    if(isset($insertContractPrices) && strcmp("$insertContractPrices",'yes')==0){

        if(strcmp(trim("$query"),"")==0){return "";}

//        echo "<tr style='border-color: transparent;border-top: 3px solid transparent;background-color: silver'><td colspan='10' style='border-color: transparent'><b>$query</b></td></tr>";


        $db->set_charset("utf8");
        $stm = $db->prepare($query);
        $stm->execute();
        $error = $stm->error;
        $stm->close();

//        echo "<tr style='border-color: transparent;border-top: 3px solid transparent;background-color: silver'><td colspan='10' style='border-color: transparent'><b>ERROR: $error</b></td></tr>";


        if(strcmp(trim("$error"),"")!=0){return $error;}

        if($insertIntoDeletes){

            $deleteID = getNextKeySingleTransaction('Deletes','delete_id',$db);

            echo "<tr style='border-color: transparent;border-top: 3px solid transparent;background-color: silver'><td colspan='10' style='border-color: transparent'><b>INSERT INTO Deletes (delete_id,statement) VALUES ($deleteID,\"$query\")</b></td></tr>";

            $stm = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES (?,?)");
            $stm->bind_param('is',$deleteID,$query);
            $stm->execute();
            $error = $stm->error;
            $stm->close();

//            echo "<tr style='border-color: transparent;border-top: 3px solid transparent;background-color: silver'><td colspan='10' style='border-color: transparent'><b>ERROR: $error</b></td></tr>";

        }

        return $error;

    } else {
        return "";
    }

}
?>
 