<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 include_once('../../../../param.php');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// DB table to use
$table = 'Warehouse_Transactions';
$warehouseID =$_GET['warehouseID'];
// Table's primary key
$primaryKey = "warehouse_transaction_id";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
     array( 'db' => '`t`.`warehouse_transaction_code`', 'dt' =>  'code', 'field' =>'warehouse_transaction_code' ),
       array( 'db' => '`t`.`type`', 'dt' => 'type', 'field' => 'type' ),
    array( 'db' => '`t`.`warehouse_id_from`', 'dt' => 'from', 'formatter' => function( $d, $row ) {
        return  getWarehouseCode($d);},
        'field' => 'warehouse_id_from' ),
    array( 'db' => '`t`.`warehouse_id_to`', 'dt' => 'to', 'formatter' => function( $d, $row ) {
        return  getWarehouseCode($d);},
        'field' => 'warehouse_id_to' ),
     array( 'db' => '`t`.`transaction_date`', 'dt' => 'date' , 'field' => 'transaction_date' ),
            array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson', 'field' => 'salesperson_code' ),
     array( 'db' => '`t`.`warehouse_transaction_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
                return '<form id="'.$d.'" target="_blank" action="//'.HTML_PATH .'/cop/backend/core/views/view/view_warehouse_transaction.php" method="post" style="display: inline-block;"> 
           		<input type="hidden" name="warehouse_transaction_id" value="'.$d.'">
			<input style="font-size:13px;" type="submit" class="btn btn-primary" value="View" style="width:60px">
			</form>
			<form id="'.$d.'" target="_blank" action="//'.HTML_PATH .'/cop/backend/core/views/addedit/create_warehouse_transfer.php" method="post" style="display: inline-block;">
           		<input type="hidden" name="wt_id" value="'.$d.'">
			<input style="font-size:13px;" type="submit" class="btn btn-success" value="Edit" style="width:60px">
			</form>
			';},
            'field' => 'warehouse_transaction_id' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Warehouse_Transactions` AS `t`  LEFT JOIN `SalesPersons` AS `s` ON (`t`.`salesperson_id` = `s`.`salesperson_id`)";
$extraWhere = "(`t`.`warehouse_id_from` = '$warehouseID' OR `t`.`warehouse_id_to` = '$warehouseID')";


if (isset($_GET['fromWarehouseCodeFilter']) && !empty($_GET['fromWarehouseCodeFilter'])) {
    if (!empty($extraWhere)) {
        $extraWhere .= " AND ";
    }
    $fromWarehouseCodeFilter = trim($_GET['fromWarehouseCodeFilter']);
    $warehouseFromIDs = implode(",", getWarehouseIDs( $fromWarehouseCodeFilter));
    if(!empty($warehouseFromIDs)) {
        $extraWhere .= "t.warehouse_id_from IN (" . $warehouseFromIDs . ")";
    }
    else{
        $extraWhere .= "1=0";
    }
}

if (isset($_GET['toWarehouseCodeFilter']) && !empty($_GET['toWarehouseCodeFilter'])) {
    $toWarehouseCodeFilter = trim($_GET['toWarehouseCodeFilter']);
    if (!empty($extraWhere)) {
        $extraWhere .= " AND ";
    }
    $warehouseToIDs = implode(",", getWarehouseIDs( $toWarehouseCodeFilter));
    if(!empty($warehouseFromIDs)) {
        $extraWhere .= "t.warehouse_id_to IN (".$warehouseToIDs.")";
    }
    else{
        $extraWhere .= "1=0";
    }
}


if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($extraWhere,'')!=0){$extraWhere.= " AND ";}
    $extraWhere .= " `t`.`salesperson_id` IN (".$_SESSION['Allow_Salespersons'].")";
}
require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$extraWhere)
     );


function getWarehouseCode($warehouseID) {
    global $username,$password,$database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT warehouse_code FROM Warehouses WHERE warehouse_id='$warehouseID'");
    $stm1-> execute();
    $stm1-> bind_result($warehouseCode);
    while ($stm1->fetch()) {
        return $warehouseCode;
    }
    $stm1->close();
    return $warehouseCode;
}

function getWarehouseIDs($warehouseCodeFilter){
    global $username,$password,$database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $stm1 = $db1->prepare("SELECT warehouse_id FROM Warehouses WHERE warehouse_code LIKE '" . $warehouseCodeFilter . "%'");
    $stm1-> execute();
    $stm1-> bind_result($warehouseID);
    $warehouseIDs = [];
    while ($stm1->fetch()) {
        $warehouseIDs[] =  $warehouseID;
    }
    $stm1->close();
    return $warehouseIDs;

}

     ?>