<?php
include_once('../../../../param.php');

// DB table to use
$table = 'SubCustomers';

// Table's primary key
$primaryKey = "position";

$columns = array(
    array(
        'db' => 'CONCAT(c1.customer_code, " - ", c1.customer_company_name)',
        'dt' => 'customer',
        'field' => 'customer',
        'as' => 'customer'
    ),
    array(
        'db' => 'CONCAT(c2.customer_code, " - ", c2.customer_company_name)',
        'dt' => 'subcustomer',
        'field' => 'subcustomer',
        'as' => 'subcustomer'
    ),
    array(
        'db' => 's.type',
        'dt' => 'type',
        'field' => 'type'
    ),
    array(
        'db' => 's.position',
        'dt' => 'position',
        'field' => 'position'
    ),
    array(
        'db' => 's.notes',
        'dt' => 'notes',
        'field' => 'notes'
    ),
    array(
        'db' => 'DATE_FORMAT(s.date_added, "%d/%m/%Y")',
        'dt' => 'date_added',
        'field' => 'date_added',
        'as' => 'date_added'
    ),
    array(
        'db' => 's.customer_id',
        'dt' => 'customer_id',
        'field' => 'customer_id'
    ),
    array(
        'db' => 's.subcustomer_id',
        'dt' => 'subcustomer_id',
        'field' => 'subcustomer_id'
    ),
    array(
        'db' => 's.type',
        'dt' => 'type',
        'field' => 'type',
        'formatter' => function($d) {
            if(strcmp($d, 'sub') ==0){
                return "Sub Account";
            }
            else if(strcmp($d, 'rep') ==0){
                return "Representative";
            }
            else return $d;
        }
    ),
    array(
        'db' => 's.customer_id',
        'dt' => 'form',
        'formatter' => function($d, $row) {
            $customerId = $row['customer_id'];
            $subcustomerId = $row['subcustomer_id'];
            $type = $row['type'];
            return '<button class="btn btn-primary" onclick="openEditModal('.$customerId.', '.$subcustomerId.', \''.$type.'\');">Edit</button>';
        },
        'field' => 'form'
    )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

$joinQuery = "FROM SubCustomers AS s 
             LEFT JOIN Customers AS c1 ON s.customer_id = c1.customer_id 
             LEFT JOIN Customers AS c2 ON s.subcustomer_id = c2.customer_id";
$where = "";

require(ROOT.'backend/core/controllers/ssp2.class.php');

echo json_encode(
    SSP::simple($_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where)
);